﻿NDSummary.OnToolTipsLoaded("File:firmware/common/icss_iep_macros.inc",{170:"<div class=\"NDToolTip TFile LAssembly\"><div class=\"TTSummary\">Brief:&nbsp; PRU IEP related macro definitions</div></div>",172:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_sync_pwidth_reg. Defines the number of clock cycles SYNC0/1 will be high.&nbsp; Note if SYNC0/1 is disabled during pulse width time (that is, SYNC_CTRL[SYNC0_EN | SYNC1_EN | SYNC_EN] = 0), the ongoing pulse will be terminated.&nbsp; 0h = 1 clock cycle.&nbsp; 1h = 2 clock cycles.&nbsp; Nh = N+1 clock cycles.</div></div>",173:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_global_cfg_reg.&nbsp; Bit&nbsp; | Field&nbsp; | Type | Reset | Description 19-8&nbsp; | CMP_INC&nbsp; | R/W&nbsp; | 5h&nbsp; | Defines the increment value when compensation is active 7-4&nbsp; | DEFAULT_INC | R/W&nbsp; | 5h&nbsp; | Defines the default increment value 0&nbsp; | CNT_ENABLE&nbsp; | R/W&nbsp; | 0h&nbsp; | Counter enable.</div></div>",174:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_count_reg0.&nbsp; When Shadow Mode is disabled, this is the 64-bit count value (lower 32-bits). The count is incremented (DEFAULT_INC or CMP_INC) on every positive edge of ICSSGn_IEP_CLK (200MHz) or ICSSGn_ICLK. In 64-bit mode, reading this value locks the IEP_COUNT_REG1[31-0] COUNT_HI value.&nbsp; When Shadow Mode is enabled, the counter will be in 32-bit mode.</div></div>",175:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_count_reg1.&nbsp; When Shadow Mode is disabled: The master upper 32-bits of the 64-bit count value. The count is incremented (DEFAULT_INC or CMP_INC) on every positive edge of ICSSGn_IEP_CLK (200MHz) or ICSSGn_ICLK. This value only updates when software reads IEP_COUNT_REG0[31-0] COUNT_LO.&nbsp; When Shadow Mode is enabled: This counts the counter reset events caused by CMP0. But, limited to 24-bit counter, so software must clear before this threshold is met.&nbsp; Any writes to COUNT_LO or COUNT_HI will reset COUNT_HI to 0.&nbsp; Max COUNT_HI is 0xFF_FFFF and will stop at this value</div></div>",176:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp_cfg_reg.&nbsp; Bit&nbsp; | Field&nbsp; | Type | Reset | Description 31-18 | RESERVED&nbsp; | R/W&nbsp; | X&nbsp; | 17&nbsp; | SHADOW_EN&nbsp; | R/W&nbsp; | 0h&nbsp; | 16-1&nbsp; | CMP_EN&nbsp; | R/W&nbsp; | 0h&nbsp; | Enable bits for each of the compare registers</div></div>",177:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp0_reg0. Compare 0 low value</div></div>",178:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp0_reg1. Compare 0 high value</div></div>",179:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp1_reg0. Compare 1 low value</div></div>",180:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp1_reg1. Compare 1 high value</div></div>",181:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp2_reg0. Compare 2 low value</div></div>",182:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp2_reg1. Compare 2 high value</div></div>",183:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp3_reg0. Compare 3 low value</div></div>",184:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp3_reg1. Compare 3 high value</div></div>",185:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp4_reg0. Compare 4 low value</div></div>",186:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp4_reg1. Compare 4 high value</div></div>",187:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp5_reg0. Compare 5 low value</div></div>",188:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp5_reg1. Compare 5 high value</div></div>",189:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp6_reg0. Compare 6 low value</div></div>",190:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp6_reg1. Compare 6 high value</div></div>",191:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp7_reg0. Compare 7 low value</div></div>",192:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp7_reg1. Compare 7 high value</div></div>",193:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_cmp_status_reg.&nbsp; Status bit for each of the compare registers. &quot;Match&quot; indicates the current counter is greater than or equal to the compare value. Note it is the firmware\'s responsibility to handle the IEP overflow.&nbsp; 0h = No match has occured 1h = A match occured. The associated hardware event signal will assert and remain high until the status is cleared.&nbsp; Shadow Mode Disabled: Any write to a CMP register will cause the corresponding CMP_STATUS bit to get cleared Shadow Mode Enabled: Any write to the active CMP&lt;n&gt;_0 will cause the corresponding CMP_STATUS to get cleared. Any write to the shadow CMP&lt;n&gt;_1 will have no effect on pending state If PWM_EFC_EN is set, hardware will auto clear the bit on next clock cycle.</div></div>",194:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_sync_ctrl_reg.&nbsp; Refer table Table 6-1614 TRM</div></div>",195:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_sync_start_reg.&nbsp; Defines the start time after the activation event.&nbsp; 0h = 1 clock cycle delay.&nbsp; Nh = N+1 clock cycles delay</div></div>",196:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_sync0_period_reg.&nbsp; Defines the period between the rising edges of SYNC0.&nbsp; (Check SYNC0_CYCLIC_EN bit in IEP_SYNC_CTRL_REG is set) 0h = Reserved 1h = 2 clk cycles period N: N+1 clk cycles period</div></div>",197:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Set value of iep_sync0_stat_reg.&nbsp; 0: SYNC0_PEND SYNC0 pending state 0h = SYNC0 is not pending 1h = SYNC0 is pending or has occurred when SYNC0_ACK_EN = 0 (Disable). Write &quot;1&quot; to clear</div></div>",198:"<div class=\"NDToolTip TMacro LAssembly\"><div class=\"TTSummary\">Get value of get_iep_sync0_stat_reg.&nbsp; 0: SYNC0_PEND SYNC0 pending state 0h = SYNC0 is not pending 1h = SYNC0 is pending or has occurred when SYNC0_ACK_EN = 0 (Disable). Write &quot;1&quot; to clear</div></div>"});