/*
 * Copyright (c) 2024, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * initTableTypes.h
 *
 *  Created on: Apr 13, 2011
 *      Author: a0387670
 */

#ifndef INITTABLETYPES_H_
#define INITTABLETYPES_H_

#include "paramOut.h"
#include "802_11defs.h"

#define REG_DOMAIN_COUNTRY_STR_LEN		DOT11_COUNTRY_STRING_LEN-1

//typedef struct
//{
//	TReportInitParams				tReport;
//	TTwdInitParams      			tTwdInitParams;
//	ctrlDataInitParams_t    		tCtrlDataInitParams;
//	TUdataInitParams                tUdataInitParams;
//	regulatoryDomainInitParams_t    tRegulatoryDomainInitParams;
//	TScanCncnInitParams             tScanCncnInitParams;
//    TMlmeParserInitParams           tMlmeParserInitParams;
//    healthMonitorInitParams_t		tHealthMonitorInitParams;
//    SoftGeminiInitParams_t          tSoftGeminiInitParams;
//    TRolesMngrInitParams			tRolesMngrInitParams;
//    TRatePoliciesInitParams         tRatePoliciesInitParams;
//    TDrvMainParams                  tDrvMainParams;
//
//}TInitTableCommonCfg; /* drvMain's Init table*/


//typedef struct
//{
//	TSmeInitParams 					tSmeInitParams;
//	TSmeModifiedInitParams			tSmeModifiedInitParams;
//	TRsnInitParams 					tRsnInitParams;
//	apConnParams_t                  tApConnParams;
//	TRoamScanMngrInitParams         tRoamScanMngrInitParams;
//	QosMngrInitParams_t             tQosMngrInitParams;
//	SwitchChannelInitParams_t		tSwitchChannelInitParams;
//	PowerMgrInitParams_t            tPowerMgrInitParams;
//	measurementInitParams_t         tMeasurementInitParams;
//	connInitParams_t                tConnInitParams;
//	TCurrBssInitParams              tCurrBssInitParams;
//#ifdef CCX_MODULE_INCLUDED
//	ccxMngrParams_t                 tCcxMngrParams;
//#endif /* CCX_MODULE_INCLUDED */
//
//  TRoleStaInitParams              tRoleStaInitParams;
//  TMlmeInitParams                 tMlmeInitParams;
//
//}TInitTableRoleStaCfg; /* drvMain's Init table*/


//typedef struct
//{
//	TRoleApInitParams		tRoleAPInitParams;
//}TInitTableRoleAPCfg; 		/* drvMain's Init table*/


/* Regulatoty Domain init table*/
typedef struct
{
	uint8_t band;
    uint8_t TxPower;
    uint8_t DfsChannel;
	uint8_t NumOfChannels;
	uint8_t Channel[REG_DOMAIN_MAX_CHAN_NUM];
} RegDomainChan_t;

typedef struct
{
	char             CountryStr[REG_DOMAIN_COUNTRY_STR_LEN];
    RegDomainChan_t  DomainReg;
} RegDomainInfoRow_t;




//#define INI_FILE_NAME_COMMON "tiwlan.ini"
//#define INI_FILE_NAME_REGULATORY "tiwlanRegDomain.ini"
//#define INI_FILE_NAME_ROLE_STA "roleSta.ini"
//#define INI_FILE_NAME_ROLE_AP "roleAp.ini"
//#define INI_FILE_NAME_ROLE_P2PCL "roleP2pCl.ini"
//
//#define TLV_BIN_FILE_NAME_COMMON "tiwlan.bin"
//#define TLV_BIN_FILE_NAME_REGULATORY "tiwlanRegDomain.bin"
//#define TLV_BIN_FILE_NAME_ROLE_STA "roleSta.bin"
//#define TLV_BIN_FILE_NAME_ROLE_AP "roleAp.bin"
//#define TLV_BIN_FILE_NAME_ROLE_P2PCL "roleP2pCl.bin"

typedef enum
{
	INI_FILE_TYPE_COMMON = 0,
	INI_FILE_TYPE_REGULATORY,
	INI_FILE_TYPE_ROLE_STA,
	INI_FILE_TYPE_ROLE_AP,
	INI_FILE_TYPE_ROLE_P2PCL,
	INI_FILE_TYPE_MAX,
} EINIFileType;

typedef enum
{
	CMN_KEY_REPORT_SEVERITY_TABLE = 0,
	CMN_KEY_CALIBRATION_CHANNEL24,
	CMN_KEY_CALIBRATION_CHANNEL5,
	CMN_KEY_TX_COMPLETE_THRESHOLD,
	CMN_KEY_RX_INTERRUPT_THRESHOLD,
	CMN_KEY_RX_AGGREGATION_PKTS_LIMIT,
	CMN_KEY_DOT11FRAGMENTATION_THRESHOLD,
    CMN_KEY_DOT11MAX_RECEIVE_LIFETIME,
	CMN_KEY_DOT11NETWORK_TYPE,
	CMN_KEY_RATE_POLICY_USER_SHORT_RETRY_LIMIT,
	CMN_KEY_RATE_POLICY_USER_LONG_RETRY_LIMIT,
    CMN_KEY_JAPAN_CHANNELS_ENABLED,
	CMN_KEY_SRSTATE,
	CMN_KEY_SRF1,
	CMN_KEY_SRF2,
	CMN_KEY_SRF3,
	CMN_KEY_DCO_ITRIM_ENABLED,
	CMN_KEY_FM_COEXU_ENABLE,
	CMN_KEY_FM_COEXU_SWALLOW_PERIOD,
	CMN_KEY_FM_COEXU_NDIVIDER_FREF_SET1,
	CMN_KEY_FM_COEXU_NDIVIDER_FREF_SET2,
	CMN_KEY_FM_COEXU_MDIVIDER_FREF_SET1,
	CMN_KEY_FM_COEXU_MDIVIDER_FREF_SET2,
	CMN_KEY_DCO_ITRIM_MODERATION_TIMEOUT,
	CMN_KEY_TX_POWER,
	CMN_KEY_BTH_WLAN_COEXIST_ENABLE,
	CMN_KEY_HT_ENABLE,
	CMN_KEY_40MHZ_ENABLE,
	CMN_KEY_MIMO_ENABLE,
	CMN_KEY_QOS_TX_BLKS_THRESHOLD_VO,
	CMN_KEY_CLSFR_TYPE,
	CMN_KEY_NUM_OF_CODE_POINTS,
	CMN_KEY_DSCPCLASSIFIER00_CODE_POINT,
	CMN_KEY_DSCPCLASSIFIER01_CODE_POINT,
	CMN_KEY_DSCPCLASSIFIER02_CODE_POINT,
	CMN_KEY_DSCPCLASSIFIER03_CODE_POINT,
	CMN_KEY_DSCPCLASSIFIER04_CODE_POINT,
	CMN_KEY_DSCPCLASSIFIER05_CODE_POINT,
	CMN_KEY_DSCPCLASSIFIER06_CODE_POINT,
	CMN_KEY_DSCPCLASSIFIER07_CODE_POINT,
	CMN_KEY_DSCPCLASSIFIER00_DTAG,
	CMN_KEY_DSCPCLASSIFIER01_DTAG,
	CMN_KEY_DSCPCLASSIFIER02_DTAG,
	CMN_KEY_DSCPCLASSIFIER03_DTAG,
	CMN_KEY_DSCPCLASSIFIER04_DTAG,
	CMN_KEY_DSCPCLASSIFIER05_DTAG,
	CMN_KEY_DSCPCLASSIFIER06_DTAG,
	CMN_KEY_DSCPCLASSIFIER07_DTAG,
	CMN_KEY_SCAN_RESULT_AGING,
	CMN_KEY_SETTINGS,
	CMN_KEY_TX_AGGREGATION_PKTS_LIMIT,
    CMN_KEY_RECOVERY_ENABLE,
    CMN_KEY_COEX_ANTENNA_CONFIGURATION,
	CMN_KEY_COEX_HV3AUTO_ENLARGE_PASSIVE_SCAN_WINDOW_PERCENT,
	CMN_KEY_COEX_CONSECUTIVE_HV3IN_PASSIVE_SCAN,
	CMN_KEY_COEX_BEACON_HV3COLLISION_TIME_THRESHOLD_PASSIVE_SCAN,
	CMN_KEY_COEX_PASSIVE_SCAN_TXRXPROTECTION_BAND_WITH,
	CMN_KEY_COEX_TEMP_PARAM1,
	CMN_KEY_COEX_TEMP_PARAM2,
	CMN_KEY_COEX_TEMP_PARAM3,
	CMN_KEY_HOST_IF_CFG_BITMAP,
    CMN_KEY_LOG_MODE,				
	CMN_KEY_BUFFER_SIZE,			
	CMN_KEY_LOG_SEVERITY,			
	CMN_KEY_TIME_STAMP,
	CMN_KEY_MSG_OUT_PUT,
	CMN_KEY_THRESHOLD,
    CMN_KEY_FW_MEM_DUMP,
    CMN_KEY_ROLES_COMBINATION,
	CMN_KEY_COEX_RXT,
	CMN_KEY_COEX_ADAPTIVE_RXT_TXT,
	CMN_KEY_COEX_CTS_DILUTED_BAD_RX_PACKETS_TH,
	CMN_KEY_COEX_CTS_CHOP_IN_DUAL_ANT_SCO_MASTER,
	CMN_KEY_SCAN_RSSI_THRESHOLD,
   	CMN_KEY_DEFAULT_POWER_LEVEL,
    CMN_KEY_INACTIVITY_PERIOD,
    CMN_KEY_MAC_ADDRESS_OVERRIDE,
	CMN_KEY_PHY_STAND_ALONE,
	CMN_KEY_PRIMARY_CLOCK_SETTING_TIME,
	CMN_KEY_SECONDARY_CLOCK_SETTING_TIME,
	CMN_KEY_AUTO_DETECT,
	CMN_KEY_DEDICATED_FEM,
	CMN_KEY_LOW_BAND_COMPONENT,
	CMN_KEY_LOW_BAND_COMPONENT_TYPE,
	CMN_KEY_HIGH_BAND_COMPONENT,
	CMN_KEY_HIGH_BAND_COMPONENT_TYPE,
	CMN_KEY_NUM_OF_ASSEMBLED_ANT2_4,
	CMN_KEY_NUM_OF_ASSEMBLED_ANT5,
	CMN_KEY_EXTERNAL_PA_DC2DC,
	CMN_KEY_TCXO_LDO_VOLTAGE,
	CMN_KEY_XTAL_ITRIM_VAL,
	CMN_KEY_IO_CONFIGURATION,
	CMN_KEY_SDIO_CONFIGURATION,
	CMN_KEY_RX_PROFILE,
	CMN_KEY_PWR_LIMIT_REFERENCE_11ABG,
	CMN_KEY_PWR_LIMIT_REFERENCE_11P,
	CMN_KEY_PER_CHANNEL_PWR_LIMIT_ARR_ABG,
	CMN_KEY_BOARD_TYPE,
	CMN_KEY_ENABLE_CLPC,
	CMN_KEY_ENABLE_TX_LOW_PWR_ON_SISO_RDL,
	CMN_KEY_PER_SUB_BAND_TX_TRACE_LOSS,
	CMN_KEY_PER_SUB_BAND_RX_TRACE_LOSS,
	CMN_KEY_PIN_MUXING_PLATFORM_OPTIONS,
	CMN_KEY_PER_CHANNEL_PWR_LIMIT_ARR_11P,
	CMN_KEY_CLOCK_VALID_ON_WAKE_UP,
	CMN_KEY_ENABLE_POINT_SAT,
	CMN_KEY_LOW_POWER_VAL,
	CMN_KEY_MED_POWER_VAL,
	CMN_KEY_HIGH_POWER_VAL,
	CMN_KEY_TX_RF_MARGIN,
	CMN_KEY_LOW_POWER_VAL_2,
	CMN_KEY_MED_POWER_VAL_2,
	CMN_KEY_HIGH_POWER_VAL_2,
	CMN_KEY_PER_CHAN_BO_MODE_11ABG,
	CMN_KEY_PER_CHAN_BO_MODE_11P,
    CMN_KEY_MAX
}EMetaKeysCmn;


typedef enum
{
	REG_DOMAIN_KEY_COUNTRY_CONFIG,
	REG_DOMAIN_KEY_NUM_OF_COUNTRIES,
	REG_DOMAIN_KEY_MAX
}EMetaKeysRegDomain;

typedef enum
{
	STA_KEY_WPAMIXED_MODE = 0,
	STA_KEY_BURST_MODE_ENABLE,
	STA_KEY_SME_CONNECT_MODE,
	STA_KEY_ROAM_SCAN_ENABLE,
	STA_KEY_WME_ENABLE,
	STA_KEY_DESIRED_PS_MODE,
	STA_KEY_QOS_WME_PS_MODE_BE,
	STA_KEY_QOS_WME_PS_MODE_BK,
	STA_KEY_QOS_WME_PS_MODE_VI,
	STA_KEY_QOS_WME_PS_MODE_VO,
	STA_KEY_BA_POLICY_TID_0,
	STA_KEY_BA_POLICY_TID_1,
	STA_KEY_BA_POLICY_TID_2,
	STA_KEY_BA_POLICY_TID_3,
	STA_KEY_BA_POLICY_TID_4,
	STA_KEY_BA_POLICY_TID_5,
	STA_KEY_BA_POLICY_TID_6,
	STA_KEY_BA_POLICY_TID_7,
	STA_KEY_BA_INACTIVITY_TIMEOUT,
	STA_KEY_ROAMING_OPERATIONAL_MODE,
	STA_KEY_RE_AUTH_ACTIVE_PRIORITY,
    STA_KEY_DPS_TIMEOUT,
	STA_KEY_BEACON_RECEIVE_TIME,
	STA_KEY_BEACON_LISTEN_INTERVAL,
	STA_KEY_DTIM_LISTEN_INTERVAL,
    STA_KEY_POWER_SAVE_DOZE_MODE,
	STA_KEY_SME_SCAN_GCHANNEL_LIST,
	STA_KEY_SME_SCAN_ACHANNEL_LIST,
	STA_KEY_DOT11NETWORK_TYPE,
	STA_KEY_MAC_FILTER_ENABLED,
	STA_KEY_NUM_GROUP_ADDRS,
	STA_KEY_GROUP_ADDR0,
	STA_KEY_GROUP_ADDR1,
	STA_KEY_GROUP_ADDR2,
	STA_KEY_GROUP_ADDR3,
	STA_KEY_GROUP_ADDR4,
	STA_KEY_GROUP_ADDR5,
	STA_KEY_GROUP_ADDR6,
	STA_KEY_GROUP_ADDR7,
	STA_KEY_ARP_IP_ADDR,
	STA_KEY_ARP_IP_FILTER_ENA,
	STA_KEY_BEACON_FILTER_DESIRED_STATE,
	STA_KEY_BEACON_FILTER_STORED,
	STA_KEY_BEACON_IE_TABLE_SIZE,
	STA_KEY_BEACON_IE_TABLE,
	STA_KEY_BEACON_IE_NUM_OF_ELEM,
	STA_KEY_SEND_TSPEC_IN_REASS_PKT,
	STA_KEY_DOT11BASIC_RATE_MASK,
	STA_KEY_DOT11SUPPORTED_RATE_MASK,
	STA_KEY_DESIRED_MAX_SP_LEN,
    STA_KEY_DOT11_RTS_THRESHOLD,
	STA_KEY_RX_BROADCAST_IN_PS,	
	STA_KEY_CONSECUTIVE_PS_POLL_DELIVERY_FAILURE_THRESHOLD,
    STA_KEY_RSSI_BEACON_AVERAGE_WEIGHT,
	STA_KEY_RSSI_PACKET_AVERAGE_WEIGHT,
	STA_KEY_SNR_BEACON_AVERAGE_WEIGHT,
	STA_KEY_SNR_PACKET_AVERAGE_WEIGHT,
    STA_KEY_DOT11LISTEN_INTERVAL,
    STA_KEY_PROBE_BEFORE_CONNECT,
	STA_KEY_MEASUREMENT_MIN_TIME_BET_REQ,
#ifdef CCX_MODULE_INCLUDED
	STA_KEY_MEASUREMENT_CCX_ENABLE,
	STA_KEY_MEASUREMENT_ONLY_SERVING_CHANNEL,
#endif	
	STA_KEY_MAX
}EMetaKeysSta;

typedef enum
{
	AP_KEY_DOT11NETWORK_TYPE = 0,
	AP_KEY_ARP_IP_ADDR,
	AP_KEY_ARP_IP_FILTER_ENA,
	AP_KEY_MAC_FILTER_ENABLED,
	AP_KEY_NUM_GROUP_ADDRS,
	AP_KEY_GROUP_ADDR0,
	AP_KEY_GROUP_ADDR1,
	AP_KEY_GROUP_ADDR2,
	AP_KEY_GROUP_ADDR3,
	AP_KEY_GROUP_ADDR4,
	AP_KEY_GROUP_ADDR5,
	AP_KEY_GROUP_ADDR6,
	AP_KEY_GROUP_ADDR7,
	AP_KEY_BA_POLICY_TID_0,
	AP_KEY_BA_POLICY_TID_1,
	AP_KEY_BA_POLICY_TID_2,
	AP_KEY_BA_POLICY_TID_3,
	AP_KEY_BA_POLICY_TID_4,
	AP_KEY_BA_POLICY_TID_5,
	AP_KEY_BA_POLICY_TID_6,
	AP_KEY_BA_POLICY_TID_7,
	AP_KEY_BA_INACTIVITY_TIMEOUT,
    AP_KEY_DOT11_RTS_THRESHOLD,
	AP_KEY_RSSI_BEACON_AVERAGE_WEIGHT,
	AP_KEY_RSSI_PACKET_AVERAGE_WEIGHT,
	AP_KEY_SNR_BEACON_AVERAGE_WEIGHT,
	AP_KEY_SNR_PACKET_AVERAGE_WEIGHT,
    AP_KEY_MAX
} EMetaKeysAp;

#endif /* INITTABLETYPES_H_ */

