/* --COPYRIGHT--,BSD
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
//*****************************************************************************
//
// This file is generated by ftrasterize; DO NOT EDIT BY HAND!
//
//*****************************************************************************

#include <ti/grlib/grlib.h>

//*****************************************************************************
//
// Details of this font:
//     Style: cmss
//     Size: 42 point
//     Bold: no
//     Italic: yes
//     Memory usage: 5108 bytes
//
//*****************************************************************************

//*****************************************************************************
//
// The compressed data for the 42 point Cmss italic font.
//
//*****************************************************************************
static const uint8_t g_pucCmss42iData[4908] =
{
    5,  17,   0,  91,  48,  34,  13, 240, 240, 243, 163, 147,
    163, 163, 163, 163, 147, 163, 163, 163, 163, 147, 163, 163,
    163, 162, 178, 163, 163, 163, 162,   0,   7,  99, 147, 163,
    0,  19,  16,  25,  16,   0,   6,  35,  67,  84,  52,  84,
    52,  98,  82, 114,  82,  98,  82, 114,  82, 113,  97, 114,
    82,   0,  62, 112, 113,  34,   0,  15,   2, 114, 240, 129,
    129, 240, 130, 114, 240, 129, 129, 240, 130, 114, 240, 129,
    129, 240, 130, 114, 240, 129, 129, 240, 130, 114, 240, 129,
    130, 240, 114, 114, 240, 130, 114, 240, 114, 129, 240, 130,
    114, 223,  13, 241, 130, 240, 114, 129, 240, 130, 114, 240,
    129, 129, 240, 130, 114, 240, 129, 130, 240, 114, 129, 255,
    13, 210, 114, 240, 129, 130, 240, 114, 114, 240, 130, 114,
    240, 114, 129, 240, 130, 114, 240, 129, 129, 240, 130, 114,
    240, 129, 129, 240, 130, 114, 240, 129, 129, 240, 130, 114,
    240, 129, 129, 240, 130, 129,   0,  15,  64,  73,  24, 240,
    240, 114, 240, 114, 240,  86, 240,  26, 220, 165,  18,  36,
    163,  50,  65, 163,  51, 242,  67, 227,  66, 243,  66, 243,
    51, 244,  35, 245,  18, 240,  39, 240,  42, 240,  25, 240,
    39, 240,  34,  21, 243,  36, 243,  51, 243,  51, 242,  67,
    242,  67, 227,  51, 243,  51, 130,  82,  51, 148,  50,  20,
    173, 218, 240,  22, 240,  82, 240, 114,   0,  29,  99,  29,
    84, 241, 134, 210, 119, 194, 116,  35, 177, 131,  51, 162,
    115,  67, 146, 131,  67, 130, 147,  67, 129, 148,  67, 114,
    147,  83,  98, 163,  67,  98, 179,  67,  97, 195,  67,  82,
    195,  51,  82, 212,  19,  97, 247,  81, 240,  36,  98, 240,
    178, 240, 193, 101, 240,  18,  87, 226,  83,  36, 194,  83,
    67, 193,  84,  67, 178,  83,  83, 162,  99,  83, 146,  99,
    99, 145, 115,  84, 130, 115,  83, 130, 131,  83, 129, 147,
    67, 130, 148,  36, 114, 184, 114, 199, 129, 228,   0,  33,
    112,  79,  30,   0,  12, 116, 240, 151, 240, 121, 240,  84,
    51, 240,  83,  67, 240,  67,  83, 240,  67,  83, 240,  66,
    84, 240,  51,  83, 240,  67,  67, 240,  83,  51, 240,  99,
    20, 240, 119, 240, 133, 179, 180, 195, 165, 179, 166, 163,
    148,  20, 147, 132,  36, 131, 131,  84,  99, 147,  84,  83,
    147, 116,  51, 163, 117,  19, 179, 135, 195, 149, 212, 104,
    220,  27, 122,  57, 150, 135,   0,  42,  15,   9, 240, 227,
    84,  84,  98, 114,  98, 114, 113, 114,   0,  35,  96,  52,
    18, 240, 242, 242, 242, 243, 227, 227, 242, 243, 227, 243,
    227, 243, 243, 227, 243, 227, 243, 243, 243, 227, 243, 243,
    243, 243, 227, 243, 243, 243, 243, 243, 243, 243, 243, 243,
    243, 240,  18, 240,  19, 243, 240,  18, 240,  19, 240,  18,
    240,  19, 192,  77,  19, 240, 211, 240,  34, 240,  35, 240,
    34, 240,  35, 240,  19, 240,  34, 240,  35, 240,  19, 240,
    19, 240,  19, 240,  19, 240,  19, 240,  19, 240,  19, 240,
    19, 240,  19, 240,  19, 244, 243, 240,  19, 240,  19, 240,
    19, 244, 243, 240,  19, 240,  19, 243, 240,  19, 240,  19,
    243, 240,  19, 243, 240,  19, 243, 240,  18, 240,  19, 243,
    243, 240,  18, 240,  18, 243, 240,  16,  39,  20, 240, 226,
    240,  35, 240,  35, 240,  34, 195,  50,  51, 100,  34,  36,
    109, 153, 198, 230, 201, 151,  21, 100,  34,  36,  99,  50,
    66, 194, 240,  35, 240,  35, 240,  34,   0,  61,  80,  61,
    30,   0,  31, 113, 240, 225, 240, 225, 240, 210, 240, 210,
    240, 209, 240, 225, 240, 225, 240, 210, 240, 210, 240, 209,
    240, 225, 240, 225, 240,  31,  11, 240,  17, 240, 225, 240,
    225, 240, 210, 240, 210, 240, 209, 240, 225, 240, 225, 240,
    210, 240, 210, 240, 209, 240, 225, 240, 225,   0,  32,  48,
    15,   9,   0,  32, 115,  84,  83, 114,  99,  98, 113, 114,
    0,   7,  80,  10,  15,   0,  39,  59,  75,  75,   0,  36,
    16,  10,   8,   0,  29,  19,  68,  67,   0,  11,  80,  88,
    27,   0,   6,  17, 240, 162, 240, 161, 240, 162, 240, 146,
    240, 162, 240, 146, 240, 161, 240, 162, 240, 161, 240, 162,
    240, 161, 240, 162, 240, 161, 240, 162, 240, 146, 240, 162,
    240, 146, 240, 161, 240, 162, 240, 161, 240, 162, 240, 161,
    240, 162, 240, 161, 240, 162, 240, 146, 240, 162, 240, 146,
    240, 161, 240, 162, 240, 161, 240, 162, 240, 161, 240, 162,
    240, 161, 240, 162, 240, 146, 240, 161, 240, 162, 240, 161,
    0,   6,  80,  55,  21,   0,  14,  37, 232, 202, 164,  52,
    147, 100, 131, 115, 115, 131, 115, 131,  99, 147,  99, 147,
    99, 147,  83, 163,  83, 147,  99, 147,  99, 147,  83, 163,
    83, 148,  83, 147,  99, 147,  99, 132,  99, 131, 115, 116,
    116,  84, 148,  52, 170, 200, 229,   0,  30,  64,  35,  18,
    0,  12,  83, 153, 152, 163,  35, 243, 228, 228, 227, 243,
    243, 228, 227, 243, 243, 243, 228, 227, 243, 243, 243, 228,
    227, 243, 243, 243, 157,  93,   0,  25,  48,  58,  23,   0,
    15,  85, 240,  25, 219, 179,  84, 163, 116, 131, 147, 130,
    163, 130, 163, 240,  83, 240,  83, 240,  67, 240,  83, 240,
    67, 240,  67, 240,  67, 240,  67, 240,  66, 240,  82, 240,
    67, 240,  67, 240,  66, 240,  82, 240,  82, 240,  67, 240,
    79,   1, 127, 143,   0,  32,  80,  55,  23,   0,  15, 101,
    249, 219, 180,  84, 147, 131, 146, 147, 240,  83, 240,  67,
    240,  83, 240,  67, 240,  52, 247, 240,  21, 240,  40, 240,
    84, 240,  84, 240,  83, 240,  83, 240,  83, 240,  83, 240,
    67, 129, 179, 115, 147, 148,  85, 172, 201, 240,  21,   0,
    33,  32,  60,  22,   0,  15,  68, 240,  37, 240,  21, 240,
    37, 240,  18,  19, 242,  35, 227,  20, 211,  35, 226,  51,
    211,  51, 195,  52, 179,  67, 179,  83, 179,  83, 163,  99,
    147, 100, 131, 115, 159,   2,  79,   3,  79,   3, 228, 240,
    51, 240,  67, 240,  67, 240,  52, 240,  51, 240,  67,   0,
    31,  64,  54,  23,   0,  15,  44, 173, 173, 163, 240,  83,
    240,  83, 240,  67, 240,  83, 240,  83, 240,  83,  21, 211,
    23, 204, 181,  67, 179, 115, 163, 115, 240,  83, 240,  83,
    240,  83, 240,  83, 240,  67, 240,  83, 129, 163, 131, 132,
    148,  84, 172, 202, 245,   0,  33,  48,  54,  22,   0,  15,
    22, 233, 186, 181, 240,  20, 240,  36, 240,  51, 240,  51,
    240,  52,  53, 163,  40, 132,  25, 134,  69, 117, 100, 116,
    131, 100, 147, 100, 147,  99, 163,  99, 163,  99, 147, 115,
    147, 115, 147, 115, 131, 132,  99, 164,  68, 171, 200, 245,
    0,  32,  61,  22,   0,  13, 127,   2,  95,   2,  95,   2,
    240,  51, 240,  51, 240,  51, 240,  51, 240,  51, 240,  51,
    240,  67, 240,  51, 240,  51, 240,  52, 240,  51, 240,  51,
    240,  67, 240,  51, 240,  67, 240,  51, 240,  67, 240,  51,
    240,  67, 240,  52, 240,  51, 240,  67, 240,  52, 240,  52,
    0,  32,  64,  52,  22,   0,  14, 118, 233, 203, 164,  84,
    132, 115, 131, 131, 115, 147, 115, 147, 115, 147, 115, 131,
    148,  68, 185, 245, 249, 180,  68, 147, 116, 115, 147, 115,
    147,  99, 163,  99, 163,  99, 147, 115, 147, 116, 115, 148,
    69, 156, 185, 245,   0,  31, 112,  56,  22,   0,  15,   5,
    248, 218, 164,  83, 163, 115, 131, 131, 115, 147, 115, 147,
    115, 147,  99, 163,  99, 163,  99, 148,  99, 148,  99, 132,
    116, 101, 117,  66,  19, 137,  20, 136,  35, 165,  52, 240,
    51, 240,  52, 240,  36, 240,  36, 162,  69, 171, 200, 245,
    0,  32,  16,  15,  11,   0,  19,  99, 116, 115,   0,  17,
    35, 116, 115,   0,  16,  16,  20,  12,   0,  21,  83, 132,
    131,   0,  18, 115, 132, 131, 162, 147, 146, 161, 162,   0,
    10,  32,  34,  13,   0,  18,  83, 148, 147,   0,   7,  98,
    163, 163, 163, 162, 178, 163, 163, 163, 162, 163, 163, 163,
    163, 163, 147, 163, 163, 163, 163, 147, 163,   0,   6,  16,
    13,  31,   0,  66,  31,  10,   0,  27,  95,  10,   0,  66,
    80,  36,  17,   0,  24,  68, 212, 211,   0,  10,  19, 227,
    227, 226, 227, 227, 211, 227, 211, 211, 211, 212, 196, 211,
    211, 227, 227, 227, 145,  68,  84,  92,  90, 150,   0,   7,
    48,  36,  18,   0,   7,  54, 170, 108,  99, 100,  81, 147,
    243, 243, 243, 227, 228, 212, 212, 212, 212, 227, 227, 242,
    243, 242, 243, 243, 243,   0,  10,  99, 228, 227,   0,  26,
    80,  75,  26,   0,  11,  54, 240,  42, 252, 198,  69, 164,
    147, 148,  84,  19, 132,  74, 116,  75, 115,  68,  53,  99,
    68,  84,  99,  67, 100,  83,  67, 131,  83,  67, 131,  83,
    67, 131,  67,  67, 132,  67,  67, 131,  83,  67, 131,  83,
    67, 116,  83,  67, 115,  99,  68,  84,  99,  84,  52, 116,
    74, 147,  88, 164,  85, 212, 240, 118, 116, 174, 235, 240,
    38,   0,  37,  48,  75,  28,   0,  12,  68, 240, 133, 240,
    133, 240, 118, 240, 114,  19, 240,  99,  19, 240,  98,  36,
    240,  67,  36, 240,  51,  67, 240,  51,  67, 240,  35,  83,
    240,  35,  83, 240,  19,  99, 240,  19, 100, 227, 116, 226,
    132, 211, 132, 195, 148, 207,   1, 191,   2, 191,   2, 164,
    180, 147, 196, 131, 212, 131, 212, 115, 243, 100, 243,  99,
    240,  19,  84, 240,  20,   0,  39,  59,  27,   0,  10, 124,
    239, 195, 134, 163, 164, 163, 180, 147, 195, 132, 195, 131,
    196, 131, 195, 147, 179, 148, 164, 147, 133, 191, 205, 239,
    180, 133, 164, 164, 147, 196, 131, 211, 131, 211, 116, 211,
    116, 211, 115, 211, 131, 211, 131, 195, 132, 179, 148, 133,
    175,   1, 189,   0,  38, 112,  61,  26,   0,  11,  40, 240,
    28, 206, 181, 115, 164, 240, 100, 240, 100, 240, 100, 240,
    115, 240, 115, 240, 131, 240, 115, 240, 131, 240, 131, 240,
    115, 240, 131, 240, 131, 240, 131, 240, 131, 240, 131, 240,
    131, 240, 132, 240, 131, 240, 132, 240, 132, 162, 165, 116,
    190, 220, 240,  23,   0,  37,  48,  64,  29,   0,  11,  93,
    240,  31, 227, 133, 196, 164, 179, 196, 163, 211, 163, 211,
    148, 227, 132, 227, 131, 243, 131, 243, 131, 243, 116, 243,
    116, 243, 115, 240,  19, 115, 243, 131, 243, 116, 243, 116,
    242, 131, 243, 131, 242, 147, 227, 132, 211, 148, 195, 163,
    195, 179, 179, 180, 148, 207,   1, 221,   0,  41, 112,  65,
    27,   0,  10, 127,   2, 159,   3, 159,   2, 163, 240, 147,
    240, 147, 240, 132, 240, 132, 240, 131, 240, 147, 240, 132,
    240, 132, 240, 143,   1, 191,   1, 191,   1, 164, 240, 132,
    240, 131, 240, 147, 240, 147, 240, 132, 240, 132, 240, 131,
    240, 147, 240, 147, 240, 132, 240, 143,   3, 159,   3, 159,
    3,   0,  38,  32,  62,  26,   0,  10,  79,   1, 159,   2,
    159,   2, 147, 240, 131, 240, 131, 240, 116, 240, 116, 240,
    115, 240, 131, 240, 116, 240, 116, 240, 115, 240, 143, 191,
    175,   1, 164, 240, 116, 240, 115, 240, 131, 240, 116, 240,
    116, 240, 115, 240, 131, 240, 131, 240, 116, 240, 116, 240,
    115, 240, 131,   0,  38,  80,  61,  27,   0,  11,  88, 240,
    44, 223, 181, 100, 180, 162, 164, 240, 116, 240, 116, 240,
    131, 240, 131, 240, 147, 240, 131, 240, 147, 240, 147, 240,
    131, 240, 147, 240, 147, 152, 115, 152, 115, 137, 115, 211,
    131, 211, 147, 195, 147, 195, 148, 164, 164, 147, 181, 116,
    207, 220, 240,  39,   0,  38, 112,  65,  30,   0,  12,   3,
    212, 148, 211, 164, 211, 163, 212, 163, 212, 163, 212, 148,
    211, 164, 211, 163, 212, 163, 212, 163, 212, 148, 211, 175,
    5, 175,   5, 175,   5, 148, 211, 164, 211, 163, 227, 163,
    212, 163, 212, 148, 211, 164, 211, 163, 227, 163, 212, 163,
    212, 148, 211, 164, 211, 163, 212, 163, 212,   0,  42,  64,
    36,  14,   0,   6,   4, 164, 163, 179, 164, 164, 164, 163,
    179, 164, 164, 163, 179, 164, 164, 164, 163, 179, 164, 164,
    163, 179, 164, 164, 164, 163, 179, 164, 164,   0,  20,  64,
    61,  23,   0,  10,  83, 240,  68, 240,  68, 240,  67, 240,
    83, 240,  83, 240,  68, 240,  67, 240,  83, 240,  83, 240,
    68, 240,  68, 240,  67, 240,  83, 240,  83, 240,  68, 240,
    68, 240,  67, 240,  83, 240,  68, 240,  68, 240,  67, 240,
    83, 240,  68, 161, 132, 147,  85, 172, 202, 246,   0,  33,
    48,  76,  30,   0,  12,   3, 212, 148, 196, 164, 180, 179,
    180, 195, 164, 211, 148, 212, 132, 228, 100, 240,  19, 100,
    240,  35,  84, 240,  51,  68, 240,  52,  52, 240,  67,  53,
    240,  67,  39, 240,  51,  24, 240,  40,  36, 240,  23,  52,
    240,  21,  99, 240,  20, 116, 243, 132, 228, 148, 212, 148,
    211, 180, 195, 180, 195, 180, 180, 196, 164, 196, 163, 228,
    147, 228,   0,  42,  48,  64,  20,   0,   8,  35, 240,  20,
    240,  20, 240,  19, 240,  35, 240,  35, 240,  20, 240,  20,
    240,  19, 240,  35, 240,  35, 240,  20, 240,  20, 240,  19,
    240,  35, 240,  20, 240,  20, 240,  19, 240,  35, 240,  35,
    240,  20, 240,  20, 240,  19, 240,  35, 240,  35, 240,  20,
    240,  31,   1,  79,   1,  79,   0,  28,  16, 106,  36,   0,
    14,  37, 240,  21, 150, 246, 150, 246, 150, 230, 166, 230,
    166, 211,  19, 148,  19, 199, 147,  35, 179,  20, 147,  35,
    178,  35, 163,  35, 163,  35, 163,  35, 147,  51, 148,  35,
    147,  36, 147,  51, 131,  51, 163,  51, 131,  51, 163,  52,
    99,  67, 163,  67,  99,  67, 148,  67,  83,  68, 147,  83,
    83,  67, 163,  83,  67,  83, 163,  83,  66,  99, 148,  83,
    51,  99, 148,  83,  35, 100, 147, 115,  19,  99, 163, 118,
    115, 163, 118, 115, 148, 117, 116, 147, 132, 132, 147, 132,
    131, 163, 240,  83,   0,  50,  96,  85,  30,   0,  12,   5,
    180, 150, 179, 166, 179, 167, 163, 163,  19, 163, 163,  19,
    148, 148,  19, 147, 163,  36, 131, 163,  51, 131, 163,  51,
    131, 163,  51, 116, 147,  68,  99, 163,  68,  99, 163,  83,
    99, 163,  83,  84, 148,  84,  67, 163, 100,  67, 163, 115,
    67, 163, 115,  67, 163, 116,  36, 148, 116,  35, 163, 147,
    35, 163, 147,  35, 163, 148,  19, 163, 152, 148, 166, 163,
    182, 163, 182, 163, 182,   0,  42,  64,  74,  28,   0,  12,
    6, 240,  90, 240,  29, 229,  85, 196, 148, 163, 180, 147,
    211, 132, 227, 115, 243,  99, 240,  19,  99, 240,  19,  83,
    240,  35,  83, 240,  35,  83, 240,  35,  67, 240,  51,  67,
    240,  35,  83, 240,  35,  83, 240,  35,  83, 240,  19,  99,
    240,  19,  99, 243, 116, 212, 131, 196, 148, 164, 180, 132,
    197,  85, 237, 240,  26, 240,  86,   0,  40,  64,  59,  27,
    0,  10, 125, 239, 195, 133, 164, 163, 163, 180, 147, 195,
    147, 195, 132, 195, 132, 195, 131, 195, 147, 195, 147, 179,
    148, 164, 147, 149, 175,   1, 190, 220, 228, 240, 132, 240,
    131, 240, 147, 240, 147, 240, 132, 240, 132, 240, 131, 240,
    147, 240, 132, 240, 132, 240, 132,   0,  40,  89,  28,   0,
    12,   6, 240,  90, 240,  29, 229,  85, 196, 148, 164, 164,
    148, 195, 132, 212, 115, 243,  99, 240,  19,  99, 240,  19,
    83, 240,  35,  83, 240,  35,  83, 240,  35,  67, 240,  51,
    67, 240,  35,  83, 240,  35,  83, 240,  35,  83, 240,  19,
    99, 240,  19,  99, 100,  83, 116,  84,  68, 131, 100,  51,
    148,  84,  20, 180,  87, 197,  70, 237, 240,  28, 240,  54,
    19, 240, 164, 240, 148, 240, 164, 240, 148, 240, 164,   0,
    22,  16,  60,  27,   0,  10, 124, 239, 195, 149, 163, 179,
    163, 195, 147, 195, 132, 195, 131, 211, 131, 211, 131, 195,
    147, 180, 132, 164, 147, 149, 175,   1, 190, 205, 228,  99,
    227, 116, 211, 131, 211, 131, 196, 132, 180, 147, 179, 164,
    163, 164, 163, 179, 148, 180, 132, 180, 131, 211, 131, 212,
    0,  38,  58,  24,   0,  10,  55, 251, 204, 165,  99, 163,
    161, 147, 240,  98, 240,  99, 240,  99, 240,  99, 240, 100,
    240,  85, 240,  87, 240,  57, 240,  25, 240,  55, 240,  85,
    240,  84, 240,  99, 240,  99, 240,  99, 240,  99, 240,  83,
    129, 195, 115, 163, 133, 100, 158, 203, 247,   0,  34,  80,
    63,  28,   0,  10,  79,   9,  79,   9,  79,   9, 227, 240,
    163, 240, 148, 240, 148, 240, 147, 240, 163, 240, 163, 240,
    148, 240, 148, 240, 147, 240, 163, 240, 163, 240, 148, 240,
    148, 240, 147, 240, 163, 240, 148, 240, 148, 240, 147, 240,
    163, 240, 163, 240, 148, 240, 148, 240, 147, 240, 163, 240,
    163,   0,  41,  65,  27,   0,  10,  83, 211, 131, 211, 116,
    196, 116, 195, 131, 211, 131, 211, 131, 211, 116, 195, 132,
    195, 131, 211, 131, 211, 131, 211, 116, 195, 131, 211, 131,
    211, 131, 211, 131, 196, 131, 195, 131, 211, 131, 211, 131,
    211, 131, 195, 147, 195, 147, 179, 179, 147, 195, 131, 228,
    68, 240,  26, 240,  69,   0,  39,  32,  73,  28,   0,  10,
    67, 240,  51,  67, 240,  35,  84, 240,  19,  84, 243, 100,
    228, 100, 227, 131, 211, 147, 211, 148, 179, 164, 179, 164,
    163, 180, 148, 195, 147, 211, 131, 227, 131, 228,  99, 244,
    99, 244,  83, 240,  20,  83, 240,  35,  67, 240,  51,  67,
    240,  51,  51, 240,  67,  35, 240,  84,  19, 240,  87, 240,
    103, 240, 117, 240, 133, 240, 132,   0,  41, 114,  39,   0,
    14,  83, 196, 211,  67, 196, 195,  83, 181, 195,  83, 181,
    179,  99, 181, 179,  99, 166, 163, 116, 146,  20, 147, 116,
    131,  20, 131, 132, 130,  36, 131, 132, 115,  51, 115, 148,
    115,  51, 115, 148,  99,  67,  99, 164,  99,  67,  99, 164,
    83,  83,  83, 180,  83,  83,  83, 195,  67,  99,  83, 195,
    67,  99,  67, 211,  51, 115,  67, 211,  51, 115,  51, 227,
    50, 131,  51, 227,  35, 131,  35, 243,  34, 147,  35, 243,
    19, 147,  19, 240,  19,  18, 163,  19, 240,  22, 163,  18,
    240,  37, 182, 240,  37, 181, 240,  53, 181, 240,  52, 196,
    0,  55, 112,  77,  32,   0,  12, 100, 228, 180, 211, 196,
    195, 228, 163, 244, 148, 240,  20, 116, 240,  36, 100, 240,
    68,  68, 240,  84,  52, 240, 116,  35, 240, 132,  19, 240,
    166, 240, 182, 240, 196, 240, 197, 240, 182, 240, 183, 240,
    147,  35, 240, 131,  52, 240,  99,  83, 240,  84,  84, 240,
    52, 115, 240,  36, 132, 244, 163, 243, 180, 211, 196, 195,
    228, 164, 228, 148, 240,  20,   0,  45,  71,  29,   0,  10,
    116, 240,  51,  84, 240,  19, 100, 244, 116, 212, 132, 196,
    164, 164, 180, 163, 196, 147, 228, 115, 244, 100, 240,  20,
    68, 240,  36,  52, 240,  52,  51, 240,  84,  19, 240, 103,
    240, 134, 240, 133, 240, 163, 240, 164, 240, 164, 240, 163,
    240, 179, 240, 179, 240, 164, 240, 163, 240, 179, 240, 179,
    240, 164, 240, 164,   0,  42,  48,  65,  29,   0,  11, 111,
    3, 175,   4, 175,   4, 240, 148, 240, 148, 240, 163, 240,
    163, 240, 163, 240, 164, 240, 148, 240, 148, 240, 163, 240,
    163, 240, 163, 240, 164, 240, 148, 240, 148, 240, 163, 240,
    163, 240, 163, 240, 164, 240, 148, 240, 148, 240, 163, 240,
    163, 240, 163, 240, 175,   4, 159,   5, 159,   5,   0,  41,
    75,  19, 135, 199, 198, 211, 244, 243, 240,  19, 240,  19,
    240,  19, 243, 240,  19, 240,  19, 240,  19, 240,  19, 243,
    240,  19, 240,  19, 240,  19, 240,  19, 243, 240,  19, 240,
    19, 240,  19, 243, 240,  19, 240,  19, 240,  19, 240,  19,
    243, 240,  19, 240,  19, 240,  19, 240,  19, 243, 240,  19,
    240,  19, 240,  19, 240,  18, 240,  19, 240,  23, 198, 214,
    240, 240,  32,  25,  17,   0,   6,  98,  98, 113, 113, 114,
    98, 114,  98,  98,  98, 114,  98, 100,  68,  84,  68,  83,
    83,   0,  66,  80,  76,  19, 135, 199, 198, 240,  19, 240,
    19, 240,  19, 240,  19, 243, 240,  19, 240,  19, 240,  19,
    240,  19, 243, 240,  19, 240,  19, 240,  19, 240,  18, 240,
    19, 240,  19, 240,  19, 240,  19, 243, 240,  19, 240,  19,
    240,  19, 240,  19, 243, 240,  19, 240,  19, 240,  19, 240,
    19, 243, 240,  19, 240,  19, 240,  19, 244, 243, 240,  19,
    240,  19, 199, 199, 198, 240, 240,  32,  19,  17,   0,   7,
    19, 213, 179,  19, 147,  35, 131,  67,  99,  98,  83, 115,
    0,  70,  80,  11,   8, 240, 240, 179,  68,  68,  67,   0,
    34,  80,  15,   9, 240, 242, 113, 114, 114,  98, 114, 100,
    84,  83,   0,  35,  80,  37,  19,   0,  34,   7, 170, 146,
    84, 240,  19, 240,  19, 240,  19, 240,  19, 183, 154, 124,
    101,  83,  99, 115,  83, 131,  83, 115, 100,  84, 109, 120,
    19, 133,  51,   0,  26, 112,  63,  21,   0,   8,  83, 240,
    35, 240,  51, 240,  51, 240,  51, 240,  36, 240,  35, 240,
    51, 240,  51, 240,  51, 240,  36, 240,  35,  69, 147,  40,
    141, 133,  69, 100, 116,  99, 147,  99, 147,  99, 147,  99,
    147,  83, 163,  83, 147,  99, 147,  99, 131, 100, 116, 101,
    69, 125, 131,  24, 147,  37,   0,  30,  32,  37,  20,   0,
    36,   6, 202, 140, 117,  83, 100, 240,  19, 240,  19, 240,
    35, 240,  19, 240,  35, 240,  35, 240,  35, 240,  35, 240,
    36, 145, 116,  98, 140, 154, 198,   0,  28,  96,  62,  24,
    0,  11,  19, 240,  83, 240,  99, 240,  99, 240,  99, 240,
    99, 240,  83, 240,  99, 240,  99, 240,  99, 240,  99, 213,
    35, 200,  19, 189, 165,  69, 148, 115, 163, 131, 147, 147,
    147, 147, 131, 163, 131, 147, 147, 147, 147, 147, 147, 147,
    148, 116, 149,  69, 189, 199,  35, 212,  67,   0,  34,  32,
    35,  20,   0,  36,   5, 217, 155, 132,  84,  99, 131,  98,
    147,  95,  95,  79,   1,  67, 240,  35, 240,  35, 240,  35,
    240,  36, 145, 116,  99, 125, 139, 182,   0,  28,  96,  58,
    20,   0,   8, 102, 215, 185, 164, 240,  19, 240,  19, 240,
    35, 240,  35, 240,  20, 240,  19, 240,  35, 219, 155, 195,
    240,  35, 240,  35, 240,  35, 240,  20, 240,  19, 240,  35,
    240,  35, 240,  35, 240,  19, 240,  35, 240,  35, 240,  35,
    240,  35, 240,  19, 240,  35,   0,  29,  80,  54,  26,   0,
    46, 101,  52, 206, 179,  68, 227,  99, 227,  99, 211, 115,
    211, 115, 211,  99, 227,  99, 228,  67, 250, 250, 240,  18,
    37, 240,  19, 240, 131, 240, 140, 253, 191,   1, 148, 148,
    147, 179, 131, 195, 131, 195, 132, 163, 164, 116, 205, 248,
    0,  11,  64,  65,  20,   0,   8,  35, 240,  19, 240,  35,
    240,  35, 240,  35, 240,  35, 240,  19, 240,  35, 240,  35,
    240,  35, 240,  35, 240,  19,  68, 147,  39, 131,  25, 117,
    68, 101,  99, 100, 115, 100, 115,  99, 131,  99, 115, 100,
    115,  99, 131,  99, 131,  99, 131,  99, 115, 100, 115,  99,
    131,  99, 131,  99, 116,   0,  28,  32,  31,  13,   0,   8,
    100, 148, 148, 147,   0,   9,  35, 148, 147, 163, 163, 163,
    147, 163, 163, 163, 163, 147, 163, 163, 163, 163, 147, 163,
    0,  19,  16,  64,  21,   0,  14, 100, 240,  36, 240,  36,
    240,  35,   0,  15,  35, 240,  51, 240,  35, 240,  51, 240,
    51, 240,  51, 240,  36, 240,  35, 240,  51, 240,  51, 240,
    51, 240,  35, 240,  51, 240,  51, 240,  51, 240,  36, 240,
    35, 240,  51, 240,  51, 240,  51, 240,  36, 240,  35, 193,
    68, 185, 200, 245,   0,   9,  80,  64,  22,   0,   9,   3,
    240,  67, 240,  67, 240,  51, 240,  67, 240,  67, 240,  67,
    240,  67, 240,  51, 240,  67, 240,  67, 240,  67, 116, 131,
    84, 147,  84, 163,  68, 179,  52, 195,  36, 196,  20, 211,
    20, 233, 213,  19, 212,  36, 180,  67, 179,  84, 163,  99,
    163, 100, 147, 115, 131, 132, 115, 132,   0,  31,  16,  36,
    13, 240, 240, 243, 163, 147, 163, 163, 163, 163, 147, 163,
    163, 163, 163, 147, 163, 163, 163, 163, 147, 163, 163, 163,
    163, 147, 163, 163, 163, 163, 147, 163,   0,  19,  16,  61,
    31,   0,  54,  99,  53,  85, 147,  40,  55, 131,  25,  41,
    117,  71,  68, 116, 101,  99, 115, 116, 115, 100, 116, 115,
    99, 131, 131,  99, 131, 115, 115, 131, 115, 100, 115, 131,
    99, 131, 131,  99, 131, 131,  99, 131, 115, 115, 116, 115,
    100, 115, 131,  99, 131, 131,  99, 131, 116,   0,  43,  48,
    43,  20,   0,  35,  51,  68, 147,  39, 131,  25, 117,  68,
    116,  99, 100, 115, 100, 115,  99, 131,  99, 115, 100, 115,
    99, 131,  99, 131,  99, 131,  99, 115, 100, 115,  99, 131,
    99, 131,  99, 116,   0,  28,  32,  37,  21,   0,  37, 101,
    233, 172, 132,  84, 116, 116,  99, 147,  83, 163,  83, 163,
    67, 179,  67, 179,  67, 163,  83, 163,  83, 147, 100, 116,
    116,  84, 140, 169, 229,   0,  30,  48,  56,  23,   0,  40,
    115,  69, 179,  40, 173, 165,  69, 132, 116, 131, 147, 131,
    147, 131, 147, 131, 147, 116, 147, 115, 147, 131, 147, 131,
    131, 147, 116, 133,  69, 157, 163,  24, 179,  52, 211, 240,
    67, 240,  83, 240,  83, 240,  83, 240,  68, 240,  67, 240,
    83,   0,  11,  16,  56,  21,   0,  37,  84,  51, 152,  19,
    141, 117,  69, 100, 116,  99, 131,  99, 147,  99, 147,  83,
    163,  83, 147,  99, 147,  99, 147,  99, 147, 100, 116, 116,
    69, 141, 151,  35, 164,  52, 240,  36, 240,  35, 240,  51,
    240,  51, 240,  36, 240,  35, 240,  51, 240,  51,   0,   9,
    28,  17,   0,  30,  35,  51, 130,  37, 115,  22, 118, 181,
    196, 211, 212, 211, 227, 227, 211, 227, 227, 227, 227, 211,
    227,   0,  25,  16,  33,  19,   0,  34,   7, 171, 123, 131,
    98, 115, 240,  19, 240,  19, 240,  22, 232, 200, 245, 240,
    19, 240,  19,  97, 147,  99,  99, 124, 122, 183,   0,  27,
    48,  31,  16,   0,  18,  83, 211, 195, 211, 211, 171,  76,
    115, 211, 211, 211, 195, 211, 211, 211, 210, 211, 211, 211,
    211,  65, 136, 136, 148,   0,  23,  32,  43,  20,   0,  35,
    51, 115, 114, 131,  99, 131,  99, 131,  99, 116,  99, 115,
    114, 131,  99, 131,  99, 131,  99, 115, 115, 115, 114, 131,
    99, 131,  99, 116,  99, 100, 115,  85, 121,  19, 134,  51,
    0,  28,  48,  42,  21,   0,  36, 100, 163,  68, 147,  99,
    132,  99, 131, 115, 115, 131, 115, 132,  83, 148,  83, 163,
    67, 179,  52, 179,  51, 195,  35, 211,  35, 211,  19, 227,
    19, 245, 240,  21, 240,  20,   0,  30,  80,  69,  29,   0,
    50, 100, 115, 131,  68, 115, 131,  68, 101,  99,  99, 101,
    99,  99,  82,  19,  83, 115,  82,  19,  83, 115,  67,  19,
    67, 131,  66,  35,  67, 131,  51,  35,  51, 147,  50,  51,
    51, 147,  35,  51,  35, 163,  34,  67,  35, 163,  19,  67,
    19, 179,  18,  83,  19, 194,  18,  98,  18, 212, 117, 212,
    116, 227, 132,   0,  41,  48,  44,  24,   0,  42,  68, 147,
    147, 131, 164,  99, 196,  67, 227,  51, 244,  19, 240,  38,
    240,  68, 240,  83, 240,  85, 240,  54, 240,  35,  35, 244,
    35, 228,  67, 211,  84, 179, 115, 163, 132, 116, 163,   0,
    33, 112,  62,  25,   0,  44,  36, 148, 147, 147, 163, 131,
    179, 131, 180,  99, 196,  99, 211,  83, 227,  68, 227,  67,
    243,  51, 240,  20,  35, 240,  35,  19, 240,  51,  19, 240,
    54, 240,  69, 240,  85, 240,  99, 240, 115, 240,  99, 240,
    115, 240,  99, 240,  99, 240, 100, 240,  39, 240,  54, 240,
    69,   0,  11, 112,  38,  22,   0,  39,  14, 142, 141, 240,
    51, 240,  51, 240,  51, 240,  51, 240,  51, 240,  51, 240,
    51, 240,  51, 240,  51, 240,  51, 240,  51, 240,  51, 240,
    62, 127, 127,   0,  31,  16,  13,  24,   0,  57,  15,   5,
    79,   5,  79,   5,   0,  63,  64,  16,  43,   0, 102,  31,
    15,   9,  79,  15,   9,  79,  15,   9,   0, 113,  48,  21,
    18,   0,   7,  35,  52, 115,  67, 131,  51, 131,  67, 115,
    67, 131,  66, 131,  67,   0,  75,  32,  16,  18,   0,  11,
    83,  83, 102,  50, 108,  98,  54,  99,  83,   0,  75,  16,
};

//*****************************************************************************
//
// The font definition for the 42 point Cmss italic font.
//
//*****************************************************************************
const Graphics_Font g_sFontCmss42i =
{
    //
    // The format of the font.
    //
    FONT_FMT_PIXEL_RLE,

    //
    // The maximum width of the font.
    //
    38,

    //
    // The height of the font.
    //
    43,

    //
    // The baseline of the font.
    //
    32,

    //
    // The offset to each character in the font.
    //
    {
        0,    5,   39,   64,  177,  250,  349,  428,
        443,  495,  572,  611,  672,  687,  697,  707,
        795,  850,  885,  943,  998, 1058, 1112, 1166,
        1227, 1279, 1335, 1350, 1370, 1404, 1417, 1453,
        1489, 1564, 1639, 1698, 1759, 1823, 1888, 1950,
        2011, 2076, 2112, 2173, 2249, 2313, 2419, 2504,
        2578, 2637, 2726, 2786, 2844, 2907, 2972, 3045,
        3159, 3236, 3307, 3372, 3447, 3472, 3548, 3567,
        3578, 3593, 3630, 3693, 3730, 3792, 3827, 3885,
        3939, 4004, 4035, 4099, 4163, 4199, 4260, 4303,
        4340, 4396, 4452, 4480, 4513, 4544, 4587, 4629,
        4698, 4742, 4804, 4842, 4855, 4871, 4892,
    },

    //
    // A pointer to the actual font data
    //
    g_pucCmss42iData
};
