/*
 * Decompiled with CFR 0.152.
 */
package com.ti.msp430.imagereformer;

import com.ti.msp430.imagereformer.ImageDisplay;
import com.ti.msp430.imagereformer.Output;
import java.awt.AlphaComposite;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.IndexColorModel;
import java.awt.image.RescaleOp;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ImageConverter
extends Panel
implements ActionListener,
FocusListener {
    String imageName;
    static JFrame jf;
    static File lastDir;
    BufferedImage image;
    static final String original = "Original";
    static final String modified = "Modified";
    MyPanel imagePanel;
    private static final long serialVersionUID = 1232211803609446210L;
    ImageDisplay originalPanel = new ImageDisplay();
    ImageDisplay modifiedPanel = new ImageDisplay();

    public ImageConverter() {
        SplashScreen splash = SplashScreen.getSplashScreen();
        if (splash == null) {
            System.out.println("SplashScreen.getSplashScreen() returned null");
            return;
        }
        Graphics2D g = splash.createGraphics();
        if (g == null) {
            System.out.println("g is null");
            return;
        }
        for (int i = 0; i < 10; ++i) {
            this.renderSplashFrame(g, i);
            splash.update();
            try {
                Thread.sleep(90L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        splash.close();
    }

    public static BufferedImage convert2(BufferedImage src) {
        IndexColorModel icm = new IndexColorModel(1, 2, new byte[]{0, -1}, new byte[]{0, -1}, new byte[]{0, -1});
        BufferedImage dest = ImageConverter.convert2(src, icm);
        return dest;
    }

    public static BufferedImage convert2(BufferedImage src, IndexColorModel icm) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 12, icm);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    public static BufferedImage convert4(BufferedImage src) {
        int[] cmap = new int[]{0, 0xFFFF55, 0xAA00AA, 1048575};
        IndexColorModel icm = new IndexColorModel(2, 4, cmap, 0, false, 1, 0);
        BufferedImage dest = ImageConverter.convert4(src, icm);
        return dest;
    }

    public static BufferedImage convert4(BufferedImage src, IndexColorModel icm) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 12, icm);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    public static BufferedImage convert16(BufferedImage src) {
        int[] cmap = new int[]{0, 0xFF0000, 65280, 255, 0xFFFFFF, 0xFFFF00, 0xFF00FF, 0xFF0080, 16744512, 0x804000, 32896, 0x800080, 0x800000, 0x800080, 0x8080FF};
        IndexColorModel icm = new IndexColorModel(4, cmap.length, cmap, 0, false, 1, 0);
        BufferedImage dest = ImageConverter.convert16(src, icm);
        return dest;
    }

    public static BufferedImage convert16(BufferedImage src, IndexColorModel icm) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 13, icm);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    public static BufferedImage convert256(BufferedImage src) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 13);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    public static BufferedImage convert256(BufferedImage src, IndexColorModel icm) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 13, icm);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    public void renderSplashFrame(Graphics2D g, int frame) {
        String[] displayItems = new String[]{"JVM", "Color Palette", "Button Images"};
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(120, 140, 200, 40);
        g.setPaintMode();
        g.setColor(Color.WHITE);
        g.drawString("Loading " + displayItems[frame / 5 % 3] + "...", 120, 150);
    }

    public void createMenuBar(final JFrame jf) {
        ImageConverter.jf = jf;
        System.out.println(System.getProperty("user.dir"));
        jf.setIconImage(new ImageIcon(this.loadURLImage("images/images.gif")).getImage());
        JMenuBar mb = new JMenuBar();
        ImageIcon openImage = new ImageIcon(this.loadURLImage("images/open.gif"));
        ImageIcon buildImage = new ImageIcon(this.loadURLImage("images/gear_icon.gif"));
        JButton open = new JButton(openImage);
        JButton generate = new JButton(buildImage);
        JToolBar toolBar = new JToolBar("Conversion");
        toolBar.add(open);
        open.addActionListener(new OpenActionListener());
        toolBar.add(generate);
        generate.addActionListener(new OutputActionListner());
        jf.setJMenuBar(mb);
        JMenu fileMenu = new JMenu("File");
        mb.add(fileMenu);
        JMenuItem openAction = new JMenuItem("Open", 79);
        KeyStroke ctrlXKeyStroke = KeyStroke.getKeyStroke("control O");
        openAction.setAccelerator(ctrlXKeyStroke);
        openAction.addActionListener(new OpenActionListener());
        JMenuItem generateAction = new JMenuItem("Generate", 71);
        ctrlXKeyStroke = KeyStroke.getKeyStroke("control G");
        generateAction.setAccelerator(ctrlXKeyStroke);
        generateAction.addActionListener(new OutputActionListner());
        JMenuItem exitAction = new JMenuItem("Exit", 88);
        ctrlXKeyStroke = KeyStroke.getKeyStroke("control G");
        exitAction.setAccelerator(ctrlXKeyStroke);
        exitAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        fileMenu.add(openAction);
        fileMenu.add(generateAction);
        fileMenu.addSeparator();
        fileMenu.add(exitAction);
        JMenu helpMenu = new JMenu("Help");
        mb.add(helpMenu);
        JMenuItem aboutAction = new JMenuItem("About", 65);
        ctrlXKeyStroke = KeyStroke.getKeyStroke("control A");
        aboutAction.setAccelerator(ctrlXKeyStroke);
        aboutAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageIcon aboutImage = new ImageIcon(ImageConverter.this.loadURLImage("images/about_430.gif"));
                JOptionPane.showMessageDialog(jf, "Image Reformer v1.10\nMSP430 Software Applications", "Image Reformer", -1, aboutImage);
            }
        });
        JMenuItem helpAction = new JMenuItem("Help", 112);
        ctrlXKeyStroke = KeyStroke.getKeyStroke("F1");
        helpAction.setAccelerator(ctrlXKeyStroke);
        helpAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JEditorPane infodex = new JEditorPane();
                JDialog helpDialog = new JDialog();
                helpDialog.setModal(true);
                URL url = null;
                try {
                    url = new URL("jar:file:ImageReformer.jar!/images/help.html");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                System.out.println("URL: " + url);
                try {
                    infodex.setPage(url);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                helpDialog.getContentPane().add(new JScrollPane(infodex));
                helpDialog.setBounds(400, 200, 900, 600);
                helpDialog.show();
                infodex.setEditable(false);
            }
        });
        helpMenu.add(aboutAction);
        helpMenu.add(helpAction);
        jf.getContentPane().add((Component)toolBar, "North");
    }

    public BufferedImage getDestination() {
        return this.modifiedPanel.getThisImage();
    }

    public void setDestination(BufferedImage destination) {
        this.modifiedPanel.setThisImage(destination);
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void createDisplay(BufferedImage destinationImage, int numPix) {
        BufferedImage destination = null;
        int xsize = 0;
        int ysize = 0;
        int numPixels = 0;
        if (this.imagePanel != null) {
            destination = this.modifiedPanel.getThisImage();
            xsize = this.modifiedPanel.getXsize();
            ysize = this.modifiedPanel.getYsize();
            numPixels = destination.getColorModel().getPixelSize();
            this.remove(this.imagePanel);
        }
        this.imagePanel = new MyPanel();
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
        System.out.println(topFrame.getSize());
        this.imagePanel.setLayout(new FlowLayout());
        BufferedImage bi = ImageConverter.toBufferedImage(this.image);
        this.originalPanel = new ImageDisplay(bi, original);
        this.originalPanel.allowChange(false);
        this.imagePanel.add(this.originalPanel);
        Panel buttons = this.createButtons();
        this.imagePanel.add(buttons);
        if (destinationImage == null) {
            this.modifiedPanel = new ImageDisplay(ImageConverter.toBufferedImage(this.image), modified);
        } else {
            this.modifiedPanel = new ImageDisplay(destinationImage, modified);
            if (this.modifiedPanel.getAdaptivePallet().isSelected()) {
                byte ff = -1;
                byte[] r = new byte[]{0, ff};
                byte[] g = new byte[]{0, ff};
                byte[] b = new byte[]{0, ff};
                IndexColorModel cm = new IndexColorModel(1, 2, r, g, b);
                this.modifiedPanel.setThisImage(ImageConverter.convert2(bi, cm));
            } else {
                this.modifiedPanel.setThisImage(ImageConverter.convert2(bi));
            }
            Graphics2D gr = this.modifiedPanel.getThisImage().createGraphics();
            RenderingHints hints = new RenderingHints(null);
            RescaleOp op = new RescaleOp(1.0f, 0.0f, hints);
            gr.drawImage(bi, op, 0, 0);
            this.modifiedPanel = new ImageDisplay(destinationImage, modified);
        }
        this.modifiedPanel.addActionListener(this);
        this.modifiedPanel.addFocusListener(this);
        this.imagePanel.add(this.modifiedPanel);
        this.add((Component)this.imagePanel, "Center");
        jf.pack();
        jf.setVisible(true);
    }

    protected Panel createButtons() {
        Panel buttons = new Panel();
        JButton bpp1 = new JButton(">>> 2 Color >>>");
        JButton bpp2 = new JButton(">>> 4 Color >>>");
        JButton bpp4 = new JButton(">>> 16 Color >>>");
        JButton bpp8 = new JButton(">>> 256 Color >>>");
        JButton grayScale = new JButton("Gray Scale >>>");
        Button write = new Button("create");
        JButton reset = new JButton("Reset");
        bpp1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConverter.this.bpp1();
            }
        });
        bpp2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConverter.this.bpp2();
            }
        });
        bpp4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConverter.this.bpp4();
            }
        });
        bpp8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConverter.this.bpp8();
            }
        });
        grayScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageConverter.this.grayScale();
            }
        });
        write.addActionListener(new OutputActionListner());
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("reset called");
                ImageConverter.this.reset();
            }
        });
        buttons.setLayout(new GridLayout(5, 1));
        buttons.add(bpp1);
        buttons.add(bpp2);
        buttons.add(bpp4);
        buttons.add(bpp8);
        buttons.add(reset);
        return buttons;
    }

    public void loadImage(String name) {
        this.imageName = name;
        try {
            this.image = ImageIO.read(new File(name));
        }
        catch (IOException e) {
            System.out.println("Unable to load image " + e.toString());
        }
        BufferedImage bi = ImageConverter.toBufferedImage(this.image);
        if (bi.getColorModel() instanceof IndexColorModel) {
            int height = bi.getHeight();
            int width = bi.getWidth();
            BufferedImage newBi = new BufferedImage(width, height, 1);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int rgb = bi.getRGB(x, y);
                    newBi.setRGB(x, y, rgb);
                }
            }
            this.image = newBi;
        }
        System.out.println(this.image);
        this.createDisplay(null, -1);
    }

    public void reset() {
        this.createDisplay(null, -1);
    }

    public void grayScale() {
    }

    public int ImagePreamble() {
        int comp = -1;
        if (this.imagePanel != null) {
            if (this.modifiedPanel != null) {
                comp = this.modifiedPanel.getCompression();
            }
            this.remove(this.imagePanel);
        }
        return comp;
    }

    public void imagePost(int comp) {
    }

    public static BufferedImage resize1(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public void bpp1() {
        BufferedImage destination = this.modifiedPanel.getThisImage();
        int xsize = this.modifiedPanel.getXsize();
        int ysize = this.modifiedPanel.getYsize();
        boolean adaptive = this.modifiedPanel.getAdaptivePallet().isSelected();
        int comp = -1;
        if (this.imagePanel != null && this.modifiedPanel != null) {
            comp = this.modifiedPanel.getCompression();
        }
        this.imagePanel.removeAll();
        BufferedImage bi = ImageConverter.toBufferedImage(this.image);
        this.originalPanel = new ImageDisplay(bi, original);
        this.originalPanel.allowChange(false);
        this.imagePanel.add(this.originalPanel);
        Panel buttons = this.createButtons();
        this.imagePanel.add(buttons);
        if (bi != null) {
            if (adaptive) {
                byte ff = -1;
                byte[] r = new byte[]{0, ff};
                byte[] g = new byte[]{0, ff};
                byte[] b = new byte[]{0, ff};
                IndexColorModel cm = new IndexColorModel(1, 2, r, g, b);
                destination = ImageConverter.convert2(bi, cm);
            } else {
                destination = ImageConverter.convert2(bi);
            }
            destination = ImageConverter.resize(destination, xsize, ysize);
            this.modifiedPanel = new ImageDisplay(destination, modified);
            Graphics2D gr = destination.createGraphics();
            RenderingHints hints = new RenderingHints(null);
            RescaleOp op = new RescaleOp(1.0f, 0.0f, hints);
            gr.drawImage(bi, op, 0, 0);
        }
        this.modifiedPanel = new ImageDisplay(destination, modified);
        this.modifiedPanel.addActionListener(this);
        this.modifiedPanel.addFocusListener(this);
        this.modifiedPanel.adaptivePallet.setSelected(adaptive);
        this.modifiedPanel.setCompression(comp);
        this.imagePanel.add(this.modifiedPanel);
        this.add((Component)this.imagePanel, "Center");
        jf.pack();
        jf.setVisible(true);
    }

    public void bpp2() {
        BufferedImage destination = this.modifiedPanel.getThisImage();
        int xsize = this.modifiedPanel.getXsize();
        int ysize = this.modifiedPanel.getYsize();
        boolean adaptive = this.modifiedPanel.getAdaptivePallet().isSelected();
        int comp = -1;
        if (this.imagePanel != null && this.modifiedPanel != null) {
            comp = this.modifiedPanel.getCompression();
        }
        this.imagePanel.removeAll();
        BufferedImage bi = ImageConverter.toBufferedImage(this.image);
        this.originalPanel = new ImageDisplay(bi, original);
        this.originalPanel.allowChange(false);
        this.imagePanel.add(this.originalPanel);
        Panel buttons = this.createButtons();
        this.imagePanel.add(buttons);
        if (bi != null) {
            if (adaptive) {
                AdaptiveColorPalette mp = new AdaptiveColorPalette(this.image, 4);
                byte[] r = mp.getReds();
                byte[] g = mp.getGreens();
                byte[] b = mp.getBlues();
                IndexColorModel cm = new IndexColorModel(2, 4, r, g, b);
                destination = ImageConverter.convert4(bi, cm);
            } else {
                destination = ImageConverter.convert4(bi);
            }
            Graphics2D gr = destination.createGraphics();
            RenderingHints hints = new RenderingHints(null);
            RescaleOp op = new RescaleOp(1.0f, 0.0f, hints);
            gr.drawImage(bi, op, 0, 0);
        }
        this.modifiedPanel = new ImageDisplay(destination, modified);
        this.modifiedPanel.addActionListener(this);
        this.modifiedPanel.addFocusListener(this);
        this.modifiedPanel.adaptivePallet.setSelected(adaptive);
        this.modifiedPanel.setCompression(comp);
        this.imagePanel.add(this.modifiedPanel);
        this.add((Component)this.imagePanel, "Center");
        jf.pack();
        jf.setVisible(true);
    }

    public void bpp4() {
        BufferedImage destination = this.modifiedPanel.getThisImage();
        int xsize = this.modifiedPanel.getXsize();
        int ysize = this.modifiedPanel.getYsize();
        boolean adaptive = this.modifiedPanel.getAdaptivePallet().isSelected();
        int comp = -1;
        if (this.imagePanel != null && this.modifiedPanel != null) {
            comp = this.modifiedPanel.getCompression();
        }
        this.imagePanel.removeAll();
        BufferedImage bi = ImageConverter.toBufferedImage(this.image);
        this.originalPanel = new ImageDisplay(bi, original);
        this.originalPanel.allowChange(false);
        this.imagePanel.add(this.originalPanel);
        Panel buttons = this.createButtons();
        this.imagePanel.add(buttons);
        if (bi != null) {
            if (adaptive) {
                AdaptiveColorPalette mp = new AdaptiveColorPalette(this.image, 16);
                byte[] r = mp.getReds();
                byte[] g = mp.getGreens();
                byte[] b = mp.getBlues();
                IndexColorModel cm = new IndexColorModel(4, 16, r, g, b);
                System.out.println("Num color comp " + cm.getNumColorComponents());
                destination = ImageConverter.convert16(bi, cm);
            } else {
                destination = ImageConverter.convert16(bi);
            }
        }
        this.modifiedPanel = new ImageDisplay(destination, modified);
        this.modifiedPanel.addActionListener(this);
        this.modifiedPanel.addFocusListener(this);
        this.modifiedPanel.adaptivePallet.setSelected(adaptive);
        this.modifiedPanel.setCompression(comp);
        this.imagePanel.add(this.modifiedPanel);
        this.add((Component)this.imagePanel, "Center");
        jf.pack();
        jf.setVisible(true);
    }

    public void bpp8() {
        BufferedImage destination = this.modifiedPanel.getThisImage();
        int xsize = this.modifiedPanel.getXsize();
        int ysize = this.modifiedPanel.getYsize();
        boolean adaptive = this.modifiedPanel.getAdaptivePallet().isSelected();
        int comp = -1;
        if (this.imagePanel != null && this.modifiedPanel != null) {
            comp = this.modifiedPanel.getCompression();
        }
        this.imagePanel.removeAll();
        BufferedImage bi = ImageConverter.toBufferedImage(this.image);
        this.originalPanel = new ImageDisplay(bi, original);
        this.originalPanel.allowChange(false);
        this.imagePanel.add(this.originalPanel);
        Panel buttons = this.createButtons();
        this.imagePanel.add(buttons);
        if (bi != null) {
            if (adaptive) {
                AdaptiveColorPalette mp = new AdaptiveColorPalette(this.image, 256);
                byte[] r = mp.getReds();
                byte[] g = mp.getGreens();
                byte[] b = mp.getBlues();
                IndexColorModel cm = new IndexColorModel(8, 256, r, g, b);
                System.out.println("Num color comp " + cm.getNumColorComponents());
                destination = ImageConverter.convert256(bi, cm);
            } else {
                destination = ImageConverter.convert256(bi);
            }
            bi = ImageConverter.resize(bi, xsize, ysize);
            Graphics2D gr = destination.createGraphics();
            RenderingHints hints = new RenderingHints(null);
            RescaleOp op = new RescaleOp(1.0f, 0.0f, hints);
            gr.drawImage(bi, op, 0, 0);
            this.imagePost(comp);
        }
        this.modifiedPanel = new ImageDisplay(destination, modified);
        this.modifiedPanel.addActionListener(this);
        this.modifiedPanel.addFocusListener(this);
        this.modifiedPanel.adaptivePallet.setSelected(adaptive);
        this.modifiedPanel.setCompression(comp);
        this.imagePanel.add(this.modifiedPanel);
        this.add((Component)this.imagePanel, "Center");
        jf.pack();
        jf.setVisible(true);
    }

    public void justResize() {
        byte[] g;
        byte[] r;
        AdaptiveColorPalette mp;
        BufferedImage destination = this.modifiedPanel.getThisImage();
        int xsize = this.modifiedPanel.getXsize();
        int ysize = this.modifiedPanel.getYsize();
        boolean adaptive = this.modifiedPanel.getAdaptivePallet().isSelected();
        int numPixels = destination.getColorModel().getPixelSize();
        int type = destination.getType();
        destination = null;
        int comp = this.modifiedPanel.getCompression();
        this.imagePanel.removeAll();
        BufferedImage bi = ImageConverter.toBufferedImage(this.image);
        this.originalPanel = new ImageDisplay(bi, original);
        this.originalPanel.allowChange(false);
        this.imagePanel.add(this.originalPanel);
        Panel buttons = this.createButtons();
        this.imagePanel.add(buttons);
        System.out.println("justResize xsize:" + xsize + " ysize:" + ysize + " numPixels=:" + numPixels + " type:" + type + " bi.type:" + bi.getType());
        destination = new BufferedImage(xsize, ysize, type);
        if (numPixels == 2) {
            if (!adaptive) {
                destination = ImageConverter.convert4(destination);
            } else {
                mp = new AdaptiveColorPalette(this.image, 4);
                r = mp.getReds();
                g = mp.getGreens();
                byte[] b = mp.getBlues();
                IndexColorModel cm = new IndexColorModel(2, 4, r, g, b);
                destination = ImageConverter.convert4(destination, cm);
            }
        } else if (numPixels == 4) {
            if (!adaptive) {
                destination = ImageConverter.convert16(destination);
            } else {
                mp = new AdaptiveColorPalette(this.image, 16);
                r = mp.getReds();
                g = mp.getGreens();
                byte[] b = mp.getBlues();
                IndexColorModel cm = new IndexColorModel(4, 16, r, g, b);
                System.out.println("Num color comp " + cm.getNumColorComponents());
                destination = ImageConverter.convert16(destination, cm);
            }
        } else if (numPixels == 8) {
            if (!adaptive) {
                destination = ImageConverter.convert256(destination);
            } else {
                mp = new AdaptiveColorPalette(this.image, 256);
                r = mp.getReds();
                g = mp.getGreens();
                byte[] b = mp.getBlues();
                IndexColorModel cm = new IndexColorModel(8, 256, r, g, b);
                System.out.println("Num color comp " + cm.getNumColorComponents());
                destination = ImageConverter.convert256(destination, cm);
            }
        }
        bi = ImageConverter.resize(bi, xsize, ysize);
        Graphics2D g2 = destination.createGraphics();
        RenderingHints hints = new RenderingHints(null);
        RescaleOp op = new RescaleOp(1.0f, 0.0f, hints);
        g2.drawImage(bi, op, 0, 0);
        this.modifiedPanel = new ImageDisplay(destination, modified);
        this.modifiedPanel.addActionListener(this);
        this.modifiedPanel.addFocusListener(this);
        this.modifiedPanel.setXsize(xsize);
        this.modifiedPanel.setYsize(ysize);
        this.modifiedPanel.adaptivePallet.setSelected(adaptive);
        this.modifiedPanel.setCompression(comp);
        this.imagePanel.add(this.modifiedPanel);
        this.add((Component)this.imagePanel, "Center");
        jf.pack();
        jf.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        System.out.println("action even " + arg0);
        BufferedImage destination = this.modifiedPanel.getThisImage();
        if (destination != null) {
            int numPix = destination.getColorModel().getPixelSize();
            System.out.println("actionPerformed numPix:" + numPix);
            this.justResize();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.justResize();
    }

    private static BufferedImage resize(BufferedImage image, int width, int height) {
        int type = image.getType();
        BufferedImage resizedImage = new BufferedImage(width, height, type);
        Graphics2D g = resizedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            System.out.println(e.toString());
        }
        if (bimage == null) {
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public Image loadURLImage(String path) {
        BufferedImage img = null;
        try {
            InputStream url = this.getClass().getClassLoader().getResourceAsStream(path);
            System.out.println("URL:" + url + " path: " + path);
            img = ImageIO.read(url);
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            ex.printStackTrace();
            try {
                img = ImageIO.read(new File(path));
            }
            catch (Exception e) {
                System.out.println("Unable to load image " + e.toString());
            }
        }
        System.out.println(img);
        return img;
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.setName("GRLib GUI");
        System.out.println(System.getProperty("java.vendor"));
        System.out.println(System.getProperty("java.vendor.url"));
        System.out.println(System.getProperty("java.version"));
        ImageConverter iv = new ImageConverter();
        iv.createMenuBar(jf);
        jf.getContentPane().add(iv);
        jf.setSize(1300, 800);
        jf.setVisible(true);
        jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    static {
        lastDir = null;
    }

    class OpenActionListener
    implements ActionListener {
        OpenActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            if (lastDir == null) {
                fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
            } else {
                fileChooser.setCurrentDirectory(lastDir);
            }
            fileChooser.setFileFilter(new ImageFilter());
            int result = fileChooser.showOpenDialog(ImageConverter.this);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                lastDir = selectedFile.getParentFile();
                System.out.println("Selected file: " + selectedFile.getAbsolutePath());
                ImageConverter.this.loadImage(selectedFile.getAbsolutePath());
            }
        }
    }

    class OutputActionListner
    implements ActionListener {
        OutputActionListner() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageConverter.this.imageName == null) {
                JOptionPane.showMessageDialog(jf, "No image in buffer.");
                return;
            }
            String fileName = ImageConverter.this.imageName + ".c";
            JFileChooser fc = new JFileChooser(lastDir);
            fc.addChoosableFileFilter(new OutputFilter());
            fc.setSelectedFile(new File(fileName));
            int returnVal = fc.showSaveDialog(new JFrame());
            if (returnVal == 0) {
                Output o = new Output(ImageConverter.this.modifiedPanel.getThisImage(), ImageConverter.this.imageName, ImageConverter.this.modifiedPanel.getCompression(), jf);
                o.write(fileName);
            } else {
                System.out.println("canceled");
            }
        }
    }

    class ImageFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".jpg") || file.getName().endsWith(".bmp") || file.getName().endsWith(".gif") || file.getName().endsWith(".jpeg") || file.getName().endsWith(".png") || file.getName().endsWith(".tif") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.jpg, *.bmp, *.gif, *.jpeg, *.png, *.tif";
        }
    }

    class OutputFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".c");
        }

        @Override
        public String getDescription() {
            return "*.c";
        }
    }

    class AdaptiveColorPalette {
        byte[] r;
        byte[] g;
        byte[] b;
        Image bi;
        int size;
        FuzzyHashtable colors;

        public AdaptiveColorPalette(Image i, int paletteSize) {
            this.bi = i;
            this.size = paletteSize;
            this.colors = new FuzzyHashtable(this.size);
            this.createPalette();
        }

        private void createPalette() {
            byte ff = -1;
            BufferedImage myImage = ImageConverter.toBufferedImage(this.bi);
            BufferedImage destination = new BufferedImage(myImage.getWidth(), myImage.getHeight(), 13);
            if (myImage.getColorModel() instanceof IndexColorModel) {
                destination = myImage;
            } else {
                Graphics2D gr = destination.createGraphics();
                RenderingHints hints = new RenderingHints(null);
                RescaleOp op = new RescaleOp(1.0f, 0.0f, hints);
                gr.drawImage(myImage, op, 0, 0);
            }
            IndexColorModel cm = (IndexColorModel)destination.getColorModel();
            int initialSize = cm.getMapSize();
            byte[] rr = new byte[initialSize];
            byte[] bb = new byte[initialSize];
            byte[] gg = new byte[initialSize];
            cm.getReds(rr);
            cm.getBlues(bb);
            cm.getGreens(gg);
            this.r = new byte[this.size];
            this.g = new byte[this.size];
            this.b = new byte[this.size];
            Date dte = new Date();
            int yoffset = 1;
            int xoffset = 1;
            int width = myImage.getWidth();
            int height = myImage.getHeight();
            yoffset = height < 300 ? 4 : (height < 1000 ? 6 : (height < 1500 ? 8 : 10));
            xoffset = width < 400 ? 1 : (width < 1500 ? 2 : (width < 2000 ? 4 : 8));
            System.out.println("Before loop " + dte.getTime());
            for (int y = 0; y < height; y += yoffset) {
                for (int x = 0; x < width; x += xoffset) {
                    Color c = new Color(myImage.getRGB(x, y));
                    Integer I = (Integer)this.colors.get(c);
                    if (I == null) {
                        this.colors.put(c, new Integer(1));
                        continue;
                    }
                    int i = I;
                    this.colors.put(c, ++i);
                }
            }
            Date dte1 = new Date();
            System.out.println("Before loop " + dte1.getTime());
            System.out.println(dte1.getTime() - dte.getTime());
            Hashtable ht = new Hashtable();
            Enumeration e = this.colors.keys();
            while (e.hasMoreElements()) {
                Object k = e.nextElement();
                Object v = this.colors.get(k);
                ht.put(v, k);
            }
            Vector v = new Vector(ht.keySet());
            Collections.reverse(v);
            Iterator it = v.iterator();
            Vector vv = new Vector();
            while (it.hasNext()) {
                Object element = it.next();
                vv.addElement(ht.get(element));
            }
            for (int j = 0; j < this.size; ++j) {
                if (vv.size() <= j) continue;
                Color c = (Color)vv.elementAt(j);
                this.r[j] = (byte)c.getRed();
                this.b[j] = (byte)c.getBlue();
                this.g[j] = (byte)c.getGreen();
            }
            boolean blackFound = false;
            boolean whiteFound = false;
            for (int i = 0; i < this.size; ++i) {
                if (this.r[i] == ff && this.g[i] == ff && this.b[i] == ff) {
                    whiteFound = true;
                }
                if (this.r[i] != 0 || this.g[i] != 0 || this.b[i] != 0) continue;
                blackFound = true;
            }
            if (!whiteFound) {
                byte by = ff;
                this.b[this.size - 1] = by;
                this.g[this.size - 1] = by;
                this.r[this.size - 1] = by;
            }
            if (!blackFound) {
                this.b[0] = 0;
                this.g[0] = 0;
                this.r[0] = 0;
            }
        }

        public byte[] getReds() {
            return this.r;
        }

        public byte[] getGreens() {
            return this.g;
        }

        public byte[] getBlues() {
            return this.b;
        }

        class FuzzyHashtable
        extends Hashtable {
            int range = 10;
            private static final long serialVersionUID = -7991404974611369290L;

            public FuzzyHashtable(int colors) {
            }

            public boolean inRange(int val, int target) {
                int max = target + this.range;
                int min = target - this.range;
                return val >= min && val <= max;
            }

            @Override
            public Object get(Object key) {
                Object val = super.get(key);
                if (val == null) {
                    Color keyC = (Color)key;
                    int kRed = keyC.getRed();
                    int kGreen = keyC.getGreen();
                    int kBlue = keyC.getBlue();
                    Enumeration e = AdaptiveColorPalette.this.colors.keys();
                    while (e.hasMoreElements()) {
                        Color c = (Color)e.nextElement();
                        int cRed = c.getRed();
                        int cGreen = c.getGreen();
                        int cBlue = c.getBlue();
                        if (!this.inRange(cRed, kRed) || !this.inRange(cGreen, kGreen) || !this.inRange(cBlue, kBlue)) continue;
                        return super.get(c);
                    }
                }
                return val;
            }
        }
    }

    class MyPanel
    extends Panel {
        private static final long serialVersionUID = 1L;
    }
}

