import json
from os import getcwd, remove
from os.path import isfile, join, dirname
from sys import exit
import shutil
from pathlib import Path
import xml.etree.ElementTree as ET
import os


def rollback_target_setup_json(cwd, devices_info):
    target_setup_json_path = join(cwd, "cloudagent", "target_setup.json")
    origin_target_setup_json_path = join(cwd, "cloudagent", "target_setup.json.origin")

    if isfile(origin_target_setup_json_path):
        print("Overriding target_setup.json from origin")
        shutil.copy(origin_target_setup_json_path, target_setup_json_path)
        remove(origin_target_setup_json_path)

    elif isfile(target_setup_json_path):
        target_setup_json_content = json.load(open(target_setup_json_path, "r"))
        devices_id_list = [d["id"] for d in target_setup_json_content["devices"]]
        devices_list = [d["device"] for d in devices_info]

        for device in devices_list:
            if device in devices_id_list:
                target_setup_json_content["devices"] = [
                    d for d in target_setup_json_content["devices"] if d["id"] != device
                ]

        json.dump(target_setup_json_content, open(target_setup_json_path, "w"))

    else:
        print(f"{target_setup_json_path} not found !")
        return False

    print(f"Successfully rollback {target_setup_json_path}")
    return True


def rollback_FlashDLLDB_xml(cwd, devices_info):
    flash_dll_db_xml_path = join(cwd, "DebugServer", "bin", "FlashDLLDB.xml")
    origin_flash_dll_db_xml_path = join(
        cwd, "DebugServer", "bin", "FlashDLLDB.xml.origin"
    )

    if isfile(origin_flash_dll_db_xml_path):
        print("Overriding FlashDLLDB.xml from origin")
        shutil.copy(origin_flash_dll_db_xml_path, flash_dll_db_xml_path)
        remove(origin_flash_dll_db_xml_path)

    elif isfile(flash_dll_db_xml_path):
        tree = ET.parse(flash_dll_db_xml_path)
        root = tree.getroot()

        devices_list = [d["device"] for d in devices_info]
        flash_devices_list = [f"Flash{device}" for device in devices_list]

        for child in root:
            if child.attrib.get("name") in flash_devices_list:
                root.remove(child)

        ET.indent(tree, space="\t", level=0)
        tree.write(flash_dll_db_xml_path)

    else:
        print(f"{flash_dll_db_xml_path} not found !")
        return False

    print(f"Successfully rollback {flash_dll_db_xml_path}")
    return True


def rollback_FlashPropertiesTranslator_xml(cwd, devices_info):
    flash_prop_tran_xml_path = join(
        cwd, "DebugServer", "propertyDB", "FlashPropertiesTranslator.xml"
    )
    origin_flash_prop_tran_xml_path = join(
        cwd, "DebugServer", "propertyDB", "FlashPropertiesTranslator.xml.origin"
    )

    if isfile(origin_flash_prop_tran_xml_path):
        print("Overriding FlashPropertiesTranslators.xml from origin")
        shutil.copy(origin_flash_prop_tran_xml_path, flash_prop_tran_xml_path)
        remove(origin_flash_prop_tran_xml_path)

    elif isfile(flash_prop_tran_xml_path):
        tree = ET.parse(flash_prop_tran_xml_path)
        root = tree.getroot()

        devices_list = [d["device"] for d in devices_info]

        for child in root:
            if child.attrib.get("name") in devices_list:
                root.remove(child)

        ET.indent(tree, space="\t", level=0)
        tree.write(flash_prop_tran_xml_path, encoding="utf-8", xml_declaration=True)

    else:
        print(f"{flash_prop_tran_xml_path} not found !")
        return False

    print(f"Successfully rollback {flash_prop_tran_xml_path}")
    return True


def touch_timestamp(cwd):
    timestamp = join(cwd, "common", "targetdb", "timestamp")

    if not isfile(timestamp):
        print(f"{timestamp} not found !")
        return False

    print(f"Touch and go of {timestamp}")
    with open(timestamp, "r") as f:
        timestamp_content = int(f.read())
    with open(timestamp, "w") as f:
        f.write(str(timestamp_content + 1))

    return True


def get_devices_info(cwd):
    cc35xx_release_path = join(cwd, ".metadata", "cc35xx_release.json")
    cc35xx_release_content = json.load(open(cc35xx_release_path, "r"))
    return cc35xx_release_content


if __name__ == "__main__":
    cwd = getcwd()
    ccs_base_path = Path(cwd).parents[2]
    devices_info = get_devices_info(ccs_base_path)
    rollback_target_setup_json(ccs_base_path, devices_info)
    rollback_FlashDLLDB_xml(ccs_base_path, devices_info)
    rollback_FlashPropertiesTranslator_xml(ccs_base_path, devices_info)
    touch_timestamp(ccs_base_path)
