/* testvectors_ecdsa_data.h
 *
 * Description: Test vectors for ECDSA, actual test vector contents.
 *              This file has been automatically generated.
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

#include <third_party/hsmddk/include/Config/cs_eip130.h>

#include <third_party/hsmddk/include/Kit/DriverFramework/Basic_Defs_API/incl/basic_defs.h>

/* The ECDSA binary material. */
//#define USE_THE_SM2_CURVE

// [P-192,SHA-1] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P192_SHA1_Message[] =
{
    0xEB, 0xF7, 0x48, 0xD7, 0x48, 0xEB, 0xBC, 0xA7, 0xD2, 0x9F, 0xB4, 0x73, 0x69, 0x8A, 0x6E, 0x6B,
    0x4F, 0xB1, 0x0C, 0x86, 0x5D, 0x4A, 0xF0, 0x24, 0xCC, 0x39, 0xAE, 0x3D, 0xF3, 0x46, 0x4B, 0xA4,
    0xF1, 0xD6, 0xD4, 0x0F, 0x32, 0xBF, 0x96, 0x18, 0xA9, 0x1B, 0xB5, 0x98, 0x6F, 0xA1, 0xA2, 0xAF,
    0x04, 0x8A, 0x0E, 0x14, 0xDC, 0x51, 0xE5, 0x26, 0x7E, 0xB0, 0x5E, 0x12, 0x7D, 0x68, 0x9D, 0x0A,
    0xC6, 0xF1, 0xA7, 0xF1, 0x56, 0xCE, 0x06, 0x63, 0x16, 0xB9, 0x71, 0xCC, 0x7A, 0x11, 0xD0, 0xFD,
    0x7A, 0x20, 0x93, 0xE2, 0x7C, 0xF2, 0xD0, 0x87, 0x27, 0xA4, 0xE6, 0x74, 0x8C, 0xC3, 0x2F, 0xD5,
    0x9C, 0x78, 0x10, 0xC5, 0xB9, 0x01, 0x9D, 0xF2, 0x1C, 0xDC, 0xC0, 0xBC, 0xA4, 0x32, 0xC0, 0xA3,
    0xEE, 0xD0, 0x78, 0x53, 0x87, 0x50, 0x88, 0x77, 0x11, 0x43, 0x59, 0xCE, 0xE4, 0xA0, 0x71, 0xCF
};
static const uint8_t Vector_P192_SHA1_PrivateKey[] =
{
    0xE1, 0x4F, 0x37, 0xB3, 0xD1, 0x37, 0x4F, 0xF8, 0xB0, 0x3F, 0x41, 0xB9, 0xB3, 0xFD, 0xD2, 0xF0,
    0xEB, 0xCC, 0xF2, 0x75, 0xD6, 0x60, 0xD7, 0xF3
};
static const uint8_t Vector_P192_SHA1_PublicKeyX[] =
{
    0x07, 0x00, 0x8E, 0xA4, 0x0B, 0x08, 0xDB, 0xE7, 0x64, 0x32, 0x09, 0x6E, 0x80, 0xA2, 0x49, 0x4C,
    0x94, 0x98, 0x2D, 0x2D, 0x5B, 0xCF, 0x98, 0xE6
};
static const uint8_t Vector_P192_SHA1_PublicKeyY[] =
{
    0x76, 0xFA, 0xB6, 0x81, 0xD0, 0x0B, 0x41, 0x4E, 0xA6, 0x36, 0xBA, 0x21, 0x5D, 0xE2, 0x6D, 0x98,
    0xC4, 0x1B, 0xD7, 0xF2, 0xE4, 0xD6, 0x54, 0x77
};
static const uint8_t Vector_P192_SHA1_SignatureR[] =
{
    0x69, 0x94, 0xD9, 0x62, 0xBD, 0xD0, 0xD7, 0x93, 0xFF, 0xDD, 0xF8, 0x55, 0xEC, 0x5B, 0xF2, 0xF9,
    0x1A, 0x96, 0x98, 0xB4, 0x62, 0x58, 0xA6, 0x3E
};
static const uint8_t Vector_P192_SHA1_SignatureS[] =
{
    0x02, 0xBA, 0x64, 0x65, 0xA2, 0x34, 0x90, 0x37, 0x44, 0xAB, 0x02, 0xBC, 0x85, 0x21, 0x40, 0x5B,
    0x73, 0xCF, 0x5F, 0xC0, 0x0E, 0x1A, 0x9F, 0x41
};

// [P-192,SHA-224] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P192_SHA224_Message[] =
{
    0x66, 0xA2, 0x51, 0x3D, 0x7B, 0x60, 0x45, 0xE5, 0x66, 0x79, 0xB0, 0x32, 0xCA, 0xD4, 0x5F, 0xB1,
    0x82, 0x28, 0x9C, 0xA7, 0x6A, 0x88, 0xC0, 0x6D, 0x78, 0xC8, 0x5F, 0x3D, 0xD3, 0x80, 0x45, 0x90,
    0x20, 0x5B, 0x73, 0xA7, 0x84, 0x24, 0x9A, 0x0A, 0x0C, 0x8B, 0xF2, 0xF2, 0x21, 0x45, 0xD1, 0x05,
    0x21, 0x9B, 0x48, 0x0D, 0x74, 0x60, 0x7C, 0x02, 0xB8, 0xA6, 0xB6, 0xB4, 0x59, 0x25, 0x9E, 0x4F,
    0xDF, 0xE2, 0xBD, 0xB4, 0xAB, 0x22, 0x38, 0x01, 0x75, 0x35, 0x29, 0x1D, 0x7A, 0xC1, 0xAB, 0xDA,
    0x66, 0xC4, 0xF6, 0xDC, 0xEA, 0x9E, 0x5D, 0x0B, 0xF0, 0x5A, 0x93, 0x06, 0xF3, 0x33, 0xB0, 0x0E,
    0x56, 0x34, 0x2F, 0x75, 0x53, 0x40, 0x21, 0x1A, 0xC2, 0x94, 0xAC, 0x21, 0xA7, 0xC2, 0xB2, 0x67,
    0x12, 0xB8, 0x79, 0x95, 0x1B, 0x2E, 0x23, 0xF6, 0x48, 0x7E, 0x4D, 0x39, 0x89, 0x9F, 0xE3, 0x74
};
static const uint8_t Vector_P192_SHA224_PrivateKey[] =
{
    0x69, 0x4B, 0x9F, 0xAF, 0x76, 0xB8, 0xC6, 0xBE, 0x78, 0xBB, 0x33, 0xCC, 0xF1, 0xCD, 0x6F, 0x34,
    0x80, 0x9A, 0xB5, 0x7D, 0x04, 0x9F, 0x8E, 0xEB
};
static const uint8_t Vector_P192_SHA224_PublicKeyX[] =
{
    0xDB, 0x43, 0x88, 0xF0, 0x05, 0x04, 0xA5, 0x7B, 0x8C, 0xE6, 0x9B, 0xC4, 0x89, 0x53, 0xD2, 0x51,
    0x57, 0x5B, 0xEC, 0xF9, 0xEF, 0x0A, 0x74, 0x30
};
static const uint8_t Vector_P192_SHA224_PublicKeyY[] =
{
    0x25, 0xF0, 0xD8, 0x77, 0xAF, 0x0B, 0x27, 0x6D, 0xCD, 0xCB, 0xA7, 0x80, 0x71, 0x99, 0xF4, 0x25,
    0x9D, 0xA9, 0x14, 0xDB, 0xAE, 0xCD, 0xC1, 0xA7
};
static const uint8_t Vector_P192_SHA224_SignatureR[] =
{
    0x03, 0x61, 0xCA, 0x48, 0x73, 0x1D, 0xC0, 0x17, 0x02, 0x3C, 0x59, 0xBE, 0xFF, 0x86, 0x09, 0x6B,
    0x56, 0x24, 0x27, 0x08, 0xE4, 0xBC, 0x9E, 0x41
};
static const uint8_t Vector_P192_SHA224_SignatureS[] =
{
    0xF7, 0x65, 0x43, 0x1C, 0xDC, 0x56, 0xA7, 0x3E, 0xF3, 0xAE, 0x3F, 0x1B, 0x58, 0x8E, 0x72, 0x38,
    0x01, 0xB6, 0x59, 0x25, 0x08, 0xD4, 0x52, 0xBF
};

// [P-192,SHA-256] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P192_SHA256_Message[] =
{
    0x5C, 0x86, 0x8F, 0xED, 0xB8, 0x02, 0x69, 0x79, 0xEB, 0xD2, 0x6F, 0x1B, 0xA0, 0x7C, 0x27, 0xEE,
    0xDF, 0x4F, 0xF6, 0xD1, 0x04, 0x43, 0x50, 0x5A, 0x96, 0xEC, 0xAF, 0x21, 0xBA, 0x8C, 0x4F, 0x09,
    0x37, 0xB3, 0xCD, 0x23, 0xFF, 0xDC, 0x3D, 0xD4, 0x29, 0xD4, 0xCD, 0x19, 0x05, 0xFB, 0x8D, 0xBC,
    0xCE, 0xEF, 0xF1, 0x35, 0x00, 0x20, 0xE1, 0x8B, 0x58, 0xD2, 0xBA, 0x70, 0x88, 0x7B, 0xAA, 0x3A,
    0x9B, 0x78, 0x3A, 0xD3, 0x0D, 0x3F, 0xBF, 0x21, 0x03, 0x31, 0xCD, 0xD7, 0xDF, 0x8D, 0x77, 0xDE,
    0xFA, 0x39, 0x8C, 0xDA, 0xCD, 0xFC, 0x2E, 0x35, 0x9C, 0x7B, 0xA4, 0xCA, 0xE4, 0x6B, 0xB7, 0x44,
    0x01, 0xDE, 0xB4, 0x17, 0xF8, 0xB9, 0x12, 0xA1, 0xAA, 0x96, 0x6A, 0xEE, 0xBA, 0x9C, 0x39, 0xC7,
    0xDD, 0x22, 0x47, 0x9A, 0xE2, 0xB3, 0x07, 0x19, 0xDC, 0xA2, 0xF2, 0x20, 0x6C, 0x5E, 0xB4, 0xB7
};
static const uint8_t Vector_P192_SHA256_PrivateKey[] =
{
    0x24, 0xED, 0xD2, 0x2F, 0x7D, 0xDD, 0x6F, 0xA5, 0xBC, 0x61, 0xFC, 0x06, 0x53, 0x47, 0x9A, 0xA4,
    0x08, 0x09, 0xEF, 0x86, 0x5C, 0xF2, 0x7A, 0x47
};
static const uint8_t Vector_P192_SHA256_PublicKeyX[] =
{
    0x9B, 0xF1, 0x2D, 0x71, 0x74, 0xB7, 0x70, 0x8A, 0x07, 0x6A, 0x38, 0xBC, 0x80, 0xAA, 0x28, 0x66,
    0x2F, 0x25, 0x1E, 0x2E, 0xD8, 0xD4, 0x14, 0xDC
};
static const uint8_t Vector_P192_SHA256_PublicKeyY[] =
{
    0x48, 0x54, 0xC8, 0xD0, 0x7D, 0xFC, 0x08, 0x82, 0x4E, 0x9E, 0x47, 0x1C, 0xA2, 0xFE, 0xDC, 0xFC,
    0xFF, 0x3D, 0xDC, 0xB0, 0x11, 0x57, 0x34, 0x98
};
static const uint8_t Vector_P192_SHA256_SignatureR[] =
{
    0x35, 0x4A, 0xBA, 0xEC, 0xF4, 0x36, 0x1F, 0xEA, 0x90, 0xC2, 0x9B, 0x91, 0x99, 0x88, 0x2E, 0xDF,
    0x85, 0x73, 0xE6, 0x86, 0xA8, 0x13, 0xEF, 0xF8
};
static const uint8_t Vector_P192_SHA256_SignatureS[] =
{
    0x80, 0xF5, 0x00, 0x00, 0xAC, 0x86, 0x11, 0x1C, 0x9B, 0x30, 0x47, 0x38, 0x5A, 0x15, 0xD7, 0x8E,
    0x63, 0x2C, 0x58, 0xB7, 0x94, 0x9E, 0x82, 0xC1
};


// [P-224,SHA-1] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P224_SHA1_Message[] =
{
    0x36, 0xC8, 0xB2, 0x29, 0x86, 0x48, 0x7F, 0x67, 0x7C, 0x18, 0xD0, 0x97, 0x2A, 0x9E, 0x20, 0x47,
    0xB3, 0xAF, 0xA5, 0x9E, 0xC1, 0x62, 0x76, 0x4E, 0xC3, 0x0B, 0x5B, 0x69, 0xE0, 0x63, 0x0F, 0x99,
    0x0D, 0x4E, 0x05, 0xC2, 0x73, 0xB0, 0xE5, 0xA9, 0xD4, 0x28, 0x27, 0xB6, 0x95, 0xFC, 0x2D, 0x64,
    0xD9, 0x13, 0x8B, 0x1C, 0xF4, 0xC1, 0x21, 0x55, 0x89, 0x4C, 0x42, 0x13, 0x21, 0xA7, 0xBB, 0x97,
    0x0B, 0xDC, 0xE0, 0xFB, 0xF0, 0xD2, 0xAE, 0x85, 0x61, 0xAA, 0xD8, 0x71, 0x7F, 0x2E, 0x46, 0xDF,
    0xE3, 0xFF, 0x8D, 0xEA, 0xB4, 0xD7, 0x93, 0x23, 0x56, 0x03, 0x2C, 0x15, 0x13, 0x0D, 0x59, 0x9E,
    0x26, 0xC1, 0x0F, 0x2F, 0xEC, 0x96, 0x30, 0x31, 0xAC, 0x69, 0x38, 0xA1, 0x8D, 0x66, 0x45, 0x38,
    0xB9, 0x4D, 0xAC, 0x55, 0x34, 0xEF, 0x7B, 0x59, 0x94, 0x24, 0xD6, 0x9B, 0xE1, 0xF7, 0x1C, 0x20
};
static const uint8_t Vector_P224_SHA1_PrivateKey[] =
{
    0x97, 0xC4, 0xB7, 0x96, 0xE1, 0x63, 0x9D, 0xD1, 0x03, 0x5B, 0x70, 0x8F, 0xC0, 0x0D, 0xC7, 0xBA,
    0x16, 0x82, 0xCE, 0xC4, 0x4A, 0x10, 0x02, 0xA1, 0xA8, 0x20, 0x61, 0x9F
};
static const uint8_t Vector_P224_SHA1_PublicKeyX[] =
{
    0x8A, 0x4D, 0xCA, 0x35, 0x13, 0x6C, 0x4B, 0x70, 0xE5, 0x88, 0xE2, 0x35, 0x54, 0x63, 0x7A, 0xE2,
    0x51, 0x07, 0x7D, 0x13, 0x65, 0xA6, 0xBA, 0x5D, 0xB9, 0x58, 0x5D, 0xE7
};
static const uint8_t Vector_P224_SHA1_PublicKeyY[] =
{
    0xAD, 0x3D, 0xEE, 0x06, 0xDE, 0x0B, 0xE8, 0x27, 0x9D, 0x4A, 0xF4, 0x35, 0xD7, 0x24, 0x5F, 0x14,
    0xF3, 0xB4, 0xF8, 0x2E, 0xB5, 0x78, 0xE5, 0x19, 0xEE, 0x00, 0x57, 0xB1
};
static const uint8_t Vector_P224_SHA1_SignatureR[] =
{
    0x14, 0x7B, 0x33, 0x75, 0x83, 0x21, 0xE7, 0x22, 0xA0, 0x36, 0x0A, 0x47, 0x19, 0x73, 0x8A, 0xF8,
    0x48, 0x44, 0x9E, 0x2C, 0x1D, 0x08, 0xDE, 0xFE, 0xBC, 0x16, 0x71, 0xA7
};
static const uint8_t Vector_P224_SHA1_SignatureS[] =
{
    0x24, 0xFC, 0x7E, 0xD7, 0xF1, 0x35, 0x2C, 0xA3, 0x87, 0x2A, 0xA0, 0x91, 0x61, 0x91, 0x28, 0x9E,
    0x2E, 0x04, 0xD4, 0x54, 0x93, 0x5D, 0x50, 0xFE, 0x6A, 0xF3, 0xAD, 0x5B
};

// [P-224,SHA-224] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P224_SHA224_Message[] =
{
    0x69, 0x93, 0x25, 0xD6, 0xFC, 0x8F, 0xBB, 0xB4, 0x98, 0x1A, 0x6D, 0xED, 0x3C, 0x3A, 0x54, 0xAD,
    0x2E, 0x4E, 0x3D, 0xB8, 0xA5, 0x66, 0x92, 0x01, 0x91, 0x20, 0x64, 0xC6, 0x4E, 0x70, 0x0C, 0x13,
    0x92, 0x48, 0xCD, 0xC1, 0x94, 0x95, 0xDF, 0x08, 0x1C, 0x3F, 0xC6, 0x02, 0x45, 0xB9, 0xF2, 0x5F,
    0xC9, 0xE3, 0x01, 0xB8, 0x45, 0xB3, 0xD7, 0x03, 0xA6, 0x94, 0x98, 0x6E, 0x46, 0x41, 0xAE, 0x3C,
    0x7E, 0x5A, 0x19, 0xE6, 0xD6, 0xED, 0xBF, 0x1D, 0x61, 0xE5, 0x35, 0xF4, 0x9A, 0x8F, 0xAD, 0x5F,
    0x4A, 0xC2, 0x63, 0x97, 0xCF, 0xEC, 0x68, 0x2F, 0x16, 0x1A, 0x5F, 0xCD, 0x32, 0xC5, 0xE7, 0x80,
    0x66, 0x8B, 0x01, 0x81, 0xA9, 0x19, 0x55, 0x15, 0x76, 0x35, 0x53, 0x6A, 0x22, 0x36, 0x73, 0x08,
    0x03, 0x6E, 0x20, 0x70, 0xF5, 0x44, 0xAD, 0x4F, 0xFF, 0x3D, 0x51, 0x22, 0xC7, 0x6F, 0xAD, 0x5D
};
static const uint8_t Vector_P224_SHA224_PrivateKey[] =
{
    0x16, 0x79, 0x7B, 0x5C, 0x0C, 0x7E, 0xD5, 0x46, 0x1E, 0x2F, 0xF1, 0xB8, 0x8E, 0x6E, 0xAF, 0xA0,
    0x3C, 0x0F, 0x46, 0xBF, 0x07, 0x20, 0x00, 0xDF, 0xC8, 0x30, 0xD6, 0x15
};
static const uint8_t Vector_P224_SHA224_PublicKeyX[] =
{
    0x60, 0x54, 0x95, 0x75, 0x6E, 0x6E, 0x88, 0xF1, 0xD0, 0x7A, 0xE5, 0xF9, 0x87, 0x87, 0xAF, 0x9B,
    0x4D, 0xA8, 0xA6, 0x41, 0xD1, 0xA9, 0x49, 0x2A, 0x12, 0x17, 0x4E, 0xAB
};
static const uint8_t Vector_P224_SHA224_PublicKeyY[] =
{
    0xF5, 0xCC, 0x73, 0x3B, 0x17, 0xDE, 0xCC, 0x80, 0x6E, 0xF1, 0xDF, 0x86, 0x1A, 0x42, 0x50, 0x5D,
    0x0A, 0xF9, 0xEF, 0x7C, 0x3D, 0xF3, 0x95, 0x9B, 0x8D, 0xFC, 0x66, 0x69
};
static const uint8_t Vector_P224_SHA224_SignatureR[] =
{
    0x2F, 0xC2, 0xCF, 0xF8, 0xCD, 0xD4, 0x86, 0x6B, 0x1D, 0x74, 0xE4, 0x5B, 0x07, 0xD3, 0x33, 0xAF,
    0x46, 0xB7, 0xAF, 0x08, 0x88, 0x04, 0x9D, 0x0F, 0xDB, 0xC7, 0xB0, 0xD6
};
static const uint8_t Vector_P224_SHA224_SignatureS[] =
{
    0x8D, 0x9C, 0xC4, 0xC8, 0xEA, 0x93, 0xE0, 0xFD, 0x9D, 0x64, 0x31, 0xB9, 0xA1, 0xFD, 0x99, 0xB8,
    0x8F, 0x28, 0x17, 0x93, 0x39, 0x63, 0x21, 0xB1, 0x1D, 0xAC, 0x41, 0xEB
};

// [P-224,SHA-256] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P224_SHA256_Message[] =
{
    0x2B, 0x49, 0xDE, 0x97, 0x1B, 0xB0, 0xF7, 0x05, 0xA3, 0xFB, 0x59, 0x14, 0xEB, 0x76, 0x38, 0xD7,
    0x28, 0x84, 0xA6, 0xC3, 0x55, 0x06, 0x67, 0xDB, 0xFD, 0xF3, 0x01, 0xAD, 0xF2, 0x6B, 0xDE, 0x02,
    0xF3, 0x87, 0xFD, 0x42, 0x6A, 0x31, 0xBE, 0x6C, 0x9F, 0xF8, 0xBF, 0xE8, 0x69, 0x0C, 0x81, 0x13,
    0xC8, 0x85, 0x76, 0x42, 0x7F, 0x14, 0x66, 0x50, 0x84, 0x58, 0x34, 0x9F, 0xC8, 0x60, 0x36, 0xAF,
    0xCF, 0xB6, 0x64, 0x48, 0xB9, 0x47, 0x70, 0x7E, 0x79, 0x1E, 0x71, 0xF5, 0x58, 0xB2, 0xBF, 0x4E,
    0x7E, 0x75, 0x07, 0x77, 0x3A, 0xAF, 0x4E, 0x9A, 0xF5, 0x1E, 0xDA, 0x95, 0xCB, 0xCE, 0x0A, 0x0F,
    0x75, 0x2B, 0x21, 0x6F, 0x8A, 0x54, 0xA0, 0x45, 0xD4, 0x78, 0x01, 0xFF, 0x41, 0x0E, 0xE4, 0x11,
    0xA1, 0xB6, 0x6A, 0x51, 0x6F, 0x27, 0x83, 0x27, 0xDF, 0x24, 0x62, 0xFB, 0x56, 0x19, 0x47, 0x0E
};
static const uint8_t Vector_P224_SHA256_PrivateKey[] =
{
    0x88, 0x8F, 0xC9, 0x92, 0x89, 0x3B, 0xDD, 0x8A, 0xA0, 0x2C, 0x80, 0x76, 0x88, 0x32, 0x60, 0x5D,
    0x02, 0x0B, 0x81, 0xAE, 0x0B, 0x25, 0x47, 0x41, 0x54, 0xEC, 0x89, 0xAA
};
static const uint8_t Vector_P224_SHA256_PublicKeyX[] =
{
    0x4C, 0x74, 0x1E, 0x4D, 0x20, 0x10, 0x36, 0x70, 0xB7, 0x16, 0x1A, 0xE7, 0x22, 0x71, 0x08, 0x21,
    0x55, 0x83, 0x84, 0x18, 0x08, 0x43, 0x35, 0x33, 0x8A, 0xC3, 0x8F, 0xA4
};
static const uint8_t Vector_P224_SHA256_PublicKeyY[] =
{
    0xDB, 0x79, 0x19, 0x15, 0x1A, 0xC2, 0x85, 0x87, 0xB7, 0x2B, 0xAD, 0x7A, 0xB1, 0x80, 0xEC, 0x8E,
    0x95, 0xAB, 0x9E, 0x2C, 0x8D, 0x81, 0xD9, 0xB9, 0xD7, 0xE2, 0xE3, 0x83
};
static const uint8_t Vector_P224_SHA256_SignatureR[] =
{
    0x09, 0x09, 0xC9, 0xB9, 0xCA, 0xE8, 0xD2, 0x79, 0x0E, 0x29, 0xDB, 0x6A, 0xFD, 0xB4, 0x5C, 0x04,
    0xF5, 0xB0, 0x72, 0xC4, 0xC2, 0x04, 0x10, 0xC7, 0xDC, 0x9B, 0x67, 0x72
};
static const uint8_t Vector_P224_SHA256_SignatureS[] =
{
    0x29, 0x8F, 0x4F, 0xCA, 0xE1, 0xFE, 0x27, 0x1D, 0xA1, 0xE0, 0x34, 0x5D, 0x11, 0xD0, 0x7A, 0x1F,
    0xCA, 0x43, 0xF5, 0x8A, 0xF4, 0xC1, 0x13, 0xB9, 0x09, 0xEE, 0xDE, 0xA0
};

#ifdef EIP130_ENABLE_SYM_ALGO_SHA512
// [P-224,SHA-384] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P224_SHA384_Message[] =
{
    0x25, 0xE4, 0x41, 0x66, 0x95, 0xF7, 0x75, 0x51, 0xFD, 0xCE, 0x27, 0x63, 0x55, 0x52, 0x8C, 0xCF,
    0x1D, 0xDC, 0x24, 0x83, 0x82, 0x1C, 0x5D, 0x22, 0xD7, 0x51, 0xD5, 0x01, 0x11, 0xCA, 0x2F, 0xAD,
    0xC6, 0x59, 0x3B, 0x52, 0xC7, 0x4F, 0x4B, 0x59, 0x57, 0x49, 0x4F, 0x1D, 0xF2, 0x5B, 0x0B, 0x2F,
    0x86, 0x95, 0x0D, 0x0D, 0x19, 0x22, 0x9E, 0xC6, 0x50, 0x6F, 0xEE, 0x85, 0x81, 0xD2, 0xDD, 0x09,
    0xD4, 0x84, 0x18, 0xB1, 0x46, 0xFF, 0x16, 0xBD, 0x84, 0xA1, 0x7C, 0xA0, 0xDC, 0x83, 0xB1, 0x88,
    0x8E, 0xB4, 0x07, 0x37, 0x6D, 0xA6, 0xC8, 0xA8, 0x8F, 0xA1, 0xE6, 0x0B, 0x8C, 0x2A, 0x24, 0x71,
    0xDF, 0xDE, 0x4B, 0x39, 0x96, 0xEF, 0x67, 0x3D, 0x5B, 0xDE, 0x3D, 0x70, 0xC4, 0x34, 0xDC, 0x9F,
    0x24, 0x88, 0xE9, 0xDE, 0x16, 0xAE, 0x65, 0x7D, 0x29, 0xE5, 0xE5, 0x9E, 0xC9, 0x22, 0xA1, 0xEC
};
static const uint8_t Vector_P224_SHA384_PrivateKey[] =
{
    0x62, 0xC5, 0x72, 0xEE, 0x0D, 0x6F, 0x81, 0xB2, 0x7E, 0x59, 0x1D, 0x78, 0x8B, 0xFC, 0x2F, 0x42,
    0xB5, 0x10, 0x5D, 0x26, 0x63, 0x07, 0x8D, 0xFB, 0x58, 0x06, 0x9E, 0xBD
};
static const uint8_t Vector_P224_SHA384_PublicKeyX[] =
{
    0xBD, 0x6B, 0xA6, 0x05, 0x63, 0x9B, 0x98, 0xFA, 0x81, 0x13, 0xA1, 0x6A, 0x3B, 0xB0, 0x04, 0xDD,
    0xFA, 0xEC, 0x90, 0x1C, 0x98, 0xA9, 0x31, 0x20, 0x61, 0x65, 0xF4, 0xA5
};
static const uint8_t Vector_P224_SHA384_PublicKeyY[] =
{
    0xA3, 0x19, 0x0B, 0x10, 0xEF, 0x39, 0xE8, 0x8A, 0xBD, 0x60, 0xB2, 0x29, 0x3B, 0x47, 0x07, 0x51,
    0x2B, 0x45, 0xC6, 0xC5, 0xED, 0x57, 0x94, 0xCC, 0x11, 0x45, 0x44, 0x27
};
static const uint8_t Vector_P224_SHA384_SignatureR[] =
{
    0xAA, 0xC0, 0xEA, 0x27, 0xE1, 0x29, 0xF5, 0x44, 0xAB, 0xCC, 0x77, 0xF1, 0x10, 0xE7, 0x0B, 0xBD,
    0xD5, 0xAA, 0x3E, 0x42, 0x5D, 0xC3, 0x9D, 0x5E, 0x88, 0x87, 0x02, 0x5D
};
static const uint8_t Vector_P224_SHA384_SignatureS[] =
{
    0x10, 0xE5, 0xDD, 0x06, 0xAE, 0xE6, 0xB8, 0x41, 0x9A, 0x04, 0xAA, 0x33, 0xD9, 0xD5, 0x67, 0x8B,
    0x00, 0x39, 0xC3, 0xAC, 0xC3, 0xC4, 0xB6, 0x1F, 0xE1, 0x06, 0xBF, 0xDC
};

// [P-224,SHA-512] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P224_SHA512_Message[] =
{
    0x75, 0x22, 0x49, 0x2B, 0xDB, 0x91, 0x6A, 0x59, 0x7B, 0x81, 0x21, 0xF3, 0xE5, 0xC2, 0x73, 0xB1,
    0xD2, 0x80, 0x0E, 0xF8, 0xC1, 0xDB, 0x4F, 0x7D, 0xCB, 0xAE, 0x63, 0x3B, 0x60, 0xD7, 0xDA, 0x51,
    0x93, 0xBA, 0x53, 0xA6, 0x3D, 0x7A, 0x37, 0x7B, 0x35, 0x18, 0x97, 0xC3, 0xB2, 0x49, 0x03, 0xAE,
    0x1C, 0xD1, 0x99, 0x42, 0x11, 0xB2, 0x59, 0xBE, 0x3E, 0x6A, 0xE2, 0xCB, 0xC8, 0x97, 0x0E, 0x49,
    0x57, 0xFD, 0xF7, 0x82, 0xC7, 0xD1, 0xBC, 0x7A, 0x91, 0xC8, 0x0C, 0x8E, 0xF6, 0x54, 0x68, 0xD4,
    0xEF, 0x35, 0x42, 0x8F, 0x26, 0xE2, 0x94, 0x0A, 0xE8, 0xB0, 0xBD, 0x9B, 0x80, 0x74, 0x23, 0x6B,
    0xF6, 0xC0, 0x0D, 0x0E, 0xBE, 0x83, 0xF9, 0xDD, 0xB2, 0xAD, 0xE0, 0xF8, 0x35, 0x13, 0x8D, 0x39,
    0xF3, 0x3B, 0x59, 0xF2, 0x44, 0xE0, 0x03, 0x7C, 0x17, 0x1F, 0x1B, 0xA7, 0x04, 0x5A, 0x96, 0xF5
};
static const uint8_t Vector_P224_SHA512_PrivateKey[] =
{
    0xBA, 0x53, 0x74, 0x54, 0x1C, 0x13, 0x59, 0x7B, 0xDE, 0xD6, 0x88, 0x08, 0x49, 0x18, 0x4A, 0x59,
    0x3D, 0x69, 0xD3, 0xD4, 0xF0, 0xB1, 0xCB, 0x4D, 0x09, 0x19, 0xCB, 0xD6
};
static const uint8_t Vector_P224_SHA512_PublicKeyX[] =
{
    0xAC, 0x63, 0x5F, 0xE0, 0x0E, 0x8B, 0x7A, 0x3C, 0x8E, 0xF5, 0x65, 0x5B, 0xDF, 0xB7, 0xF8, 0x3E,
    0x85, 0x32, 0xE5, 0x9C, 0x0C, 0xC0, 0xB6, 0x53, 0x4D, 0x81, 0x0F, 0xFA
};
static const uint8_t Vector_P224_SHA512_PublicKeyY[] =
{
    0x1D, 0x06, 0x7A, 0xEB, 0xEB, 0xA6, 0x6E, 0x79, 0xB2, 0x8E, 0xCF, 0xE5, 0x9A, 0xC6, 0xFD, 0xF5,
    0xE1, 0x97, 0x0D, 0xC3, 0xA8, 0x44, 0x99, 0xC9, 0xD9, 0x0C, 0xD8, 0xE2
};
static const uint8_t Vector_P224_SHA512_SignatureR[] =
{
    0xF8, 0x3D, 0x54, 0x94, 0x59, 0x97, 0x58, 0x4C, 0x92, 0x3C, 0x09, 0x66, 0x2C, 0x34, 0xCF, 0x9A,
    0xD1, 0xE9, 0x87, 0xDA, 0x8B, 0xFD, 0x9B, 0xE6, 0x00, 0xE7, 0xA0, 0x98
};
static const uint8_t Vector_P224_SHA512_SignatureS[] =
{
    0x4F, 0xF2, 0xDB, 0xA9, 0xDB, 0xA9, 0x92, 0xC9, 0x8A, 0x09, 0x5B, 0x11, 0x44, 0xA5, 0x39, 0x31,
    0x0E, 0x1A, 0x57, 0x0E, 0x20, 0xC8, 0x8B, 0x7D, 0x0A, 0xA1, 0x95, 0x5C
};
#endif /* EIP130_ENABLE_SYM_ALGO_SHA512 */


// [P-256,SHA-1] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P256_SHA1_Message[] =
{
    0xA2, 0x4B, 0x21, 0x76, 0x2E, 0x6E, 0xDB, 0x15, 0x3C, 0xC1, 0x14, 0x38, 0xDB, 0x0E, 0x92, 0xCD,
    0xF5, 0x2B, 0x86, 0xB0, 0x6C, 0xA9, 0x70, 0x16, 0x06, 0x27, 0x59, 0xC7, 0x0D, 0x36, 0xD1, 0x56,
    0x2C, 0xC9, 0x63, 0x0D, 0x7F, 0xC7, 0xC7, 0x74, 0xB2, 0x8B, 0x54, 0xE3, 0x1E, 0xF5, 0x58, 0x72,
    0xB2, 0xA6, 0x5D, 0xF1, 0xD7, 0xEC, 0x26, 0xDE, 0xBB, 0x33, 0xE7, 0xD9, 0x27, 0xEF, 0xCC, 0xF4,
    0x6B, 0x63, 0xDE, 0x52, 0xA4, 0xF4, 0x31, 0xEA, 0xCA, 0x59, 0xB0, 0x5D, 0x2E, 0xDE, 0xC4, 0x84,
    0x5F, 0xFF, 0xC0, 0xEE, 0x15, 0x03, 0x94, 0xD6, 0x1F, 0x3D, 0xFE, 0xCB, 0xCD, 0xBF, 0x6F, 0x5A,
    0x73, 0x38, 0xD0, 0xBE, 0x3F, 0x2A, 0x77, 0x34, 0x51, 0x98, 0x3E, 0xBA, 0xEB, 0x48, 0xF6, 0x73,
    0x8F, 0xC8, 0x95, 0xDF, 0x35, 0x7E, 0x1A, 0x48, 0xA6, 0x53, 0xBB, 0x35, 0x5A, 0x31, 0xA1, 0xB4
};
static const uint8_t Vector_P256_SHA1_PrivateKey[] =
{
    0xBE, 0x34, 0xBA, 0xA8, 0xD0, 0x40, 0xA3, 0xB9, 0x91, 0xF9, 0x07, 0x5B, 0x56, 0xBA, 0x29, 0x2F,
    0x75, 0x5B, 0x90, 0xE4, 0xB6, 0xDC, 0x10, 0xDA, 0xD3, 0x67, 0x15, 0xC3, 0x3C, 0xFD, 0xAC, 0x25
};
static const uint8_t Vector_P256_SHA1_PublicKeyX[] =
{
    0xFA, 0x27, 0x37, 0xFB, 0x93, 0x48, 0x8D, 0x19, 0xCA, 0xEF, 0x11, 0xAE, 0x7F, 0xAF, 0x6B, 0x7F,
    0x4B, 0xCD, 0x67, 0xB2, 0x86, 0xE3, 0xFC, 0x54, 0xE8, 0xA6, 0x5C, 0x2B, 0x74, 0xAE, 0xCC, 0xB0,
};
static const uint8_t Vector_P256_SHA1_PublicKeyY[] =
{
    0xD4, 0xCC, 0xD6, 0xDA, 0xE6, 0x98, 0x20, 0x8A, 0xA8, 0xC3, 0xA6, 0xF3, 0x9E, 0x45, 0x51, 0x0D,
    0x03, 0xBE, 0x09, 0xB2, 0xF1, 0x24, 0xBF, 0xC0, 0x67, 0x85, 0x6C, 0x32, 0x4F, 0x9B, 0x4D, 0x09
};
static const uint8_t Vector_P256_SHA1_SignatureR[] =
{
    0x2B, 0x82, 0x6F, 0x5D, 0x44, 0xE2, 0xD0, 0xB6, 0xDE, 0x53, 0x1A, 0xD9, 0x6B, 0x51, 0xE8, 0xF0,
    0xC5, 0x6F, 0xDF, 0xEA, 0xD3, 0xC2, 0x36, 0x89, 0x2E, 0x4D, 0x84, 0xEA, 0xCF, 0xC3, 0xB7, 0x5C
};
static const uint8_t Vector_P256_SHA1_SignatureS[] =
{
    0xA2, 0x24, 0x8B, 0x62, 0xC0, 0x3D, 0xB3, 0x5A, 0x7C, 0xD6, 0x3E, 0x8A, 0x12, 0x0A, 0x35, 0x21,
    0xA8, 0x9D, 0x3D, 0x2F, 0x61, 0xFF, 0x99, 0x03, 0x5A, 0x21, 0x48, 0xAE, 0x32, 0xE3, 0xA2, 0x48
};

// [P-256,SHA-224] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P256_SHA224_Message[] =
{
    0xFF, 0x62, 0x4D, 0x0B, 0xA0, 0x2C, 0x7B, 0x63, 0x70, 0xC1, 0x62, 0x2E, 0xEC, 0x3F, 0xA2, 0x18,
    0x6E, 0xA6, 0x81, 0xD1, 0x65, 0x9E, 0x0A, 0x84, 0x54, 0x48, 0xE7, 0x77, 0xB7, 0x5A, 0x8E, 0x77,
    0xA7, 0x7B, 0xB2, 0x6E, 0x57, 0x33, 0x17, 0x9D, 0x58, 0xEF, 0x9B, 0xC8, 0xA4, 0xE8, 0xB6, 0x97,
    0x1A, 0xEF, 0x25, 0x39, 0xF7, 0x7A, 0xB0, 0x96, 0x3A, 0x34, 0x15, 0xBB, 0xD6, 0x25, 0x83, 0x39,
    0xBD, 0x1B, 0xF5, 0x5D, 0xE6, 0x5D, 0xB5, 0x20, 0xC6, 0x3F, 0x5B, 0x8E, 0xAB, 0x3D, 0x55, 0xDE,
    0xBD, 0x05, 0xE9, 0x49, 0x42, 0x12, 0x17, 0x0F, 0x5D, 0x65, 0xB3, 0x28, 0x6B, 0x8B, 0x66, 0x87,
    0x05, 0xB1, 0xE2, 0xB2, 0xB5, 0x56, 0x86, 0x10, 0x61, 0x7A, 0xBB, 0x51, 0xD2, 0xDD, 0x0C, 0xB4,
    0x50, 0xEF, 0x59, 0xDF, 0x4B, 0x90, 0x7D, 0xA9, 0x0C, 0xFA, 0x7B, 0x26, 0x8D, 0xE8, 0xC4, 0xC2
};
static const uint8_t Vector_P256_SHA224_PrivateKey[] =
{
    0x70, 0x83, 0x09, 0xA7, 0x44, 0x9E, 0x15, 0x6B, 0x0D, 0xB7, 0x0E, 0x5B, 0x52, 0xE6, 0x06, 0xC7,
    0xE0, 0x94, 0xED, 0x67, 0x6C, 0xE8, 0x95, 0x3B, 0xF6, 0xC1, 0x47, 0x57, 0xC8, 0x26, 0xF5, 0x90
};
static const uint8_t Vector_P256_SHA224_PublicKeyX[] =
{
    0x29, 0x57, 0x8C, 0x7A, 0xB6, 0xCE, 0x0D, 0x11, 0x49, 0x3C, 0x95, 0xD5, 0xEA, 0x05, 0xD2, 0x99,
    0xD5, 0x36, 0x80, 0x1C, 0xA9, 0xCB, 0xD5, 0x0E, 0x99, 0x24, 0xE4, 0x3B, 0x73, 0x3B, 0x83, 0xAB
};
static const uint8_t Vector_P256_SHA224_PublicKeyY[] =
{
    0x08, 0xC8, 0x04, 0x98, 0x79, 0xC6, 0x27, 0x8B, 0x22, 0x73, 0x34, 0x84, 0x74, 0x15, 0x85, 0x15,
    0xAC, 0xCA, 0xA3, 0x83, 0x44, 0x10, 0x6E, 0xF9, 0x68, 0x03, 0xC5, 0xA0, 0x5A, 0xDC, 0x48, 0x00
};
static const uint8_t Vector_P256_SHA224_SignatureR[] =
{
    0x4A, 0x19, 0x27, 0x44, 0x29, 0xE4, 0x05, 0x22, 0x23, 0x4B, 0x87, 0x85, 0xDC, 0x25, 0xFC, 0x52,
    0x4F, 0x17, 0x9D, 0xCC, 0x95, 0xFF, 0x09, 0xB3, 0xC9, 0x77, 0x0F, 0xC7, 0x1F, 0x54, 0xCA, 0x0D
};
static const uint8_t Vector_P256_SHA224_SignatureS[] =
{
    0x58, 0x98, 0x2B, 0x79, 0xA6, 0x5B, 0x73, 0x20, 0xF5, 0xB9, 0x2D, 0x13, 0xBD, 0xAE, 0xCD, 0xD1,
    0x25, 0x9E, 0x76, 0x0F, 0x0F, 0x71, 0x8B, 0xA9, 0x33, 0xFD, 0x09, 0x8F, 0x6F, 0x75, 0xD4, 0xB7
};

// [P-256,SHA-256] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P256_SHA256_Message[] =
{
    0x59, 0x05, 0x23, 0x88, 0x77, 0xC7, 0x74, 0x21, 0xF7, 0x3E, 0x43, 0xEE, 0x3D, 0xA6, 0xF2, 0xD9,
    0xE2, 0xCC, 0xAD, 0x5F, 0xC9, 0x42, 0xDC, 0xEC, 0x0C, 0xBD, 0x25, 0x48, 0x29, 0x35, 0xFA, 0xAF,
    0x41, 0x69, 0x83, 0xFE, 0x16, 0x5B, 0x1A, 0x04, 0x5E, 0xE2, 0xBC, 0xD2, 0xE6, 0xDC, 0xA3, 0xBD,
    0xF4, 0x6C, 0x43, 0x10, 0xA7, 0x46, 0x1F, 0x9A, 0x37, 0x96, 0x0C, 0xA6, 0x72, 0xD3, 0xFE, 0xB5,
    0x47, 0x3E, 0x25, 0x36, 0x05, 0xFB, 0x1D, 0xDF, 0xD2, 0x80, 0x65, 0xB5, 0x3C, 0xB5, 0x85, 0x8A,
    0x8A, 0xD2, 0x81, 0x75, 0xBF, 0x9B, 0xD3, 0x86, 0xA5, 0xE4, 0x71, 0xEA, 0x7A, 0x65, 0xC1, 0x7C,
    0xC9, 0x34, 0xA9, 0xD7, 0x91, 0xE9, 0x14, 0x91, 0xEB, 0x37, 0x54, 0xD0, 0x37, 0x99, 0x79, 0x0F,
    0xE2, 0xD3, 0x08, 0xD1, 0x61, 0x46, 0xD5, 0xC9, 0xB0, 0xD0, 0xDE, 0xBD, 0x97, 0xD7, 0x9C, 0xE8
};
static const uint8_t Vector_P256_SHA256_PrivateKey[] =
{
    0x51, 0x9B, 0x42, 0x3D, 0x71, 0x5F, 0x8B, 0x58, 0x1F, 0x4F, 0xA8, 0xEE, 0x59, 0xF4, 0x77, 0x1A,
    0x5B, 0x44, 0xC8, 0x13, 0x0B, 0x4E, 0x3E, 0xAC, 0xCA, 0x54, 0xA5, 0x6D, 0xDA, 0x72, 0xB4, 0x64
};
static const uint8_t Vector_P256_SHA256_PublicKeyX[] =
{
    0x1C, 0xCB, 0xE9, 0x1C, 0x07, 0x5F, 0xC7, 0xF4, 0xF0, 0x33, 0xBF, 0xA2, 0x48, 0xDB, 0x8F, 0xCC,
    0xD3, 0x56, 0x5D, 0xE9, 0x4B, 0xBF, 0xB1, 0x2F, 0x3C, 0x59, 0xFF, 0x46, 0xC2, 0x71, 0xBF, 0x83
};
static const uint8_t Vector_P256_SHA256_PublicKeyY[] =
{
    0xCE, 0x40, 0x14, 0xC6, 0x88, 0x11, 0xF9, 0xA2, 0x1A, 0x1F, 0xDB, 0x2C, 0x0E, 0x61, 0x13, 0xE0,
    0x6D, 0xB7, 0xCA, 0x93, 0xB7, 0x40, 0x4E, 0x78, 0xDC, 0x7C, 0xCD, 0x5C, 0xA8, 0x9A, 0x4C, 0xA9
};
static const uint8_t Vector_P256_SHA256_SignatureR[] =
{
    0xF3, 0xAC, 0x80, 0x61, 0xB5, 0x14, 0x79, 0x5B, 0x88, 0x43, 0xE3, 0xD6, 0x62, 0x95, 0x27, 0xED,
    0x2A, 0xFD, 0x6B, 0x1F, 0x6A, 0x55, 0x5A, 0x7A, 0xCA, 0xBB, 0x5E, 0x6F, 0x79, 0xC8, 0xC2, 0xAC
};
static const uint8_t Vector_P256_SHA256_SignatureS[] =
{
    0x8B, 0xF7, 0x78, 0x19, 0xCA, 0x05, 0xA6, 0xB2, 0x78, 0x6C, 0x76, 0x26, 0x2B, 0xF7, 0x37, 0x1C,
    0xEF, 0x97, 0xB2, 0x18, 0xE9, 0x6F, 0x17, 0x5A, 0x3C, 0xCD, 0xDA, 0x2A, 0xCC, 0x05, 0x89, 0x03
};

#ifdef EIP130_ENABLE_SYM_ALGO_SHA512
// [P-256,SHA-384] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P256_SHA384_Message[] =
{
    0xE0, 0xB8, 0x59, 0x6B, 0x37, 0x5F, 0x33, 0x06, 0xBB, 0xC6, 0xE7, 0x7A, 0x0B, 0x42, 0xF7, 0x46,
    0x9D, 0x7E, 0x83, 0x63, 0x59, 0x90, 0xE7, 0x4A, 0xA6, 0xD7, 0x13, 0x59, 0x4A, 0x3A, 0x24, 0x49,
    0x8F, 0xEF, 0xF5, 0x00, 0x67, 0x90, 0x74, 0x2D, 0x9C, 0x2E, 0x9B, 0x47, 0xD7, 0x14, 0xBE, 0xE9,
    0x32, 0x43, 0x5D, 0xB7, 0x47, 0xC6, 0xE7, 0x33, 0xE3, 0xD8, 0xDE, 0x41, 0xF2, 0xF9, 0x13, 0x11,
    0xF2, 0xE9, 0xFD, 0x8E, 0x02, 0x56, 0x51, 0x63, 0x1F, 0xFD, 0x84, 0xF6, 0x67, 0x32, 0xD3, 0x47,
    0x3F, 0xBD, 0x16, 0x27, 0xE6, 0x3D, 0xC7, 0x19, 0x40, 0x48, 0xEB, 0xEC, 0x93, 0xC9, 0x5C, 0x15,
    0x9B, 0x50, 0x39, 0xAB, 0x5E, 0x79, 0xE4, 0x2C, 0x80, 0xB4, 0x84, 0xA9, 0x43, 0xF1, 0x25, 0xDE,
    0x3D, 0xA1, 0xE0, 0x4E, 0x5B, 0xF9, 0xC1, 0x66, 0x71, 0xAD, 0x55, 0xA1, 0x11, 0x7D, 0x33, 0x06
};
static const uint8_t Vector_P256_SHA384_PrivateKey[] =
{
    0xB6, 0xFA, 0xF2, 0xC8, 0x92, 0x22, 0x35, 0xC5, 0x89, 0xC2, 0x73, 0x68, 0xA3, 0xB3, 0xE6, 0xE2,
    0xF4, 0x2E, 0xB6, 0x07, 0x3B, 0xF9, 0x50, 0x7F, 0x19, 0xEE, 0xD0, 0x74, 0x6C, 0x79, 0xDC, 0xED
};
static const uint8_t Vector_P256_SHA384_PublicKeyX[] =
{
    0xE0, 0xE7, 0xB9, 0x9B, 0xC6, 0x2D, 0x8D, 0xD6, 0x78, 0x83, 0xE3, 0x9E, 0xD9, 0xFA, 0x06, 0x57,
    0x78, 0x9C, 0x5F, 0xF5, 0x56, 0xCC, 0x1F, 0xD8, 0xDD, 0x1E, 0x2A, 0x55, 0xE9, 0xE3, 0xF2, 0x43
};
static const uint8_t Vector_P256_SHA384_PublicKeyY[] =
{
    0x63, 0xFB, 0xFD, 0x02, 0x32, 0xB9, 0x55, 0x78, 0x07, 0x5C, 0x90, 0x3A, 0x4D, 0xBF, 0x85, 0xAD,
    0x58, 0xF8, 0x35, 0x05, 0x16, 0xE1, 0xEC, 0x89, 0xB0, 0xEE, 0x1F, 0x5E, 0x13, 0x62, 0xDA, 0x69
};
static const uint8_t Vector_P256_SHA384_SignatureR[] =
{
    0xF5, 0x08, 0x78, 0x78, 0xE2, 0x12, 0xB7, 0x03, 0x57, 0x8F, 0x5C, 0x66, 0xF4, 0x34, 0x88, 0x3F,
    0x3E, 0xF4, 0x14, 0xDC, 0x23, 0xE2, 0xE8, 0xD8, 0xAB, 0x6A, 0x8D, 0x15, 0x9E, 0xD5, 0xAD, 0x83
};
static const uint8_t Vector_P256_SHA384_SignatureS[] =
{
    0x30, 0x6B, 0x4C, 0x6C, 0x20, 0x21, 0x37, 0x07, 0x98, 0x2D, 0xFF, 0xBB, 0x30, 0xFB, 0xA9, 0x9B,
    0x96, 0xE7, 0x92, 0x16, 0x3D, 0xD5, 0x9D, 0xBE, 0x60, 0x6E, 0x73, 0x43, 0x28, 0xDD, 0x7C, 0x8A
};

// [P-256,SHA-512] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P256_SHA512_Message[] =
{
    0x6C, 0x85, 0x72, 0xB6, 0xA3, 0xA4, 0xA9, 0xE8, 0xE0, 0x3D, 0xBE, 0xED, 0x99, 0x33, 0x4D, 0x41,
    0x66, 0x1B, 0x8A, 0x84, 0x17, 0x07, 0x4F, 0x33, 0x5A, 0xB1, 0x84, 0x5F, 0x6C, 0xC8, 0x52, 0xAD,
    0xB8, 0xC0, 0x1D, 0x98, 0x20, 0xFC, 0xF8, 0xE1, 0x06, 0x99, 0xCC, 0x82, 0x7A, 0x8F, 0xBD, 0xCA,
    0x2C, 0xBD, 0x46, 0xCC, 0x66, 0xE4, 0xE6, 0xB7, 0xBA, 0x41, 0xEC, 0x3E, 0xFA, 0x73, 0x35, 0x87,
    0xE4, 0xA3, 0x0E, 0xC5, 0x52, 0xCD, 0x8D, 0xDA, 0xB8, 0x16, 0x3E, 0x14, 0x8E, 0x50, 0xF4, 0xD0,
    0x90, 0x78, 0x28, 0x97, 0xF3, 0xDD, 0xAC, 0x84, 0xA4, 0x1E, 0x1F, 0xCF, 0xE8, 0xC5, 0x6B, 0x61,
    0x52, 0xC0, 0x09, 0x7B, 0x0D, 0x63, 0x4B, 0x41, 0x01, 0x14, 0x71, 0xFF, 0xD0, 0x04, 0xF4, 0x3E,
    0xB4, 0xAA, 0xFC, 0x03, 0x81, 0x97, 0xEC, 0x6B, 0xAE, 0x2B, 0x44, 0x70, 0xE8, 0x69, 0xBD, 0xED
};
static const uint8_t Vector_P256_SHA512_PrivateKey[] =
{
    0x9D, 0xD0, 0xD3, 0xA3, 0xD5, 0x14, 0xC2, 0xA8, 0xAD, 0xB1, 0x62, 0xB8, 0x1E, 0x3A, 0xDF, 0xBA,
    0x32, 0x99, 0x30, 0x9F, 0x7D, 0x20, 0x18, 0xF6, 0x07, 0xBD, 0xB1, 0x5B, 0x1A, 0x25, 0xF4, 0x99
};
static const uint8_t Vector_P256_SHA512_PublicKeyX[] =
{
    0x6B, 0x73, 0x8D, 0xE3, 0x39, 0x8B, 0x6A, 0xC5, 0x7B, 0x95, 0x91, 0xF9, 0xD7, 0x98, 0x5D, 0xD4,
    0xF3, 0x21, 0x37, 0xAD, 0x34, 0x60, 0xDC, 0xF8, 0x97, 0x0C, 0x13, 0x90, 0xCB, 0x9E, 0xAF, 0x8D
};
static const uint8_t Vector_P256_SHA512_PublicKeyY[] =
{
    0x83, 0xBC, 0x61, 0xE2, 0x6D, 0x2B, 0xBB, 0xD3, 0xCF, 0x2D, 0x2A, 0xB4, 0x45, 0xA2, 0xBC, 0x4A,
    0xB5, 0xDD, 0xE4, 0x1F, 0x4A, 0x13, 0x07, 0x8F, 0xD1, 0xD3, 0xCC, 0x36, 0xAB, 0x59, 0x6D, 0x57
};
static const uint8_t Vector_P256_SHA512_SignatureR[] =
{
    0x27, 0x5F, 0xA7, 0x60, 0x87, 0x8B, 0x4D, 0xC0, 0x5E, 0x9D, 0x15, 0x7F, 0xED, 0xFD, 0x8E, 0x9B,
    0x1C, 0x9C, 0x86, 0x12, 0x22, 0xA7, 0x12, 0x74, 0x8C, 0xB4, 0xB7, 0x75, 0x4C, 0x04, 0x3F, 0xB1
};
static const uint8_t Vector_P256_SHA512_SignatureS[] =
{
    0x69, 0x9D, 0x90, 0x6B, 0xB8, 0x43, 0x5A, 0x05, 0x34, 0x5A, 0xF3, 0xB3, 0x7E, 0x3B, 0x35, 0x77,
    0x86, 0x93, 0x9E, 0x94, 0xCA, 0xAE, 0x25, 0x78, 0x52, 0xF0, 0x50, 0x3A, 0xDB, 0x1E, 0x0F, 0x7E
};
#endif /* EIP130_ENABLE_SYM_ALGO_SHA512 */


// [P-384,SHA-1] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P384_SHA1_Message[] =
{
    0xAB, 0xE1, 0x0A, 0xCE, 0x13, 0xE7, 0xE1, 0xD9, 0x18, 0x6C, 0x48, 0xF7, 0x88, 0x9D, 0x51, 0x47,
    0x3D, 0x3A, 0x09, 0x61, 0x98, 0x4B, 0xC8, 0x72, 0xDF, 0x70, 0x8E, 0xCC, 0x3E, 0xD3, 0xB8, 0x16,
    0x9D, 0x01, 0xE3, 0xD9, 0x6F, 0xC4, 0xF1, 0xD5, 0xEA, 0x00, 0xA0, 0x36, 0x92, 0xBC, 0xC5, 0xCF,
    0xFD, 0x53, 0x78, 0x7C, 0x88, 0xB9, 0x34, 0xAF, 0x40, 0x4C, 0x03, 0x9D, 0x32, 0x89, 0xB5, 0xBA,
    0xC5, 0xAE, 0x7D, 0xB1, 0x49, 0x68, 0x75, 0xB5, 0xDC, 0x73, 0xC3, 0x09, 0xF9, 0x25, 0xC1, 0x3D,
    0x1C, 0x01, 0xAB, 0xDA, 0xAF, 0xEB, 0xCD, 0xAC, 0x2C, 0xEE, 0x43, 0x39, 0x39, 0xCE, 0x8D, 0x4A,
    0x0A, 0x5D, 0x57, 0xBB, 0x70, 0x5F, 0x3B, 0xF6, 0xEC, 0x08, 0x47, 0x95, 0x11, 0xD4, 0xB4, 0xA3,
    0x21, 0x1F, 0x61, 0x64, 0x9A, 0xD6, 0x27, 0x43, 0x14, 0xBF, 0x0D, 0x43, 0x8A, 0x81, 0xE0, 0x60
};
static const uint8_t Vector_P384_SHA1_PrivateKey[] =
{
    0xA4, 0x92, 0xCE, 0x8F, 0xA9, 0x00, 0x84, 0xC2, 0x27, 0xE1, 0xA3, 0x2F, 0x79, 0x74, 0xD3, 0x9E,
    0x9F, 0xF6, 0x7A, 0x7E, 0x87, 0x05, 0xEC, 0x34, 0x19, 0xB3, 0x5F, 0xB6, 0x07, 0x58, 0x2B, 0xEB,
    0xD4, 0x61, 0xE0, 0xB1, 0x52, 0x0A, 0xC7, 0x6E, 0xC2, 0xDD, 0x4E, 0x9B, 0x63, 0xEB, 0xAE, 0x71
};
static const uint8_t Vector_P384_SHA1_PublicKeyX[] =
{
    0xE5, 0x5F, 0xEE, 0x6C, 0x49, 0xD8, 0xD5, 0x23, 0xF5, 0xCE, 0x7B, 0xF9, 0xC0, 0x42, 0x5C, 0xE4,
    0xFF, 0x65, 0x07, 0x08, 0xB7, 0xDE, 0x5C, 0xFB, 0x09, 0x59, 0x01, 0x52, 0x39, 0x79, 0xA7, 0xF0,
    0x42, 0x60, 0x2D, 0xB3, 0x08, 0x54, 0x73, 0x53, 0x69, 0x81, 0x3B, 0x5C, 0x3F, 0x5E, 0xF8, 0x68
};
static const uint8_t Vector_P384_SHA1_PublicKeyY[] =
{
    0x28, 0xF5, 0x9C, 0xC5, 0xDC, 0x50, 0x98, 0x92, 0xA9, 0x88, 0xD3, 0x8A, 0x8E, 0x25, 0x19, 0xDE,
    0x3D, 0x0C, 0x4F, 0xD0, 0xFB, 0xDB, 0x09, 0x93, 0xE3, 0x8F, 0x18, 0x50, 0x6C, 0x17, 0x60, 0x6C,
    0x5E, 0x24, 0x24, 0x92, 0x46, 0xF1, 0xCE, 0x94, 0x98, 0x3A, 0x53, 0x61, 0xC5, 0xBE, 0x98, 0x3E
};
static const uint8_t Vector_P384_SHA1_SignatureR[] =
{
    0x68, 0x20, 0xB8, 0x58, 0x52, 0x04, 0x64, 0x8A, 0xED, 0x63, 0xBD, 0xFF, 0x47, 0xF6, 0xD9, 0xAC,
    0xEB, 0xDE, 0xA6, 0x29, 0x44, 0x77, 0x4A, 0x7D, 0x14, 0xF0, 0xE1, 0x4A, 0xA0, 0xB9, 0xA5, 0xB9,
    0x95, 0x45, 0xB2, 0xDA, 0xEE, 0x6B, 0x3C, 0x74, 0xEB, 0xF6, 0x06, 0x66, 0x7A, 0x3F, 0x39, 0xB7
};
static const uint8_t Vector_P384_SHA1_SignatureS[] =
{
    0x49, 0x1A, 0xF1, 0xD0, 0xCC, 0xCD, 0x56, 0xDD, 0xD5, 0x20, 0xB2, 0x33, 0x77, 0x5D, 0x0B, 0xC6,
    0xB4, 0x0A, 0x62, 0x55, 0xCC, 0x55, 0x20, 0x7D, 0x8E, 0x93, 0x56, 0x74, 0x1F, 0x23, 0xC9, 0x6C,
    0x14, 0x71, 0x42, 0x21, 0x07, 0x8D, 0xBD, 0x5C, 0x17, 0xF4, 0xFD, 0xD8, 0x9B, 0x32, 0xA9, 0x07
};

// [P-384,SHA-224] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P384_SHA224_Message[] =
{
    0x39, 0xF0, 0xB2, 0x5D, 0x4C, 0x15, 0xB0, 0x9A, 0x06, 0x92, 0xB2, 0x2F, 0xBA, 0xCB, 0xB5, 0xF8,
    0xAE, 0xE1, 0x84, 0xCB, 0x75, 0x88, 0x7E, 0x2E, 0xBE, 0x0C, 0xD3, 0xBE, 0x5D, 0x38, 0x15, 0xD2,
    0x9F, 0x9B, 0x58, 0x7E, 0x10, 0xB3, 0x16, 0x8C, 0x93, 0x90, 0x54, 0xA8, 0x9D, 0xF1, 0x10, 0x68,
    0xE5, 0xC3, 0xFA, 0xC2, 0x1A, 0xF7, 0x42, 0xBF, 0x4C, 0x3E, 0x95, 0x12, 0xF5, 0x56, 0x96, 0x74,
    0xE7, 0xAD, 0x8B, 0x39, 0x04, 0x2B, 0xCD, 0x73, 0xE4, 0xB7, 0xCE, 0x3E, 0x64, 0xFB, 0xEA, 0x1C,
    0x43, 0x4E, 0xD0, 0x1A, 0xD4, 0xAD, 0x8B, 0x5B, 0x56, 0x9F, 0x6A, 0x0B, 0x9A, 0x11, 0x44, 0xF9,
    0x40, 0x97, 0x92, 0x56, 0x72, 0xE5, 0x9B, 0xA9, 0x7B, 0xC4, 0xD3, 0x3B, 0xE2, 0xFA, 0x21, 0xB4,
    0x6C, 0x3D, 0xAD, 0xBF, 0xB3, 0xA1, 0xF8, 0x9A, 0xFA, 0x19, 0x9D, 0x4B, 0x44, 0x18, 0x99, 0x38
};
static const uint8_t Vector_P384_SHA224_PrivateKey[] =
{
    0x0A, 0xF8, 0x57, 0xBE, 0xFF, 0x08, 0x04, 0x6F, 0x23, 0xB0, 0x3C, 0x42, 0x99, 0xED, 0xA8, 0x64,
    0x90, 0x39, 0x3B, 0xDE, 0x88, 0xE4, 0xF7, 0x43, 0x48, 0x88, 0x6B, 0x20, 0x05, 0x55, 0x27, 0x6B,
    0x93, 0xB3, 0x7D, 0x4F, 0x6F, 0xDE, 0xC1, 0x7C, 0x0E, 0xA5, 0x81, 0xA3, 0x0C, 0x59, 0xC7, 0x27
};
static const uint8_t Vector_P384_SHA224_PublicKeyX[] =
{
    0x00, 0xEA, 0x9D, 0x10, 0x9D, 0xBA, 0xA3, 0x90, 0x04, 0x61, 0xA9, 0x23, 0x64, 0x53, 0x95, 0x2B,
    0x1F, 0x1C, 0x2A, 0x5A, 0xA1, 0x2F, 0x6D, 0x50, 0x0A, 0xC7, 0x74, 0xAC, 0xDF, 0xF8, 0x4A, 0xB7,
    0xCB, 0x71, 0xA0, 0xF9, 0x1B, 0xCD, 0x55, 0xAA, 0xA5, 0x7C, 0xB8, 0xB4, 0xFB, 0xB3, 0x08, 0x7D
};
static const uint8_t Vector_P384_SHA224_PublicKeyY[] =
{
    0x0F, 0xC0, 0xE3, 0x11, 0x6C, 0x9E, 0x94, 0xBE, 0x58, 0x3B, 0x02, 0xB2, 0x1B, 0x1E, 0xB1, 0x68,
    0xD8, 0xFA, 0xCF, 0x39, 0x55, 0x27, 0x93, 0x60, 0xCB, 0xCD, 0x86, 0xE0, 0x4E, 0xE5, 0x07, 0x51,
    0x05, 0x4C, 0xFA, 0xEB, 0xCF, 0x54, 0x25, 0x38, 0xAC, 0x11, 0x3D, 0x56, 0xCC, 0xC3, 0x8B, 0x3E
};
static const uint8_t Vector_P384_SHA224_SignatureR[] =
{
    0xC3, 0x6E, 0x5F, 0x0D, 0x3D, 0xE7, 0x14, 0x11, 0xE6, 0xE5, 0x19, 0xF6, 0x3E, 0x0F, 0x56, 0xCF,
    0xF4, 0x32, 0x33, 0x0A, 0x04, 0xFE, 0xFE, 0xF2, 0x99, 0x3F, 0xDB, 0x56, 0x34, 0x3E, 0x49, 0xF2,
    0xF7, 0xDB, 0x5F, 0xCA, 0xB7, 0x72, 0x8A, 0xCC, 0x1E, 0x33, 0xD4, 0x69, 0x25, 0x53, 0xC0, 0x2E
};
static const uint8_t Vector_P384_SHA224_SignatureS[] =
{
    0x0D, 0x40, 0x64, 0x39, 0x9D, 0x58, 0xCD, 0x77, 0x1A, 0xB9, 0x42, 0x0D, 0x43, 0x87, 0x57, 0xF5,
    0x93, 0x6C, 0x38, 0x08, 0xE9, 0x70, 0x81, 0xE4, 0x57, 0xBC, 0x86, 0x2A, 0x0C, 0x90, 0x52, 0x95,
    0xDC, 0xA6, 0x0E, 0xE9, 0x4F, 0x45, 0x37, 0x59, 0x1C, 0x6C, 0x7D, 0x21, 0x74, 0x53, 0x90, 0x9B
};

// [P-384,SHA-256] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P384_SHA256_Message[] =
{
    0x66, 0x3B, 0x12, 0xEB, 0xF4, 0x4B, 0x7E, 0xD3, 0x87, 0x2B, 0x38, 0x54, 0x77, 0x38, 0x1F, 0x4B,
    0x11, 0xAD, 0xEB, 0x0A, 0xEC, 0x9E, 0x0E, 0x24, 0x78, 0x77, 0x63, 0x13, 0xD5, 0x36, 0x37, 0x6D,
    0xC8, 0xFD, 0x5F, 0x3C, 0x71, 0x5B, 0xB6, 0xDD, 0xF3, 0x2C, 0x01, 0xEE, 0x1D, 0x6F, 0x8B, 0x73,
    0x17, 0x85, 0x73, 0x2C, 0x0D, 0x84, 0x41, 0xDF, 0x63, 0x6D, 0x81, 0x45, 0x57, 0x7E, 0x7B, 0x31,
    0x38, 0xE4, 0x3C, 0x32, 0xA6, 0x1B, 0xC1, 0x24, 0x2E, 0x0E, 0x73, 0xD6, 0x2D, 0x62, 0x4C, 0xDC,
    0x92, 0x48, 0x56, 0x07, 0x6B, 0xDB, 0xBF, 0x1E, 0xC0, 0x4A, 0xD4, 0x42, 0x07, 0x32, 0xEF, 0x0C,
    0x53, 0xD4, 0x24, 0x79, 0xA0, 0x82, 0x35, 0xFC, 0xFC, 0x4D, 0xB4, 0xD8, 0x69, 0xC4, 0xEB, 0x28,
    0x28, 0xC7, 0x39, 0x28, 0xCD, 0xC3, 0xE3, 0x75, 0x83, 0x62, 0xD1, 0xB7, 0x70, 0x80, 0x99, 0x97
};
static const uint8_t Vector_P384_SHA256_PrivateKey[] =
{
    0xC6, 0x02, 0xBC, 0x74, 0xA3, 0x45, 0x92, 0xC3, 0x11, 0xA6, 0x56, 0x96, 0x61, 0xE0, 0x83, 0x2C,
    0x84, 0xF7, 0x20, 0x72, 0x74, 0x67, 0x6C, 0xC4, 0x2A, 0x89, 0xF0, 0x58, 0x16, 0x26, 0x30, 0x18,
    0x4B, 0x52, 0xF0, 0xD9, 0x9B, 0x85, 0x5A, 0x77, 0x83, 0xC9, 0x87, 0x47, 0x6D, 0x7F, 0x9E, 0x6B
};
static const uint8_t Vector_P384_SHA256_PublicKeyX[] =
{
    0x04, 0x00, 0x19, 0x3B, 0x21, 0xF0, 0x7C, 0xD0, 0x59, 0x82, 0x6E, 0x94, 0x53, 0xD3, 0xE9, 0x6D,
    0xD1, 0x45, 0x04, 0x1C, 0x97, 0xD4, 0x9F, 0xF6, 0xB7, 0x04, 0x7F, 0x86, 0xBB, 0x0B, 0x04, 0x39,
    0xE9, 0x09, 0x27, 0x4C, 0xB9, 0xC2, 0x82, 0xBF, 0xAB, 0x88, 0x67, 0x4C, 0x07, 0x65, 0xBC, 0x75
};
static const uint8_t Vector_P384_SHA256_PublicKeyY[] =
{
    0xF7, 0x0D, 0x89, 0xC5, 0x2A, 0xCB, 0xC7, 0x04, 0x68, 0xD2, 0xC5, 0xAE, 0x75, 0xC7, 0x6D, 0x7F,
    0x69, 0xB7, 0x6A, 0xF6, 0x2D, 0xCF, 0x95, 0xE9, 0x9E, 0xBA, 0x5D, 0xD1, 0x1A, 0xDF, 0x8F, 0x42,
    0xEC, 0x9A, 0x42, 0x5B, 0x0C, 0x5E, 0xC9, 0x8E, 0x2F, 0x23, 0x4A, 0x92, 0x6B, 0x82, 0xA1, 0x47
};
static const uint8_t Vector_P384_SHA256_SignatureR[] =
{
    0xB1, 0x1D, 0xB0, 0x0C, 0xDA, 0xF5, 0x32, 0x86, 0xD4, 0x48, 0x3F, 0x38, 0xCD, 0x02, 0x78, 0x59,
    0x48, 0x47, 0x7E, 0xD7, 0xEB, 0xC2, 0xAD, 0x60, 0x90, 0x54, 0x55, 0x1D, 0xA0, 0xAB, 0x03, 0x59,
    0x97, 0x8C, 0x61, 0x85, 0x17, 0x88, 0xAA, 0x2E, 0xC3, 0x26, 0x79, 0x46, 0xD4, 0x40, 0xE8, 0x78
};
static const uint8_t Vector_P384_SHA256_SignatureS[] =
{
    0x16, 0x00, 0x78, 0x73, 0xC5, 0xB0, 0x60, 0x4C, 0xE6, 0x81, 0x12, 0xA8, 0xFE, 0xE9, 0x73, 0xE8,
    0xE2, 0xB6, 0xE3, 0x31, 0x9C, 0x68, 0x3A, 0x76, 0x2F, 0xF5, 0x06, 0x5A, 0x07, 0x65, 0x12, 0xD7,
    0xC9, 0x8B, 0x27, 0xE7, 0x4B, 0x78, 0x87, 0x67, 0x10, 0x48, 0xAC, 0x02, 0x7D, 0xF8, 0xCB, 0xF2
};

#ifdef EIP130_ENABLE_SYM_ALGO_SHA512
// [P-384,SHA-384] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P384_SHA384_Message[] =
{
    0x6B, 0x45, 0xD8, 0x80, 0x37, 0x39, 0x2E, 0x13, 0x71, 0xD9, 0xFD, 0x1C, 0xD1, 0x74, 0xE9, 0xC1,
    0x83, 0x8D, 0x11, 0xC3, 0xD6, 0x13, 0x3D, 0xC1, 0x7E, 0x65, 0xFA, 0x0C, 0x48, 0x5D, 0xCC, 0xA9,
    0xF5, 0x2D, 0x41, 0xB6, 0x01, 0x61, 0x24, 0x60, 0x39, 0xE4, 0x2E, 0xC7, 0x84, 0xD4, 0x94, 0x00,
    0xBF, 0xFD, 0xB5, 0x14, 0x59, 0xF5, 0xDE, 0x65, 0x40, 0x91, 0x30, 0x1A, 0x09, 0x37, 0x8F, 0x93,
    0x46, 0x4D, 0x52, 0x11, 0x8B, 0x48, 0xD4, 0x4B, 0x30, 0xD7, 0x81, 0xEB, 0x1D, 0xBE, 0xD0, 0x9D,
    0xA1, 0x1F, 0xB4, 0xC8, 0x18, 0xDB, 0xD4, 0x42, 0xD1, 0x61, 0xAB, 0xA4, 0xB9, 0xED, 0xC7, 0x9F,
    0x05, 0xE4, 0xB7, 0xE4, 0x01, 0x65, 0x13, 0x95, 0xB5, 0x3B, 0xD8, 0xB5, 0xBD, 0x3F, 0x2A, 0xAA,
    0x6A, 0x00, 0x87, 0x7F, 0xA9, 0xB4, 0x5C, 0xAD, 0xB8, 0xE6, 0x48, 0x55, 0x0B, 0x4C, 0x6C, 0xBE
};
static const uint8_t Vector_P384_SHA384_PrivateKey[] =
{
    0x20, 0x1B, 0x43, 0x2D, 0x8D, 0xF1, 0x43, 0x24, 0x18, 0x2D, 0x62, 0x61, 0xDB, 0x3E, 0x4B, 0x3F,
    0x46, 0xA8, 0x28, 0x44, 0x82, 0xD5, 0x2E, 0x37, 0x0D, 0xA4, 0x1E, 0x6C, 0xBD, 0xF4, 0x5E, 0xC2,
    0x95, 0x2F, 0x5D, 0xB7, 0xCC, 0xBC, 0xE3, 0xBC, 0x29, 0x44, 0x9F, 0x4F, 0xB0, 0x80, 0xAC, 0x97
};
static const uint8_t Vector_P384_SHA384_PublicKeyX[] =
{
    0xC2, 0xB4, 0x79, 0x44, 0xFB, 0x5D, 0xE3, 0x42, 0xD0, 0x32, 0x85, 0x88, 0x01, 0x77, 0xCA, 0x5F,
    0x7D, 0x0F, 0x2F, 0xCA, 0xD7, 0x67, 0x8C, 0xCE, 0x42, 0x29, 0xD6, 0xE1, 0x93, 0x2F, 0xCA, 0xC1,
    0x1B, 0xFC, 0x3C, 0x3E, 0x97, 0xD9, 0x42, 0xA3, 0xC5, 0x6B, 0xF3, 0x41, 0x23, 0x01, 0x3D, 0xBF
};
static const uint8_t Vector_P384_SHA384_PublicKeyY[] =
{
    0x37, 0x25, 0x79, 0x06, 0xA8, 0x22, 0x38, 0x66, 0xED, 0xA0, 0x74, 0x3C, 0x51, 0x96, 0x16, 0xA7,
    0x6A, 0x75, 0x8A, 0xE5, 0x8A, 0xEE, 0x81, 0xC5, 0xFD, 0x35, 0xFB, 0xF3, 0xA8, 0x55, 0xB7, 0x75,
    0x4A, 0x36, 0xD4, 0xA0, 0x67, 0x2D, 0xF9, 0x5D, 0x6C, 0x44, 0xA8, 0x1C, 0xF7, 0x62, 0x0C, 0x2D
};
static const uint8_t Vector_P384_SHA384_SignatureR[] =
{
    0x50, 0x83, 0x5A, 0x92, 0x51, 0xBA, 0xD0, 0x08, 0x10, 0x61, 0x77, 0xEF, 0x00, 0x4B, 0x09, 0x1A,
    0x1E, 0x42, 0x35, 0xCD, 0x0D, 0xA8, 0x4F, 0xFF, 0x54, 0x54, 0x2B, 0x0E, 0xD7, 0x55, 0xC1, 0xD6,
    0xF2, 0x51, 0x60, 0x9D, 0x14, 0xEC, 0xF1, 0x8F, 0x9E, 0x1D, 0xDF, 0xE6, 0x9B, 0x94, 0x6E, 0x32
};
static const uint8_t Vector_P384_SHA384_SignatureS[] =
{
    0x04, 0x75, 0xF3, 0xD3, 0x0C, 0x64, 0x63, 0xB6, 0x46, 0xE8, 0xD3, 0xBF, 0x24, 0x55, 0x83, 0x03,
    0x14, 0x61, 0x1C, 0xBD, 0xE4, 0x04, 0xBE, 0x51, 0x8B, 0x14, 0x46, 0x4F, 0xDB, 0x19, 0x5F, 0xDC,
    0xC9, 0x2E, 0xB2, 0x22, 0xE6, 0x1F, 0x42, 0x6A, 0x4A, 0x59, 0x2C, 0x00, 0xA6, 0xA8, 0x97, 0x21
};

// [P-384,SHA-512] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P384_SHA512_Message[] =
{
    0x67, 0xD9, 0xEB, 0x88, 0xF2, 0x89, 0x45, 0x4D, 0x61, 0xDE, 0xF4, 0x76, 0x4D, 0x15, 0x73, 0xDB,
    0x49, 0xB8, 0x75, 0xCF, 0xB1, 0x1E, 0x13, 0x9D, 0x7E, 0xAC, 0xC4, 0xB7, 0xA7, 0x9D, 0x3D, 0xB3,
    0xBF, 0x72, 0x08, 0x19, 0x1B, 0x2B, 0x20, 0x78, 0xCB, 0xBC, 0xC9, 0x74, 0xEC, 0x0D, 0xA1, 0xED,
    0x5E, 0x0C, 0x10, 0xEC, 0x37, 0xF6, 0x18, 0x1B, 0xF8, 0x1C, 0x0F, 0x32, 0x97, 0x2A, 0x12, 0x5D,
    0xF6, 0x4E, 0x3B, 0x3E, 0x1D, 0x83, 0x8E, 0xC7, 0xDA, 0x8D, 0xFE, 0x0B, 0x7F, 0xCC, 0x91, 0x1E,
    0x43, 0x15, 0x9A, 0x79, 0xC7, 0x3D, 0xF5, 0xFA, 0x25, 0x2B, 0x98, 0x79, 0x0B, 0xE5, 0x11, 0xD8,
    0xA7, 0x32, 0xFC, 0xBF, 0x01, 0x1A, 0xAC, 0xC7, 0xD4, 0x5D, 0x80, 0x27, 0xD5, 0x0A, 0x34, 0x77,
    0x03, 0xD6, 0x13, 0xCE, 0xDA, 0x09, 0xF6, 0x50, 0xC6, 0x10, 0x4C, 0x94, 0x59, 0x53, 0x7C, 0x8F
};
static const uint8_t Vector_P384_SHA512_PrivateKey[] =
{
    0x21, 0x7A, 0xFB, 0xA4, 0x06, 0xD8, 0xAB, 0x32, 0xEE, 0x07, 0xB0, 0xF2, 0x7E, 0xEF, 0x78, 0x9F,
    0xC2, 0x01, 0xD1, 0x21, 0xFF, 0xAB, 0x76, 0xC8, 0xFB, 0xE3, 0xC2, 0xD3, 0x52, 0xC5, 0x94, 0x90,
    0x9A, 0xBE, 0x59, 0x1C, 0x6F, 0x86, 0x23, 0x39, 0x92, 0x36, 0x2C, 0x9D, 0x63, 0x1B, 0xAF, 0x7C
};
static const uint8_t Vector_P384_SHA512_PublicKeyX[] =
{
    0xFB, 0x93, 0x7E, 0x4A, 0x30, 0x36, 0x17, 0xB7, 0x1B, 0x6C, 0x1A, 0x25, 0xF2, 0xAC, 0x78, 0x60,
    0x87, 0x32, 0x8A, 0x3E, 0x26, 0xBD, 0xEF, 0x55, 0xE5, 0x2D, 0x46, 0xAB, 0x5E, 0x69, 0xE5, 0x41,
    0x1B, 0xF9, 0xFC, 0x55, 0xF5, 0xDF, 0x99, 0x94, 0xD2, 0xBF, 0x82, 0xE8, 0xF3, 0x9A, 0x15, 0x3E
};
static const uint8_t Vector_P384_SHA512_PublicKeyY[] =
{
    0xA9, 0x7D, 0x90, 0x75, 0xE9, 0x2F, 0xA5, 0xBF, 0xE6, 0x7E, 0x6E, 0xC1, 0x8E, 0x21, 0xCC, 0x4D,
    0x11, 0xFD, 0xE5, 0x9A, 0x68, 0xAE, 0xF7, 0x2C, 0x0E, 0x46, 0xA2, 0x8F, 0x31, 0xA9, 0xD6, 0x03,
    0x85, 0xF4, 0x1F, 0x39, 0xDA, 0x46, 0x8F, 0x4E, 0x6C, 0x3D, 0x3F, 0xBA, 0xC9, 0x04, 0x67, 0x65
};
static const uint8_t Vector_P384_SHA512_SignatureR[] =
{
    0xC2, 0x69, 0xD9, 0xC4, 0x61, 0x9A, 0xAF, 0xDF, 0x5F, 0x4B, 0x31, 0x00, 0x21, 0x1D, 0xDD, 0xB1,
    0x46, 0x93, 0xAB, 0xE2, 0x55, 0x51, 0xE0, 0x4F, 0x94, 0x99, 0xC9, 0x11, 0x52, 0xA2, 0x96, 0xD7,
    0x44, 0x9C, 0x08, 0xB3, 0x6F, 0x87, 0xD1, 0xE1, 0x6E, 0x8E, 0x15, 0xFE, 0xE4, 0xA7, 0xF5, 0xC8
};
static const uint8_t Vector_P384_SHA512_SignatureS[] =
{
    0x77, 0xFF, 0xED, 0x5C, 0x61, 0x66, 0x51, 0x52, 0xD5, 0x21, 0x61, 0xDC, 0x13, 0xAC, 0x3F, 0xBA,
    0xE5, 0x78, 0x69, 0x28, 0xA3, 0xD7, 0x36, 0xF4, 0x2D, 0x34, 0xA9, 0xE4, 0xD6, 0xD4, 0xA7, 0x0A,
    0x02, 0xD5, 0xAF, 0x90, 0xFA, 0x37, 0xA2, 0x3A, 0x31, 0x89, 0x02, 0xAE, 0x26, 0x56, 0xC0, 0x71
};
#endif /* EIP130_ENABLE_SYM_ALGO_SHA512 */

// [P-521,SHA-1] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P521_SHA1_Message[] =
{
    0x50, 0x3F, 0x79, 0x39, 0x34, 0x0A, 0xC7, 0x23, 0xCD, 0x4A, 0x2F, 0x4E, 0x6C, 0xCC, 0x27, 0x33,
    0x38, 0x3A, 0xCA, 0x2F, 0xBA, 0x90, 0x02, 0x19, 0x9D, 0x9E, 0x1F, 0x94, 0x8B, 0xE0, 0x41, 0x21,
    0x07, 0xA3, 0xFD, 0xD5, 0x14, 0xD9, 0x0C, 0xD4, 0xF3, 0x7C, 0xC3, 0xAC, 0x62, 0xEF, 0x00, 0x3A,
    0x2D, 0xB1, 0xD9, 0x65, 0x7A, 0xB7, 0x7F, 0xE7, 0x55, 0xBF, 0x71, 0xFA, 0x59, 0xE4, 0xD9, 0x6E,
    0xA7, 0x2A, 0xE7, 0xBF, 0x9D, 0xE8, 0x7D, 0x79, 0x34, 0x3B, 0xC1, 0xA4, 0xBB, 0x14, 0x4D, 0x16,
    0x28, 0xD1, 0xE9, 0xE9, 0xC8, 0xED, 0x80, 0x8B, 0x96, 0x2C, 0x54, 0xE5, 0xF9, 0x6D, 0x53, 0xDA,
    0x14, 0x7A, 0x96, 0x38, 0xF9, 0x4A, 0x91, 0x75, 0xD8, 0xED, 0x61, 0x05, 0x5F, 0x0B, 0xA5, 0x73,
    0xA8, 0x2B, 0xB7, 0xE0, 0x18, 0xEE, 0xDA, 0xC4, 0xEA, 0x7B, 0x36, 0x2E, 0xC8, 0x9C, 0x38, 0x2B
};
static const uint8_t Vector_P521_SHA1_PrivateKey[] =
{
    0x01, 0xBD, 0x56, 0xBD, 0x10, 0x61, 0x18, 0xED, 0xA2, 0x46, 0x15, 0x5B, 0xD4, 0x3B, 0x42, 0xB8,
    0xE1, 0x3F, 0x0A, 0x6E, 0x25, 0xDD, 0x3B, 0xB3, 0x76, 0x02, 0x6F, 0xAB, 0x4D, 0xC9, 0x2B, 0x61,
    0x57, 0xBC, 0x6D, 0xFE, 0xC2, 0xD1, 0x5D, 0xD3, 0xD0, 0xCF, 0x2A, 0x39, 0xAA, 0x68, 0x49, 0x40,
    0x42, 0xAF, 0x48, 0xBA, 0x96, 0x01, 0x11, 0x8D, 0xA8, 0x2C, 0x6F, 0x21, 0x08, 0xA3, 0xA2, 0x03,
    0xAD, 0x74
};
static const uint8_t Vector_P521_SHA1_PublicKeyX[] =
{
    0x01, 0x2F, 0xBC, 0xAE, 0xFF, 0xA6, 0xA5, 0x1F, 0x3E, 0xE4, 0xD3, 0xD2, 0xB5, 0x1C, 0x5D, 0xEC,
    0x6D, 0x7C, 0x72, 0x6C, 0xA3, 0x53, 0xFC, 0x01, 0x4E, 0xA2, 0xBF, 0x7C, 0xFB, 0xB9, 0xB9, 0x10,
    0xD3, 0x2C, 0xBF, 0xA6, 0xA0, 0x0F, 0xE3, 0x9B, 0x6C, 0xDB, 0x89, 0x46, 0xF2, 0x27, 0x75, 0x39,
    0x8B, 0x2E, 0x23, 0x3C, 0x0C, 0xF1, 0x44, 0xD7, 0x8C, 0x8A, 0x77, 0x42, 0xB5, 0xC7, 0xA3, 0xBB,
    0x5D, 0x23
};
static const uint8_t Vector_P521_SHA1_PublicKeyY[] =
{
    0x00, 0x9C, 0xDE, 0xF8, 0x23, 0xDD, 0x7B, 0xF9, 0xA7, 0x9E, 0x8C, 0xCE, 0xAC, 0xD2, 0xE4, 0x52,
    0x7C, 0x23, 0x1D, 0x0A, 0xE5, 0x96, 0x7A, 0xF0, 0x95, 0x8E, 0x93, 0x1D, 0x7D, 0xDC, 0xCF, 0x28,
    0x05, 0xA3, 0xE6, 0x18, 0xDC, 0x30, 0x39, 0xFE, 0xC9, 0xFE, 0xBB, 0xD3, 0x30, 0x52, 0xFE, 0x4C,
    0x0F, 0xEE, 0x98, 0xF0, 0x33, 0x10, 0x60, 0x64, 0x98, 0x2D, 0x88, 0xF4, 0xE0, 0x35, 0x49, 0xD4,
    0xA6, 0x4D,
};
static const uint8_t Vector_P521_SHA1_SignatureR[] =
{
    0x00, 0xBD, 0x11, 0x7B, 0x48, 0x07, 0x71, 0x08, 0x98, 0xF9, 0xDD, 0x77, 0x78, 0x05, 0x64, 0x85,
    0x77, 0x76, 0x68, 0xF0, 0xE7, 0x8E, 0x6D, 0xDF, 0x5B, 0x00, 0x03, 0x56, 0x12, 0x1E, 0xB7, 0xA2,
    0x20, 0xE9, 0x49, 0x3C, 0x7F, 0x9A, 0x57, 0xC0, 0x77, 0x94, 0x7F, 0x89, 0xAC, 0x45, 0xD5, 0xAC,
    0xB6, 0x66, 0x1B, 0xBC, 0xD1, 0x7A, 0xBB, 0x3F, 0xAE, 0xA1, 0x49, 0xBA, 0x0A, 0xA3, 0xBB, 0x15,
    0x21, 0xBE
};
static const uint8_t Vector_P521_SHA1_SignatureS[] =
{
    0x00, 0x19, 0xCD, 0x2C, 0x5C, 0x3F, 0x98, 0x70, 0xEC, 0xDE, 0xB9, 0xB3, 0x23, 0xAB, 0xDF, 0x3A,
    0x98, 0xCD, 0x5E, 0x23, 0x1D, 0x85, 0xC6, 0xDD, 0xC5, 0xB7, 0x1A, 0xB1, 0x90, 0x73, 0x9F, 0x7F,
    0x22, 0x6E, 0x6B, 0x13, 0x4B, 0xA1, 0xD5, 0x88, 0x9D, 0xDE, 0xB2, 0x75, 0x1D, 0xAB, 0xD9, 0x79,
    0x11, 0xDF, 0xF9, 0x0C, 0x34, 0x68, 0x4C, 0xDB, 0xE7, 0xBB, 0x66, 0x9B, 0x6C, 0x3D, 0x22, 0xF2,
    0x48, 0x0C
};

// [P-521,SHA-224] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P521_SHA224_Message[] =
{
    0x58, 0xEC, 0x2B, 0x2C, 0xEB, 0x80, 0x20, 0x7F, 0xF5, 0x1B, 0x17, 0x68, 0x8B, 0xD5, 0x85, 0x0F,
    0x93, 0x88, 0xCE, 0x0B, 0x4A, 0x4F, 0x73, 0x16, 0xF5, 0xAF, 0x6F, 0x52, 0xCF, 0xC4, 0xDD, 0xE4,
    0x19, 0x2B, 0x6D, 0xBD, 0x97, 0xB5, 0x6F, 0x93, 0xD1, 0xE4, 0x07, 0x35, 0x17, 0xAC, 0x6C, 0x61,
    0x40, 0x42, 0x9B, 0x54, 0x84, 0xE2, 0x66, 0xD0, 0x71, 0x27, 0xE2, 0x8B, 0x8E, 0x61, 0x3D, 0xDF,
    0x65, 0x88, 0x8C, 0xBD, 0x52, 0x42, 0xB2, 0xF0, 0xEE, 0xE4, 0xD5, 0x75, 0x4E, 0xB1, 0x1F, 0x25,
    0xDF, 0xA5, 0xC3, 0xF8, 0x7C, 0x79, 0x0D, 0xE3, 0x71, 0x85, 0x6C, 0x88, 0x27, 0x31, 0xA1, 0x57,
    0x08, 0x3A, 0x00, 0xD8, 0xEA, 0xE2, 0x9A, 0x57, 0x88, 0x4D, 0xBB, 0xFC, 0xD9, 0x89, 0x22, 0xC1,
    0x2C, 0xF5, 0xD7, 0x30, 0x66, 0xDA, 0xAB, 0xE3, 0xBF, 0x3F, 0x42, 0xCF, 0xBD, 0xB9, 0xD8, 0x53
};
static const uint8_t Vector_P521_SHA224_PrivateKey[] =
{
    0x01, 0xD7, 0xBB, 0x86, 0x4C, 0x5B, 0x5E, 0xCA, 0xE0, 0x19, 0x29, 0x6C, 0xF9, 0xB5, 0xC6, 0x3A,
    0x16, 0x6F, 0x5F, 0x11, 0x13, 0x94, 0x28, 0x19, 0xB1, 0x93, 0x3D, 0x88, 0x9A, 0x96, 0xD1, 0x22,
    0x45, 0x77, 0x7A, 0x99, 0x42, 0x8F, 0x93, 0xDE, 0x4F, 0xC9, 0xA1, 0x8D, 0x70, 0x9B, 0xF9, 0x18,
    0x89, 0xD7, 0xF8, 0xDD, 0xDD, 0x52, 0x2B, 0x4C, 0x36, 0x4A, 0xEA, 0xE1, 0x3C, 0x98, 0x3E, 0x9F,
    0xAE, 0x46
};
static const uint8_t Vector_P521_SHA224_PublicKeyX[] =
{
    0x01, 0xA7, 0x59, 0x6D, 0x38, 0xAA, 0xC7, 0x86, 0x83, 0x27, 0xDD, 0xC1, 0xEF, 0x5E, 0x81, 0x78,
    0xCF, 0x05, 0x2B, 0x7E, 0xBC, 0x51, 0x28, 0x28, 0xE8, 0xA4, 0x59, 0x55, 0xD8, 0x5B, 0xEF, 0x49,
    0x49, 0x4D, 0x15, 0x27, 0x81, 0x98, 0xBB, 0xCC, 0x54, 0x54, 0x35, 0x8C, 0x12, 0xA2, 0xAF, 0x9A,
    0x38, 0x74, 0xE7, 0x00, 0x2E, 0x1A, 0x2F, 0x02, 0xFC, 0xB3, 0x6F, 0xF3, 0xE3, 0xB4, 0xBC, 0x0C,
    0x69, 0xE7
};
static const uint8_t Vector_P521_SHA224_PublicKeyY[] =
{
    0x01, 0x84, 0x90, 0x2E, 0x51, 0x59, 0x82, 0xBB, 0x22, 0x5B, 0x8C, 0x84, 0xF2, 0x45, 0xE6, 0x1B,
    0x32, 0x7C, 0x08, 0xE9, 0x4D, 0x41, 0xC0, 0x7D, 0x0B, 0x41, 0x01, 0xA9, 0x63, 0xE0, 0x2F, 0xE5,
    0x2F, 0x6A, 0x9F, 0x33, 0xE8, 0xB1, 0xDE, 0x23, 0x94, 0xE0, 0xCB, 0x74, 0xC4, 0x07, 0x90, 0xB4,
    0xE4, 0x89, 0xB5, 0x50, 0x0E, 0x68, 0x04, 0xCA, 0xBE, 0xD0, 0xFE, 0x8C, 0x19, 0x24, 0x43, 0xD4,
    0x02, 0x7B
};
static const uint8_t Vector_P521_SHA224_SignatureR[] =
{
    0x00, 0x6B, 0x97, 0x3A, 0x63, 0x8B, 0xDE, 0x22, 0xD8, 0xC1, 0xC0, 0xD8, 0x04, 0xD9, 0x4E, 0x40,
    0x53, 0x85, 0x26, 0x09, 0x37, 0x05, 0xF9, 0x2C, 0x0C, 0x4D, 0xAC, 0x2C, 0x72, 0xE7, 0xDB, 0x01,
    0x3A, 0x9C, 0x89, 0xFF, 0xC5, 0xB1, 0x2A, 0x39, 0x68, 0x86, 0x30, 0x5D, 0xDF, 0x0C, 0xBA, 0xA7,
    0xF1, 0x0C, 0xDD, 0x4C, 0xD8, 0x86, 0x63, 0x34, 0xC8, 0xAB, 0xFC, 0x80, 0x0E, 0x5C, 0xCA, 0x36,
    0x53, 0x91
};
static const uint8_t Vector_P521_SHA224_SignatureS[] =
{
    0x00, 0xB0, 0xA0, 0x1E, 0xCA, 0x07, 0xA3, 0x96, 0x4D, 0xD2, 0x7D, 0x9B, 0xA6, 0xF3, 0x75, 0x06,
    0x15, 0xEA, 0x36, 0x43, 0x49, 0x79, 0xDC, 0x73, 0xE1, 0x53, 0xCD, 0x8E, 0xD1, 0xDB, 0xCD, 0xE2,
    0x88, 0x5E, 0xAD, 0x57, 0x57, 0xEB, 0xCA, 0xBB, 0xA1, 0x17, 0xA6, 0x4F, 0xCF, 0xF9, 0xB5, 0x08,
    0x5D, 0x84, 0x8F, 0x10, 0x7F, 0x0C, 0x9E, 0xCC, 0x83, 0xDF, 0xA2, 0xFA, 0x09, 0xAD, 0xA3, 0x50,
    0x30, 0x28
};

// [P-521,SHA-256] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P521_SHA256_Message[] =
{
    0x8A, 0xB8, 0x17, 0x6B, 0x16, 0x27, 0x8D, 0xB5, 0x4F, 0x84, 0x32, 0x8A, 0xE0, 0xB7, 0x5E, 0xF8,
    0xF0, 0xCD, 0x18, 0xAF, 0xDF, 0x40, 0xC0, 0x4A, 0xD0, 0x92, 0x7E, 0xD0, 0xF6, 0xD9, 0xE4, 0x74,
    0x70, 0x39, 0x6C, 0x8E, 0x87, 0xCD, 0xE7, 0xA9, 0xBE, 0x2F, 0xFB, 0xFE, 0x6C, 0x96, 0x58, 0xC8,
    0x8B, 0x7D, 0xE4, 0xD5, 0x82, 0x11, 0x11, 0x19, 0xC4, 0x33, 0xB2, 0xE4, 0xA5, 0x04, 0x49, 0x3F,
    0x0A, 0x11, 0x66, 0xE3, 0xA3, 0xEA, 0x0D, 0x7B, 0x93, 0x35, 0x8F, 0x4A, 0x29, 0x7D, 0x63, 0xF6,
    0x5A, 0x5E, 0x75, 0x2F, 0x94, 0xE2, 0xEE, 0x7F, 0x49, 0xEB, 0xCC, 0x74, 0x2F, 0xA3, 0xEB, 0x03,
    0xA6, 0x17, 0xD0, 0x0C, 0x57, 0x42, 0x45, 0xB7, 0x7A, 0x20, 0x03, 0x38, 0x54, 0xD8, 0x29, 0x64,
    0xB2, 0x94, 0x9E, 0x22, 0x47, 0x63, 0x72, 0x39, 0xAB, 0x00, 0xBA, 0xF4, 0xD1, 0x70, 0xD9, 0x7C
};
static const uint8_t Vector_P521_SHA256_PrivateKey[] =
{
    0x01, 0xE8, 0xC0, 0x59, 0x96, 0xB8, 0x5E, 0x6F, 0x3F, 0x87, 0x57, 0x12, 0xA0, 0x9C, 0x1B, 0x40,
    0x67, 0x2B, 0x5E, 0x7A, 0x78, 0xD5, 0x85, 0x2D, 0xE0, 0x15, 0x85, 0xC5, 0xFB, 0x99, 0x0B, 0xF3,
    0x81, 0x2C, 0x32, 0x45, 0x53, 0x4A, 0x71, 0x43, 0x89, 0xAE, 0x90, 0x14, 0xD6, 0x77, 0xA4, 0x49,
    0xEF, 0xD6, 0x58, 0x25, 0x4E, 0x61, 0x0D, 0xA8, 0xE6, 0xCA, 0xD3, 0x34, 0x14, 0xB9, 0xD3, 0x3E,
    0x0D, 0x7A
};
static const uint8_t Vector_P521_SHA256_PublicKeyX[] =
{
    0x00, 0x7D, 0x04, 0x2C, 0xA1, 0x94, 0x08, 0x52, 0x4E, 0x68, 0xB9, 0x81, 0xF1, 0x41, 0x93, 0x51,
    0xE3, 0xB8, 0x47, 0x36, 0xC7, 0x7F, 0xE5, 0x8F, 0xEE, 0x7D, 0x11, 0x31, 0x7D, 0xF2, 0xE8, 0x50,
    0xD9, 0x60, 0xC7, 0xDD, 0x10, 0xD1, 0x0B, 0xA7, 0x14, 0xC8, 0xA6, 0x09, 0xD1, 0x63, 0x50, 0x2B,
    0x79, 0xD6, 0x82, 0xE8, 0xBB, 0xEC, 0xD4, 0xF5, 0x25, 0x91, 0xD2, 0x74, 0x85, 0x33, 0xE4, 0x5A,
    0x86, 0x7A
};
static const uint8_t Vector_P521_SHA256_PublicKeyY[] =
{
    0x01, 0x97, 0xAC, 0x64, 0x16, 0x11, 0x1C, 0xCF, 0x98, 0x7D, 0x29, 0x04, 0x59, 0xEB, 0xC8, 0xAD,
    0x9E, 0xC5, 0x6E, 0x49, 0x05, 0x9C, 0x99, 0x21, 0x55, 0x53, 0x9A, 0x36, 0xA6, 0x26, 0x63, 0x1F,
    0x4A, 0x2D, 0x89, 0x16, 0x4B, 0x98, 0x51, 0x54, 0xF2, 0xDD, 0xDC, 0x02, 0x81, 0xEE, 0x5B, 0x51,
    0x78, 0x27, 0x1F, 0x3A, 0x76, 0xA0, 0x91, 0x4C, 0x3F, 0xCD, 0x1F, 0x97, 0xBE, 0x8E, 0x83, 0x76,
    0xEF, 0xB3
};
static const uint8_t Vector_P521_SHA256_SignatureR[] =
{
    0x00, 0x9D, 0xD1, 0xF2, 0xA7, 0x16, 0x84, 0x3E, 0xED, 0xEC, 0x7A, 0x66, 0x45, 0xAC, 0x83, 0x4D,
    0x43, 0x36, 0xE7, 0xB1, 0x8E, 0x35, 0x70, 0x1F, 0x06, 0xCA, 0xE9, 0xD6, 0xB2, 0x90, 0xD4, 0x14,
    0x91, 0x42, 0x47, 0x35, 0xF3, 0xB5, 0x7E, 0x82, 0x9A, 0xD5, 0xDE, 0x05, 0x5E, 0xAE, 0xEF, 0x17,
    0x78, 0xF0, 0x51, 0xC1, 0xEE, 0x15, 0x2B, 0xF2, 0x13, 0x1A, 0x08, 0x1E, 0x53, 0xDF, 0x2A, 0x56,
    0x7A, 0x8A
};
static const uint8_t Vector_P521_SHA256_SignatureS[] =
{
    0x00, 0x21, 0x48, 0xE8, 0x42, 0x8D, 0x70, 0xA7, 0x2B, 0xC9, 0xFA, 0x98, 0x6C, 0x38, 0xC2, 0xC9,
    0x7D, 0xED, 0xA0, 0x42, 0x0F, 0x22, 0x2F, 0x9D, 0xC9, 0x9D, 0x32, 0xC0, 0xAC, 0xBA, 0x69, 0x9D,
    0xC7, 0xBA, 0x0A, 0x2B, 0x79, 0xCE, 0x59, 0x99, 0xFF, 0x61, 0xBD, 0x0B, 0x23, 0x3C, 0x74, 0x4A,
    0x89, 0x3B, 0xC1, 0x05, 0xBC, 0xA5, 0xC2, 0x35, 0x42, 0x3E, 0x53, 0x16, 0x12, 0xDA, 0x65, 0xD7,
    0x2E, 0x62
};

#ifdef EIP130_ENABLE_SYM_ALGO_SHA512
// [P-521,SHA-384] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P521_SHA384_Message[] =
{
    0xDB, 0xC0, 0x94, 0x40, 0x2C, 0x5B, 0x55, 0x9D, 0x53, 0x16, 0x8C, 0x6F, 0x0C, 0x55, 0x0D, 0x82,
    0x74, 0x99, 0xC6, 0xFB, 0x21, 0x86, 0xAE, 0x2D, 0xB1, 0x5B, 0x89, 0xB4, 0xE6, 0xF4, 0x62, 0x20,
    0x38, 0x6D, 0x6F, 0x01, 0xBE, 0xBD, 0xE9, 0x1B, 0x6C, 0xEB, 0x3E, 0xC7, 0xB4, 0x69, 0x6E, 0x2C,
    0xBF, 0xD1, 0x48, 0x94, 0xDD, 0x0B, 0x7D, 0x65, 0x6D, 0x23, 0x39, 0x6C, 0xE9, 0x20, 0x04, 0x4F,
    0x9C, 0xA5, 0x14, 0xBF, 0x11, 0x5C, 0xF9, 0x8E, 0xCA, 0xA5, 0x5B, 0x95, 0x0A, 0x9E, 0x49, 0x36,
    0x5C, 0x2F, 0x3A, 0x05, 0xBE, 0x50, 0x20, 0xE9, 0x3D, 0xB9, 0x2C, 0x37, 0x43, 0x75, 0x13, 0x04,
    0x49, 0x73, 0xE7, 0x92, 0xAF, 0x81, 0x4D, 0x0F, 0xFA, 0xD2, 0xC8, 0xEC, 0xC8, 0x9A, 0xE4, 0xB3,
    0x5C, 0xCB, 0x19, 0x31, 0x8F, 0x0B, 0x98, 0x8A, 0x7D, 0x33, 0xEC, 0x5A, 0x4F, 0xE8, 0x5D, 0xFE
};
static const uint8_t Vector_P521_SHA384_PrivateKey[] =
{
    0x00, 0x95, 0x97, 0x6D, 0x38, 0x7D, 0x81, 0x4E, 0x68, 0xAE, 0xB0, 0x9A, 0xBE, 0xCD, 0xBF, 0x42,
    0x28, 0xDB, 0x72, 0x32, 0xCD, 0x32, 0x29, 0x56, 0x9A, 0xDE, 0x53, 0x7F, 0x33, 0xE0, 0x7E, 0xD0,
    0xDA, 0x0A, 0xBD, 0xEE, 0x84, 0xAB, 0x05, 0x7C, 0x9A, 0x00, 0x04, 0x9F, 0x45, 0x25, 0x0E, 0x27,
    0x19, 0xD1, 0xEC, 0xAC, 0xCF, 0x91, 0xC0, 0xE6, 0xFC, 0xDD, 0x40, 0x16, 0xB7, 0x5B, 0xDD, 0x98,
    0xA9, 0x50
};
static const uint8_t Vector_P521_SHA384_PublicKeyX[] =
{
    0x01, 0x3B, 0x4A, 0xB7, 0xBC, 0x1D, 0xDF, 0x7F, 0xD7, 0x4C, 0xA6, 0xF7, 0x5A, 0xC5, 0x60, 0xC9,
    0x41, 0x69, 0xF4, 0x35, 0x36, 0x1E, 0x74, 0xEB, 0xA1, 0xF8, 0xE7, 0x59, 0xAC, 0x70, 0xAB, 0x3A,
    0xF1, 0x38, 0xD8, 0x80, 0x7A, 0xCA, 0x3D, 0x8E, 0x73, 0xB5, 0xC2, 0xEB, 0x78, 0x7F, 0x6D, 0xCC,
    0xA2, 0x71, 0x81, 0x22, 0xBD, 0x94, 0xF0, 0x89, 0x43, 0xA6, 0x86, 0xB1, 0x15, 0xD8, 0x69, 0xD3,
    0xF4, 0x06
};
static const uint8_t Vector_P521_SHA384_PublicKeyY[] =
{
    0x00, 0xF2, 0x93, 0xC1, 0xD6, 0x27, 0xB4, 0x4E, 0x79, 0x54, 0xD0, 0x54, 0x62, 0x70, 0x66, 0x58,
    0x88, 0x14, 0x4A, 0x94, 0xD4, 0x37, 0x67, 0x9D, 0x07, 0x47, 0x87, 0x95, 0x9D, 0x0D, 0x94, 0x4D,
    0x82, 0x23, 0xB9, 0xD4, 0xB5, 0xD0, 0x68, 0xB4, 0xFB, 0xBD, 0x11, 0x76, 0xA0, 0x04, 0xB4, 0x76,
    0x81, 0x04, 0x75, 0xCD, 0x2A, 0x20, 0x0B, 0x83, 0xEC, 0xCD, 0x22, 0x6D, 0x08, 0xB4, 0x44, 0xA7,
    0x1E, 0x71
};
static const uint8_t Vector_P521_SHA384_SignatureR[] =
{
    0x00, 0x21, 0x28, 0xF7, 0x7D, 0xF6, 0x6D, 0x16, 0xA6, 0x04, 0xFF, 0xCD, 0x1A, 0x51, 0x5E, 0x03,
    0x9D, 0x49, 0xBF, 0x6B, 0x91, 0xA2, 0x15, 0xB8, 0x14, 0xB2, 0xA1, 0xC8, 0x8D, 0x32, 0x03, 0x95,
    0x21, 0xFB, 0xD1, 0x42, 0xF7, 0x17, 0x81, 0x7B, 0x83, 0x84, 0x50, 0x22, 0x90, 0x25, 0x67, 0x0D,
    0x99, 0xC1, 0xFD, 0x5A, 0xB1, 0x8B, 0xD9, 0x65, 0xF0, 0x93, 0xCA, 0xE7, 0xAC, 0xCF, 0xF0, 0x67,
    0x5A, 0xAE
};
static const uint8_t Vector_P521_SHA384_SignatureS[] =
{
    0x00, 0x08, 0xDC, 0x65, 0xA2, 0x43, 0x70, 0x0A, 0x84, 0x61, 0x9D, 0xCE, 0x14, 0xE4, 0x4E, 0xA8,
    0x55, 0x7E, 0x36, 0x63, 0x1D, 0xB1, 0xA5, 0x5D, 0xE1, 0x58, 0x65, 0x49, 0x7D, 0xBF, 0xD6, 0x6E,
    0x76, 0xA7, 0x47, 0x1F, 0x78, 0xE5, 0x10, 0xC0, 0x4E, 0x61, 0x3C, 0xED, 0x33, 0x2A, 0xA5, 0x63,
    0x43, 0x2A, 0x10, 0x17, 0xDA, 0x8B, 0x81, 0xC1, 0x46, 0x05, 0x9C, 0xCC, 0x79, 0x30, 0x15, 0x31,
    0x03, 0xA6
};

// [P-521,SHA-512] CAVS 11.2, Generated on Tue Aug 16 15:27:42 2011
static const uint8_t Vector_P521_SHA512_Message[] =
{
    0x9E, 0xCD, 0x50, 0x0C, 0x60, 0xE7, 0x01, 0x40, 0x49, 0x22, 0xE5, 0x8A, 0xB2, 0x0C, 0xC0, 0x02,
    0x65, 0x1F, 0xDE, 0xE7, 0xCB, 0xC9, 0x33, 0x6A, 0xDD, 0xA3, 0x3E, 0x4C, 0x10, 0x88, 0xFA, 0xB1,
    0x96, 0x4E, 0xCB, 0x79, 0x04, 0xDC, 0x68, 0x56, 0x86, 0x5D, 0x6C, 0x8E, 0x15, 0x04, 0x1C, 0xCF,
    0x2D, 0x5A, 0xC3, 0x02, 0xE9, 0x9D, 0x34, 0x6F, 0xF2, 0xF6, 0x86, 0x53, 0x1D, 0x25, 0x52, 0x16,
    0x78, 0xD4, 0xFD, 0x3F, 0x76, 0xBB, 0xF2, 0xC8, 0x93, 0xD2, 0x46, 0xCB, 0x4D, 0x76, 0x93, 0x79,
    0x2F, 0xE1, 0x81, 0x72, 0x10, 0x81, 0x46, 0x85, 0x31, 0x03, 0xA5, 0x1F, 0x82, 0x4A, 0xCC, 0x62,
    0x1C, 0xB7, 0x31, 0x1D, 0x24, 0x63, 0xC3, 0x36, 0x1E, 0xA7, 0x07, 0x25, 0x4F, 0x2B, 0x05, 0x2B,
    0xC2, 0x2C, 0xB8, 0x01, 0x28, 0x73, 0xDC, 0xBB, 0x95, 0xBF, 0x1A, 0x5C, 0xC5, 0x3A, 0xB8, 0x9F
};
static const uint8_t Vector_P521_SHA512_PrivateKey[] =
{
    0x00, 0xF7, 0x49, 0xD3, 0x27, 0x04, 0xBC, 0x53, 0x3C, 0xA8, 0x2C, 0xEF, 0x0A, 0xCF, 0x10, 0x3D,
    0x8F, 0x4F, 0xBA, 0x67, 0xF0, 0x8D, 0x26, 0x78, 0xE5, 0x15, 0xED, 0x7D, 0xB8, 0x86, 0x26, 0x7F,
    0xFA, 0xF0, 0x2F, 0xAB, 0x00, 0x80, 0xDC, 0xA2, 0x35, 0x9B, 0x72, 0xF5, 0x74, 0xCC, 0xC2, 0x9A,
    0x0F, 0x21, 0x8C, 0x86, 0x55, 0xC0, 0xCC, 0xCF, 0x9F, 0xEE, 0x6C, 0x5E, 0x56, 0x7A, 0xA1, 0x4C,
    0xB9, 0x26
};
static const uint8_t Vector_P521_SHA512_PublicKeyX[] =
{
    0x00, 0x61, 0x38, 0x7F, 0xD6, 0xB9, 0x59, 0x14, 0xE8, 0x85, 0xF9, 0x12, 0xED, 0xFB, 0xB5, 0xFB,
    0x27, 0x46, 0x55, 0x02, 0x7F, 0x21, 0x6C, 0x40, 0x91, 0xCA, 0x83, 0xE1, 0x93, 0x36, 0x74, 0x0F,
    0xD8, 0x1A, 0xED, 0xFE, 0x04, 0x7F, 0x51, 0xB4, 0x2B, 0xDF, 0x68, 0x16, 0x11, 0x21, 0x01, 0x3E,
    0x0D, 0x55, 0xB1, 0x17, 0xA1, 0x4E, 0x43, 0x03, 0xF9, 0x26, 0xC8, 0xDE, 0xBB, 0x77, 0xA7, 0xFD,
    0xAA, 0xD1
};
static const uint8_t Vector_P521_SHA512_PublicKeyY[] =
{
    0x00, 0xE7, 0xD0, 0xC7, 0x5C, 0x38, 0x62, 0x6E, 0x89, 0x5C, 0xA2, 0x15, 0x26, 0xB9, 0xF9, 0xFD,
    0xF8, 0x4D, 0xCE, 0xCB, 0x93, 0xF2, 0xB2, 0x33, 0x39, 0x05, 0x50, 0xD2, 0xB1, 0x46, 0x3B, 0x7E,
    0xE3, 0xF5, 0x8D, 0xF7, 0x34, 0x64, 0x35, 0xFF, 0x04, 0x34, 0x19, 0x95, 0x83, 0xC9, 0x7C, 0x66,
    0x5A, 0x97, 0xF1, 0x2F, 0x70, 0x6F, 0x23, 0x57, 0xDA, 0x4B, 0x40, 0x28, 0x8D, 0xEF, 0x88, 0x8E,
    0x59, 0xE6
};
static const uint8_t Vector_P521_SHA512_SignatureR[] =
{
    0x00, 0x4D, 0xE8, 0x26, 0xEA, 0x70, 0x4A, 0xD1, 0x0B, 0xC0, 0xF7, 0x53, 0x8A, 0xF8, 0xA3, 0x84,
    0x3F, 0x28, 0x4F, 0x55, 0xC8, 0xB9, 0x46, 0xAF, 0x92, 0x35, 0xAF, 0x5A, 0xF7, 0x4F, 0x2B, 0x76,
    0xE0, 0x99, 0xE4, 0xBC, 0x72, 0xFD, 0x79, 0xD2, 0x8A, 0x38, 0x0F, 0x8D, 0x4B, 0x4C, 0x91, 0x9A,
    0xC2, 0x90, 0xD2, 0x48, 0xC3, 0x79, 0x83, 0xBA, 0x05, 0xAE, 0xA4, 0x2E, 0x2D, 0xD7, 0x9F, 0xDD,
    0x33, 0xE8
};
static const uint8_t Vector_P521_SHA512_SignatureS[] =
{
    0x00, 0x87, 0x48, 0x8C, 0x85, 0x9A, 0x96, 0xFE, 0xA2, 0x66, 0xEA, 0x13, 0xBF, 0x6D, 0x11, 0x4C,
    0x42, 0x9B, 0x16, 0x3B, 0xE9, 0x7A, 0x57, 0x55, 0x90, 0x86, 0xED, 0xB6, 0x4A, 0xED, 0x4A, 0x18,
    0x59, 0x4B, 0x46, 0xFB, 0x9E, 0xFC, 0x7F, 0xD2, 0x5D, 0x8B, 0x2D, 0xE8, 0xF0, 0x9C, 0xA0, 0x58,
    0x7F, 0x54, 0xBD, 0x28, 0x72, 0x99, 0xF4, 0x7B, 0x2F, 0xF1, 0x24, 0xAA, 0xC5, 0x66, 0xE8, 0xEE,
    0x3B, 0x43
};
#endif /* EIP130_ENABLE_SYM_ALGO_SHA512 */

#ifdef EIP130_ENABLE_ASYM_ALGO_SM2
/* SM2 curve based vectors */
static const uint8_t Vector_SM2_Fp256_UserIdentity[] =
{
    0x41, 0x4C, 0x49, 0x43, 0x45, 0x31, 0x32, 0x33,
    0x40, 0x59, 0x41, 0x48, 0x4F, 0x4F, 0x2E, 0x43,
    0x4F, 0x4D
};
static const uint8_t Vector_SM2_Fp256_Message[] =
{
    0x6D, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20,
    0x64, 0x69, 0x67, 0x65, 0x73, 0x74
};
static const uint8_t Vector_SM2_Fp256_Message_2[] =
{
    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
    0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
    0x59, 0x5A, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66,
    0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E,
    0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76,
    0x77, 0x78, 0x79, 0x7A, 0x41, 0x42, 0x43, 0x44,
    0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C,
    0x4D, 0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54,
    0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x61, 0x62,
    0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A,
    0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70, 0x71, 0x72,
    0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A
};
#ifdef USE_THE_SM2_CURVE
static const uint8_t Vector_SM2_Fp256_PrivateKey[] =
{
    0x12, 0x8B, 0x2F, 0xA8, 0xBD, 0x43, 0x3C, 0x6C,
    0x06, 0x8C, 0x8D, 0x80, 0x3D, 0xFF, 0x79, 0x79,
    0x2A, 0x51, 0x9A, 0x55, 0x17, 0x1B, 0x1B, 0x65,
    0x0C, 0x23, 0x66, 0x1D, 0x15, 0x89, 0x72, 0x63
};
static const uint8_t Vector_SM2_Fp256_PublicKeyX[] =
{
    0x0A, 0xE4, 0xC7, 0x79, 0x8A, 0xA0, 0xF1, 0x19,
    0x47, 0x1B, 0xEE, 0x11, 0x82, 0x5B, 0xE4, 0x62,
    0x02, 0xBB, 0x79, 0xE2, 0xA5, 0x84, 0x44, 0x95,
    0xE9, 0x7C, 0x04, 0xFF, 0x4D, 0xF2, 0x54, 0x8A
};
static const uint8_t Vector_SM2_Fp256_PublicKeyY[] =
{
    0x7C, 0x02, 0x40, 0xF8, 0x8F, 0x1C, 0xD4, 0xE1,
    0x63, 0x52, 0xA7, 0x3C, 0x17, 0xB7, 0xF1, 0x6F,
    0x07, 0x35, 0x3E, 0x53, 0xA1, 0x76, 0xD6, 0x84,
    0xA9, 0xFE, 0x0C, 0x6B, 0xB7, 0x98, 0xE8, 0x57
};
static const uint8_t Vector_SM2_Fp256_SignatureR[] =
{
    0x40, 0xF1, 0xEC, 0x59, 0xF7, 0x93, 0xD9, 0xF4,
    0x9E, 0x09, 0xDC, 0xEF, 0x49, 0x13, 0x0D, 0x41,
    0x94, 0xF7, 0x9F, 0xB1, 0xEE, 0xD2, 0xCA, 0xA5,
    0x5B, 0xAC, 0xDB, 0x49, 0xC4, 0xE7, 0x55, 0xD1
};
static const uint8_t Vector_SM2_Fp256_SignatureS[] =
{
    0x6F, 0xC6, 0xDA, 0xC3, 0x2C, 0x5D, 0x5C, 0xF1,
    0x0C, 0x77, 0xDF, 0xB2, 0x0F, 0x7C, 0x2E, 0xB6,
    0x67, 0xA4, 0x57, 0x87, 0x2F, 0xB0, 0x9E, 0xC5,
    0x63, 0x27, 0xA6, 0x7E, 0xC7, 0xDE, 0xEB, 0xE7
};
static const uint8_t Vector_SM2_Fp256_SignatureR_2[] =
{
    0x56, 0x6C, 0x92, 0xCC, 0x5A, 0x09, 0xC2, 0x7F,
    0x80, 0x97, 0x02, 0x58, 0x4A, 0x64, 0xEE, 0x53,
    0x96, 0x51, 0x8B, 0x2E, 0x3C, 0xFC, 0xC1, 0x04,
    0xAD, 0x69, 0xE5, 0x33, 0xA6, 0xC9, 0x60, 0x70
};
static const uint8_t Vector_SM2_Fp256_SignatureS_2[] =
{
    0x78, 0x84, 0x81, 0x9B, 0x62, 0x62, 0x6A, 0xFC,
    0x67, 0xC1, 0xEF, 0x5C, 0x74, 0x6F, 0x4A, 0x58,
    0xA1, 0xAC, 0xF4, 0x51, 0x3A, 0x0B, 0x69, 0x82,
    0xE4, 0x6E, 0x4B, 0xE7, 0x8A, 0x26, 0x68, 0xEE
};
#else
/* NIST curve based vectors */
static const uint8_t Vector_SM2_Np256_PrivateKey[] =
{
    0x8D, 0x72, 0x31, 0x04, 0xF7, 0x73, 0x83, 0xC1,
    0x34, 0x58, 0xA7, 0x48, 0xE9, 0xBB, 0x17, 0xBC,
    0xA3, 0xF2, 0xC9, 0xBF, 0x9C, 0x63, 0x16, 0xB9,
    0x50, 0xF2, 0x44, 0x55, 0x6F, 0x25, 0xE2, 0xA3
};
static const uint8_t Vector_SM2_Np256_PublicKeyX[] =
{
    0x70, 0x6C, 0x86, 0x1E, 0xF1, 0x2D, 0x52, 0x04,
    0x9F, 0x65, 0x0D, 0xF3, 0x97, 0x97, 0x5B, 0x37,
    0x41, 0x6D, 0x86, 0xE5, 0x7A, 0x38, 0xC7, 0xD5,
    0x52, 0xA9, 0x9F, 0x25, 0x28, 0x18, 0x16, 0x6D
};
static const uint8_t Vector_SM2_Np256_PublicKeyY[] =
{
    0xC8, 0x1A, 0x0E, 0x89, 0xA3, 0xC3, 0xA4, 0x11,
    0x35, 0x34, 0x7D, 0xA5, 0x21, 0xBB, 0xC3, 0x21,
    0x76, 0xB4, 0xD6, 0xB0, 0xEE, 0x2B, 0x85, 0x6B,
    0x7B, 0x08, 0x8B, 0xE4, 0x14, 0x15, 0x4F, 0xB0
};
static const uint8_t Vector_SM2_Np256_SignatureR[] =
{
    0xCD, 0xE5, 0xD5, 0x20, 0xD9, 0x82, 0x43, 0x02,
    0x36, 0xF2, 0x9F, 0xA1, 0x98, 0x14, 0x0F, 0x8E,
    0x09, 0x5E, 0x64, 0xF2, 0xB5, 0x7D, 0x7B, 0x40,
    0x7F, 0x16, 0x9A, 0x38, 0x11, 0x99, 0x9C, 0x14
};
static const uint8_t Vector_SM2_Np256_SignatureS[] =
{
    0xDD, 0xD8, 0x2C, 0x81, 0xC6, 0x02, 0x0C, 0x88,
    0x4F, 0xC9, 0x87, 0xAD, 0x56, 0x8C, 0xC3, 0xE9,
    0x09, 0xD2, 0x13, 0x8C, 0xC6, 0x34, 0x05, 0xB9,
    0x25, 0xD9, 0x08, 0xC8, 0xCA, 0x44, 0xB0, 0xA9
};
static const uint8_t Vector_SM2_Np256_SignatureR_2[] =
{
    0xB9, 0x46, 0xBB, 0x10, 0x04, 0x5E, 0x26, 0x82,
    0x20, 0xB4, 0x96, 0xA5, 0x3E, 0xC6, 0x3E, 0x2A,
    0x72, 0xC9, 0x21, 0xDA, 0xA0, 0x82, 0x40, 0xDD,
    0xD9, 0xC5, 0x82, 0x06, 0xD9, 0x32, 0x5D, 0x6D
};
static const uint8_t Vector_SM2_Np256_SignatureS_2[] =
{
    0x43, 0x9A, 0xF2, 0x24, 0x7C, 0x00, 0x9F, 0xAA,
    0x7B, 0xD1, 0xF1, 0xBF, 0xBE, 0xFB, 0x59, 0xB9,
    0xC0, 0xF5, 0x5B, 0x3A, 0xB9, 0xC0, 0x06, 0xE2,
    0x07, 0xE6, 0xAC, 0x89, 0xCB, 0x0D, 0x1F, 0xDB
};
#endif /* USE_THE_SM2_CURVE */


/* Example from GM/T 0003.3-2012 Annex A */
/* ALICE123@YAHOO.COM */
static const uint8_t Vector_SM2_Kex_IdentityA[] =
{
    0x41, 0x4c, 0x49, 0x43, 0x45, 0x31, 0x32, 0x33,
    0x40, 0x59, 0x41, 0x48, 0x4f, 0x4f, 0x2e, 0x43,
    0x4f, 0x4d
};
/* BILL456@YAHOO.COM */
static const uint8_t Vector_SM2_Kex_IdentityB[] =
{
    0x42, 0x49, 0x4c, 0x4c, 0x34, 0x35, 0x36, 0x40,
    0x59, 0x41, 0x48, 0x4f, 0x4f, 0x2e, 0x43, 0x4f,
    0x4d
};
#ifdef USE_THE_SM2_CURVE
/* Static private key for A */
static const uint8_t Vector_SM2_PrivateKeyA[] =
{
    0x6f, 0xcb, 0xa2, 0xef, 0x9a, 0xe0, 0xab, 0x90,
    0x2b, 0xc3, 0xbd, 0xe3, 0xff, 0x91, 0x5d, 0x44,
    0xba, 0x4c, 0xc7, 0x8f, 0x88, 0xe2, 0xf8, 0xe7,
    0xf8, 0x99, 0x6d, 0x3b, 0x8c, 0xce, 0xed, 0xee
};
/* Static public key for A */
static const uint8_t Vector_SM2_PublicKeyAX[] =
{
    0x30, 0x99, 0x09, 0x3b, 0xf3, 0xc1, 0x37, 0xd8,
    0xfc, 0xbb, 0xcd, 0xf4, 0xa2, 0xae, 0x50, 0xf3,
    0xb0, 0xf2, 0x16, 0xc3, 0x12, 0x2d, 0x79, 0x42,
    0x5f, 0xe0, 0x3a, 0x45, 0xdb, 0xfe, 0x16, 0x55
};
static const uint8_t Vector_SM2_PublicKeyAY[] =
{
    0x3d, 0xf7, 0x9e, 0x8d, 0xac, 0x1c, 0xf0, 0xec,
    0xba, 0xa2, 0xf2, 0xb4, 0x9d, 0x51, 0xa4, 0xb3,
    0x87, 0xf2, 0xef, 0xaf, 0x48, 0x23, 0x39, 0x08,
    0x6a, 0x27, 0xa8, 0xe0, 0x5b, 0xae, 0xd9, 0x8b
};
/* Static private key for B */
static const uint8_t Vector_SM2_PrivateKeyB[] =
{
    0x5e, 0x35, 0xd7, 0xd3, 0xf3, 0xc5, 0x4d, 0xba,
    0xc7, 0x2e, 0x61, 0x81, 0x9e, 0x73, 0x0b, 0x01,
    0x9a, 0x84, 0x20, 0x8c, 0xa3, 0xa3, 0x5e, 0x4c,
    0x2e, 0x35, 0x3d, 0xfc, 0xcb, 0x2a, 0x3b, 0x53
};
/* Static public key for B */
static const uint8_t Vector_SM2_PublicKeyBX[] =
{
    0x24, 0x54, 0x93, 0xd4, 0x46, 0xc3, 0x8d, 0x8c,
    0xc0, 0xf1, 0x18, 0x37, 0x46, 0x90, 0xe7, 0xdf,
    0x63, 0x3a, 0x8a, 0x4b, 0xfb, 0x33, 0x29, 0xb5,
    0xec, 0xe6, 0x04, 0xb2, 0xb4, 0xf3, 0x7f, 0x43
};
static const uint8_t Vector_SM2_PublicKeyBY[] =
{
    0x53, 0xc0, 0x86, 0x9f, 0x4b, 0x9e, 0x17, 0x77,
    0x3d, 0xe6, 0x8f, 0xec, 0x45, 0xe1, 0x49, 0x04,
    0xe0, 0xde, 0xa4, 0x5b, 0xf6, 0xce, 0xcf, 0x99,
    0x18, 0xc8, 0x5e, 0xa0, 0x47, 0xc6, 0x0a, 0x4c
};
/* Z_A = H256(ENTL_A || ID_A || a || b || xG || yG || xA || yA) */
static const uint8_t Vector_SM2_ZA[] =
{
    0xe4, 0xd1, 0xd0, 0xc3, 0xca, 0x4c, 0x7f, 0x11,
    0xbc, 0x8f, 0xf8, 0xcb, 0x3f, 0x4c, 0x02, 0xa7,
    0x8f, 0x10, 0x8f, 0xa0, 0x98, 0xe5, 0x1a, 0x66,
    0x84, 0x87, 0x24, 0x0f, 0x75, 0xe2, 0x0f, 0x31
};
/* Z_B */
static const uint8_t Vector_SM2_ZB[] =
{
    0x6b, 0x4b, 0x6d, 0x0e, 0x27, 0x66, 0x91, 0xbd,
    0x4a, 0x11, 0xbf, 0x72, 0xf4, 0xfb, 0x50, 0x1a,
    0xe3, 0x09, 0xfd, 0xac, 0xb7, 0x2f, 0xa6, 0xcc,
    0x33, 0x6e, 0x66, 0x56, 0x11, 0x9a, 0xbd, 0x67
};
/* Ephemeral private key for A */
static const uint8_t Vector_SM2_rA[] =
{
    0x83, 0xa2, 0xc9, 0xc8, 0xb9, 0x6e, 0x5a, 0xf7,
    0x0b, 0xd4, 0x80, 0xb4, 0x72, 0x40, 0x9a, 0x9a,
    0x32, 0x72, 0x57, 0xf1, 0xeb, 0xb7, 0x3f, 0x5b,
    0x07, 0x33, 0x54, 0xb2, 0x48, 0x66, 0x85, 0x63
};
/* Ephemeral public key for A */
static const uint8_t Vector_SM2_RAx[] =
{
    0x6c, 0xb5, 0x63, 0x38, 0x16, 0xf4, 0xdd, 0x56,
    0x0b, 0x1d, 0xec, 0x45, 0x83, 0x10, 0xcb, 0xcc,
    0x68, 0x56, 0xc0, 0x95, 0x05, 0x32, 0x4a, 0x6d,
    0x23, 0x15, 0x0c, 0x40, 0x8f, 0x16, 0x2b, 0xf0
};
static const uint8_t Vector_SM2_RAy[] =
{
    0x0d, 0x6f, 0xcf, 0x62, 0xf1, 0x03, 0x6c, 0x0a,
    0x1b, 0x6d, 0xac, 0xcf, 0x57, 0x39, 0x92, 0x23,
    0xa6, 0x5f, 0x7d, 0x7b, 0xf2, 0xd9, 0x63, 0x7e,
    0x5b, 0xbb, 0xeb, 0x85, 0x79, 0x61, 0xbf, 0x1a
};
/* Ephemeral private key for B */
static const uint8_t Vector_SM2_rB[] =
{
    0x33, 0xfe, 0x21, 0x94, 0x03, 0x42, 0x16, 0x1c,
    0x55, 0x61, 0x9c, 0x4a, 0x0c, 0x06, 0x02, 0x93,
    0xd5, 0x43, 0xc8, 0x0a, 0xf1, 0x97, 0x48, 0xce,
    0x17, 0x6d, 0x83, 0x47, 0x7d, 0xe7, 0x1c, 0x80
};
/* Ephemeral public key for B */
static const uint8_t Vector_SM2_RBx[] =
{
    0x17, 0x99, 0xb2, 0xa2, 0xc7, 0x78, 0x29, 0x53,
    0x00, 0xd9, 0xa2, 0x32, 0x5c, 0x68, 0x61, 0x29,
    0xb8, 0xf2, 0xb5, 0x33, 0x7b, 0x3d, 0xcf, 0x45,
    0x14, 0xe8, 0xbb, 0xc1, 0x9d, 0x90, 0x0e, 0xe5
};
static const uint8_t Vector_SM2_RBy[] =
{
    0x54, 0xc9, 0x28, 0x8c, 0x82, 0x73, 0x3e, 0xfd,
    0xf7, 0x80, 0x8a, 0xe7, 0xf2, 0x7d, 0x0e, 0x73,
    0x2f, 0x7c, 0x73, 0xa7, 0xd9, 0xac, 0x98, 0xb7,
    0xd8, 0x74, 0x0a, 0x91, 0xd0, 0xdb, 0x3c, 0xf4
};
/* Shared secret */
static const uint8_t Vector_SM2_xv[] =
{
    0x47, 0xc8, 0x26, 0x53, 0x4d, 0xc2, 0xf6, 0xf1,
    0xfb, 0xf2, 0x87, 0x28, 0xdd, 0x65, 0x8f, 0x21,
    0xe1, 0x74, 0xf4, 0x81, 0x79, 0xac, 0xef, 0x29,
    0x00, 0xf8, 0xb7, 0xf5, 0x66, 0xe4, 0x09, 0x05
};
static const uint8_t Vector_SM2_yv[] =
{
    0x2a, 0xf8, 0x6e, 0xfe, 0x73, 0x2c, 0xf1, 0x2a,
    0xd0, 0xe0, 0x9a, 0x1f, 0x25, 0x56, 0xcc, 0x65,
    0x0d, 0x9c, 0xcc, 0xe3, 0xe2, 0x49, 0x86, 0x6b,
    0xbb, 0x5c, 0x68, 0x46, 0xa4, 0xc4, 0xa2, 0x95
};
/* Shared key from xv || yv || Za || ZB */
static const uint8_t Vector_SM2_KB[] =
{
    0x55, 0xb0, 0xac, 0x62, 0xa6, 0xb9, 0x27, 0xba,
    0x23, 0x70, 0x38, 0x32, 0xc8, 0x53, 0xde, 0xd4
};
#else
/* Static private key for A */
static const uint8_t Vector_SM2_PrivateKeyA[] =
{
    0xDE, 0xD7, 0x33, 0xE8, 0xB4, 0x21, 0xEA, 0xEB,
    0x53, 0x40, 0x97, 0xCA, 0xBA, 0xF3, 0x89, 0x7A,
    0x3E, 0x70, 0xF1, 0x6A, 0x55, 0x48, 0x58, 0x22,
    0xDE, 0x1B, 0x37, 0x2A, 0xD3, 0xFB, 0xF4, 0x7B
};
/* Static public key for A */
static const uint8_t Vector_SM2_PublicKeyAX[] =
{
    0x55, 0x19, 0xE4, 0x36, 0x4B, 0x26, 0x14, 0xA0,
    0xAE, 0x04, 0xC7, 0x7F, 0x31, 0x9C, 0x4B, 0xBD,
    0x9B, 0x9A, 0xD9, 0x68, 0xDD, 0xCC, 0xBA, 0xFE,
    0x1A, 0x07, 0xEA, 0x27, 0xB8, 0x87, 0x6D, 0xCE
};
static const uint8_t Vector_SM2_PublicKeyAY[] =
{
    0xB1, 0x09, 0x9F, 0xFA, 0xCF, 0x1D, 0x76, 0x3F,
    0x88, 0xCE, 0x0B, 0x5B, 0x9B, 0xB3, 0x2A, 0xBA,
    0x81, 0xDC, 0x00, 0xDF, 0x59, 0xD3, 0xF4, 0x83,
    0xB2, 0x1C, 0x10, 0xF2, 0x37, 0x27, 0x4B, 0xF9
};
/* Static private key for B */
static const uint8_t Vector_SM2_PrivateKeyB[] =
{
    0x42, 0xAF, 0x9F, 0xC3, 0x85, 0x77, 0x6E, 0x9A,
    0xDD, 0x84, 0xF3, 0x9E, 0x71, 0x54, 0x5A, 0x13,
    0x7A, 0x1D, 0x50, 0x06, 0x8D, 0x72, 0x31, 0x04,
    0xF7, 0x73, 0x83, 0xC1, 0x34, 0x58, 0xA7, 0x49
};
/* Static public key for A */
static const uint8_t Vector_SM2_PublicKeyBX[] =
{
    0x99, 0x66, 0xB3, 0xEB, 0x78, 0x6E, 0xF8, 0x06,
    0x49, 0xE2, 0x11, 0x79, 0xFF, 0xCD, 0x02, 0x53,
    0x92, 0x61, 0x97, 0x61, 0xFA, 0x8B, 0x89, 0xA6,
    0x50, 0x92, 0x61, 0xE1, 0x90, 0x0F, 0x23, 0xEC
};
static const uint8_t Vector_SM2_PublicKeyBY[] =
{
    0xC8, 0x9C, 0xF0, 0x07, 0x18, 0xBC, 0x05, 0xA0,
    0x08, 0xA2, 0xA7, 0x67, 0xFD, 0xF0, 0xF2, 0x71,
    0x2A, 0xBD, 0x98, 0xDF, 0x3E, 0x00, 0x6F, 0xE5,
    0x74, 0xFC, 0xB2, 0xAC, 0xAA, 0x1D, 0xA2, 0xB3
};
/* Z_A = H256(ENTL_A || ID_A || a || b || xG || yG || xA || yA) */
static const uint8_t Vector_SM2_ZA[] =
{
    0x6A, 0x4B, 0x15, 0x60, 0xC1, 0x42, 0x69, 0xC7,
    0x7A, 0x30, 0x1B, 0x2B, 0xB7, 0xA6, 0x8B, 0xD2,
    0x11, 0x93, 0x5B, 0xD9, 0xBE, 0x6B, 0xC1, 0xFB,
    0xDA, 0x5D, 0x6E, 0x9A, 0x96, 0xBC, 0x75, 0x2C
};
/* Z_B */
static const uint8_t Vector_SM2_ZB[] =
{
    0xCB, 0xF8, 0xCB, 0x7B, 0x27, 0x0B, 0x20, 0x71,
    0x35, 0xD5, 0xBF, 0x91, 0x59, 0x84, 0xBE, 0x3A,
    0x91, 0x25, 0xFB, 0x01, 0x39, 0x62, 0x80, 0x2B,
    0x04, 0x30, 0x76, 0x2C, 0x90, 0xF8, 0x44, 0x6E
};
/* Ephemeral private key for A */
static const uint8_t Vector_SM2_rA[] =
{
    0xDE, 0xC9, 0x60, 0x47, 0x1F, 0xDD, 0xDE, 0x5C,
    0xD6, 0x10, 0xCA, 0xAD, 0x22, 0x34, 0xDA, 0x30,
    0xC6, 0x21, 0x37, 0xD3, 0x7D, 0x56, 0x62, 0x25,
    0x0E, 0x38, 0x32, 0x5A, 0xA7, 0x54, 0xFD, 0x5A
};
/* Ephemeral public key for A */
static const uint8_t Vector_SM2_RAx[] =
{
    0x96, 0x18, 0xA6, 0xEF, 0x38, 0xE3, 0xC5, 0x44,
    0x78, 0xC3, 0x25, 0x9A, 0x43, 0xCE, 0xAC, 0xC4,
    0xCA, 0x70, 0x5F, 0x0D, 0xA8, 0x2D, 0x06, 0xAE,
    0x0E, 0x12, 0xE3, 0xBC, 0x01, 0xEC, 0xD0, 0x70
};
static const uint8_t Vector_SM2_RAy[] =
{
    0x46, 0xA1, 0x56, 0xA2, 0xFE, 0x7A, 0x76, 0x2F,
    0xD5, 0x61, 0x98, 0x25, 0xED, 0x7B, 0x35, 0x6F,
    0xFC, 0x03, 0xD3, 0xF1, 0xC6, 0x27, 0xEC, 0x18,
    0xEB, 0xBB, 0x6D, 0x18, 0xA9, 0xCF, 0xAC, 0xEF
};
/* Ephemeral private key for B */
static const uint8_t Vector_SM2_rB[] =
{
    0x1D, 0x87, 0x8F, 0x9F, 0x9C, 0xDF, 0x5A, 0x86,
    0x53, 0x06, 0xF3, 0xF5, 0x15, 0x16, 0x65, 0x70,
    0x5B, 0x7C, 0x70, 0x9A, 0xCB, 0x17, 0x5A, 0x5A,
    0xFB, 0x82, 0x86, 0x0D, 0xEA, 0xBC, 0xA8, 0xD1
};
/* Ephemeral public key for B */
static const uint8_t Vector_SM2_RBx[] =
{
    0x18, 0xF5, 0x76, 0x13, 0x14, 0x6B, 0xC6, 0x22,
    0x58, 0x99, 0xDA, 0x06, 0x76, 0x77, 0xC0, 0xD8,
    0xDD, 0x7B, 0x02, 0xDA, 0xA4, 0x8B, 0x17, 0x8D,
    0x30, 0x24, 0xB5, 0x8C, 0xB4, 0xDF, 0x83, 0x46
};
static const uint8_t Vector_SM2_RBy[] =
{
    0x94, 0x7B, 0x38, 0xC4, 0xCF, 0xA8, 0xEB, 0xE5,
    0x48, 0x7D, 0x20, 0x26, 0xED, 0x94, 0x21, 0xD3,
    0xE9, 0x4F, 0xEE, 0xDE, 0xAD, 0x45, 0x45, 0xA8,
    0xDA, 0x26, 0xAC, 0xCD, 0x3C, 0x7D, 0x95, 0xBC
};
/* Shared secret */
static const uint8_t Vector_SM2_xv[] =
{
    0x43, 0x8D, 0x55, 0x0D, 0xE1, 0xB8, 0x6E, 0xA3,
    0x23, 0xF5, 0xA3, 0xEB, 0x56, 0xF0, 0x0D, 0x58,
    0x64, 0x89, 0x7D, 0xD0, 0x46, 0xD0, 0xDE, 0x57,
    0xA2, 0x9B, 0x4B, 0x40, 0xDF, 0xD0, 0x83, 0xEF,
};
static const uint8_t Vector_SM2_yv[] =
{
    0xE2, 0xFA, 0x47, 0x02, 0xAE, 0x00, 0x25, 0x16,
    0x15, 0xB8, 0x79, 0xAD, 0xDF, 0xD6, 0x0E, 0x6D,
    0xE8, 0x94, 0x8D, 0x74, 0xEB, 0x56, 0xC8, 0x76,
    0x7F, 0x94, 0xB0, 0x26, 0x7F, 0xA2, 0x88, 0xED
};
#endif /* USE_THE_SM2_CURVE */
#endif /* EIP130_ENABLE_ASYM_ALGO_SM2 */


/* Actual test vectors. */
static const TestVector_ECDSA_Rec_t test_vectors_ecdsa[] =
{
    {
        &ECurve_NIST_P192,
        Vector_P192_SHA1_PrivateKey, sizeof(Vector_P192_SHA1_PrivateKey),
        Vector_P192_SHA1_PublicKeyX, sizeof(Vector_P192_SHA1_PublicKeyX),
        Vector_P192_SHA1_PublicKeyY, sizeof(Vector_P192_SHA1_PublicKeyY),
        Vector_P192_SHA1_Message,    sizeof(Vector_P192_SHA1_Message),
        160,
        Vector_P192_SHA1_SignatureR, sizeof(Vector_P192_SHA1_SignatureR),
        Vector_P192_SHA1_SignatureS, sizeof(Vector_P192_SHA1_SignatureS),
    },
    {
        &ECurve_NIST_P192,
        Vector_P192_SHA224_PrivateKey, sizeof(Vector_P192_SHA224_PrivateKey),
        Vector_P192_SHA224_PublicKeyX, sizeof(Vector_P192_SHA224_PublicKeyX),
        Vector_P192_SHA224_PublicKeyY, sizeof(Vector_P192_SHA224_PublicKeyY),
        Vector_P192_SHA224_Message,    sizeof(Vector_P192_SHA224_Message),
        224,
        Vector_P192_SHA224_SignatureR, sizeof(Vector_P192_SHA224_SignatureR),
        Vector_P192_SHA224_SignatureS, sizeof(Vector_P192_SHA224_SignatureS),
    },
    {
        &ECurve_NIST_P192,
        Vector_P192_SHA256_PrivateKey, sizeof(Vector_P192_SHA256_PrivateKey),
        Vector_P192_SHA256_PublicKeyX, sizeof(Vector_P192_SHA256_PublicKeyX),
        Vector_P192_SHA256_PublicKeyY, sizeof(Vector_P192_SHA256_PublicKeyY),
        Vector_P192_SHA256_Message,    sizeof(Vector_P192_SHA256_Message),
        256,
        Vector_P192_SHA256_SignatureR, sizeof(Vector_P192_SHA256_SignatureR),
        Vector_P192_SHA256_SignatureS, sizeof(Vector_P192_SHA256_SignatureS),
    },
    {
        &ECurve_NIST_P224,
        Vector_P224_SHA1_PrivateKey, sizeof(Vector_P224_SHA1_PrivateKey),
        Vector_P224_SHA1_PublicKeyX, sizeof(Vector_P224_SHA1_PublicKeyX),
        Vector_P224_SHA1_PublicKeyY, sizeof(Vector_P224_SHA1_PublicKeyY),
        Vector_P224_SHA1_Message,    sizeof(Vector_P224_SHA1_Message),
        160,
        Vector_P224_SHA1_SignatureR, sizeof(Vector_P224_SHA1_SignatureR),
        Vector_P224_SHA1_SignatureS, sizeof(Vector_P224_SHA1_SignatureS),
    },
    {
        &ECurve_NIST_P224,
        Vector_P224_SHA224_PrivateKey, sizeof(Vector_P224_SHA224_PrivateKey),
        Vector_P224_SHA224_PublicKeyX, sizeof(Vector_P224_SHA224_PublicKeyX),
        Vector_P224_SHA224_PublicKeyY, sizeof(Vector_P224_SHA224_PublicKeyY),
        Vector_P224_SHA224_Message,    sizeof(Vector_P224_SHA224_Message),
        224,
        Vector_P224_SHA224_SignatureR, sizeof(Vector_P224_SHA224_SignatureR),
        Vector_P224_SHA224_SignatureS, sizeof(Vector_P224_SHA224_SignatureS),
    },
    {
        &ECurve_NIST_P224,
        Vector_P224_SHA256_PrivateKey, sizeof(Vector_P224_SHA256_PrivateKey),
        Vector_P224_SHA256_PublicKeyX, sizeof(Vector_P224_SHA256_PublicKeyX),
        Vector_P224_SHA256_PublicKeyY, sizeof(Vector_P224_SHA256_PublicKeyY),
        Vector_P224_SHA256_Message,    sizeof(Vector_P224_SHA256_Message),
        256,
        Vector_P224_SHA256_SignatureR, sizeof(Vector_P224_SHA256_SignatureR),
        Vector_P224_SHA256_SignatureS, sizeof(Vector_P224_SHA256_SignatureS),
    },
#ifdef EIP130_ENABLE_SYM_ALGO_SHA512
    {
        &ECurve_NIST_P224,
        Vector_P224_SHA384_PrivateKey, sizeof(Vector_P224_SHA384_PrivateKey),
        Vector_P224_SHA384_PublicKeyX, sizeof(Vector_P224_SHA384_PublicKeyX),
        Vector_P224_SHA384_PublicKeyY, sizeof(Vector_P224_SHA384_PublicKeyY),
        Vector_P224_SHA384_Message,    sizeof(Vector_P224_SHA384_Message),
        384,
        Vector_P224_SHA384_SignatureR, sizeof(Vector_P224_SHA384_SignatureR),
        Vector_P224_SHA384_SignatureS, sizeof(Vector_P224_SHA384_SignatureS),
    },
    {
        &ECurve_NIST_P224,
        Vector_P224_SHA512_PrivateKey, sizeof(Vector_P224_SHA512_PrivateKey),
        Vector_P224_SHA512_PublicKeyX, sizeof(Vector_P224_SHA512_PublicKeyX),
        Vector_P224_SHA512_PublicKeyY, sizeof(Vector_P224_SHA512_PublicKeyY),
        Vector_P224_SHA512_Message,    sizeof(Vector_P224_SHA512_Message),
        512,
        Vector_P224_SHA512_SignatureR, sizeof(Vector_P224_SHA512_SignatureR),
        Vector_P224_SHA512_SignatureS, sizeof(Vector_P224_SHA512_SignatureS),
    },
#endif /* EIP130_ENABLE_SYM_ALGO_SHA512 */
    {
        &ECurve_NIST_P256,
        Vector_P256_SHA1_PrivateKey, sizeof(Vector_P256_SHA1_PrivateKey),
        Vector_P256_SHA1_PublicKeyX, sizeof(Vector_P256_SHA1_PublicKeyX),
        Vector_P256_SHA1_PublicKeyY, sizeof(Vector_P256_SHA1_PublicKeyY),
        Vector_P256_SHA1_Message,    sizeof(Vector_P256_SHA1_Message),
        160,
        Vector_P256_SHA1_SignatureR, sizeof(Vector_P256_SHA1_SignatureR),
        Vector_P256_SHA1_SignatureS, sizeof(Vector_P256_SHA1_SignatureS),
    },
    {
        &ECurve_NIST_P256,
        Vector_P256_SHA224_PrivateKey, sizeof(Vector_P256_SHA224_PrivateKey),
        Vector_P256_SHA224_PublicKeyX, sizeof(Vector_P256_SHA224_PublicKeyX),
        Vector_P256_SHA224_PublicKeyY, sizeof(Vector_P256_SHA224_PublicKeyY),
        Vector_P256_SHA224_Message,    sizeof(Vector_P256_SHA224_Message),
        224,
        Vector_P256_SHA224_SignatureR, sizeof(Vector_P256_SHA224_SignatureR),
        Vector_P256_SHA224_SignatureS, sizeof(Vector_P256_SHA224_SignatureS),
    },
    {
        &ECurve_NIST_P256,
        Vector_P256_SHA256_PrivateKey, sizeof(Vector_P256_SHA256_PrivateKey),
        Vector_P256_SHA256_PublicKeyX, sizeof(Vector_P256_SHA256_PublicKeyX),
        Vector_P256_SHA256_PublicKeyY, sizeof(Vector_P256_SHA256_PublicKeyY),
        Vector_P256_SHA256_Message,    sizeof(Vector_P256_SHA256_Message),
        256,
        Vector_P256_SHA256_SignatureR, sizeof(Vector_P256_SHA256_SignatureR),
        Vector_P256_SHA256_SignatureS, sizeof(Vector_P256_SHA256_SignatureS),
    },
#ifdef EIP130_ENABLE_SYM_ALGO_SHA512
    {
        &ECurve_NIST_P256,
        Vector_P256_SHA384_PrivateKey, sizeof(Vector_P256_SHA384_PrivateKey),
        Vector_P256_SHA384_PublicKeyX, sizeof(Vector_P256_SHA384_PublicKeyX),
        Vector_P256_SHA384_PublicKeyY, sizeof(Vector_P256_SHA384_PublicKeyY),
        Vector_P256_SHA384_Message,    sizeof(Vector_P256_SHA384_Message),
        384,
        Vector_P256_SHA384_SignatureR, sizeof(Vector_P256_SHA384_SignatureR),
        Vector_P256_SHA384_SignatureS, sizeof(Vector_P256_SHA384_SignatureS),
    },
    {
        &ECurve_NIST_P256,
        Vector_P256_SHA512_PrivateKey, sizeof(Vector_P256_SHA512_PrivateKey),
        Vector_P256_SHA512_PublicKeyX, sizeof(Vector_P256_SHA512_PublicKeyX),
        Vector_P256_SHA512_PublicKeyY, sizeof(Vector_P256_SHA512_PublicKeyY),
        Vector_P256_SHA512_Message,    sizeof(Vector_P256_SHA512_Message),
        512,
        Vector_P256_SHA512_SignatureR, sizeof(Vector_P256_SHA512_SignatureR),
        Vector_P256_SHA512_SignatureS, sizeof(Vector_P256_SHA512_SignatureS),
    },
#endif /* EIP130_ENABLE_SYM_ALGO_SHA512 */
    {
        &ECurve_NIST_P384,
        Vector_P384_SHA1_PrivateKey, sizeof(Vector_P384_SHA1_PrivateKey),
        Vector_P384_SHA1_PublicKeyX, sizeof(Vector_P384_SHA1_PublicKeyX),
        Vector_P384_SHA1_PublicKeyY, sizeof(Vector_P384_SHA1_PublicKeyY),
        Vector_P384_SHA1_Message,    sizeof(Vector_P384_SHA1_Message),
        160,
        Vector_P384_SHA1_SignatureR, sizeof(Vector_P384_SHA1_SignatureR),
        Vector_P384_SHA1_SignatureS, sizeof(Vector_P384_SHA1_SignatureS),
    },
    {
        &ECurve_NIST_P384,
        Vector_P384_SHA224_PrivateKey, sizeof(Vector_P384_SHA224_PrivateKey),
        Vector_P384_SHA224_PublicKeyX, sizeof(Vector_P384_SHA224_PublicKeyX),
        Vector_P384_SHA224_PublicKeyY, sizeof(Vector_P384_SHA224_PublicKeyY),
        Vector_P384_SHA224_Message,    sizeof(Vector_P384_SHA224_Message),
        224,
        Vector_P384_SHA224_SignatureR, sizeof(Vector_P384_SHA224_SignatureR),
        Vector_P384_SHA224_SignatureS, sizeof(Vector_P384_SHA224_SignatureS),
    },
    {
        &ECurve_NIST_P384,
        Vector_P384_SHA256_PrivateKey, sizeof(Vector_P384_SHA256_PrivateKey),
        Vector_P384_SHA256_PublicKeyX, sizeof(Vector_P384_SHA256_PublicKeyX),
        Vector_P384_SHA256_PublicKeyY, sizeof(Vector_P384_SHA256_PublicKeyY),
        Vector_P384_SHA256_Message,    sizeof(Vector_P384_SHA256_Message),
        256,
        Vector_P384_SHA256_SignatureR, sizeof(Vector_P384_SHA256_SignatureR),
        Vector_P384_SHA256_SignatureS, sizeof(Vector_P384_SHA256_SignatureS),
    },
#ifdef EIP130_ENABLE_SYM_ALGO_SHA512
    {
        &ECurve_NIST_P384,
        Vector_P384_SHA384_PrivateKey, sizeof(Vector_P384_SHA384_PrivateKey),
        Vector_P384_SHA384_PublicKeyX, sizeof(Vector_P384_SHA384_PublicKeyX),
        Vector_P384_SHA384_PublicKeyY, sizeof(Vector_P384_SHA384_PublicKeyY),
        Vector_P384_SHA384_Message,    sizeof(Vector_P384_SHA384_Message),
        384,
        Vector_P384_SHA384_SignatureR, sizeof(Vector_P384_SHA384_SignatureR),
        Vector_P384_SHA384_SignatureS, sizeof(Vector_P384_SHA384_SignatureS),
    },
    {
        &ECurve_NIST_P384,
        Vector_P384_SHA512_PrivateKey, sizeof(Vector_P384_SHA512_PrivateKey),
        Vector_P384_SHA512_PublicKeyX, sizeof(Vector_P384_SHA512_PublicKeyX),
        Vector_P384_SHA512_PublicKeyY, sizeof(Vector_P384_SHA512_PublicKeyY),
        Vector_P384_SHA512_Message,    sizeof(Vector_P384_SHA512_Message),
        512,
        Vector_P384_SHA512_SignatureR, sizeof(Vector_P384_SHA512_SignatureR),
        Vector_P384_SHA512_SignatureS, sizeof(Vector_P384_SHA512_SignatureS),
    },
#endif /* EIP130_ENABLE_SYM_ALGO_SHA512 */
    {
        &ECurve_NIST_P521,
        Vector_P521_SHA1_PrivateKey, sizeof(Vector_P521_SHA1_PrivateKey),
        Vector_P521_SHA1_PublicKeyX, sizeof(Vector_P521_SHA1_PublicKeyX),
        Vector_P521_SHA1_PublicKeyY, sizeof(Vector_P521_SHA1_PublicKeyY),
        Vector_P521_SHA1_Message,    sizeof(Vector_P521_SHA1_Message),
        160,
        Vector_P521_SHA1_SignatureR, sizeof(Vector_P521_SHA1_SignatureR),
        Vector_P521_SHA1_SignatureS, sizeof(Vector_P521_SHA1_SignatureS),
    },
    {
        &ECurve_NIST_P521,
        Vector_P521_SHA224_PrivateKey, sizeof(Vector_P521_SHA224_PrivateKey),
        Vector_P521_SHA224_PublicKeyX, sizeof(Vector_P521_SHA224_PublicKeyX),
        Vector_P521_SHA224_PublicKeyY, sizeof(Vector_P521_SHA224_PublicKeyY),
        Vector_P521_SHA224_Message,    sizeof(Vector_P521_SHA224_Message),
        224,
        Vector_P521_SHA224_SignatureR, sizeof(Vector_P521_SHA224_SignatureR),
        Vector_P521_SHA224_SignatureS, sizeof(Vector_P521_SHA224_SignatureS),
    },
    {
        &ECurve_NIST_P521,
        Vector_P521_SHA256_PrivateKey, sizeof(Vector_P521_SHA256_PrivateKey),
        Vector_P521_SHA256_PublicKeyX, sizeof(Vector_P521_SHA256_PublicKeyX),
        Vector_P521_SHA256_PublicKeyY, sizeof(Vector_P521_SHA256_PublicKeyY),
        Vector_P521_SHA256_Message,    sizeof(Vector_P521_SHA256_Message),
        256,
        Vector_P521_SHA256_SignatureR, sizeof(Vector_P521_SHA256_SignatureR),
        Vector_P521_SHA256_SignatureS, sizeof(Vector_P521_SHA256_SignatureS),
    },
#ifdef EIP130_ENABLE_SYM_ALGO_SHA512
    {
        &ECurve_NIST_P521,
        Vector_P521_SHA384_PrivateKey, sizeof(Vector_P521_SHA384_PrivateKey),
        Vector_P521_SHA384_PublicKeyX, sizeof(Vector_P521_SHA384_PublicKeyX),
        Vector_P521_SHA384_PublicKeyY, sizeof(Vector_P521_SHA384_PublicKeyY),
        Vector_P521_SHA384_Message,    sizeof(Vector_P521_SHA384_Message),
        384,
        Vector_P521_SHA384_SignatureR, sizeof(Vector_P521_SHA384_SignatureR),
        Vector_P521_SHA384_SignatureS, sizeof(Vector_P521_SHA384_SignatureS),
    },
    {
        &ECurve_NIST_P521,
        Vector_P521_SHA512_PrivateKey, sizeof(Vector_P521_SHA512_PrivateKey),
        Vector_P521_SHA512_PublicKeyX, sizeof(Vector_P521_SHA512_PublicKeyX),
        Vector_P521_SHA512_PublicKeyY, sizeof(Vector_P521_SHA512_PublicKeyY),
        Vector_P521_SHA512_Message,    sizeof(Vector_P521_SHA512_Message),
        512,
        Vector_P521_SHA512_SignatureR, sizeof(Vector_P521_SHA512_SignatureR),
        Vector_P521_SHA512_SignatureS, sizeof(Vector_P521_SHA512_SignatureS),
    },
#endif /* EIP130_ENABLE_SYM_ALGO_SHA512 */
};


#ifdef EIP130_ENABLE_ASYM_ALGO_SM2
static const struct TestVector_SM2KEX_Rec test_vectors_sm2kex[] =
{
#ifdef USE_THE_SM2_CURVE
    {
        &ECurve_SM2_Fp_256,
        {
            {
                Vector_SM2_Kex_IdentityA, sizeof(Vector_SM2_Kex_IdentityA),
                {
                    Vector_SM2_PrivateKeyA, Vector_SM2_PublicKeyAX, Vector_SM2_PublicKeyAY
                },
                Vector_SM2_ZA,
                {
                    Vector_SM2_rA, Vector_SM2_RAx, Vector_SM2_RAy
                }
            },
            {
                Vector_SM2_Kex_IdentityB, sizeof(Vector_SM2_Kex_IdentityB),
                {
                    Vector_SM2_PrivateKeyB, Vector_SM2_PublicKeyBX, Vector_SM2_PublicKeyBY
                },
                Vector_SM2_ZB,
                {
                    Vector_SM2_rB, Vector_SM2_RBx, Vector_SM2_RBy
                }
            }
        },
        Vector_SM2_xv, Vector_SM2_yv,
        NULL
    },
    {
        &ECurve_SM2_Fp_192,
        {
            {
                Vector_SM2_Kex_IdentityA, sizeof(Vector_SM2_Kex_IdentityA),
                {
                    NULL, NULL, NULL
                },
                NULL,
                {
                    NULL, NULL, NULL
                }
            },
            {
                Vector_SM2_Kex_IdentityB, sizeof(Vector_SM2_Kex_IdentityB),
                {
                    NULL, NULL, NULL
                },
                NULL,
                {
                    NULL, NULL, NULL
                }
            }
        },
        NULL, NULL,
        NULL
    }
#else
    {
        &ECurve_NIST_P256,
        {
            {
                Vector_SM2_Kex_IdentityA, sizeof(Vector_SM2_Kex_IdentityA),
                {
                    Vector_SM2_PrivateKeyA, Vector_SM2_PublicKeyAX, Vector_SM2_PublicKeyAY
                },
                Vector_SM2_ZA,
                {
                    Vector_SM2_rA, Vector_SM2_RAx, Vector_SM2_RAy
                }
            },
            {
                Vector_SM2_Kex_IdentityB, sizeof(Vector_SM2_Kex_IdentityB),
                {
                    Vector_SM2_PrivateKeyB, Vector_SM2_PublicKeyBX, Vector_SM2_PublicKeyBY
                },
                Vector_SM2_ZB,
                {
                    Vector_SM2_rB, Vector_SM2_RBx, Vector_SM2_RBy
                }
            }
        },
        Vector_SM2_xv, Vector_SM2_yv,
        NULL
    },
    {
        &ECurve_NIST_P192,
        {
            {
                Vector_SM2_Kex_IdentityA, sizeof(Vector_SM2_Kex_IdentityA),
                {
                    NULL, NULL, NULL
                },
                NULL,
                {
                    NULL, NULL, NULL
                }
            },
            {
                Vector_SM2_Kex_IdentityB, sizeof(Vector_SM2_Kex_IdentityB),
                {
                    NULL, NULL, NULL
                },
                NULL,
                {
                    NULL, NULL, NULL
                }
            }
        },
        NULL, NULL,
        NULL
    }
#endif /* USE_THE_SM2_CURVE */
};

static const TestVector_SM2DSA_Rec_t test_vectors_sm2dsa[] =
{
#ifdef USE_THE_SM2_CURVE
    {
        &ECurve_SM2_Fp_256,
        Vector_SM2_Fp256_UserIdentity, sizeof(Vector_SM2_Fp256_UserIdentity),
        Vector_SM2_Fp256_PrivateKey,   sizeof(Vector_SM2_Fp256_PrivateKey),
        Vector_SM2_Fp256_PublicKeyX,   sizeof(Vector_SM2_Fp256_PublicKeyX),
        Vector_SM2_Fp256_PublicKeyY,   sizeof(Vector_SM2_Fp256_PublicKeyY),
        Vector_SM2_Fp256_Message,      sizeof(Vector_SM2_Fp256_Message),
        256,
        Vector_SM2_Fp256_SignatureR,   sizeof(Vector_SM2_Fp256_SignatureR),
        Vector_SM2_Fp256_SignatureS,   sizeof(Vector_SM2_Fp256_SignatureS)
    },
    {
        // Same private and public keys, but slightly bigger message
        &ECurve_SM2_Fp_256,
        Vector_SM2_Fp256_UserIdentity, sizeof(Vector_SM2_Fp256_UserIdentity),
        Vector_SM2_Fp256_PrivateKey,   sizeof(Vector_SM2_Fp256_PrivateKey),
        Vector_SM2_Fp256_PublicKeyX,   sizeof(Vector_SM2_Fp256_PublicKeyX),
        Vector_SM2_Fp256_PublicKeyY,   sizeof(Vector_SM2_Fp256_PublicKeyY),
        Vector_SM2_Fp256_Message_2,    sizeof(Vector_SM2_Fp256_Message_2),
        256,
        Vector_SM2_Fp256_SignatureR_2, sizeof(Vector_SM2_Fp256_SignatureR_2),
        Vector_SM2_Fp256_SignatureS_2, sizeof(Vector_SM2_Fp256_SignatureS_2)
    }
#else
    {
        &ECurve_NIST_P256,
        Vector_SM2_Fp256_UserIdentity, sizeof(Vector_SM2_Fp256_UserIdentity),
        Vector_SM2_Np256_PrivateKey,   sizeof(Vector_SM2_Np256_PrivateKey),
        Vector_SM2_Np256_PublicKeyX,   sizeof(Vector_SM2_Np256_PublicKeyX),
        Vector_SM2_Np256_PublicKeyY,   sizeof(Vector_SM2_Np256_PublicKeyY),
        Vector_SM2_Fp256_Message,      sizeof(Vector_SM2_Fp256_Message),
        256,
        Vector_SM2_Np256_SignatureR,   sizeof(Vector_SM2_Np256_SignatureR),
        Vector_SM2_Np256_SignatureS,   sizeof(Vector_SM2_Np256_SignatureS)
    },
    {
        // Same private and public keys, but slightly bigger message
        &ECurve_NIST_P256,
        Vector_SM2_Fp256_UserIdentity, sizeof(Vector_SM2_Fp256_UserIdentity),
        Vector_SM2_Np256_PrivateKey,   sizeof(Vector_SM2_Np256_PrivateKey),
        Vector_SM2_Np256_PublicKeyX,   sizeof(Vector_SM2_Np256_PublicKeyX),
        Vector_SM2_Np256_PublicKeyY,   sizeof(Vector_SM2_Np256_PublicKeyY),
        Vector_SM2_Fp256_Message_2,    sizeof(Vector_SM2_Fp256_Message_2),
        256,
        Vector_SM2_Np256_SignatureR_2,   sizeof(Vector_SM2_Np256_SignatureR_2),
        Vector_SM2_Np256_SignatureS_2,   sizeof(Vector_SM2_Np256_SignatureS_2)
    }
#endif /* USE_THE_SM2_CURVE */
};
#endif /* EIP130_ENABLE_ASYM_ALGO_SM2 */

/* end of file testvectors_ecdsa_data.h */
