/*
 * Copyright (c) 2024, Texas Instruments Incorporated
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * This file is a trimmed-down and modified version of the flash_layout.h
 * generated by the secure image build process. It contains only the defines
 * needed to build the TF-M Internal Trusted Storage (ITS) component, needed for
 * key storage. It has been modified to remove the PS and NV counter areas. This
 * file is only used for tfm_disabled builds.
 */

#ifndef __FLASH_LAYOUT_H__
#define __FLASH_LAYOUT_H__

#include <DeviceFamily.h>

#define PROGRAM_UNIT 1


#if (DeviceFamily_PARENT == DeviceFamily_PARENT_CC27XX)
    #include DeviceFamily_constructPath(inc/hw_device.h)
    #define BASE 0x0
    #define SIZE FLASH_MAIN_SW_SIZE /* FLASH_MAIN_SIZE - HSM_FW_SIZE in driverlib */
    #define SECTOR_SIZE FLASH_MAIN_SECTOR_SIZE /* 2 KB for 1M CC27XX */
#elif (DeviceFamily_PARENT == DeviceFamily_PARENT_CC35XX)
    /* Generated in ti_flash_map_config.c by Memory Map SysConfig module */
    extern const uint32_t key_storage_physical_slot_address;
    extern const uint32_t key_storage_region_size;
    #define BASE key_storage_physical_slot_address /* XMEM KeyStore Region physical address base */
    #define SIZE key_storage_region_size /* Size of KeyStore's XMEM region */
    #define SECTOR_SIZE 0x1000 /* 4 KB */
#endif

#define FLASH0_BASE_S        (BASE)
#define FLASH0_SIZE          (SIZE)
#define FLASH0_SECTOR_SIZE   (SECTOR_SIZE)
#define FLASH0_PAGE_SIZE     (SECTOR_SIZE)
#define FLASH0_PROGRAM_UNIT  (PROGRAM_UNIT)         /* Minimum write size */

/* Sector size of the flash hardware */
#define FLASH_AREA_IMAGE_SECTOR_SIZE FLASH0_SECTOR_SIZE
#define FLASH_TOTAL_SIZE             FLASH0_SIZE

/* Internal Trusted Storage (ITS) Service definitions */
#if (DeviceFamily_PARENT == DeviceFamily_PARENT_CC27XX)
#if ((defined (__GNUC__) && !defined (__clang__)))
    #define FLASH_ITS_AREA_ADDR ((FLASH_TOTAL_SIZE - FLASH_ITS_AREA_SIZE) + FLASH0_BASE_S)
#else
    extern const void *FLASH_ITS_ADDRESS;
    #define FLASH_ITS_AREA_ADDR ((uint32_t)FLASH_ITS_ADDRESS)
#endif
    /* This represents the size of the ITS area specifically.
     * For CC35XX, the ITS area is the only flash region known
     * to ITS. For CC27XX, the ITS area is calculated relative
     * to the whole flash available on the device.
     */
    extern const size_t FLASH_ITS_SIZE;
    #define FLASH_ITS_AREA_SIZE   (FLASH_ITS_SIZE)
#elif (DeviceFamily_PARENT == DeviceFamily_PARENT_CC35XX)
    /* Generated in ti_flash_map_config.c by Memory Map SysConfig module */
    extern const uint32_t key_storage_logical_slot_address;
    #define FLASH_ITS_AREA_SIZE (FLASH0_SIZE) /* Entire XMEM region is dedicated to ITS */
    /* XMEM KeyStore Region physical address base - note that 'offset' and 'base' are used
     * interchangeably since the XMEM region is the ONLY region of flash that CC35XX ITS is aware of.
     */
    #define FLASH_ITS_AREA_ADDR (FLASH0_BASE_S)
    #define FLASH_ITS_AREA_LOGICAL_ADDR (key_storage_logical_slot_address) /* XMEM KeyStore Region logical address base */
#endif

/*
 * Internal Trusted Storage (ITS) Service definitions
 * Note: Further documentation of these definitions can be found in the
 * TF-M ITS Integration Guide.
 */

#define TFM_HAL_ITS_FLASH_DRIVER Driver_FLASH0

#define TFM_HAL_ITS_FLASH_AREA_ADDR    FLASH_ITS_AREA_ADDR
/* Dedicated flash area for ITS */
#define TFM_HAL_ITS_FLASH_AREA_SIZE    FLASH_ITS_AREA_SIZE
#define TFM_HAL_ITS_SECTOR_SIZE        FLASH_AREA_IMAGE_SECTOR_SIZE
/* Number of ITS_SECTOR_SIZE per block */
#define TFM_HAL_ITS_SECTORS_PER_BLOCK  (1)
/* Specifies the smallest flash programmable unit in bytes */
#define TFM_HAL_ITS_PROGRAM_UNIT FLASH0_PROGRAM_UNIT

#endif /* __FLASH_LAYOUT_H__ */
