/*
 * Decompiled with CFR 0.152.
 */
package com.ti.msp430.imagereformer;

import com.ti.msp430.imagereformer.ImageWindow;
import com.ti.msp430.imagereformer.Output;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class ImageDisplay
extends JPanel {
    private static final long serialVersionUID = -6519689355657597475L;
    BufferedImage thisImage;
    ImageWindow imageWin;
    JLabel xlabel = new JLabel();
    JLabel ylabel = new JLabel();
    TextField xsize = new TextField();
    TextField ysize = new TextField();
    JPanel imageSize = new JPanel();
    JLabel depth = new JLabel();
    JLabel colorSpace = new JLabel();
    ColorPalette paletteBar;
    JPanel compressionAndPalletPanel = new JPanel();
    JRadioButton uncompressedButton = new JRadioButton("Compression Off");
    JRadioButton compressedButton = new JRadioButton("Compression On");
    JPanel palletPanel = new JPanel();
    public JRadioButton adaptivePallet = new JRadioButton("Adaptive Pallet");
    public JRadioButton standardPallet = new JRadioButton("Standard Pallet");
    Panel stats = new Panel();
    Panel topLine = new Panel();
    String title;

    public void setXsize(int xsize) {
        this.xsize.setText(Integer.toString(xsize));
    }

    public void setYsize(int ysize) {
        this.ysize.setText(Integer.toString(ysize));
    }

    public ImageDisplay() {
        this.setLayout(new BorderLayout());
    }

    public ImageDisplay(BufferedImage myBufferedImage, String title) {
        this();
        this.thisImage = myBufferedImage;
        this.title = title;
        this.imageWin = new ImageWindow(myBufferedImage);
        this.add((Component)this.imageWin, "Center");
        this.xlabel.setText(" Width: ");
        if (myBufferedImage != null) {
            this.xsize.setText(Integer.toString(myBufferedImage.getWidth()));
        }
        this.xsize.setEditable(true);
        this.ylabel.setText(" Height: ");
        if (myBufferedImage != null) {
            this.ysize.setText(Integer.toString(myBufferedImage.getHeight()));
        }
        this.imageSize.setLayout(new GridLayout(1, 4));
        this.imageSize.add(this.xlabel);
        this.imageSize.add(this.xsize);
        this.imageSize.add(this.ylabel);
        this.imageSize.add(this.ysize);
        if (this.thisImage != null) {
            this.depth.setText("Color Depth: " + myBufferedImage.getColorModel().getPixelSize());
        }
        if (this.thisImage != null) {
            this.colorSpace.setText("Color Space: " + System.getProperty("java.version"));
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.uncompressedButton);
        group.add(this.compressedButton);
        ButtonGroup pallet = new ButtonGroup();
        pallet.add(this.standardPallet);
        pallet.add(this.adaptivePallet);
        this.compressionAndPalletPanel.setLayout(new GridLayout(1, 4));
        this.compressionAndPalletPanel.add(this.uncompressedButton);
        this.compressionAndPalletPanel.add(this.compressedButton);
        this.uncompressedButton.setSelected(true);
        this.compressionAndPalletPanel.add(this.standardPallet);
        this.compressionAndPalletPanel.add(this.adaptivePallet);
        this.standardPallet.setSelected(true);
        this.stats.setLayout(new GridLayout(2, 1));
        this.topLine.setLayout(new GridLayout(1, 3));
        this.topLine.add(this.imageSize);
        Button t = new Button(title);
        t.setEnabled(false);
        this.topLine.add(t);
        this.topLine.add(this.depth);
        this.stats.add(this.topLine);
        this.stats.add(this.compressionAndPalletPanel);
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        this.imageSize.setBorder(loweredbevel);
        this.depth.setBorder(loweredbevel);
        this.colorSpace.setBorder(loweredbevel);
        this.compressionAndPalletPanel.setBorder(loweredbevel);
        this.setBorder(compound);
        if (this.thisImage != null) {
            this.paletteBar = new ColorPalette(this.thisImage.getWidth());
            this.add((Component)this.paletteBar, "South");
        }
        this.add((Component)this.stats, "North");
        this.validate();
    }

    Dimension calculateSize() {
        Dimension statD = this.stats.getSize();
        Dimension iD = this.imageWin.getSize();
        Dimension pD = this.paletteBar.getSize();
        Dimension d = new Dimension(statD.width + iD.width + pD.width, statD.height + iD.height + pD.height);
        return d;
    }

    public void addActionListener(ActionListener l) {
        this.xsize.addActionListener(l);
        this.ysize.addActionListener(l);
    }

    public boolean isAlreadyAFocusListener(Component c, FocusListener l) {
        FocusListener[] fl = c.getFocusListeners();
        for (int i = 0; i < fl.length; ++i) {
            if (fl[i] != l) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addFocusListener(FocusListener l) {
        if (!this.isAlreadyAFocusListener(this.xsize, l)) {
            this.xsize.addFocusListener(l);
        }
        if (!this.isAlreadyAFocusListener(this.ysize, l)) {
            this.ysize.addFocusListener(l);
        }
    }

    public void allowChange(boolean allow) {
        this.xsize.setEditable(allow);
        this.ysize.setEditable(allow);
        this.uncompressedButton.setEnabled(allow);
        this.compressedButton.setEnabled(allow);
        this.stats.setEnabled(allow);
        this.topLine.setEnabled(allow);
    }

    public int getXsize() {
        String val = this.xsize.getText();
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public int getYsize() {
        String val = this.ysize.getText();
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public BufferedImage getThisImage() {
        return this.thisImage;
    }

    public JRadioButton getAdaptivePallet() {
        return this.adaptivePallet;
    }

    public JRadioButton getStandardPallet() {
        return this.standardPallet;
    }

    public void setThisImage(BufferedImage thisImage) {
        this.thisImage = thisImage;
    }

    public int getCompression() {
        if (this.uncompressedButton.isSelected()) {
            return Output.UNCOMPRESSED;
        }
        if (this.compressedButton.isSelected()) {
            return Output.COMPRESSED;
        }
        return -1;
    }

    public void setCompression(int comp) {
        if (comp == Output.COMPRESSED) {
            this.compressedButton.setSelected(true);
        } else {
            this.uncompressedButton.setSelected(true);
        }
    }

    class ColorPalette
    extends Button {
        private static final long serialVersionUID = 6539790657871467337L;
        Dimension dimension;
        byte[] rr;
        byte[] bb;
        byte[] gg;
        int numColorsInPalette;
        int width;

        public ColorPalette(int width) {
            this.setEnabled(false);
            this.width = width;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (ImageDisplay.this.thisImage != null) {
                this.dimension = this.getSize();
                ColorModel cm = ImageDisplay.this.thisImage.getColorModel();
                if (cm instanceof IndexColorModel) {
                    IndexColorModel icm = (IndexColorModel)cm;
                    this.numColorsInPalette = icm.getMapSize();
                    this.rr = new byte[this.numColorsInPalette];
                    this.bb = new byte[this.numColorsInPalette];
                    this.gg = new byte[this.numColorsInPalette];
                    System.out.println("numColorsInPalette:" + this.numColorsInPalette);
                    icm.getReds(this.rr);
                    icm.getGreens(this.gg);
                    icm.getBlues(this.bb);
                    int offset = 1;
                    Vector<ComparibleColor> v = new Vector<ComparibleColor>();
                    for (int i = 0; i < this.numColorsInPalette; ++i) {
                        try {
                            ComparibleColor myColor = new ComparibleColor(this.rr[i] & 0xFF, this.gg[i] & 0xFF, this.bb[i] & 0xFF);
                            v.addElement(myColor);
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println(e + " r: " + this.rr[i] + " g: " + this.gg[i] + " b: " + this.bb[i]);
                        }
                    }
                    Collections.sort(v);
                    float barSize = (float)this.dimension.width / (float)v.size();
                    int intBarSize = (int)Math.ceil(barSize);
                    System.out.println("barSize" + barSize + " offset:" + offset + " intBarSize:" + intBarSize);
                    for (int i = 0; i < v.size(); ++i) {
                        ComparibleColor myColor = (ComparibleColor)v.elementAt(i);
                        g.setColor(myColor);
                        g.fillRect(intBarSize * i, 0, intBarSize * offset, this.dimension.height);
                        g.setColor(Color.BLACK);
                        g.drawRect(intBarSize * i, 0, intBarSize * offset, this.dimension.height);
                        ++offset;
                    }
                }
            }
        }
    }

    class ComparibleColor
    extends Color
    implements Comparable<Object> {
        private static final long serialVersionUID = 346418231120947948L;

        public ComparibleColor(int arg0, int arg1, int arg2) {
            super(arg0, arg1, arg2);
        }

        @Override
        public int compareTo(Object arg0) {
            Color c = (Color)arg0;
            if (c.getRGB() > this.getRGB()) {
                return -1;
            }
            if (c.getRGB() < this.getRGB()) {
                return 1;
            }
            return 0;
        }
    }
}

