/*
 * Copyright (c) 2025, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdbool.h>

#include <ti/drivers/GPIO.h>
#include <ti/drivers/gpio/GPIOWFF3.h>
#include <ti/drivers/ITM.h>
#include <ti/drivers/itm/ITMWFF3.h>

#include <ti/devices/DeviceFamily.h>
#include DeviceFamily_constructPath(inc/hw_iomux.h)

#define SWO_TRACE_SIGNAL_M 0xFFFFFDFF

/* This enables the device specific hwAttrs to be cast as the generic ones
 * The hwAttrs will be generated by syscfg.
 */
extern void *itmHwAttrs;

/*
 *  ======== ITM_applyPinMux ========
 */
bool ITM_applyPinMux(void)
{
    ITMWFF3_HWAttrs *hwAttrs = (ITMWFF3_HWAttrs *)itmHwAttrs;

    GPIO_setConfigAndMux(hwAttrs->swoPin,
                         ((GPIO_CFG_OUTPUT | GPIO_CFG_OUT_HIGH) & SWO_TRACE_SIGNAL_M),
                         IOMUX_GPIO35PCFG_IOSEL_SEL_27);

    return true;
}

/*
 *  ======== ITM_clearPinMux ========
 */
void ITM_clearPinMux(void)
{
    ITMWFF3_HWAttrs *hwAttrs = (ITMWFF3_HWAttrs *)itmHwAttrs;
    GPIO_resetConfig(hwAttrs->swoPin);
}

/*
 *  ======== ITMWFF3_flush ========
 */
void ITMWFF3_flush(void)
{
    ITMWFF3_HWAttrs *hwAttrs = (ITMWFF3_HWAttrs *)itmHwAttrs;
    /* Release the SWO pin from the ITM */
    GPIO_setConfigAndMux(hwAttrs->swoPin, GPIO_CFG_OUTPUT | GPIO_CFG_OUT_HIGH, GPIO_MUX_GPIO);
}

/*
 *  ======== ITMWFF3_restore ========
 */
void ITMWFF3_restore(void)
{
    ITMWFF3_HWAttrs *hwAttrs = (ITMWFF3_HWAttrs *)itmHwAttrs;
    /* Return SWO pin to the ITM hardware*/
    GPIO_setConfigAndMux(hwAttrs->swoPin,
                         ((GPIO_CFG_OUTPUT | GPIO_CFG_OUT_HIGH) & SWO_TRACE_SIGNAL_M),
                         IOMUX_GPIO35PCFG_IOSEL_SEL_27);
}
