/* testvectors_xts_aes_data.h
 *
 * Description: XTS-AES test vector data, some vectors from XTSTestVectors.zip.
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

#ifndef INCLUDE_GUARD_TEST_VECTORS_XTS_AES_DATA_H
#define INCLUDE_GUARD_TEST_VECTORS_XTS_AES_DATA_H

#include <third_party/hsmddk/include/Kit/DriverFramework/Basic_Defs_API/incl/basic_defs.h>

/* XTS-AES-128 */
/*
#  CAVS 11.0
#  XTSGen information
#  State tested: Encrypt/Decrypt
#  Key Length:  AES128
#  Data Unit Lengths Tested: 128 256 130 200 256
#  Generated on Tue Mar 01 08:39:46 2011

[ENCRYPT]

COUNT = 1
DataUnitLen = 128
Key = a1b90cba3f06ac353b2c343876081762090923026e91771815f29dab01932f2f
i = 4faef7117cda59c66e4b92013e768ad5
PT = ebabce95b14d3c8d6fb350390790311c
CT = 778ae8b43cb98d5a825081d5be471c63
*/
static const uint8_t V128_1_key[] =
{
    0xa1, 0xb9, 0x0c, 0xba, 0x3f, 0x06, 0xac, 0x35, 0x3b, 0x2c, 0x34, 0x38, 0x76, 0x08, 0x17, 0x62,
    0x09, 0x09, 0x23, 0x02, 0x6e, 0x91, 0x77, 0x18, 0x15, 0xf2, 0x9d, 0xab, 0x01, 0x93, 0x2f, 0x2f,
};
static const uint8_t V128_1_tweak[] =
{
    0x4f, 0xae, 0xf7, 0x11, 0x7c, 0xda, 0x59, 0xc6, 0x6e, 0x4b, 0x92, 0x01, 0x3e, 0x76, 0x8a, 0xd5,
};
static const uint8_t V128_1_ptx[] =
{
    0xeb, 0xab, 0xce, 0x95, 0xb1, 0x4d, 0x3c, 0x8d, 0x6f, 0xb3, 0x50, 0x39, 0x07, 0x90, 0x31, 0x1c,
};
static const uint8_t V128_1_ctx[] =
{
    0x77, 0x8a, 0xe8, 0xb4, 0x3c, 0xb9, 0x8d, 0x5a, 0x82, 0x50, 0x81, 0xd5, 0xbe, 0x47, 0x1c, 0x63,
};

/*
#  CAVS 16.2
#  XTSGen information
#  State tested: Encrypt/Decrypt
#  Key Length:  AES128
#  Data Unit Lengths Tested: 128 256 65536
#  Generated on Fri Apr 04 10:25:58 2014

[ENCRYPT]

COUNT = 1
DataUnitLen = 128
Key = 6e6a8497b532c21107a077bff09b6b398b835431159bacbdb5cd3d7e0f20cbbe
i = 82b104ac669b16adfa252d952e9f3cf3
PT = 69ab9c45b7a2672ab0bd8aabd6d2726c
CT = a606642eddb298afa552df2a314e6937
*/
static const uint8_t V128_2_key[] =
{
    0x6E, 0x6A, 0x84, 0x97, 0xB5, 0x32, 0xC2, 0x11, 0x07, 0xA0, 0x77, 0xBF, 0xF0, 0x9B, 0x6B, 0x39,
    0x8B, 0x83, 0x54, 0x31, 0x15, 0x9B, 0xAC, 0xBD, 0xB5, 0xCD, 0x3D, 0x7E, 0x0F, 0x20, 0xCB, 0xBE,
};
static const uint8_t V128_2_tweak[] =
{
    0x82, 0xB1, 0x04, 0xAC, 0x66, 0x9B, 0x16, 0xAD, 0xFA, 0x25, 0x2D, 0x95, 0x2E, 0x9F, 0x3C, 0xF3,
};
static const uint8_t V128_2_ptx[] =
{
    0x69, 0xAB, 0x9C, 0x45, 0xB7, 0xA2, 0x67, 0x2A, 0xB0, 0xBD, 0x8A, 0xAB, 0xD6, 0xD2, 0x72, 0x6C,
};
static const uint8_t V128_2_ctx[] =
{
    0xA6, 0x06, 0x64, 0x2E, 0xDD, 0xB2, 0x98, 0xAF, 0xA5, 0x52, 0xDF, 0x2A, 0x31, 0x4E, 0x69, 0x37,
};

/*
#  CAVS 16.2
#  XTSGen information
#  State tested: Encrypt/Decrypt
#  Key Length:  AES128
#  Data Unit Lengths Tested: 128 256 65536
#  Generated on Fri Apr 04 10:25:58 2014

[ENCRYPT]

COUNT = 101
DataUnitLen = 256
Key = ff96b20a0161af79f793217d8e2890af2528609c0ccfe584dbc8eeeb0e47f6fb
i = 4c69621913d49a3b28af59d781480440
PT = 5cb436dd5ad48ecd923864e073e9324d88206437d30b196e4d6d2697f1aba9e1
CT = 297e3460099abfcaa3601b99723dd5bdeb6617143d7d1f81fc6fffec3e8cc65e
*/
static const uint8_t V128_3_key[] =
{
    0xFF, 0x96, 0xB2, 0x0A, 0x01, 0x61, 0xAF, 0x79, 0xF7, 0x93, 0x21, 0x7D, 0x8E, 0x28, 0x90, 0xAF,
    0x25, 0x28, 0x60, 0x9C, 0x0C, 0xCF, 0xE5, 0x84, 0xDB, 0xC8, 0xEE, 0xEB, 0x0E, 0x47, 0xF6, 0xFB,
};
static const uint8_t V128_3_tweak[] =
{
    0x4C, 0x69, 0x62, 0x19, 0x13, 0xD4, 0x9A, 0x3B, 0x28, 0xAF, 0x59, 0xD7, 0x81, 0x48, 0x04, 0x40,
};
static const uint8_t V128_3_ptx[] =
{
    0x5C, 0xB4, 0x36, 0xDD, 0x5A, 0xD4, 0x8E, 0xCD, 0x92, 0x38, 0x64, 0xE0, 0x73, 0xE9, 0x32, 0x4D,
    0x88, 0x20, 0x64, 0x37, 0xD3, 0x0B, 0x19, 0x6E, 0x4D, 0x6D, 0x26, 0x97, 0xF1, 0xAB, 0xA9, 0xE1,
};
static const uint8_t V128_3_ctx[] =
{
    0x29, 0x7E, 0x34, 0x60, 0x09, 0x9A, 0xBF, 0xCA, 0xA3, 0x60, 0x1B, 0x99, 0x72, 0x3D, 0xD5, 0xBD,
    0xEB, 0x66, 0x17, 0x14, 0x3D, 0x7D, 0x1F, 0x81, 0xFC, 0x6F, 0xFF, 0xEC, 0x3E, 0x8C, 0xC6, 0x5E,
};

/*
#  CAVS 11.0
#  XTSGen information
#  State tested: Encrypt/Decrypt
#  Key Length:  AES128
#  Data Unit Lengths Tested: 128 256 130 200 256
#  Generated on Tue Mar 01 08:39:46 2011

[ENCRYPT]

COUNT = 301
DataUnitLen = 200
Key = 394c97881abd989d29c703e48a72b397a7acf51b59649eeea9b33274d8541df4
i = 4b15c684a152d485fe9937d39b168c29
PT = 2f3b9dcfbae729583b1d1ffdd16bb6fe2757329435662a78f0
CT = f3473802e38a3ffef4d4fb8e6aa266ebde553a64528a06463e
*/
static const uint8_t V128_4_key[] =
{
    0x39, 0x4c, 0x97, 0x88, 0x1a, 0xbd, 0x98, 0x9d, 0x29, 0xc7, 0x03, 0xe4, 0x8a, 0x72, 0xb3, 0x97,
    0xa7, 0xac, 0xf5, 0x1b, 0x59, 0x64, 0x9e, 0xee, 0xa9, 0xb3, 0x32, 0x74, 0xd8, 0x54, 0x1d, 0xf4,
};
static const uint8_t V128_4_ptx[] =
{
    0x2f, 0x3b, 0x9d, 0xcf, 0xba, 0xe7, 0x29, 0x58, 0x3b, 0x1d, 0x1f, 0xfd, 0xd1, 0x6b, 0xb6, 0xfe,
    0x27, 0x57, 0x32, 0x94, 0x35, 0x66, 0x2a, 0x78, 0xf0,
};
static const uint8_t V128_4_ctx[] =
{
    0xf3, 0x47, 0x38, 0x02, 0xe3, 0x8a, 0x3f, 0xfe, 0xf4, 0xd4, 0xfb, 0x8e, 0x6a, 0xa2, 0x66, 0xeb,
    0xde, 0x55, 0x3a, 0x64, 0x52, 0x8a, 0x06, 0x46, 0x3e,
};
static const uint8_t V128_4_tweak[] = {
    0x4b, 0x15, 0xc6, 0x84, 0xa1, 0x52, 0xd4, 0x85, 0xfe, 0x99, 0x37, 0xd3, 0x9b, 0x16, 0x8c, 0x29,
};


/* XTS-AES-256 */
/*
#  CAVS 11.0
#  XTSGen information
#  State tested: Encrypt/Decrypt
#  Key Length:  AES256
#  Data Unit Lengths Tested: 256 384 140 250 384
#  Generated on Tue Mar 01 08:39:52 2011

[ENCRYPT]

COUNT = 1
DataUnitLen = 256
Key = 1ea661c58d943a0e4801e42f4b0947149e7f9f8e3e68d0c7505210bd311a0e7cd6e13ffdf2418d8d1911c004cda58da3d619b7e2b9141e58318eea392cf41b08
i = adf8d92627464ad2f0428e84a9f87564
PT = 2eedea52cd8215e1acc647e810bbc3642e87287f8d2e57e36c0a24fbc12a202e
CT = cbaad0e2f6cea3f50b37f934d46a9b130b9d54f07e34f36af793e86f73c6d7db
*/
static const uint8_t V256_1_key[] =
{
    0x1e, 0xa6, 0x61, 0xc5, 0x8d, 0x94, 0x3a, 0x0e, 0x48, 0x01, 0xe4, 0x2f, 0x4b, 0x09, 0x47, 0x14,
    0x9e, 0x7f, 0x9f, 0x8e, 0x3e, 0x68, 0xd0, 0xc7, 0x50, 0x52, 0x10, 0xbd, 0x31, 0x1a, 0x0e, 0x7c,
    0xd6, 0xe1, 0x3f, 0xfd, 0xf2, 0x41, 0x8d, 0x8d, 0x19, 0x11, 0xc0, 0x04, 0xcd, 0xa5, 0x8d, 0xa3,
    0xd6, 0x19, 0xb7, 0xe2, 0xb9, 0x14, 0x1e, 0x58, 0x31, 0x8e, 0xea, 0x39, 0x2c, 0xf4, 0x1b, 0x08,
};
static const uint8_t V256_1_tweak[] =
{
    0xad, 0xf8, 0xd9, 0x26, 0x27, 0x46, 0x4a, 0xd2, 0xf0, 0x42, 0x8e, 0x84, 0xa9, 0xf8, 0x75, 0x64,
};
static const uint8_t V256_1_ptx[] =
{
    0x2e, 0xed, 0xea, 0x52, 0xcd, 0x82, 0x15, 0xe1, 0xac, 0xc6, 0x47, 0xe8, 0x10, 0xbb, 0xc3, 0x64,
    0x2e, 0x87, 0x28, 0x7f, 0x8d, 0x2e, 0x57, 0xe3, 0x6c, 0x0a, 0x24, 0xfb, 0xc1, 0x2a, 0x20, 0x2e,
};
static const uint8_t V256_1_ctx[] =
{
    0xcb, 0xaa, 0xd0, 0xe2, 0xf6, 0xce, 0xa3, 0xf5, 0x0b, 0x37, 0xf9, 0x34, 0xd4, 0x6a, 0x9b, 0x13,
    0x0b, 0x9d, 0x54, 0xf0, 0x7e, 0x34, 0xf3, 0x6a, 0xf7, 0x93, 0xe8, 0x6f, 0x73, 0xc6, 0xd7, 0xdb,
};

/*
#  CAVS 16.2
#  XTSGen information
#  State tested: Encrypt/Decrypt
#  Key Length:  AES256
#  Data Unit Lengths Tested: 128 256 65536
#  Generated on Fri Apr 04 10:30:19 2014

[ENCRYPT]

COUNT = 1
DataUnitLen = 128
Key = 749a7f8e9a75866e08fd7997c5609099966545f2f2535bded652dc4ea4f4af75add1844a9d92a9fa03f19cf5788ef056b7e983d3e6123787e0a1e290c2ddc617
i = d21514e9b2798c1b600b6862111f7ea2
PT = 8ed1125ec1cc8c43e7babaec0dd7b409
CT = 8bc04d2b4bef2cdf9073987edd778075
*/
static const uint8_t V256_2_key[] =
{
    0x74, 0x9A, 0x7F, 0x8E, 0x9A, 0x75, 0x86, 0x6E, 0x08, 0xFD, 0x79, 0x97, 0xC5, 0x60, 0x90, 0x99,
    0x96, 0x65, 0x45, 0xF2, 0xF2, 0x53, 0x5B, 0xDE, 0xD6, 0x52, 0xDC, 0x4E, 0xA4, 0xF4, 0xAF, 0x75,
    0xAD, 0xD1, 0x84, 0x4A, 0x9D, 0x92, 0xA9, 0xFA, 0x03, 0xF1, 0x9C, 0xF5, 0x78, 0x8E, 0xF0, 0x56,
    0xB7, 0xE9, 0x83, 0xD3, 0xE6, 0x12, 0x37, 0x87, 0xE0, 0xA1, 0xE2, 0x90, 0xC2, 0xDD, 0xC6, 0x17,
};
static const uint8_t V256_2_tweak[] =
{
    0xD2, 0x15, 0x14, 0xE9, 0xB2, 0x79, 0x8C, 0x1B, 0x60, 0x0B, 0x68, 0x62, 0x11, 0x1F, 0x7E, 0xA2,
};
static const uint8_t V256_2_ptx[] =
{
    0x8E, 0xD1, 0x12, 0x5E, 0xC1, 0xCC, 0x8C, 0x43, 0xE7, 0xBA, 0xBA, 0xEC, 0x0D, 0xD7, 0xB4, 0x09,
};
static const uint8_t V256_2_ctx[] =
{
    0x8B, 0xC0, 0x4D, 0x2B, 0x4B, 0xEF, 0x2C, 0xDF, 0x90, 0x73, 0x98, 0x7E, 0xDD, 0x77, 0x80, 0x75,
};

/*
#  CAVS 16.2
#  XTSGen information
#  State tested: Encrypt/Decrypt
#  Key Length:  AES256
#  Data Unit Lengths Tested: 128 256 65536
#  Generated on Fri Apr 04 10:30:19 2014

[ENCRYPT]

COUNT = 101
DataUnitLen = 256
Key = 71c66b37bb213063b4ef269e0c5387900d06534bd05b7145922d8d9870e65d49d717dff12fb037b214bde15fbfab5eee058a54c2dfdf3d4fb834f5ff18e7b78b
i = 4ee57d34dbca050036fab34be19ac1ea
PT = ef92f3d1fcf49511349abea3159638c5eae62a5e9a6ed3760903c2f1f9173f6f
CT = 247448dd74b66dfabdb35b895ff452c489445597bc3cbd2575084395a13bd685
*/
static const uint8_t V256_3_key[] =
{
    0x71, 0xC6, 0x6B, 0x37, 0xBB, 0x21, 0x30, 0x63, 0xB4, 0xEF, 0x26, 0x9E, 0x0C, 0x53, 0x87, 0x90,
    0x0D, 0x06, 0x53, 0x4B, 0xD0, 0x5B, 0x71, 0x45, 0x92, 0x2D, 0x8D, 0x98, 0x70, 0xE6, 0x5D, 0x49,
    0xD7, 0x17, 0xDF, 0xF1, 0x2F, 0xB0, 0x37, 0xB2, 0x14, 0xBD, 0xE1, 0x5F, 0xBF, 0xAB, 0x5E, 0xEE,
    0x05, 0x8A, 0x54, 0xC2, 0xDF, 0xDF, 0x3D, 0x4F, 0xB8, 0x34, 0xF5, 0xFF, 0x18, 0xE7, 0xB7, 0x8B,
};
static const uint8_t V256_3_tweak[] =
{
    0x4E, 0xE5, 0x7D, 0x34, 0xDB, 0xCA, 0x05, 0x00, 0x36, 0xFA, 0xB3, 0x4B, 0xE1, 0x9A, 0xC1, 0xEA,
};
static const uint8_t V256_3_ptx[] =
{
    0xEF, 0x92, 0xF3, 0xD1, 0xFC, 0xF4, 0x95, 0x11, 0x34, 0x9A, 0xBE, 0xA3, 0x15, 0x96, 0x38, 0xC5,
    0xEA, 0xE6, 0x2A, 0x5E, 0x9A, 0x6E, 0xD3, 0x76, 0x09, 0x03, 0xC2, 0xF1, 0xF9, 0x17, 0x3F, 0x6F,
};
static const uint8_t V256_3_ctx[] =
{
    0x24, 0x74, 0x48, 0xDD, 0x74, 0xB6, 0x6D, 0xFA, 0xBD, 0xB3, 0x5B, 0x89, 0x5F, 0xF4, 0x52, 0xC4,
    0x89, 0x44, 0x55, 0x97, 0xBC, 0x3C, 0xBD, 0x25, 0x75, 0x08, 0x43, 0x95, 0xA1, 0x3B, 0xD6, 0x85,
};


#endif /* INCLUDE_GUARD_TEST_VECTORS_XTS_AES_DATA_H */

/* end of file testvectors_xts_aes_data.h */

