/* c_hwpal_dmares_mb.h
 *
 * Configuration Handling for Driver Framework Device API implementation.
 * A build-level configuration file is included and sanity-checked.
 * Do not edit this file. Edit cs_hwpal.h instead.
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

/*----------------------------------------------------------------
 * get configuration settings from product config file
 */
#include <DeviceFamily.h>

#if (DeviceFamily_PARENT == DeviceFamily_PARENT_CC35XX)
    #include <third_party/hsmddk/include/Config/cc35xx/cs_hwpal_mb.h>
#else
    #include <third_party/hsmddk/include/Config/cc27xx/cs_hwpal_mb.h>
#endif


// DMA memory not used for D-cache
//#define HWPAL_ARCH_COHERENT

// choose from LOG_SEVERITY_INFO, LOG_SEVERITY_WARN, LOG_SEVERITY_CRIT
#ifndef HWPAL_LOG_SEVERITY
#define HWPAL_LOG_SEVERITY LOG_SEVERITY_INFO
#endif

#ifndef HWPAL_DMA_NRESOURCES
#error "Expected HWPAL_DMA_NRESOURCES defined by cs_hwpal_umdevxs.h"
#endif

#if HWPAL_DMA_NRESOURCES < 8
#error "HWPAL_DMA_NRESOURCES too small"
#endif

// Remove Attach/Detach functions.
//#define HWPAL_DMARESOURCE_REMOVE_ATTACH

// Lowest allowed DMA address
#ifndef HWPAL_DMARESOURCE_DMA_ADDR_MIN
#define HWPAL_DMARESOURCE_DMA_ADDR_MIN      0
#endif

// Highest allowed DMA address
#ifndef HWPAL_DMARESOURCE_DMA_ADDR_MAX
#define HWPAL_DMARESOURCE_DMA_ADDR_MAX      0xFFFFFFFFU
#endif

// Maximum alignment supported for DMA resources
#ifndef HWPAL_DMARESOURCE_MAX_ALIGNMENT
#define HWPAL_DMARESOURCE_MAX_ALIGNMENT     (1024 * 4)
#endif

// Logging level that DMAResource_CheckAndRegister() function will use
// for reporting errors that can be considered warnings otherwise.
// By setting it to LOG_INFO the user can use this function to check
// whether a buffer can be used for DMA operations without bouncing and keep
// the log file free from the failed check error messages.
#ifndef HWPAL_DMARESOURCE_LOG_LEVEL
#define HWPAL_DMARESOURCE_LOG_LEVEL         LOG_CRIT
#endif


/* end of file c_hwpal_dmares_mb.h */
