/*
 * Decompiled with CFR 0.152.
 */
package com.ti.msp430.imagereformer;

import com.ti.msp430.imagereformer.Compression;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Output {
    BufferedImage destination;
    String imageName;
    int compressionLevel;
    static String year = new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime());
    JFrame jf;
    static String license = "/* Copyright (c) " + year + ", Texas Instruments Incorporated\nAll rights reserved.\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\n*  Redistributions of source code must retain the above copyright\n   notice, this list of conditions and the following disclaimer.\n\n*  Redistributions in binary form must reproduce the above copyright\n   notice, this list of conditions and the following disclaimer in the\n   documentation and/or other materials provided with the distribution.\n\n*  Neither the name of Texas Instruments Incorporated nor the names of\n   its contributors may be used to endorse or promote products derived\n   from this software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\"\nAND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,\nTHE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\nPURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR\nCONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\nEXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\nPROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;\nOR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,\nWHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR\nOTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,\nEVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.*/\n";
    public static int UNCOMPRESSED = 0;
    public static int COMPRESSED = 1;
    public static int STANDARD_PALLET = 0;
    public static int ADAPTIVE_PALLET = 1;
    public static int COMPRESSED_RLE8_SPEED = 2;
    public static int COMPRESSED_RLE8_SIZE = 3;

    public Output(BufferedImage bi, String name, int compression, JFrame jf) {
        this.compressionLevel = compression;
        this.destination = bi;
        this.jf = jf;
        if (name == null) {
            return;
        }
        File f = new File(name);
        int idx = (name = f.getName()).indexOf(".");
        this.imageName = idx > -1 ? name.substring(0, idx) : name;
    }

    public void writePixels(BufferedWriter output) throws IOException {
        output.write("static const uint8_t pixel_" + this.imageName + this.getEnc() + "[] =\n");
        output.write("{\n");
        DataBuffer buff = this.destination.getRaster().getDataBuffer();
        int width = this.destination.getWidth();
        int size = buff.getSize();
        int count = 0;
        int bitsPerPixel = this.destination.getColorModel().getPixelSize();
        int pixInByte = 0;
        if (bitsPerPixel == 1) {
            pixInByte = 8;
        } else if (bitsPerPixel == 2) {
            pixInByte = 4;
        } else if (bitsPerPixel == 4) {
            pixInByte = 2;
        } else if (bitsPerPixel == 8) {
            pixInByte = 1;
        }
        if (this.compressionLevel > 0) {
            int i;
            DataBufferInt compBuffer;
            Compression compression = new Compression(this.destination);
            if (bitsPerPixel == 1) {
                compBuffer = compression.rle_4_1bpp();
                for (i = 0; i < compBuffer.getSize(); ++i) {
                    output.write("0x" + this.formatByte((byte)compBuffer.getElem(i)) + ", ");
                    if (count == width - 1) {
                        count = 0;
                        output.write("\n");
                        continue;
                    }
                    ++count;
                }
                output.write("\n};\n\n");
            }
            if (bitsPerPixel == 2) {
                compBuffer = compression.rle_4_2bpp();
                for (i = 0; i < compBuffer.getSize(); ++i) {
                    output.write("0x" + this.formatByte((byte)compBuffer.getElem(i)) + ", ");
                    if (count == width - 1) {
                        count = 0;
                        output.write("\n");
                        continue;
                    }
                    ++count;
                }
                output.write("\n};\n\n");
            }
            if (bitsPerPixel == 4) {
                compBuffer = compression.rle_4_4bpp();
                for (i = 0; i < compBuffer.getSize(); ++i) {
                    output.write("0x" + this.formatByte((byte)compBuffer.getElem(i)) + ", ");
                    if (count == width - 1) {
                        count = 0;
                        output.write("\n");
                        continue;
                    }
                    ++count;
                }
                output.write("\n};\n\n");
            }
            if (bitsPerPixel == 8) {
                compBuffer = compression.rle_8_8bpp();
                for (i = 0; i < compBuffer.getSize(); ++i) {
                    output.write("0x" + this.formatByte((byte)compBuffer.getElem(i)) + ", ");
                    if (count == width - 1) {
                        count = 0;
                        output.write("\n");
                        continue;
                    }
                    ++count;
                }
                output.write("\n};\n\n");
            }
        } else {
            byte[] b = new byte[pixInByte];
            int i = 0;
            while (i + pixInByte - 1 < size - 1) {
                for (int j = 0; j < pixInByte; ++j) {
                    b[j] = ++count <= width ? (byte)buff.getElem(i++) : (byte)0;
                }
                output.write("0x" + this.formatBytes(b, pixInByte) + ", ");
                if (count < width) continue;
                count = 0;
                output.write("\n");
            }
            if (i <= size - 1) {
                int bitPosition = 0;
                for (int missing = size - i; missing != 0; --missing) {
                    b[bitPosition] = (byte)buff.getElem(i++);
                    ++bitPosition;
                }
                output.write("0x" + this.formatBytes(b, pixInByte) + "\n};\n\n");
            } else {
                output.write("\n};\n\n");
            }
        }
    }

    public String convertImageSize(int intSize) {
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toString(intSize));
        sb.append(",\n");
        return sb.toString();
    }

    public void writeEpi(BufferedWriter output) throws IOException {
        String width = this.convertImageSize(this.destination.getWidth());
        String height = this.convertImageSize(this.destination.getHeight());
        output.write("const Graphics_Image  " + this.imageName + this.getEnc() + "=\n{\n");
        output.write("\tIMAGE_FMT_" + this.getEnc() + ",\n");
        output.write("\t" + width);
        output.write("\t" + height);
        if (this.destination.getColorModel().getPixelSize() == 1) {
            output.write("\t2,\n");
        } else if (this.destination.getColorModel().getPixelSize() == 2) {
            output.write("\t4,\n");
        } else if (this.destination.getColorModel().getPixelSize() == 4) {
            output.write("\t16,\n");
        } else if (this.destination.getColorModel().getPixelSize() == 8) {
            output.write("\t256,\n");
        }
        output.write("\tpalette_" + this.imageName + this.getEnc() + ",\n");
        output.write("\tpixel_" + this.imageName + this.getEnc() + ",\n");
        output.write("};\n\n");
    }

    public void writeHeader(BufferedWriter output) throws IOException {
        output.write(license + "\n\n");
        output.write("#include <ti/grlib/grlib.h>\n");
        output.write("#include <stdint.h>\n\n");
    }

    public void write(String file) {
        try {
            MyFile out = new MyFile(file);
            BufferedWriter output = new BufferedWriter(new FileWriter(out));
            this.writeHeader(output);
            this.writePixels(output);
            this.writePalette(output);
            this.writeEpi(output);
            output.close();
        }
        catch (Exception e) {
            System.err.println("Error writing to file");
            e.printStackTrace();
        }
    }

    private String getEnc() {
        int numPix = this.destination.getColorModel().getPixelSize();
        return this.getCompression(numPix);
    }

    private String getCompression(int numPix) {
        if (numPix == 1 && this.compressionLevel == UNCOMPRESSED) {
            return "1BPP_UNCOMP";
        }
        if (numPix == 4 && this.compressionLevel == UNCOMPRESSED) {
            return "4BPP_UNCOMP";
        }
        if (numPix == 2 && this.compressionLevel == UNCOMPRESSED) {
            return "2BPP_UNCOMP";
        }
        if (numPix == 8 && this.compressionLevel == UNCOMPRESSED) {
            return "8BPP_UNCOMP";
        }
        if (numPix == 1 && this.compressionLevel == COMPRESSED) {
            return "1BPP_COMP_RLE4";
        }
        if (numPix == 2 && this.compressionLevel == COMPRESSED) {
            return "2BPP_COMP_RLE4";
        }
        if (numPix == 4 && this.compressionLevel == COMPRESSED) {
            return "4BPP_COMP_RLE4";
        }
        if (numPix == 8) {
            return "8BPP_COMP_RLE8";
        }
        JOptionPane.showMessageDialog(this.jf, "Compression is not supported for that format.");
        return "-1";
    }

    private String formatByte(byte b) {
        String value = Integer.toHexString(0xFF & b);
        if (value.length() < 2) {
            value = "0" + value;
        }
        return value;
    }

    private String formatBytes(byte[] b, int numBytes) {
        String value = "";
        int tempValue = 0;
        int shift = 0;
        if (numBytes == 8) {
            shift = 1;
        } else if (numBytes == 4) {
            shift = 2;
        } else if (numBytes == 2) {
            shift = 4;
        } else if (numBytes == 1) {
            shift = 0;
        }
        for (int i = 0; i < numBytes; ++i) {
            tempValue = (tempValue << shift) + (0xFF & b[i]);
        }
        value = Integer.toHexString(0xFF & tempValue);
        if (value.length() < 2) {
            value = "0" + value;
        }
        return value;
    }

    public void writePalette(BufferedWriter output) throws IOException {
        IndexColorModel cm = (IndexColorModel)this.destination.getColorModel();
        int size = cm.getMapSize();
        MyFile f = new MyFile(this.imageName);
        output.write("static const uint32_t palette_" + f.getName() + this.getEnc() + "[]=\n");
        output.write("{\n");
        byte[] r = new byte[size];
        byte[] b = new byte[size];
        byte[] g = new byte[size];
        cm.getReds(r);
        cm.getBlues(b);
        cm.getGreens(g);
        for (int i = 0; i < size; ++i) {
            String ir = this.formatByte(r[i]);
            String ig = this.formatByte(g[i]);
            String ib = this.formatByte(b[i]);
            output.write("\t0x" + ir + ig + ib);
            if (i + 1 < size) {
                output.write(", ");
                if ((i + 1) % 4 != 0) continue;
                output.write("\n");
                continue;
            }
            output.write("\n};\n\n");
        }
    }

    class MyFile
    extends File {
        public MyFile(String name) {
            super(name);
        }

        @Override
        public String getName() {
            String s = super.getName();
            s = s.replaceAll("\\.", "_");
            return s;
        }
    }
}

