/*
 * Copyright (c) 2022-2025, Texas Instruments Incorporated - http://www.ti.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  ======== CryptoKeyKeyStore_PSA.syscfg.js ========
 */

"use strict";

/* get Common /ti/drivers utility functions */
let CryptoCommon = system.getScript("/ti/drivers/CryptoCommon.syscfg.js");

/* get /ti/drivers family name from device object */
let family = CryptoCommon.device2Family(system.deviceData, "CryptoKeyKeyStore_PSA");

/*
 *  ======== base ========
 *  Define the base CryptoKeyKeyStore_PSA properties and methods
 */
let base = {
    displayName         : "PSA Crypto + KeyStore",
    description         : "PSA Crypto and KeyStore",
    longDescription     : `
The [__PSA Crypto API__][1] provides APIs to import, export, copy, and destroy
KeyStore keys which are referenced using a key identifier. These keys
are subject to usage restrictions as defined by the key attributes assigned
during key import. Depending on these restrictions, the keys can be used
via their key identifiers for future PSA Crypto operations.

[1]: /psa_crypto/doxygen/html/crypto_8h.html#details "C API reference"
`,
    maxInstances: 1
};

/* extend the base exports to include family-specific content */
let devCrypto = system.getScript("/ti/drivers/cryptoutils/cryptokey/CryptoKeyKeyStore_PSA" + family);
exports = devCrypto.extend(base);
