/**
  ******************************************************************************
  * @file    otp_provision.c
  * @author  MCD Application Team
  * @brief   File provisionning otp value
  *
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2020-2021 STMicroelectronics.
  * All rights reserved.</center></h2>
  * <h2><center>&copy; Copyright (c) 2022 Cypress Semiconductor Corporation
  * (an Infineon company) or an affiliate of Cypress Semiconductor Corporation.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
#include "template/flash_otp_nv_counters_backend.h"
#include "tfm_plat_otp.h"
#include "tfm_attest_hal.h"
#include "psa/crypto.h"

#define INT2LE(A) (uint8_t)(A & 0xFF), (uint8_t )((A >> 8) & 0xFF),\
         (uint8_t )((A >> 16) & 0xFF), (uint8_t )((A >> 24) & 0xFF)


#define INT64NULL 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  \
                  0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  \
                  0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  \
                  0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  \
                  0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  \
                  0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  \
                  0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  \
                  0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
#if defined(__ICCARM__)
__root
#endif
#if defined(__ICCARM__)
#pragma default_function_attributes = @ ".BL2_OTP_Const"
#else
__attribute__((section(".BL2_OTP_Const")))
#endif /* __ICCARM__ */
const struct flash_otp_nv_counters_region_t otp_stm_provision = {
    .init_value = OTP_NV_COUNTERS_INITIALIZED,
    .huk = {
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
    },
 /* IAK */
#if 1
    .iak= {
        0xA9, 0xB4, 0x54, 0xB2, 0x6D, 0x6F, 0x90, 0xA4,
        0xEA, 0x31, 0x19, 0x35, 0x64, 0xCB, 0xA9, 0x1F,
        0xEC, 0x6F, 0x9A, 0x00, 0x2A, 0x7D, 0xC0, 0x50,
        0x4B, 0x92, 0xA1, 0x93, 0x71, 0x34, 0x58, 0x5F
    },
#else
    .iak= {
        0xA8, 0xB4, 0x54, 0xB2, 0x6D, 0x6F, 0x90, 0xA4,
        0xEA, 0x31, 0x19, 0x35, 0x64, 0xCB, 0xA9, 0x1F,
        0xEC, 0x6F, 0x9A, 0x00, 0x2A, 0x7D, 0xC0, 0x50,
        0x4B, 0x92, 0xA1, 0x93, 0x71, 0x34, 0x58, 0x5F
    },
#endif
    /* IAK len */
    .iak_len = { INT2LE(32) },
#ifdef SYMMETRIC_INITIAL_ATTESTATION
    /* IAK type */
    .iak_type= { INT2LE(PSA_ALG_HMAC(PSA_ALG_SHA_256))},
#else
    /* IAK type */
    .iak_type= { INT2LE(PSA_ECC_FAMILY_SECP_R1) },
#endif /* SYMMETRIC_INITIAL_ATTESTATION */
    /* IAK id */
    .iak_id = {'s','t','m','.','e','x','a','m','p',\
               'l','e','.','x','c','u','b','e','!'},
    /* boot seed */
    .boot_seed ={
        0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
        0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
        0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,
        0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
    },
    .lcs= {INT2LE(PLAT_OTP_LCS_SECURED)},

    /* implementation id */
    .implementation_id = {
        0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA,
        0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
        0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC,
        0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    },
    /* certification reference */
    .cert_ref = { '0','6','0','4','5','6','5','2','7',
                  '2','8','2','9','1','0','0','1','0'},
    /* verification_service_url */
    .verification_service_url = "www.trustedfirmware.org",
    /* attestation_profile_definition */
    .profile_definition ="PSA_IOT_PROFILE_1",
#if (MCUBOOT_SIGNATURE_TYPE == RSA-2048)

    .bl2_rotpk_0 = {
        0xfc, 0x57, 0x01, 0xdc, 0x61, 0x35, 0xe1, 0x32,
        0x38, 0x47, 0xbd, 0xc4, 0x0f, 0x04, 0xd2, 0xe5,
        0xbe, 0xe5, 0x83, 0x3b, 0x23, 0xc2, 0x9f, 0x93,
        0x59, 0x3d, 0x00, 0x01, 0x8c, 0xfa, 0x99, 0x94,
     },
    .bl2_rotpk_1 = {
        0xe1, 0x80, 0x15, 0x99, 0x3d, 0x6d, 0x27, 0x60,
        0xb4, 0x99, 0x27, 0x4b, 0xae, 0xf2, 0x64, 0xb8,
        0x3a, 0xf2, 0x29, 0xe9, 0xa7, 0x85, 0xf3, 0xd5,
        0xbf, 0x00, 0xb9, 0xd3, 0x2c, 0x1f, 0x03, 0x96,
    }
    .bl2_nv_counter_0 = { INT64NULL },
    .bl2_nv_counter_1 = { INT64NULL },
    .bl2_nv_counter_2 = { INT64NULL },
    .bl2_rotpk_2 =  {
        0xe1, 0x80, 0x15, 0x99, 0x3d, 0x6d, 0x27, 0x60,
        0xb4, 0x99, 0x27, 0x4b, 0xae, 0xf2, 0x64, 0xb8,
        0x3a, 0xf2, 0x29, 0xe9, 0xa7, 0x85, 0xf3, 0xd5,
        0xbf, 0x00, 0xb9, 0xd3, 0x2c, 0x1f, 0x03, 0x96,

    },
#elif (MCUBOOT_SIGNATURE_TYPE == RSA-3072)

    .bl2_rotpk_0 = {
        0xbf, 0xe6, 0xd8, 0x6f, 0x88, 0x26, 0xf4, 0xff,
        0x97, 0xfb, 0x96, 0xc4, 0xe6, 0xfb, 0xc4, 0x99,
        0x3e, 0x46, 0x19, 0xfc, 0x56, 0x5d, 0xa2, 0x6a,
        0xdf, 0x34, 0xc3, 0x29, 0x48, 0x9a, 0xdc, 0x38,
     },
    .bl2_rotpk_1 = {
        0xb3, 0x60, 0xca, 0xf5, 0xc9, 0x8c, 0x6b, 0x94,
        0x2a, 0x48, 0x82, 0xfa, 0x9d, 0x48, 0x23, 0xef,
        0xb1, 0x66, 0xa9, 0xef, 0x6a, 0x6e, 0x4a, 0xa3,
        0x7c, 0x19, 0x19, 0xed, 0x1f, 0xcc, 0xc0, 0x49,
    },
    .bl2_nv_counter_0 = { INT64NULL },
    .bl2_nv_counter_1 = { INT64NULL },
    .bl2_nv_counter_2 = { INT64NULL },
    .bl2_rotpk_2 =  {
        0xb3, 0x60, 0xca, 0xf5, 0xc9, 0x8c, 0x6b, 0x94,
        0x2a, 0x48, 0x82, 0xfa, 0x9d, 0x48, 0x23, 0xef,
        0xb1, 0x66, 0xa9, 0xef, 0x6a, 0x6e, 0x4a, 0xa3,
        0x7c, 0x19, 0x19, 0xed, 0x1f, 0xcc, 0xc0, 0x49,
    },
#endif
    /* Entropy seed */
    .entropy_seed ={
        0x12, 0x13, 0x23, 0x34, 0x0a, 0x05, 0x89, 0x78,
        0xa3, 0x66, 0x8c, 0x0d, 0x97, 0x55, 0x53, 0xca,
        0xb5, 0x76, 0x18, 0x62, 0x29, 0xc6, 0xb6, 0x79,
        0x75, 0xc8, 0x5a, 0x8d, 0x9e, 0x11, 0x8f, 0x85,
        0xde, 0xc4, 0x5f, 0x66, 0x21, 0x52, 0xf9, 0x39,
        0xd9, 0x77, 0x93, 0x28, 0xb0, 0x5e, 0x02, 0xfa,
        0x58, 0xb4, 0x16, 0xc8, 0x0f, 0x38, 0x91, 0xbb,
        0x28, 0x17, 0xcd, 0x8a, 0xc9, 0x53, 0x72, 0x66,
    },
#ifdef PLATFORM_DEFAULT_NV_COUNTERS
    .flash_nv_counters = { 0x0, 0x0, 0x0 },
#endif
    .swap_count =  1
};


