/******************************************************************************

@file  app_extctrl_l2cap_coc.h

@brief This file parse and process the messages comes form the external control module
 dispatcher module, and build the events from the app_connection.c application and
 send it to the external control dispatcher module back.

Group: WCS, BTS
Target Device: cc23xx

******************************************************************************

 Copyright (c) 2024-2026, Texas Instruments Incorporated
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 *  Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

 *  Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

 *  Neither the name of Texas Instruments Incorporated nor the names of
    its contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

******************************************************************************


*****************************************************************************/

#ifndef APP_EXTCTRL_L2CAP_COC_H
#define APP_EXTCTRL_L2CAP_COC_H

#ifdef __cplusplus
extern "C"
{
#endif

/*********************************************************************
 * INCLUDES
 */
#include "ti/ble/app_util/framework/bleapputil_api.h"
#include <app_extctrl_common.h>
#include <app_l2cap_coc_api.h>

/*********************************************************************
*  EXTERNAL VARIABLES
*/

/*********************************************************************
 * CONSTANTS
 */

/*********************************************************************
 * MACROS
 */

/*********************************************************************
 * TYPEDEFS
 */

/**
 * @brief Structure for incoming L2cap Send SDU Command parameters
 */
typedef struct __attribute__((packed))
{
  uint16_t connHandle; //!< Connection handle
  uint16_t CID;        //!< Connection Identifier
  uint16_t len;        //!< Length of the payload
  uint8_t  pPayload[]; //!< Pointer to the payload
} AppExtCtrlL2capSendSdu_t;

/**
 * @brief Structure for L2cap Create PSM Command parameters
 */
typedef struct __attribute__((packed))
{
  uint16_t psm; //!< Protocol/Service Multiplexer
} AppExtCtrlL2capCreatePsm_t;

/**
 * @brief Structure for L2cap Close PSM Command parameters
 */
typedef struct __attribute__((packed))
{
  uint16_t psm; //!< Protocol/Service Multiplexer
} AppExtCtrlL2capClosePsm_t;

/**
 * @brief Structure for L2cap Disconnect Request Command parameters
 */
typedef struct __attribute__((packed))
{
  uint16_t CID; //!< Connection Identifier
} AppExtCtrlL2capDisconnectReq_t;

/**
 * @brief Structure for L2cap Connect Request Command parameters
 */
typedef struct __attribute__((packed))
{
  uint16_t connHandle; //!< Connection handle
  uint16_t psm;        //!< Protocol/Service Multiplexer
  uint16_t peerPsm;    //!< Peer Protocol/Service Multiplexer
} AppExtCtrlL2capConnectReq_t;

/*********************************************************************
 * Enumerators
 */

/*********************************************************************
 * Structures
 */

/*********************************************************************
 * FUNCTIONS
 */

/*********************************************************************
 * @fn      L2CAPCOCExtCtrl_start
 *
 * @brief   This function is called after stack initialization,
 *          the purpose of this function is to initialize and
 *          register the specific message handler of the connection module
 *          to the external control dispatcher, and register the call back
 *          event handler function to the l2cap_coc application.
 *
 * @return  SUCCESS/FAILURE
 */
bStatus_t L2CAPCOCExtCtrl_start(void);


#ifdef __cplusplus
}
#endif

#endif /* APP_EXTCTRL_L2CAP_COC_H */
