/**
 * \file rsa.h
 *
 * \brief This file provides an API for the RSA public-key cryptosystem.
 *
 * The RSA public-key cryptosystem is defined in <em>Public-Key
 * Cryptography Standards (PKCS) #1 v1.5: RSA Encryption</em>
 * and <em>Public-Key Cryptography Standards (PKCS) #1 v2.1:
 * RSA Cryptography Specifications</em>.
 *
 */
/*
 *  Copyright (C) 2006-2021, Arm Limited (or its affiliates), All Rights Reserved
 *  Copyright (C) 2020, STMicroelectronics, All Rights Reserved
 *  SPDX-License-Identifier: Apache-2.0
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"); you may
 *  not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  This file is part of Mbed TLS (https://tls.mbed.org)
 */
#ifndef MBEDTLS_RSA_ALT_H
#define MBEDTLS_RSA_ALT_H

#ifdef __cplusplus
extern "C" {
#endif

#if defined(MBEDTLS_RSA_ALT)
#include "stm32hal.h"

// Regular implementation
//

/**
 * \brief   The RSA context structure.
 *
 * \note    Direct manipulation of the members of this structure
 *          is deprecated. All manipulation should instead be done through
 *          the public interface functions.
 */
typedef struct mbedtls_rsa_context
{
    int MBEDTLS_PRIVATE(ver);        /*!<  Always 0.*/
    size_t MBEDTLS_PRIVATE(len);     /*!<  The size of \p N in Bytes. */

    mbedtls_mpi MBEDTLS_PRIVATE(N);  /*!<  The public modulus. */
    mbedtls_mpi MBEDTLS_PRIVATE(E);  /*!<  The public exponent. */

    mbedtls_mpi MBEDTLS_PRIVATE(D);  /*!<  The private exponent. */
    mbedtls_mpi MBEDTLS_PRIVATE(P);  /*!<  The first prime factor. */
    mbedtls_mpi MBEDTLS_PRIVATE(Q);  /*!<  The second prime factor. */
#if defined(GENERATOR_HW_PKA_EXTENDED_API)
    mbedtls_mpi MBEDTLS_PRIVATE(Phi);/*!<  The Euler tolient function. */
#endif
    mbedtls_mpi MBEDTLS_PRIVATE(DP); /*!<  <code>D % (P - 1)</code>. */
    mbedtls_mpi MBEDTLS_PRIVATE(DQ); /*!<  <code>D % (Q - 1)</code>. */
    mbedtls_mpi MBEDTLS_PRIVATE(QP); /*!<  <code>1 / (Q % P)</code>. */

    mbedtls_mpi MBEDTLS_PRIVATE(RN); /*!<  cached <code>R^2 mod N</code>. */

    mbedtls_mpi MBEDTLS_PRIVATE(RP); /*!<  cached <code>R^2 mod P</code>. */
    mbedtls_mpi MBEDTLS_PRIVATE(RQ); /*!<  cached <code>R^2 mod Q</code>. */

    mbedtls_mpi MBEDTLS_PRIVATE(Vi); /*!<  The cached blinding value. */
    mbedtls_mpi MBEDTLS_PRIVATE(Vf); /*!<  The cached un-blinding value. */

    int MBEDTLS_PRIVATE(padding);    /*!< Selects padding mode:
                                     #MBEDTLS_RSA_PKCS_V15 for 1.5 padding and
                                     #MBEDTLS_RSA_PKCS_V21 for OAEP or PSS. */
    int MBEDTLS_PRIVATE(hash_id);    /*!< Hash identifier of mbedtls_md_type_t type,
                                     as specified in md.h for use in the MGF
                                     mask generating function used in the
                                     EME-OAEP and EMSA-PSS encodings. */
#if defined(MBEDTLS_THREADING_C)
    mbedtls_threading_mutex_t MBEDTLS_PRIVATE(mutex);    /*!<  Thread-safety mutex. */
#endif
}
mbedtls_rsa_context;

#endif /* MBEDTLS_RSA_ALT */



#ifdef __cplusplus
}
#endif

#endif /* MBEDTLS_RSA_ALT_H */
