\page rcl_tx_power_output TX Output Power


The RCL enables the control of the TX output power associated with a radio operation. This is achieved by including a _txPower_ field in the command struct of all commands that involve a TX operation.

The available TX power settings are defined in a TX power table (LRF_TxPowerTable) which is part of the radio setup.

\image html docs/rcl/source/images/LRF_TxPowerTable.png width=800

In addition to the TX power table, the RCL also utilizes a TX power limitation table (LRF_TxPowerLimitTable) to specify maximum output power values based on frequency or channel. This table is sorted in ascending order of frequency and uses a bitmask to specify the regulatory domain (configurable via SysConfig) for which the output power limits apply.

\image html docs/rcl/source/images/LRF_TxPowerLimitTable.png width=800

The following regulatory domains are currently supported by the RCL:

| Regulatory Domain | Description |
| :---------------: | :---------: |
| RCL_REGULATORY_DOMAIN_NONE | No frequency-specific output power limitation |
| RCL_REGULATORY_DOMAIN_ETSI | European Telecommunications Standards Institute (Europe) |
| RCL_REGULATORY_DOMAIN_FCC  | Federal Communications Commission (USA) |
| RCL_REGULATORY_DOMAIN_MIIT | Ministry of Information and Communications Technology (China) |

# Usage

For a normal use case, the following usage is recommended:

- Set the 'Regulatory Domains' option of the RCL module in SysConfig. Multiple regulations can be selected.
- Specify the desired dBm value in the `txPower` field. This must be done before submitting a command involving a TX operation.
  - The RCL will apply the TX power table to determine the nearest entry that is equal to or below the requested power value (e.g., 7dBm might be rounded to 6dBm, and -5dBm might be rounded to -8dBm).
  - The RCL will check the power limitation table to ensure the output power is within the regulatory domain and frequency or channel restrictions.
- If no output power in the table satisfies the requested setting, an error is returned.
- The recommended way to set TX output power is by using designated initializers, either setting `.dBm` and `.fraction` or `.rawValue`. However, if the application writes directly to the `txPower` field, it should ensure the value is within the available range.

Please note:

- Special values (::LRF_TxPower_Use_Min and ::LRF_TxPower_Use_Max) are available for selecting the maximum and minimum available output power.
- No additional action is required by the application to apply the power limitation table. The RCL will automatically adjust the output power based on the regulatory domain and frequency or channel in use.
- If needed, the regulatory domain can be modified at runtime.
- The RCL will use the most restrictive regulatory domain when programming the output power value (i.e., the smallest value applicable) if multiple regulations are selected.

## Examples

### Recommended

The recommended way to set TX output power is using designated initializers, either setting .dBm and .fraction or .rawValue

\snippet source/functional/generic_examples/generic_tx/generic_tx.c genericTxPower_example_snippet

### Alternative

The user can also set TX output power by assigning the value to an existing structure's member.

\snippet source/functional/generic_examples/generic_tx/generic_tx.c example_2_snippet

### Special settings

Special settings are another way to set the Tx output power, either to the maximum or the minimum available in the table

\snippet source/functional/generic_examples/generic_tx/generic_tx.c example_3_snippet

### Advanced

#### This setting is intented for advanced users only and is not recommended

If the user set txPower to Raw, then value.rawValue and the temperature coefficient needs to be set.

\snippet source/functional/generic_examples/generic_tx/generic_tx.c example_4_snippet
