#-------------------------------------------------------------------------------
# Copyright (c) 2022, Arm Limited. All rights reserved.
#
# SPDX-License-Identifier: BSD-3-Clause
#
#-------------------------------------------------------------------------------

set(CONFIG_TFM_BUILD_LOG_QUIET              OFF     CACHE BOOL      "Disable build logs")

if(CONFIG_TFM_BUILD_LOG_QUIET)
    set(CMAKE_INSTALL_MESSAGE               NEVER   CACHE BOOL      "Output installation message generated by the install() command[ALWAYS,LAZY,NEVER]")
    set(CONFIG_TFM_PARTITION_QUIET          ON      CACHE BOOL      "Disable printing of partition configuration during build")
    set(CONFIG_TFM_MEMORY_USAGE_QUIET       ON      CACHE BOOL      "Disable the memory usage report")
    set(CONFIG_TFM_PARSE_MANIFEST_QUIET     ON      CACHE BOOL      "Parse manifest quietly")
else()
    set(CONFIG_TFM_PARTITION_QUIET          OFF     CACHE BOOL      "Disable printing of partition configuration during build")
    set(CONFIG_TFM_MEMORY_USAGE_QUIET       OFF     CACHE BOOL      "Disable the memory usage report")
    set(CONFIG_TFM_PARSE_MANIFEST_QUIET     OFF     CACHE BOOL      "Parse manifest quietly")
endif()
