/* testvectors_aes_gcm_data.h
 *
 * Description: Test vectors for AES GCM, test vector contents.
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

#include <third_party/hsmddk/include/Kit/DriverFramework/Basic_Defs_API/incl/basic_defs.h>

/*
#=================================================
#GCM Test Case #02 (AES-128)
#Variable          Value
#-------------------------------------------------
#K               : 00000000000000000000000000000000
#P               : 00000000000000000000000000000000
#IV              : 000000000000000000000000
#H               : 66e94bd4ef8a2c3b884cfa59ca342b2e
#Y_0             : 00000000000000000000000000000001
#E(K,Y_0)        : 58e2fccefa7e3061367f1d57a4e7455a
#Y_1             : 00000000000000000000000000000002
#E(K,Y_1)        : 0388dace60b6a392f328c2b971b2fe78
#X_1             : 5e2ec746917062882c85b0685353deb7
#len(A)||len(C)  : 00000000000000000000000000000080
#GHASH(H,A,C)    : f38cbb1ad69223dcc3457ae5b6b0f885
#C               : 0388dace60b6a392f328c2b971b2fe78
#T               : ab6e47d42cec13bdf53a67b21257bddf
*/
static const uint8_t AESGCM_128_tv0_Key[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t AESGCM_128_tv0_P[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t AESGCM_128_tv0_C[] =
{
    0x03, 0x88, 0xDA, 0xCE, 0x60, 0xB6, 0xA3, 0x92, 0xF3, 0x28, 0xC2, 0xB9, 0x71, 0xB2, 0xFE, 0x78,
};
static const uint8_t AESGCM_128_tv0_A[] = { };
static const uint8_t AESGCM_128_tv0_IV[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t AESGCM_128_tv0_H[] =
{
    0x66, 0xE9, 0x4B, 0xD4, 0xEF, 0x8A, 0x2C, 0x3B, 0x88, 0x4C, 0xFA, 0x59, 0xCA, 0x34, 0x2B, 0x2E,
};
static const uint8_t AESGCM_128_tv0_Y0[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};
static const uint8_t AESGCM_128_tv0_GHASH[] =
{
    0xF3, 0x8C, 0xBB, 0x1A, 0xD6, 0x92, 0x23, 0xDC, 0xC3, 0x45, 0x7A, 0xE5, 0xB6, 0xB0, 0xF8, 0x85,
};
static const uint8_t AESGCM_128_tv0_T[] =
{
    0xAB, 0x6E, 0x47, 0xD4, 0x2C, 0xEC, 0x13, 0xBD, 0xF5, 0x3A, 0x67, 0xB2, 0x12, 0x57, 0xBD, 0xDF,
};

/*
#=================================================
#GCM Test Case #03 (AES-128)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b391aafd255
#IV              : cafebabefacedbaddecaf888
#H               : b83b533708bf535d0aa6e52980d53b78
#Y_0             : cafebabefacedbaddecaf88800000001
#E(K,Y_0)        : 3247184b3c4f69a44dbcd22887bbb418
#Y_1             : cafebabefacedbaddecaf88800000002
#E(K,Y_1)        : 9bb22ce7d9f372c1ee2b28722b25f206
#Y_2             : cafebabefacedbaddecaf88800000003
#E(K,Y_2)        : 650d887c3936533a1b8d4e1ea39d2b5c
#Y_3             : cafebabefacedbaddecaf88800000004
#E(K,Y_3)        : 3de91827c10e9a4f5240647ee5221f20
#Y_4             : cafebabefacedbaddecaf88800000005
#E(K,Y_4)        : aac9e6ccc0074ac0873b9ba85d908bd0
#X_1             : 59ed3f2bb1a0aaa07c9f56c6a504647b
#X_2             : b714c9048389afd9f9bc5c1d4378e052
#X_3             : 47400c6577b1ee8d8f40b2721e86ff10
#X_4             : 4796cf49464704b5dd91f159bb1b7f95
#len(A)||len(C)  : 00000000000000000000000000000200
#GHASH(H,A,C)    : 7f1b32b81b820d02614f8895ac1d4eac
#C               : 42831ec2217774244b7221b784d0d49c
#                : e3aa212f2c02a4e035c17e2329aca12e
#                : 21d514b25466931c7d8f6a5aac84aa05
#                : 1ba30b396a0aac973d58e091473f5985
#T               : 4d5c2af327cd64a62cf35abd2ba6fab4
*/
static const uint8_t AESGCM_128_tv1_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t AESGCM_128_tv1_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39, 0x1A, 0xAF, 0xD2, 0x55,
};
static const uint8_t AESGCM_128_tv1_C[] =
{
    0x42, 0x83, 0x1E, 0xC2, 0x21, 0x77, 0x74, 0x24, 0x4B, 0x72, 0x21, 0xB7, 0x84, 0xD0, 0xD4, 0x9C,
    0xE3, 0xAA, 0x21, 0x2F, 0x2C, 0x02, 0xA4, 0xE0, 0x35, 0xC1, 0x7E, 0x23, 0x29, 0xAC, 0xA1, 0x2E,
    0x21, 0xD5, 0x14, 0xB2, 0x54, 0x66, 0x93, 0x1C, 0x7D, 0x8F, 0x6A, 0x5A, 0xAC, 0x84, 0xAA, 0x05,
    0x1B, 0xA3, 0x0B, 0x39, 0x6A, 0x0A, 0xAC, 0x97, 0x3D, 0x58, 0xE0, 0x91, 0x47, 0x3F, 0x59, 0x85,
};
static const uint8_t AESGCM_128_tv1_A[] = { };
static const uint8_t AESGCM_128_tv1_IV[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD, 0xDE, 0xCA, 0xF8, 0x88,
};
static const uint8_t AESGCM_128_tv1_H[] =
{
    0xB8, 0x3B, 0x53, 0x37, 0x08, 0xBF, 0x53, 0x5D, 0x0A, 0xA6, 0xE5, 0x29, 0x80, 0xD5, 0x3B, 0x78,
};
static const uint8_t AESGCM_128_tv1_Y0[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};
static const uint8_t AESGCM_128_tv1_GHASH[] =
{
    0x7F, 0x1B, 0x32, 0xB8, 0x1B, 0x82, 0x0D, 0x02, 0x61, 0x4F, 0x88, 0x95, 0xAC, 0x1D, 0x4E, 0xAC,
};
static const uint8_t AESGCM_128_tv1_T[] =
{
    0x4D, 0x5C, 0x2A, 0xF3, 0x27, 0xCD, 0x64, 0xA6, 0x2C, 0xF3, 0x5A, 0xBD, 0x2B, 0xA6, 0xFA, 0xB4,
};

/*
#=================================================
#GCM Test Case #04 (AES-128)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b39
#A               : feedfacedeadbeeffeedfacedeadbeef
#                : abaddad2
#IV              : cafebabefacedbaddecaf888
#H               : b83b533708bf535d0aa6e52980d53b78
#Y_0             : cafebabefacedbaddecaf88800000001
#E(K,Y_0)        : 3247184b3c4f69a44dbcd22887bbb418
#X_1             : ed56aaf8a72d67049fdb9228edba1322
#X_2             : cd47221ccef0554ee4bb044c88150352
#Y_1             : cafebabefacedbaddecaf88800000002
#E(K,Y_1)        : 9bb22ce7d9f372c1ee2b28722b25f206
#Y_2             : cafebabefacedbaddecaf88800000003
#E(K,Y_2)        : 650d887c3936533a1b8d4e1ea39d2b5c
#Y_3             : cafebabefacedbaddecaf88800000004
#E(K,Y_3)        : 3de91827c10e9a4f5240647ee5221f20
#Y_4             : cafebabefacedbaddecaf88800000005
#E(K,Y_4)        : aac9e6ccc0074ac0873b9ba85d908bd0
#X_3             : 54f5e1b2b5a8f9525c23924751a3ca51
#X_4             : 324f585c6ffc1359ab371565d6c45f93
#X_5             : ca7dd446af4aa70cc3c0cd5abba6aa1c
#X_6             : 1590df9b2eb6768289e57d56274c8570
#len(A)||len(C)  : 00000000000000a000000000000001e0
#GHASH(H,A,C)    : 698e57f70e6ecc7fd9463b7260a9ae5f
#C               : 42831ec2217774244b7221b784d0d49c
#                : e3aa212f2c02a4e035c17e2329aca12e
#                : 21d514b25466931c7d8f6a5aac84aa05
#                : 1ba30b396a0aac973d58e091
#T               : 5bc94fbc3221a5db94fae95ae7121a47
*/
static const uint8_t AESGCM_128_tv2_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t AESGCM_128_tv2_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39,
};
static const uint8_t AESGCM_128_tv2_C[] =
{
    0x42, 0x83, 0x1E, 0xC2, 0x21, 0x77, 0x74, 0x24, 0x4B, 0x72, 0x21, 0xB7, 0x84, 0xD0, 0xD4, 0x9C,
    0xE3, 0xAA, 0x21, 0x2F, 0x2C, 0x02, 0xA4, 0xE0, 0x35, 0xC1, 0x7E, 0x23, 0x29, 0xAC, 0xA1, 0x2E,
    0x21, 0xD5, 0x14, 0xB2, 0x54, 0x66, 0x93, 0x1C, 0x7D, 0x8F, 0x6A, 0x5A, 0xAC, 0x84, 0xAA, 0x05,
    0x1B, 0xA3, 0x0B, 0x39, 0x6A, 0x0A, 0xAC, 0x97, 0x3D, 0x58, 0xE0, 0x91,
};
static const uint8_t AESGCM_128_tv2_A[] =
{
    0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF,
    0xAB, 0xAD, 0xDA, 0xD2,
};
static const uint8_t AESGCM_128_tv2_IV[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD, 0xDE, 0xCA, 0xF8, 0x88,
};
static const uint8_t AESGCM_128_tv2_H[] =
{
    0xB8, 0x3B, 0x53, 0x37, 0x08, 0xBF, 0x53, 0x5D, 0x0A, 0xA6, 0xE5, 0x29, 0x80, 0xD5, 0x3B, 0x78,
};
static const uint8_t AESGCM_128_tv2_Y0[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD, 0xDE, 0xCA, 0xF8, 0x88, 0x00, 0x00, 0x00, 0x01,
};
static const uint8_t AESGCM_128_tv2_GHASH[] =
{
    0x69, 0x8E, 0x57, 0xF7, 0x0E, 0x6E, 0xCC, 0x7F, 0xD9, 0x46, 0x3B, 0x72, 0x60, 0xA9, 0xAE, 0x5F,
};
static const uint8_t AESGCM_128_tv2_T[] =
{
    0x5B, 0xC9, 0x4F, 0xBC, 0x32, 0x21, 0xA5, 0xDB, 0x94, 0xFA, 0xE9, 0x5A, 0xE7, 0x12, 0x1A, 0x47,
};

/*
#=================================================
#GCM Test Case #05 (AES-128)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b39
#A               : feedfacedeadbeeffeedfacedeadbeef
#                : abaddad2
#IV              : cafebabefacedbad
#H               : b83b533708bf535d0aa6e52980d53b78
#N_1             : 6f288b846e5fed9a18376829c86a6a16
#0^{64}||len(IV) : 00000000000000000000000000000040
#Y_0             : c43a83c4c4badec4354ca984db252f7d
#E(K,Y_0)        : e94ab9535c72bea9e089c93d48e62fb0
#X_1             : ed56aaf8a72d67049fdb9228edba1322
#X_2             : cd47221ccef0554ee4bb044c88150352
#Y_1             : c43a83c4c4badec4354ca984db252f7e
#E(K,Y_1)        : b8040969d08295afd226fcda0ddf61cf
#Y_2             : c43a83c4c4badec4354ca984db252f7f
#E(K,Y_2)        : ef3c83225af93122192ad5c4f15dfe51
#Y_3             : c43a83c4c4badec4354ca984db252f80
#E(K,Y_3)        : 6fbc659571f72de104c67b609d2fde67
#Y_4             : c43a83c4c4badec4354ca984db252f81
#E(K,Y_4)        : f8e3581441a1e950785c3ea1430c6fa6
#X_3             : 9379e2feae14649c86cf2250e3a81916
#X_4             : 65dde904c92a6b3db877c4817b50a5f4
#X_5             : 48c53cf863b49a1b0bbfc48c3baaa89d
#X_6             : 08c873f1c8cec3effc209a07468caab1
#len(A)||len(C)  : 00000000000000a000000000000001e0
#GHASH(H,A,C)    : df586bb4c249b92cb6922877e444d37b
#C               : 61353b4c2806934a777ff51fa22a4755
#                : 699b2a714fcdc6f83766e5f97b6c7423
#                : 73806900e49f24b22b097544d4896b42
#                : 4989b5e1ebac0f07c23f4598
#T               : 3612d2e79e3b0785561be14aaca2fccb
*/
static const uint8_t AESGCM_128_tv3_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t AESGCM_128_tv3_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39,
};
static const uint8_t AESGCM_128_tv3_C[] =
{
    0x61, 0x35, 0x3B, 0x4C, 0x28, 0x06, 0x93, 0x4A, 0x77, 0x7F, 0xF5, 0x1F, 0xA2, 0x2A, 0x47, 0x55,
    0x69, 0x9B, 0x2A, 0x71, 0x4F, 0xCD, 0xC6, 0xF8, 0x37, 0x66, 0xE5, 0xF9, 0x7B, 0x6C, 0x74, 0x23,
    0x73, 0x80, 0x69, 0x00, 0xE4, 0x9F, 0x24, 0xB2, 0x2B, 0x09, 0x75, 0x44, 0xD4, 0x89, 0x6B, 0x42,
    0x49, 0x89, 0xB5, 0xE1, 0xEB, 0xAC, 0x0F, 0x07, 0xC2, 0x3F, 0x45, 0x98,
};
static const uint8_t AESGCM_128_tv3_A[] =
{
    0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF,
    0xAB, 0xAD, 0xDA, 0xD2,
};
static const uint8_t AESGCM_128_tv3_IV[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD,
};
static const uint8_t AESGCM_128_tv3_H[] =
{
    0xB8, 0x3B, 0x53, 0x37, 0x08, 0xBF, 0x53, 0x5D, 0x0A, 0xA6, 0xE5, 0x29, 0x80, 0xD5, 0x3B, 0x78,
};
static const uint8_t AESGCM_128_tv3_Y0[] =
{
    0xC4, 0x3A, 0x83, 0xC4, 0xC4, 0xBA, 0xDE, 0xC4, 0x35, 0x4C, 0xA9, 0x84, 0xDB, 0x25, 0x2F, 0x7D,
};
static const uint8_t AESGCM_128_tv3_GHASH[] =
{
    0xDF, 0x58, 0x6B, 0xB4, 0xC2, 0x49, 0xB9, 0x2C, 0xB6, 0x92, 0x28, 0x77, 0xE4, 0x44, 0xD3, 0x7B,
};
static const uint8_t AESGCM_128_tv3_T[] =
{
    0x36, 0x12, 0xD2, 0xE7, 0x9E, 0x3B, 0x07, 0x85, 0x56, 0x1B, 0xE1, 0x4A, 0xAC, 0xA2, 0xFC, 0xCB,
};

/*
#=================================================
#GCM Test Case #06 (AES-128)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b39
#A               : feedfacedeadbeeffeedfacedeadbeef
#                : abaddad2
#IV              : 9313225df88406e555909c5aff5269aa
#                : 6a7a9538534f7da1e4c303d2a318a728
#                : c3c0c95156809539fcf0e2429a6b5254
#                : 16aedbf5a0de6a57a637b39b
#H               : b83b533708bf535d0aa6e52980d53b78
#N_1             : 004d6599d7fb1634756e1e299d81630f
#N_2             : 88ffe8a3c8033df4b54d732f7f88408e
#N_3             : 24e694cfab657beabba8055aad495e23
#N_4             : d8349a5eda24943c8fbb2ef5168b20cb
#0^{64}||len(IV) : 000000000000000000000000000001e0
#Y_0             : 3bab75780a31c059f83d2a44752f9864
#E(K,Y_0)        : 7dc63b399f2d98d57ab073b6baa4138e
#X_1             : ed56aaf8a72d67049fdb9228edba1322
#X_2             : cd47221ccef0554ee4bb044c88150352
#Y_1             : 3bab75780a31c059f83d2a44752f9865
#E(K,Y_1)        : 55d37bbd9ad21353a6f93a690eca9e0e
#Y_2             : 3bab75780a31c059f83d2a44752f9866
#E(K,Y_2)        : 3836bbf6d696e672946a1a01404fa6d5
#Y_3             : 3bab75780a31c059f83d2a44752f9867
#E(K,Y_3)        : 1dd8a5316ecc35c3e313bca59d2ac94a
#Y_4             : 3bab75780a31c059f83d2a44752f9868
#E(K,Y_4)        : 6742982706a9f154f657d5dc94b746db
#X_3             : 31727669c63c6f078b5d22adbbbca384
#X_4             : 480c00db2679065a7ed2f771a53acacd
#X_5             : 1c1ae3c355e2214466a9923d2ba6ab35
#X_6             : 0694c6f16bb0275a48891d06590344b0
#len(A)||len(C)  : 00000000000000a000000000000001e0
#GHASH(H,A,C)    : 1c5afe9760d3932f3c9a878aac3dc3de
#C               : 8ce24998625615b603a033aca13fb894
#                : be9112a5c3a211a8ba262a3cca7e2ca7
#                : 01e4a9a4fba43c90ccdcb281d48c7c6f
#                : d62875d2aca417034c34aee5
#T               : 619cc5aefffe0bfa462af43c1699d050
*/
static const uint8_t AESGCM_128_tv4_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t AESGCM_128_tv4_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39,
};
static const uint8_t AESGCM_128_tv4_C[] =
{
    0x8C, 0xE2, 0x49, 0x98, 0x62, 0x56, 0x15, 0xB6, 0x03, 0xA0, 0x33, 0xAC, 0xA1, 0x3F, 0xB8, 0x94,
    0xBE, 0x91, 0x12, 0xA5, 0xC3, 0xA2, 0x11, 0xA8, 0xBA, 0x26, 0x2A, 0x3C, 0xCA, 0x7E, 0x2C, 0xA7,
    0x01, 0xE4, 0xA9, 0xA4, 0xFB, 0xA4, 0x3C, 0x90, 0xCC, 0xDC, 0xB2, 0x81, 0xD4, 0x8C, 0x7C, 0x6F,
    0xD6, 0x28, 0x75, 0xD2, 0xAC, 0xA4, 0x17, 0x03, 0x4C, 0x34, 0xAE, 0xE5,
};
static const uint8_t AESGCM_128_tv4_A[] =
{
    0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF,
    0xAB, 0xAD, 0xDA, 0xD2,
};
static const uint8_t AESGCM_128_tv4_IV[] =
{
    0x93, 0x13, 0x22, 0x5D, 0xF8, 0x84, 0x06, 0xE5, 0x55, 0x90, 0x9C, 0x5A, 0xFF, 0x52, 0x69, 0xAA,
    0x6A, 0x7A, 0x95, 0x38, 0x53, 0x4F, 0x7D, 0xA1, 0xE4, 0xC3, 0x03, 0xD2, 0xA3, 0x18, 0xA7, 0x28,
    0xC3, 0xC0, 0xC9, 0x51, 0x56, 0x80, 0x95, 0x39, 0xFC, 0xF0, 0xE2, 0x42, 0x9A, 0x6B, 0x52, 0x54,
    0x16, 0xAE, 0xDB, 0xF5, 0xA0, 0xDE, 0x6A, 0x57, 0xA6, 0x37, 0xB3, 0x9B,
};
static const uint8_t AESGCM_128_tv4_H[] =
{
    0xB8, 0x3B, 0x53, 0x37, 0x08, 0xBF, 0x53, 0x5D, 0x0A, 0xA6, 0xE5, 0x29, 0x80, 0xD5, 0x3B, 0x78,
};
static const uint8_t AESGCM_128_tv4_Y0[] =
{
    0x3B, 0xAB, 0x75, 0x78, 0x0A, 0x31, 0xC0, 0x59, 0xF8, 0x3D, 0x2A, 0x44, 0x75, 0x2F, 0x98, 0x64,
};
static const uint8_t AESGCM_128_tv4_GHASH[] =
{
    0x1C, 0x5A, 0xFE, 0x97, 0x60, 0xD3, 0x93, 0x2F, 0x3C, 0x9A, 0x87, 0x8A, 0xAC, 0x3D, 0xC3, 0xDE,
};
static const uint8_t AESGCM_128_tv4_T[] =
{
    0x61, 0x9C, 0xC5, 0xAE, 0xFF, 0xFE, 0x0B, 0xFA, 0x46, 0x2A, 0xF4, 0x3C, 0x16, 0x99, 0xD0, 0x50,
};

/*
#=================================================
#GCM Test Case #08 (AES-192)
#Variable          Value
#-------------------------------------------------
#K               : 00000000000000000000000000000000
#                : 0000000000000000
#P               : 00000000000000000000000000000000
#IV              : 000000000000000000000000
#H               : aae06992acbf52a3e8f4a96ec9300bd7
#Y_0             : 00000000000000000000000000000001
#E(K,Y_0)        : cd33b28ac773f74ba00ed1f312572435
#Y_1             : 00000000000000000000000000000002
#E(K,Y_1)        : 98e7247c07f0fe411c267e4384b0f600
#X_1             : 90e87315fb7d4e1b4092ec0cbfda5d7d
#len(A)||len(C)  : 00000000000000000000000000000080
#GHASH(H,A,C)    : e2c63f0ac44ad0e02efa05ab6743d4ce
#C               : 98e7247c07f0fe411c267e4384b0f600
#T               : 2ff58d80033927ab8ef4d4587514f0fb
*/
static const uint8_t AESGCM_192_tv0_Key[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const uint8_t AESGCM_192_tv0_P[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t AESGCM_192_tv0_C[] =
{
    0x98, 0xE7, 0x24, 0x7C, 0x07, 0xF0, 0xFE, 0x41, 0x1C, 0x26, 0x7E, 0x43, 0x84, 0xB0, 0xF6, 0x00,
};
static const uint8_t AESGCM_192_tv0_A[] = { };
static const uint8_t AESGCM_192_tv0_IV[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const uint8_t AESGCM_192_tv0_H[] =
{
    0xAA, 0xE0, 0x69, 0x92, 0xAC, 0xBF, 0x52, 0xA3, 0xE8, 0xF4, 0xA9, 0x6E, 0xC9, 0x30, 0x0B, 0xD7,
};
static const uint8_t AESGCM_192_tv0_Y0[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
};
static const uint8_t AESGCM_192_tv0_GHASH[] =
{
    0xE2, 0xC6, 0x3F, 0x0A, 0xC4, 0x4A, 0xD0, 0xE0, 0x2E, 0xFA, 0x05, 0xAB, 0x67, 0x43, 0xD4, 0xCE,
};
static const uint8_t AESGCM_192_tv0_T[] =
{
    0x2F, 0xF5, 0x8D, 0x80, 0x03, 0x39, 0x27, 0xAB, 0x8E, 0xF4, 0xD4, 0x58, 0x75, 0x14, 0xF0, 0xFB,
};

/*
#=================================================
#GCM Test Case #09 (AES-192)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#                : feffe9928665731c
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b391aafd255
#IV              : cafebabefacedbaddecaf888
#H               : 466923ec9ae682214f2c082badb39249
#Y_0             : cafebabefacedbaddecaf88800000001
#E(K,Y_0)        : c835aa88aebbc94f5a02e179fdcfc3e4
#Y_1             : cafebabefacedbaddecaf88800000002
#E(K,Y_1)        : e0b1f82ec484eea44e5ff30128df01cd
#Y_2             : cafebabefacedbaddecaf88800000003
#E(K,Y_2)        : 0339b5b9b3db2e5e4cc9a38986906bee
#Y_3             : cafebabefacedbaddecaf88800000004
#E(K,Y_3)        : 614b3195542ccc7683ae933c81ec8a62
#Y_4             : cafebabefacedbaddecaf88800000005
#E(K,Y_4)        : a988a97e85eec28e76b95c29b6023003
#X_1             : dddca3f91c17821ffac4a6d0fed176f7
#X_2             : a4e84ac60e2730f4a7e0e1eef708b198
#X_3             : e67592048dd7153973a0dbbb8804bee2
#X_4             : 503e86628536625fb746ce3cecea433f
#len(A)||len(C)  : 00000000000000000000000000000200
#GHASH(H,A,C)    : 51110d40f6c8fff0eb1ae33445a889f0
#C               : 3980ca0b3c00e841eb06fac4872a2757
#                : 859e1ceaa6efd984628593b40ca1e19c
#                : 7d773d00c144c525ac619d18c84a3f47
#                : 18e2448b2fe324d9ccda2710acade256
#T               : 9924a7c8587336bfb118024db8674a14
*/
static const uint8_t AESGCM_192_tv1_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C,
};
static const uint8_t AESGCM_192_tv1_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39, 0x1A, 0xAF, 0xD2, 0x55,
};
static const uint8_t AESGCM_192_tv1_C[] =
{
    0x39, 0x80, 0xCA, 0x0B, 0x3C, 0x00, 0xE8, 0x41, 0xEB, 0x06, 0xFA, 0xC4, 0x87, 0x2A, 0x27, 0x57,
    0x85, 0x9E, 0x1C, 0xEA, 0xA6, 0xEF, 0xD9, 0x84, 0x62, 0x85, 0x93, 0xB4, 0x0C, 0xA1, 0xE1, 0x9C,
    0x7D, 0x77, 0x3D, 0x00, 0xC1, 0x44, 0xC5, 0x25, 0xAC, 0x61, 0x9D, 0x18, 0xC8, 0x4A, 0x3F, 0x47,
    0x18, 0xE2, 0x44, 0x8B, 0x2F, 0xE3, 0x24, 0xD9, 0xCC, 0xDA, 0x27, 0x10, 0xAC, 0xAD, 0xE2, 0x56,
};
static const uint8_t AESGCM_192_tv1_A[] = { };
static const uint8_t AESGCM_192_tv1_IV[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD, 0xDE, 0xCA, 0xF8, 0x88,
};
static const uint8_t AESGCM_192_tv1_H[] =
{
    0x46, 0x69, 0x23, 0xEC, 0x9A, 0xE6, 0x82, 0x21, 0x4F, 0x2C, 0x08, 0x2B, 0xAD, 0xB3, 0x92, 0x49,
};
static const uint8_t AESGCM_192_tv1_Y0[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD, 0xDE, 0xCA, 0xF8, 0x88, 0x00, 0x00, 0x00, 0x01,
};
static const uint8_t AESGCM_192_tv1_GHASH[] =
{
    0x51, 0x11, 0x0D, 0x40, 0xF6, 0xC8, 0xFF, 0xF0, 0xEB, 0x1A, 0xE3, 0x34, 0x45, 0xA8, 0x89, 0xF0,
};
static const uint8_t AESGCM_192_tv1_T[] =
{
    0x99, 0x24, 0xA7, 0xC8, 0x58, 0x73, 0x36, 0xBF, 0xB1, 0x18, 0x02, 0x4D, 0xB8, 0x67, 0x4A, 0x14,
};

/*
#=================================================
#GCM Test Case #10 (AES-192)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#                : feffe9928665731c
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b39
#A               : feedfacedeadbeeffeedfacedeadbeef
#                : abaddad2
#IV              : cafebabefacedbaddecaf888
#H               : 466923ec9ae682214f2c082badb39249
#Y_0             : cafebabefacedbaddecaf88800000001
#E(K,Y_0)        : c835aa88aebbc94f5a02e179fdcfc3e4
#X_1             : f3bf7ba3e305aeb05ed0d2e4fe076666
#X_2             : 20a51fa2302e9c01b87c48f2c3d91a56
#Y_1             : cafebabefacedbaddecaf88800000002
#E(K,Y_1)        : e0b1f82ec484eea44e5ff30128df01cd
#Y_2             : cafebabefacedbaddecaf88800000003
#E(K,Y_2)        : 0339b5b9b3db2e5e4cc9a38986906bee
#Y_3             : cafebabefacedbaddecaf88800000004
#E(K,Y_3)        : 614b3195542ccc7683ae933c81ec8a62
#Y_4             : cafebabefacedbaddecaf88800000005
#E(K,Y_4)        : a988a97e85eec28e76b95c29b6023003
#X_3             : 714f9700ddf520f20695f6180c6e669d
#X_4             : e858680b7b240d2ecf7e06bbad4524e2
#X_5             : 3f4865abd6bb3fb9f5c4a816f0a9b778
#X_6             : 4256f67fe87b4f49422ba11af857c973
#len(A)||len(C)  : 00000000000000a000000000000001e0
#GHASH(H,A,C)    : ed2ce3062e4a8ec06db8b4c490e8a268
#C               : 3980ca0b3c00e841eb06fac4872a2757
#                : 859e1ceaa6efd984628593b40ca1e19c
#                : 7d773d00c144c525ac619d18c84a3f47
#                : 18e2448b2fe324d9ccda2710
#T               : 2519498e80f1478f37ba55bd6d27618c
*/
static const uint8_t AESGCM_192_tv2_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C,
};
static const uint8_t AESGCM_192_tv2_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39,
};
static const uint8_t AESGCM_192_tv2_C[] =
{
    0x39, 0x80, 0xCA, 0x0B, 0x3C, 0x00, 0xE8, 0x41, 0xEB, 0x06, 0xFA, 0xC4, 0x87, 0x2A, 0x27, 0x57,
    0x85, 0x9E, 0x1C, 0xEA, 0xA6, 0xEF, 0xD9, 0x84, 0x62, 0x85, 0x93, 0xB4, 0x0C, 0xA1, 0xE1, 0x9C,
    0x7D, 0x77, 0x3D, 0x00, 0xC1, 0x44, 0xC5, 0x25, 0xAC, 0x61, 0x9D, 0x18, 0xC8, 0x4A, 0x3F, 0x47,
    0x18, 0xE2, 0x44, 0x8B, 0x2F, 0xE3, 0x24, 0xD9, 0xCC, 0xDA, 0x27, 0x10,
};
static const uint8_t AESGCM_192_tv2_A[] =
{
    0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF,
    0xAB, 0xAD, 0xDA, 0xD2,
};
static const uint8_t AESGCM_192_tv2_IV[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD, 0xDE, 0xCA, 0xF8, 0x88,
};
static const uint8_t AESGCM_192_tv2_H[] =
{
    0x46, 0x69, 0x23, 0xEC, 0x9A, 0xE6, 0x82, 0x21, 0x4F, 0x2C, 0x08, 0x2B, 0xAD, 0xB3, 0x92, 0x49,
};
static const uint8_t AESGCM_192_tv2_Y0[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD, 0xDE, 0xCA, 0xF8, 0x88, 0x00, 0x00, 0x00, 0x01,
};
static const uint8_t AESGCM_192_tv2_GHASH[] =
{
    0xED, 0x2C, 0xE3, 0x06, 0x2E, 0x4A, 0x8E, 0xC0, 0x6D, 0xB8, 0xB4, 0xC4, 0x90, 0xE8, 0xA2, 0x68,
};
static const uint8_t AESGCM_192_tv2_T[] =
{
    0x25, 0x19, 0x49, 0x8E, 0x80, 0xF1, 0x47, 0x8F, 0x37, 0xBA, 0x55, 0xBD, 0x6D, 0x27, 0x61, 0x8C,
};

/*
#=================================================
#GCM Test Case #11 (AES-192)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#                : feffe9928665731c
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b39
#A               : feedfacedeadbeeffeedfacedeadbeef
#                : abaddad2
#IV              : cafebabefacedbad
#H               : 466923ec9ae682214f2c082badb39249
#N_1             : 9473c07b02544299cf007c42c5778218
#0^{64}||len(IV) : 00000000000000000000000000000040
#Y_0             : a14378078d27258a6292737e1802ada5
#E(K,Y_0)        : 7bb6d647c902427ce7cf26563a337371
#X_1             : f3bf7ba3e305aeb05ed0d2e4fe076666
#X_2             : 20a51fa2302e9c01b87c48f2c3d91a56
#Y_1             : a14378078d27258a6292737e1802ada6
#E(K,Y_1)        : d621c7bc5690a7b1487dbaab8ac76b22
#Y_2             : a14378078d27258a6292737e1802ada7
#E(K,Y_2)        : 43c1ca7de78f4495ad0b18324e61fa25
#Y_3             : a14378078d27258a6292737e1802ada8
#E(K,Y_3)        : e1e0254a0f2f1626e9aa4ff09d7c64ec
#Y_4             : a14378078d27258a6292737e1802ada9
#E(K,Y_4)        : 5850f4502486a1681a9319ce7d0afa59
#X_3             : 8bdedafd6ee8e529689de3a269b8240d
#X_4             : 6607feb377b49c9ecdbc696344fe22d8
#X_5             : 8a19570a06500ba9405fcece4a73fb48
#X_6             : 8532826e63ce4a5b89b70fa28f8070fe
#len(A)||len(C)  : 00000000000000a000000000000001e0
#GHASH(H,A,C)    : 1e6a133806607858ee80eaf237064089
#C               : 0f10f599ae14a154ed24b36e25324db8
#                : c566632ef2bbb34f8347280fc4507057
#                : fddc29df9a471f75c66541d4d4dad1c9
#                : e93a19a58e8b473fa0f062f7
#T               : 65dcc57fcf623a24094fcca40d3533f8
*/
static const uint8_t AESGCM_192_tv3_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C,
};
static const uint8_t AESGCM_192_tv3_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39,
};
static const uint8_t AESGCM_192_tv3_C[] =
{
    0x0F, 0x10, 0xF5, 0x99, 0xAE, 0x14, 0xA1, 0x54, 0xED, 0x24, 0xB3, 0x6E, 0x25, 0x32, 0x4D, 0xB8,
    0xC5, 0x66, 0x63, 0x2E, 0xF2, 0xBB, 0xB3, 0x4F, 0x83, 0x47, 0x28, 0x0F, 0xC4, 0x50, 0x70, 0x57,
    0xFD, 0xDC, 0x29, 0xDF, 0x9A, 0x47, 0x1F, 0x75, 0xC6, 0x65, 0x41, 0xD4, 0xD4, 0xDA, 0xD1, 0xC9,
    0xE9, 0x3A, 0x19, 0xA5, 0x8E, 0x8B, 0x47, 0x3F, 0xA0, 0xF0, 0x62, 0xF7,
};
static const uint8_t AESGCM_192_tv3_A[] =
{
    0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF,
    0xAB, 0xAD, 0xDA, 0xD2,
};
static const uint8_t AESGCM_192_tv3_IV[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD,
};
static const uint8_t AESGCM_192_tv3_H[] =
{
    0x46, 0x69, 0x23, 0xEC, 0x9A, 0xE6, 0x82, 0x21, 0x4F, 0x2C, 0x08, 0x2B, 0xAD, 0xB3, 0x92, 0x49,
};
static const uint8_t AESGCM_192_tv3_Y0[] =
{
    0xA1, 0x43, 0x78, 0x07, 0x8D, 0x27, 0x25, 0x8A, 0x62, 0x92, 0x73, 0x7E, 0x18, 0x02, 0xAD, 0xA5,
};
static const uint8_t AESGCM_192_tv3_GHASH[] =
{
    0x1E, 0x6A, 0x13, 0x38, 0x06, 0x60, 0x78, 0x58, 0xEE, 0x80, 0xEA, 0xF2, 0x37, 0x06, 0x40, 0x89,
};
static const uint8_t AESGCM_192_tv3_T[] =
{
    0x65, 0xDC, 0xC5, 0x7F, 0xCF, 0x62, 0x3A, 0x24, 0x09, 0x4F, 0xCC, 0xA4, 0x0D, 0x35, 0x33, 0xF8,
};

/*
#=================================================
#GCM Test Case #12 (AES-192)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#                : feffe9928665731c
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b39
#A               : feedfacedeadbeeffeedfacedeadbeef
#                : abaddad2
#IV              : 9313225df88406e555909c5aff5269aa
#                : 6a7a9538534f7da1e4c303d2a318a728
#                : c3c0c95156809539fcf0e2429a6b5254
#                : 16aedbf5a0de6a57a637b39b
#H               : 466923ec9ae682214f2c082badb39249
#N_1             : 19aef0f04763b0c87903c5a217d5314f
#N_2             : 62120253f79efc978625d1feb03b5b5b
#N_3             : b6ce2a84e366de900fa78a1653df77fb
#N_4             : 374ecad90487f0bb261ba817447e022c
#0^{64}||len(IV) : 000000000000000000000000000001e0
#Y_0             : 4505cdc367a054c5002820e96aebef27
#E(K,Y_0)        : 5ea3194f9dd012a3b9bc5103d6e0284d
#X_1             : f3bf7ba3e305aeb05ed0d2e4fe076666
#X_2             : 20a51fa2302e9c01b87c48f2c3d91a56
#Y_1             : 4505cdc367a054c5002820e96aebef28
#E(K,Y_1)        : 0b4fba4de46722d9ed691f9f2029df65
#Y_2             : 4505cdc367a054c5002820e96aebef29
#E(K,Y_2)        : 9b4e088bf380b03540bb87a5a257e437
#Y_3             : 4505cdc367a054c5002820e96aebef2a
#E(K,Y_3)        : 9ddb9c873a5cd48acd3f397cd28f9896
#Y_4             : 4505cdc367a054c5002820e96aebef2b
#E(K,Y_4)        : 5716ee92eff7c4b053d44c0294ea88cd
#X_3             : f70d61693ea7f53f08c866d6eedb1e4b
#X_4             : dc40bc9a181b35aed66488071ef282ae
#X_5             : 85ffa424b87b35cac7be9c450f0d7aee
#X_6             : 65233cbe5251f7d246bfc967a8678647
#len(A)||len(C)  : 00000000000000a000000000000001e0
#GHASH(H,A,C)    : 82567fb0b4cc371801eadec005968e94
#C               : d27e88681ce3243c4830165a8fdcf9ff
#                : 1de9a1d8e6b447ef6ef7b79828666e45
#                : 81e79012af34ddd9e2f037589b292db3
#                : e67c036745fa22e7e9b7373b
#T               : dcf566ff291c25bbb8568fc3d376a6d9
*/
static const uint8_t AESGCM_192_tv4_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C,
};
static const uint8_t AESGCM_192_tv4_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39,
};
static const uint8_t AESGCM_192_tv4_C[] =
{
    0xD2, 0x7E, 0x88, 0x68, 0x1C, 0xE3, 0x24, 0x3C, 0x48, 0x30, 0x16, 0x5A, 0x8F, 0xDC, 0xF9, 0xFF,
    0x1D, 0xE9, 0xA1, 0xD8, 0xE6, 0xB4, 0x47, 0xEF, 0x6E, 0xF7, 0xB7, 0x98, 0x28, 0x66, 0x6E, 0x45,
    0x81, 0xE7, 0x90, 0x12, 0xAF, 0x34, 0xDD, 0xD9, 0xE2, 0xF0, 0x37, 0x58, 0x9B, 0x29, 0x2D, 0xB3,
    0xE6, 0x7C, 0x03, 0x67, 0x45, 0xFA, 0x22, 0xE7, 0xE9, 0xB7, 0x37, 0x3B,
};
static const uint8_t AESGCM_192_tv4_A[] =
{
    0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF,
    0xAB, 0xAD, 0xDA, 0xD2,
};
static const uint8_t AESGCM_192_tv4_IV[] =
{
    0x93, 0x13, 0x22, 0x5D, 0xF8, 0x84, 0x06, 0xE5, 0x55, 0x90, 0x9C, 0x5A, 0xFF, 0x52, 0x69, 0xAA,
    0x6A, 0x7A, 0x95, 0x38, 0x53, 0x4F, 0x7D, 0xA1, 0xE4, 0xC3, 0x03, 0xD2, 0xA3, 0x18, 0xA7, 0x28,
    0xC3, 0xC0, 0xC9, 0x51, 0x56, 0x80, 0x95, 0x39, 0xFC, 0xF0, 0xE2, 0x42, 0x9A, 0x6B, 0x52, 0x54,
    0x16, 0xAE, 0xDB, 0xF5, 0xA0, 0xDE, 0x6A, 0x57, 0xA6, 0x37, 0xB3, 0x9B,
};
static const uint8_t AESGCM_192_tv4_H[] =
{
    0x46, 0x69, 0x23, 0xEC, 0x9A, 0xE6, 0x82, 0x21, 0x4F, 0x2C, 0x08, 0x2B, 0xAD, 0xB3, 0x92, 0x49,
};
static const uint8_t AESGCM_192_tv4_Y0[] =
{
    0x45, 0x05, 0xCD, 0xC3, 0x67, 0xA0, 0x54, 0xC5, 0x00, 0x28, 0x20, 0xE9, 0x6A, 0xEB, 0xEF, 0x27,
};
static const uint8_t AESGCM_192_tv4_GHASH[] =
{
    0x82, 0x56, 0x7F, 0xB0, 0xB4, 0xCC, 0x37, 0x18, 0x01, 0xEA, 0xDE, 0xC0, 0x05, 0x96, 0x8E, 0x94,
};
static const uint8_t AESGCM_192_tv4_T[] =
{
    0xDC, 0xF5, 0x66, 0xFF, 0x29, 0x1C, 0x25, 0xBB, 0xB8, 0x56, 0x8F, 0xC3, 0xD3, 0x76, 0xA6, 0xD9,
};

/*
#=================================================
#GCM Test Case #14 (AES-256)
#Variable          Value
#-------------------------------------------------
#K               : 00000000000000000000000000000000
#                : 00000000000000000000000000000000
#P               : 00000000000000000000000000000000
#IV              : 000000000000000000000000
#H               : dc95c078a2408989ad48a21492842087
#Y_0             : 00000000000000000000000000000001
#E(K,Y_0)        : 530f8afbc74536b9a963b4f1c4cb738b
#Y_1             : 00000000000000000000000000000002
#E(K,Y_1)        : cea7403d4d606b6e074ec5d3baf39d18
#X_1             : fd6ab7586e556dba06d69cfe6223b262
#len(A)||len(C)  : 00000000000000000000000000000080
#GHASH(H,A,C)    : 83de425c5edc5d498f382c441041ca92
#C               : cea7403d4d606b6e074ec5d3baf39d18
#T               : d0d1c8a799996bf0265b98b5d48ab919
*/
static const uint8_t AESGCM_256_tv0_Key[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t AESGCM_256_tv0_P[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t AESGCM_256_tv0_C[] =
{
    0xCE, 0xA7, 0x40, 0x3D, 0x4D, 0x60, 0x6B, 0x6E, 0x07, 0x4E, 0xC5, 0xD3, 0xBA, 0xF3, 0x9D, 0x18,
};
static const uint8_t AESGCM_256_tv0_A[] = { };
static const uint8_t AESGCM_256_tv0_IV[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const uint8_t AESGCM_256_tv0_H[] =
{
    0xDC, 0x95, 0xC0, 0x78, 0xA2, 0x40, 0x89, 0x89, 0xAD, 0x48, 0xA2, 0x14, 0x92, 0x84, 0x20, 0x87,
};
static const uint8_t AESGCM_256_tv0_Y0[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
};
static const uint8_t AESGCM_256_tv0_GHASH[] =
{
    0x83, 0xDE, 0x42, 0x5C, 0x5E, 0xDC, 0x5D, 0x49, 0x8F, 0x38, 0x2C, 0x44, 0x10, 0x41, 0xCA, 0x92,
};
static const uint8_t AESGCM_256_tv0_T[] =
{
    0xD0, 0xD1, 0xC8, 0xA7, 0x99, 0x99, 0x6B, 0xF0, 0x26, 0x5B, 0x98, 0xB5, 0xD4, 0x8A, 0xB9, 0x19,
};

/*
#=================================================
#GCM Test Case #15 (AES-256)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#                : feffe9928665731c6d6a8f9467308308
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b391aafd255
#IV              : cafebabefacedbaddecaf888
#H               : acbef20579b4b8ebce889bac8732dad7
#Y_0             : cafebabefacedbaddecaf88800000001
#E(K,Y_0)        : fd2caa16a5832e76aa132c1453eeda7e
#Y_1             : cafebabefacedbaddecaf88800000002
#E(K,Y_1)        : 8b1cf3d561d27be251263e66857164e7
#Y_2             : cafebabefacedbaddecaf88800000003
#E(K,Y_2)        : e29d258faad137135bd49280af645bd8
#Y_3             : cafebabefacedbaddecaf88800000004
#E(K,Y_3)        : 908c82ddcc65b26e887f85341f243d1d
#Y_4             : cafebabefacedbaddecaf88800000005
#E(K,Y_4)        : 749cf39639b79c5d06aa8d5b932fc7f8
#X_1             : fcbefb78635d598eddaf982310670f35
#X_2             : 29de812309d3116a6eff7ec844484f3e
#X_3             : 45fad9deeda9ea561b8f199c3613845b
#X_4             : ed95f8e164bf3213febc740f0bd9c6af
#len(A)||len(C)  : 00000000000000000000000000000200
#GHASH(H,A,C)    : 4db870d37cb75fcb46097c36230d1612
#C               : 522dc1f099567d07f47f37a32a84427d
#                : 643a8cdcbfe5c0c97598a2bd2555d1aa
#                : 8cb08e48590dbb3da7b08b1056828838
#                : c5f61e6393ba7a0abcc9f662898015ad
#T               : b094dac5d93471bdec1a502270e3cc6c
*/
static const uint8_t AESGCM_256_tv1_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t AESGCM_256_tv1_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39, 0x1A, 0xAF, 0xD2, 0x55,
};
static const uint8_t AESGCM_256_tv1_C[] =
{
    0x52, 0x2D, 0xC1, 0xF0, 0x99, 0x56, 0x7D, 0x07, 0xF4, 0x7F, 0x37, 0xA3, 0x2A, 0x84, 0x42, 0x7D,
    0x64, 0x3A, 0x8C, 0xDC, 0xBF, 0xE5, 0xC0, 0xC9, 0x75, 0x98, 0xA2, 0xBD, 0x25, 0x55, 0xD1, 0xAA,
    0x8C, 0xB0, 0x8E, 0x48, 0x59, 0x0D, 0xBB, 0x3D, 0xA7, 0xB0, 0x8B, 0x10, 0x56, 0x82, 0x88, 0x38,
    0xC5, 0xF6, 0x1E, 0x63, 0x93, 0xBA, 0x7A, 0x0A, 0xBC, 0xC9, 0xF6, 0x62, 0x89, 0x80, 0x15, 0xAD,
};
static const uint8_t AESGCM_256_tv1_A[] = { };
static const uint8_t AESGCM_256_tv1_IV[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD, 0xDE, 0xCA, 0xF8, 0x88,
};
static const uint8_t AESGCM_256_tv1_H[] =
{
    0xAC, 0xBE, 0xF2, 0x05, 0x79, 0xB4, 0xB8, 0xEB, 0xCE, 0x88, 0x9B, 0xAC, 0x87, 0x32, 0xDA, 0xD7,
};
static const uint8_t AESGCM_256_tv1_Y0[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD, 0xDE, 0xCA, 0xF8, 0x88, 0x00, 0x00, 0x00, 0x01,
};
static const uint8_t AESGCM_256_tv1_GHASH[] =
{
    0x4D, 0xB8, 0x70, 0xD3, 0x7C, 0xB7, 0x5F, 0xCB, 0x46, 0x09, 0x7C, 0x36, 0x23, 0x0D, 0x16, 0x12,
};
static const uint8_t AESGCM_256_tv1_T[] =
{
    0xB0, 0x94, 0xDA, 0xC5, 0xD9, 0x34, 0x71, 0xBD, 0xEC, 0x1A, 0x50, 0x22, 0x70, 0xE3, 0xCC, 0x6C,
};

/*
#=================================================
#GCM Test Case #16 (AES-256)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#                : feffe9928665731c6d6a8f9467308308
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b39
#A               : feedfacedeadbeeffeedfacedeadbeef
#                : abaddad2
#IV              : cafebabefacedbaddecaf888
#H               : acbef20579b4b8ebce889bac8732dad7
#Y_0             : cafebabefacedbaddecaf88800000001
#E(K,Y_0)        : fd2caa16a5832e76aa132c1453eeda7e
#X_1             : 5165d242c2592c0a6375e2622cf925d2
#X_2             : 8efa30ce83298b85fe71abefc0cdd01d
#Y_1             : cafebabefacedbaddecaf88800000002
#E(K,Y_1)        : 8b1cf3d561d27be251263e66857164e7
#Y_2             : cafebabefacedbaddecaf88800000003
#E(K,Y_2)        : e29d258faad137135bd49280af645bd8
#Y_3             : cafebabefacedbaddecaf88800000004
#E(K,Y_3)        : 908c82ddcc65b26e887f85341f243d1d
#Y_4             : cafebabefacedbaddecaf88800000005
#E(K,Y_4)        : 749cf39639b79c5d06aa8d5b932fc7f8
#X_3             : abe07e0bb62354177480b550f9f6cdcc
#X_4             : 3978e4f141b95f3b4699756b1c3c2082
#X_5             : 8abf3c48901debe76837d8a05c7d6e87
#X_6             : 9249beaf520c48b912fa120bbf391dc8
#len(A)||len(C)  : 00000000000000a000000000000001e0
#GHASH(H,A,C)    : 8bd0c4d8aacd391e67cca447e8c38f65
#C               : 522dc1f099567d07f47f37a32a84427d
#                : 643a8cdcbfe5c0c97598a2bd2555d1aa
#                : 8cb08e48590dbb3da7b08b1056828838
#                : c5f61e6393ba7a0abcc9f662
#T               : 76fc6ece0f4e1768cddf8853bb2d551b
*/
static const uint8_t AESGCM_256_tv2_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t AESGCM_256_tv2_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39,
};
static const uint8_t AESGCM_256_tv2_C[] =
{
    0x52, 0x2D, 0xC1, 0xF0, 0x99, 0x56, 0x7D, 0x07, 0xF4, 0x7F, 0x37, 0xA3, 0x2A, 0x84, 0x42, 0x7D,
    0x64, 0x3A, 0x8C, 0xDC, 0xBF, 0xE5, 0xC0, 0xC9, 0x75, 0x98, 0xA2, 0xBD, 0x25, 0x55, 0xD1, 0xAA,
    0x8C, 0xB0, 0x8E, 0x48, 0x59, 0x0D, 0xBB, 0x3D, 0xA7, 0xB0, 0x8B, 0x10, 0x56, 0x82, 0x88, 0x38,
    0xC5, 0xF6, 0x1E, 0x63, 0x93, 0xBA, 0x7A, 0x0A, 0xBC, 0xC9, 0xF6, 0x62,
};
static const uint8_t AESGCM_256_tv2_A[] =
{
    0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF,
    0xAB, 0xAD, 0xDA, 0xD2,
};
static const uint8_t AESGCM_256_tv2_IV[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD, 0xDE, 0xCA, 0xF8, 0x88,
};
static const uint8_t AESGCM_256_tv2_H[] =
{
    0xAC, 0xBE, 0xF2, 0x05, 0x79, 0xB4, 0xB8, 0xEB, 0xCE, 0x88, 0x9B, 0xAC, 0x87, 0x32, 0xDA, 0xD7,
};
static const uint8_t AESGCM_256_tv2_Y0[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD, 0xDE, 0xCA, 0xF8, 0x88, 0x00, 0x00, 0x00, 0x01,
};
static const uint8_t AESGCM_256_tv2_GHASH[] =
{
    0x8B, 0xD0, 0xC4, 0xD8, 0xAA, 0xCD, 0x39, 0x1E, 0x67, 0xCC, 0xA4, 0x47, 0xE8, 0xC3, 0x8F, 0x65,
};
static const uint8_t AESGCM_256_tv2_T[] =
{
    0x76, 0xFC, 0x6E, 0xCE, 0x0F, 0x4E, 0x17, 0x68, 0xCD, 0xDF, 0x88, 0x53, 0xBB, 0x2D, 0x55, 0x1B,
};

/*
#=================================================
#GCM Test Case #17 (AES-256)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#                : feffe9928665731c6d6a8f9467308308
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b39
#A               : feedfacedeadbeeffeedfacedeadbeef
#                : abaddad2
#IV              : cafebabefacedbad
#H               : acbef20579b4b8ebce889bac8732dad7
#N_1             : 90c22e3d2aca34b971e8bd09708fae5c
#0^{64}||len(IV) : 00000000000000000000000000000040
#Y_0             : 0095df49dd90abe3e4d252475748f5d4
#E(K,Y_0)        : 4f903f37fe611d454217fbfa5cd7d791
#X_1             : 5165d242c2592c0a6375e2622cf925d2
#X_2             : 8efa30ce83298b85fe71abefc0cdd01d
#Y_1             : 0095df49dd90abe3e4d252475748f5d5
#E(K,Y_1)        : 1a471fd432fc7bd70b1ec8fe5e6d6251
#Y_2             : 0095df49dd90abe3e4d252475748f5d6
#E(K,Y_2)        : 29bd481e1ea39d20eb63c7ea118b1792
#Y_3             : 0095df49dd90abe3e4d252475748f5d7
#E(K,Y_3)        : e2898e46ac5cada3ba83cc1272618a5d
#Y_4             : 0095df49dd90abe3e4d252475748f5d8
#E(K,Y_4)        : d3c6aefbcea602ce4e1fe026065447bf
#X_3             : 55e1ff68f9249e64b95223858e5cb936
#X_4             : cef1c034383dc96f733aaa4c99bd3e61
#X_5             : 68588d004fd468f5854515039b08165d
#X_6             : 2378943c034697f72a80fce5059bf3f3
#len(A)||len(C)  : 00000000000000a000000000000001e0
#GHASH(H,A,C)    : 75a34288b8c68f811c52b2e9a2f97f63
#C               : c3762df1ca787d32ae47c13bf19844cb
#                : af1ae14d0b976afac52ff7d79bba9de0
#                : feb582d33934a4f0954cc2363bc73f78
#                : 62ac430e64abe499f47c9b1f
#T               : 3a337dbf46a792c45e454913fe2ea8f2
*/
static const uint8_t AESGCM_256_tv3_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t AESGCM_256_tv3_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39,
};
static const uint8_t AESGCM_256_tv3_C[] =
{
    0xC3, 0x76, 0x2D, 0xF1, 0xCA, 0x78, 0x7D, 0x32, 0xAE, 0x47, 0xC1, 0x3B, 0xF1, 0x98, 0x44, 0xCB,
    0xAF, 0x1A, 0xE1, 0x4D, 0x0B, 0x97, 0x6A, 0xFA, 0xC5, 0x2F, 0xF7, 0xD7, 0x9B, 0xBA, 0x9D, 0xE0,
    0xFE, 0xB5, 0x82, 0xD3, 0x39, 0x34, 0xA4, 0xF0, 0x95, 0x4C, 0xC2, 0x36, 0x3B, 0xC7, 0x3F, 0x78,
    0x62, 0xAC, 0x43, 0x0E, 0x64, 0xAB, 0xE4, 0x99, 0xF4, 0x7C, 0x9B, 0x1F,
};
static const uint8_t AESGCM_256_tv3_A[] =
{
    0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF,
    0xAB, 0xAD, 0xDA, 0xD2,
};
static const uint8_t AESGCM_256_tv3_IV[] =
{
    0xCA, 0xFE, 0xBA, 0xBE, 0xFA, 0xCE, 0xDB, 0xAD,
};
static const uint8_t AESGCM_256_tv3_H[] =
{
    0xAC, 0xBE, 0xF2, 0x05, 0x79, 0xB4, 0xB8, 0xEB, 0xCE, 0x88, 0x9B, 0xAC, 0x87, 0x32, 0xDA, 0xD7,
};
static const uint8_t AESGCM_256_tv3_Y0[] =
{
    0x00, 0x95, 0xDF, 0x49, 0xDD, 0x90, 0xAB, 0xE3, 0xE4, 0xD2, 0x52, 0x47, 0x57, 0x48, 0xF5, 0xD4,
};
static const uint8_t AESGCM_256_tv3_GHASH[] =
{
    0x75, 0xA3, 0x42, 0x88, 0xB8, 0xC6, 0x8F, 0x81, 0x1C, 0x52, 0xB2, 0xE9, 0xA2, 0xF9, 0x7F, 0x63,
};
static const uint8_t AESGCM_256_tv3_T[] =
{
    0x3A, 0x33, 0x7D, 0xBF, 0x46, 0xA7, 0x92, 0xC4, 0x5E, 0x45, 0x49, 0x13, 0xFE, 0x2E, 0xA8, 0xF2,
};

/*
#=================================================
#GCM Test Case #18 (AES-256)
#Variable          Value
#-------------------------------------------------
#K               : feffe9928665731c6d6a8f9467308308
#                : feffe9928665731c6d6a8f9467308308
#P               : d9313225f88406e5a55909c5aff5269a
#                : 86a7a9531534f7da2e4c303d8a318a72
#                : 1c3c0c95956809532fcf0e2449a6b525
#                : b16aedf5aa0de657ba637b39
#A               : feedfacedeadbeeffeedfacedeadbeef
#                : abaddad2
#IV              : 9313225df88406e555909c5aff5269aa
#                : 6a7a9538534f7da1e4c303d2a318a728
#                : c3c0c95156809539fcf0e2429a6b5254
#                : 16aedbf5a0de6a57a637b39b
#H               : acbef20579b4b8ebce889bac8732dad7
#N_1             : 0bfe66e2032f195516379f5fb710f987
#N_2             : f0631554d11409915feec8f9f5102aba
#N_3             : 749b90dda19a1557fd9e9fd31fed1d14
#N_4             : 7a6a833f260d848793b327cb07d1b190
#0^{64}||len(IV) : 000000000000000000000000000001e0
#Y_0             : 0cd953e2140a5976079f8e2406bc8eb4
#E(K,Y_0)        : 71b54d092bb0c3d9ba94538d4096e691
#X_1             : 5165d242c2592c0a6375e2622cf925d2
#X_2             : 8efa30ce83298b85fe71abefc0cdd01d
#Y_1             : 0cd953e2140a5976079f8e2406bc8eb5
#E(K,Y_1)        : 83bcdd0af41a551452047196ca6b0cba
#Y_2             : 0cd953e2140a5976079f8e2406bc8eb6
#E(K,Y_2)        : 68151b79baea93c38e149b72e545e186
#Y_3             : 0cd953e2140a5976079f8e2406bc8eb7
#E(K,Y_3)        : 13fccf22159a4d16026ce5d58c7e99fb
#Y_4             : 0cd953e2140a5976079f8e2406bc8eb8
#E(K,Y_4)        : 132b64628a031e79fecd050675a64f07
#X_3             : e963941cfa8c417bdaa3b3d94ab4e905
#X_4             : 2178d7f836e5fa105ce0fdf0fc8f0654
#X_5             : bac14eeba3216f966b3e7e011475b832
#X_6             : cc9ae9175729a649936e890bd971a8bf
#len(A)||len(C)  : 00000000000000a000000000000001e0
#GHASH(H,A,C)    : d5ffcf6fc5ac4d69722187421a7f170b
#C               : 5a8def2f0c9e53f1f75d7853659e2a20
#                : eeb2b22aafde6419a058ab4f6f746bf4
#                : 0fc0c3b780f244452da3ebf1c5d82cde
#                : a2418997200ef82e44ae7e3f
#T               : a44a8266ee1c8eb0c8b5d4cf5ae9f19a
*/
static const uint8_t AESGCM_256_tv4_Key[] =
{
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t AESGCM_256_tv4_P[] =
{
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39,
};
static const uint8_t AESGCM_256_tv4_C[] =
{
    0x5A, 0x8D, 0xEF, 0x2F, 0x0C, 0x9E, 0x53, 0xF1, 0xF7, 0x5D, 0x78, 0x53, 0x65, 0x9E, 0x2A, 0x20,
    0xEE, 0xB2, 0xB2, 0x2A, 0xAF, 0xDE, 0x64, 0x19, 0xA0, 0x58, 0xAB, 0x4F, 0x6F, 0x74, 0x6B, 0xF4,
    0x0F, 0xC0, 0xC3, 0xB7, 0x80, 0xF2, 0x44, 0x45, 0x2D, 0xA3, 0xEB, 0xF1, 0xC5, 0xD8, 0x2C, 0xDE,
    0xA2, 0x41, 0x89, 0x97, 0x20, 0x0E, 0xF8, 0x2E, 0x44, 0xAE, 0x7E, 0x3F,
};
static const uint8_t AESGCM_256_tv4_A[] =
{
    0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF,
    0xAB, 0xAD, 0xDA, 0xD2,
};
static const uint8_t AESGCM_256_tv4_IV[] =
{
    0x93, 0x13, 0x22, 0x5D, 0xF8, 0x84, 0x06, 0xE5, 0x55, 0x90, 0x9C, 0x5A, 0xFF, 0x52, 0x69, 0xAA,
    0x6A, 0x7A, 0x95, 0x38, 0x53, 0x4F, 0x7D, 0xA1, 0xE4, 0xC3, 0x03, 0xD2, 0xA3, 0x18, 0xA7, 0x28,
    0xC3, 0xC0, 0xC9, 0x51, 0x56, 0x80, 0x95, 0x39, 0xFC, 0xF0, 0xE2, 0x42, 0x9A, 0x6B, 0x52, 0x54,
    0x16, 0xAE, 0xDB, 0xF5, 0xA0, 0xDE, 0x6A, 0x57, 0xA6, 0x37, 0xB3, 0x9B,
};
static const uint8_t AESGCM_256_tv4_H[] =
{
    0xAC, 0xBE, 0xF2, 0x05, 0x79, 0xB4, 0xB8, 0xEB, 0xCE, 0x88, 0x9B, 0xAC, 0x87, 0x32, 0xDA, 0xD7,
};
static const uint8_t AESGCM_256_tv4_Y0[] =
{
    0x0C, 0xD9, 0x53, 0xE2, 0x14, 0x0A, 0x59, 0x76, 0x07, 0x9F, 0x8E, 0x24, 0x06, 0xBC, 0x8E, 0xB4,
};
static const uint8_t AESGCM_256_tv4_GHASH[] =
{
    0xD5, 0xFF, 0xCF, 0x6F, 0xC5, 0xAC, 0x4D, 0x69, 0x72, 0x21, 0x87, 0x42, 0x1A, 0x7F, 0x17, 0x0B,
};
static const uint8_t AESGCM_256_tv4_T[] =
{
    0xA4, 0x4A, 0x82, 0x66, 0xEE, 0x1C, 0x8E, 0xB0, 0xC8, 0xB5, 0xD4, 0xCF, 0x5A, 0xE9, 0xF1, 0x9A,
};


/* end of file testvectors_aes_gcm_data.h */
