/* testvectors_sm4_basic_data.h
 *
 * Description: SM4 test vector data taken from the SM4 Blockcipher Algorithm
 *              And Its Modes Of Operations draft-ribose-cfrg-sm4-08
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

#ifndef INCLUDE_GUARD_TEST_VECTORS_SM4_BASIC_DATA_H
#define INCLUDE_GUARD_TEST_VECTORS_SM4_BASIC_DATA_H

#include <third_party/hsmddk/include/Kit/DriverFramework/Basic_Defs_API/incl/basic_defs.h>

// ------------------------------------------------------------------------------
// A.2.1 SM4-ECB Examples
static const uint8_t ECB_A_2_1_1_key[] =
{
    0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF, 0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10
};
static const uint8_t ECB_A_2_1_1_ptx[] =
{
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDD, 0xDD,
    0xEE, 0xEE, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB
};
static const uint8_t ECB_A_2_1_1_ctx[] =
{
    0x5E, 0xC8, 0x14, 0x3D, 0xE5, 0x09, 0xCF, 0xF7, 0xB5, 0x17, 0x9F, 0x8F, 0x47, 0x4B, 0x86, 0x19,
    0x2F, 0x1D, 0x30, 0x5A, 0x7F, 0xB1, 0x7D, 0xF9, 0x85, 0xF8, 0x1C, 0x84, 0x82, 0x19, 0x23, 0x04
};

static const uint8_t ECB_A_2_1_2_key[] =
{
    0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10, 0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF
};
static const uint8_t ECB_A_2_1_2_ptx[] =
{
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDD, 0xDD,
    0xEE, 0xEE, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB
};
static const uint8_t ECB_A_2_1_2_ctx[] =
{
    0xC5, 0x87, 0x68, 0x97, 0xE4, 0xA5, 0x9B, 0xBB, 0xA7, 0x2A, 0x10, 0xC8, 0x38, 0x72, 0x24, 0x5B,
    0x12, 0xDD, 0x90, 0xBC, 0x2D, 0x20, 0x06, 0x92, 0xB5, 0x29, 0xA4, 0x15, 0x5A, 0xC9, 0xE6, 0x00
};


// ------------------------------------------------------------------------------
// A.2.2 SM4-CBC Examples
static const uint8_t CBC_A_2_2_1_key[] =
{
    0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF, 0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10
};
static const uint8_t CBC_A_2_2_1_iv[] =
{
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F
};
static const uint8_t CBC_A_2_2_1_ptx[] =
{
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDD, 0xDD,
    0xEE, 0xEE, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB
};
static const uint8_t CBC_A_2_2_1_ctx[] =
{
    0x78, 0xEB, 0xB1, 0x1C, 0xC4, 0x0B, 0x0A, 0x48, 0x31, 0x2A, 0xAE, 0xB2, 0x04, 0x02, 0x44, 0xCB,
    0x4C, 0xB7, 0x01, 0x69, 0x51, 0x90, 0x92, 0x26, 0x97, 0x9B, 0x0D, 0x15, 0xDC, 0x6A, 0x8F, 0x6D
};
static const uint8_t CBC_A_2_2_1_res_iv[] =
{
    0x4C, 0xB7, 0x01, 0x69, 0x51, 0x90, 0x92, 0x26, 0x97, 0x9B, 0x0D, 0x15, 0xDC, 0x6A, 0x8F, 0x6D
};

static const uint8_t CBC_A_2_2_2_key[] =
{
    0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10, 0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF
};
static const uint8_t CBC_A_2_2_2_iv[] =
{
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F
};
static const uint8_t CBC_A_2_2_2_ptx[] =
{
    0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDD, 0xDD,
    0xEE, 0xEE, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB
};
static const uint8_t CBC_A_2_2_2_ctx[] =
{
    0x0D, 0x3A, 0x6D, 0xDC, 0x2D, 0x21, 0xC6, 0x98, 0x85, 0x72, 0x15, 0x58, 0x7B, 0x7B, 0xB5, 0x9A,
    0x91, 0xF2, 0xC1, 0x47, 0x91, 0x1A, 0x41, 0x44, 0x66, 0x5E, 0x1F, 0xA1, 0xD4, 0x0B, 0xAE, 0x38
};
static const uint8_t CBC_A_2_2_2_res_iv[] =
{
    0x91, 0xF2, 0xC1, 0x47, 0x91, 0x1A, 0x41, 0x44, 0x66, 0x5E, 0x1F, 0xA1, 0xD4, 0x0B, 0xAE, 0x38
};


// ------------------------------------------------------------------------------
// A.2.5 SM4-CTR Examples
static const uint8_t CTR_A_2_5_1_key[] =
{
    0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF, 0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10
};
static const uint8_t CTR_A_2_5_1_iv[] =
{
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F
};
static const uint8_t CTR_A_2_5_1_ptx[] =
{
    0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
    0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB
};
static const uint8_t CTR_A_2_5_1_ctx[] =
{
    0xAC, 0x32, 0x36, 0xCB, 0x97, 0x0C, 0xC2, 0x07, 0x91, 0x36, 0x4C, 0x39, 0x5A, 0x13, 0x42, 0xD1,
    0xA3, 0xCB, 0xC1, 0x87, 0x8C, 0x6F, 0x30, 0xCD, 0x07, 0x4C, 0xCE, 0x38, 0x5C, 0xDD, 0x70, 0xC7,
    0xF2, 0x34, 0xBC, 0x0E, 0x24, 0xC1, 0x19, 0x80, 0xFD, 0x12, 0x86, 0x31, 0x0C, 0xE3, 0x7B, 0x92,
    0x6E, 0x02, 0xFC, 0xD0, 0xFA, 0xA0, 0xBA, 0xF3, 0x8B, 0x29, 0x33, 0x85, 0x1D, 0x82, 0x45, 0x14
};
static const uint8_t CTR_A_2_5_1_res_iv[] =
{
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x13
};

static const uint8_t CTR_A_2_5_2_key[] =
{
    0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10, 0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF
};
static const uint8_t CTR_A_2_5_2_iv[] =
{
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F
};
static const uint8_t CTR_A_2_5_2_ptx[] =
{
    0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB,
    0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB
};
static const uint8_t CTR_A_2_5_2_ctx[] =
{
    0x5D, 0xCC, 0xCD, 0x25, 0xB9, 0x5A, 0xB0, 0x74, 0x17, 0xA0, 0x85, 0x12, 0xEE, 0x16, 0x0E, 0x2F,
    0x8F, 0x66, 0x15, 0x21, 0xCB, 0xBA, 0xB4, 0x4C, 0xC8, 0x71, 0x38, 0x44, 0x5B, 0xC2, 0x9E, 0x5C,
    0x0A, 0xE0, 0x29, 0x72, 0x05, 0xD6, 0x27, 0x04, 0x17, 0x3B, 0x21, 0x23, 0x9B, 0x88, 0x7F, 0x6C,
    0x8C, 0xB5, 0xB8, 0x00, 0x91, 0x7A, 0x24, 0x88, 0x28, 0x4B, 0xDE, 0x9E, 0x16, 0xEA, 0x29, 0x06
};
static const uint8_t CTR_A_2_5_2_res_iv[] =
{
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x13
};


#endif /* INCLUDE_GUARD_TEST_VECTORS_SM4_BASIC_DATA_H */

/* end of file testvectors_sm4_basic_data.h */

