/*
 * Copyright (c) 2018-2025, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 /*
 *  ======== pbe_generic_ram_regs.h ========
*/

#ifndef __PBE_GENERIC_RAM_REGS_H
#define __PBE_GENERIC_RAM_REGS_H

//******************************************************************************
// REGISTER OFFSETS
//******************************************************************************
// 
#define PBE_GENERIC_RAM_O_PHY                                        0x00000020U

// 
#define PBE_GENERIC_RAM_O_SYNTHCALTIMEOUT                            0x00000022U

// Packet configuration (common between TX and RX)
#define PBE_GENERIC_RAM_O_PKTCFG                                     0x00000024U

// 
#define PBE_GENERIC_RAM_O_NUMCRCBITS                                 0x00000026U

// Configure FIFO usage
#define PBE_GENERIC_RAM_O_FIFOCFG                                    0x00000028U

// 
#define PBE_GENERIC_RAM_O_EXTRABYTES                                 0x0000002AU

// Initialization for the whitener, if 0 the whitener is not used
#define PBE_GENERIC_RAM_O_WHITEINIT                                  0x0000002CU

// CRC initialization value
#define PBE_GENERIC_RAM_O_CRCINITL                                   0x00000030U

// CRC initialization value
#define PBE_GENERIC_RAM_O_CRCINITH                                   0x00000032U

// Length field configuration
#define PBE_GENERIC_RAM_O_LENCFG                                     0x00000034U

// 
#define PBE_GENERIC_RAM_O_LENOFFSET                                  0x00000036U

// 
#define PBE_GENERIC_RAM_O_FIRSTRXTIMEOUT                             0x00000038U

// How long to search for sync before giving up
#define PBE_GENERIC_RAM_O_RXTIMEOUT                                  0x0000003AU

// 
#define PBE_GENERIC_RAM_O_RFINTERVAL                                 0x0000003CU

// 
#define PBE_GENERIC_RAM_O_PRETXIFS                                   0x0000003EU

// 
#define PBE_GENERIC_RAM_O_PRERXIFS                                   0x00000040U

// combined tx/rx/fs configuration
#define PBE_GENERIC_RAM_O_OPCFG                                      0x00000042U

// Maximum allowed packet length in RX
#define PBE_GENERIC_RAM_O_MAXLEN                                     0x00000044U

// 
#define PBE_GENERIC_RAM_O_PATTERN                                    0x00000046U

// Address filtering config
#define PBE_GENERIC_RAM_O_ADDRCFG                                    0x00000048U

// Address filtering config
#define PBE_GENERIC_RAM_O_ADDRSW                                     0x0000004AU

// 
#define PBE_GENERIC_RAM_O_TESTCFG                                    0x0000004CU

// 
#define PBE_GENERIC_RAM_O_TESTAPI                                    0x0000004EU

// 
#define PBE_GENERIC_RAM_O_TESTTIMEOUT                                0x00000050U

// 
#define PBE_GENERIC_RAM_O_ADD0                                       0x00000054U

// 
#define PBE_GENERIC_RAM_O_ADD1                                       0x00000056U

// 
#define PBE_GENERIC_RAM_O_ADD2                                       0x00000058U

// 
#define PBE_GENERIC_RAM_O_ADD3                                       0x0000005AU

// 
#define PBE_GENERIC_RAM_O_ADD4                                       0x0000005CU

// 
#define PBE_GENERIC_RAM_O_ADD5                                       0x0000005EU

// 
#define PBE_GENERIC_RAM_O_ADD6                                       0x00000060U

// 
#define PBE_GENERIC_RAM_O_ADD7                                       0x00000062U

// 
#define PBE_GENERIC_RAM_O_ADD8                                       0x00000064U

// 
#define PBE_GENERIC_RAM_O_ADD9                                       0x00000066U

// 
#define PBE_GENERIC_RAM_O_ADD10                                      0x00000068U

// 
#define PBE_GENERIC_RAM_O_ADD11                                      0x0000006AU

// 
#define PBE_GENERIC_RAM_O_ADD12                                      0x0000006CU

// 
#define PBE_GENERIC_RAM_O_ADD13                                      0x0000006EU

// 
#define PBE_GENERIC_RAM_O_ADD15                                      0x00000070U

// 
#define PBE_GENERIC_RAM_O_NRXNOK                                     0x00000072U

// 
#define PBE_GENERIC_RAM_O_NRXIGNORED                                 0x00000074U

// 
#define PBE_GENERIC_RAM_O_NRXEMPTY                                   0x00000076U

// 
#define PBE_GENERIC_RAM_O_NRXFIFOFULL                                0x00000078U

// 
#define PBE_GENERIC_RAM_O_NRXOK                                      0x0000007AU

// 
#define PBE_GENERIC_RAM_O_NTX                                        0x0000007CU

// 
#define PBE_GENERIC_RAM_O_NRXTIMEOUT                                 0x0000007EU

// 
#define PBE_GENERIC_RAM_O_LASTRSSI                                   0x00000080U

// 
#define PBE_GENERIC_RAM_O_LASTFREQOFF                                0x00000082U

// 
#define PBE_GENERIC_RAM_O_LASTLQI                                    0x00000084U

// 
#define PBE_GENERIC_RAM_O_LASTTIMESTAMPL                             0x00000088U

// 
#define PBE_GENERIC_RAM_O_LASTTIMESTAMPH                             0x0000008AU

// 
#define PBE_GENERIC_RAM_O_PEERADRINFO                                0x0000008CU

// Peer address list for syncwordA (MDMSYNCA*)
#define PBE_GENERIC_RAM_O_PEERADR1AL                                 0x0000008EU

// Peer address list for syncwordA (MDMSYNCA*)
#define PBE_GENERIC_RAM_O_PEERADR1AH                                 0x00000090U

// Peer address list for syncwordA (MDMSYNCA*)
#define PBE_GENERIC_RAM_O_PEERADR0AL                                 0x00000092U

// Peer address list for syncwordA (MDMSYNCA*)
#define PBE_GENERIC_RAM_O_PEERADR0AH                                 0x00000094U

// Peer address list for syncwordB (MDMSYNCB*)
#define PBE_GENERIC_RAM_O_PEERADR1BL                                 0x00000096U

// Peer address list for syncwordB (MDMSYNCB*)
#define PBE_GENERIC_RAM_O_PEERADR1BH                                 0x00000098U

// Peer address list for syncwordB (MDMSYNCB*)
#define PBE_GENERIC_RAM_O_PEERADR0BL                                 0x0000009AU

// Peer address list for syncwordB (MDMSYNCB*)
#define PBE_GENERIC_RAM_O_PEERADR0BH                                 0x0000009CU

// Nordic Enhanced Shock Burst configuration shared for both PTX and PRX devices.
#define PBE_GENERIC_RAM_O_NESB                                       0x0000009EU

// NESB feature. CRC value (last two bytes if more than 2 CRC bytes) of last successfully received packet with syncWord0.
#define PBE_GENERIC_RAM_O_CRCVAL0                                    0x000000A0U

// Sequencing or Pkt ID status
#define PBE_GENERIC_RAM_O_SEQSTAT0                                   0x000000A2U

// NESB feature. CRC value (first two bytes if more than 2 CRC bytes) of first successfully received packet with syncWord1.
#define PBE_GENERIC_RAM_O_CRCVAL1                                    0x000000A4U

// Sequencing or Pkt ID status
#define PBE_GENERIC_RAM_O_SEQSTAT1                                   0x000000A6U

// Status for the received packet, appended in the RX FIFO depending on FIFOCFG.
#define PBE_GENERIC_RAM_O_STATUSBYTE                                 0x000000A8U

// Temporary register for storing header byte
#define PBE_GENERIC_RAM_O_TMPBYTE1                                   0x000000AAU

// Temporary register for storing header byte  
#define PBE_GENERIC_RAM_O_TMPBYTE2                                   0x000000ACU

// Temporary register for storing header byte  
#define PBE_GENERIC_RAM_O_TMPBYTE3                                   0x000000AEU

// Temporary register for storing header byte  
#define PBE_GENERIC_RAM_O_TMPBYTE4                                   0x000000B0U

// Temporary register for storing RSSI
#define PBE_GENERIC_RAM_O_TMPRSSI                                    0x000000B2U

// Temporary address register
#define PBE_GENERIC_RAM_O_TMPADR1                                    0x000000B4U

// Temporary address register  
#define PBE_GENERIC_RAM_O_TMPADR2                                    0x000000B6U

// Temporary address register  
#define PBE_GENERIC_RAM_O_TMPADR3                                    0x000000B8U

// Temporary address register  
#define PBE_GENERIC_RAM_O_TMPADR4                                    0x000000BAU

//******************************************************************************
// Register: PHY
//******************************************************************************
// Field: [5:3] rfesel
//
// Used to pass on the value of the Coding Indicator to the RFE.
#define PBE_GENERIC_RAM_PHY_RFESEL_W                                          3U
#define PBE_GENERIC_RAM_PHY_RFESEL_M                                     0x0038U
#define PBE_GENERIC_RAM_PHY_RFESEL_S                                          3U
#define PBE_GENERIC_RAM_PHY_RFESEL_1M                                    0x0000U
#define PBE_GENERIC_RAM_PHY_RFESEL_2M                                    0x0008U
#define PBE_GENERIC_RAM_PHY_RFESEL_CODED_125K                            0x0010U
#define PBE_GENERIC_RAM_PHY_RFESEL_CODED_500K                            0x0018U

// Field: [2:0] mcesel
//
// Used to pass on the value of the Coding Indicator to the MCE.
#define PBE_GENERIC_RAM_PHY_MCESEL_W                                          3U
#define PBE_GENERIC_RAM_PHY_MCESEL_M                                     0x0007U
#define PBE_GENERIC_RAM_PHY_MCESEL_S                                          0U
#define PBE_GENERIC_RAM_PHY_MCESEL_1M                                    0x0000U
#define PBE_GENERIC_RAM_PHY_MCESEL_2M                                    0x0001U
#define PBE_GENERIC_RAM_PHY_MCESEL_CODED_125K                            0x0002U
#define PBE_GENERIC_RAM_PHY_MCESEL_CODED_500K                            0x0003U

//******************************************************************************
// Register: SYNTHCALTIMEOUT
//******************************************************************************
// Field: [15:0] val
//
// SynthCal timeout in 0.25 us unit. 0 means infinite (no timeout)
#define PBE_GENERIC_RAM_SYNTHCALTIMEOUT_VAL_W                                16U
#define PBE_GENERIC_RAM_SYNTHCALTIMEOUT_VAL_M                            0xFFFFU
#define PBE_GENERIC_RAM_SYNTHCALTIMEOUT_VAL_S                                 0U

//******************************************************************************
// Register: PKTCFG
//******************************************************************************
// Field: [11:11] whiteorder
//
// For NextGen CC2500 compatibility
#define PBE_GENERIC_RAM_PKTCFG_WHITEORDER                                0x0800U
#define PBE_GENERIC_RAM_PKTCFG_WHITEORDER_M                              0x0800U
#define PBE_GENERIC_RAM_PKTCFG_WHITEORDER_S                                  11U

// Field: [10:10] crcorder
//
// Bit ordering of the CRC
#define PBE_GENERIC_RAM_PKTCFG_CRCORDER                                  0x0400U
#define PBE_GENERIC_RAM_PKTCFG_CRCORDER_M                                0x0400U
#define PBE_GENERIC_RAM_PKTCFG_CRCORDER_S                                    10U

// Field: [9:9] bitorder
//
// Bit ordering of the payload
#define PBE_GENERIC_RAM_PKTCFG_BITORDER                                  0x0200U
#define PBE_GENERIC_RAM_PKTCFG_BITORDER_M                                0x0200U
#define PBE_GENERIC_RAM_PKTCFG_BITORDER_S                                     9U

// Field: [8:8] hdrorder
//
// Bit ordering of the header
#define PBE_GENERIC_RAM_PKTCFG_HDRORDER                                  0x0100U
#define PBE_GENERIC_RAM_PKTCFG_HDRORDER_M                                0x0100U
#define PBE_GENERIC_RAM_PKTCFG_HDRORDER_S                                     8U

// Field: [7:7] crcinchdr
//
// CRC HDR rule
#define PBE_GENERIC_RAM_PKTCFG_CRCINCHDR                                 0x0080U
#define PBE_GENERIC_RAM_PKTCFG_CRCINCHDR_M                               0x0080U
#define PBE_GENERIC_RAM_PKTCFG_CRCINCHDR_S                                    7U

// Field: [6:6] crcincsw
//
// CRC SW rule
#define PBE_GENERIC_RAM_PKTCFG_CRCINCSW                                  0x0040U
#define PBE_GENERIC_RAM_PKTCFG_CRCINCSW_M                                0x0040U
#define PBE_GENERIC_RAM_PKTCFG_CRCINCSW_S                                     6U

// Field: [5:0] numhdrbits
//
// Number of bits in the header 0-32
#define PBE_GENERIC_RAM_PKTCFG_NUMHDRBITS_W                                   6U
#define PBE_GENERIC_RAM_PKTCFG_NUMHDRBITS_M                              0x003FU
#define PBE_GENERIC_RAM_PKTCFG_NUMHDRBITS_S                                   0U

//******************************************************************************
// Register: NUMCRCBITS
//******************************************************************************
// Field: [5:0] val
//
// Length of CRC checksum in bits
#define PBE_GENERIC_RAM_NUMCRCBITS_VAL_W                                      6U
#define PBE_GENERIC_RAM_NUMCRCBITS_VAL_M                                 0x003FU
#define PBE_GENERIC_RAM_NUMCRCBITS_VAL_S                                      0U

//******************************************************************************
// Register: FIFOCFG
//******************************************************************************
// Field: [15:15] appendtimestamp
//
// 
#define PBE_GENERIC_RAM_FIFOCFG_APPENDTIMESTAMP                          0x8000U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDTIMESTAMP_M                        0x8000U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDTIMESTAMP_S                            15U

// Field: [14:14] appendrssi
//
// 
#define PBE_GENERIC_RAM_FIFOCFG_APPENDRSSI                               0x4000U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDRSSI_M                             0x4000U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDRSSI_S                                 14U

// Field: [13:13] appendfreqest
//
// 
#define PBE_GENERIC_RAM_FIFOCFG_APPENDFREQEST                            0x2000U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDFREQEST_M                          0x2000U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDFREQEST_S                              13U

// Field: [12:12] appendlqi
//
// 
#define PBE_GENERIC_RAM_FIFOCFG_APPENDLQI                                0x1000U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDLQI_M                              0x1000U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDLQI_S                                  12U

// Field: [11:11] appendstatus
//
// CRCOK, Ignore, Code rate
#define PBE_GENERIC_RAM_FIFOCFG_APPENDSTATUS                             0x0800U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDSTATUS_M                           0x0800U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDSTATUS_S                               11U

// Field: [10:10] appendcrc
//
// Append all received crc bits
#define PBE_GENERIC_RAM_FIFOCFG_APPENDCRC                                0x0400U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDCRC_M                              0x0400U
#define PBE_GENERIC_RAM_FIFOCFG_APPENDCRC_S                                  10U

// Field: [9:9] autoflushempty
//
// 
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHEMPTY                           0x0200U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHEMPTY_M                         0x0200U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHEMPTY_S                              9U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHEMPTY_KEEP                      0x0000U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHEMPTY_FLUSH                     0x0200U

// Field: [8:8] autoflushign
//
// 
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHIGN                             0x0100U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHIGN_M                           0x0100U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHIGN_S                                8U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHIGN_KEEP                        0x0000U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHIGN_FLUSH                       0x0100U

// Field: [7:7] autoflushcrc
//
// 
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHCRC                             0x0080U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHCRC_M                           0x0080U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHCRC_S                                7U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHCRC_KEEP                        0x0000U
#define PBE_GENERIC_RAM_FIFOCFG_AUTOFLUSHCRC_FLUSH                       0x0080U

// Field: [6:4] lenoptpad
//
// Length of optional padding, required by the PBE during RX operations  
#define PBE_GENERIC_RAM_FIFOCFG_LENOPTPAD_W                                   3U
#define PBE_GENERIC_RAM_FIFOCFG_LENOPTPAD_M                              0x0070U
#define PBE_GENERIC_RAM_FIFOCFG_LENOPTPAD_S                                   4U

//******************************************************************************
// Register: EXTRABYTES
//******************************************************************************
// Field: [15:0] val
//
// Indicates how many bytes that are required after the PDU to hold the statuses configured in FIFOCFG. It has to be equal or greater. If FIFOCFG_APPENDRSSI is high, EXTRABYTES shall increment by 2 etc.
#define PBE_GENERIC_RAM_EXTRABYTES_VAL_W                                     16U
#define PBE_GENERIC_RAM_EXTRABYTES_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_EXTRABYTES_VAL_S                                      0U

//******************************************************************************
// Register: WHITEINIT
//******************************************************************************
// Field: [15:0] val
//
// Whitener initialization value
#define PBE_GENERIC_RAM_WHITEINIT_VAL_W                                      16U
#define PBE_GENERIC_RAM_WHITEINIT_VAL_M                                  0xFFFFU
#define PBE_GENERIC_RAM_WHITEINIT_VAL_S                                       0U

//******************************************************************************
// Register: CRCINITL
//******************************************************************************
// Field: [15:0] vallsb
//
// 
#define PBE_GENERIC_RAM_CRCINITL_VALLSB_W                                    16U
#define PBE_GENERIC_RAM_CRCINITL_VALLSB_M                                0xFFFFU
#define PBE_GENERIC_RAM_CRCINITL_VALLSB_S                                     0U

//******************************************************************************
// Register: CRCINITH
//******************************************************************************
// Field: [15:0] valmsb
//
// 
#define PBE_GENERIC_RAM_CRCINITH_VALMSB_W                                    16U
#define PBE_GENERIC_RAM_CRCINITH_VALMSB_M                                0xFFFFU
#define PBE_GENERIC_RAM_CRCINITH_VALMSB_S                                     0U

//******************************************************************************
// Register: LENCFG
//******************************************************************************
// Field: [15:10] reserved
//
// Reserved values
#define PBE_GENERIC_RAM_LENCFG_RESERVED_W                                     6U
#define PBE_GENERIC_RAM_LENCFG_RESERVED_M                                0xFC00U
#define PBE_GENERIC_RAM_LENCFG_RESERVED_S                                    10U

// Field: [9:5] numlenbits
//
// Number of bits in length field 0-16.
#define PBE_GENERIC_RAM_LENCFG_NUMLENBITS_W                                   5U
#define PBE_GENERIC_RAM_LENCFG_NUMLENBITS_M                              0x03E0U
#define PBE_GENERIC_RAM_LENCFG_NUMLENBITS_S                                   5U
#define PBE_GENERIC_RAM_LENCFG_NUMLENBITS_FIXED                          0x0000U

// Field: [4:0] lenpos
//
// Position of length field in header 0-31
#define PBE_GENERIC_RAM_LENCFG_LENPOS_W                                       5U
#define PBE_GENERIC_RAM_LENCFG_LENPOS_M                                  0x001FU
#define PBE_GENERIC_RAM_LENCFG_LENPOS_S                                       0U

//******************************************************************************
// Register: LENOFFSET
//******************************************************************************
// Field: [15:0] val
//
// Signed value to add to length field
#define PBE_GENERIC_RAM_LENOFFSET_VAL_W                                      16U
#define PBE_GENERIC_RAM_LENOFFSET_VAL_M                                  0xFFFFU
#define PBE_GENERIC_RAM_LENOFFSET_VAL_S                                       0U

//******************************************************************************
// Register: FIRSTRXTIMEOUT
//******************************************************************************
// Field: [15:0] val
//
// For NESB tasks, the timeout in µs from SYSTCMP0 event to giving up listening for the first packet. Must be at least 128 µs if non-zero, may be up to 32000 µs.
#define PBE_GENERIC_RAM_FIRSTRXTIMEOUT_VAL_W                                 16U
#define PBE_GENERIC_RAM_FIRSTRXTIMEOUT_VAL_M                             0xFFFFU
#define PBE_GENERIC_RAM_FIRSTRXTIMEOUT_VAL_S                                  0U

//******************************************************************************
// Register: RXTIMEOUT
//******************************************************************************
// Field: [15:0] val
//
// RX timeout in 0.25 us unit. 0 means infinite (no timeout)
#define PBE_GENERIC_RAM_RXTIMEOUT_VAL_W                                      16U
#define PBE_GENERIC_RAM_RXTIMEOUT_VAL_M                                  0xFFFFU
#define PBE_GENERIC_RAM_RXTIMEOUT_VAL_S                                       0U

//******************************************************************************
// Register: RFINTERVAL
//******************************************************************************
// Field: [15:0] val
//
// RF interval in units of 1 µs 
#define PBE_GENERIC_RAM_RFINTERVAL_VAL_W                                     16U
#define PBE_GENERIC_RAM_RFINTERVAL_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_RFINTERVAL_VAL_S                                      0U

//******************************************************************************
// Register: PRETXIFS
//******************************************************************************
// Field: [15:0] val
//
// Base value used to set timer0 for when to start Transmission.
#define PBE_GENERIC_RAM_PRETXIFS_VAL_W                                       16U
#define PBE_GENERIC_RAM_PRETXIFS_VAL_M                                   0xFFFFU
#define PBE_GENERIC_RAM_PRETXIFS_VAL_S                                        0U

//******************************************************************************
// Register: PRERXIFS
//******************************************************************************
// Field: [15:0] val
//
// Base value used to set timer0 for when to start Reception.
#define PBE_GENERIC_RAM_PRERXIFS_VAL_W                                       16U
#define PBE_GENERIC_RAM_PRERXIFS_VAL_M                                   0xFFFFU
#define PBE_GENERIC_RAM_PRERXIFS_VAL_S                                        0U

//******************************************************************************
// Register: OPCFG
//******************************************************************************
// Field: [14:14] rxfilterop
//
// Address filtering option
#define PBE_GENERIC_RAM_OPCFG_RXFILTEROP                                 0x4000U
#define PBE_GENERIC_RAM_OPCFG_RXFILTEROP_M                               0x4000U
#define PBE_GENERIC_RAM_OPCFG_RXFILTEROP_S                                   14U

// Field: [13:13] rxincludehdr
//
// Rule for HDR inclusion in FIFO
#define PBE_GENERIC_RAM_OPCFG_RXINCLUDEHDR                               0x2000U
#define PBE_GENERIC_RAM_OPCFG_RXINCLUDEHDR_M                             0x2000U
#define PBE_GENERIC_RAM_OPCFG_RXINCLUDEHDR_S                                 13U
#define PBE_GENERIC_RAM_OPCFG_RXINCLUDEHDR_NO                            0x0000U
#define PBE_GENERIC_RAM_OPCFG_RXINCLUDEHDR_YES                           0x2000U

// Field: [12:12] rxrepeatok
//
// Rule for what to do after packets with correct CRC
#define PBE_GENERIC_RAM_OPCFG_RXREPEATOK                                 0x1000U
#define PBE_GENERIC_RAM_OPCFG_RXREPEATOK_M                               0x1000U
#define PBE_GENERIC_RAM_OPCFG_RXREPEATOK_S                                   12U
#define PBE_GENERIC_RAM_OPCFG_RXREPEATOK_YES                             0x0000U
#define PBE_GENERIC_RAM_OPCFG_RXREPEATOK_NO                              0x1000U

// Field: [11:11] rxrepeatnok
//
// Rule for what to do after packets with CRC error or address mismatch.
#define PBE_GENERIC_RAM_OPCFG_RXREPEATNOK                                0x0800U
#define PBE_GENERIC_RAM_OPCFG_RXREPEATNOK_M                              0x0800U
#define PBE_GENERIC_RAM_OPCFG_RXREPEATNOK_S                                  11U
#define PBE_GENERIC_RAM_OPCFG_RXREPEATNOK_NO                             0x0000U
#define PBE_GENERIC_RAM_OPCFG_RXREPEATNOK_YES                            0x0800U

// Field: [10:10] txinfinite
//
// Infinite TX control
#define PBE_GENERIC_RAM_OPCFG_TXINFINITE                                 0x0400U
#define PBE_GENERIC_RAM_OPCFG_TXINFINITE_M                               0x0400U
#define PBE_GENERIC_RAM_OPCFG_TXINFINITE_S                                   10U
#define PBE_GENERIC_RAM_OPCFG_TXINFINITE_NO                              0x0000U
#define PBE_GENERIC_RAM_OPCFG_TXINFINITE_YES                             0x0400U

// Field: [9:9] txpattern
//
// Send fixed pattern
#define PBE_GENERIC_RAM_OPCFG_TXPATTERN                                  0x0200U
#define PBE_GENERIC_RAM_OPCFG_TXPATTERN_M                                0x0200U
#define PBE_GENERIC_RAM_OPCFG_TXPATTERN_S                                     9U
#define PBE_GENERIC_RAM_OPCFG_TXPATTERN_NO                               0x0000U
#define PBE_GENERIC_RAM_OPCFG_TXPATTERN_YES                              0x0200U

// Field: [8:7] txfcmd
//
// Rule for FCMD after TX_DONE
#define PBE_GENERIC_RAM_OPCFG_TXFCMD_W                                        2U
#define PBE_GENERIC_RAM_OPCFG_TXFCMD_M                                   0x0180U
#define PBE_GENERIC_RAM_OPCFG_TXFCMD_S                                        7U
#define PBE_GENERIC_RAM_OPCFG_TXFCMD_NONE                                0x0000U
#define PBE_GENERIC_RAM_OPCFG_TXFCMD_RETRY                               0x0080U
#define PBE_GENERIC_RAM_OPCFG_TXFCMD_DEALLOC                             0x0100U

// Field: [6:6] start
//
// Rule for start of operation.
#define PBE_GENERIC_RAM_OPCFG_START                                      0x0040U
#define PBE_GENERIC_RAM_OPCFG_START_M                                    0x0040U
#define PBE_GENERIC_RAM_OPCFG_START_S                                         6U

// Field: [5:5] fs_nocal
//
// Rule for frequency synthesizer(FS) calibration
#define PBE_GENERIC_RAM_OPCFG_FS_NOCAL                                   0x0020U
#define PBE_GENERIC_RAM_OPCFG_FS_NOCAL_M                                 0x0020U
#define PBE_GENERIC_RAM_OPCFG_FS_NOCAL_S                                      5U
#define PBE_GENERIC_RAM_OPCFG_FS_NOCAL_CAL                               0x0000U
#define PBE_GENERIC_RAM_OPCFG_FS_NOCAL_NOCAL                             0x0020U

// Field: [4:4] fs_keepon
//
// Rule for frequency synthesizer(FS) power down
#define PBE_GENERIC_RAM_OPCFG_FS_KEEPON                                  0x0010U
#define PBE_GENERIC_RAM_OPCFG_FS_KEEPON_M                                0x0010U
#define PBE_GENERIC_RAM_OPCFG_FS_KEEPON_S                                     4U
#define PBE_GENERIC_RAM_OPCFG_FS_KEEPON_NO                               0x0000U
#define PBE_GENERIC_RAM_OPCFG_FS_KEEPON_YES                              0x0010U

// Field: [3:3] nextop
//
// Enable automatic RX/TX switching, does nothing if OPCFG_SINGLE is selected.
#define PBE_GENERIC_RAM_OPCFG_NEXTOP                                     0x0008U
#define PBE_GENERIC_RAM_OPCFG_NEXTOP_M                                   0x0008U
#define PBE_GENERIC_RAM_OPCFG_NEXTOP_S                                        3U
#define PBE_GENERIC_RAM_OPCFG_NEXTOP_SWITCH                              0x0000U
#define PBE_GENERIC_RAM_OPCFG_NEXTOP_SAME                                0x0008U

// Field: [2:2] single
//
// Only one shall be high of SINGLE, IFSPERIOD or RFINTERVAL.
#define PBE_GENERIC_RAM_OPCFG_SINGLE                                     0x0004U
#define PBE_GENERIC_RAM_OPCFG_SINGLE_M                                   0x0004U
#define PBE_GENERIC_RAM_OPCFG_SINGLE_S                                        2U
#define PBE_GENERIC_RAM_OPCFG_SINGLE_DIS                                 0x0000U
#define PBE_GENERIC_RAM_OPCFG_SINGLE_EN                                  0x0004U

// Field: [1:1] ifsperiod
//
// Only one shall be high of SINGLE, IFSPERIOD or RFINTERVAL.
#define PBE_GENERIC_RAM_OPCFG_IFSPERIOD                                  0x0002U
#define PBE_GENERIC_RAM_OPCFG_IFSPERIOD_M                                0x0002U
#define PBE_GENERIC_RAM_OPCFG_IFSPERIOD_S                                     1U
#define PBE_GENERIC_RAM_OPCFG_IFSPERIOD_DIS                              0x0000U
#define PBE_GENERIC_RAM_OPCFG_IFSPERIOD_EN                               0x0002U

// Field: [0:0] rfinterval
//
// Only one shall be high of SINGLE, IFSPERIOD or RFINTERVAL.
#define PBE_GENERIC_RAM_OPCFG_RFINTERVAL                                 0x0001U
#define PBE_GENERIC_RAM_OPCFG_RFINTERVAL_M                               0x0001U
#define PBE_GENERIC_RAM_OPCFG_RFINTERVAL_S                                    0U
#define PBE_GENERIC_RAM_OPCFG_RFINTERVAL_DIS                             0x0000U
#define PBE_GENERIC_RAM_OPCFG_RFINTERVAL_EN                              0x0001U

//******************************************************************************
// Register: MAXLEN
//******************************************************************************
// Field: [15:0] val
//
// Indicates maximum expected packet length during RX. If NUMLENBITS is 0 then MAXLEN indicates the length of the payload. The length is fixed. If it's 0, RX restarts sync search.
#define PBE_GENERIC_RAM_MAXLEN_VAL_W                                         16U
#define PBE_GENERIC_RAM_MAXLEN_VAL_M                                     0xFFFFU
#define PBE_GENERIC_RAM_MAXLEN_VAL_S                                          0U

//******************************************************************************
// Register: PATTERN
//******************************************************************************
// Field: [15:0] val
//
// Data to send if OPCFG.TXPATTERN is 1
#define PBE_GENERIC_RAM_PATTERN_VAL_W                                        16U
#define PBE_GENERIC_RAM_PATTERN_VAL_M                                    0xFFFFU
#define PBE_GENERIC_RAM_PATTERN_VAL_S                                         0U

//******************************************************************************
// Register: ADDRCFG
//******************************************************************************
// Field: [15:11] numaddr
//
// Number of addresses in use in the address table
#define PBE_GENERIC_RAM_ADDRCFG_NUMADDR_W                                     5U
#define PBE_GENERIC_RAM_ADDRCFG_NUMADDR_M                                0xF800U
#define PBE_GENERIC_RAM_ADDRCFG_NUMADDR_S                                    11U

// Field: [10:6] addrpos
//
// If ADDRTYPE=1, bit position of address in header. If ADDRTYPE=1, set to non-zero to extend address with sync word identifier.
#define PBE_GENERIC_RAM_ADDRCFG_ADDRPOS_W                                     5U
#define PBE_GENERIC_RAM_ADDRCFG_ADDRPOS_M                                0x07C0U
#define PBE_GENERIC_RAM_ADDRCFG_ADDRPOS_S                                     6U

// Field: [5:1] addrsz
//
// Address size. If ADDRTYPE=0 it is in bytes, if ADDRTYPE=1 it is in bits
#define PBE_GENERIC_RAM_ADDRCFG_ADDRSZ_W                                      5U
#define PBE_GENERIC_RAM_ADDRCFG_ADDRSZ_M                                 0x003EU
#define PBE_GENERIC_RAM_ADDRCFG_ADDRSZ_S                                      1U

// Field: [0:0] addrtype
//
// Address type
#define PBE_GENERIC_RAM_ADDRCFG_ADDRTYPE                                 0x0001U
#define PBE_GENERIC_RAM_ADDRCFG_ADDRTYPE_M                               0x0001U
#define PBE_GENERIC_RAM_ADDRCFG_ADDRTYPE_S                                    0U

//******************************************************************************
// Register: ADDRSW
//******************************************************************************
// Field: [15:15] add15sw
//
// Control what SW add15 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD15SW                                   0x8000U
#define PBE_GENERIC_RAM_ADDRSW_ADD15SW_M                                 0x8000U
#define PBE_GENERIC_RAM_ADDRSW_ADD15SW_S                                     15U
#define PBE_GENERIC_RAM_ADDRSW_ADD15SW_A                                 0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD15SW_B                                 0x8000U

// Field: [14:14] add14sw
//
// Control what SW add14 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD14SW                                   0x4000U
#define PBE_GENERIC_RAM_ADDRSW_ADD14SW_M                                 0x4000U
#define PBE_GENERIC_RAM_ADDRSW_ADD14SW_S                                     14U
#define PBE_GENERIC_RAM_ADDRSW_ADD14SW_A                                 0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD14SW_B                                 0x4000U

// Field: [13:13] add13sw
//
// Control what SW add13 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD13SW                                   0x2000U
#define PBE_GENERIC_RAM_ADDRSW_ADD13SW_M                                 0x2000U
#define PBE_GENERIC_RAM_ADDRSW_ADD13SW_S                                     13U
#define PBE_GENERIC_RAM_ADDRSW_ADD13SW_A                                 0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD13SW_B                                 0x2000U

// Field: [12:12] add12sw
//
// Control what SW add12 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD12SW                                   0x1000U
#define PBE_GENERIC_RAM_ADDRSW_ADD12SW_M                                 0x1000U
#define PBE_GENERIC_RAM_ADDRSW_ADD12SW_S                                     12U
#define PBE_GENERIC_RAM_ADDRSW_ADD12SW_A                                 0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD12SW_B                                 0x1000U

// Field: [11:11] add11sw
//
// Control what SW add11 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD11SW                                   0x0800U
#define PBE_GENERIC_RAM_ADDRSW_ADD11SW_M                                 0x0800U
#define PBE_GENERIC_RAM_ADDRSW_ADD11SW_S                                     11U
#define PBE_GENERIC_RAM_ADDRSW_ADD11SW_A                                 0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD11SW_B                                 0x0800U

// Field: [10:10] add10sw
//
// Control what SW add10 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD10SW                                   0x0400U
#define PBE_GENERIC_RAM_ADDRSW_ADD10SW_M                                 0x0400U
#define PBE_GENERIC_RAM_ADDRSW_ADD10SW_S                                     10U
#define PBE_GENERIC_RAM_ADDRSW_ADD10SW_A                                 0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD10SW_B                                 0x0400U

// Field: [9:9] add9sw
//
// Control what SW add9 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD9SW                                    0x0200U
#define PBE_GENERIC_RAM_ADDRSW_ADD9SW_M                                  0x0200U
#define PBE_GENERIC_RAM_ADDRSW_ADD9SW_S                                       9U
#define PBE_GENERIC_RAM_ADDRSW_ADD9SW_A                                  0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD9SW_B                                  0x0200U

// Field: [8:8] add8sw
//
// Control what SW add8 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD8SW                                    0x0100U
#define PBE_GENERIC_RAM_ADDRSW_ADD8SW_M                                  0x0100U
#define PBE_GENERIC_RAM_ADDRSW_ADD8SW_S                                       8U
#define PBE_GENERIC_RAM_ADDRSW_ADD8SW_A                                  0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD8SW_B                                  0x0100U

// Field: [7:7] add7sw
//
// Control what SW add7 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD7SW                                    0x0080U
#define PBE_GENERIC_RAM_ADDRSW_ADD7SW_M                                  0x0080U
#define PBE_GENERIC_RAM_ADDRSW_ADD7SW_S                                       7U
#define PBE_GENERIC_RAM_ADDRSW_ADD7SW_A                                  0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD7SW_B                                  0x0080U

// Field: [6:6] add6sw
//
// Control what SW add6 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD6SW                                    0x0040U
#define PBE_GENERIC_RAM_ADDRSW_ADD6SW_M                                  0x0040U
#define PBE_GENERIC_RAM_ADDRSW_ADD6SW_S                                       6U
#define PBE_GENERIC_RAM_ADDRSW_ADD6SW_A                                  0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD6SW_B                                  0x0040U

// Field: [5:5] add5sw
//
// Control what SW add5 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD5SW                                    0x0020U
#define PBE_GENERIC_RAM_ADDRSW_ADD5SW_M                                  0x0020U
#define PBE_GENERIC_RAM_ADDRSW_ADD5SW_S                                       5U
#define PBE_GENERIC_RAM_ADDRSW_ADD5SW_A                                  0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD5SW_B                                  0x0020U

// Field: [4:4] add4sw
//
// Control what SW add4 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD4SW                                    0x0010U
#define PBE_GENERIC_RAM_ADDRSW_ADD4SW_M                                  0x0010U
#define PBE_GENERIC_RAM_ADDRSW_ADD4SW_S                                       4U
#define PBE_GENERIC_RAM_ADDRSW_ADD4SW_A                                  0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD4SW_B                                  0x0010U

// Field: [3:3] add3sw
//
// Control what SW add3 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD3SW                                    0x0008U
#define PBE_GENERIC_RAM_ADDRSW_ADD3SW_M                                  0x0008U
#define PBE_GENERIC_RAM_ADDRSW_ADD3SW_S                                       3U
#define PBE_GENERIC_RAM_ADDRSW_ADD3SW_A                                  0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD3SW_B                                  0x0008U

// Field: [2:2] add2sw
//
// Control what SW add2 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD2SW                                    0x0004U
#define PBE_GENERIC_RAM_ADDRSW_ADD2SW_M                                  0x0004U
#define PBE_GENERIC_RAM_ADDRSW_ADD2SW_S                                       2U
#define PBE_GENERIC_RAM_ADDRSW_ADD2SW_A                                  0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD2SW_B                                  0x0004U

// Field: [1:1] add1sw
//
// Control what SW add1 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD1SW                                    0x0002U
#define PBE_GENERIC_RAM_ADDRSW_ADD1SW_M                                  0x0002U
#define PBE_GENERIC_RAM_ADDRSW_ADD1SW_S                                       1U
#define PBE_GENERIC_RAM_ADDRSW_ADD1SW_A                                  0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD1SW_B                                  0x0002U

// Field: [0:0] add0sw
//
// Control what SW add0 is expected to belong to
#define PBE_GENERIC_RAM_ADDRSW_ADD0SW                                    0x0001U
#define PBE_GENERIC_RAM_ADDRSW_ADD0SW_M                                  0x0001U
#define PBE_GENERIC_RAM_ADDRSW_ADD0SW_S                                       0U
#define PBE_GENERIC_RAM_ADDRSW_ADD0SW_A                                  0x0000U
#define PBE_GENERIC_RAM_ADDRSW_ADD0SW_B                                  0x0001U

//******************************************************************************
// Register: TESTCFG
//******************************************************************************
// Field: [9:8] endcond
//
// Condition to end the command
#define PBE_GENERIC_RAM_TESTCFG_ENDCOND_W                                     2U
#define PBE_GENERIC_RAM_TESTCFG_ENDCOND_M                                0x0300U
#define PBE_GENERIC_RAM_TESTCFG_ENDCOND_S                                     8U
#define PBE_GENERIC_RAM_TESTCFG_ENDCOND_NEVER                            0x0000U
#define PBE_GENERIC_RAM_TESTCFG_ENDCOND_MDMRFE                           0x0100U
#define PBE_GENERIC_RAM_TESTCFG_ENDCOND_TIMEOUT                          0x0200U
#define PBE_GENERIC_RAM_TESTCFG_ENDCOND_TIMEOUT_DONE                     0x0300U

// Field: [7:1] reserved1
//
// Reserved				
#define PBE_GENERIC_RAM_TESTCFG_RESERVED1_W                                   7U
#define PBE_GENERIC_RAM_TESTCFG_RESERVED1_M                              0x00FEU
#define PBE_GENERIC_RAM_TESTCFG_RESERVED1_S                                   1U

// Field: [0:0] start
//
// Condition to tigger the test command
#define PBE_GENERIC_RAM_TESTCFG_START                                    0x0001U
#define PBE_GENERIC_RAM_TESTCFG_START_M                                  0x0001U
#define PBE_GENERIC_RAM_TESTCFG_START_S                                       0U
#define PBE_GENERIC_RAM_TESTCFG_START_SYNC                               0x0000U
#define PBE_GENERIC_RAM_TESTCFG_START_ASYNC                              0x0001U

//******************************************************************************
// Register: TESTAPI
//******************************************************************************
// Field: [15:8] mdmapi
//
// Command to be sent to modem
#define PBE_GENERIC_RAM_TESTAPI_MDMAPI_W                                      8U
#define PBE_GENERIC_RAM_TESTAPI_MDMAPI_M                                 0xFF00U
#define PBE_GENERIC_RAM_TESTAPI_MDMAPI_S                                      8U

// Field: [7:0] rfeapi
//
// Command to be sent to RFE
#define PBE_GENERIC_RAM_TESTAPI_RFEAPI_W                                      8U
#define PBE_GENERIC_RAM_TESTAPI_RFEAPI_M                                 0x00FFU
#define PBE_GENERIC_RAM_TESTAPI_RFEAPI_S                                      0U

//******************************************************************************
// Register: TESTTIMEOUT
//******************************************************************************
// Field: [15:0] val
//
// Optional timeout value for test command, unit 0.25 us
#define PBE_GENERIC_RAM_TESTTIMEOUT_VAL_W                                    16U
#define PBE_GENERIC_RAM_TESTTIMEOUT_VAL_M                                0xFFFFU
#define PBE_GENERIC_RAM_TESTTIMEOUT_VAL_S                                     0U

//******************************************************************************
// Register: ADD0
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD0_VAL_W                                           16U
#define PBE_GENERIC_RAM_ADD0_VAL_M                                       0xFFFFU
#define PBE_GENERIC_RAM_ADD0_VAL_S                                            0U

//******************************************************************************
// Register: ADD1
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD1_VAL_W                                           16U
#define PBE_GENERIC_RAM_ADD1_VAL_M                                       0xFFFFU
#define PBE_GENERIC_RAM_ADD1_VAL_S                                            0U

//******************************************************************************
// Register: ADD2
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD2_VAL_W                                           16U
#define PBE_GENERIC_RAM_ADD2_VAL_M                                       0xFFFFU
#define PBE_GENERIC_RAM_ADD2_VAL_S                                            0U

//******************************************************************************
// Register: ADD3
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD3_VAL_W                                           16U
#define PBE_GENERIC_RAM_ADD3_VAL_M                                       0xFFFFU
#define PBE_GENERIC_RAM_ADD3_VAL_S                                            0U

//******************************************************************************
// Register: ADD4
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD4_VAL_W                                           16U
#define PBE_GENERIC_RAM_ADD4_VAL_M                                       0xFFFFU
#define PBE_GENERIC_RAM_ADD4_VAL_S                                            0U

//******************************************************************************
// Register: ADD5
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD5_VAL_W                                           16U
#define PBE_GENERIC_RAM_ADD5_VAL_M                                       0xFFFFU
#define PBE_GENERIC_RAM_ADD5_VAL_S                                            0U

//******************************************************************************
// Register: ADD6
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD6_VAL_W                                           16U
#define PBE_GENERIC_RAM_ADD6_VAL_M                                       0xFFFFU
#define PBE_GENERIC_RAM_ADD6_VAL_S                                            0U

//******************************************************************************
// Register: ADD7
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD7_VAL_W                                           16U
#define PBE_GENERIC_RAM_ADD7_VAL_M                                       0xFFFFU
#define PBE_GENERIC_RAM_ADD7_VAL_S                                            0U

//******************************************************************************
// Register: ADD8
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD8_VAL_W                                           16U
#define PBE_GENERIC_RAM_ADD8_VAL_M                                       0xFFFFU
#define PBE_GENERIC_RAM_ADD8_VAL_S                                            0U

//******************************************************************************
// Register: ADD9
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD9_VAL_W                                           16U
#define PBE_GENERIC_RAM_ADD9_VAL_M                                       0xFFFFU
#define PBE_GENERIC_RAM_ADD9_VAL_S                                            0U

//******************************************************************************
// Register: ADD10
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD10_VAL_W                                          16U
#define PBE_GENERIC_RAM_ADD10_VAL_M                                      0xFFFFU
#define PBE_GENERIC_RAM_ADD10_VAL_S                                           0U

//******************************************************************************
// Register: ADD11
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD11_VAL_W                                          16U
#define PBE_GENERIC_RAM_ADD11_VAL_M                                      0xFFFFU
#define PBE_GENERIC_RAM_ADD11_VAL_S                                           0U

//******************************************************************************
// Register: ADD12
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD12_VAL_W                                          16U
#define PBE_GENERIC_RAM_ADD12_VAL_M                                      0xFFFFU
#define PBE_GENERIC_RAM_ADD12_VAL_S                                           0U

//******************************************************************************
// Register: ADD13
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD13_VAL_W                                          16U
#define PBE_GENERIC_RAM_ADD13_VAL_M                                      0xFFFFU
#define PBE_GENERIC_RAM_ADD13_VAL_S                                           0U

//******************************************************************************
// Register: ADD15
//******************************************************************************
// Field: [15:0] val
//
// address bits
#define PBE_GENERIC_RAM_ADD15_VAL_W                                          16U
#define PBE_GENERIC_RAM_ADD15_VAL_M                                      0xFFFFU
#define PBE_GENERIC_RAM_ADD15_VAL_S                                           0U

//******************************************************************************
// Register: NRXNOK
//******************************************************************************
// Field: [15:0] val
//
// Number of packets received with CRC error
#define PBE_GENERIC_RAM_NRXNOK_VAL_W                                         16U
#define PBE_GENERIC_RAM_NRXNOK_VAL_M                                     0xFFFFU
#define PBE_GENERIC_RAM_NRXNOK_VAL_S                                          0U

//******************************************************************************
// Register: NRXIGNORED
//******************************************************************************
// Field: [15:0] val
//
// Number of packets received with CRC OK, but to be ignored by the MCU
#define PBE_GENERIC_RAM_NRXIGNORED_VAL_W                                     16U
#define PBE_GENERIC_RAM_NRXIGNORED_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_NRXIGNORED_VAL_S                                      0U

//******************************************************************************
// Register: NRXEMPTY
//******************************************************************************
// Field: [15:0] val
//
// Number of packets received with CRC OK and length zero
#define PBE_GENERIC_RAM_NRXEMPTY_VAL_W                                       16U
#define PBE_GENERIC_RAM_NRXEMPTY_VAL_M                                   0xFFFFU
#define PBE_GENERIC_RAM_NRXEMPTY_VAL_S                                        0U

//******************************************************************************
// Register: NRXFIFOFULL
//******************************************************************************
// Field: [15:0] val
//
// Number of received packets discarded because the Rx FIFO was full
#define PBE_GENERIC_RAM_NRXFIFOFULL_VAL_W                                    16U
#define PBE_GENERIC_RAM_NRXFIFOFULL_VAL_M                                0xFFFFU
#define PBE_GENERIC_RAM_NRXFIFOFULL_VAL_S                                     0U

//******************************************************************************
// Register: NRXOK
//******************************************************************************
// Field: [15:0] val
//
// Number of non-empty packets received with CRC OK and not  to be ignored by the MCU
#define PBE_GENERIC_RAM_NRXOK_VAL_W                                          16U
#define PBE_GENERIC_RAM_NRXOK_VAL_M                                      0xFFFFU
#define PBE_GENERIC_RAM_NRXOK_VAL_S                                           0U

//******************************************************************************
// Register: NTX
//******************************************************************************
// Field: [15:0] val
//
// Number of transmitted packets,incremented for every transmitted packet
#define PBE_GENERIC_RAM_NTX_VAL_W                                            16U
#define PBE_GENERIC_RAM_NTX_VAL_M                                        0xFFFFU
#define PBE_GENERIC_RAM_NTX_VAL_S                                             0U

//******************************************************************************
// Register: NRXTIMEOUT
//******************************************************************************
// Field: [15:0] val
//
// Number of RX timeout
#define PBE_GENERIC_RAM_NRXTIMEOUT_VAL_W                                     16U
#define PBE_GENERIC_RAM_NRXTIMEOUT_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_NRXTIMEOUT_VAL_S                                      0U

//******************************************************************************
// Register: LASTRSSI
//******************************************************************************
// Field: [15:0] val
//
// RSSI of last received packet with crc OK
#define PBE_GENERIC_RAM_LASTRSSI_VAL_W                                       16U
#define PBE_GENERIC_RAM_LASTRSSI_VAL_M                                   0xFFFFU
#define PBE_GENERIC_RAM_LASTRSSI_VAL_S                                        0U

//******************************************************************************
// Register: LASTFREQOFF
//******************************************************************************
// Field: [15:0] val
//
// FREQOFF of last received packet with crc OK
#define PBE_GENERIC_RAM_LASTFREQOFF_VAL_W                                    16U
#define PBE_GENERIC_RAM_LASTFREQOFF_VAL_M                                0xFFFFU
#define PBE_GENERIC_RAM_LASTFREQOFF_VAL_S                                     0U

//******************************************************************************
// Register: LASTLQI
//******************************************************************************
// Field: [15:0] val
//
// LQI of last received packet with crc OK
#define PBE_GENERIC_RAM_LASTLQI_VAL_W                                        16U
#define PBE_GENERIC_RAM_LASTLQI_VAL_M                                    0xFFFFU
#define PBE_GENERIC_RAM_LASTLQI_VAL_S                                         0U

//******************************************************************************
// Register: LASTTIMESTAMPL
//******************************************************************************
// Field: [15:0] val
//
// Lower part of timestamp.
#define PBE_GENERIC_RAM_LASTTIMESTAMPL_VAL_W                                 16U
#define PBE_GENERIC_RAM_LASTTIMESTAMPL_VAL_M                             0xFFFFU
#define PBE_GENERIC_RAM_LASTTIMESTAMPL_VAL_S                                  0U

//******************************************************************************
// Register: LASTTIMESTAMPH
//******************************************************************************
// Field: [15:0] val
//
// Upper part of timestamp.
#define PBE_GENERIC_RAM_LASTTIMESTAMPH_VAL_W                                 16U
#define PBE_GENERIC_RAM_LASTTIMESTAMPH_VAL_M                             0xFFFFU
#define PBE_GENERIC_RAM_LASTTIMESTAMPH_VAL_S                                  0U

//******************************************************************************
// Register: PEERADRINFO
//******************************************************************************
// Field: [15:0] val
//
// Indicates which peer address that matched the received address.
#define PBE_GENERIC_RAM_PEERADRINFO_VAL_W                                    16U
#define PBE_GENERIC_RAM_PEERADRINFO_VAL_M                                0xFFFFU
#define PBE_GENERIC_RAM_PEERADRINFO_VAL_S                                     0U

//******************************************************************************
// Register: PEERADR1AL
//******************************************************************************
// Field: [15:0] val
//
// bits 15:0 of address
#define PBE_GENERIC_RAM_PEERADR1AL_VAL_W                                     16U
#define PBE_GENERIC_RAM_PEERADR1AL_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_PEERADR1AL_VAL_S                                      0U

//******************************************************************************
// Register: PEERADR1AH
//******************************************************************************
// Field: [15:0] val
//
// bits 31:16 of address
#define PBE_GENERIC_RAM_PEERADR1AH_VAL_W                                     16U
#define PBE_GENERIC_RAM_PEERADR1AH_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_PEERADR1AH_VAL_S                                      0U

//******************************************************************************
// Register: PEERADR0AL
//******************************************************************************
// Field: [15:0] val
//
// bits 15:0 of address
#define PBE_GENERIC_RAM_PEERADR0AL_VAL_W                                     16U
#define PBE_GENERIC_RAM_PEERADR0AL_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_PEERADR0AL_VAL_S                                      0U

//******************************************************************************
// Register: PEERADR0AH
//******************************************************************************
// Field: [15:0] val
//
// bits 31:16 of address
#define PBE_GENERIC_RAM_PEERADR0AH_VAL_W                                     16U
#define PBE_GENERIC_RAM_PEERADR0AH_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_PEERADR0AH_VAL_S                                      0U

//******************************************************************************
// Register: PEERADR1BL
//******************************************************************************
// Field: [15:0] val
//
// bits 15:0 of address
#define PBE_GENERIC_RAM_PEERADR1BL_VAL_W                                     16U
#define PBE_GENERIC_RAM_PEERADR1BL_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_PEERADR1BL_VAL_S                                      0U

//******************************************************************************
// Register: PEERADR1BH
//******************************************************************************
// Field: [15:0] val
//
// bits 31:16 of address
#define PBE_GENERIC_RAM_PEERADR1BH_VAL_W                                     16U
#define PBE_GENERIC_RAM_PEERADR1BH_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_PEERADR1BH_VAL_S                                      0U

//******************************************************************************
// Register: PEERADR0BL
//******************************************************************************
// Field: [15:0] val
//
// bits 15:0 of address
#define PBE_GENERIC_RAM_PEERADR0BL_VAL_W                                     16U
#define PBE_GENERIC_RAM_PEERADR0BL_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_PEERADR0BL_VAL_S                                      0U

//******************************************************************************
// Register: PEERADR0BH
//******************************************************************************
// Field: [15:0] val
//
// bits 31:16 of address
#define PBE_GENERIC_RAM_PEERADR0BH_VAL_W                                     16U
#define PBE_GENERIC_RAM_PEERADR0BH_VAL_M                                 0xFFFFU
#define PBE_GENERIC_RAM_PEERADR0BH_VAL_S                                      0U

//******************************************************************************
// Register: NESB
//******************************************************************************
// Field: [15:6] reserved
//
// reserved
#define PBE_GENERIC_RAM_NESB_RESERVED_W                                      10U
#define PBE_GENERIC_RAM_NESB_RESERVED_M                                  0xFFC0U
#define PBE_GENERIC_RAM_NESB_RESERVED_S                                       6U

// Field: [5:3] peeradrlen
//
// Length of address after header (0-4 bytes) at the start of the "Payload"
#define PBE_GENERIC_RAM_NESB_PEERADRLEN_W                                     3U
#define PBE_GENERIC_RAM_NESB_PEERADRLEN_M                                0x0038U
#define PBE_GENERIC_RAM_NESB_PEERADRLEN_S                                     3U

// Field: [2:2] nesbmode
//
// The default mode is ble5 without many features, aka generic ble5.
#define PBE_GENERIC_RAM_NESB_NESBMODE                                    0x0004U
#define PBE_GENERIC_RAM_NESB_NESBMODE_M                                  0x0004U
#define PBE_GENERIC_RAM_NESB_NESBMODE_S                                       2U
#define PBE_GENERIC_RAM_NESB_NESBMODE_OFF                                0x0000U
#define PBE_GENERIC_RAM_NESB_NESBMODE_ON                                 0x0004U

//******************************************************************************
// Register: CRCVAL0
//******************************************************************************
// Field: [15:0] val
//
// 
#define PBE_GENERIC_RAM_CRCVAL0_VAL_W                                        16U
#define PBE_GENERIC_RAM_CRCVAL0_VAL_M                                    0xFFFFU
#define PBE_GENERIC_RAM_CRCVAL0_VAL_S                                         0U

//******************************************************************************
// Register: SEQSTAT0
//******************************************************************************
// Field: [15:5] reserved
//
// reserved
#define PBE_GENERIC_RAM_SEQSTAT0_RESERVED_W                                  11U
#define PBE_GENERIC_RAM_SEQSTAT0_RESERVED_M                              0xFFE0U
#define PBE_GENERIC_RAM_SEQSTAT0_RESERVED_S                                   5U

// Field: [4:3] stopauto
//
// PTX may attempt to receive an Ack packet and then execute automatic retransmission if the reception failed due to sync timeout or wrong CRC or full RX fifo. PRX may execute automatic acknowledgement transmission and then return to sync search.
#define PBE_GENERIC_RAM_SEQSTAT0_STOPAUTO_W                                   2U
#define PBE_GENERIC_RAM_SEQSTAT0_STOPAUTO_M                              0x0018U
#define PBE_GENERIC_RAM_SEQSTAT0_STOPAUTO_S                                   3U
#define PBE_GENERIC_RAM_SEQSTAT0_STOPAUTO_ALWAYS                         0x0000U
#define PBE_GENERIC_RAM_SEQSTAT0_STOPAUTO_POSNOA                         0x0008U
#define PBE_GENERIC_RAM_SEQSTAT0_STOPAUTO_NEGNOA                         0x0010U
#define PBE_GENERIC_RAM_SEQSTAT0_STOPAUTO_NEVER                          0x0018U

// Field: [2:1] pid
//
// NESB Sequence Number or packet ID.
#define PBE_GENERIC_RAM_SEQSTAT0_PID_W                                        2U
#define PBE_GENERIC_RAM_SEQSTAT0_PID_M                                   0x0006U
#define PBE_GENERIC_RAM_SEQSTAT0_PID_S                                        1U

// Field: [0:0] valid
//
// 
#define PBE_GENERIC_RAM_SEQSTAT0_VALID                                   0x0001U
#define PBE_GENERIC_RAM_SEQSTAT0_VALID_M                                 0x0001U
#define PBE_GENERIC_RAM_SEQSTAT0_VALID_S                                      0U
#define PBE_GENERIC_RAM_SEQSTAT0_VALID_NO                                0x0000U
#define PBE_GENERIC_RAM_SEQSTAT0_VALID_YES                               0x0001U

//******************************************************************************
// Register: CRCVAL1
//******************************************************************************
// Field: [15:0] val
//
// 
#define PBE_GENERIC_RAM_CRCVAL1_VAL_W                                        16U
#define PBE_GENERIC_RAM_CRCVAL1_VAL_M                                    0xFFFFU
#define PBE_GENERIC_RAM_CRCVAL1_VAL_S                                         0U

//******************************************************************************
// Register: SEQSTAT1
//******************************************************************************
// Field: [15:5] reserved
//
// reserved
#define PBE_GENERIC_RAM_SEQSTAT1_RESERVED_W                                  11U
#define PBE_GENERIC_RAM_SEQSTAT1_RESERVED_M                              0xFFE0U
#define PBE_GENERIC_RAM_SEQSTAT1_RESERVED_S                                   5U

// Field: [4:3] stopauto
//
// PTX may attempt to receive an Ack packet and then execute automatic retransmission if the reception failed due to sync timeout or wrong CRC or full RX fifo. PRX may execute automatic acknowledgement transmission and then return to sync search.
#define PBE_GENERIC_RAM_SEQSTAT1_STOPAUTO_W                                   2U
#define PBE_GENERIC_RAM_SEQSTAT1_STOPAUTO_M                              0x0018U
#define PBE_GENERIC_RAM_SEQSTAT1_STOPAUTO_S                                   3U
#define PBE_GENERIC_RAM_SEQSTAT1_STOPAUTO_ALWAYS                         0x0000U
#define PBE_GENERIC_RAM_SEQSTAT1_STOPAUTO_POSNOA                         0x0008U
#define PBE_GENERIC_RAM_SEQSTAT1_STOPAUTO_NEGNOA                         0x0010U
#define PBE_GENERIC_RAM_SEQSTAT1_STOPAUTO_NEVER                          0x0018U

// Field: [2:1] pid
//
// NESB Sequence Number or packet ID.
#define PBE_GENERIC_RAM_SEQSTAT1_PID_W                                        2U
#define PBE_GENERIC_RAM_SEQSTAT1_PID_M                                   0x0006U
#define PBE_GENERIC_RAM_SEQSTAT1_PID_S                                        1U

// Field: [0:0] valid
//
// 
#define PBE_GENERIC_RAM_SEQSTAT1_VALID                                   0x0001U
#define PBE_GENERIC_RAM_SEQSTAT1_VALID_M                                 0x0001U
#define PBE_GENERIC_RAM_SEQSTAT1_VALID_S                                      0U
#define PBE_GENERIC_RAM_SEQSTAT1_VALID_NO                                0x0000U
#define PBE_GENERIC_RAM_SEQSTAT1_VALID_YES                               0x0001U

//******************************************************************************
// Register: STATUSBYTE
//******************************************************************************
// Field: [15:5] reserved
//
// Flags
#define PBE_GENERIC_RAM_STATUSBYTE_RESERVED_W                                11U
#define PBE_GENERIC_RAM_STATUSBYTE_RESERVED_M                            0xFFE0U
#define PBE_GENERIC_RAM_STATUSBYTE_RESERVED_S                                 5U

// Field: [4:4] swsel
//
// Indicates which syncword that was used. 0: SyncwordA, 1: SyncwordB. 
#define PBE_GENERIC_RAM_STATUSBYTE_SWSEL                                 0x0010U
#define PBE_GENERIC_RAM_STATUSBYTE_SWSEL_M                               0x0010U
#define PBE_GENERIC_RAM_STATUSBYTE_SWSEL_S                                    4U

// Field: [3:3] ignored
//
// Ignored due to PID or address.
#define PBE_GENERIC_RAM_STATUSBYTE_IGNORED                               0x0008U
#define PBE_GENERIC_RAM_STATUSBYTE_IGNORED_M                             0x0008U
#define PBE_GENERIC_RAM_STATUSBYTE_IGNORED_S                                  3U

// Field: [2:2] crcerror
//
// CRC check with PHA failed.
#define PBE_GENERIC_RAM_STATUSBYTE_CRCERROR                              0x0004U
#define PBE_GENERIC_RAM_STATUSBYTE_CRCERROR_M                            0x0004U
#define PBE_GENERIC_RAM_STATUSBYTE_CRCERROR_S                                 2U

// Field: [1:0] phy
//
// aka Rate Indicator.
#define PBE_GENERIC_RAM_STATUSBYTE_PHY_W                                      2U
#define PBE_GENERIC_RAM_STATUSBYTE_PHY_M                                 0x0003U
#define PBE_GENERIC_RAM_STATUSBYTE_PHY_S                                      0U
#define PBE_GENERIC_RAM_STATUSBYTE_PHY_1M                                0x0000U
#define PBE_GENERIC_RAM_STATUSBYTE_PHY_2M                                0x0001U
#define PBE_GENERIC_RAM_STATUSBYTE_PHY_CODED_125K                        0x0002U
#define PBE_GENERIC_RAM_STATUSBYTE_PHY_CODED_500K                        0x0003U

//******************************************************************************
// Register: TMPBYTE1
//******************************************************************************
// Field: [15:0] val
//
// Flags
#define PBE_GENERIC_RAM_TMPBYTE1_VAL_W                                       16U
#define PBE_GENERIC_RAM_TMPBYTE1_VAL_M                                   0xFFFFU
#define PBE_GENERIC_RAM_TMPBYTE1_VAL_S                                        0U

//******************************************************************************
// Register: TMPBYTE2
//******************************************************************************
// Field: [15:0] val
//
// Flags
#define PBE_GENERIC_RAM_TMPBYTE2_VAL_W                                       16U
#define PBE_GENERIC_RAM_TMPBYTE2_VAL_M                                   0xFFFFU
#define PBE_GENERIC_RAM_TMPBYTE2_VAL_S                                        0U

//******************************************************************************
// Register: TMPBYTE3
//******************************************************************************
// Field: [15:0] val
//
// Flags
#define PBE_GENERIC_RAM_TMPBYTE3_VAL_W                                       16U
#define PBE_GENERIC_RAM_TMPBYTE3_VAL_M                                   0xFFFFU
#define PBE_GENERIC_RAM_TMPBYTE3_VAL_S                                        0U

//******************************************************************************
// Register: TMPBYTE4
//******************************************************************************
// Field: [15:0] val
//
// Flags
#define PBE_GENERIC_RAM_TMPBYTE4_VAL_W                                       16U
#define PBE_GENERIC_RAM_TMPBYTE4_VAL_M                                   0xFFFFU
#define PBE_GENERIC_RAM_TMPBYTE4_VAL_S                                        0U

//******************************************************************************
// Register: TMPRSSI
//******************************************************************************
// Field: [15:0] val
//
// RSSI
#define PBE_GENERIC_RAM_TMPRSSI_VAL_W                                        16U
#define PBE_GENERIC_RAM_TMPRSSI_VAL_M                                    0xFFFFU
#define PBE_GENERIC_RAM_TMPRSSI_VAL_S                                         0U

//******************************************************************************
// Register: TMPADR1
//******************************************************************************
// Field: [15:0] val
//
// Flags
#define PBE_GENERIC_RAM_TMPADR1_VAL_W                                        16U
#define PBE_GENERIC_RAM_TMPADR1_VAL_M                                    0xFFFFU
#define PBE_GENERIC_RAM_TMPADR1_VAL_S                                         0U

//******************************************************************************
// Register: TMPADR2
//******************************************************************************
// Field: [15:0] val
//
// Flags
#define PBE_GENERIC_RAM_TMPADR2_VAL_W                                        16U
#define PBE_GENERIC_RAM_TMPADR2_VAL_M                                    0xFFFFU
#define PBE_GENERIC_RAM_TMPADR2_VAL_S                                         0U

//******************************************************************************
// Register: TMPADR3
//******************************************************************************
// Field: [15:0] val
//
// Flags
#define PBE_GENERIC_RAM_TMPADR3_VAL_W                                        16U
#define PBE_GENERIC_RAM_TMPADR3_VAL_M                                    0xFFFFU
#define PBE_GENERIC_RAM_TMPADR3_VAL_S                                         0U

//******************************************************************************
// Register: TMPADR4
//******************************************************************************
// Field: [15:0] val
//
// Flags
#define PBE_GENERIC_RAM_TMPADR4_VAL_W                                        16U
#define PBE_GENERIC_RAM_TMPADR4_VAL_M                                    0xFFFFU
#define PBE_GENERIC_RAM_TMPADR4_VAL_S                                         0U


#endif // __PBE_GENERIC_RAM_REGS_H
