/*
 * Copyright (c) 2021-2023, Arm Limited. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 */

#ifndef CC3XX_ERROR_H
#define CC3XX_ERROR_H

#include <stdint.h>

typedef int cc3xx_err_t;

#ifdef __cplusplus
extern "C" {
#endif
enum cc3xx_error {
    CC3XX_ERR_SUCCESS = 0,
    CC3XX_ERR_BUFFER_OVERFLOW,
    CC3XX_ERR_INVALID_LCS,
    CC3XX_ERR_INVALID_DATA,
    CC3XX_ERR_INVALID_STATE,
    CC3XX_ERR_NOT_IMPLEMENTED,
    CC3XX_ERR_ENGINE_IN_USE,
    CC3XX_ERR_KEY_IMPORT_FAILED,
    CC3XX_ERR_INVALID_REMAP_REGION,
    CC3XX_ERR_BUS_ERROR,
    CC3XX_ERR_RNG_TOO_MANY_ATTEMPTS,
    CC3XX_ERR_VERIFY_FAILED,
    CC3XX_ERR_INVALID_TAG,
    CC3XX_ERR_DMA_OUTPUT_BUFFER_TOO_SMALL,
    CC3XX_ERR_INVALID_INPUT_LENGTH,
    CC3XX_ERR_GCM_VARIABLE_IV_NOT_IMPLEMENTED,
    CC3XX_ERR_CHACHA_IV_SIZE_INCORRECT,
    CC3XX_ERR_DFA_VIOLATION,
    CC3XX_ERR_DRBG_RESEED_REQUIRED,
    CC3XX_ERR_DRBG_INVALID_ID,
    CC3XX_ERR_MAX_VALUE = UINT32_MAX
};

#ifdef __cplusplus
}
#endif

#endif /* CC3XX_ERROR_H */
