/* testvectors_sm4_gcm_data.h
 *
 * Description: Test vectors for SM4-GCM, test vector contents.
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

#include <third_party/hsmddk/include/Kit/DriverFramework/Basic_Defs_API/incl/basic_defs.h>

/* Not used items */
static const uint8_t SM4_GCM_H_nu[] = {};
static const uint8_t SM4_GCM_Y0_nu[] = {};
static const uint8_t SM4_GCM_GH_nu[] = {};

/* Test Case: KLen=128, PtxLen=16, AadLen=16, TagLen=16 */
static const uint8_t SM4_GCM_128_1_K[] =
{
    0x01, 0x23, 0x45, 0x67, 0x89, 0xAB, 0xCD, 0xEF, 0xFE, 0xDC, 0xBA, 0x98, 0x76, 0x54, 0x32, 0x10
};
static const uint8_t SM4_GCM_128_1_P[] =
{
    0x92, 0x5B, 0x5E, 0xF6, 0x86, 0x3A, 0x90, 0x51, 0xD6, 0x14, 0xE7, 0x83, 0x5B, 0x38, 0x58, 0xC9
};
static const uint8_t SM4_GCM_128_1_A[] =
{
    0xB6, 0x09, 0x6D, 0x0F, 0x2D, 0xF1, 0xB9, 0x11, 0x75, 0xE9, 0x74, 0x8C, 0x7C, 0x03, 0x4B, 0x97
};
static const uint8_t SM4_GCM_128_1_IV[] =
{
    0x70, 0xE2, 0x5A, 0x32, 0xEB, 0xE1, 0x15, 0x43, 0xAA, 0xDE, 0x32, 0xED
};
static const uint8_t SM4_GCM_128_1_C[] =
{
    0xDD, 0x80, 0xD8, 0xE0, 0x43, 0x58, 0x0E, 0xE9, 0xD9, 0x3E, 0x14, 0x30, 0x73, 0xD1, 0x51, 0x5F
};
static const uint8_t SM4_GCM_128_1_T[] =
{
    0x66, 0xCE, 0xC0, 0x81, 0x16, 0xF7, 0x69, 0x10, 0x06, 0xE6, 0x44, 0xDF, 0x66, 0x2D, 0x26, 0xA4
};

/* Test Case: KLen=128, PtxLen=19, AadLen=8, TagLen=16 */
static const uint8_t SM4_GCM_128_2_K[] =
{
    0x46, 0x0A, 0x8C, 0x3E, 0x1F, 0x0B, 0x4A, 0x32, 0x2A, 0xB6, 0x2E, 0x5F, 0xAF, 0xA7, 0x09, 0x6A
};
static const uint8_t SM4_GCM_128_2_P[] =
{
    0xF4, 0x70, 0x4C, 0xCE, 0x1F, 0xB4, 0x56, 0xA8, 0x19, 0x61, 0x54, 0x57, 0xB1, 0x2E, 0x02, 0xA6,
    0xD6, 0xDB, 0x6C
};
static const uint8_t SM4_GCM_128_2_A[] =
{
    0x2C, 0x94, 0x56, 0x4E, 0x2A, 0xE4, 0x82, 0xA4
};
static const uint8_t SM4_GCM_128_2_IV[] =
{
    0x42, 0x7F, 0xF0, 0x18, 0x97, 0x37, 0x1F, 0x00, 0x0C, 0xA3, 0x08, 0x30
};
static const uint8_t SM4_GCM_128_2_C[] =
{
    0x12, 0x9E, 0x8F, 0x64, 0xE3, 0x11, 0x85, 0x7E, 0x9A, 0xAC, 0xC4, 0x85, 0xDB, 0x2B, 0x94, 0xD8,
    0xEC, 0x21, 0x57
};
static const uint8_t SM4_GCM_128_2_T[] =
{
    0x93, 0x65, 0x5B, 0x26, 0x7B, 0x1D, 0x18, 0xEA, 0xA1, 0x15, 0xA2, 0xBA, 0x46, 0xEA, 0xBE, 0xE6
};

/* Test Case: KLen=128, PtxLen=93, AadLen=31, TagLen=16 */
static const uint8_t SM4_GCM_128_3_K[] =
{
    0xB3, 0xD9, 0x1B, 0x9A, 0x04, 0x75, 0xC7, 0x5A, 0x04, 0x41, 0xCF, 0x04, 0xA0, 0x57, 0xA7, 0xEA
};
static const uint8_t SM4_GCM_128_3_P[] =
{
    0xE6, 0xB3, 0x02, 0x8D, 0x20, 0x24, 0xE5, 0x5D, 0xF3, 0x8C, 0x94, 0xC6, 0xCA, 0x72, 0xC3, 0x16,
    0x95, 0x4A, 0x90, 0x9F, 0x65, 0x28, 0x99, 0x6F, 0x7F, 0x1D, 0xDF, 0xBD, 0x5E, 0x7A, 0xF2, 0x94,
    0xEF, 0xB9, 0x90, 0x46, 0x37, 0xF2, 0xDF, 0x03, 0x99, 0x72, 0x6E, 0x2F, 0x64, 0x85, 0x80, 0x83,
    0x00, 0x80, 0x97, 0xFE, 0xE1, 0xA8, 0x0D, 0x76, 0xED, 0x00, 0xE2, 0x62, 0x04, 0x6A, 0x58, 0x29,
    0x46, 0xD7, 0x17, 0x3A, 0xBD, 0x7B, 0x65, 0xF6, 0xFA, 0xD0, 0x92, 0x89, 0xDF, 0x00, 0x01, 0xD5,
    0x02, 0x94, 0x8E, 0x54, 0x65, 0xAC, 0xA8, 0xCE, 0x2F, 0xAD, 0x83, 0x61, 0x2B
};
static const uint8_t SM4_GCM_128_3_A[] =
{
    0x89, 0x6F, 0xF1, 0x91, 0xB2, 0xFE, 0xB2, 0xAA, 0x44, 0x25, 0xEA, 0x0D, 0xFB, 0x7A, 0x89, 0xDB,
    0x03, 0xED, 0x61, 0xF8, 0x02, 0x2D, 0x19, 0x58, 0xF8, 0x51, 0xA6, 0xE0, 0x0A, 0x4B, 0xFC
};
static const uint8_t SM4_GCM_128_3_IV[] =
{
    0x82, 0x36, 0x21, 0x0A, 0x02, 0x9A, 0x73, 0x09, 0xC3, 0xC9, 0x2C, 0xBF
};
static const uint8_t SM4_GCM_128_3_C[] =
{
    0x3C, 0x7F, 0x7A, 0x6B, 0x3E, 0x59, 0x01, 0x79, 0x4E, 0x7A, 0x05, 0xE8, 0x76, 0xDC, 0x55, 0x67,
    0xB1, 0x15, 0x77, 0x3D, 0xE7, 0xE8, 0x1E, 0x6E, 0xC0, 0x13, 0x71, 0x8F, 0x1D, 0x12, 0x54, 0x0E,
    0xA3, 0x81, 0x8E, 0x52, 0x22, 0x80, 0x5B, 0x7E, 0xE6, 0x4A, 0x47, 0xC7, 0xB5, 0x50, 0x4C, 0xEB,
    0xCB, 0xA5, 0x75, 0x24, 0x37, 0x97, 0xC6, 0x51, 0xF4, 0xDD, 0x31, 0x6A, 0xDD, 0x74, 0xBD, 0x7A,
    0xC4, 0x5A, 0xEE, 0x20, 0x52, 0x36, 0x9D, 0x27, 0xCC, 0x60, 0x7C, 0xD6, 0xE6, 0x48, 0x31, 0xB3,
    0x3A, 0x77, 0xDA, 0x9B, 0x91, 0x51, 0xEC, 0xAA, 0x5F, 0x88, 0xBC, 0x83, 0x56
};
static const uint8_t SM4_GCM_128_3_T[] =
{
    0x02, 0x60, 0x67, 0xD8, 0xEE, 0x0A, 0x59, 0xEA, 0xD6, 0xEF, 0xA7, 0xFD, 0xAF, 0xE9, 0x21, 0xAB
};

/* end of file testvectors_sm4_gcm_data.h */
