/* testvectors_rsa_data.h
 *
 * Description: Test vectors for RSA, actual test vector contents.
 *              This file has been automatically generated.
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

//=============================================================================
// RSA PKCS#1 v1.5

#include <third_party/hsmddk/include/Kit/DriverFramework/Basic_Defs_API/incl/basic_defs.h>

/* The RSA key pairs. */
static const uint8_t der_rsa_pkcs1v15_key_1024[] =
{
    /*0x0000*/ 0x30, 0x82, 0x02, 0x5e, 0x02, 0x01, 0x00, 0x02,
    /*0x0008*/ 0x81, 0x81, 0x00, 0xc3, 0xad, 0x78, 0xdb, 0x1d,
    /*0x0010*/ 0xbd, 0x02, 0x36, 0xa5, 0xcb, 0x09, 0x35, 0x8e,
    /*0x0018*/ 0x9d, 0x25, 0x38, 0xd5, 0x9a, 0xda, 0xe1, 0xca,
    /*0x0020*/ 0xf8, 0x78, 0xa1, 0x1c, 0xd0, 0xdb, 0x1d, 0xf2,
    /*0x0028*/ 0x60, 0x7f, 0x9c, 0xaf, 0xe0, 0xcd, 0xc9, 0x85,
    /*0x0030*/ 0x18, 0xe7, 0xde, 0x1c, 0xe3, 0xb0, 0x3c, 0x41,
    /*0x0038*/ 0x8a, 0xcf, 0xda, 0x27, 0xcb, 0x47, 0xc4, 0xa0,
    /*0x0040*/ 0xb7, 0xcf, 0x28, 0x11, 0x85, 0x85, 0x13, 0x33,
    /*0x0048*/ 0xfb, 0x06, 0x4e, 0xb4, 0xca, 0x79, 0xe7, 0xd3,
    /*0x0050*/ 0x29, 0x13, 0x04, 0x59, 0xd3, 0x5e, 0x83, 0xea,
    /*0x0058*/ 0xbf, 0x5f, 0x68, 0x9e, 0x36, 0x29, 0x59, 0x59,
    /*0x0060*/ 0x8a, 0xb5, 0xa1, 0x90, 0x0f, 0x67, 0xc1, 0x73,
    /*0x0068*/ 0x62, 0xb9, 0xe4, 0x93, 0x36, 0xa3, 0xf4, 0xb1,
    /*0x0070*/ 0x20, 0x2d, 0x2c, 0xbf, 0xa0, 0x14, 0x3f, 0xdc,
    /*0x0078*/ 0xf8, 0xd2, 0x6e, 0xc6, 0x28, 0x2e, 0x96, 0x5a,
    /*0x0080*/ 0x71, 0xd3, 0xeb, 0x12, 0x05, 0x7e, 0xdc, 0x4c,
    /*0x0088*/ 0x0d, 0xd5, 0xfb, 0x02, 0x03, 0x01, 0x00, 0x01,
    /*0x0090*/ 0x02, 0x81, 0x80, 0x35, 0xa6, 0xad, 0x99, 0x5e,
    /*0x0098*/ 0x79, 0x01, 0x4f, 0x5c, 0x7b, 0xe3, 0xe5, 0x84,
    /*0x00a0*/ 0x59, 0xbf, 0xe7, 0xea, 0x61, 0x50, 0x1c, 0x52,
    /*0x00a8*/ 0x9b, 0x77, 0xef, 0xac, 0xc7, 0xf3, 0x1c, 0x2d,
    /*0x00b0*/ 0xe5, 0x99, 0x77, 0xab, 0x9d, 0x76, 0xaf, 0x07,
    /*0x00b8*/ 0x48, 0x41, 0xe2, 0xdb, 0x86, 0xee, 0x3e, 0x47,
    /*0x00c0*/ 0x36, 0x39, 0x31, 0x36, 0x71, 0xfd, 0x16, 0x83,
    /*0x00c8*/ 0x7e, 0x82, 0x55, 0x19, 0x20, 0xc3, 0xd0, 0xf5,
    /*0x00d0*/ 0x12, 0xa1, 0xb2, 0x9d, 0x69, 0x03, 0x03, 0xca,
    /*0x00d8*/ 0x5c, 0x5c, 0x81, 0xdf, 0x9b, 0x59, 0xcd, 0xc7,
    /*0x00e0*/ 0x7b, 0x55, 0x95, 0x70, 0x59, 0xf3, 0xd1, 0x0f,
    /*0x00e8*/ 0x7b, 0x91, 0xa2, 0xcb, 0x0c, 0x4e, 0x4b, 0x6f,
    /*0x00f0*/ 0xa7, 0xa3, 0x8f, 0x90, 0x39, 0x1f, 0xc4, 0xb5,
    /*0x00f8*/ 0x19, 0x1e, 0xea, 0x3c, 0x47, 0x11, 0xc6, 0x1c,
    /*0x0100*/ 0x81, 0x0b, 0xa2, 0x3e, 0xfa, 0x09, 0x87, 0x30,
    /*0x0108*/ 0x0f, 0x42, 0xd7, 0x0f, 0xc1, 0xa1, 0x75, 0xb7,
    /*0x0110*/ 0x20, 0xff, 0xc9, 0x02, 0x41, 0x00, 0xf8, 0x39,
    /*0x0118*/ 0x46, 0xdc, 0xd3, 0x56, 0x09, 0x6a, 0x54, 0xba,
    /*0x0120*/ 0x25, 0xae, 0xff, 0x79, 0x77, 0xa9, 0x3b, 0x75,
    /*0x0128*/ 0xa5, 0x49, 0x83, 0x55, 0x36, 0x3a, 0xe1, 0xa2,
    /*0x0130*/ 0xc4, 0xef, 0xc8, 0x8e, 0x36, 0xff, 0x62, 0xd6,
    /*0x0138*/ 0xbb, 0x25, 0xd7, 0x82, 0xe4, 0xe1, 0x68, 0x26,
    /*0x0140*/ 0xc3, 0x74, 0x26, 0x6a, 0x8d, 0x58, 0x8a, 0xf3,
    /*0x0148*/ 0x0d, 0x77, 0xa1, 0x30, 0x94, 0xa1, 0xc0, 0xb7,
    /*0x0150*/ 0xb8, 0x8a, 0x88, 0x71, 0x10, 0x4d, 0x02, 0x41,
    /*0x0158*/ 0x00, 0xc9, 0xce, 0xc8, 0x35, 0x97, 0x7e, 0x41,
    /*0x0160*/ 0xc5, 0xf4, 0x8e, 0x0a, 0x21, 0x05, 0x6a, 0x0c,
    /*0x0168*/ 0x61, 0x16, 0x5e, 0x9c, 0x18, 0x90, 0xd5, 0x21,
    /*0x0170*/ 0x82, 0x82, 0x80, 0x0c, 0xa9, 0x6f, 0x67, 0xe4,
    /*0x0178*/ 0x15, 0x72, 0x20, 0xbd, 0x49, 0x5c, 0x1d, 0xfc,
    /*0x0180*/ 0xc8, 0x0a, 0x73, 0x9a, 0x17, 0xbe, 0x7d, 0x2b,
    /*0x0188*/ 0xfa, 0xda, 0xc4, 0x66, 0xde, 0x72, 0xba, 0x1e,
    /*0x0190*/ 0x3e, 0x5a, 0x74, 0x61, 0x5c, 0xa7, 0x8c, 0xe3,
    /*0x0198*/ 0x67, 0x02, 0x41, 0x00, 0x86, 0xe0, 0xc0, 0xa3,
    /*0x01a0*/ 0x9f, 0x66, 0x61, 0xc9, 0x58, 0x6e, 0xa9, 0xa9,
    /*0x01a8*/ 0x54, 0x82, 0x91, 0x45, 0xf0, 0xdc, 0x35, 0x4b,
    /*0x01b0*/ 0x23, 0xc4, 0xfa, 0xa9, 0xb6, 0x0f, 0x77, 0x09,
    /*0x01b8*/ 0x80, 0x25, 0xde, 0xb6, 0x98, 0xe3, 0x6b, 0x5f,
    /*0x01c0*/ 0xdd, 0xa1, 0xef, 0x72, 0x97, 0xe0, 0x70, 0x56,
    /*0x01c8*/ 0x3d, 0xc5, 0xaa, 0x36, 0x51, 0x92, 0x4e, 0x60,
    /*0x01d0*/ 0x11, 0xc3, 0x4f, 0x10, 0x31, 0xa2, 0xe2, 0xf0,
    /*0x01d8*/ 0xcb, 0xc0, 0xfc, 0x05, 0x02, 0x41, 0x00, 0xb6,
    /*0x01e0*/ 0x95, 0x6d, 0xb2, 0x7f, 0x13, 0xee, 0x32, 0x49,
    /*0x01e8*/ 0xa6, 0xd1, 0x27, 0x3b, 0x1c, 0xcd, 0x82, 0x71,
    /*0x01f0*/ 0x98, 0xbb, 0xa5, 0xc6, 0x33, 0xee, 0x93, 0x83,
    /*0x01f8*/ 0xba, 0x92, 0xba, 0x21, 0x5f, 0x5f, 0x8e, 0xbf,
    /*0x0200*/ 0xa9, 0x3b, 0x58, 0xca, 0x0d, 0x1f, 0x8d, 0x65,
    /*0x0208*/ 0x57, 0x5e, 0x0d, 0x29, 0x7d, 0x5a, 0x73, 0x25,
    /*0x0210*/ 0xc7, 0x18, 0x43, 0x1e, 0x8d, 0xa1, 0x9b, 0x4c,
    /*0x0218*/ 0x7f, 0x8b, 0x2f, 0x27, 0x30, 0x62, 0xf5, 0x02,
    /*0x0220*/ 0x41, 0x00, 0xd8, 0x43, 0xa5, 0x63, 0x17, 0x88,
    /*0x0228*/ 0x4e, 0xdd, 0x67, 0x92, 0xfa, 0x43, 0xd1, 0xd5,
    /*0x0230*/ 0xe8, 0x7a, 0x4c, 0xf0, 0x61, 0xef, 0x53, 0xdb,
    /*0x0238*/ 0x14, 0x72, 0x10, 0xc0, 0x3a, 0x21, 0xe2, 0xbd,
    /*0x0240*/ 0x76, 0x2c, 0x79, 0xe4, 0xe8, 0x3b, 0x39, 0x86,
    /*0x0248*/ 0x1f, 0x37, 0x0b, 0x80, 0xd4, 0x55, 0x83, 0xaa,
    /*0x0250*/ 0xf2, 0x19, 0x48, 0xd4, 0xc3, 0x45, 0x35, 0xe1,
    /*0x0258*/ 0x2c, 0xda, 0x7f, 0x05, 0x18, 0x25, 0xe9, 0x8d,
    /*0x0260*/ 0xf4, 0xe9,
    /*0x0262*/
};


static const uint8_t der_rsa_pkcs1v15_key_2048[] =
{
    /*0x0000*/ 0x30, 0x82, 0x04, 0xa3, 0x02, 0x01, 0x00, 0x02,
    /*0x0008*/ 0x82, 0x01, 0x01, 0x00, 0xad, 0xbb, 0xaf, 0x2a,
    /*0x0010*/ 0xa1, 0xbf, 0x02, 0x16, 0x07, 0x09, 0xdf, 0x6a,
    /*0x0018*/ 0xe6, 0xd1, 0xa6, 0xc3, 0x7d, 0x93, 0x27, 0x41,
    /*0x0020*/ 0x84, 0xd1, 0x4d, 0x3d, 0x87, 0xf4, 0xd1, 0xba,
    /*0x0028*/ 0xf6, 0xd4, 0xa3, 0x6e, 0xcb, 0xaf, 0x03, 0xe1,
    /*0x0030*/ 0xa8, 0xbd, 0x6c, 0xfb, 0x5d, 0x97, 0x53, 0x2e,
    /*0x0038*/ 0xf0, 0xa9, 0xbb, 0xf5, 0xa7, 0x35, 0xa1, 0x57,
    /*0x0040*/ 0x57, 0xb8, 0xda, 0x08, 0x56, 0xc6, 0x96, 0x28,
    /*0x0048*/ 0x10, 0xfc, 0xa5, 0xb9, 0x12, 0xf5, 0x47, 0x9f,
    /*0x0050*/ 0x28, 0xf4, 0x70, 0xb5, 0xbb, 0xfe, 0x55, 0x79,
    /*0x0058*/ 0xea, 0x52, 0x96, 0xfa, 0xa6, 0xf8, 0x7a, 0x66,
    /*0x0060*/ 0xc8, 0x2a, 0x82, 0x5c, 0x56, 0x63, 0x0a, 0xf1,
    /*0x0068*/ 0xd4, 0xad, 0x28, 0xe3, 0xa0, 0xa6, 0x93, 0xf9,
    /*0x0070*/ 0x6b, 0xe8, 0xf5, 0xa5, 0x10, 0x0b, 0x53, 0x26,
    /*0x0078*/ 0xb0, 0x7e, 0x2f, 0x2c, 0x73, 0xb8, 0x6d, 0x99,
    /*0x0080*/ 0x4d, 0xcc, 0x53, 0x98, 0x30, 0x1c, 0xc8, 0x7a,
    /*0x0088*/ 0x76, 0x2a, 0x8f, 0x4b, 0x42, 0x8b, 0x1d, 0x49,
    /*0x0090*/ 0x9a, 0xac, 0xcd, 0xd8, 0x61, 0x7a, 0xe5, 0xdc,
    /*0x0098*/ 0x02, 0xa8, 0x57, 0x2d, 0xe0, 0x8d, 0x36, 0xe2,
    /*0x00a0*/ 0xd2, 0x0c, 0xc4, 0x61, 0x5d, 0x73, 0xd4, 0x26,
    /*0x00a8*/ 0xf3, 0xa7, 0xb0, 0xcf, 0x09, 0xe1, 0x57, 0xa4,
    /*0x00b0*/ 0x6b, 0x46, 0x03, 0xed, 0x3a, 0x5a, 0x9d, 0xe7,
    /*0x00b8*/ 0xcd, 0x14, 0x92, 0x30, 0x1a, 0x4e, 0x6b, 0x45,
    /*0x00c0*/ 0x68, 0x5f, 0xc4, 0x4b, 0x1e, 0x92, 0x41, 0x68,
    /*0x00c8*/ 0x75, 0x58, 0xe0, 0x8e, 0x07, 0x12, 0x73, 0xc2,
    /*0x00d0*/ 0x5e, 0xb5, 0x08, 0x4e, 0x4b, 0x00, 0xc8, 0xdb,
    /*0x00d8*/ 0x5e, 0x6d, 0xdb, 0xca, 0x23, 0x07, 0x08, 0x6b,
    /*0x00e0*/ 0x99, 0xf6, 0x8d, 0x9c, 0xd4, 0x51, 0x07, 0x91,
    /*0x00e8*/ 0x8b, 0xa1, 0xfe, 0x72, 0xb2, 0x43, 0xf5, 0x6d,
    /*0x00f0*/ 0xec, 0x9e, 0x01, 0x90, 0x1b, 0xc7, 0xce, 0x78,
    /*0x00f8*/ 0x05, 0x7d, 0x00, 0x3f, 0xe4, 0xe2, 0x60, 0x68,
    /*0x0100*/ 0xdd, 0xbf, 0xd2, 0x8a, 0x81, 0x76, 0x9d, 0x0a,
    /*0x0108*/ 0xd4, 0x56, 0xb2, 0xd5, 0x02, 0x03, 0x01, 0x00,
    /*0x0110*/ 0x01, 0x02, 0x82, 0x01, 0x00, 0x74, 0x79, 0xda,
    /*0x0118*/ 0x4c, 0x78, 0xb8, 0x78, 0x8b, 0x90, 0x18, 0x7c,
    /*0x0120*/ 0x63, 0x4d, 0x70, 0xcd, 0x9f, 0x4e, 0xf7, 0x73,
    /*0x0128*/ 0x60, 0x27, 0xcd, 0xb3, 0x3d, 0x47, 0x83, 0x49,
    /*0x0130*/ 0x81, 0x51, 0xae, 0xea, 0x0b, 0x84, 0x1f, 0x48,
    /*0x0138*/ 0x38, 0xe8, 0x4a, 0x67, 0x60, 0x77, 0x34, 0xd7,
    /*0x0140*/ 0x1e, 0x27, 0x57, 0x84, 0x9e, 0x83, 0x86, 0x1f,
    /*0x0148*/ 0x2f, 0x51, 0xae, 0xaa, 0xee, 0xe0, 0x4e, 0xaf,
    /*0x0150*/ 0xa9, 0x19, 0x0a, 0x69, 0x89, 0x15, 0x3e, 0xc0,
    /*0x0158*/ 0xcf, 0xe2, 0x43, 0x4f, 0xb5, 0x67, 0xde, 0x72,
    /*0x0160*/ 0x2c, 0x14, 0x7f, 0x5e, 0x9d, 0x99, 0x88, 0x09,
    /*0x0168*/ 0x78, 0x13, 0x46, 0xfc, 0xb3, 0x2f, 0x6f, 0xa3,
    /*0x0170*/ 0x8c, 0xd2, 0x8b, 0x6d, 0x58, 0x7f, 0x02, 0x6f,
    /*0x0178*/ 0x3e, 0xcf, 0xac, 0x15, 0xd4, 0x9e, 0x57, 0x19,
    /*0x0180*/ 0x5e, 0x5d, 0x01, 0x9c, 0x5a, 0xef, 0x12, 0x7c,
    /*0x0188*/ 0xd8, 0x45, 0x22, 0x72, 0x01, 0x1c, 0x70, 0x8f,
    /*0x0190*/ 0xb0, 0x1a, 0xbd, 0x19, 0xe7, 0xbe, 0x53, 0x3b,
    /*0x0198*/ 0x0f, 0xed, 0xc8, 0x45, 0xbd, 0x56, 0x67, 0x6b,
    /*0x01a0*/ 0xc9, 0x80, 0x69, 0xdb, 0x64, 0xd9, 0x1b, 0x8b,
    /*0x01a8*/ 0x5b, 0x92, 0x80, 0x35, 0xaa, 0xd4, 0x3b, 0x01,
    /*0x01b0*/ 0x33, 0x09, 0x83, 0x54, 0xfb, 0x50, 0x24, 0xed,
    /*0x01b8*/ 0x56, 0x7e, 0xc8, 0x1f, 0x07, 0x12, 0xf3, 0x6d,
    /*0x01c0*/ 0xe9, 0x10, 0xe2, 0x27, 0x19, 0x34, 0x16, 0x65,
    /*0x01c8*/ 0x51, 0xd3, 0xdf, 0x22, 0x3f, 0xca, 0x79, 0xf7,
    /*0x01d0*/ 0xc3, 0x26, 0xc8, 0x0c, 0x27, 0x5a, 0x04, 0xa8,
    /*0x01d8*/ 0xef, 0xbf, 0x89, 0x91, 0xe9, 0x99, 0x34, 0x1f,
    /*0x01e0*/ 0xde, 0x64, 0x68, 0x50, 0x63, 0x36, 0x16, 0x1d,
    /*0x01e8*/ 0x61, 0xcc, 0xf7, 0x86, 0x0b, 0x4c, 0xe1, 0xdf,
    /*0x01f0*/ 0x06, 0x6d, 0xbf, 0x8c, 0x46, 0xca, 0xd2, 0x8b,
    /*0x01f8*/ 0x0f, 0x04, 0x04, 0x2e, 0x0b, 0x5e, 0x0a, 0xfe,
    /*0x0200*/ 0x9c, 0xca, 0x84, 0xfb, 0xd5, 0x9f, 0xd3, 0x34,
    /*0x0208*/ 0x5e, 0xd2, 0xce, 0x70, 0x26, 0x91, 0x5d, 0x74,
    /*0x0210*/ 0x16, 0xc6, 0xdb, 0xf5, 0x59, 0x02, 0x81, 0x81,
    /*0x0218*/ 0x00, 0xd7, 0x5b, 0x56, 0xfa, 0x61, 0x3a, 0x42,
    /*0x0220*/ 0x98, 0x22, 0xe5, 0x41, 0xec, 0x75, 0x6c, 0x2a,
    /*0x0228*/ 0x6e, 0x4d, 0x58, 0xa7, 0x54, 0x76, 0x55, 0xdc,
    /*0x0230*/ 0x6a, 0x2a, 0xb6, 0x2c, 0x9a, 0x7a, 0x67, 0x4c,
    /*0x0238*/ 0x57, 0xbd, 0xaf, 0xf9, 0x06, 0x06, 0x1c, 0x12,
    /*0x0240*/ 0xab, 0x94, 0xf0, 0xa5, 0x4b, 0x5a, 0xfc, 0x4b,
    /*0x0248*/ 0xbd, 0xee, 0x0c, 0xb7, 0xa9, 0x39, 0xd2, 0x65,
    /*0x0250*/ 0x10, 0x66, 0xdc, 0x85, 0x71, 0x48, 0x9f, 0xab,
    /*0x0258*/ 0x21, 0x2b, 0x52, 0x84, 0x8a, 0xaa, 0xf3, 0x96,
    /*0x0260*/ 0x3b, 0xe0, 0xe5, 0x7f, 0x9e, 0x79, 0x87, 0x93,
    /*0x0268*/ 0x5e, 0xc8, 0xd4, 0x88, 0x28, 0x24, 0x98, 0xe2,
    /*0x0270*/ 0x9d, 0x17, 0x2d, 0xc1, 0x67, 0x3d, 0xfc, 0x5f,
    /*0x0278*/ 0x77, 0xb6, 0x97, 0x80, 0x93, 0x5f, 0x0e, 0xfd,
    /*0x0280*/ 0xad, 0xff, 0x5a, 0x49, 0xb3, 0x13, 0x61, 0xac,
    /*0x0288*/ 0x1a, 0xee, 0x0a, 0x19, 0xb6, 0xbf, 0x5f, 0xa9,
    /*0x0290*/ 0x1d, 0x63, 0x0f, 0xbb, 0xbc, 0xad, 0x92, 0xcb,
    /*0x0298*/ 0x1b, 0x02, 0x81, 0x81, 0x00, 0xce, 0x85, 0x5b,
    /*0x02a0*/ 0x33, 0xb5, 0x0f, 0x1a, 0x14, 0xd6, 0x46, 0xab,
    /*0x02a8*/ 0x18, 0xca, 0x2b, 0xd3, 0xba, 0x86, 0xc4, 0xfe,
    /*0x02b0*/ 0x8a, 0xd7, 0x06, 0x87, 0x52, 0xb2, 0x4b, 0x0d,
    /*0x02b8*/ 0x7c, 0xae, 0x12, 0x4a, 0x88, 0xe8, 0xfa, 0xca,
    /*0x02c0*/ 0x7d, 0xee, 0x08, 0xa9, 0xc5, 0x73, 0x6e, 0xa6,
    /*0x02c8*/ 0x89, 0xa5, 0x26, 0x74, 0xeb, 0xc9, 0x3b, 0xcf,
    /*0x02d0*/ 0x0a, 0x18, 0x79, 0xec, 0x3b, 0xfb, 0xc9, 0x70,
    /*0x02d8*/ 0x0d, 0x82, 0x8a, 0x0b, 0x5f, 0xb3, 0x8f, 0x29,
    /*0x02e0*/ 0x77, 0xac, 0x56, 0x38, 0x4a, 0x66, 0x4c, 0x38,
    /*0x02e8*/ 0xb6, 0x11, 0xe0, 0x0b, 0x44, 0xaf, 0x85, 0xdb,
    /*0x02f0*/ 0x42, 0xb5, 0xed, 0x1e, 0x96, 0xfc, 0x8e, 0x9b,
    /*0x02f8*/ 0xc0, 0xd1, 0x5b, 0xc6, 0xf5, 0x88, 0xeb, 0xc1,
    /*0x0300*/ 0x4c, 0x6d, 0xea, 0x14, 0xd1, 0x3f, 0xbb, 0xcf,
    /*0x0308*/ 0x53, 0x38, 0x39, 0x0d, 0x89, 0x60, 0xd5, 0x6e,
    /*0x0310*/ 0x86, 0x5b, 0x08, 0x5d, 0x3a, 0x89, 0x6e, 0xbc,
    /*0x0318*/ 0xbc, 0xcc, 0xfc, 0xe8, 0xcf, 0x02, 0x81, 0x81,
    /*0x0320*/ 0x00, 0xd1, 0x94, 0x77, 0x81, 0xf5, 0x4b, 0x00,
    /*0x0328*/ 0x72, 0x14, 0x4b, 0xae, 0x2b, 0x53, 0x5e, 0xef,
    /*0x0330*/ 0xb0, 0x26, 0x9f, 0xa7, 0x40, 0x60, 0x65, 0x50,
    /*0x0338*/ 0xbb, 0x15, 0x53, 0xf2, 0xf6, 0x67, 0x36, 0xce,
    /*0x0340*/ 0x29, 0xf9, 0x55, 0x1e, 0xf0, 0xc8, 0xd3, 0x5b,
    /*0x0348*/ 0x2c, 0x16, 0x27, 0x57, 0x85, 0x8d, 0x47, 0x48,
    /*0x0350*/ 0xe2, 0xce, 0x9f, 0x1b, 0xc1, 0x99, 0x9e, 0xf2,
    /*0x0358*/ 0x71, 0xd2, 0xd8, 0xbb, 0x18, 0xb3, 0x07, 0x88,
    /*0x0360*/ 0x40, 0x20, 0x6c, 0x0e, 0xc6, 0xf0, 0x75, 0x5b,
    /*0x0368*/ 0xf8, 0x6b, 0xf6, 0x8c, 0x8b, 0x0a, 0x54, 0x71,
    /*0x0370*/ 0x8b, 0xe5, 0xc0, 0x47, 0xbd, 0x61, 0x58, 0x53,
    /*0x0378*/ 0xf9, 0x73, 0x0c, 0x39, 0x52, 0xa3, 0x15, 0x4f,
    /*0x0380*/ 0x47, 0x2e, 0xb0, 0x24, 0x15, 0xc7, 0x85, 0xcc,
    /*0x0388*/ 0x45, 0x1f, 0xe3, 0x9b, 0x23, 0xa6, 0x32, 0x00,
    /*0x0390*/ 0x8e, 0xb8, 0xa7, 0xa5, 0xbc, 0x9e, 0x63, 0x97,
    /*0x0398*/ 0x2e, 0x1d, 0x30, 0xbb, 0x90, 0x74, 0x0f, 0x0e,
    /*0x03a0*/ 0x8f, 0x02, 0x81, 0x80, 0x34, 0x3c, 0xd5, 0x19,
    /*0x03a8*/ 0xda, 0x25, 0x6c, 0xc2, 0x72, 0x84, 0xc3, 0x88,
    /*0x03b0*/ 0x6c, 0xb2, 0xf3, 0x46, 0x4e, 0x0a, 0x8c, 0x1c,
    /*0x03b8*/ 0x10, 0x51, 0xad, 0x6f, 0x04, 0x7c, 0x29, 0x78,
    /*0x03c0*/ 0x2d, 0x0b, 0xa1, 0x60, 0xca, 0x15, 0x8d, 0x9c,
    /*0x03c8*/ 0x96, 0xd6, 0x08, 0x23, 0x52, 0x94, 0x5d, 0x79,
    /*0x03d0*/ 0x99, 0x95, 0x85, 0xa3, 0x92, 0x6e, 0x17, 0x6b,
    /*0x03d8*/ 0x85, 0x4f, 0x69, 0xaa, 0xae, 0x80, 0x80, 0x60,
    /*0x03e0*/ 0x5a, 0x71, 0x92, 0x78, 0xed, 0x91, 0x3b, 0xba,
    /*0x03e8*/ 0xf2, 0x93, 0x88, 0x7f, 0x81, 0x2a, 0xac, 0x79,
    /*0x03f0*/ 0x99, 0x41, 0xe3, 0x77, 0xc7, 0x32, 0x03, 0x88,
    /*0x03f8*/ 0xf7, 0x3d, 0x78, 0x2c, 0x56, 0xcb, 0xb7, 0xa7,
    /*0x0400*/ 0xe9, 0x0c, 0xde, 0xe1, 0x82, 0x75, 0xa7, 0x9a,
    /*0x0408*/ 0x2e, 0x7f, 0x34, 0x2e, 0xcd, 0x81, 0x32, 0xea,
    /*0x0410*/ 0xe8, 0xe0, 0xbd, 0x84, 0xcf, 0x42, 0x8d, 0x47,
    /*0x0418*/ 0x5c, 0xc5, 0x5b, 0xd7, 0x8f, 0xa5, 0xbc, 0x05,
    /*0x0420*/ 0xc1, 0x90, 0x03, 0x4f, 0x02, 0x81, 0x80, 0x30,
    /*0x0428*/ 0x23, 0x54, 0xc7, 0x62, 0xd1, 0x9f, 0x22, 0x20,
    /*0x0430*/ 0x6b, 0x86, 0x24, 0x3b, 0x0a, 0x1d, 0xd4, 0x9f,
    /*0x0438*/ 0x35, 0x79, 0x29, 0xcb, 0x57, 0x92, 0x54, 0x94,
    /*0x0440*/ 0x2e, 0x8d, 0x1c, 0x81, 0xaf, 0x36, 0x3d, 0x3c,
    /*0x0448*/ 0x1c, 0x2d, 0xde, 0x32, 0xcd, 0x34, 0xe9, 0x39,
    /*0x0450*/ 0xaa, 0x47, 0x75, 0x54, 0x96, 0x30, 0xf6, 0x3a,
    /*0x0458*/ 0x26, 0x06, 0x3d, 0x86, 0x5d, 0xaf, 0x83, 0x39,
    /*0x0460*/ 0x0e, 0x14, 0xaa, 0x0c, 0xfc, 0x57, 0xb5, 0x02,
    /*0x0468*/ 0x39, 0x6f, 0xd5, 0xc1, 0xf0, 0xbe, 0xce, 0xb9,
    /*0x0470*/ 0xee, 0xde, 0x66, 0x6b, 0x3d, 0xf2, 0x98, 0x23,
    /*0x0478*/ 0x3d, 0x54, 0xfb, 0xac, 0x62, 0x8f, 0x92, 0x2b,
    /*0x0480*/ 0x9b, 0x51, 0xf5, 0xcc, 0x9c, 0x12, 0x2e, 0xc7,
    /*0x0488*/ 0x41, 0xef, 0xbd, 0x98, 0xc0, 0x5f, 0x63, 0x46,
    /*0x0490*/ 0xb7, 0x53, 0x72, 0x23, 0x4b, 0x81, 0xa0, 0x4b,
    /*0x0498*/ 0x7b, 0xa2, 0x2a, 0x30, 0x41, 0x64, 0x77, 0x7b,
    /*0x04a0*/ 0xad, 0x44, 0x93, 0x4e, 0xf7, 0x36, 0x1a,
    /*0x04a7*/
};

static const uint8_t der_rsa_pkcs1v15_key_3072[] =
{
    /*0x0000*/ 0x30, 0x82, 0x06, 0xe2, 0x02, 0x01, 0x00, 0x02,
    /*0x0008*/ 0x82, 0x01, 0x81, 0x00, 0xae, 0x7b, 0xa4, 0x0e,
    /*0x0010*/ 0x67, 0xb9, 0xa2, 0x27, 0x8c, 0xec, 0x5a, 0xa5,
    /*0x0018*/ 0xd2, 0x9d, 0x64, 0x16, 0xb9, 0xee, 0x34, 0x30,
    /*0x0020*/ 0x20, 0x51, 0xe8, 0x93, 0x2b, 0x47, 0x8a, 0xb2,
    /*0x0028*/ 0x53, 0xcc, 0x14, 0x27, 0x3c, 0x61, 0x08, 0xdb,
    /*0x0030*/ 0xb1, 0xea, 0x2e, 0xee, 0x9c, 0x58, 0x87, 0x6f,
    /*0x0038*/ 0x4c, 0x27, 0xc6, 0x65, 0xfd, 0x66, 0x7f, 0x6e,
    /*0x0040*/ 0x51, 0xd5, 0xf8, 0x16, 0xf8, 0xa7, 0xdf, 0x32,
    /*0x0048*/ 0x7a, 0xaf, 0x2b, 0xc4, 0xd4, 0x2c, 0x62, 0x3e,
    /*0x0050*/ 0x58, 0x0c, 0xf2, 0x55, 0x0f, 0xd0, 0xe3, 0x25,
    /*0x0058*/ 0xba, 0x3e, 0x94, 0xce, 0x12, 0x0f, 0x4c, 0xa8,
    /*0x0060*/ 0x9f, 0xf5, 0x20, 0x89, 0x33, 0xe4, 0x85, 0x5c,
    /*0x0068*/ 0x9f, 0xd0, 0x76, 0xae, 0x30, 0x62, 0x9a, 0x3d,
    /*0x0070*/ 0xf5, 0x2e, 0x13, 0x7a, 0x14, 0x9e, 0xed, 0x2f,
    /*0x0078*/ 0xd0, 0xb1, 0xd6, 0x49, 0x07, 0x8d, 0x0a, 0x1f,
    /*0x0080*/ 0xde, 0x7b, 0x7d, 0x29, 0x9e, 0x73, 0xee, 0x38,
    /*0x0088*/ 0x95, 0x7f, 0x2d, 0xb0, 0x55, 0x99, 0x75, 0xea,
    /*0x0090*/ 0x9a, 0x01, 0x5c, 0x54, 0x96, 0x26, 0x32, 0x1b,
    /*0x0098*/ 0x4c, 0xa1, 0x69, 0x67, 0x2a, 0x59, 0x72, 0x1a,
    /*0x00a0*/ 0x4f, 0xef, 0xc6, 0xde, 0x2f, 0xa0, 0x6e, 0x29,
    /*0x00a8*/ 0xf2, 0xa2, 0x0b, 0xf5, 0xc9, 0xad, 0x93, 0xb6,
    /*0x00b0*/ 0x44, 0xf1, 0x7e, 0x2d, 0xeb, 0x53, 0xab, 0x52,
    /*0x00b8*/ 0x6f, 0x18, 0x3f, 0x02, 0x2d, 0x2b, 0xbd, 0x82,
    /*0x00c0*/ 0xf8, 0x96, 0x26, 0x78, 0x2b, 0xaa, 0x6e, 0x64,
    /*0x00c8*/ 0x98, 0xdd, 0xea, 0xfb, 0xc5, 0xe8, 0xce, 0x65,
    /*0x00d0*/ 0xf5, 0x47, 0x77, 0xe0, 0x04, 0xb0, 0x4d, 0x48,
    /*0x00d8*/ 0x54, 0x30, 0x24, 0xd2, 0xd0, 0x8a, 0xd7, 0x28,
    /*0x00e0*/ 0xa1, 0xc7, 0xc0, 0x6b, 0x81, 0x6f, 0xfd, 0x39,
    /*0x00e8*/ 0x55, 0x30, 0xc5, 0xe0, 0x71, 0xda, 0x87, 0xe7,
    /*0x00f0*/ 0xee, 0xdb, 0xff, 0xe3, 0x32, 0xb1, 0x03, 0x96,
    /*0x00f8*/ 0x28, 0x1d, 0x35, 0x54, 0x37, 0x2d, 0x64, 0x4c,
    /*0x0100*/ 0x6e, 0xfc, 0x35, 0x4a, 0x48, 0x56, 0x83, 0x76,
    /*0x0108*/ 0xe5, 0x04, 0x98, 0x9a, 0xfc, 0x19, 0xc9, 0x68,
    /*0x0110*/ 0x90, 0x87, 0xc3, 0xad, 0x9a, 0x41, 0xb9, 0x42,
    /*0x0118*/ 0x7f, 0x62, 0xc2, 0xd0, 0x10, 0x28, 0x97, 0xc2,
    /*0x0120*/ 0xad, 0xff, 0xda, 0xdc, 0x10, 0xff, 0xb6, 0x54,
    /*0x0128*/ 0x0d, 0x38, 0xf7, 0x28, 0x60, 0x0e, 0xf4, 0xb4,
    /*0x0130*/ 0xd1, 0xb6, 0x88, 0x58, 0x87, 0x71, 0xb9, 0x3a,
    /*0x0138*/ 0xc8, 0x63, 0xf2, 0xfb, 0x3e, 0x01, 0x09, 0xec,
    /*0x0140*/ 0x56, 0xfa, 0x81, 0x71, 0x5a, 0x59, 0x43, 0x65,
    /*0x0148*/ 0x38, 0x34, 0x0e, 0xcd, 0xbc, 0xe3, 0x35, 0x88,
    /*0x0150*/ 0xb2, 0x52, 0x7a, 0x9f, 0x11, 0x08, 0xab, 0xcd,
    /*0x0158*/ 0xe9, 0xbf, 0xbe, 0xea, 0x67, 0x76, 0x38, 0x29,
    /*0x0160*/ 0xaa, 0x39, 0x1c, 0x9f, 0x0b, 0x2c, 0x94, 0x75,
    /*0x0168*/ 0x37, 0xe1, 0xdb, 0x67, 0xdf, 0x60, 0x27, 0x5b,
    /*0x0170*/ 0x3c, 0x04, 0xcf, 0x99, 0x21, 0x22, 0x9a, 0x4f,
    /*0x0178*/ 0x3a, 0x35, 0xd3, 0x5d, 0x1f, 0x61, 0x0a, 0x24,
    /*0x0180*/ 0xa5, 0x8d, 0x08, 0x17, 0x95, 0x4c, 0xda, 0x4f,
    /*0x0188*/ 0x58, 0x33, 0x09, 0x53, 0x02, 0x03, 0x01, 0x00,
    /*0x0190*/ 0x01, 0x02, 0x82, 0x01, 0x80, 0x04, 0x88, 0xb3,
    /*0x0198*/ 0xf7, 0xa7, 0xdc, 0x5c, 0x09, 0x59, 0x11, 0x1f,
    /*0x01a0*/ 0x3d, 0xe5, 0xde, 0x2f, 0x26, 0xa4, 0x08, 0x3b,
    /*0x01a8*/ 0x94, 0xf0, 0x92, 0x10, 0x50, 0x1a, 0xb4, 0xce,
    /*0x01b0*/ 0x36, 0xda, 0x14, 0x98, 0x85, 0x78, 0x7d, 0x31,
    /*0x01b8*/ 0x04, 0xbc, 0x77, 0xd0, 0x66, 0x64, 0xeb, 0xac,
    /*0x01c0*/ 0x01, 0x49, 0x62, 0x53, 0x36, 0x7d, 0x42, 0x37,
    /*0x01c8*/ 0x97, 0x7f, 0x4a, 0xe7, 0x1a, 0x79, 0xb5, 0xab,
    /*0x01d0*/ 0x08, 0x1d, 0xc6, 0x05, 0x86, 0x24, 0xd9, 0x4e,
    /*0x01d8*/ 0x68, 0x3e, 0x53, 0x7f, 0xcc, 0x94, 0x0f, 0xa2,
    /*0x01e0*/ 0x87, 0x6d, 0x72, 0x88, 0xdd, 0x5d, 0xfc, 0xc5,
    /*0x01e8*/ 0xca, 0x2f, 0xf5, 0xe7, 0xb5, 0x89, 0x02, 0xac,
    /*0x01f0*/ 0x30, 0x7e, 0xfa, 0xa4, 0xca, 0xdb, 0xf9, 0x03,
    /*0x01f8*/ 0xf7, 0x0e, 0x32, 0xf7, 0x50, 0x99, 0xce, 0x93,
    /*0x0200*/ 0x6d, 0x45, 0xa8, 0x09, 0x60, 0x76, 0x70, 0xc4,
    /*0x0208*/ 0xcd, 0x95, 0x33, 0x72, 0x4a, 0x2d, 0x92, 0xe7,
    /*0x0210*/ 0xa2, 0xd2, 0xc7, 0xae, 0x41, 0x41, 0xc8, 0x2e,
    /*0x0218*/ 0x17, 0x3d, 0x8f, 0x41, 0x7d, 0xf5, 0x34, 0xe2,
    /*0x0220*/ 0xe2, 0x70, 0xb8, 0x55, 0x0b, 0xd8, 0x3e, 0xe0,
    /*0x0228*/ 0xc7, 0x2c, 0x42, 0x97, 0xd1, 0x58, 0x3d, 0x7b,
    /*0x0230*/ 0xff, 0x5d, 0x0d, 0xb6, 0xef, 0xd9, 0x20, 0xc8,
    /*0x0238*/ 0x90, 0xd8, 0xf3, 0xc9, 0x8a, 0x99, 0xed, 0xdf,
    /*0x0240*/ 0xaa, 0xd1, 0xb6, 0x38, 0x94, 0xee, 0xe5, 0x8f,
    /*0x0248*/ 0x14, 0x23, 0x2f, 0x8b, 0xaa, 0x5d, 0xc0, 0x1d,
    /*0x0250*/ 0x04, 0x42, 0x30, 0xaa, 0x15, 0x7b, 0xc5, 0x9b,
    /*0x0258*/ 0xbd, 0x67, 0xa0, 0x30, 0x83, 0xc6, 0x81, 0xf1,
    /*0x0260*/ 0x68, 0x62, 0x1a, 0x03, 0x22, 0x1b, 0x1b, 0x98,
    /*0x0268*/ 0x14, 0xab, 0x24, 0x0b, 0x99, 0x52, 0x2a, 0x15,
    /*0x0270*/ 0x32, 0x13, 0x88, 0x23, 0x90, 0x32, 0xb3, 0xf0,
    /*0x0278*/ 0x17, 0xbb, 0x17, 0x5f, 0xf8, 0x59, 0x82, 0x60,
    /*0x0280*/ 0x1d, 0xa2, 0xc5, 0xe2, 0x60, 0xf7, 0xe0, 0x4a,
    /*0x0288*/ 0xc7, 0x98, 0x18, 0x7d, 0x11, 0xe2, 0xe0, 0xf5,
    /*0x0290*/ 0x97, 0xed, 0xc1, 0xf2, 0x59, 0x25, 0xe8, 0xa3,
    /*0x0298*/ 0xac, 0x8b, 0xfe, 0x35, 0x30, 0x3c, 0xc9, 0x49,
    /*0x02a0*/ 0x99, 0xe9, 0xf1, 0x39, 0x68, 0x50, 0x1b, 0x22,
    /*0x02a8*/ 0x18, 0x03, 0x50, 0xef, 0x3b, 0x52, 0x7a, 0x5c,
    /*0x02b0*/ 0x16, 0xd7, 0x4c, 0x5b, 0xdf, 0x87, 0x74, 0xc6,
    /*0x02b8*/ 0x01, 0xdc, 0xe7, 0xef, 0xef, 0x85, 0x39, 0xc2,
    /*0x02c0*/ 0x60, 0x13, 0x33, 0x14, 0x48, 0x25, 0xe7, 0xbe,
    /*0x02c8*/ 0x6a, 0xc8, 0x6f, 0x42, 0x0e, 0x2b, 0xaa, 0xa2,
    /*0x02d0*/ 0xd8, 0x84, 0x15, 0x9b, 0x26, 0x6e, 0x7b, 0x18,
    /*0x02d8*/ 0x8c, 0xf0, 0x83, 0x51, 0x1a, 0x88, 0x97, 0x85,
    /*0x02e0*/ 0xb3, 0x76, 0x90, 0xda, 0x0f, 0x55, 0x2b, 0x2f,
    /*0x02e8*/ 0x90, 0x38, 0x3f, 0x36, 0x0e, 0x2a, 0x85, 0x8f,
    /*0x02f0*/ 0x56, 0x9e, 0xbe, 0xfc, 0x92, 0xe7, 0xe4, 0x9c,
    /*0x02f8*/ 0x0d, 0xb8, 0x0a, 0x0e, 0xd0, 0x4f, 0x49, 0x88,
    /*0x0300*/ 0x32, 0xed, 0x07, 0x53, 0xf1, 0x4a, 0x44, 0x33,
    /*0x0308*/ 0x34, 0xbb, 0x52, 0x45, 0x00, 0xed, 0x4d, 0x8f,
    /*0x0310*/ 0xee, 0xc7, 0xf4, 0xdb, 0x69, 0x02, 0x81, 0xc1,
    /*0x0318*/ 0x00, 0xe6, 0x79, 0xbe, 0x78, 0xd0, 0xf2, 0x2a,
    /*0x0320*/ 0xd1, 0x6c, 0xa8, 0x63, 0x80, 0x7e, 0xda, 0x57,
    /*0x0328*/ 0xab, 0xbc, 0x25, 0xf7, 0x49, 0x5b, 0xaa, 0x25,
    /*0x0330*/ 0xa3, 0x47, 0x0a, 0x88, 0x44, 0xa0, 0xda, 0xf7,
    /*0x0338*/ 0x3f, 0xc5, 0xa3, 0x38, 0x3d, 0xe4, 0x6f, 0x05,
    /*0x0340*/ 0x0f, 0x4c, 0x8d, 0x9d, 0x7b, 0xca, 0x05, 0x3f,
    /*0x0348*/ 0x6d, 0x35, 0xce, 0x55, 0x7b, 0x40, 0x03, 0xda,
    /*0x0350*/ 0x13, 0x48, 0x49, 0x3c, 0x5f, 0xc2, 0xc7, 0x12,
    /*0x0358*/ 0x1f, 0x20, 0xe4, 0x80, 0xbf, 0x71, 0x7e, 0x58,
    /*0x0360*/ 0x81, 0x21, 0x50, 0xf0, 0xae, 0x06, 0x94, 0xfb,
    /*0x0368*/ 0x09, 0x7d, 0xbf, 0x98, 0x29, 0x97, 0xa7, 0xb1,
    /*0x0370*/ 0xef, 0xcf, 0x2e, 0xad, 0xd7, 0x66, 0x32, 0x99,
    /*0x0378*/ 0x9f, 0x0c, 0x4f, 0x90, 0x16, 0x95, 0xed, 0x91,
    /*0x0380*/ 0xf0, 0x63, 0x75, 0x04, 0xe7, 0xb4, 0x57, 0x0b,
    /*0x0388*/ 0xaa, 0x43, 0x05, 0xfc, 0x48, 0x43, 0xd0, 0xdd,
    /*0x0390*/ 0x19, 0x70, 0x26, 0x67, 0x43, 0x1a, 0x20, 0x8a,
    /*0x0398*/ 0x20, 0x4b, 0x7a, 0xd5, 0xb7, 0xca, 0xc4, 0xe2,
    /*0x03a0*/ 0x66, 0x9c, 0x9c, 0xd4, 0x0a, 0x77, 0x87, 0xd1,
    /*0x03a8*/ 0x49, 0x92, 0x80, 0xbc, 0x14, 0xa8, 0x8b, 0x6a,
    /*0x03b0*/ 0x0e, 0xe4, 0x36, 0xd8, 0x04, 0xa9, 0x9f, 0x18,
    /*0x03b8*/ 0xb2, 0x2f, 0x83, 0x35, 0x5b, 0x85, 0x2c, 0x58,
    /*0x03c0*/ 0x8c, 0xb6, 0x8d, 0x40, 0xc0, 0x23, 0x33, 0xfe,
    /*0x03c8*/ 0x34, 0x4f, 0xf7, 0x95, 0x56, 0x57, 0x5f, 0x4a,
    /*0x03d0*/ 0xf9, 0x0d, 0xa3, 0x2c, 0xac, 0x8e, 0x09, 0x6f,
    /*0x03d8*/ 0xb7, 0x02, 0x81, 0xc1, 0x00, 0xc1, 0xce, 0x70,
    /*0x03e0*/ 0xbb, 0x7a, 0xfa, 0xef, 0x8f, 0xb7, 0xca, 0x98,
    /*0x03e8*/ 0x1b, 0x2f, 0x9e, 0xac, 0x36, 0xd3, 0xcc, 0xde,
    /*0x03f0*/ 0xa1, 0x4e, 0xba, 0x21, 0x44, 0x21, 0x3b, 0x4f,
    /*0x03f8*/ 0xf3, 0xd7, 0xed, 0xeb, 0x70, 0x61, 0x08, 0xbd,
    /*0x0400*/ 0xe6, 0x97, 0xdd, 0x1c, 0x8a, 0x9e, 0xa0, 0x39,
    /*0x0408*/ 0x27, 0x9c, 0xd9, 0xb4, 0x3b, 0xbf, 0xca, 0x97,
    /*0x0410*/ 0x2d, 0x59, 0xa6, 0x41, 0x4d, 0x8e, 0x6e, 0x50,
    /*0x0418*/ 0xba, 0x54, 0xea, 0xfb, 0x6b, 0xbb, 0xac, 0x1a,
    /*0x0420*/ 0x08, 0x53, 0x62, 0xd5, 0x62, 0x97, 0xad, 0x87,
    /*0x0428*/ 0xe9, 0x2c, 0x1e, 0x4d, 0x08, 0x09, 0x19, 0x25,
    /*0x0430*/ 0x9b, 0x94, 0xc6, 0x1d, 0x28, 0xbb, 0x06, 0x50,
    /*0x0438*/ 0x02, 0xae, 0xa9, 0x4a, 0x29, 0x5f, 0x20, 0x6e,
    /*0x0440*/ 0x98, 0x15, 0x55, 0x16, 0x5b, 0x56, 0xc1, 0x16,
    /*0x0448*/ 0x0f, 0x32, 0x3d, 0xfc, 0xa0, 0xc6, 0x15, 0x4f,
    /*0x0450*/ 0xb4, 0x2e, 0x83, 0xe9, 0x93, 0xef, 0x7d, 0x31,
    /*0x0458*/ 0x57, 0xf1, 0x8f, 0xf3, 0x4f, 0x3e, 0xf8, 0x61,
    /*0x0460*/ 0x03, 0x67, 0x4a, 0x01, 0xc5, 0x0d, 0x71, 0x0f,
    /*0x0468*/ 0x62, 0x99, 0x1a, 0xd2, 0x64, 0x5e, 0x20, 0x37,
    /*0x0470*/ 0x79, 0x4c, 0xec, 0xf0, 0x23, 0x88, 0x42, 0x92,
    /*0x0478*/ 0x78, 0xf6, 0x0a, 0xf1, 0x53, 0x74, 0xb5, 0x6b,
    /*0x0480*/ 0x1c, 0x1c, 0x7f, 0x58, 0x7a, 0x49, 0x89, 0x40,
    /*0x0488*/ 0x3c, 0x60, 0xc7, 0x0f, 0x8a, 0xca, 0x13, 0xb3,
    /*0x0490*/ 0x80, 0x35, 0x60, 0x0c, 0x4f, 0x56, 0xbb, 0xfb,
    /*0x0498*/ 0x73, 0x9a, 0xdd, 0x7b, 0x45, 0x02, 0x81, 0xc0,
    /*0x04a0*/ 0x2c, 0xb7, 0xfa, 0x89, 0x1e, 0xa1, 0x9e, 0x45,
    /*0x04a8*/ 0x3c, 0x3b, 0xff, 0xf2, 0x72, 0xaa, 0x92, 0xd0,
    /*0x04b0*/ 0x33, 0x95, 0x7a, 0x41, 0xb5, 0x93, 0x71, 0xf2,
    /*0x04b8*/ 0x18, 0x5a, 0xa6, 0xce, 0x0a, 0x17, 0xf2, 0x59,
    /*0x04c0*/ 0x61, 0x53, 0xa6, 0x19, 0xfc, 0x34, 0xbe, 0x5a,
    /*0x04c8*/ 0x95, 0x93, 0xf4, 0xb6, 0x8c, 0x20, 0x30, 0x8a,
    /*0x04d0*/ 0x54, 0x22, 0x50, 0xdb, 0xb5, 0x34, 0x0a, 0x20,
    /*0x04d8*/ 0x2b, 0xaa, 0x6a, 0x18, 0x7a, 0x86, 0x7d, 0xb1,
    /*0x04e0*/ 0xa4, 0x84, 0x31, 0xa6, 0xf3, 0xb2, 0x7c, 0x21,
    /*0x04e8*/ 0xb2, 0x01, 0x2e, 0x71, 0xd5, 0xbd, 0x1a, 0x68,
    /*0x04f0*/ 0x61, 0x09, 0xc7, 0xd0, 0x6a, 0x28, 0x93, 0x91,
    /*0x04f8*/ 0xe0, 0x35, 0x42, 0x6d, 0xc4, 0xda, 0x94, 0x8c,
    /*0x0500*/ 0x13, 0xab, 0x6c, 0x5d, 0xb5, 0x81, 0x7f, 0x0b,
    /*0x0508*/ 0x91, 0x80, 0xa7, 0x0e, 0xfe, 0x22, 0xd5, 0x94,
    /*0x0510*/ 0x97, 0xa4, 0x95, 0xaa, 0xbf, 0xdd, 0xca, 0xc8,
    /*0x0518*/ 0xa0, 0xc6, 0x12, 0xcb, 0x26, 0x4a, 0xa2, 0x02,
    /*0x0520*/ 0x5a, 0x22, 0xdf, 0x4c, 0xe5, 0xff, 0x05, 0x9e,
    /*0x0528*/ 0xbb, 0x4c, 0x82, 0xa7, 0xf5, 0x41, 0x59, 0x0e,
    /*0x0530*/ 0x59, 0x6a, 0xb9, 0x13, 0x99, 0x10, 0x53, 0xe7,
    /*0x0538*/ 0xc7, 0xc8, 0x0c, 0x69, 0xfb, 0x2f, 0x6f, 0x6f,
    /*0x0540*/ 0x43, 0x60, 0xc5, 0xfd, 0x97, 0xfd, 0x5e, 0xc1,
    /*0x0548*/ 0x0e, 0xba, 0xa1, 0x91, 0xa6, 0x42, 0xf4, 0x53,
    /*0x0550*/ 0xda, 0x20, 0x43, 0xcd, 0x98, 0xee, 0x58, 0x71,
    /*0x0558*/ 0xb2, 0x7f, 0xb2, 0xaf, 0x58, 0x6f, 0xe4, 0x49,
    /*0x0560*/ 0x02, 0x81, 0xc0, 0x0f, 0xf5, 0x03, 0x6b, 0x2c,
    /*0x0568*/ 0x51, 0x04, 0xf0, 0x7c, 0x5d, 0x7d, 0xf0, 0x9f,
    /*0x0570*/ 0x17, 0x1d, 0x6e, 0xd6, 0x39, 0x84, 0x0b, 0x1c,
    /*0x0578*/ 0x04, 0x4f, 0x40, 0xe0, 0xcb, 0x95, 0x65, 0xaa,
    /*0x0580*/ 0x5d, 0xb8, 0x88, 0xe4, 0x34, 0x68, 0x0e, 0x58,
    /*0x0588*/ 0x6a, 0xa8, 0x32, 0xf1, 0xa4, 0x97, 0x90, 0x1f,
    /*0x0590*/ 0x65, 0xfd, 0x64, 0xfe, 0x01, 0x9c, 0x38, 0xeb,
    /*0x0598*/ 0xac, 0xb8, 0xab, 0xbe, 0x12, 0x6f, 0x2b, 0x28,
    /*0x05a0*/ 0x5a, 0xc0, 0xa0, 0xba, 0x2f, 0x0d, 0x65, 0xaa,
    /*0x05a8*/ 0x17, 0xf5, 0x21, 0xcd, 0x03, 0x48, 0xb1, 0x76,
    /*0x05b0*/ 0x24, 0x78, 0x8b, 0x34, 0xd4, 0x91, 0x38, 0x22,
    /*0x05b8*/ 0x23, 0xbd, 0xba, 0xe0, 0xcb, 0x40, 0x43, 0x38,
    /*0x05c0*/ 0x46, 0x50, 0x08, 0xe0, 0x00, 0x37, 0x9a, 0xe6,
    /*0x05c8*/ 0x06, 0xbf, 0x74, 0x7d, 0xcc, 0x20, 0x18, 0xd8,
    /*0x05d0*/ 0x36, 0x2a, 0x5a, 0xc2, 0x74, 0x76, 0xbf, 0x8b,
    /*0x05d8*/ 0x24, 0xe9, 0x52, 0x78, 0xe1, 0x81, 0xf2, 0x8f,
    /*0x05e0*/ 0xbd, 0x1e, 0x77, 0x63, 0xe3, 0xe7, 0x78, 0xf4,
    /*0x05e8*/ 0x44, 0x2f, 0xa9, 0x1d, 0xd6, 0x35, 0x42, 0x15,
    /*0x05f0*/ 0x01, 0x14, 0x59, 0x97, 0x36, 0x67, 0xda, 0xe0,
    /*0x05f8*/ 0xee, 0x91, 0x47, 0x1b, 0xac, 0xff, 0x8a, 0x5e,
    /*0x0600*/ 0x17, 0xc0, 0x8e, 0xf2, 0x89, 0x0d, 0x6c, 0x9f,
    /*0x0608*/ 0x1c, 0x0d, 0x18, 0xe4, 0x7d, 0x1c, 0x80, 0xdc,
    /*0x0610*/ 0x27, 0x07, 0xac, 0x91, 0xbe, 0xd5, 0x84, 0xb4,
    /*0x0618*/ 0xe0, 0x57, 0xa3, 0x20, 0xad, 0x11, 0xa3, 0x0f,
    /*0x0620*/ 0x19, 0x35, 0x51, 0x02, 0x81, 0xc0, 0x5b, 0x9e,
    /*0x0628*/ 0x1d, 0x08, 0x5f, 0x2c, 0xc0, 0x2d, 0x64, 0x05,
    /*0x0630*/ 0x4f, 0xc7, 0x1a, 0x00, 0x8f, 0x54, 0x78, 0xce,
    /*0x0638*/ 0x3c, 0x66, 0x5f, 0x85, 0x7a, 0x4c, 0x58, 0x09,
    /*0x0640*/ 0xf7, 0x2b, 0x78, 0xda, 0xc4, 0x24, 0x71, 0xc1,
    /*0x0648*/ 0xb8, 0xb2, 0x5f, 0x91, 0x91, 0x3b, 0x74, 0xd2,
    /*0x0650*/ 0xe9, 0xd1, 0x71, 0x07, 0x7e, 0xec, 0x6a, 0x1b,
    /*0x0658*/ 0x5d, 0x8e, 0x88, 0x31, 0x6d, 0x39, 0xf3, 0x33,
    /*0x0660*/ 0x63, 0x2c, 0x88, 0x44, 0xea, 0xd8, 0x8b, 0xdf,
    /*0x0668*/ 0xf1, 0xb9, 0x62, 0xb3, 0xed, 0xa6, 0x58, 0xd8,
    /*0x0670*/ 0x2f, 0x8f, 0x42, 0xce, 0xb1, 0x37, 0x06, 0x35,
    /*0x0678*/ 0xf2, 0x5f, 0xba, 0xb8, 0x8a, 0x1b, 0xf2, 0x66,
    /*0x0680*/ 0xd3, 0x58, 0x1c, 0x87, 0x66, 0x85, 0x1c, 0x17,
    /*0x0688*/ 0x7a, 0xf1, 0x6c, 0x2e, 0xc5, 0x94, 0x8d, 0x4a,
    /*0x0690*/ 0x6c, 0x54, 0x62, 0x56, 0xc1, 0x6f, 0x23, 0x60,
    /*0x0698*/ 0xea, 0x5b, 0x59, 0xde, 0x3f, 0x25, 0x44, 0x5b,
    /*0x06a0*/ 0x10, 0xb2, 0x0f, 0x6a, 0xb1, 0x6d, 0x84, 0x96,
    /*0x06a8*/ 0x9c, 0x2d, 0x21, 0xe5, 0x0a, 0xcf, 0x99, 0x66,
    /*0x06b0*/ 0xd3, 0x6e, 0x19, 0xc2, 0x25, 0xd9, 0x70, 0x16,
    /*0x06b8*/ 0xd4, 0x7b, 0xe9, 0xad, 0x05, 0x94, 0xa8, 0x4f,
    /*0x06c0*/ 0x05, 0x13, 0x76, 0xbe, 0xc6, 0x86, 0x78, 0x6f,
    /*0x06c8*/ 0x33, 0xbf, 0x53, 0x8d, 0x2f, 0x0f, 0x5c, 0x97,
    /*0x06d0*/ 0xa9, 0x79, 0xd6, 0xe1, 0x8f, 0xb8, 0x72, 0x03,
    /*0x06d8*/ 0x77, 0x81, 0xe7, 0xa3, 0xeb, 0x2f, 0xa8, 0x97,
    /*0x06e0*/ 0x16, 0x7a, 0xda, 0xd0, 0xee, 0xf0,
    /*0x06e6*/
};


/* Signatures for the various hashes */
static const uint8_t signature_rsa_pkcs1v15_abc_1024_sha1[] =
{
    /*0x0000*/ 0x9a, 0x3c, 0x65, 0x42, 0x32, 0x50, 0xc2, 0x89,
    /*0x0008*/ 0x3d, 0x26, 0xb6, 0x82, 0x3b, 0xf0, 0x6b, 0x0a,
    /*0x0010*/ 0x86, 0x0f, 0x5f, 0x8a, 0x60, 0xcb, 0x2e, 0xa9,
    /*0x0018*/ 0x54, 0x74, 0x50, 0xf1, 0xcc, 0x1a, 0x4d, 0xd4,
    /*0x0020*/ 0x71, 0xf8, 0xef, 0x21, 0x8f, 0xce, 0xa0, 0x39,
    /*0x0028*/ 0xc8, 0xeb, 0x05, 0x2e, 0xc1, 0xc6, 0x2d, 0xb6,
    /*0x0030*/ 0x4b, 0x04, 0xcf, 0xbe, 0xf5, 0xef, 0xe1, 0x73,
    /*0x0038*/ 0x19, 0x2c, 0x56, 0x06, 0x69, 0xec, 0xdf, 0x35,
    /*0x0040*/ 0x3f, 0x3c, 0xac, 0x3f, 0x35, 0xc9, 0xb8, 0x42,
    /*0x0048*/ 0xd3, 0x9e, 0x68, 0xed, 0xdb, 0x08, 0xe5, 0x1c,
    /*0x0050*/ 0x4e, 0xd6, 0x8a, 0x18, 0x86, 0x57, 0x66, 0x4f,
    /*0x0058*/ 0x3c, 0xe1, 0x51, 0x24, 0x82, 0xd6, 0xc4, 0xc1,
    /*0x0060*/ 0x9e, 0xed, 0xe9, 0x74, 0xa6, 0x91, 0x04, 0x31,
    /*0x0068*/ 0x22, 0x4d, 0x79, 0x53, 0x03, 0x5a, 0xac, 0x8c,
    /*0x0070*/ 0x44, 0xc2, 0x2e, 0x88, 0x60, 0x28, 0xa9, 0xa8,
    /*0x0078*/ 0x02, 0x58, 0x75, 0x63, 0x8c, 0xf2, 0x92, 0x1c,
    /*0x0080*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_2048_sha1[] =
{
    /*0x0000*/ 0x41, 0xf2, 0xab, 0x00, 0x91, 0x49, 0x26, 0xa5,
    /*0x0008*/ 0x60, 0x59, 0x38, 0x14, 0x24, 0xbc, 0xaa, 0x4f,
    /*0x0010*/ 0x47, 0x8e, 0x8e, 0xe4, 0x09, 0x1f, 0xe1, 0xf1,
    /*0x0018*/ 0x20, 0xd9, 0x3e, 0x00, 0x54, 0x42, 0xd3, 0x59,
    /*0x0020*/ 0x4a, 0x48, 0x03, 0xe2, 0x72, 0x07, 0x77, 0xa6,
    /*0x0028*/ 0xa7, 0x5b, 0xe8, 0x29, 0xca, 0x2f, 0xc0, 0xf6,
    /*0x0030*/ 0xa6, 0x48, 0x9b, 0xb5, 0xb1, 0xdd, 0xd8, 0xaf,
    /*0x0038*/ 0x55, 0x8d, 0x4b, 0xaa, 0x32, 0xf5, 0x93, 0x04,
    /*0x0040*/ 0x4d, 0x92, 0xb4, 0xa0, 0x66, 0x0b, 0x81, 0x7d,
    /*0x0048*/ 0x12, 0x32, 0x58, 0x1c, 0xbe, 0xbf, 0xa1, 0x8c,
    /*0x0050*/ 0xf8, 0x12, 0x6d, 0x4e, 0x21, 0x17, 0x70, 0xfd,
    /*0x0058*/ 0x67, 0xb4, 0x28, 0x54, 0x83, 0xbb, 0xb9, 0x00,
    /*0x0060*/ 0xab, 0x69, 0x27, 0xec, 0x70, 0xc1, 0x21, 0xbe,
    /*0x0068*/ 0x0f, 0xca, 0x13, 0x08, 0x03, 0x60, 0x04, 0x28,
    /*0x0070*/ 0xf3, 0x74, 0xcc, 0x92, 0x29, 0x2a, 0x53, 0x67,
    /*0x0078*/ 0xf7, 0x42, 0x50, 0x91, 0xf9, 0x09, 0xef, 0x3e,
    /*0x0080*/ 0x26, 0xd1, 0x47, 0x25, 0x41, 0xf5, 0x33, 0xa4,
    /*0x0088*/ 0x3d, 0xee, 0x0c, 0xb3, 0xdd, 0x6d, 0xc1, 0x5d,
    /*0x0090*/ 0xd0, 0x02, 0x06, 0x59, 0xf2, 0x31, 0x44, 0xf3,
    /*0x0098*/ 0xf3, 0xf2, 0x79, 0x01, 0xc6, 0xbd, 0x05, 0xa8,
    /*0x00a0*/ 0x86, 0x1a, 0x78, 0x99, 0xe4, 0xea, 0x22, 0x61,
    /*0x00a8*/ 0x26, 0xe3, 0x18, 0xb5, 0x9d, 0x91, 0x19, 0x4c,
    /*0x00b0*/ 0x9a, 0x93, 0xcd, 0x26, 0x81, 0xbb, 0x59, 0xc2,
    /*0x00b8*/ 0xfc, 0x25, 0x12, 0xfe, 0x0d, 0x27, 0xe7, 0x88,
    /*0x00c0*/ 0xca, 0x7a, 0xbb, 0x77, 0xc6, 0xaf, 0x5b, 0x5c,
    /*0x00c8*/ 0xc8, 0xec, 0x42, 0xaa, 0x6c, 0xd5, 0x1b, 0xe7,
    /*0x00d0*/ 0xc7, 0x83, 0xd0, 0x4e, 0x8f, 0xcf, 0x72, 0xdb,
    /*0x00d8*/ 0x59, 0x38, 0x0e, 0x73, 0xcf, 0x00, 0xcb, 0x82,
    /*0x00e0*/ 0x12, 0x60, 0xfa, 0x8b, 0x02, 0xee, 0x41, 0x84,
    /*0x00e8*/ 0xcb, 0x83, 0x79, 0xc8, 0xb6, 0x44, 0x83, 0xe3,
    /*0x00f0*/ 0x51, 0x3a, 0x16, 0xd5, 0x28, 0x2d, 0x25, 0x90,
    /*0x00f8*/ 0x2b, 0x6a, 0x12, 0x26, 0x96, 0x5d, 0x2b, 0x72,
    /*0x0100*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_3072_sha1[] =
{
    /*0x0000*/ 0xac, 0xe2, 0x2e, 0x21, 0x06, 0x29, 0x45, 0xde,
    /*0x0008*/ 0x41, 0xd5, 0x99, 0x3f, 0x58, 0xc8, 0xb1, 0xc5,
    /*0x0010*/ 0xdd, 0xe6, 0x1a, 0x2b, 0x7b, 0x4d, 0xcd, 0x07,
    /*0x0018*/ 0x5a, 0xf8, 0xfa, 0x85, 0x83, 0xdf, 0xd0, 0xf4,
    /*0x0020*/ 0x72, 0x91, 0x19, 0xc2, 0x1b, 0x97, 0x25, 0x0e,
    /*0x0028*/ 0x28, 0x52, 0xb6, 0x3b, 0xed, 0x0c, 0x0c, 0x35,
    /*0x0030*/ 0xe9, 0x5f, 0xd4, 0x36, 0x22, 0xca, 0x71, 0x1c,
    /*0x0038*/ 0x3f, 0xb2, 0x00, 0xa8, 0xb6, 0x0b, 0x14, 0x91,
    /*0x0040*/ 0x50, 0xba, 0x62, 0x31, 0x0d, 0xcf, 0x4b, 0xf8,
    /*0x0048*/ 0xdf, 0x56, 0xa5, 0x2c, 0xa7, 0x89, 0x31, 0x20,
    /*0x0050*/ 0xa3, 0x97, 0x68, 0xd9, 0xaa, 0x5b, 0xf3, 0xb0,
    /*0x0058*/ 0xec, 0x19, 0x63, 0x33, 0xfd, 0x32, 0xa9, 0xc6,
    /*0x0060*/ 0x21, 0x86, 0x2f, 0x20, 0xc1, 0x11, 0x71, 0xcd,
    /*0x0068*/ 0x0b, 0x0f, 0xcb, 0x8a, 0x9f, 0x6c, 0xc2, 0xe1,
    /*0x0070*/ 0x9d, 0x9f, 0x8a, 0xe7, 0x1e, 0x37, 0x1a, 0xa2,
    /*0x0078*/ 0x1f, 0x9a, 0xde, 0x46, 0x7f, 0xd0, 0x16, 0xfe,
    /*0x0080*/ 0x58, 0xb2, 0x58, 0x82, 0xd9, 0x04, 0x87, 0xfd,
    /*0x0088*/ 0x72, 0x68, 0x8d, 0x34, 0x44, 0xb9, 0xff, 0x46,
    /*0x0090*/ 0x48, 0x0a, 0xda, 0x70, 0x85, 0x7e, 0x61, 0xec,
    /*0x0098*/ 0xd3, 0x09, 0x28, 0xe8, 0xad, 0xc6, 0xd6, 0x28,
    /*0x00a0*/ 0xd5, 0xa4, 0x19, 0xfa, 0x01, 0x0b, 0x7d, 0xe7,
    /*0x00a8*/ 0x5c, 0x88, 0x8b, 0x31, 0xfa, 0x26, 0x9c, 0x0e,
    /*0x00b0*/ 0x2f, 0x55, 0x47, 0xce, 0x5f, 0x34, 0x39, 0x78,
    /*0x00b8*/ 0xc1, 0xf4, 0x7d, 0x68, 0x97, 0x4a, 0x02, 0xbd,
    /*0x00c0*/ 0x98, 0xb8, 0xdb, 0x66, 0xa6, 0x66, 0x10, 0x6e,
    /*0x00c8*/ 0x46, 0xb0, 0x9e, 0x0f, 0xec, 0xa7, 0x9c, 0x0d,
    /*0x00d0*/ 0x25, 0x56, 0x50, 0x79, 0x7a, 0xbb, 0x3a, 0xd5,
    /*0x00d8*/ 0xa4, 0x8a, 0x18, 0xb7, 0x89, 0xb6, 0xa8, 0x47,
    /*0x00e0*/ 0xf7, 0x40, 0x0a, 0x28, 0x5e, 0xa3, 0x95, 0x1f,
    /*0x00e8*/ 0xf7, 0x5b, 0xc2, 0x45, 0x81, 0x39, 0x21, 0xb0,
    /*0x00f0*/ 0x49, 0xfe, 0xea, 0x36, 0x06, 0x8d, 0xa7, 0x5c,
    /*0x00f8*/ 0xdb, 0xd2, 0xcd, 0x1c, 0xbd, 0x47, 0xd3, 0xef,
    /*0x0100*/ 0xb3, 0x22, 0xb6, 0xf6, 0x79, 0x82, 0xb4, 0xa5,
    /*0x0108*/ 0xf1, 0x35, 0x6a, 0xb5, 0x09, 0x92, 0xaa, 0x5f,
    /*0x0110*/ 0xd2, 0xfb, 0x35, 0x9a, 0x8c, 0x14, 0x9d, 0x95,
    /*0x0118*/ 0x7a, 0x9d, 0xd0, 0x84, 0xc5, 0x8b, 0x41, 0x49,
    /*0x0120*/ 0x61, 0x1f, 0x27, 0x80, 0xd1, 0xad, 0x44, 0xb9,
    /*0x0128*/ 0xa7, 0x27, 0x54, 0xf4, 0x97, 0x72, 0x09, 0xe6,
    /*0x0130*/ 0x4c, 0x5d, 0x85, 0xf0, 0xca, 0xc8, 0x8d, 0xab,
    /*0x0138*/ 0x79, 0x87, 0xdc, 0x0d, 0x64, 0xd4, 0xa6, 0x1e,
    /*0x0140*/ 0xa9, 0x18, 0x52, 0xcd, 0x5e, 0x1f, 0xb0, 0x2d,
    /*0x0148*/ 0xd5, 0x05, 0xa1, 0x4b, 0xbf, 0x5d, 0xf8, 0xfb,
    /*0x0150*/ 0x0a, 0x92, 0x93, 0xdc, 0xd2, 0xbd, 0xa7, 0xdc,
    /*0x0158*/ 0xc1, 0x21, 0x5d, 0xfc, 0xde, 0xa0, 0xee, 0x12,
    /*0x0160*/ 0xf6, 0x6a, 0x5f, 0x8a, 0xff, 0xff, 0x9b, 0x74,
    /*0x0168*/ 0x32, 0x19, 0xfb, 0x24, 0xc1, 0x62, 0x2e, 0x88,
    /*0x0170*/ 0xf9, 0x68, 0x17, 0x51, 0x72, 0x50, 0xfa, 0x41,
    /*0x0178*/ 0x25, 0xb5, 0x67, 0xf6, 0xa7, 0x71, 0x5d, 0x94,
    /*0x0180*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_1024_sha224[] =
{
    /*0x0000*/ 0x09, 0x25, 0x6e, 0x95, 0xaa, 0x82, 0x8f, 0x9c,
    /*0x0008*/ 0x8c, 0xe9, 0xdc, 0x7b, 0x08, 0x3e, 0x9b, 0x67,
    /*0x0010*/ 0xb1, 0xa4, 0x83, 0xcb, 0x9a, 0xc8, 0x18, 0x39,
    /*0x0018*/ 0x0d, 0x3e, 0xc4, 0xab, 0xea, 0x7e, 0x9d, 0x7e,
    /*0x0020*/ 0x71, 0x32, 0x3d, 0x70, 0xbb, 0xec, 0x5b, 0x25,
    /*0x0028*/ 0xd4, 0xb5, 0x01, 0x38, 0xd3, 0x4a, 0x95, 0xc0,
    /*0x0030*/ 0xd4, 0x7e, 0xf0, 0x2a, 0x0e, 0x3d, 0x1f, 0xbd,
    /*0x0038*/ 0xd0, 0x85, 0x5e, 0x6d, 0xe5, 0xa0, 0xb5, 0x48,
    /*0x0040*/ 0x1f, 0xd8, 0x86, 0x15, 0x28, 0x18, 0xd8, 0xac,
    /*0x0048*/ 0xda, 0x2b, 0x67, 0x32, 0xd2, 0x8b, 0x07, 0xd6,
    /*0x0050*/ 0x69, 0xc2, 0x70, 0x35, 0xc7, 0xfe, 0xaf, 0x35,
    /*0x0058*/ 0x62, 0xbc, 0x3e, 0x66, 0x20, 0x0b, 0x2d, 0x25,
    /*0x0060*/ 0x02, 0x08, 0x0b, 0x47, 0xee, 0x8e, 0x5f, 0xba,
    /*0x0068*/ 0xee, 0x48, 0xc0, 0x76, 0x02, 0x13, 0xf8, 0x49,
    /*0x0070*/ 0x00, 0x13, 0xde, 0x94, 0xc3, 0x6d, 0x4e, 0xe6,
    /*0x0078*/ 0x1c, 0xbd, 0xfa, 0x49, 0x2e, 0x7f, 0xfe, 0x4a,
    /*0x0080*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_2048_sha224[] =
{
    /*0x0000*/ 0x83, 0xce, 0x60, 0xe1, 0xa5, 0xd0, 0xb3, 0xf3,
    /*0x0008*/ 0x4b, 0x3d, 0xbd, 0x64, 0x43, 0x30, 0x5b, 0x86,
    /*0x0010*/ 0xcc, 0x30, 0xa5, 0x8a, 0x3b, 0x0c, 0xf0, 0x20,
    /*0x0018*/ 0x2b, 0x2c, 0xa7, 0x42, 0x84, 0x06, 0x05, 0x41,
    /*0x0020*/ 0x2e, 0x3f, 0x8f, 0x6e, 0x5b, 0xa9, 0x13, 0xb5,
    /*0x0028*/ 0x45, 0x08, 0x77, 0x58, 0xf1, 0x67, 0x2f, 0x5c,
    /*0x0030*/ 0x9a, 0x6a, 0xbf, 0x55, 0x17, 0x9e, 0xdc, 0x53,
    /*0x0038*/ 0xdd, 0xe6, 0x6f, 0x4d, 0xf5, 0xea, 0x68, 0xd2,
    /*0x0040*/ 0xa7, 0x74, 0xed, 0x8a, 0x97, 0xfa, 0x94, 0xcd,
    /*0x0048*/ 0x2a, 0xf8, 0xa4, 0x31, 0x4c, 0xb0, 0xfe, 0xf9,
    /*0x0050*/ 0x0e, 0x21, 0x3f, 0x46, 0x46, 0x4a, 0xc4, 0x82,
    /*0x0058*/ 0x94, 0x42, 0xd3, 0x4a, 0xfb, 0x07, 0x84, 0x4f,
    /*0x0060*/ 0x5c, 0xc8, 0x53, 0x7c, 0x2b, 0xd2, 0xca, 0x04,
    /*0x0068*/ 0x3e, 0x31, 0xdf, 0x02, 0xf7, 0x68, 0x3e, 0xb4,
    /*0x0070*/ 0x8e, 0x04, 0x73, 0xcd, 0xba, 0x9b, 0x97, 0x11,
    /*0x0078*/ 0xf8, 0x52, 0xf0, 0x82, 0x6d, 0x2b, 0x0b, 0x2d,
    /*0x0080*/ 0x3d, 0xc8, 0x1f, 0x9e, 0xb2, 0x85, 0x2b, 0x76,
    /*0x0088*/ 0xa1, 0x5e, 0x9f, 0x19, 0xf6, 0xba, 0x36, 0xd1,
    /*0x0090*/ 0x97, 0x5d, 0x15, 0x7a, 0x4f, 0xc9, 0xcb, 0xbc,
    /*0x0098*/ 0x08, 0x53, 0xad, 0x73, 0xe1, 0x1e, 0x76, 0x4b,
    /*0x00a0*/ 0x1b, 0x53, 0x6c, 0x1c, 0x29, 0xa7, 0xb0, 0x05,
    /*0x00a8*/ 0x11, 0x5c, 0xe1, 0xb5, 0x6a, 0xd9, 0xa4, 0x12,
    /*0x00b0*/ 0x2d, 0x25, 0xe4, 0x06, 0x52, 0x86, 0x93, 0xa9,
    /*0x00b8*/ 0x37, 0x4a, 0xf9, 0x7d, 0x1d, 0xbc, 0xee, 0x4a,
    /*0x00c0*/ 0x65, 0x25, 0xfd, 0x87, 0x18, 0xcd, 0x7c, 0x65,
    /*0x00c8*/ 0x0c, 0x3f, 0x49, 0x40, 0xe5, 0x21, 0x01, 0x16,
    /*0x00d0*/ 0xaa, 0xd9, 0x51, 0x1c, 0x27, 0x50, 0x34, 0x16,
    /*0x00d8*/ 0xcc, 0x6b, 0x6b, 0x5b, 0x0e, 0xce, 0x05, 0x1e,
    /*0x00e0*/ 0xc2, 0x35, 0x6b, 0xb5, 0x8e, 0xee, 0x89, 0x1c,
    /*0x00e8*/ 0x7a, 0xb8, 0xb7, 0x89, 0x29, 0xfb, 0x82, 0x60,
    /*0x00f0*/ 0x19, 0xad, 0xd1, 0xac, 0xde, 0x1e, 0xbe, 0xc7,
    /*0x00f8*/ 0x5e, 0xaf, 0xee, 0x2b, 0xe0, 0x3d, 0xb0, 0x03,
    /*0x0100*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_3072_sha224[] =
{
    /*0x0000*/ 0x2d, 0xd9, 0x69, 0x88, 0x29, 0xd6, 0x49, 0x7d,
    /*0x0008*/ 0x37, 0x69, 0x67, 0xcd, 0xae, 0x25, 0xb0, 0x91,
    /*0x0010*/ 0x94, 0xde, 0x3a, 0x62, 0x1e, 0x0a, 0xfb, 0xd7,
    /*0x0018*/ 0x38, 0xc1, 0xcc, 0x63, 0x5f, 0xde, 0x97, 0xfd,
    /*0x0020*/ 0x3a, 0x50, 0xc2, 0x0d, 0x99, 0xb3, 0xec, 0xe8,
    /*0x0028*/ 0x12, 0x39, 0x57, 0xf2, 0x08, 0xa8, 0x80, 0xf5,
    /*0x0030*/ 0xbd, 0xa4, 0x69, 0xbd, 0x6d, 0x4c, 0x99, 0x06,
    /*0x0038*/ 0x7a, 0xfb, 0x54, 0xf4, 0x8a, 0x29, 0x17, 0xe8,
    /*0x0040*/ 0xf7, 0xbb, 0x81, 0xb6, 0x62, 0x8a, 0x8c, 0xe0,
    /*0x0048*/ 0x31, 0xa0, 0x55, 0x7c, 0x81, 0xef, 0x72, 0xd1,
    /*0x0050*/ 0x5b, 0xac, 0x19, 0xbb, 0x3c, 0x0f, 0xaa, 0xf5,
    /*0x0058*/ 0xff, 0xf8, 0xe9, 0x22, 0x2a, 0xd8, 0xef, 0xd0,
    /*0x0060*/ 0x45, 0x69, 0xd8, 0x91, 0x88, 0x19, 0x35, 0x37,
    /*0x0068*/ 0xf8, 0x57, 0x42, 0x50, 0x5c, 0x9d, 0x8e, 0xf1,
    /*0x0070*/ 0xda, 0xf9, 0x1c, 0x4e, 0x7b, 0x9d, 0x4f, 0x48,
    /*0x0078*/ 0x2e, 0x8d, 0x43, 0xf5, 0x13, 0x56, 0x92, 0xa0,
    /*0x0080*/ 0xe3, 0xa3, 0xf0, 0xee, 0xbb, 0xf3, 0xc7, 0x6e,
    /*0x0088*/ 0x2c, 0x7a, 0x60, 0x54, 0xfb, 0x36, 0x31, 0x10,
    /*0x0090*/ 0xb0, 0xbc, 0x86, 0x43, 0x67, 0xd8, 0xc2, 0xd8,
    /*0x0098*/ 0xa1, 0xcf, 0x66, 0xc2, 0x46, 0xe4, 0x96, 0x96,
    /*0x00a0*/ 0x71, 0xc6, 0x44, 0x77, 0x60, 0xeb, 0x65, 0xbd,
    /*0x00a8*/ 0x73, 0xea, 0xcc, 0xd1, 0x5f, 0x59, 0x1f, 0xac,
    /*0x00b0*/ 0x25, 0x92, 0x19, 0xdd, 0x58, 0xea, 0x4a, 0xe6,
    /*0x00b8*/ 0x8d, 0x87, 0x49, 0x4d, 0xe4, 0x78, 0x3a, 0xed,
    /*0x00c0*/ 0x5b, 0x12, 0xec, 0x72, 0xfb, 0x38, 0x5b, 0x69,
    /*0x00c8*/ 0x94, 0x54, 0x94, 0x91, 0x91, 0x8f, 0xea, 0xf7,
    /*0x00d0*/ 0x48, 0x9c, 0x23, 0xc3, 0xa8, 0xb0, 0x43, 0xe5,
    /*0x00d8*/ 0x15, 0x57, 0x24, 0x45, 0xec, 0xa3, 0x61, 0xc0,
    /*0x00e0*/ 0x17, 0x92, 0x9e, 0xc9, 0x46, 0x9c, 0x45, 0x6e,
    /*0x00e8*/ 0x5f, 0x7c, 0x0c, 0x7b, 0x76, 0x32, 0x8f, 0xcb,
    /*0x00f0*/ 0x1c, 0xc1, 0x19, 0xf2, 0x94, 0x60, 0x06, 0x04,
    /*0x00f8*/ 0x25, 0x0a, 0xb2, 0x33, 0x38, 0x55, 0xb7, 0x78,
    /*0x0100*/ 0xf5, 0x47, 0x90, 0xe5, 0x58, 0x68, 0xab, 0x30,
    /*0x0108*/ 0x29, 0xde, 0x38, 0x15, 0x1b, 0x48, 0xaf, 0xa0,
    /*0x0110*/ 0xda, 0xf0, 0x60, 0xd5, 0xd8, 0xbd, 0x0b, 0x6e,
    /*0x0118*/ 0xd8, 0x39, 0x34, 0xf3, 0xaa, 0xe2, 0x4d, 0xf4,
    /*0x0120*/ 0xd0, 0x3b, 0x87, 0x3e, 0xd7, 0xad, 0x8c, 0xe9,
    /*0x0128*/ 0x8b, 0x80, 0x0e, 0x0c, 0x26, 0xeb, 0xf9, 0xdc,
    /*0x0130*/ 0x5b, 0xf3, 0xc9, 0x48, 0x4f, 0xb0, 0xfe, 0xa3,
    /*0x0138*/ 0xb2, 0xc2, 0x98, 0x4e, 0xb1, 0x48, 0x11, 0x27,
    /*0x0140*/ 0x1d, 0xf2, 0xee, 0xc7, 0xa9, 0x76, 0xb9, 0xaf,
    /*0x0148*/ 0x9b, 0x74, 0xd4, 0xec, 0xe6, 0x7d, 0x4c, 0x6d,
    /*0x0150*/ 0xe1, 0xc1, 0x35, 0x99, 0x79, 0xee, 0xb2, 0x27,
    /*0x0158*/ 0x0e, 0xd5, 0x9c, 0x20, 0x17, 0xae, 0x25, 0x88,
    /*0x0160*/ 0x37, 0x69, 0x3b, 0x4f, 0x30, 0x9e, 0xf6, 0x01,
    /*0x0168*/ 0x83, 0xd9, 0x6d, 0x13, 0x90, 0x2b, 0xcb, 0x50,
    /*0x0170*/ 0x11, 0xd9, 0xb7, 0x7d, 0x1b, 0x9d, 0x31, 0x1c,
    /*0x0178*/ 0xf9, 0x86, 0xf1, 0xa4, 0x49, 0x71, 0x49, 0x33,
    /*0x0180*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_1024_sha256[] =
{
    /*0x0000*/ 0x6d, 0x44, 0x8f, 0x0a, 0x97, 0x3f, 0x29, 0x1e,
    /*0x0008*/ 0x2f, 0x3d, 0x6c, 0x58, 0xca, 0xd6, 0xd0, 0xdf,
    /*0x0010*/ 0x80, 0x58, 0xf3, 0x00, 0x92, 0x38, 0x84, 0x9d,
    /*0x0018*/ 0x11, 0x48, 0x4d, 0xa5, 0x35, 0x1b, 0xcc, 0x4b,
    /*0x0020*/ 0xa1, 0x2f, 0x03, 0x36, 0x28, 0xef, 0x54, 0x5b,
    /*0x0028*/ 0x02, 0x6d, 0x08, 0x0b, 0x5a, 0x2d, 0x71, 0x69,
    /*0x0030*/ 0x2d, 0x2a, 0xdc, 0x8a, 0xec, 0x31, 0xcd, 0x4c,
    /*0x0038*/ 0x8f, 0x73, 0x47, 0xf1, 0xb6, 0x12, 0xc5, 0x1b,
    /*0x0040*/ 0xc8, 0x33, 0x0a, 0x72, 0xb3, 0xdd, 0x83, 0x98,
    /*0x0048*/ 0xe8, 0xf8, 0x54, 0x12, 0x69, 0xd4, 0x2e, 0xaa,
    /*0x0050*/ 0xd6, 0xbb, 0x7e, 0x5e, 0x8b, 0xfc, 0x13, 0x25,
    /*0x0058*/ 0xdb, 0x6e, 0xb4, 0xa6, 0xc8, 0x6f, 0x69, 0x83,
    /*0x0060*/ 0xb4, 0x35, 0xcf, 0xd2, 0x3e, 0xa5, 0x42, 0x2b,
    /*0x0068*/ 0x8b, 0x1e, 0xcd, 0x73, 0x4d, 0x55, 0x2c, 0x0b,
    /*0x0070*/ 0x2d, 0x71, 0xf3, 0xa5, 0x0e, 0x92, 0xee, 0x42,
    /*0x0078*/ 0xd1, 0xd6, 0x54, 0x0d, 0x4b, 0xf7, 0x60, 0x6b,
    /*0x0080*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_2048_sha256[] =
{
    /*0x0000*/ 0xa9, 0x15, 0x57, 0x1c, 0xb3, 0xb5, 0x8c, 0xcd,
    /*0x0008*/ 0x61, 0x45, 0x06, 0xd0, 0x97, 0x73, 0x65, 0x5b,
    /*0x0010*/ 0xcf, 0x9e, 0x7f, 0x12, 0xba, 0x7a, 0x8d, 0x57,
    /*0x0018*/ 0x90, 0xa9, 0x83, 0x8d, 0xbf, 0x0d, 0x85, 0x66,
    /*0x0020*/ 0xe9, 0x9a, 0x0e, 0xcb, 0x7f, 0x57, 0x3e, 0x39,
    /*0x0028*/ 0xa2, 0x96, 0x3f, 0xd4, 0x7e, 0x4b, 0x76, 0x60,
    /*0x0030*/ 0xca, 0x73, 0xe6, 0x8e, 0xab, 0xf1, 0x71, 0x0b,
    /*0x0038*/ 0x4b, 0x80, 0x4a, 0xc7, 0x97, 0xaa, 0x46, 0x02,
    /*0x0040*/ 0x8b, 0x04, 0x55, 0x14, 0x01, 0x49, 0x00, 0x8f,
    /*0x0048*/ 0x7e, 0xc9, 0x7b, 0x51, 0xd3, 0xfc, 0x35, 0xb8,
    /*0x0050*/ 0x82, 0x7a, 0xce, 0x55, 0x2f, 0x00, 0x4e, 0x1c,
    /*0x0058*/ 0x59, 0x1b, 0x78, 0x1e, 0xc2, 0xe0, 0xf6, 0x8f,
    /*0x0060*/ 0x2b, 0x12, 0x72, 0xa2, 0x5d, 0x37, 0x27, 0x6b,
    /*0x0068*/ 0x50, 0x04, 0xe8, 0xd6, 0x8d, 0xa8, 0x82, 0xd7,
    /*0x0070*/ 0x0b, 0xf1, 0xfe, 0x30, 0xe0, 0x21, 0x25, 0x4e,
    /*0x0078*/ 0xe7, 0xe6, 0xc9, 0x82, 0x91, 0x03, 0xc7, 0x80,
    /*0x0080*/ 0xb2, 0x15, 0xe5, 0x53, 0xf9, 0x77, 0x76, 0x18,
    /*0x0088*/ 0x7b, 0xf7, 0xf3, 0xd3, 0xbf, 0xc6, 0xea, 0xc3,
    /*0x0090*/ 0x3e, 0x51, 0x71, 0x39, 0x47, 0x29, 0x69, 0xaf,
    /*0x0098*/ 0x22, 0xdf, 0x2b, 0x6f, 0x28, 0x81, 0xaa, 0xd9,
    /*0x00a0*/ 0x6b, 0x9a, 0x87, 0x0b, 0xbf, 0x63, 0xda, 0xfc,
    /*0x00a8*/ 0xb5, 0x1d, 0xd1, 0xe8, 0xd1, 0x5b, 0xdc, 0x13,
    /*0x00b0*/ 0xaf, 0x71, 0xd4, 0xaf, 0xe2, 0x8f, 0xc8, 0x0e,
    /*0x00b8*/ 0xf2, 0x67, 0x20, 0x72, 0x84, 0x44, 0xc5, 0x5c,
    /*0x00c0*/ 0xf8, 0xb0, 0x4e, 0xfb, 0xfd, 0x0b, 0x59, 0x14,
    /*0x00c8*/ 0x90, 0x37, 0x0a, 0x91, 0x92, 0x55, 0xa1, 0x9f,
    /*0x00d0*/ 0x31, 0x33, 0x4b, 0x1c, 0x43, 0x04, 0xf7, 0xeb,
    /*0x00d8*/ 0x00, 0xa8, 0x52, 0x61, 0x8e, 0x23, 0x49, 0x08,
    /*0x00e0*/ 0xdb, 0xf6, 0xd2, 0x44, 0x15, 0xf4, 0x94, 0x17,
    /*0x00e8*/ 0x0c, 0x46, 0x41, 0xce, 0x85, 0x89, 0xa6, 0x2b,
    /*0x00f0*/ 0x2d, 0x36, 0xee, 0xc0, 0x92, 0x26, 0x1d, 0xe9,
    /*0x00f8*/ 0xe9, 0xdc, 0x16, 0x35, 0x7f, 0xf8, 0xad, 0x6b,
    /*0x0100*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_3072_sha256[] =
{
    /*0x0000*/ 0x07, 0x8e, 0x4c, 0x67, 0xf0, 0x05, 0x5f, 0xd5,
    /*0x0008*/ 0x44, 0x8f, 0x54, 0x94, 0xa2, 0x4c, 0x11, 0xc9,
    /*0x0010*/ 0x4d, 0x66, 0x2b, 0xe3, 0xa2, 0xb3, 0x12, 0x91,
    /*0x0018*/ 0xbe, 0xfb, 0x86, 0x23, 0x70, 0xdf, 0x7d, 0xc0,
    /*0x0020*/ 0xa4, 0xe5, 0x55, 0x42, 0x50, 0xb7, 0x0c, 0x9a,
    /*0x0028*/ 0x95, 0xe9, 0x80, 0x0a, 0xb5, 0x9d, 0xef, 0x33,
    /*0x0030*/ 0xeb, 0x47, 0x9e, 0xb1, 0x09, 0x57, 0x79, 0xc4,
    /*0x0038*/ 0x42, 0x06, 0x59, 0x24, 0xa5, 0xae, 0x91, 0xeb,
    /*0x0040*/ 0x48, 0xba, 0x05, 0x36, 0x4a, 0x45, 0x21, 0xd7,
    /*0x0048*/ 0xc1, 0x25, 0xb9, 0x65, 0x05, 0x1f, 0x99, 0xbb,
    /*0x0050*/ 0xfb, 0x85, 0x96, 0x99, 0x47, 0x3f, 0x6c, 0xeb,
    /*0x0058*/ 0xca, 0x65, 0xdc, 0xf5, 0xa5, 0xe3, 0x22, 0x84,
    /*0x0060*/ 0x5f, 0xb9, 0x8c, 0x92, 0x7d, 0xd3, 0x7a, 0xaf,
    /*0x0068*/ 0xa7, 0x73, 0x53, 0xe8, 0x7c, 0x33, 0x6c, 0x62,
    /*0x0070*/ 0x25, 0x83, 0xda, 0x9e, 0x7f, 0x53, 0x41, 0x36,
    /*0x0078*/ 0xb8, 0xa5, 0xd6, 0xbf, 0x39, 0xad, 0xe4, 0x33,
    /*0x0080*/ 0xf2, 0x25, 0x31, 0x9b, 0x27, 0x7b, 0x03, 0xc2,
    /*0x0088*/ 0xd3, 0xb7, 0x8e, 0xe8, 0xb6, 0x0f, 0x7d, 0x18,
    /*0x0090*/ 0x24, 0xf8, 0x51, 0x91, 0x83, 0xed, 0x96, 0x0c,
    /*0x0098*/ 0xec, 0x86, 0x3c, 0x37, 0x3c, 0xb6, 0x84, 0xb3,
    /*0x00a0*/ 0x39, 0x55, 0x1b, 0x2f, 0xf7, 0xc6, 0xd7, 0x3f,
    /*0x00a8*/ 0x2a, 0x94, 0x73, 0xba, 0x8c, 0x97, 0xbd, 0x72,
    /*0x00b0*/ 0x55, 0xb8, 0x1c, 0xb1, 0x81, 0x4e, 0xdf, 0x2d,
    /*0x00b8*/ 0x02, 0x74, 0x08, 0xd6, 0x5e, 0x63, 0x49, 0x9b,
    /*0x00c0*/ 0x27, 0x80, 0x57, 0x02, 0x5f, 0xb5, 0x92, 0x77,
    /*0x00c8*/ 0xd5, 0x11, 0xd4, 0xae, 0xee, 0xb5, 0x1d, 0xf0,
    /*0x00d0*/ 0xac, 0xe4, 0xd5, 0x2e, 0x1c, 0xb4, 0xef, 0xf5,
    /*0x00d8*/ 0x4a, 0x95, 0x5e, 0x61, 0xe0, 0x08, 0x43, 0x93,
    /*0x00e0*/ 0xa1, 0x51, 0xcb, 0xc4, 0x2a, 0x1e, 0xd9, 0xd2,
    /*0x00e8*/ 0xac, 0xe5, 0xb4, 0x74, 0x82, 0x91, 0x7a, 0x43,
    /*0x00f0*/ 0x46, 0xea, 0xf9, 0x59, 0x5d, 0xfc, 0xbb, 0x71,
    /*0x00f8*/ 0x1d, 0x34, 0x3e, 0xca, 0x0e, 0xb7, 0xaa, 0xca,
    /*0x0100*/ 0xf8, 0x04, 0x32, 0xe9, 0xcf, 0xfb, 0x73, 0xd3,
    /*0x0108*/ 0xb6, 0x3f, 0xef, 0xfb, 0x44, 0xf6, 0xc9, 0x60,
    /*0x0110*/ 0xdd, 0xef, 0x9d, 0xf2, 0x65, 0xc9, 0x5a, 0xea,
    /*0x0118*/ 0x14, 0x89, 0x93, 0x41, 0x9d, 0xa1, 0x00, 0x07,
    /*0x0120*/ 0xc8, 0xa0, 0x9a, 0x12, 0x42, 0x59, 0xa6, 0x90,
    /*0x0128*/ 0x28, 0xde, 0x52, 0x23, 0x8b, 0x36, 0x00, 0x04,
    /*0x0130*/ 0x6e, 0x0e, 0x96, 0x4c, 0x65, 0x4d, 0xf0, 0x68,
    /*0x0138*/ 0x36, 0x69, 0xa4, 0xa6, 0xb8, 0x11, 0xcd, 0xd7,
    /*0x0140*/ 0xea, 0x49, 0x8d, 0x67, 0x0c, 0xab, 0xed, 0x5f,
    /*0x0148*/ 0xda, 0x49, 0xdd, 0x3b, 0x00, 0xd1, 0x28, 0xbe,
    /*0x0150*/ 0xbe, 0xd2, 0x82, 0x1b, 0xf3, 0x9d, 0x09, 0x19,
    /*0x0158*/ 0x4f, 0x83, 0x73, 0x4f, 0xaf, 0x0b, 0xa1, 0x4f,
    /*0x0160*/ 0x53, 0xf8, 0x8e, 0xaf, 0x51, 0x61, 0xac, 0x18,
    /*0x0168*/ 0x58, 0x2e, 0x4d, 0x34, 0x64, 0xca, 0x13, 0x3b,
    /*0x0170*/ 0xb6, 0x77, 0x55, 0x02, 0xef, 0xf7, 0xce, 0xc4,
    /*0x0178*/ 0xa1, 0xcd, 0xd5, 0xa6, 0x9f, 0x9c, 0xa6, 0xda,
    /*0x0180*/
};

#ifdef EIP130_ENABLE_SYM_ALGO_SHA512
static const uint8_t signature_rsa_pkcs1v15_abc_1024_sha384[] =
{
    /*0x0000*/ 0x57, 0x66, 0xa1, 0x0f, 0x78, 0xd3, 0xa7, 0x23,
    /*0x0008*/ 0x30, 0x53, 0x7e, 0x81, 0xcc, 0xe2, 0x5f, 0x00,
    /*0x0010*/ 0x92, 0x11, 0x37, 0x40, 0xd2, 0x26, 0x0b, 0x74,
    /*0x0018*/ 0x9d, 0x8c, 0x22, 0x3c, 0xa8, 0x6e, 0xf1, 0xd5,
    /*0x0020*/ 0x4e, 0x8f, 0xa1, 0x12, 0x6b, 0x39, 0x62, 0x91,
    /*0x0028*/ 0xec, 0x22, 0x23, 0x23, 0x0c, 0xa4, 0xdf, 0x31,
    /*0x0030*/ 0x0a, 0xcb, 0xc2, 0x11, 0x19, 0x14, 0x49, 0x3e,
    /*0x0038*/ 0xd4, 0x3c, 0x3e, 0xbb, 0x76, 0x07, 0x56, 0x01,
    /*0x0040*/ 0x4c, 0x5e, 0xff, 0xd9, 0x92, 0x32, 0xe7, 0xea,
    /*0x0048*/ 0xdc, 0x41, 0x9f, 0xa2, 0xb2, 0xb4, 0x58, 0x70,
    /*0x0050*/ 0x06, 0x4c, 0xc8, 0xf1, 0xb9, 0x47, 0x4a, 0x8b,
    /*0x0058*/ 0xf7, 0x9e, 0x0e, 0xab, 0x07, 0xfe, 0xc7, 0x24,
    /*0x0060*/ 0x90, 0x96, 0x4d, 0xcf, 0xb7, 0xeb, 0x82, 0xaf,
    /*0x0068*/ 0xf5, 0x47, 0xef, 0xe9, 0x1e, 0x76, 0x11, 0x5c,
    /*0x0070*/ 0xc3, 0x64, 0x40, 0x5d, 0x0c, 0xbe, 0xeb, 0x6c,
    /*0x0078*/ 0x2f, 0x83, 0x75, 0x5c, 0x54, 0x77, 0xa6, 0x59,
    /*0x0080*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_2048_sha384[] =
{
    /*0x0000*/ 0x2f, 0x47, 0x45, 0x6f, 0xd4, 0xc0, 0x1c, 0x8a,
    /*0x0008*/ 0x16, 0x23, 0xf5, 0x95, 0x3d, 0xe4, 0x0f, 0xea,
    /*0x0010*/ 0x4e, 0xfa, 0x25, 0xb6, 0x7c, 0x44, 0x57, 0x2a,
    /*0x0018*/ 0x72, 0x69, 0xcb, 0xe0, 0x47, 0x2d, 0xee, 0x0a,
    /*0x0020*/ 0xcc, 0x96, 0xb9, 0xbc, 0x6e, 0xa6, 0x00, 0x18,
    /*0x0028*/ 0x1f, 0x51, 0x44, 0x56, 0xca, 0xd4, 0xce, 0x15,
    /*0x0030*/ 0x32, 0xe3, 0x63, 0x62, 0x74, 0xec, 0xab, 0x0b,
    /*0x0038*/ 0xc4, 0xc2, 0x8b, 0x2c, 0x5e, 0xa5, 0x0f, 0x57,
    /*0x0040*/ 0x05, 0xeb, 0x26, 0x13, 0x50, 0x9f, 0x95, 0x26,
    /*0x0048*/ 0x5d, 0xf0, 0x1d, 0xdb, 0x69, 0x5a, 0xf6, 0x0f,
    /*0x0050*/ 0xcf, 0x52, 0x9e, 0x3f, 0xfe, 0x51, 0x13, 0xfb,
    /*0x0058*/ 0xcb, 0x49, 0x33, 0xb0, 0xe6, 0x69, 0x9f, 0x52,
    /*0x0060*/ 0xd4, 0xd8, 0x84, 0x95, 0x8f, 0x16, 0xa3, 0x80,
    /*0x0068*/ 0x09, 0xcc, 0x42, 0x09, 0xb6, 0x1f, 0xb9, 0x1c,
    /*0x0070*/ 0x2f, 0x3e, 0x53, 0x0c, 0x0b, 0x90, 0x5e, 0x05,
    /*0x0078*/ 0x18, 0xe7, 0xcb, 0x78, 0x0e, 0x8c, 0x38, 0xc2,
    /*0x0080*/ 0xa9, 0x41, 0xcf, 0x62, 0x02, 0x25, 0xa0, 0x7f,
    /*0x0088*/ 0xa5, 0x2c, 0xb3, 0x16, 0x31, 0x6f, 0xbe, 0xf9,
    /*0x0090*/ 0x29, 0x02, 0xa2, 0x9d, 0x7f, 0x0e, 0x85, 0x05,
    /*0x0098*/ 0xf9, 0xf5, 0x4f, 0x37, 0xae, 0x6d, 0xe0, 0x78,
    /*0x00a0*/ 0xf1, 0x20, 0x41, 0x71, 0xbf, 0x27, 0xea, 0x14,
    /*0x00a8*/ 0x6e, 0x55, 0x1b, 0xa1, 0x40, 0x20, 0x72, 0xc0,
    /*0x00b0*/ 0x81, 0x21, 0x6c, 0xe0, 0xa0, 0x98, 0x9a, 0x9b,
    /*0x00b8*/ 0x26, 0x7b, 0x3b, 0x54, 0xfa, 0xc7, 0xf8, 0xfe,
    /*0x00c0*/ 0xe3, 0x65, 0x6f, 0x28, 0x13, 0x97, 0x43, 0xa0,
    /*0x00c8*/ 0xf0, 0x54, 0x73, 0x28, 0x55, 0x7e, 0xe2, 0x82,
    /*0x00d0*/ 0xf5, 0x98, 0x05, 0x92, 0x82, 0x87, 0x63, 0x27,
    /*0x00d8*/ 0x4a, 0xd6, 0x1d, 0x6b, 0x74, 0xa2, 0xd1, 0xfc,
    /*0x00e0*/ 0x75, 0xe3, 0x20, 0x20, 0x49, 0xda, 0xfb, 0x06,
    /*0x00e8*/ 0x43, 0x8f, 0x12, 0xa5, 0x7c, 0x9b, 0x8f, 0x4c,
    /*0x00f0*/ 0x57, 0xbe, 0xad, 0xb8, 0xd4, 0x01, 0x93, 0x0d,
    /*0x00f8*/ 0x5c, 0x53, 0xa4, 0xbc, 0x99, 0x72, 0x1e, 0x9a,
    /*0x0100*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_3072_sha384[] =
{
    /*0x0000*/ 0x2c, 0x66, 0xff, 0x2d, 0x21, 0xaf, 0x3d, 0x95,
    /*0x0008*/ 0xcc, 0xa8, 0xcc, 0xa4, 0x7f, 0xa0, 0x0b, 0x20,
    /*0x0010*/ 0xc8, 0x33, 0x7b, 0xb2, 0x0c, 0xde, 0xe1, 0x77,
    /*0x0018*/ 0x00, 0xa9, 0x40, 0x0a, 0xc6, 0x25, 0x7d, 0x59,
    /*0x0020*/ 0xc3, 0x6b, 0x2d, 0x94, 0x2c, 0x5c, 0x4e, 0xe0,
    /*0x0028*/ 0xb4, 0x3d, 0x4f, 0xa9, 0xaa, 0xcc, 0x94, 0x27,
    /*0x0030*/ 0x27, 0x74, 0x13, 0xda, 0xa2, 0x50, 0xe9, 0x2a,
    /*0x0038*/ 0x9e, 0xd5, 0x46, 0x58, 0xa3, 0xc9, 0xe8, 0xee,
    /*0x0040*/ 0x20, 0x5a, 0xbe, 0x79, 0xc8, 0x70, 0xcb, 0xbc,
    /*0x0048*/ 0x00, 0xc7, 0xc3, 0xfd, 0x62, 0x5a, 0xb2, 0xc5,
    /*0x0050*/ 0xe5, 0xeb, 0x61, 0xab, 0x79, 0x19, 0x12, 0xef,
    /*0x0058*/ 0x15, 0x43, 0xfa, 0x18, 0x12, 0xf6, 0xaa, 0x72,
    /*0x0060*/ 0x0e, 0xa0, 0xc6, 0x7b, 0x9c, 0x45, 0xcb, 0x03,
    /*0x0068*/ 0x2d, 0x22, 0x7b, 0x4b, 0xec, 0x5f, 0xc8, 0x3e,
    /*0x0070*/ 0x38, 0xf7, 0x66, 0xbe, 0xe6, 0x46, 0xa4, 0xdf,
    /*0x0078*/ 0x53, 0x5b, 0xde, 0x24, 0x32, 0x6c, 0x6a, 0x85,
    /*0x0080*/ 0x94, 0xdf, 0x3f, 0x65, 0x1a, 0xfe, 0x0e, 0xcb,
    /*0x0088*/ 0xbb, 0xa0, 0x95, 0x10, 0xaa, 0x12, 0xec, 0x45,
    /*0x0090*/ 0xdf, 0xd1, 0xf9, 0xb7, 0x51, 0x0c, 0x9c, 0x00,
    /*0x0098*/ 0xc0, 0xac, 0xed, 0x36, 0x99, 0xee, 0xaa, 0x27,
    /*0x00a0*/ 0x3c, 0xab, 0x7d, 0x0a, 0x88, 0x69, 0x29, 0x2b,
    /*0x00a8*/ 0x1f, 0x5e, 0x55, 0x01, 0xc0, 0x74, 0x38, 0xe0,
    /*0x00b0*/ 0x19, 0x8f, 0x13, 0xb7, 0x5d, 0xd4, 0x5c, 0xc0,
    /*0x00b8*/ 0xa6, 0x0f, 0xde, 0x9e, 0xc2, 0x94, 0x64, 0x5c,
    /*0x00c0*/ 0xf2, 0xfd, 0x83, 0x49, 0xd6, 0x63, 0x47, 0xb0,
    /*0x00c8*/ 0xc0, 0x88, 0x96, 0xeb, 0xdd, 0x28, 0x99, 0x44,
    /*0x00d0*/ 0x62, 0x7f, 0xa4, 0x42, 0x5c, 0x31, 0xf4, 0x15,
    /*0x00d8*/ 0xba, 0xa5, 0x57, 0xf3, 0x89, 0xe4, 0xd2, 0x28,
    /*0x00e0*/ 0xe6, 0x6a, 0xbc, 0xa4, 0x9e, 0xc1, 0x12, 0xba,
    /*0x00e8*/ 0xfc, 0xb5, 0x24, 0xd3, 0x1b, 0xff, 0x66, 0xa5,
    /*0x00f0*/ 0x2e, 0x18, 0xa5, 0xf5, 0x68, 0x0e, 0xd9, 0xb0,
    /*0x00f8*/ 0x78, 0xc1, 0x4c, 0x3c, 0x37, 0x23, 0xfe, 0x76,
    /*0x0100*/ 0x18, 0xcb, 0x10, 0xd2, 0x88, 0x20, 0x33, 0xf9,
    /*0x0108*/ 0xa0, 0xcd, 0xf4, 0x52, 0xc6, 0x52, 0xc9, 0xe3,
    /*0x0110*/ 0x85, 0x26, 0xda, 0xb1, 0xe7, 0xda, 0xa5, 0xa3,
    /*0x0118*/ 0x50, 0x14, 0xbe, 0x6e, 0x8f, 0x6a, 0xca, 0x55,
    /*0x0120*/ 0xb8, 0xa9, 0x8c, 0x30, 0x7d, 0x54, 0x5d, 0x4b,
    /*0x0128*/ 0x47, 0xce, 0x39, 0xae, 0x33, 0x0e, 0x8c, 0xe8,
    /*0x0130*/ 0x0f, 0x67, 0x59, 0x33, 0x04, 0x6d, 0xb0, 0x8f,
    /*0x0138*/ 0x6b, 0x1d, 0x79, 0x0c, 0xf5, 0x8d, 0x23, 0x0a,
    /*0x0140*/ 0x7e, 0x32, 0x61, 0x79, 0x87, 0x52, 0x8d, 0x76,
    /*0x0148*/ 0x4c, 0x8a, 0xf6, 0xf8, 0x17, 0x7d, 0x05, 0x2c,
    /*0x0150*/ 0xae, 0x4a, 0x77, 0x06, 0x45, 0x48, 0xc5, 0xdc,
    /*0x0158*/ 0x67, 0x2e, 0x89, 0x13, 0x60, 0xa5, 0x71, 0x4b,
    /*0x0160*/ 0x22, 0xb0, 0xa8, 0x91, 0x83, 0x6c, 0x07, 0xea,
    /*0x0168*/ 0xd0, 0x3b, 0xf1, 0x17, 0xd1, 0x23, 0xaf, 0x17,
    /*0x0170*/ 0x33, 0x6b, 0x96, 0x3c, 0x88, 0x93, 0x47, 0x66,
    /*0x0178*/ 0x21, 0x4d, 0x82, 0x3c, 0x2d, 0x82, 0x0e, 0x05,
    /*0x0180*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_1024_sha512[] =
{
    /*0x0000*/ 0x92, 0x08, 0x12, 0xfe, 0x39, 0xaa, 0x1d, 0xcf,
    /*0x0008*/ 0x25, 0x85, 0xf9, 0x8a, 0xde, 0x10, 0xd9, 0x16,
    /*0x0010*/ 0xc6, 0x3a, 0x2f, 0x04, 0x5b, 0xcd, 0x30, 0x45,
    /*0x0018*/ 0x10, 0xf4, 0x6e, 0x6f, 0x98, 0x43, 0x17, 0xe0,
    /*0x0020*/ 0x81, 0xe1, 0x11, 0x27, 0x8f, 0xc3, 0x58, 0x17,
    /*0x0028*/ 0x42, 0xd9, 0xfb, 0x16, 0x25, 0xc5, 0x0b, 0x4c,
    /*0x0030*/ 0xf2, 0x04, 0xa7, 0x43, 0x38, 0xd2, 0xf6, 0x63,
    /*0x0038*/ 0x70, 0xc8, 0xd9, 0xe7, 0x0c, 0x9c, 0xf7, 0xca,
    /*0x0040*/ 0x9b, 0xa8, 0xd8, 0xf4, 0x7d, 0x16, 0xa9, 0xb3,
    /*0x0048*/ 0xa2, 0x0c, 0x56, 0x57, 0xbf, 0x91, 0x12, 0x05,
    /*0x0050*/ 0x5b, 0xc6, 0xbc, 0xf7, 0x3e, 0x41, 0x8d, 0xf6,
    /*0x0058*/ 0x21, 0x1a, 0x75, 0xde, 0x10, 0x42, 0x0c, 0x44,
    /*0x0060*/ 0x58, 0xf2, 0xd1, 0x80, 0x13, 0x3f, 0x1b, 0x58,
    /*0x0068*/ 0xb6, 0xa0, 0x98, 0xff, 0xf0, 0xa4, 0x38, 0x83,
    /*0x0070*/ 0x23, 0x66, 0xec, 0xb9, 0x97, 0x51, 0x25, 0x49,
    /*0x0078*/ 0xc6, 0x57, 0xc0, 0xc8, 0x59, 0x34, 0xd8, 0x26,
    /*0x0080*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_2048_sha512[] =
{
    /*0x0000*/ 0xa3, 0xb6, 0x31, 0x99, 0x2b, 0x38, 0xef, 0x04,
    /*0x0008*/ 0x25, 0x7d, 0xbd, 0x13, 0x5c, 0xe6, 0x3c, 0x93,
    /*0x0010*/ 0xb9, 0x46, 0x90, 0xa3, 0x78, 0x3b, 0xb3, 0x5e,
    /*0x0018*/ 0xf8, 0x84, 0x08, 0xef, 0x6f, 0x54, 0x49, 0x46,
    /*0x0020*/ 0x01, 0x59, 0x9b, 0xb8, 0x29, 0xad, 0x19, 0x45,
    /*0x0028*/ 0x75, 0x6c, 0x6a, 0x7d, 0xef, 0xf7, 0x86, 0xf1,
    /*0x0030*/ 0xeb, 0x7f, 0x8c, 0xf1, 0x1e, 0x31, 0x7c, 0x3f,
    /*0x0038*/ 0x52, 0x12, 0x46, 0x47, 0x66, 0x25, 0x21, 0x80,
    /*0x0040*/ 0xf1, 0x34, 0x16, 0x57, 0xa6, 0xd8, 0x7f, 0xc1,
    /*0x0048*/ 0x61, 0x45, 0x11, 0x05, 0x3d, 0x90, 0x5c, 0xfd,
    /*0x0050*/ 0x4d, 0x70, 0x7a, 0x4f, 0xf5, 0xfb, 0x62, 0x9f,
    /*0x0058*/ 0x42, 0x45, 0xc9, 0x70, 0x57, 0x57, 0x98, 0x68,
    /*0x0060*/ 0xfd, 0x2b, 0xcf, 0x98, 0x43, 0x33, 0x1a, 0x5c,
    /*0x0068*/ 0xec, 0x0e, 0xc0, 0x60, 0xd7, 0x01, 0xfc, 0xe9,
    /*0x0070*/ 0xe1, 0xf3, 0xbc, 0x19, 0x19, 0xbc, 0x41, 0xc0,
    /*0x0078*/ 0xe2, 0x05, 0x8c, 0xf0, 0x75, 0xa2, 0x7b, 0x91,
    /*0x0080*/ 0xb3, 0xdd, 0x97, 0xac, 0x64, 0x89, 0xa4, 0xb3,
    /*0x0088*/ 0xe3, 0xe4, 0x28, 0x32, 0x73, 0x6a, 0xe3, 0x1e,
    /*0x0090*/ 0x6a, 0x19, 0xfb, 0x58, 0xfb, 0xe2, 0xd9, 0x2f,
    /*0x0098*/ 0xd3, 0x12, 0x83, 0x2e, 0x5f, 0xdf, 0xa8, 0x1b,
    /*0x00a0*/ 0xf9, 0xe8, 0x3f, 0xde, 0xf7, 0x6a, 0xd0, 0x69,
    /*0x00a8*/ 0xba, 0xae, 0x23, 0x33, 0xbd, 0xf5, 0xc9, 0x01,
    /*0x00b0*/ 0x32, 0x9f, 0x88, 0x57, 0x6e, 0xdb, 0x97, 0xe0,
    /*0x00b8*/ 0x47, 0xa0, 0x50, 0x1a, 0x5c, 0xa7, 0x75, 0x3b,
    /*0x00c0*/ 0xc2, 0x55, 0xc3, 0xf9, 0x8a, 0x68, 0xa7, 0xbd,
    /*0x00c8*/ 0xa5, 0xd8, 0xbe, 0xa8, 0x96, 0x00, 0xcf, 0x77,
    /*0x00d0*/ 0x9a, 0x90, 0xa2, 0x54, 0x55, 0xe1, 0xdd, 0x43,
    /*0x00d8*/ 0xc0, 0x07, 0x30, 0xfc, 0x53, 0xf8, 0x3e, 0x35,
    /*0x00e0*/ 0xba, 0x06, 0xe5, 0x5e, 0x20, 0xf0, 0xc8, 0x36,
    /*0x00e8*/ 0x87, 0xea, 0xa7, 0x1f, 0x45, 0xdd, 0x1d, 0x54,
    /*0x00f0*/ 0x2e, 0xca, 0xda, 0x63, 0x4e, 0x69, 0xc5, 0xe8,
    /*0x00f8*/ 0x9a, 0xed, 0x77, 0xc6, 0x00, 0x4d, 0x85, 0xab,
    /*0x0100*/
};

static const uint8_t signature_rsa_pkcs1v15_abc_3072_sha512[] =
{
    /*0x0000*/ 0x70, 0x79, 0xb4, 0x75, 0x3e, 0x5d, 0x65, 0xbc,
    /*0x0008*/ 0xee, 0x92, 0x09, 0xec, 0x6d, 0xc9, 0xcb, 0xd9,
    /*0x0010*/ 0xbf, 0x13, 0x16, 0xf7, 0x5a, 0xae, 0x58, 0xc5,
    /*0x0018*/ 0xe6, 0x23, 0xcf, 0x26, 0x36, 0xe7, 0xbe, 0xa0,
    /*0x0020*/ 0x5a, 0x70, 0xa9, 0x73, 0x29, 0x32, 0x80, 0x8d,
    /*0x0028*/ 0x58, 0x3d, 0x8d, 0xab, 0xfc, 0xa4, 0x4f, 0xfa,
    /*0x0030*/ 0xe2, 0xe3, 0xe6, 0x9f, 0x25, 0xda, 0x1c, 0xbd,
    /*0x0038*/ 0x18, 0x99, 0x84, 0x02, 0x9e, 0xdd, 0x02, 0x1c,
    /*0x0040*/ 0xcb, 0x39, 0x9d, 0x14, 0x2b, 0x73, 0x6d, 0xdd,
    /*0x0048*/ 0x3a, 0x7d, 0xdc, 0xcb, 0x9a, 0x85, 0x77, 0x1f,
    /*0x0050*/ 0x3b, 0x2c, 0x81, 0x81, 0x8f, 0xb7, 0xb9, 0x84,
    /*0x0058*/ 0x07, 0x4b, 0x55, 0xea, 0x4d, 0x82, 0x20, 0x0e,
    /*0x0060*/ 0xb7, 0x7e, 0x02, 0xd9, 0x66, 0x41, 0x09, 0x74,
    /*0x0068*/ 0xc2, 0x44, 0x1e, 0x02, 0x03, 0x09, 0x8a, 0x07,
    /*0x0070*/ 0x5e, 0x48, 0xd2, 0x61, 0x7b, 0x90, 0xe3, 0x9b,
    /*0x0078*/ 0xb5, 0x08, 0xac, 0x7d, 0x30, 0x2e, 0xcf, 0xd3,
    /*0x0080*/ 0x81, 0xbc, 0x12, 0x62, 0x96, 0xd6, 0xea, 0xa7,
    /*0x0088*/ 0x6d, 0xe1, 0x83, 0xa7, 0x19, 0x0e, 0xa0, 0xee,
    /*0x0090*/ 0xda, 0xc4, 0xf1, 0xd9, 0x69, 0x3d, 0x0a, 0xa5,
    /*0x0098*/ 0x97, 0x2e, 0x7b, 0x9e, 0xf5, 0xb5, 0x5b, 0x7b,
    /*0x00a0*/ 0x12, 0x49, 0xf5, 0xeb, 0xb6, 0xe8, 0xc6, 0x8a,
    /*0x00a8*/ 0xb5, 0x31, 0xd4, 0xf1, 0x7b, 0x57, 0x40, 0xc6,
    /*0x00b0*/ 0x0d, 0xb0, 0x87, 0xd0, 0xd3, 0x30, 0x24, 0xea,
    /*0x00b8*/ 0xd4, 0x8f, 0x46, 0x04, 0x41, 0xf0, 0x78, 0xb8,
    /*0x00c0*/ 0x3d, 0x56, 0xc7, 0xa1, 0x36, 0x2b, 0x12, 0x3a,
    /*0x00c8*/ 0x86, 0x13, 0x63, 0x94, 0xc9, 0x9a, 0x1e, 0x2e,
    /*0x00d0*/ 0x19, 0x43, 0x0c, 0xba, 0x5f, 0xad, 0x30, 0x75,
    /*0x00d8*/ 0x7e, 0xdf, 0x75, 0x0f, 0xc2, 0x66, 0x9e, 0xf7,
    /*0x00e0*/ 0x93, 0xa7, 0xae, 0x7c, 0xb3, 0xbb, 0xd3, 0x9e,
    /*0x00e8*/ 0xf8, 0x9a, 0x7d, 0x12, 0xd8, 0x63, 0x43, 0x98,
    /*0x00f0*/ 0xb1, 0x91, 0xed, 0x3b, 0x69, 0x0e, 0x12, 0xfc,
    /*0x00f8*/ 0x4d, 0xfc, 0x10, 0x0b, 0x90, 0x34, 0x06, 0x3d,
    /*0x0100*/ 0x54, 0xc8, 0x22, 0xe3, 0x4e, 0x82, 0xbc, 0x6c,
    /*0x0108*/ 0xf4, 0x5f, 0x1b, 0x00, 0xef, 0xb2, 0xb0, 0xe9,
    /*0x0110*/ 0xe1, 0xb8, 0xc3, 0x9e, 0x80, 0x2f, 0xd4, 0x51,
    /*0x0118*/ 0xdd, 0xb0, 0xa3, 0x04, 0x25, 0xfe, 0xa2, 0xcb,
    /*0x0120*/ 0xd2, 0x69, 0x0f, 0xe8, 0x64, 0x8b, 0x4c, 0xb1,
    /*0x0128*/ 0xb9, 0xd7, 0x20, 0xa1, 0x3c, 0x6e, 0x07, 0xa2,
    /*0x0130*/ 0xa8, 0xa3, 0xbc, 0x85, 0xf6, 0xec, 0xd9, 0x8a,
    /*0x0138*/ 0xec, 0x49, 0xd7, 0x10, 0x26, 0xc6, 0x8a, 0x81,
    /*0x0140*/ 0xd1, 0x87, 0x2c, 0x23, 0xe1, 0x98, 0x40, 0x9d,
    /*0x0148*/ 0x98, 0xc3, 0xbe, 0xc1, 0x7a, 0xc3, 0xfa, 0x67,
    /*0x0150*/ 0x10, 0x05, 0xdb, 0x7b, 0xd1, 0x81, 0x1c, 0x38,
    /*0x0158*/ 0xb1, 0xad, 0x2b, 0x7c, 0x69, 0xd1, 0xa0, 0x53,
    /*0x0160*/ 0x2c, 0x70, 0x15, 0xfc, 0x37, 0x21, 0x8c, 0x46,
    /*0x0168*/ 0x6d, 0x66, 0x11, 0x56, 0x63, 0x60, 0xd7, 0xc2,
    /*0x0170*/ 0x0b, 0x5a, 0x3f, 0x70, 0x9e, 0x89, 0x97, 0xaf,
    /*0x0178*/ 0x26, 0x56, 0x9d, 0x0a, 0xf0, 0x3b, 0xf6, 0xb4,
    /*0x0180*/
};
#endif /* EIP130_ENABLE_SYM_ALGO_SHA512 */

static const uint8_t message_rsa_pkcs1v15_abc[] =
{
    0x61, 0x62, 0x63
};

/* The RSA test vectors. */
static const TestVector_RSA_PKCS1v15_Rec_t test_vectors_rsa_pkcs1v15[] =
{
    { "rsa-pkcs1v15-1024-sha1", 1024, 160,
        {
            der_rsa_pkcs1v15_key_1024 + 6, 1,
            der_rsa_pkcs1v15_key_1024 + 11, 128,
            der_rsa_pkcs1v15_key_1024 + 141, 3,
            der_rsa_pkcs1v15_key_1024 + 147, 128,
            der_rsa_pkcs1v15_key_1024 + 278, 64,
            der_rsa_pkcs1v15_key_1024 + 345, 64,
            der_rsa_pkcs1v15_key_1024 + 412, 64,
            der_rsa_pkcs1v15_key_1024 + 479, 64,
            der_rsa_pkcs1v15_key_1024 + 546, 64,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_1024_sha1,
        sizeof(signature_rsa_pkcs1v15_abc_1024_sha1)
    },
    { "rsa-pkcs1v15-2048-sha1", 2048, 160,
        {
            der_rsa_pkcs1v15_key_2048 + 6, 1,
            der_rsa_pkcs1v15_key_2048 + 12, 256,
            der_rsa_pkcs1v15_key_2048 + 270, 3,
            der_rsa_pkcs1v15_key_2048 + 277, 256,
            der_rsa_pkcs1v15_key_2048 + 537, 128,
            der_rsa_pkcs1v15_key_2048 + 669, 128,
            der_rsa_pkcs1v15_key_2048 + 801, 128,
            der_rsa_pkcs1v15_key_2048 + 932, 128,
            der_rsa_pkcs1v15_key_2048 + 1063, 128,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_2048_sha1,
        sizeof(signature_rsa_pkcs1v15_abc_2048_sha1)
    },
    { "rsa-pkcs1v15-3072-sha1", 3072, 160,
        {
            der_rsa_pkcs1v15_key_3072 + 6, 1,
            der_rsa_pkcs1v15_key_3072 + 12, 384,
            der_rsa_pkcs1v15_key_3072 + 398, 3,
            der_rsa_pkcs1v15_key_3072 + 405, 384,
            der_rsa_pkcs1v15_key_3072 + 793, 192,
            der_rsa_pkcs1v15_key_3072 + 989, 192,
            der_rsa_pkcs1v15_key_3072 + 1184, 192,
            der_rsa_pkcs1v15_key_3072 + 1379, 192,
            der_rsa_pkcs1v15_key_3072 + 1574, 192,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_3072_sha1,
        sizeof(signature_rsa_pkcs1v15_abc_3072_sha1)
    },
    { "rsa-pkcs1v15-1024-sha224", 1024, 224,
        {
            der_rsa_pkcs1v15_key_1024 + 6, 1,
            der_rsa_pkcs1v15_key_1024 + 11, 128,
            der_rsa_pkcs1v15_key_1024 + 141, 3,
            der_rsa_pkcs1v15_key_1024 + 147, 128,
            der_rsa_pkcs1v15_key_1024 + 278, 64,
            der_rsa_pkcs1v15_key_1024 + 345, 64,
            der_rsa_pkcs1v15_key_1024 + 412, 64,
            der_rsa_pkcs1v15_key_1024 + 479, 64,
            der_rsa_pkcs1v15_key_1024 + 546, 64,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_1024_sha224,
        sizeof(signature_rsa_pkcs1v15_abc_1024_sha224)
    },
    { "rsa-pkcs1v15-2048-sha224", 2048, 224,
        {
            der_rsa_pkcs1v15_key_2048 + 6, 1,
            der_rsa_pkcs1v15_key_2048 + 12, 256,
            der_rsa_pkcs1v15_key_2048 + 270, 3,
            der_rsa_pkcs1v15_key_2048 + 277, 256,
            der_rsa_pkcs1v15_key_2048 + 537, 128,
            der_rsa_pkcs1v15_key_2048 + 669, 128,
            der_rsa_pkcs1v15_key_2048 + 801, 128,
            der_rsa_pkcs1v15_key_2048 + 932, 128,
            der_rsa_pkcs1v15_key_2048 + 1063, 128,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_2048_sha224,
        sizeof(signature_rsa_pkcs1v15_abc_2048_sha224)
    },
    { "rsa-pkcs1v15-3072-sha224", 3072, 224,
        {
            der_rsa_pkcs1v15_key_3072 + 6, 1,
            der_rsa_pkcs1v15_key_3072 + 12, 384,
            der_rsa_pkcs1v15_key_3072 + 398, 3,
            der_rsa_pkcs1v15_key_3072 + 405, 384,
            der_rsa_pkcs1v15_key_3072 + 793, 192,
            der_rsa_pkcs1v15_key_3072 + 989, 192,
            der_rsa_pkcs1v15_key_3072 + 1184, 192,
            der_rsa_pkcs1v15_key_3072 + 1379, 192,
            der_rsa_pkcs1v15_key_3072 + 1574, 192,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_3072_sha224,
        sizeof(signature_rsa_pkcs1v15_abc_3072_sha224)
    },
    { "rsa-pkcs1v15-1024-sha256", 1024, 256,
        {
            der_rsa_pkcs1v15_key_1024 + 6, 1,
            der_rsa_pkcs1v15_key_1024 + 11, 128,
            der_rsa_pkcs1v15_key_1024 + 141, 3,
            der_rsa_pkcs1v15_key_1024 + 147, 128,
            der_rsa_pkcs1v15_key_1024 + 278, 64,
            der_rsa_pkcs1v15_key_1024 + 345, 64,
            der_rsa_pkcs1v15_key_1024 + 412, 64,
            der_rsa_pkcs1v15_key_1024 + 479, 64,
            der_rsa_pkcs1v15_key_1024 + 546, 64,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_1024_sha256,
        sizeof(signature_rsa_pkcs1v15_abc_1024_sha256)
    },
    { "rsa-pkcs1v15-2048-sha256", 2048, 256,
        {
            der_rsa_pkcs1v15_key_2048 + 6, 1,
            der_rsa_pkcs1v15_key_2048 + 12, 256,
            der_rsa_pkcs1v15_key_2048 + 270, 3,
            der_rsa_pkcs1v15_key_2048 + 277, 256,
            der_rsa_pkcs1v15_key_2048 + 537, 128,
            der_rsa_pkcs1v15_key_2048 + 669, 128,
            der_rsa_pkcs1v15_key_2048 + 801, 128,
            der_rsa_pkcs1v15_key_2048 + 932, 128,
            der_rsa_pkcs1v15_key_2048 + 1063, 128,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_2048_sha256,
        sizeof(signature_rsa_pkcs1v15_abc_2048_sha256)
    },
    { "rsa-pkcs1v15-3072-sha256", 3072, 256,
        {
            der_rsa_pkcs1v15_key_3072 + 6, 1,
            der_rsa_pkcs1v15_key_3072 + 12, 384,
            der_rsa_pkcs1v15_key_3072 + 398, 3,
            der_rsa_pkcs1v15_key_3072 + 405, 384,
            der_rsa_pkcs1v15_key_3072 + 793, 192,
            der_rsa_pkcs1v15_key_3072 + 989, 192,
            der_rsa_pkcs1v15_key_3072 + 1184, 192,
            der_rsa_pkcs1v15_key_3072 + 1379, 192,
            der_rsa_pkcs1v15_key_3072 + 1574, 192,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_3072_sha256,
        sizeof(signature_rsa_pkcs1v15_abc_3072_sha256)
    },
#ifdef EIP130_ENABLE_SYM_ALGO_SHA512
    { "rsa-pkcs1v15-1024-sha384", 1024, 384,
        {
            der_rsa_pkcs1v15_key_1024 + 6, 1,
            der_rsa_pkcs1v15_key_1024 + 11, 128,
            der_rsa_pkcs1v15_key_1024 + 141, 3,
            der_rsa_pkcs1v15_key_1024 + 147, 128,
            der_rsa_pkcs1v15_key_1024 + 278, 64,
            der_rsa_pkcs1v15_key_1024 + 345, 64,
            der_rsa_pkcs1v15_key_1024 + 412, 64,
            der_rsa_pkcs1v15_key_1024 + 479, 64,
            der_rsa_pkcs1v15_key_1024 + 546, 64,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_1024_sha384,
        sizeof(signature_rsa_pkcs1v15_abc_1024_sha384)
    },
    { "rsa-pkcs1v15-2048-sha384", 2048, 384,
        {
            der_rsa_pkcs1v15_key_2048 + 6, 1,
            der_rsa_pkcs1v15_key_2048 + 12, 256,
            der_rsa_pkcs1v15_key_2048 + 270, 3,
            der_rsa_pkcs1v15_key_2048 + 277, 256,
            der_rsa_pkcs1v15_key_2048 + 537, 128,
            der_rsa_pkcs1v15_key_2048 + 669, 128,
            der_rsa_pkcs1v15_key_2048 + 801, 128,
            der_rsa_pkcs1v15_key_2048 + 932, 128,
            der_rsa_pkcs1v15_key_2048 + 1063, 128,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_2048_sha384,
        sizeof(signature_rsa_pkcs1v15_abc_2048_sha384)
    },
    { "rsa-pkcs1v15-3072-sha384", 3072, 384,
        {
            der_rsa_pkcs1v15_key_3072 + 6, 1,
            der_rsa_pkcs1v15_key_3072 + 12, 384,
            der_rsa_pkcs1v15_key_3072 + 398, 3,
            der_rsa_pkcs1v15_key_3072 + 405, 384,
            der_rsa_pkcs1v15_key_3072 + 793, 192,
            der_rsa_pkcs1v15_key_3072 + 989, 192,
            der_rsa_pkcs1v15_key_3072 + 1184, 192,
            der_rsa_pkcs1v15_key_3072 + 1379, 192,
            der_rsa_pkcs1v15_key_3072 + 1574, 192,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_3072_sha384,
        sizeof(signature_rsa_pkcs1v15_abc_3072_sha384)
    },
    { "rsa-pkcs1v15-1024-sha512", 1024, 512,
        {
            der_rsa_pkcs1v15_key_1024 + 6, 1,
            der_rsa_pkcs1v15_key_1024 + 11, 128,
            der_rsa_pkcs1v15_key_1024 + 141, 3,
            der_rsa_pkcs1v15_key_1024 + 147, 128,
            der_rsa_pkcs1v15_key_1024 + 278, 64,
            der_rsa_pkcs1v15_key_1024 + 345, 64,
            der_rsa_pkcs1v15_key_1024 + 412, 64,
            der_rsa_pkcs1v15_key_1024 + 479, 64,
            der_rsa_pkcs1v15_key_1024 + 546, 64,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_1024_sha512,
        sizeof(signature_rsa_pkcs1v15_abc_1024_sha512)
    },
    { "rsa-pkcs1v15-2048-sha512", 2048, 512,
        {
            der_rsa_pkcs1v15_key_2048 + 6, 1,
            der_rsa_pkcs1v15_key_2048 + 12, 256,
            der_rsa_pkcs1v15_key_2048 + 270, 3,
            der_rsa_pkcs1v15_key_2048 + 277, 256,
            der_rsa_pkcs1v15_key_2048 + 537, 128,
            der_rsa_pkcs1v15_key_2048 + 669, 128,
            der_rsa_pkcs1v15_key_2048 + 801, 128,
            der_rsa_pkcs1v15_key_2048 + 932, 128,
            der_rsa_pkcs1v15_key_2048 + 1063, 128,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_2048_sha512,
        sizeof(signature_rsa_pkcs1v15_abc_2048_sha512)
    },
    { "rsa-pkcs1v15-3072-sha512", 3072, 512,
        {
            der_rsa_pkcs1v15_key_3072 + 6, 1,
            der_rsa_pkcs1v15_key_3072 + 12, 384,
            der_rsa_pkcs1v15_key_3072 + 398, 3,
            der_rsa_pkcs1v15_key_3072 + 405, 384,
            der_rsa_pkcs1v15_key_3072 + 793, 192,
            der_rsa_pkcs1v15_key_3072 + 989, 192,
            der_rsa_pkcs1v15_key_3072 + 1184, 192,
            der_rsa_pkcs1v15_key_3072 + 1379, 192,
            der_rsa_pkcs1v15_key_3072 + 1574, 192,
        },
        message_rsa_pkcs1v15_abc, sizeof(message_rsa_pkcs1v15_abc),
        signature_rsa_pkcs1v15_abc_3072_sha512,
        sizeof(signature_rsa_pkcs1v15_abc_3072_sha512)
    },
#endif /* EIP130_ENABLE_SYM_ALGO_SHA512 */
};


//=============================================================================
// RSA PSS
// mod = 1024, SHA1
static const uint8_t rsa_pss_key_1024_SHA1_n[] =
{
    0xAE, 0x4C, 0xCE, 0x0D, 0xCE, 0x9D, 0xEB, 0xD4, 0xA3, 0xCF, 0xAE, 0x47, 0xE2, 0x7F, 0x36, 0x85,
    0xC0, 0xFD, 0xEB, 0x52, 0x74, 0x88, 0x8F, 0x4E, 0x94, 0x9A, 0x65, 0x77, 0x23, 0x94, 0x30, 0x60,
    0xCC, 0xB1, 0xA6, 0x0B, 0x05, 0xF6, 0xA6, 0x24, 0x7C, 0x81, 0xC1, 0x77, 0x22, 0x8A, 0x22, 0xE4,
    0xF2, 0x15, 0x92, 0x94, 0x12, 0x01, 0x36, 0x06, 0x6F, 0xC9, 0x9B, 0xA4, 0xCF, 0x63, 0x1F, 0x4B,
    0x1B, 0x71, 0x80, 0xF7, 0x37, 0xB2, 0x8E, 0xFA, 0xD2, 0x51, 0x26, 0xD4, 0x1B, 0xBC, 0x19, 0x75,
    0x70, 0xBE, 0x52, 0x0A, 0x92, 0x42, 0xFD, 0xB9, 0xC5, 0x0A, 0x3C, 0x3A, 0x6F, 0x2C, 0x71, 0x8A,
    0x7A, 0x21, 0x3E, 0x4D, 0xD0, 0xD9, 0xED, 0x4A, 0x28, 0xF1, 0xFE, 0x07, 0xA6, 0x2A, 0x36, 0x0E,
    0x48, 0xD3, 0x57, 0x9A, 0xDC, 0x72, 0xDA, 0x11, 0x4A, 0x6C, 0x41, 0x90, 0xB7, 0xAD, 0x81, 0x11,
};
static const uint8_t rsa_pss_key_1024_SHA1_e[] =
{
    0x00, 0xC2, 0x59, 0x55,
};
static const uint8_t rsa_pss_key_1024_SHA1_d[] =
{
    0x0D, 0x14, 0xD9, 0x56, 0x69, 0x5E, 0x78, 0xCC, 0xB1, 0xCB, 0xA3, 0x74, 0x44, 0x11, 0xF9, 0x97,
    0x3B, 0x72, 0x28, 0x33, 0x02, 0xAF, 0x5E, 0x62, 0x09, 0x74, 0xC6, 0x8E, 0xB8, 0xB0, 0x85, 0xC5,
    0xDC, 0xA6, 0x9B, 0x28, 0xAE, 0x24, 0xF4, 0x1E, 0xA4, 0x64, 0x6F, 0x93, 0x12, 0x2F, 0x93, 0x89,
    0xEE, 0x84, 0xD2, 0xE3, 0x35, 0x88, 0xE0, 0xA3, 0xA9, 0x7E, 0xCD, 0x48, 0x7A, 0x88, 0xA5, 0x63,
    0x71, 0xCA, 0x77, 0x82, 0x25, 0x9C, 0x84, 0xE5, 0x37, 0x81, 0x41, 0x02, 0xF7, 0x9F, 0xC9, 0xA5,
    0xCE, 0x8B, 0x12, 0x80, 0xF6, 0xD9, 0x24, 0xCD, 0x02, 0xCB, 0x96, 0xC6, 0xF9, 0xCE, 0xD3, 0xD7,
    0xE8, 0x68, 0xBD, 0xED, 0x6C, 0x9F, 0xE7, 0xB0, 0xBC, 0x73, 0xAD, 0xBE, 0xD1, 0x3A, 0xD2, 0x95,
    0xB0, 0x9C, 0x5A, 0xD7, 0x0B, 0xD4, 0xD4, 0x7F, 0x16, 0xE5, 0x6F, 0x31, 0x40, 0xB1, 0x34, 0xD9,
};
static const uint8_t rsa_pss_key_1024_SHA1_Msg[] =
{
    0x71, 0x28, 0x7F, 0xBA, 0x37, 0x67, 0x53, 0xCA, 0xA3, 0x8E, 0xD6, 0x90, 0x9C, 0xFC, 0xC0, 0x7B,
    0x29, 0xAB, 0xF0, 0x76, 0xD7, 0x05, 0xF7, 0x5F, 0x5C, 0xF9, 0xDA, 0xBB, 0x79, 0x4D, 0x14, 0xA8,
    0x25, 0x36, 0xDB, 0x12, 0xE7, 0x26, 0xA4, 0x2A, 0x84, 0xE5, 0xE9, 0x14, 0xDA, 0xE3, 0x2A, 0xE0,
    0x0C, 0xCD, 0x32, 0xBC, 0xDF, 0x5E, 0x9B, 0x68, 0x64, 0x78, 0x94, 0xEA, 0xD8, 0x73, 0xE2, 0x82,
    0xC8, 0xB5, 0x25, 0xE0, 0x78, 0x82, 0x5D, 0x95, 0x86, 0x16, 0xAC, 0xC8, 0xCB, 0xF1, 0x5E, 0x2A,
    0x82, 0x73, 0x26, 0x2C, 0xAC, 0xA8, 0xAA, 0x6F, 0xB3, 0x65, 0x42, 0x7B, 0x4D, 0x94, 0xFD, 0xB5,
    0xA3, 0xCC, 0xE6, 0x8B, 0xB3, 0x25, 0x85, 0xF2, 0xF2, 0x4A, 0xA8, 0x12, 0x36, 0xCF, 0x63, 0x3F,
    0xD4, 0xC5, 0x55, 0x2C, 0x05, 0x8C, 0x2D, 0x5B, 0x8F, 0xE9, 0x6D, 0xD8, 0xA1, 0x58, 0x6E, 0x27,
};
static const uint8_t rsa_pss_key_1024_SHA1_Sig[] =
{
    0xAC, 0xD0, 0x09, 0x6F, 0x55, 0xBC, 0x86, 0x62, 0x99, 0x50, 0x50, 0xDC, 0x39, 0x04, 0x36, 0x27,
    0x65, 0xFF, 0xEC, 0x0C, 0x27, 0xA8, 0x0E, 0xCE, 0x75, 0xBE, 0xC3, 0x68, 0x21, 0xD0, 0x39, 0xD2,
    0x89, 0x29, 0x7A, 0x80, 0x12, 0xB9, 0xAA, 0x74, 0xD7, 0xA9, 0x39, 0x18, 0x73, 0x5E, 0xF4, 0xC1,
    0xA6, 0xF8, 0x04, 0x5B, 0x4E, 0xC5, 0xAD, 0x31, 0xD7, 0xD0, 0x40, 0x07, 0xA3, 0x21, 0x51, 0x05,
    0x83, 0xB5, 0xA4, 0x0A, 0x1F, 0x6B, 0xFB, 0x17, 0x01, 0x6D, 0x66, 0x1A, 0x2A, 0xF0, 0x30, 0xE8,
    0xD8, 0xEC, 0x53, 0x76, 0xB3, 0x7E, 0x5F, 0x12, 0xD7, 0xB1, 0x05, 0xCD, 0x88, 0x0F, 0xC1, 0x31,
    0xAF, 0xA7, 0x47, 0x21, 0xC5, 0x49, 0xFA, 0x46, 0x4C, 0xBD, 0x5D, 0x16, 0xE5, 0xFB, 0xDB, 0xCC,
    0xA6, 0xF0, 0x90, 0x07, 0x05, 0x1E, 0x21, 0x4F, 0x37, 0x2C, 0x82, 0xAD, 0x40, 0xD2, 0x85, 0xFB,
};
#ifdef DONOT_ENABLE_DEFINE_USED_FOR_REFERENCE_ONLY
static const uint8_t rsa_pss_key_1024_SHA1_Salt[] =
{
    0x1D, 0x26, 0x84, 0xB0, 0x46, 0x61, 0xEB, 0x6E, 0x6F, 0xF9, 0x24, 0xFD, 0x59, 0xBF, 0x8E, 0xCB,
    0x03, 0xBE, 0xD6, 0x67,
};
#endif

// mod = 1024, SHA224
static const uint8_t rsa_pss_key_1024_SHA224_n[] =
{
    0xAA, 0xAB, 0x2A, 0xB6, 0xA5, 0x0E, 0xA4, 0x41, 0xB9, 0x57, 0xF1, 0x9A, 0xD2, 0x52, 0x7E, 0x27,
    0xDB, 0x86, 0x70, 0x96, 0xBD, 0xFB, 0x30, 0x26, 0xB7, 0x24, 0x01, 0xE8, 0x09, 0x10, 0x3E, 0xFB,
    0xB3, 0x37, 0x29, 0x69, 0xD1, 0x39, 0x1B, 0x9D, 0xF5, 0xCE, 0xC9, 0x5C, 0x11, 0x65, 0xF9, 0x69,
    0xC9, 0x9F, 0xFB, 0x14, 0xDB, 0x61, 0x6D, 0x49, 0xEE, 0x4B, 0xE6, 0x78, 0x81, 0x3C, 0xEF, 0xF9,
    0x6C, 0x17, 0x6E, 0x64, 0x10, 0x24, 0x39, 0xD0, 0x38, 0x95, 0x79, 0x00, 0x91, 0xAA, 0x71, 0x09,
    0x7B, 0x4E, 0xC0, 0xAD, 0xD5, 0x0A, 0x9C, 0x1B, 0x56, 0xC7, 0x41, 0xA3, 0xE3, 0x7F, 0x6B, 0xFC,
    0x1D, 0x69, 0xA7, 0xAE, 0x3E, 0x45, 0x38, 0xC5, 0xA6, 0x69, 0x99, 0xC2, 0x09, 0xF9, 0x26, 0x74,
    0xC1, 0x19, 0x09, 0x5B, 0xB0, 0x10, 0x73, 0x1B, 0x76, 0x68, 0xCD, 0x30, 0xDE, 0xF7, 0x4A, 0xCF,
};
static const uint8_t rsa_pss_key_1024_SHA224_e[] =
{
    0x00, 0x5F, 0xF3, 0x3D,
};
static const uint8_t rsa_pss_key_1024_SHA224_d[] =
{
    0x15, 0xF6, 0x8A, 0x1F, 0x25, 0x14, 0x15, 0x43, 0xF2, 0x74, 0x7A, 0xC7, 0x49, 0x75, 0xF2, 0xDF,
    0xE1, 0xB7, 0x4C, 0x1B, 0xB9, 0x8F, 0x09, 0xAF, 0xE7, 0x1D, 0xD0, 0x22, 0xAE, 0x06, 0xA1, 0x40,
    0xCF, 0x65, 0x47, 0x94, 0xF5, 0x9B, 0xB6, 0xC0, 0x7C, 0x71, 0x9B, 0xDB, 0x1A, 0x2A, 0x88, 0x2E,
    0x88, 0x61, 0x27, 0x88, 0x55, 0x6F, 0x2B, 0x6B, 0x22, 0x94, 0x59, 0x4A, 0x8E, 0x90, 0xB2, 0x29,
    0xA0, 0x6C, 0xA6, 0xD8, 0xE6, 0x36, 0xBE, 0x37, 0xB7, 0x33, 0x66, 0xD9, 0xA2, 0xD9, 0x17, 0x33,
    0x58, 0x29, 0xEB, 0xB0, 0x57, 0x28, 0x45, 0xEF, 0x46, 0xE0, 0xEB, 0x09, 0xE9, 0xA9, 0x7D, 0x50,
    0x21, 0x22, 0x29, 0x49, 0x46, 0x8E, 0x53, 0xC3, 0x29, 0x50, 0xA1, 0xB6, 0x23, 0x44, 0x54, 0xB0,
    0x9C, 0x29, 0x22, 0x81, 0x08, 0xC4, 0x89, 0x34, 0xBF, 0x7A, 0x9D, 0xFE, 0x86, 0x10, 0x34, 0x15,
};
static const uint8_t rsa_pss_key_1024_SHA224_Msg[] =
{
    0x54, 0x96, 0xAF, 0x7B, 0xC0, 0x20, 0xE3, 0xA0, 0x48, 0xE4, 0xC6, 0xB0, 0x30, 0x25, 0x59, 0x36,
    0x29, 0xE1, 0x74, 0x35, 0x74, 0x61, 0x0D, 0x61, 0x4A, 0x0E, 0xB7, 0x8F, 0x7C, 0x86, 0x69, 0x6B,
    0x57, 0xEF, 0x81, 0x69, 0xCA, 0x8C, 0x08, 0xFE, 0xCB, 0x8D, 0x38, 0x0F, 0xF6, 0x2C, 0x3B, 0xAA,
    0x77, 0xF5, 0x36, 0xF4, 0x2B, 0x65, 0x86, 0x62, 0x02, 0xB7, 0x4A, 0x2C, 0xA8, 0xFB, 0x21, 0xFF,
    0x64, 0x68, 0x35, 0xF3, 0x40, 0xF3, 0x78, 0xBC, 0x6A, 0x21, 0x2D, 0x24, 0xDA, 0x19, 0xAB, 0xB9,
    0x35, 0xFD, 0x5D, 0xC2, 0xF1, 0x7A, 0x0E, 0x78, 0xBB, 0x9E, 0x63, 0x73, 0x15, 0xEA, 0xA9, 0x63,
    0x44, 0xA9, 0xD1, 0x00, 0x69, 0x80, 0xB9, 0x44, 0xEE, 0x45, 0xAE, 0xD7, 0x23, 0x14, 0x2E, 0xCB,
    0x29, 0xA0, 0xF2, 0x89, 0x10, 0xC8, 0x2C, 0x0B, 0x3C, 0x6B, 0x0D, 0x4C, 0x0D, 0x7C, 0x8A, 0xFD,
};
static const uint8_t rsa_pss_key_1024_SHA224_Sig[] =
{
    0x2A, 0x21, 0x4C, 0xF4, 0x18, 0x96, 0x1F, 0x54, 0xE8, 0x37, 0x63, 0x33, 0x49, 0xE8, 0xCB, 0x3B,
    0x4E, 0x2C, 0x80, 0x65, 0xF3, 0x33, 0x6D, 0xE4, 0xFE, 0x08, 0x37, 0xBA, 0x5A, 0xD2, 0x75, 0x19,
    0x15, 0x38, 0xE7, 0xCD, 0x3C, 0x11, 0xA5, 0x7D, 0xA8, 0x7A, 0xA5, 0x63, 0x32, 0x5B, 0x2A, 0x67,
    0xF5, 0xFF, 0xA8, 0x86, 0x85, 0x84, 0x74, 0x9E, 0x06, 0x35, 0x85, 0xEC, 0x8F, 0x96, 0x21, 0x8C,
    0xF7, 0x5A, 0x99, 0x43, 0x78, 0x6F, 0x9B, 0x0D, 0x6B, 0xD1, 0xF0, 0x38, 0xF0, 0xEF, 0xAB, 0x8E,
    0x8C, 0x69, 0x32, 0xC2, 0xFC, 0x30, 0x2E, 0x57, 0xC1, 0x7F, 0x29, 0x34, 0xC9, 0x03, 0x56, 0x95,
    0xAD, 0x14, 0x25, 0x70, 0x94, 0x68, 0x9D, 0x87, 0x47, 0xD5, 0xA4, 0xA4, 0xA9, 0x06, 0x90, 0xCE,
    0xD6, 0xFC, 0x2A, 0x4E, 0xC1, 0xB1, 0x01, 0x4C, 0x24, 0x96, 0xC2, 0xFC, 0x12, 0xF5, 0x07, 0xAB,
};
#ifdef DONOT_ENABLE_DEFINE_USED_FOR_REFERENCE_ONLY
static const uint8_t rsa_pss_key_1024_SHA224_Salt[] =
{
    0x1D, 0x26, 0x84, 0xB0, 0x46, 0x61, 0xEB, 0x6E, 0x6F, 0xF9, 0x24, 0xFD, 0x59, 0xBF, 0x8E, 0xCB,
    0x03, 0xBE, 0xD6, 0x67, 0x16, 0x12, 0x75, 0xF1, 0x7F, 0xFE, 0x7A, 0xD0,
};
#endif

// mod = 1024, SHA256
static const uint8_t rsa_pss_key_1024_SHA256_n[] =
{
    0xA1, 0xC8, 0x8E, 0x5F, 0x47, 0x41, 0x39, 0x9C, 0xEF, 0xB8, 0xE1, 0x37, 0xE8, 0x21, 0xF3, 0xB3,
    0x9F, 0x69, 0x5B, 0xDF, 0x46, 0x09, 0xF8, 0xE2, 0x38, 0x09, 0xF4, 0x4A, 0x6E, 0x08, 0xF9, 0x75,
    0xD1, 0x52, 0xCD, 0x45, 0xCC, 0x8E, 0xDC, 0xCD, 0x83, 0xCF, 0xF4, 0xD5, 0x9C, 0x31, 0xA4, 0x71,
    0x57, 0xFE, 0x82, 0xBC, 0xA9, 0x83, 0xF3, 0x6A, 0xF3, 0xA3, 0x60, 0x17, 0xC1, 0x1A, 0xF2, 0xB1,
    0x6A, 0xA8, 0xF3, 0x39, 0xA8, 0xF7, 0x57, 0x9E, 0x0C, 0x2E, 0x73, 0xEB, 0x30, 0x42, 0x68, 0x05,
    0x1E, 0x8B, 0xE1, 0x12, 0x8B, 0xE3, 0x83, 0xEA, 0x92, 0x0D, 0xD0, 0x79, 0x05, 0x45, 0xBE, 0x31,
    0x60, 0xE3, 0x45, 0x95, 0x63, 0x7C, 0x30, 0x40, 0xAA, 0x7B, 0xEE, 0x4C, 0xE7, 0x31, 0xD5, 0xD9,
    0x08, 0xB4, 0x46, 0xB5, 0xAE, 0x59, 0xCE, 0xFD, 0xAD, 0x6F, 0xD6, 0x0A, 0xC0, 0x28, 0xA4, 0xB9,
};
static const uint8_t rsa_pss_key_1024_SHA256_e[] =
{
    0x00, 0x4E, 0x2C, 0x11,
};
static const uint8_t rsa_pss_key_1024_SHA256_d[] =
{
    0x00, 0x71, 0xD9, 0x1A, 0xAA, 0x58, 0x5C, 0xB5, 0xAC, 0xA4, 0x87, 0xCF, 0xDF, 0x4E, 0xB1, 0x74,
    0xD1, 0x6C, 0xC4, 0x96, 0x4E, 0x7A, 0xD7, 0xCC, 0xE1, 0xDC, 0xD0, 0x05, 0xE4, 0xC5, 0x7C, 0x7A,
    0xEA, 0x75, 0x22, 0x67, 0x7F, 0xE3, 0x39, 0xD9, 0x26, 0xEB, 0x81, 0x47, 0xE3, 0x05, 0xED, 0x9A,
    0x52, 0x59, 0x44, 0x12, 0x70, 0x9B, 0x06, 0x44, 0xD0, 0x7E, 0x33, 0xDB, 0xAF, 0x6C, 0x74, 0x68,
    0xDB, 0xED, 0x76, 0x85, 0x2C, 0x01, 0xA8, 0x42, 0x9D, 0x50, 0x47, 0x57, 0x25, 0x5C, 0x6A, 0x9C,
    0x06, 0xAC, 0x9A, 0xD0, 0x2C, 0x50, 0x57, 0x42, 0x9E, 0x7D, 0xAF, 0xEF, 0x02, 0x02, 0xC6, 0x43,
    0x32, 0x72, 0xF2, 0x7E, 0x70, 0x1A, 0x79, 0xED, 0x43, 0x15, 0x9C, 0x68, 0x3F, 0x33, 0xE3, 0xD6,
    0x01, 0x5E, 0x8F, 0xF5, 0x32, 0x5D, 0xE1, 0xC7, 0xCA, 0x3E, 0xE4, 0xB3, 0x26, 0x26, 0xD3, 0x35,
};
static const uint8_t rsa_pss_key_1024_SHA256_Msg[] =
{
    0x55, 0xD3, 0x7A, 0xD1, 0xDA, 0xC9, 0x4F, 0x73, 0xD3, 0x7C, 0x91, 0xD0, 0x8D, 0x1E, 0x85, 0xAF,
    0x02, 0xC7, 0xA8, 0x24, 0x45, 0x55, 0x39, 0x06, 0x21, 0x76, 0xF7, 0xA4, 0xFD, 0x03, 0x2C, 0xB4,
    0x03, 0x90, 0xEA, 0x8C, 0x82, 0x41, 0x95, 0x95, 0x90, 0xDF, 0xA1, 0xFC, 0xF3, 0x2A, 0x9D, 0xAA,
    0x42, 0x71, 0x71, 0x77, 0x47, 0x61, 0xE4, 0x9A, 0xA8, 0x1B, 0x61, 0x64, 0xC6, 0x89, 0xFA, 0x2F,
    0xE6, 0xF1, 0xAD, 0x91, 0x8F, 0xCA, 0xE6, 0xD5, 0x32, 0xCF, 0x46, 0xAB, 0x11, 0x53, 0xA3, 0x1E,
    0x59, 0xD4, 0x50, 0xC7, 0x91, 0xD2, 0x9E, 0x40, 0x38, 0xE1, 0xA2, 0xDC, 0xAA, 0xFE, 0x39, 0x95,
    0x44, 0x1F, 0x4A, 0x46, 0xC8, 0x0E, 0x4B, 0x1B, 0x03, 0x76, 0x07, 0x45, 0xAD, 0x3E, 0x9E, 0xF2,
    0x90, 0x17, 0xCD, 0x7C, 0xED, 0x51, 0x6F, 0xE0, 0x1B, 0xF3, 0x44, 0x73, 0x71, 0x0A, 0xF2, 0xD0,
};
static const uint8_t rsa_pss_key_1024_SHA256_Sig[] =
{
    0x7F, 0x7A, 0x2D, 0x82, 0x26, 0x7F, 0xDF, 0x70, 0xF6, 0x23, 0x66, 0xA4, 0x1E, 0x0A, 0x85, 0xD9,
    0xBD, 0x55, 0xDF, 0xDA, 0x38, 0xDE, 0x73, 0x0C, 0xB1, 0x75, 0x1D, 0x28, 0x87, 0x06, 0x6A, 0xE6,
    0xAD, 0x93, 0xBA, 0xCC, 0x0B, 0x0C, 0x2F, 0xCC, 0xEB, 0x22, 0xC5, 0x79, 0xB9, 0xF5, 0xBB, 0xC3,
    0x05, 0xE6, 0xE0, 0x6D, 0x54, 0x83, 0xEF, 0x04, 0x85, 0xC3, 0x2B, 0x20, 0x85, 0x1B, 0x78, 0x1F,
    0x61, 0x43, 0x7F, 0x2D, 0xA5, 0x59, 0x1D, 0xC7, 0x75, 0x51, 0xD9, 0xDD, 0xD8, 0xB0, 0x17, 0x53,
    0x21, 0xF1, 0x6A, 0x13, 0x42, 0x87, 0x0F, 0x9B, 0xF4, 0x60, 0x1B, 0x72, 0x3A, 0x61, 0x33, 0xC6,
    0x1B, 0xAD, 0xF3, 0xB8, 0x54, 0x39, 0xA4, 0xB8, 0x52, 0xE3, 0xE7, 0x85, 0x62, 0xE4, 0x35, 0x97,
    0x47, 0x9F, 0x80, 0x25, 0x4B, 0xD1, 0x4B, 0x94, 0xC5, 0xDE, 0xA5, 0x07, 0x33, 0xC8, 0xDD, 0x3B,
};
#ifdef DONOT_ENABLE_DEFINE_USED_FOR_REFERENCE_ONLY
static const uint8_t rsa_pss_key_1024_SHA256_Salt[] =
{
    0xF7, 0x36, 0xE1, 0x9C, 0x68, 0x78, 0x9F, 0x16, 0x15, 0x5E, 0x64, 0x9F, 0x33, 0x1B, 0x2A, 0x98,
    0xAE, 0xB8, 0x64, 0xF3, 0xC1, 0x5A, 0x36, 0x97, 0xC3, 0xC4, 0xE5, 0x06, 0x44, 0x1C, 0x8D, 0x3D,
};
#endif

// mod = 2048, SHA1
static const uint8_t rsa_pss_key_2048_SHA1_n[] =
{
    0x9F, 0x9C, 0xC4, 0xC7, 0xEC, 0x4B, 0xA3, 0xD7, 0x15, 0x56, 0x63, 0xFC, 0xA8, 0xDF, 0xEB, 0xB8,
    0xF9, 0xD2, 0xDC, 0xDB, 0x21, 0xC5, 0x43, 0xBC, 0x23, 0xC8, 0xAD, 0x12, 0x32, 0xFB, 0x9D, 0x2F,
    0xFF, 0x94, 0xA8, 0x35, 0x68, 0x32, 0x26, 0x80, 0xB3, 0xD8, 0x62, 0xC2, 0x73, 0x02, 0xBA, 0xE6,
    0x9D, 0x89, 0x2D, 0x23, 0xA2, 0x69, 0x39, 0xDE, 0x05, 0xDF, 0x7E, 0x3C, 0x31, 0x95, 0x82, 0xDF,
    0xE8, 0xDB, 0x11, 0x95, 0x0E, 0x3F, 0x7C, 0x9F, 0xA7, 0xE1, 0xCD, 0xB6, 0x0C, 0xD7, 0x2B, 0x0F,
    0x08, 0x85, 0xC6, 0x92, 0x26, 0x3C, 0x4E, 0x1E, 0x82, 0x9F, 0xF0, 0x01, 0x92, 0x6A, 0x77, 0x2C,
    0xF4, 0x4F, 0xBF, 0x8B, 0xC1, 0x9D, 0x11, 0x68, 0xAB, 0x36, 0x72, 0x3B, 0xFF, 0x58, 0x78, 0x7E,
    0x0F, 0xCE, 0x6A, 0xFA, 0x1B, 0xA0, 0xCD, 0x69, 0x48, 0x8D, 0xCA, 0x66, 0xDC, 0x32, 0x26, 0xF8,
    0x66, 0x09, 0x21, 0x05, 0xB4, 0xBD, 0x7A, 0xE2, 0xDC, 0x0C, 0x73, 0x06, 0x92, 0xD1, 0xAB, 0xC5,
    0x6B, 0xC7, 0x4E, 0x5C, 0x58, 0xF4, 0x21, 0xD0, 0x40, 0x00, 0xB1, 0xBA, 0xFA, 0x19, 0x53, 0x8E,
    0xD2, 0x92, 0x46, 0x5A, 0xC7, 0x2F, 0x32, 0xD9, 0x37, 0x48, 0xCB, 0x23, 0x00, 0x32, 0x2B, 0x91,
    0x61, 0xE6, 0xA2, 0x58, 0x59, 0xE2, 0x78, 0xA4, 0x9A, 0xE9, 0x39, 0x92, 0xBA, 0x06, 0xFC, 0x8F,
    0x26, 0x82, 0x01, 0x0D, 0xEC, 0xBE, 0xE4, 0xBD, 0x42, 0x97, 0xD6, 0x86, 0xCC, 0xB4, 0x1F, 0x90,
    0xB2, 0x73, 0xD4, 0x55, 0xFE, 0xD9, 0xC6, 0x40, 0x1E, 0xEF, 0x8A, 0xE5, 0xC3, 0x04, 0xF9, 0x3E,
    0x95, 0x2C, 0x1C, 0x6E, 0xA0, 0x84, 0x0D, 0x58, 0xCC, 0x99, 0xC6, 0xB2, 0xDF, 0x20, 0xEE, 0x78,
    0x25, 0x29, 0x0B, 0xB4, 0xEE, 0xB6, 0xA7, 0xDD, 0x93, 0x7F, 0xBF, 0x79, 0x1E, 0xEB, 0xC9, 0xB7,
};
static const uint8_t rsa_pss_key_2048_SHA1_e[] =
{
    0x00, 0xE3, 0xFA, 0x09,
};
static const uint8_t rsa_pss_key_2048_SHA1_d[] =
{
    0x05, 0xD7, 0x23, 0x63, 0xBB, 0xA3, 0x1D, 0xB8, 0x29, 0x76, 0xF3, 0x61, 0x05, 0xB8, 0x88, 0x12,
    0x0A, 0x11, 0xEC, 0xA9, 0x6F, 0x66, 0x8C, 0xD3, 0xBF, 0xC0, 0x55, 0x38, 0x67, 0x9D, 0x83, 0xE6,
    0x9B, 0x8E, 0x5B, 0xBA, 0x89, 0x10, 0xBF, 0x3D, 0x5E, 0x0C, 0x82, 0x0A, 0xE4, 0x13, 0x25, 0x42,
    0x18, 0x1A, 0xED, 0xE6, 0xE2, 0x6A, 0x8B, 0x9B, 0xCF, 0x2D, 0x97, 0x3B, 0xA1, 0x86, 0xD3, 0x19,
    0x6E, 0xB1, 0x5E, 0x2A, 0x06, 0x23, 0x0E, 0x17, 0xD5, 0x11, 0x0B, 0x8C, 0xEC, 0xFF, 0x19, 0x32,
    0x0E, 0x11, 0x3D, 0xAF, 0xEE, 0x65, 0x06, 0x58, 0x6B, 0xFC, 0x07, 0x76, 0x31, 0x16, 0xDD, 0xC2,
    0xB4, 0x83, 0xD3, 0xC7, 0x6D, 0xDB, 0x74, 0xDF, 0x6C, 0x9E, 0x7B, 0x7D, 0xBD, 0x8D, 0xF1, 0x43,
    0xB4, 0x6A, 0x17, 0x8E, 0x99, 0x58, 0x51, 0x36, 0x69, 0xD6, 0xC4, 0x94, 0x4E, 0x9D, 0xF7, 0x81,
    0xE1, 0xCF, 0xEC, 0xB7, 0xDD, 0xEB, 0x93, 0x6B, 0xC1, 0x76, 0xBF, 0xDF, 0xF3, 0x0F, 0xC4, 0x1F,
    0x7D, 0x85, 0x6F, 0x6E, 0xDB, 0xBF, 0x1A, 0xCE, 0xF5, 0x10, 0x95, 0xDB, 0x17, 0xA7, 0xA2, 0x94,
    0xF6, 0x09, 0x9A, 0x42, 0x8D, 0xDA, 0xE3, 0xA0, 0x3E, 0x3F, 0xFA, 0x2B, 0x8E, 0x89, 0x9D, 0xF8,
    0x02, 0xCF, 0x3C, 0xAE, 0xC5, 0x40, 0x55, 0x1C, 0xC3, 0x89, 0x47, 0x8A, 0x94, 0x5F, 0x93, 0xFC,
    0x12, 0x27, 0x7C, 0x66, 0x59, 0x3B, 0x47, 0xAF, 0xC2, 0x32, 0x1D, 0xC8, 0x82, 0xA6, 0xB2, 0xD9,
    0xC4, 0xE5, 0xE2, 0xA9, 0xBF, 0x48, 0x4D, 0xBE, 0xF5, 0x4E, 0x92, 0xEB, 0x2B, 0xED, 0xD6, 0x0C,
    0x8C, 0xEA, 0x4A, 0x90, 0xAF, 0x08, 0xA6, 0x02, 0x18, 0x40, 0xC0, 0x3A, 0x6E, 0x1E, 0x61, 0xEE,
    0x89, 0xD2, 0x6A, 0xA8, 0x54, 0xA4, 0xD8, 0x8D, 0x57, 0xA0, 0x54, 0x87, 0xA3, 0x0A, 0xBD, 0x21,
};
static const uint8_t rsa_pss_key_2048_SHA1_Msg[] =
{
    0xA4, 0xB5, 0x23, 0xA8, 0xA0, 0x56, 0xCA, 0x59, 0xD5, 0x14, 0xB0, 0x84, 0x02, 0xCA, 0x18, 0xEE,
    0x20, 0x9A, 0x6B, 0xEA, 0x8A, 0x82, 0x80, 0x87, 0x61, 0x30, 0x1A, 0x08, 0x2F, 0x18, 0xB2, 0x94,
    0xCA, 0xC3, 0x77, 0x2F, 0x7C, 0x6A, 0x94, 0xE9, 0x60, 0xC3, 0xB1, 0x55, 0x0F, 0x1B, 0xBC, 0x3D,
    0x7C, 0xA5, 0xE9, 0x94, 0x1D, 0x12, 0xF7, 0xAC, 0x4C, 0x61, 0xB6, 0xAA, 0xEC, 0xF9, 0xC6, 0x36,
    0x4F, 0xF5, 0xA1, 0x77, 0x57, 0xBF, 0xDB, 0x3E, 0xDC, 0xE0, 0xA9, 0x81, 0x4E, 0x16, 0xA1, 0x0C,
    0x9C, 0xA7, 0xC0, 0x73, 0x54, 0xF6, 0xB1, 0x4B, 0x0B, 0x54, 0x4C, 0x99, 0xFF, 0x18, 0x5E, 0x8B,
    0xFB, 0xF2, 0xA8, 0x66, 0x7B, 0x7C, 0x2A, 0xC0, 0x11, 0x12, 0xA1, 0xEF, 0x07, 0xE4, 0x4E, 0xC1,
    0x46, 0x49, 0xF9, 0x6E, 0x76, 0x57, 0x36, 0xCA, 0x67, 0xB0, 0xE7, 0xBF, 0xB0, 0x9E, 0x02, 0xFB,
};
static const uint8_t rsa_pss_key_2048_SHA1_Sig[] =
{
    0x72, 0x4F, 0xFF, 0xD9, 0xCF, 0xCB, 0x66, 0xEA, 0x40, 0x59, 0x08, 0xE2, 0x06, 0x49, 0x61, 0xF4,
    0x2C, 0xC8, 0x0E, 0xB4, 0xF2, 0x19, 0x9B, 0x5F, 0x5E, 0x14, 0x45, 0xFF, 0xF4, 0x3F, 0xEB, 0x61,
    0xCE, 0xF1, 0xE8, 0xB8, 0xED, 0x7D, 0xF6, 0xCD, 0x6E, 0x72, 0x15, 0x36, 0xA0, 0x71, 0x2B, 0xC7,
    0x14, 0xA9, 0x3D, 0x69, 0x7E, 0x3D, 0xEB, 0xEC, 0xA2, 0x68, 0x79, 0x77, 0x92, 0x64, 0xD7, 0xDF,
    0xA7, 0xEA, 0x5F, 0xDF, 0x39, 0x5E, 0xAB, 0x77, 0x0D, 0x46, 0x0D, 0x60, 0x89, 0x4B, 0x62, 0x86,
    0x95, 0x71, 0xCD, 0xA9, 0x53, 0x28, 0xFE, 0x12, 0x97, 0x0F, 0x5A, 0x43, 0x0F, 0x84, 0x61, 0x71,
    0xBC, 0x47, 0xB0, 0x2C, 0xE9, 0xE2, 0xCA, 0xEA, 0x89, 0xCF, 0xAF, 0xD3, 0xA7, 0x90, 0x5C, 0x01,
    0xDC, 0x8A, 0x53, 0xC9, 0x2D, 0x57, 0xB6, 0x58, 0x68, 0xA1, 0x72, 0x16, 0x75, 0xB9, 0xDE, 0x63,
    0x72, 0x56, 0x64, 0x1D, 0xB9, 0xA3, 0xCF, 0xAC, 0xEE, 0xB0, 0xF8, 0x97, 0x17, 0xED, 0xA1, 0xC7,
    0x8F, 0x04, 0x1D, 0xA4, 0xB7, 0xB7, 0xA9, 0xF9, 0xEF, 0xD8, 0x17, 0xF8, 0x47, 0xC9, 0xB6, 0x03,
    0x32, 0x32, 0x1E, 0xE6, 0x1F, 0xB0, 0x77, 0xF2, 0x0B, 0x5C, 0x1A, 0x41, 0x74, 0x2E, 0x78, 0xE8,
    0x72, 0xCA, 0x21, 0xF1, 0xD0, 0x58, 0x0F, 0x49, 0xEF, 0x0F, 0x2E, 0x53, 0x21, 0x75, 0x18, 0xA5,
    0x23, 0xC4, 0x6A, 0xA4, 0xCA, 0x9C, 0xBA, 0xD1, 0x4A, 0x04, 0x89, 0x1F, 0x59, 0x5A, 0x52, 0x3C,
    0xAE, 0xB8, 0x2B, 0x4B, 0x6A, 0xD1, 0xE6, 0x24, 0xAC, 0x55, 0x23, 0x1F, 0x5C, 0x7E, 0x22, 0x8A,
    0xFA, 0x26, 0xB6, 0x1D, 0xF9, 0x93, 0x71, 0x16, 0x5E, 0xE8, 0xB1, 0x58, 0x06, 0x39, 0x85, 0xAF,
    0x5D, 0x0D, 0xCE, 0xCE, 0x16, 0xB4, 0xAF, 0x80, 0x4E, 0x69, 0x72, 0x7B, 0x25, 0x53, 0xB1, 0x9E,
};
#ifdef DONOT_ENABLE_DEFINE_USED_FOR_REFERENCE_ONLY
static const uint8_t rsa_pss_key_2048_SHA1_Salt[] =
{
    0x9D, 0xA3, 0x96, 0x59, 0x26, 0xB1, 0xAE, 0x89, 0x75, 0x6A, 0xD1, 0x7C, 0xCB, 0x1B, 0xE3, 0x14,
    0xD2, 0xD7, 0x7E, 0x1A,
};
#endif

// mod = 2048, SHA224
static const uint8_t rsa_pss_key_2048_SHA224_n[] =
{
    0xD7, 0xD1, 0x13, 0x83, 0x78, 0xE9, 0xA2, 0x0D, 0x7A, 0x78, 0x61, 0xB4, 0xE2, 0xF0, 0x4B, 0xA9,
    0x94, 0xB2, 0x1D, 0x3F, 0x88, 0x74, 0xC4, 0xF1, 0x39, 0xB3, 0x71, 0x07, 0xA7, 0x78, 0x2F, 0xF7,
    0x3D, 0xBE, 0x71, 0xB4, 0x30, 0x22, 0xDD, 0xAC, 0x2A, 0x21, 0x22, 0xE7, 0x97, 0x9D, 0x08, 0xA6,
    0x80, 0xC1, 0x01, 0x0A, 0x29, 0x0A, 0x99, 0x68, 0xBE, 0x2A, 0x2A, 0xD5, 0xAC, 0x5C, 0xED, 0xC5,
    0x9B, 0x79, 0x96, 0x93, 0x7B, 0xF6, 0x74, 0xA0, 0xD0, 0xCD, 0x68, 0x68, 0x7C, 0x96, 0x0F, 0x99,
    0x93, 0x25, 0x0D, 0x21, 0x83, 0x99, 0xCA, 0x68, 0x10, 0x16, 0xAB, 0x9B, 0xA4, 0x59, 0x53, 0x95,
    0x37, 0x5F, 0x65, 0x4F, 0x23, 0x24, 0x51, 0x73, 0x66, 0xA5, 0x57, 0x02, 0x38, 0xAC, 0x98, 0x52,
    0x75, 0xAC, 0x5C, 0xA2, 0x2F, 0xFA, 0x12, 0x8E, 0x8D, 0xB7, 0xF3, 0xB6, 0x14, 0x94, 0x31, 0xCE,
    0x70, 0x1F, 0x02, 0xD6, 0x23, 0x6E, 0x88, 0x69, 0x7F, 0xFA, 0x6C, 0xE9, 0x34, 0x86, 0x70, 0x90,
    0x4C, 0x5E, 0xB4, 0xBD, 0xAA, 0x4C, 0xC6, 0x76, 0xB9, 0x2D, 0x91, 0xD1, 0x96, 0x6A, 0x55, 0x7D,
    0xCC, 0x9D, 0x58, 0x5C, 0xE3, 0xFA, 0x2C, 0x90, 0x53, 0x96, 0x1B, 0x8E, 0x63, 0x94, 0x8A, 0xAB,
    0xA9, 0xE9, 0x0B, 0x27, 0xA1, 0xDC, 0x78, 0x9D, 0x43, 0x98, 0x49, 0x7D, 0xA2, 0xA5, 0x3A, 0x98,
    0x38, 0xBA, 0x26, 0x09, 0xFB, 0x3E, 0xB3, 0x4F, 0x15, 0x50, 0x96, 0x84, 0x56, 0x1A, 0x8E, 0x30,
    0x61, 0xC4, 0xF7, 0x74, 0xAB, 0x99, 0x48, 0x9A, 0x0E, 0xDC, 0x12, 0x9A, 0xB7, 0x44, 0xA1, 0x03,
    0x90, 0xDB, 0xED, 0x24, 0xC6, 0xCE, 0xA4, 0xC8, 0x15, 0x31, 0x92, 0x22, 0x66, 0x80, 0xD7, 0xB8,
    0xA3, 0xD8, 0x96, 0x8B, 0x2C, 0x91, 0x72, 0xAC, 0x3D, 0x87, 0x04, 0xF2, 0xAC, 0x06, 0x25, 0xC5,
};
static const uint8_t rsa_pss_key_2048_SHA224_e[] =
{
    0x00, 0xB6, 0xCB, 0x7D,
};
static const uint8_t rsa_pss_key_2048_SHA224_d[] =
{
    0x01, 0x94, 0x2C, 0xE3, 0x29, 0x44, 0x1C, 0x18, 0xF9, 0xF2, 0x39, 0x4C, 0x87, 0xC5, 0xCF, 0x63,
    0x40, 0x64, 0x5B, 0x00, 0x50, 0xC8, 0x6D, 0x72, 0x67, 0xA5, 0x16, 0x0B, 0x23, 0x31, 0x7C, 0xB3,
    0xC4, 0xAF, 0x94, 0x58, 0xE6, 0xE5, 0x5B, 0x6B, 0x47, 0x31, 0x45, 0x93, 0x99, 0xAB, 0xF1, 0x6F,
    0x64, 0x5C, 0x1A, 0xF9, 0x62, 0xCD, 0xD8, 0x68, 0xF1, 0x6A, 0x33, 0x6F, 0x4B, 0xBE, 0x9D, 0x0F,
    0x70, 0xDC, 0x72, 0xB2, 0x5E, 0x36, 0x0A, 0x71, 0xE0, 0xBD, 0x71, 0xE9, 0x91, 0xF6, 0xC6, 0x55,
    0xDC, 0xBD, 0x31, 0x26, 0x5E, 0x33, 0xBE, 0x97, 0xDD, 0x19, 0x8E, 0xA7, 0xAC, 0xF3, 0x83, 0x30,
    0x7E, 0x79, 0x97, 0xDA, 0x20, 0x7C, 0x2D, 0xE8, 0xF4, 0xF4, 0x7D, 0xA8, 0x79, 0x4E, 0x6A, 0x3F,
    0xE5, 0xBF, 0xB0, 0xE6, 0x03, 0xDD, 0xDB, 0x11, 0xF7, 0x6E, 0x2A, 0x93, 0x0A, 0xEC, 0xE4, 0x14,
    0x2F, 0x2E, 0xBF, 0x19, 0xB8, 0xD9, 0xB1, 0xE0, 0xF5, 0xE3, 0x0B, 0xB8, 0x04, 0x8A, 0x35, 0xE0,
    0x99, 0x78, 0xDB, 0x1D, 0x7B, 0x8E, 0xF2, 0x4D, 0x1F, 0x71, 0xD0, 0xB9, 0x66, 0xC7, 0x28, 0xBC,
    0x6E, 0xB9, 0xE4, 0x2B, 0x29, 0x73, 0x8B, 0x5D, 0x16, 0xAE, 0x56, 0x17, 0x61, 0x61, 0x50, 0x6B,
    0x49, 0x54, 0xFE, 0x8E, 0x79, 0xC7, 0x7B, 0xDD, 0xD1, 0x8E, 0x9A, 0x10, 0x1E, 0x52, 0x7D, 0x11,
    0x12, 0x01, 0x97, 0xA9, 0x03, 0xF4, 0xCC, 0xC1, 0x17, 0x06, 0x40, 0x32, 0x8D, 0x39, 0xA2, 0x41,
    0xF5, 0x08, 0xAA, 0x11, 0x05, 0xB0, 0xB5, 0x9D, 0x25, 0x73, 0xDD, 0x86, 0x71, 0x1A, 0x66, 0xB0,
    0xCD, 0xB3, 0xC5, 0x8F, 0x11, 0xDB, 0xAE, 0x1C, 0x7F, 0x78, 0x73, 0xF3, 0x8A, 0x47, 0x28, 0x5D,
    0xBC, 0x4B, 0x36, 0xA2, 0x39, 0xC4, 0xAD, 0xCC, 0xE7, 0x55, 0xB7, 0x67, 0x23, 0x44, 0x86, 0xB5,
};
static const uint8_t rsa_pss_key_2048_SHA224_Msg[] =
{
    0x7B, 0x6B, 0x11, 0x73, 0x3F, 0x31, 0xC9, 0x69, 0x43, 0xB3, 0xD7, 0xC1, 0xF2, 0xC1, 0x9A, 0xEF,
    0x40, 0x90, 0x45, 0xED, 0x8E, 0x0C, 0xDF, 0x30, 0xCE, 0x6F, 0x8E, 0xDC, 0xE7, 0x13, 0x14, 0x34,
    0x5B, 0x84, 0x9A, 0x54, 0x27, 0xDA, 0xAD, 0x22, 0xEB, 0x46, 0x86, 0x82, 0x4A, 0xEA, 0x8E, 0xC9,
    0x94, 0xEE, 0x21, 0x75, 0xA2, 0xD0, 0x92, 0x1B, 0x02, 0xFB, 0x70, 0xA0, 0x55, 0x9C, 0x08, 0xAC,
    0xF4, 0xB1, 0x2B, 0x5C, 0xDA, 0x62, 0x32, 0x37, 0xBE, 0x95, 0x3E, 0x64, 0x7F, 0xBD, 0xC5, 0x1A,
    0xC5, 0xF2, 0x4A, 0x57, 0xE6, 0x47, 0x6B, 0xD5, 0x06, 0x58, 0x21, 0x3A, 0x83, 0x22, 0x44, 0x8E,
    0x90, 0x18, 0x4D, 0xF3, 0x1F, 0x73, 0x60, 0x90, 0x05, 0xC9, 0x8A, 0xCF, 0x58, 0xE1, 0x47, 0xC8,
    0x1C, 0xC6, 0x47, 0xFD, 0x1F, 0x1A, 0x71, 0x47, 0x22, 0xAD, 0x29, 0x10, 0x39, 0x4E, 0xCE, 0xC3,
};
static const uint8_t rsa_pss_key_2048_SHA224_Sig[] =
{
    0x50, 0x9A, 0x25, 0x53, 0x44, 0xCE, 0xED, 0xB8, 0xD0, 0x7C, 0x84, 0x35, 0xF6, 0xED, 0x89, 0xF1,
    0x15, 0xF7, 0xE6, 0x1D, 0x77, 0xB3, 0x10, 0xED, 0x0D, 0x0A, 0x72, 0x0B, 0x35, 0x0C, 0x81, 0x4A,
    0x43, 0x88, 0x3B, 0x61, 0x64, 0xD0, 0x27, 0xBE, 0x91, 0x93, 0xC2, 0x1D, 0xFA, 0x81, 0xC8, 0x2A,
    0x57, 0xA2, 0xCD, 0x71, 0x69, 0x14, 0xA6, 0xE8, 0x84, 0xEC, 0x5A, 0x4A, 0xCD, 0xDC, 0x8A, 0x3B,
    0x34, 0x54, 0xB0, 0x72, 0xEE, 0xDE, 0x5D, 0xC2, 0x2C, 0x84, 0xC0, 0xF0, 0x9F, 0x29, 0xEA, 0x90,
    0xA3, 0x99, 0xF8, 0x78, 0x63, 0x86, 0x27, 0xFF, 0xCA, 0x05, 0xDE, 0x5B, 0xC7, 0x49, 0xB5, 0x53,
    0xD4, 0x30, 0xFB, 0x48, 0x80, 0xD3, 0x2F, 0x40, 0x35, 0xB3, 0xDA, 0x03, 0x2B, 0x71, 0x9E, 0x63,
    0xB3, 0x9D, 0x8F, 0x1F, 0x5C, 0xDE, 0x87, 0x66, 0x4D, 0xA9, 0x65, 0x42, 0xBE, 0x13, 0x3D, 0x37,
    0x24, 0x33, 0x51, 0x78, 0x90, 0x8A, 0x0F, 0xB8, 0xDC, 0x81, 0xE8, 0x80, 0x65, 0x20, 0xAC, 0x72,
    0xAE, 0x17, 0xC0, 0x2B, 0x54, 0x3D, 0xC8, 0x4D, 0x4B, 0x36, 0x9C, 0x6E, 0xDA, 0xCA, 0x59, 0x6C,
    0x24, 0xA4, 0xC1, 0x84, 0x0D, 0x16, 0xB9, 0xF8, 0xBE, 0x74, 0x68, 0x94, 0x4B, 0xD4, 0x1A, 0x5D,
    0xE8, 0xF5, 0x75, 0x0B, 0xCB, 0xA9, 0xA9, 0x63, 0xD4, 0xEF, 0x37, 0xE6, 0x50, 0xCB, 0xAA, 0x62,
    0x38, 0xA0, 0xDC, 0x34, 0x26, 0x3B, 0x21, 0xCC, 0x01, 0x70, 0x0F, 0x3A, 0x26, 0x0C, 0xE6, 0xE7,
    0x48, 0xD3, 0x87, 0xA2, 0x5C, 0x7E, 0xBD, 0xC6, 0x25, 0x6A, 0xEE, 0x18, 0xA2, 0xDF, 0xC9, 0x87,
    0x9D, 0x62, 0x29, 0x4B, 0x88, 0x99, 0x7B, 0x71, 0x53, 0x2D, 0xF0, 0x4B, 0x4F, 0x04, 0xAD, 0xFA,
    0x81, 0x3B, 0x00, 0xF8, 0x0D, 0x90, 0xEB, 0x00, 0x5F, 0xC1, 0x5A, 0x52, 0xC7, 0xAB, 0xB5, 0x21,
};
#ifdef DONOT_ENABLE_DEFINE_USED_FOR_REFERENCE_ONLY
static const uint8_t rsa_pss_key_2048_SHA224_Salt[] =
{
    0x4C, 0xE5, 0xBC, 0x82, 0xBA, 0x28, 0x91, 0x67, 0x22, 0xED, 0x81, 0x19, 0xCB, 0xF9, 0x8E, 0x9F,
    0x6E, 0xAA, 0xED, 0x6E, 0x82, 0x2D, 0x66, 0x38, 0xBC, 0xF1, 0xFE, 0x06,
};
#endif

// mod = 2048, SHA256
static const uint8_t rsa_pss_key_2048_SHA256_n[] =
{
    0xAC, 0xF1, 0x0D, 0x27, 0x3A, 0x24, 0x7A, 0x17, 0x7F, 0x30, 0x83, 0xCC, 0x17, 0x26, 0xB6, 0x1B,
    0x05, 0xCE, 0x54, 0x22, 0x13, 0xE3, 0x71, 0x57, 0x6E, 0xD4, 0x22, 0x90, 0x6B, 0xEB, 0x53, 0x15,
    0xE3, 0x57, 0x18, 0x45, 0x88, 0x8F, 0x33, 0x4E, 0xA6, 0xAD, 0x70, 0x1D, 0xEA, 0xEA, 0xE2, 0x17,
    0x71, 0x12, 0x4C, 0x2A, 0xF9, 0xED, 0x9E, 0x19, 0xCF, 0xFD, 0x91, 0x46, 0xF4, 0xEE, 0xCC, 0xB4,
    0xAC, 0x32, 0x95, 0x84, 0x3B, 0x0B, 0xDE, 0x14, 0x9C, 0xA3, 0x04, 0xF7, 0x1F, 0x20, 0x25, 0xBC,
    0x14, 0x9F, 0x8A, 0xD6, 0xBF, 0x47, 0xEA, 0xA1, 0x3F, 0x31, 0x36, 0xF8, 0xD9, 0xA3, 0x19, 0xDD,
    0x3E, 0x96, 0x75, 0x56, 0xC5, 0xF3, 0x7F, 0xA4, 0xEC, 0xD7, 0x58, 0x6C, 0x93, 0xE0, 0xA6, 0x33,
    0xB2, 0x55, 0x49, 0xCF, 0x8E, 0x96, 0xEF, 0x0A, 0x3F, 0x54, 0x61, 0xFE, 0x43, 0x92, 0x8F, 0x97,
    0xE2, 0x69, 0xB5, 0x34, 0xEF, 0x38, 0x29, 0x96, 0xE0, 0x00, 0x61, 0x63, 0x9E, 0x80, 0xBD, 0x64,
    0x9E, 0xAF, 0x2E, 0x04, 0x9B, 0x92, 0x90, 0xE8, 0xF3, 0xF9, 0x65, 0x11, 0x74, 0x0E, 0xFD, 0x71,
    0x1A, 0x4B, 0x5D, 0x6C, 0x07, 0x2D, 0x54, 0x63, 0x08, 0x74, 0xB7, 0x06, 0x0F, 0xF0, 0x33, 0x32,
    0xCC, 0x3C, 0x3B, 0xA2, 0x46, 0xBF, 0x46, 0x34, 0x9A, 0xE5, 0x67, 0x51, 0x6C, 0xAC, 0xA7, 0x38,
    0x0E, 0xD7, 0x27, 0x51, 0x00, 0xA0, 0x79, 0x68, 0x89, 0x06, 0x46, 0x4C, 0x69, 0xA4, 0x3C, 0x70,
    0xAC, 0x0D, 0x1D, 0xBD, 0xEC, 0xCC, 0x08, 0x41, 0x32, 0x7F, 0xC5, 0x18, 0xF1, 0xF1, 0x71, 0x1C,
    0xE4, 0x65, 0x97, 0x29, 0xD6, 0x2C, 0x29, 0x55, 0xF0, 0x6D, 0x8B, 0x04, 0x30, 0x66, 0xCD, 0xDD,
    0x3C, 0x58, 0x96, 0x7A, 0x41, 0x00, 0x20, 0x1D, 0xFC, 0x9F, 0xF4, 0xAF, 0x2A, 0xD2, 0x0B, 0xC7,
};
static const uint8_t rsa_pss_key_2048_SHA256_e[] =
{
    0x00, 0x4B, 0x8C, 0xFB,
};
static const uint8_t rsa_pss_key_2048_SHA256_d[] =
{
    0x4B, 0x39, 0x70, 0x96, 0xF1, 0xAC, 0x4D, 0x13, 0xF3, 0x1C, 0x50, 0xF4, 0xE4, 0x04, 0xC9, 0x7D,
    0x58, 0xC0, 0x84, 0x90, 0xDD, 0xE9, 0x88, 0xDB, 0x8B, 0x7B, 0x46, 0xAC, 0xFD, 0xCC, 0x96, 0x25,
    0xDA, 0x5F, 0x75, 0x13, 0x05, 0xA0, 0xE2, 0x65, 0x37, 0x39, 0x85, 0xAF, 0x20, 0x3A, 0x6C, 0xF1,
    0x4C, 0x24, 0x49, 0xF3, 0xAA, 0x78, 0x50, 0x49, 0xA9, 0x06, 0x9D, 0x56, 0xA3, 0x10, 0xA9, 0x4D,
    0xDE, 0x56, 0xE6, 0x34, 0xCA, 0xC5, 0x00, 0xCE, 0xF9, 0xA3, 0x43, 0xFF, 0x9B, 0x46, 0x79, 0xB8,
    0xC5, 0x60, 0x1A, 0x40, 0xCD, 0xE6, 0xC9, 0x68, 0xEE, 0x14, 0xA8, 0x68, 0x2E, 0xFD, 0x7F, 0x0D,
    0x56, 0x50, 0x47, 0x4D, 0x4F, 0x3C, 0xD4, 0x37, 0xC0, 0xE3, 0xB2, 0x5A, 0xCC, 0x70, 0x5E, 0x82,
    0x44, 0xD6, 0xBE, 0xF4, 0xB8, 0x09, 0xC8, 0x1A, 0x4C, 0xFE, 0xEB, 0x11, 0x83, 0xD9, 0xD9, 0x38,
    0x89, 0x12, 0x96, 0x41, 0x4A, 0x59, 0x0A, 0x4B, 0x7B, 0x1F, 0x00, 0x10, 0x5A, 0x2D, 0x98, 0xD2,
    0x2A, 0x34, 0x61, 0xCF, 0x4C, 0xD5, 0x91, 0x2B, 0x56, 0x93, 0x82, 0x99, 0x05, 0xD9, 0x3A, 0x37,
    0x87, 0x03, 0xAF, 0x95, 0x47, 0x95, 0x2D, 0x56, 0x43, 0x9A, 0xC5, 0x09, 0x6B, 0x7E, 0xB5, 0x90,
    0x3F, 0x89, 0xA3, 0x89, 0x77, 0xBF, 0x07, 0x9C, 0xAA, 0xFB, 0xCE, 0xE3, 0x54, 0x74, 0xC0, 0x61,
    0xAB, 0xC8, 0x28, 0x69, 0x7D, 0x43, 0x88, 0xF6, 0xA6, 0xC8, 0x43, 0x34, 0x30, 0xCA, 0x68, 0x32,
    0xEB, 0xE4, 0xCB, 0x0B, 0x37, 0xE7, 0x61, 0x25, 0x79, 0x21, 0x34, 0xCF, 0xCB, 0x66, 0xFD, 0xBB,
    0x38, 0x28, 0x2A, 0x40, 0x0B, 0x18, 0xFF, 0x19, 0xDC, 0xCA, 0x05, 0x13, 0xD5, 0xEE, 0x4E, 0x23,
    0xDD, 0xE9, 0xB6, 0x64, 0x40, 0x23, 0xA7, 0xCE, 0x9D, 0x8E, 0x65, 0x3D, 0xB7, 0x6A, 0x9F, 0xB3,
};
static const uint8_t rsa_pss_key_2048_SHA256_Msg[] =
{
    0x8C, 0xAB, 0x19, 0x99, 0x2E, 0xE6, 0x4A, 0xA7, 0x62, 0x6F, 0x7F, 0xD6, 0xAB, 0x4E, 0xF4, 0x82,
    0xC7, 0xD7, 0xFA, 0xC6, 0x35, 0x22, 0x9D, 0x92, 0xF5, 0xBC, 0x85, 0xFD, 0x8F, 0x9C, 0x1A, 0xDC,
    0x56, 0x59, 0xEC, 0x93, 0xEE, 0x9A, 0x51, 0x2B, 0x0C, 0xCD, 0x50, 0xA5, 0x7D, 0x1C, 0xBD, 0x8E,
    0x6A, 0x9C, 0xA6, 0xD4, 0xDA, 0xC8, 0xEE, 0xD8, 0x78, 0x2F, 0x38, 0xC4, 0x97, 0x69, 0x06, 0x1F,
    0x73, 0x4F, 0x22, 0x9F, 0xB9, 0x6C, 0x3E, 0x3E, 0x4A, 0xAE, 0xD7, 0x8F, 0x3C, 0x61, 0x5F, 0x53,
    0x22, 0x5E, 0x9A, 0x48, 0x8E, 0x80, 0x49, 0x41, 0xD4, 0x58, 0x06, 0x7B, 0x10, 0x22, 0x6F, 0x2F,
    0x6A, 0xF7, 0x86, 0x64, 0x98, 0x44, 0x58, 0x07, 0xA5, 0x7A, 0xDD, 0x3D, 0xF1, 0x07, 0x20, 0xF8,
    0x7A, 0x86, 0x9F, 0xC9, 0x59, 0x32, 0xF5, 0xF5, 0x90, 0xA1, 0xB6, 0xCA, 0x02, 0xAF, 0x9B, 0x33,
};
static const uint8_t rsa_pss_key_2048_SHA256_Sig[] =
{
    0x18, 0xC6, 0x82, 0x28, 0x46, 0x6E, 0x6E, 0xDF, 0x88, 0xF1, 0x58, 0x21, 0xA2, 0xFD, 0x8B, 0xB9,
    0xC6, 0x1C, 0x80, 0xE4, 0x15, 0xB1, 0x64, 0xD1, 0x49, 0x75, 0xBF, 0xD4, 0x93, 0xD4, 0x1B, 0x6C,
    0x8D, 0x91, 0xEC, 0xA6, 0x72, 0xB0, 0x96, 0x57, 0xB6, 0x3A, 0xBF, 0x2E, 0x78, 0x76, 0xD9, 0xE1,
    0x2E, 0x65, 0x6A, 0xC3, 0xFC, 0x2B, 0xB4, 0xD3, 0x41, 0x44, 0xE3, 0x25, 0x0D, 0xC1, 0xAB, 0xC0,
    0x76, 0xB8, 0xE9, 0x7D, 0xDB, 0x47, 0x2F, 0x51, 0x7E, 0xC6, 0x77, 0xB9, 0x97, 0x4F, 0x44, 0x55,
    0xAB, 0x89, 0x02, 0x17, 0xAC, 0xC1, 0x3E, 0x87, 0x1E, 0xA3, 0xA8, 0x2A, 0x94, 0xB2, 0x72, 0x53,
    0xDB, 0xFF, 0x7B, 0x07, 0x25, 0xFB, 0x73, 0xD0, 0xBB, 0x85, 0xDA, 0x22, 0x08, 0x2C, 0x70, 0x4D,
    0xA4, 0xD0, 0x21, 0x34, 0xA5, 0xB5, 0x97, 0x86, 0xF8, 0x29, 0x2F, 0xB6, 0xDB, 0x23, 0xA5, 0xE5,
    0xCF, 0x66, 0x4F, 0xF7, 0xFF, 0x2E, 0x94, 0xC2, 0x65, 0x09, 0x30, 0x85, 0xAE, 0x71, 0xD5, 0xE8,
    0x6E, 0x4B, 0x3B, 0x1D, 0x2F, 0xEA, 0x53, 0x22, 0xD7, 0xE3, 0xE0, 0x86, 0x99, 0x54, 0xAD, 0xFC,
    0x0A, 0x86, 0xA3, 0x22, 0x1B, 0x0B, 0x4F, 0x97, 0xD7, 0xFC, 0xF5, 0x2B, 0xB8, 0x30, 0x21, 0xF3,
    0x93, 0x4D, 0x08, 0x7A, 0xAD, 0xA4, 0xF1, 0xCB, 0x0E, 0x93, 0xB6, 0x6B, 0x48, 0x69, 0x7A, 0x6A,
    0x47, 0x94, 0xB2, 0x35, 0x57, 0x98, 0x86, 0xF8, 0xAA, 0xE0, 0x84, 0xCD, 0x00, 0x3A, 0x42, 0xD6,
    0x69, 0xFF, 0xDF, 0x64, 0x48, 0x4F, 0x08, 0xB7, 0x00, 0x36, 0x0A, 0x9F, 0xBA, 0xF2, 0x0D, 0x37,
    0x6D, 0xA0, 0x65, 0x76, 0x0B, 0xD3, 0xFE, 0x58, 0x52, 0x64, 0x66, 0xE3, 0x9A, 0x93, 0xA3, 0x17,
    0x0F, 0xE5, 0xB2, 0x1F, 0x33, 0x4B, 0x93, 0x95, 0xAC, 0xC7, 0x6E, 0x08, 0xBA, 0xE7, 0xED, 0x2A,
};
#ifdef DONOT_ENABLE_DEFINE_USED_FOR_REFERENCE_ONLY
static const uint8_t rsa_pss_key_2048_SHA256_Salt[] =
{
    0x55, 0x92, 0xC2, 0x2D, 0xE7, 0xF5, 0x88, 0x4A, 0x85, 0x85, 0xE3, 0x5E, 0x1C, 0x84, 0xD7, 0xEB,
    0x78, 0x9F, 0x30, 0x1D, 0x68, 0x7F, 0xC6, 0xFE, 0x1D, 0x9B, 0x00, 0xE9, 0xD4, 0x50, 0x97, 0x41,
};
#endif

// mod = 3072, SHA1
static const uint8_t rsa_pss_key_3072_SHA1_n[] =
{
    0xAE, 0x59, 0xBC, 0x50, 0x22, 0x70, 0x0F, 0xEB, 0xFF, 0x79, 0x92, 0x99, 0xFC, 0x50, 0xB1, 0xBA,
    0xCE, 0x06, 0x44, 0xBF, 0x62, 0x30, 0x9A, 0xDA, 0x9C, 0x91, 0x8C, 0x00, 0xAB, 0x07, 0xE8, 0x23,
    0xF6, 0x0C, 0xAC, 0x61, 0x5D, 0xA3, 0x1F, 0x0A, 0xB6, 0x36, 0x6C, 0x05, 0x4E, 0xBB, 0xE4, 0x59,
    0x6A, 0x1E, 0x9F, 0x5A, 0x8A, 0x1A, 0x74, 0xD7, 0xB1, 0xD6, 0x0B, 0x9B, 0xFF, 0xE9, 0xD4, 0x8B,
    0x7F, 0xD9, 0x86, 0x2B, 0x9D, 0x3C, 0x94, 0xA3, 0x7D, 0xE0, 0x7C, 0x30, 0x80, 0x31, 0xBD, 0x7E,
    0x3A, 0xE1, 0x32, 0x7B, 0x65, 0xFF, 0x81, 0x73, 0x2D, 0x99, 0x8C, 0xED, 0x2F, 0x3F, 0xB4, 0x30,
    0xD1, 0xA3, 0xEC, 0x8F, 0x03, 0xAF, 0xF0, 0xBB, 0xFF, 0xF2, 0x29, 0x51, 0x41, 0x62, 0x93, 0x28,
    0x7D, 0x2F, 0x74, 0x88, 0x2C, 0x03, 0x24, 0xD2, 0x75, 0x7D, 0xAF, 0x53, 0x04, 0x98, 0x1C, 0xB8,
    0xC6, 0x3A, 0xC0, 0x2B, 0x6A, 0xE7, 0x42, 0xC1, 0x85, 0xA9, 0x26, 0x3B, 0xD8, 0x91, 0x02, 0xD2,
    0xD7, 0x12, 0xEB, 0x80, 0xBC, 0x1A, 0xD1, 0x96, 0xDF, 0x6C, 0xF7, 0x90, 0x36, 0xC5, 0x40, 0x77,
    0x97, 0x63, 0xEC, 0xD3, 0xDA, 0x5A, 0x86, 0x39, 0x86, 0x0B, 0xD7, 0x8F, 0x85, 0x65, 0x10, 0x17,
    0xEB, 0x01, 0x65, 0x31, 0x93, 0x2C, 0x33, 0x96, 0x88, 0xB7, 0xC5, 0x21, 0x7C, 0xD7, 0x64, 0xA5,
    0x25, 0x92, 0x81, 0x38, 0xB2, 0x7C, 0xF5, 0x0E, 0x04, 0x3A, 0x7D, 0x0E, 0xB5, 0xED, 0xE0, 0x36,
    0xFB, 0x5D, 0x8C, 0xAF, 0x17, 0x58, 0xBF, 0x21, 0x86, 0x7E, 0xEE, 0x7D, 0x18, 0x22, 0xC2, 0xE3,
    0xF2, 0x0A, 0xC9, 0x81, 0x78, 0xD3, 0xA0, 0xC7, 0xF8, 0xF9, 0xB8, 0xEB, 0x18, 0x7D, 0x2D, 0xF4,
    0x54, 0x74, 0x53, 0x72, 0xE9, 0xB1, 0x32, 0xB5, 0x4B, 0x05, 0x2D, 0xE7, 0x64, 0x3A, 0x1F, 0xC9,
    0xEE, 0xD2, 0x99, 0x03, 0x53, 0x7D, 0xE9, 0x35, 0xB1, 0x1B, 0xC4, 0xF9, 0xC0, 0x35, 0xDE, 0xCD,
    0x1E, 0xC9, 0x91, 0xD5, 0xF1, 0x50, 0x67, 0x8F, 0x70, 0x5D, 0xCA, 0x83, 0xC6, 0x28, 0xA7, 0x5A,
    0xA1, 0x3C, 0x1F, 0x92, 0x63, 0xC5, 0xBD, 0x1E, 0xDC, 0xBF, 0xF3, 0x36, 0x6C, 0x70, 0x8D, 0x80,
    0x76, 0xB0, 0x27, 0x30, 0xA6, 0x61, 0x94, 0xFC, 0xAD, 0x2E, 0x0D, 0xA4, 0x1C, 0xF1, 0x47, 0x14,
    0xFF, 0xDC, 0x37, 0x1A, 0xAC, 0x6C, 0x32, 0xDA, 0xED, 0x75, 0x36, 0x0E, 0xE2, 0xDD, 0x23, 0x67,
    0x3D, 0x0D, 0x35, 0x9D, 0x6B, 0x66, 0x84, 0x33, 0x43, 0xC7, 0xAA, 0x00, 0x4C, 0x02, 0x34, 0x07,
    0x81, 0x91, 0x55, 0x73, 0xCE, 0x9F, 0xF5, 0x18, 0xB4, 0xA7, 0x3B, 0xDF, 0xA5, 0x30, 0x2E, 0x5A,
    0x16, 0xDC, 0xFC, 0xE7, 0x7A, 0xE3, 0xEE, 0xF7, 0x37, 0xA3, 0x41, 0x01, 0x4D, 0xCD, 0xDE, 0x2B,
};
static const uint8_t rsa_pss_key_3072_SHA1_e[] =
{
    0x00, 0xDF, 0xE3, 0x4B,
};
static const uint8_t rsa_pss_key_3072_SHA1_d[] =
{
    0x11, 0x62, 0x4B, 0x0C, 0x27, 0x5C, 0xDB, 0xF8, 0x32, 0x26, 0x65, 0x7F, 0xFB, 0x05, 0x1E, 0x3D,
    0xBA, 0x1C, 0x66, 0x4A, 0xA8, 0xAA, 0x53, 0xA0, 0xA4, 0x1B, 0xC6, 0x2A, 0x13, 0x0B, 0x2E, 0x36,
    0x83, 0x3A, 0x70, 0xDE, 0x51, 0xD6, 0x3E, 0x0C, 0xAF, 0x86, 0x59, 0x1B, 0x07, 0x79, 0x59, 0xC0,
    0x11, 0x1C, 0x52, 0x32, 0x97, 0x1F, 0x91, 0x1A, 0xE3, 0xFB, 0xC1, 0x2F, 0x74, 0xD9, 0x52, 0xD7,
    0x7B, 0x68, 0xC3, 0x7E, 0xDA, 0xAE, 0xFF, 0x8A, 0x86, 0xB8, 0x09, 0xE3, 0x81, 0x95, 0x95, 0xD1,
    0x48, 0xAE, 0xF4, 0xB5, 0xEB, 0x10, 0x63, 0x9D, 0x1F, 0xB3, 0xAE, 0x02, 0xEC, 0xB0, 0x53, 0x00,
    0xEE, 0xC3, 0x29, 0xC2, 0x7D, 0x5A, 0x97, 0xC0, 0x51, 0x8E, 0x27, 0x2F, 0xDB, 0x41, 0x6C, 0x53,
    0xE8, 0x51, 0x38, 0x0C, 0x63, 0xB2, 0x04, 0xFD, 0x40, 0x3C, 0x2F, 0x49, 0xCB, 0xE3, 0xCC, 0xB7,
    0xEE, 0xFD, 0xC9, 0x6E, 0x9B, 0xD7, 0x0B, 0xC9, 0xF9, 0x7A, 0x7D, 0x50, 0x19, 0xE1, 0x49, 0xFF,
    0x8E, 0xB1, 0x69, 0x46, 0xA2, 0x56, 0xE7, 0x9C, 0x05, 0x8C, 0x66, 0xF8, 0x9B, 0xAD, 0x0D, 0x85,
    0xFA, 0x92, 0x0F, 0xDC, 0x4B, 0x4D, 0x93, 0x11, 0x57, 0x02, 0x20, 0xDA, 0x75, 0xA4, 0xFA, 0x7D,
    0x74, 0x89, 0x8D, 0xF3, 0x67, 0x01, 0x44, 0x66, 0x87, 0x3A, 0xFE, 0xDC, 0xCE, 0x7F, 0x1E, 0x43,
    0xB1, 0x4D, 0x18, 0xD2, 0x93, 0xF3, 0xD4, 0x3B, 0x82, 0x6E, 0xEC, 0x6A, 0xCB, 0xB2, 0x37, 0x43,
    0x5D, 0x4B, 0x39, 0x90, 0xC1, 0x84, 0xA5, 0x7D, 0x71, 0x75, 0x86, 0x98, 0x64, 0xCE, 0x5A, 0x39,
    0x35, 0x42, 0xAD, 0x00, 0x59, 0xAE, 0xD8, 0x19, 0xF9, 0x5E, 0x41, 0xBB, 0xE9, 0xCA, 0xF4, 0x99,
    0x5F, 0x42, 0xBB, 0x40, 0xDC, 0x3B, 0xC4, 0xBD, 0xC5, 0x68, 0xB6, 0x02, 0x65, 0x43, 0x4E, 0x99,
    0xEA, 0xE6, 0xFC, 0xF3, 0xB7, 0x99, 0x0A, 0xA8, 0x28, 0x6A, 0xF5, 0x4F, 0xB4, 0x37, 0x32, 0xA7,
    0x74, 0xA3, 0x0E, 0x80, 0xB2, 0x4A, 0x18, 0x3F, 0xD5, 0x05, 0x5F, 0xEA, 0x77, 0x98, 0xC6, 0x11,
    0xFE, 0x29, 0xE2, 0xB9, 0xAA, 0x54, 0xD2, 0x9A, 0x4C, 0xDD, 0x17, 0xB7, 0x68, 0xBD, 0x09, 0x7D,
    0x4A, 0xDC, 0x56, 0x74, 0xB7, 0x91, 0x85, 0x18, 0x9B, 0x5A, 0x65, 0x5C, 0x5B, 0x30, 0xD6, 0xAA,
    0x0B, 0x38, 0xCA, 0x86, 0xA1, 0xF7, 0x38, 0x86, 0x2D, 0xF9, 0x69, 0xE4, 0xE6, 0x79, 0x10, 0xD9,
    0xA3, 0x20, 0xCC, 0x72, 0xED, 0xF9, 0xD1, 0x5A, 0xB1, 0x53, 0x85, 0xD9, 0x45, 0x94, 0xA3, 0x2F,
    0x9E, 0x54, 0x20, 0x33, 0xC1, 0xE9, 0xF6, 0xA4, 0x2E, 0xF4, 0x85, 0x34, 0x65, 0x8A, 0x90, 0xAB,
    0x20, 0x64, 0x8E, 0x0B, 0x55, 0x8B, 0x14, 0xD6, 0xFD, 0xC5, 0x74, 0xFD, 0x9B, 0xE4, 0xE2, 0x3B,
};
static const uint8_t rsa_pss_key_3072_SHA1_Msg[] =
{
    0x5D, 0x71, 0x0B, 0x2A, 0xBB, 0x2E, 0x91, 0xA3, 0x66, 0x25, 0x03, 0x85, 0x5F, 0xA1, 0x95, 0xFE,
    0xA5, 0xFC, 0x48, 0xDD, 0x60, 0x04, 0xBE, 0x0C, 0x5F, 0xA3, 0x4D, 0x5A, 0xC4, 0xC0, 0x52, 0x7E,
    0xFE, 0x60, 0xC8, 0x59, 0xF8, 0x11, 0x19, 0x7C, 0x90, 0x88, 0x33, 0xEA, 0x4B, 0x89, 0xDF, 0x1F,
    0x47, 0x07, 0x4E, 0x51, 0x71, 0x8D, 0xF5, 0xF5, 0xF7, 0xDC, 0x9C, 0x85, 0x01, 0xD6, 0xB1, 0x81,
    0x9C, 0x9A, 0xE1, 0xB4, 0xF6, 0xF1, 0xEA, 0xB8, 0xD1, 0xE9, 0xAA, 0xBC, 0x32, 0xBF, 0x7C, 0x85,
    0x59, 0x02, 0xC5, 0xB3, 0xF6, 0xF6, 0xCA, 0x46, 0x9A, 0x37, 0xC5, 0x60, 0x6C, 0x9E, 0x37, 0x4C,
    0x1D, 0x68, 0x7F, 0xC0, 0x1E, 0x95, 0xAC, 0x5F, 0x10, 0x8F, 0x90, 0x82, 0x7C, 0x0C, 0x15, 0x38,
    0xC4, 0x35, 0xD5, 0x8C, 0x59, 0x08, 0xE4, 0x06, 0x2F, 0xFB, 0xF0, 0x74, 0x6E, 0xE2, 0x8D, 0xE9,
};
static const uint8_t rsa_pss_key_3072_SHA1_Sig[] =
{
    0x69, 0x80, 0x9C, 0x14, 0xF2, 0xFD, 0xF2, 0x0B, 0x60, 0xC8, 0xC2, 0x20, 0xA8, 0x71, 0x55, 0x8D,
    0x51, 0x66, 0x99, 0xEB, 0x1F, 0xB5, 0x1A, 0x8E, 0x99, 0x2B, 0x38, 0x98, 0xB1, 0xCD, 0x31, 0xCC,
    0x43, 0xBC, 0x86, 0x8E, 0x73, 0x1C, 0xD9, 0x09, 0x91, 0x73, 0xF4, 0x85, 0xE9, 0x3D, 0x18, 0xB5,
    0xFE, 0x32, 0x13, 0x5E, 0x44, 0x3D, 0xE9, 0xBD, 0x19, 0x8D, 0x86, 0x6B, 0x7C, 0x77, 0x42, 0x57,
    0x68, 0xFB, 0xEF, 0x09, 0x38, 0x27, 0x04, 0xDB, 0x4C, 0x32, 0x1C, 0xB9, 0x56, 0xF8, 0xE2, 0x05,
    0xAD, 0x45, 0x99, 0x5D, 0xD1, 0x19, 0x74, 0x83, 0x68, 0x3F, 0x53, 0x4D, 0xE5, 0xED, 0xDF, 0x94,
    0xC5, 0xB5, 0x6B, 0x33, 0x8F, 0x63, 0x50, 0x10, 0x1D, 0xFF, 0x9D, 0xED, 0x13, 0x9A, 0x1A, 0x2D,
    0xB1, 0xD4, 0x3A, 0xE4, 0x93, 0xE4, 0x9E, 0x34, 0x1F, 0x9F, 0xFE, 0x58, 0x0C, 0x72, 0xB7, 0x58,
    0xD1, 0x9F, 0xC3, 0xD3, 0x00, 0xF4, 0x0D, 0xA4, 0x54, 0x28, 0xB1, 0xC7, 0x19, 0xC6, 0xCA, 0x18,
    0x68, 0xD9, 0xDF, 0x60, 0x19, 0x61, 0x90, 0xA1, 0x01, 0xE1, 0xC1, 0x2F, 0xD5, 0x2E, 0x99, 0xDE,
    0x43, 0xEF, 0x42, 0xE5, 0x22, 0x57, 0xF5, 0x45, 0x8C, 0xCA, 0x8A, 0xA8, 0xC3, 0x4F, 0x65, 0x66,
    0xD8, 0xA2, 0x6E, 0xE7, 0x62, 0x4A, 0x11, 0x2A, 0x6F, 0xE2, 0x5A, 0x03, 0x8A, 0x03, 0xBC, 0xD7,
    0xD4, 0x6D, 0xD1, 0xB6, 0xF4, 0xA3, 0xF0, 0x4E, 0x2D, 0xD4, 0xAF, 0x60, 0x15, 0xCE, 0x57, 0xBF,
    0x71, 0x52, 0xC7, 0x85, 0x8F, 0xA4, 0x37, 0x02, 0x34, 0xBA, 0x10, 0x93, 0xB6, 0xF1, 0x37, 0xA9,
    0x9E, 0x8B, 0x65, 0xC4, 0x56, 0x3E, 0x7B, 0xA2, 0x5A, 0xEE, 0xA7, 0x53, 0x68, 0x0D, 0x96, 0x04,
    0x5D, 0x72, 0x67, 0x93, 0x37, 0xEF, 0x7F, 0xBF, 0x46, 0x29, 0x5C, 0xF4, 0xB8, 0x7A, 0xB1, 0x03,
    0xE8, 0x5A, 0x1C, 0x84, 0x28, 0x40, 0xF5, 0x15, 0x46, 0x9B, 0x8E, 0x99, 0x2B, 0x47, 0x97, 0x0D,
    0xB1, 0x39, 0x9E, 0xB3, 0xBB, 0xD2, 0x26, 0xFA, 0xF5, 0x8D, 0x04, 0xE9, 0x2E, 0x80, 0xF7, 0xB6,
    0xFE, 0x7D, 0x80, 0x20, 0x57, 0xF2, 0x9C, 0xB2, 0xCE, 0xAC, 0x82, 0x40, 0x4D, 0x89, 0xD5, 0xCC,
    0x91, 0xB4, 0x4C, 0xFA, 0x0A, 0xCA, 0xD9, 0x03, 0xB1, 0xD5, 0x89, 0xBA, 0xB0, 0xE2, 0x60, 0xE7,
    0x28, 0xA9, 0x09, 0xAB, 0x2E, 0x0E, 0x21, 0xDC, 0xEF, 0xF3, 0x3D, 0x42, 0xC8, 0xC9, 0xCC, 0xFD,
    0x9C, 0x58, 0x9D, 0xD3, 0x9B, 0x39, 0x65, 0x70, 0xE4, 0x45, 0xAB, 0x8F, 0xD3, 0x75, 0x5D, 0x11,
    0x1A, 0x30, 0x1C, 0xB7, 0x69, 0x4C, 0x6B, 0xB5, 0xE2, 0xCC, 0x9C, 0xB3, 0x97, 0xA0, 0xEE, 0xC1,
    0x87, 0x1D, 0xC6, 0xE5, 0x83, 0x48, 0x59, 0x6D, 0x54, 0x6A, 0x38, 0xB3, 0xDD, 0xEE, 0x77, 0x34,
};
#ifdef DONOT_ENABLE_DEFINE_USED_FOR_REFERENCE_ONLY
static const uint8_t rsa_pss_key_3072_SHA1_Salt[] =
{
    0x5B, 0x5F, 0xEF, 0x5C, 0xEB, 0x2A, 0x5E, 0xDA, 0x4B, 0xBC, 0xCC, 0x5E, 0x96, 0x98, 0x44, 0x14,
    0x56, 0xED, 0xC5, 0x53,
};
#endif

// mod = 3072, SHA224
static const uint8_t rsa_pss_key_3072_SHA224_n[] =
{
    0xB3, 0x73, 0x56, 0x9D, 0x22, 0xAC, 0x0F, 0x43, 0x99, 0xB2, 0x0D, 0x55, 0xBA, 0x19, 0x33, 0x9A,
    0xAD, 0x3C, 0x8D, 0xD7, 0x50, 0x1E, 0xDB, 0x55, 0xBD, 0xF8, 0x5B, 0x6A, 0xD7, 0x2A, 0x16, 0xEB,
    0x2C, 0xA6, 0x87, 0x2B, 0x8F, 0x84, 0xDA, 0x6D, 0x2C, 0x5A, 0xED, 0x60, 0x41, 0x03, 0x65, 0xBC,
    0x20, 0xA8, 0x66, 0x33, 0x7D, 0xA6, 0xDB, 0x5E, 0xF3, 0x38, 0xE5, 0xA5, 0xEF, 0x94, 0xCC, 0xF7,
    0x54, 0xEA, 0x5D, 0x0E, 0x61, 0xD6, 0xF6, 0x40, 0x6D, 0x35, 0xB3, 0xC6, 0x44, 0xE3, 0x0E, 0xF9,
    0xCE, 0xDA, 0x46, 0xB9, 0x34, 0x65, 0x86, 0x72, 0x9E, 0x51, 0xAA, 0x1A, 0xCD, 0x75, 0xAB, 0x82,
    0x5B, 0x58, 0xFA, 0xFA, 0xD1, 0xA3, 0xEE, 0x76, 0x26, 0x1B, 0xC4, 0x95, 0x82, 0x38, 0xC7, 0xD8,
    0x9B, 0xBE, 0x6F, 0x72, 0x4F, 0x78, 0xDB, 0xB5, 0x20, 0x12, 0x49, 0x3D, 0x91, 0x7F, 0x4A, 0xBA,
    0x06, 0xE5, 0xD3, 0x25, 0x96, 0xD6, 0x27, 0xD1, 0xAC, 0x50, 0xE8, 0xD6, 0x44, 0xF3, 0xAD, 0x74,
    0xF9, 0x7E, 0x96, 0x44, 0xC0, 0x4D, 0xF8, 0xF8, 0x1D, 0x90, 0x47, 0xA1, 0xF7, 0x87, 0x0C, 0x95,
    0x52, 0xC1, 0x56, 0x0A, 0xD6, 0x9D, 0x87, 0x9E, 0xBE, 0x54, 0x38, 0x8D, 0x3C, 0xFE, 0xD3, 0xEF,
    0x26, 0x25, 0xEF, 0xAE, 0x9C, 0xFF, 0xF4, 0x93, 0xFC, 0xCF, 0x09, 0xA7, 0xFE, 0xCE, 0x69, 0x86,
    0xDC, 0x2F, 0x74, 0x46, 0xA6, 0x50, 0x30, 0x98, 0xC3, 0x1F, 0xE8, 0x43, 0x56, 0xF4, 0x0C, 0xF2,
    0xF6, 0x83, 0x19, 0xD3, 0x6D, 0x46, 0x83, 0x0F, 0x7C, 0xB3, 0x53, 0xEC, 0xA7, 0x90, 0x12, 0xDD,
    0xDB, 0x47, 0xFA, 0xB8, 0x45, 0x87, 0x3B, 0x71, 0x97, 0x74, 0x67, 0x9F, 0xBC, 0xF3, 0xA7, 0x54,
    0xB2, 0xCE, 0xD6, 0x17, 0x0C, 0x9A, 0xE2, 0x33, 0xF6, 0x1B, 0x89, 0x92, 0x3B, 0x32, 0xEF, 0xFC,
    0x61, 0xDC, 0x6F, 0xA5, 0x80, 0x71, 0x8B, 0x5B, 0x4A, 0xAD, 0x99, 0x37, 0xBE, 0xC3, 0x55, 0x5E,
    0x8E, 0x76, 0xBC, 0xD9, 0x35, 0x6F, 0x42, 0xE5, 0x9E, 0xF2, 0x1E, 0x10, 0x51, 0xE1, 0x75, 0xAE,
    0xA2, 0xCC, 0xC6, 0x0D, 0x5A, 0x30, 0x09, 0x7A, 0x40, 0xBF, 0x15, 0xA6, 0x00, 0xE9, 0x5F, 0x86,
    0x9E, 0x40, 0xFC, 0x00, 0xFB, 0x74, 0x81, 0xE3, 0x5C, 0xC2, 0x68, 0x2E, 0xA7, 0xAB, 0x48, 0x22,
    0x8F, 0x1C, 0xE6, 0x1A, 0x22, 0x1C, 0x3F, 0x38, 0x74, 0xC3, 0x92, 0x90, 0xDB, 0xCE, 0x0E, 0x40,
    0x45, 0x21, 0x0E, 0xB8, 0x79, 0x83, 0x09, 0x7A, 0x12, 0xC1, 0x0E, 0xC1, 0x6F, 0xCE, 0xCC, 0xB1,
    0x5B, 0x3C, 0xF1, 0x05, 0xE1, 0x81, 0x0F, 0xA4, 0x3F, 0x6C, 0x8A, 0xF0, 0x16, 0x98, 0x4A, 0x28,
    0x39, 0xC8, 0xCC, 0xB0, 0x7B, 0x18, 0x1F, 0xE6, 0x3F, 0x25, 0xEF, 0xCD, 0xB4, 0x3C, 0x9A, 0x75,
};
static const uint8_t rsa_pss_key_3072_SHA224_e[] =
{
    0x00, 0x5F, 0x76, 0xAD,
};
static const uint8_t rsa_pss_key_3072_SHA224_d[] =
{
    0x52, 0x7D, 0x9C, 0xB0, 0xEE, 0x9A, 0xD9, 0xC8, 0xFD, 0x45, 0x9D, 0x58, 0xA9, 0x76, 0x32, 0xF3,
    0x72, 0x5C, 0x14, 0x10, 0x7A, 0xCE, 0x9E, 0x49, 0x04, 0xED, 0x9C, 0x82, 0x19, 0xD3, 0x35, 0x10,
    0x9B, 0x22, 0xAE, 0x6E, 0xCD, 0x69, 0xA1, 0x28, 0x33, 0xA3, 0xF3, 0xD5, 0xD4, 0xC1, 0x20, 0x03,
    0xDF, 0x5D, 0x88, 0x4C, 0x4B, 0xA4, 0x40, 0xFF, 0xF9, 0x92, 0xA2, 0xEB, 0x45, 0xDB, 0xCC, 0x6A,
    0x7E, 0xA5, 0x08, 0x8C, 0xC5, 0xF6, 0x21, 0x2D, 0xFC, 0xAA, 0xEB, 0xAD, 0xC6, 0x91, 0x98, 0x7C,
    0x00, 0xF9, 0x40, 0x26, 0x84, 0xC7, 0x63, 0xEA, 0x18, 0x02, 0xE1, 0x98, 0xF2, 0x16, 0xEA, 0xEE,
    0xDD, 0xC5, 0x1D, 0x32, 0x56, 0xF8, 0x11, 0xFC, 0x02, 0x61, 0x2C, 0x38, 0x93, 0xA7, 0x38, 0xA8,
    0x9B, 0x17, 0x5A, 0xAD, 0x78, 0x32, 0x43, 0x75, 0xC8, 0x30, 0xB8, 0x7A, 0xE9, 0xCD, 0x93, 0x54,
    0x67, 0x50, 0xE4, 0xA2, 0xCD, 0x1D, 0x1A, 0x18, 0x78, 0x0F, 0xC7, 0x3D, 0xF6, 0xB0, 0xDC, 0xD5,
    0xFB, 0x2E, 0x51, 0xC2, 0x49, 0x0A, 0x46, 0x4A, 0xFB, 0x84, 0x2D, 0xF0, 0xC1, 0x36, 0xE1, 0xA8,
    0xF1, 0x02, 0xFA, 0x9B, 0xEF, 0x3B, 0xD7, 0xAF, 0x59, 0x6C, 0x0D, 0x65, 0x91, 0x4E, 0x9D, 0x4C,
    0xE5, 0x0D, 0xA1, 0x90, 0x2C, 0x6A, 0xF8, 0x7B, 0xCF, 0xDD, 0x7D, 0x76, 0xA2, 0xF1, 0xEB, 0x09,
    0x46, 0x82, 0xEF, 0x60, 0x88, 0x16, 0x3E, 0x90, 0x87, 0x07, 0x83, 0xFB, 0x95, 0x5A, 0x4C, 0x9D,
    0xA7, 0x27, 0x53, 0xBD, 0x60, 0x75, 0x9B, 0xFB, 0x91, 0xB6, 0x05, 0xFB, 0x45, 0x58, 0x3E, 0x57,
    0x52, 0xFF, 0x49, 0xF4, 0xE4, 0x64, 0xBF, 0x64, 0xC4, 0x5F, 0xA1, 0x08, 0x72, 0x82, 0xF1, 0x18,
    0x76, 0xB6, 0x00, 0xB9, 0xDA, 0x07, 0x16, 0x97, 0x5A, 0xA0, 0xEC, 0x33, 0x52, 0xB0, 0x3D, 0x0D,
    0x9D, 0xEF, 0xF2, 0x02, 0xBE, 0x35, 0x44, 0x94, 0x7E, 0x41, 0x5D, 0xD6, 0xF5, 0x9E, 0x00, 0x42,
    0x33, 0xA5, 0xF5, 0x1F, 0x05, 0x8E, 0x48, 0xF6, 0x7F, 0x71, 0xDB, 0xE2, 0x14, 0xB3, 0xE3, 0x00,
    0x67, 0xC4, 0x34, 0x27, 0x58, 0xC4, 0x7A, 0x77, 0xB1, 0x56, 0xBF, 0x4A, 0xE3, 0x2B, 0x78, 0xB2,
    0x9E, 0x02, 0x97, 0x63, 0x78, 0x91, 0x60, 0xB2, 0x37, 0xE2, 0x40, 0xCE, 0xB2, 0x78, 0xA8, 0x5D,
    0x14, 0x86, 0x8E, 0xCD, 0xC2, 0xFA, 0xA2, 0xF3, 0x8F, 0x99, 0x88, 0x6E, 0xE5, 0xF7, 0xD0, 0xB1,
    0x68, 0x37, 0xF2, 0x66, 0x29, 0xB1, 0xF9, 0xFD, 0xDB, 0x03, 0x09, 0x78, 0xAC, 0xF4, 0x10, 0x3D,
    0x77, 0xAF, 0x58, 0x99, 0x25, 0x47, 0x68, 0x68, 0x1C, 0x1D, 0x08, 0x14, 0xF1, 0x06, 0xD9, 0xE5,
    0x3A, 0xBC, 0x5E, 0x3D, 0xB1, 0xED, 0xA1, 0x2A, 0xFB, 0xDB, 0x18, 0x81, 0xED, 0x34, 0x1B, 0x4D,
};
static const uint8_t rsa_pss_key_3072_SHA224_Msg[] =
{
    0x4E, 0xBB, 0x01, 0x3A, 0x61, 0xA6, 0x18, 0xAB, 0x29, 0x3E, 0xC4, 0x95, 0xE7, 0xCF, 0xEA, 0xD3,
    0x5A, 0x30, 0xDA, 0x0B, 0xE1, 0x54, 0x8B, 0xE0, 0xDF, 0x1C, 0x28, 0x69, 0x63, 0x6F, 0xCC, 0xE2,
    0x09, 0x8D, 0x8B, 0xA2, 0x1B, 0xA0, 0xB1, 0x4D, 0xFC, 0x95, 0x4E, 0x4B, 0xC7, 0x29, 0xF2, 0x79,
    0x33, 0x47, 0xB5, 0x1E, 0xBA, 0x91, 0x7A, 0x20, 0xFA, 0x3D, 0x75, 0x78, 0x5B, 0x22, 0xEB, 0xE3,
    0xF2, 0x12, 0x39, 0xDA, 0xA5, 0x6B, 0x18, 0xC5, 0x90, 0xE9, 0x1F, 0x6C, 0xA8, 0xBE, 0x8A, 0xAE,
    0x9E, 0xE5, 0x39, 0x75, 0x07, 0xB3, 0xFC, 0xE9, 0xB9, 0xAF, 0x0D, 0xE4, 0x78, 0xA3, 0xDE, 0xA6,
    0xD2, 0xF3, 0x15, 0xCB, 0x47, 0x2E, 0xD5, 0x7A, 0xAD, 0xE3, 0x40, 0xDE, 0xD3, 0xB6, 0x3A, 0xDA,
    0x65, 0xB2, 0x6F, 0xF8, 0x0F, 0xE1, 0x97, 0xA3, 0xE5, 0x1A, 0xF9, 0x97, 0x03, 0x1B, 0x2D, 0x95,
};
static const uint8_t rsa_pss_key_3072_SHA224_Sig[] =
{
    0x12, 0x29, 0xF7, 0xD9, 0x10, 0x43, 0x3A, 0xEC, 0x4B, 0x4A, 0x66, 0x1B, 0xA7, 0x92, 0x1F, 0xB5,
    0xFC, 0x16, 0x1D, 0x55, 0x7B, 0xFA, 0xDA, 0x92, 0x92, 0x8A, 0x70, 0xE6, 0xA4, 0xF5, 0x4B, 0x7A,
    0xE9, 0x3F, 0x82, 0xB8, 0x14, 0x98, 0x7A, 0x08, 0xCA, 0x71, 0xF1, 0xF1, 0x65, 0x3C, 0x9C, 0xFA,
    0xF8, 0x67, 0x49, 0x17, 0x48, 0x68, 0xD8, 0xC0, 0xFB, 0x8A, 0x68, 0x44, 0x47, 0x51, 0x2C, 0xD3,
    0x6B, 0xCA, 0x23, 0x00, 0x9A, 0xF8, 0x7B, 0xF0, 0xB0, 0x53, 0x61, 0x7D, 0x6F, 0x7D, 0x7E, 0xE3,
    0xC7, 0x38, 0x5D, 0x23, 0x92, 0x16, 0x1B, 0x13, 0x4D, 0x98, 0xBF, 0x67, 0x5B, 0xEF, 0xBD, 0x8C,
    0xA2, 0x15, 0x23, 0xA5, 0x99, 0xD8, 0x3E, 0x35, 0xD3, 0x64, 0xAB, 0x8B, 0x61, 0xA1, 0x91, 0x4C,
    0xE9, 0x54, 0x5C, 0x95, 0xA4, 0x0A, 0x5C, 0xCC, 0xB8, 0x66, 0x1A, 0xC0, 0x94, 0x9A, 0x93, 0xAF,
    0x4A, 0x2E, 0x46, 0xE1, 0x2A, 0x53, 0xE5, 0x14, 0x37, 0x1B, 0x95, 0x6A, 0x8A, 0xEC, 0x43, 0x6B,
    0x4B, 0x05, 0x2B, 0xB6, 0xC6, 0x11, 0x57, 0xA6, 0xA8, 0x34, 0xAB, 0x8B, 0x94, 0x77, 0x62, 0x0C,
    0x46, 0xCD, 0xE6, 0x79, 0xBA, 0xAD, 0x93, 0x58, 0x81, 0x29, 0x13, 0x96, 0xF7, 0xA3, 0x0E, 0x7A,
    0xD2, 0x9E, 0xB0, 0xD6, 0xF7, 0xDC, 0x22, 0x6E, 0x71, 0xE2, 0xCB, 0xF5, 0x5B, 0xEB, 0x83, 0x2F,
    0xC2, 0xF4, 0xB9, 0xAD, 0x48, 0x2E, 0x67, 0xB1, 0x2F, 0x5C, 0xAE, 0xFD, 0xAC, 0x23, 0x6A, 0xD4,
    0x64, 0xF1, 0x99, 0xFA, 0x62, 0x3F, 0x45, 0x5B, 0xAF, 0xFC, 0x33, 0x8D, 0x6D, 0xF6, 0x42, 0x1B,
    0x90, 0x87, 0x78, 0x09, 0x7D, 0x94, 0x27, 0x85, 0x04, 0x7F, 0x17, 0x8B, 0xCC, 0x62, 0xA9, 0x8A,
    0x5B, 0xB4, 0x89, 0x88, 0x74, 0xC7, 0x28, 0x8C, 0xCC, 0x40, 0x29, 0x02, 0xA9, 0x48, 0x72, 0x11,
    0x28, 0xFE, 0xB2, 0x5C, 0x3C, 0xD0, 0xBF, 0x09, 0x8A, 0xA6, 0x51, 0xF1, 0x0F, 0x38, 0xE5, 0x73,
    0x3B, 0x0C, 0x30, 0xE2, 0x4E, 0x16, 0x07, 0xEE, 0xBA, 0x1F, 0x60, 0x8F, 0x95, 0xEB, 0x42, 0xE2,
    0xCC, 0x0F, 0x2F, 0x65, 0xD4, 0x2C, 0x7A, 0xA8, 0xB3, 0x89, 0xA5, 0x83, 0xBF, 0x3E, 0x40, 0x62,
    0x92, 0x2C, 0x27, 0xE1, 0x41, 0x9A, 0xED, 0xEA, 0xA7, 0x7B, 0x49, 0x4A, 0x78, 0xFB, 0x39, 0x7C,
    0xDB, 0xB0, 0xBC, 0x58, 0xF3, 0xB4, 0x94, 0x21, 0x10, 0x56, 0xEC, 0xBF, 0x76, 0x3B, 0xAA, 0x41,
    0xE5, 0x2E, 0xDB, 0x64, 0xC4, 0x55, 0xDB, 0xF5, 0x15, 0x43, 0xE1, 0x90, 0x09, 0x61, 0x7E, 0x3E,
    0x90, 0xB0, 0x77, 0xF6, 0x80, 0xDC, 0x7F, 0x19, 0xCD, 0x8E, 0x0E, 0x98, 0x85, 0x4E, 0xD3, 0x65,
    0x76, 0x5D, 0x1F, 0xCA, 0x6B, 0x54, 0x68, 0x41, 0xA8, 0xEE, 0x2B, 0x7D, 0x2A, 0xD3, 0xE8, 0x7F,
};
#ifdef DONOT_ENABLE_DEFINE_USED_FOR_REFERENCE_ONLY
static const uint8_t rsa_pss_key_3072_SHA224_Salt[] =
{
    0xD5, 0xFD, 0x67, 0x76, 0x92, 0xD5, 0xFB, 0xA9, 0x6D, 0x27, 0x94, 0x6F, 0xAB, 0xFD, 0xA9, 0xB0,
    0xA6, 0x14, 0x8E, 0xC4, 0x65, 0x27, 0xA2, 0xD8, 0x6F, 0x70, 0xCB, 0x94,
};
#endif

// mod = 3072, SHA256
static const uint8_t rsa_pss_key_3072_SHA256_n[] =
{
    0x8B, 0xAD, 0xB2, 0xBC, 0x4D, 0x7A, 0x99, 0xAD, 0x0C, 0xA0, 0x81, 0xBB, 0xA6, 0xCF, 0x40, 0x91,
    0xDE, 0x50, 0x9A, 0xAA, 0x6D, 0x10, 0x94, 0xA0, 0x5D, 0x2C, 0x84, 0x44, 0x72, 0x9E, 0x94, 0xAE,
    0x6D, 0xF2, 0x59, 0xB2, 0xF1, 0x76, 0x6E, 0xB2, 0x5E, 0x0E, 0xD3, 0x7E, 0x41, 0x43, 0x26, 0x73,
    0x30, 0x01, 0x6C, 0x47, 0x6C, 0x8A, 0xC5, 0xF4, 0x58, 0xE1, 0x71, 0x64, 0xC0, 0xF2, 0xF4, 0xE1,
    0xBB, 0xFA, 0x2E, 0x92, 0x56, 0x22, 0xE0, 0x2C, 0x7E, 0xCD, 0xBA, 0x8C, 0x39, 0xBB, 0xA7, 0xEF,
    0x7E, 0x43, 0x65, 0xD7, 0xAE, 0x50, 0xE2, 0xE9, 0x19, 0x8E, 0x40, 0xC5, 0x27, 0x07, 0xBD, 0x96,
    0x0D, 0x65, 0x11, 0xFF, 0xF3, 0x35, 0x97, 0xB0, 0x90, 0xFB, 0x5B, 0xD2, 0x89, 0x19, 0x47, 0xFE,
    0xB5, 0x2A, 0x5E, 0x12, 0xE3, 0xC8, 0xAE, 0x8E, 0xC9, 0x08, 0xFC, 0x8F, 0x0A, 0xEB, 0x9C, 0x3F,
    0xA3, 0x2B, 0x7F, 0xE7, 0x0D, 0x60, 0x78, 0x66, 0xA2, 0x7B, 0x81, 0xF6, 0xFC, 0xEF, 0x55, 0x0B,
    0xED, 0x8E, 0xED, 0x46, 0x8B, 0x4E, 0xAF, 0x05, 0xE8, 0x19, 0x5F, 0xD7, 0xB2, 0x17, 0xC5, 0x8A,
    0x09, 0x27, 0x5D, 0x7D, 0x28, 0x09, 0xAF, 0x7C, 0xC0, 0x4B, 0xF9, 0xAE, 0x52, 0x77, 0x06, 0xC9,
    0xC7, 0x11, 0xFD, 0x20, 0xDF, 0x7B, 0xAE, 0x1F, 0xBD, 0x4B, 0x0A, 0x8F, 0x2C, 0xCD, 0xF6, 0xCC,
    0xAA, 0x69, 0x70, 0x10, 0x10, 0xA2, 0x2F, 0x8D, 0xB8, 0xD7, 0xF8, 0xE5, 0x73, 0x44, 0xDE, 0x4E,
    0x73, 0xFE, 0xAE, 0x53, 0x26, 0x92, 0x41, 0x34, 0x99, 0xB2, 0xF2, 0x57, 0x05, 0x3E, 0xCD, 0x04,
    0x49, 0xC4, 0xE0, 0x3E, 0x35, 0xDF, 0xC9, 0x28, 0xBC, 0x79, 0x6F, 0xBE, 0x79, 0xC6, 0xD3, 0x83,
    0xCD, 0x30, 0xBA, 0x21, 0xFE, 0x16, 0xB0, 0x31, 0x28, 0x94, 0xAC, 0x68, 0x93, 0xB0, 0x58, 0xBE,
    0x24, 0xB5, 0x6F, 0x9E, 0x36, 0x5F, 0x70, 0x98, 0x04, 0xB3, 0x63, 0xF6, 0xDD, 0x62, 0x36, 0xC7,
    0xDA, 0xB4, 0x2A, 0x36, 0xEB, 0xFA, 0xB5, 0xCC, 0xDE, 0xD6, 0x75, 0x83, 0x22, 0xD9, 0x0F, 0xF1,
    0x5E, 0xAE, 0x83, 0x64, 0xF3, 0x1D, 0x3E, 0x6F, 0xAD, 0xA1, 0x23, 0xC5, 0xFC, 0xFF, 0xBB, 0xD9,
    0x46, 0xC9, 0xC1, 0xD3, 0xA1, 0x06, 0xA2, 0x7F, 0xE0, 0x8B, 0xD5, 0x3E, 0x7B, 0x6B, 0x8A, 0xA6,
    0x4B, 0xE6, 0x3C, 0xE8, 0xD3, 0xD9, 0x0F, 0xC2, 0xC8, 0x04, 0x62, 0xAE, 0x6A, 0x3C, 0x1B, 0x48,
    0x63, 0x97, 0xCC, 0x04, 0x24, 0x0B, 0xF0, 0x30, 0xF7, 0x97, 0x81, 0x30, 0x5B, 0x6D, 0xF4, 0xDF,
    0xCD, 0xC8, 0x5C, 0x78, 0xFE, 0x76, 0x21, 0xD5, 0xB7, 0x98, 0x7F, 0xEE, 0x36, 0xBC, 0x24, 0x7B,
    0x0E, 0x64, 0xBB, 0x99, 0xA5, 0xEA, 0x7D, 0x7D, 0xCA, 0xBC, 0xC9, 0xDD, 0x56, 0xAD, 0xBB, 0xC1,
};
static const uint8_t rsa_pss_key_3072_SHA256_e[] =
{
    0x00, 0x0D, 0xC3, 0xA5,
};
static const uint8_t rsa_pss_key_3072_SHA256_d[] =
{
    0x00, 0x2E, 0xB8, 0xAC, 0xAC, 0xF4, 0x30, 0xF4, 0xE1, 0x1E, 0x75, 0x08, 0xDC, 0xFD, 0x84, 0xA8,
    0x2A, 0x9A, 0xA4, 0xC0, 0xA9, 0x22, 0x2F, 0x60, 0x0B, 0x8C, 0xBC, 0x1F, 0xB6, 0x2A, 0x01, 0x18,
    0x83, 0x55, 0x26, 0xFB, 0x4B, 0x12, 0xBF, 0xD2, 0xAE, 0xE4, 0x74, 0x36, 0xD0, 0x52, 0x0C, 0xFB,
    0xFE, 0xBC, 0x1C, 0x69, 0x09, 0xCC, 0x31, 0xB1, 0xF3, 0x3E, 0x4F, 0xC4, 0x50, 0x6E, 0x3C, 0x4F,
    0x71, 0x8C, 0x36, 0x6E, 0xDA, 0xA0, 0xAA, 0x6D, 0x30, 0x78, 0x73, 0x1F, 0x5D, 0xF7, 0x97, 0x1C,
    0x07, 0x9A, 0xE4, 0x0E, 0x10, 0xDF, 0x95, 0x2B, 0x11, 0x0E, 0x0E, 0xE7, 0xB2, 0x8C, 0x7A, 0x65,
    0xE7, 0xCE, 0x48, 0xE8, 0xF5, 0xB6, 0xA5, 0x4E, 0xBE, 0xAF, 0x28, 0xAF, 0xE0, 0x81, 0x3B, 0x11,
    0xD9, 0x6F, 0x25, 0xA0, 0x62, 0xCE, 0xFF, 0x43, 0x8D, 0x89, 0xBB, 0x24, 0x74, 0x37, 0x34, 0xF3,
    0xD2, 0x93, 0x08, 0xB7, 0x7A, 0x79, 0x10, 0xD7, 0xAC, 0x42, 0x52, 0xDF, 0xA1, 0xE1, 0x40, 0xAF,
    0x78, 0xB2, 0x16, 0x19, 0xB3, 0x85, 0xF4, 0x9F, 0x71, 0x7D, 0x0B, 0x61, 0x76, 0xF3, 0x1D, 0xD7,
    0x99, 0x17, 0xFA, 0xFE, 0xFA, 0xE3, 0x5D, 0xDF, 0xFD, 0x03, 0xB6, 0x06, 0x04, 0xF6, 0x30, 0x72,
    0x2C, 0x86, 0x8E, 0x9F, 0x8A, 0x91, 0xD3, 0xC3, 0xD3, 0xA3, 0xFB, 0xBC, 0xF1, 0xD1, 0x6C, 0x24,
    0x06, 0x4F, 0x4D, 0xAD, 0xF5, 0x8E, 0x3F, 0x09, 0xE4, 0x22, 0x5F, 0xC7, 0x12, 0x1F, 0xB5, 0x41,
    0x8D, 0x48, 0xAC, 0x65, 0x91, 0x3F, 0x6C, 0xB4, 0x19, 0x14, 0x0C, 0xED, 0xA6, 0x40, 0x74, 0x6B,
    0xCD, 0xA1, 0x2A, 0x58, 0xD8, 0x20, 0xB0, 0xE1, 0x39, 0xFA, 0x22, 0x44, 0xA5, 0xA4, 0x51, 0xDD,
    0x0B, 0x02, 0xEE, 0x13, 0x1E, 0xD2, 0x39, 0x63, 0xA1, 0x98, 0x60, 0x3E, 0x60, 0xE4, 0x24, 0x09,
    0x80, 0xBF, 0xC7, 0xB1, 0x47, 0xAB, 0x4F, 0xB3, 0x92, 0x7A, 0x27, 0x3A, 0x0A, 0xC4, 0xEA, 0x11,
    0xAC, 0x65, 0x53, 0xDF, 0x0A, 0xBC, 0x13, 0xD1, 0xA0, 0x61, 0x6B, 0x48, 0xE2, 0x90, 0xA7, 0xC4,
    0xC0, 0x87, 0x23, 0xA5, 0xEE, 0xE4, 0xC2, 0xF9, 0xD5, 0x86, 0xB6, 0x67, 0x38, 0x4E, 0x90, 0x39,
    0xD8, 0x4E, 0x92, 0xBA, 0x40, 0x4F, 0x53, 0x9D, 0x88, 0x61, 0xE2, 0x1A, 0x33, 0x97, 0x70, 0xE9,
    0xB7, 0xCC, 0x20, 0x11, 0x56, 0xC5, 0x94, 0x89, 0x60, 0xEB, 0xD3, 0x19, 0x77, 0xC4, 0x12, 0x2A,
    0xD8, 0x64, 0xB0, 0xC6, 0x98, 0x5B, 0x1E, 0x37, 0x4E, 0x59, 0x19, 0x21, 0xA4, 0x0A, 0xDD, 0xC8,
    0x54, 0x51, 0x2D, 0xF5, 0xE5, 0xC3, 0x02, 0x0E, 0xAE, 0x7E, 0xDF, 0x36, 0x46, 0x04, 0x81, 0xFF,
    0xDB, 0xA7, 0x8F, 0x58, 0xF7, 0x96, 0x3D, 0xEE, 0x27, 0x95, 0x34, 0x8A, 0x71, 0x31, 0xE0, 0xFD,
};
static const uint8_t rsa_pss_key_3072_SHA256_Msg[] =
{
    0x44, 0x3A, 0xAA, 0x12, 0xA2, 0xD0, 0x19, 0x72, 0xBD, 0x0B, 0x01, 0x29, 0x83, 0x32, 0x62, 0xCD,
    0x84, 0xA5, 0xE4, 0xF2, 0x54, 0xB8, 0x60, 0x9E, 0x31, 0xC1, 0xA2, 0xFD, 0xE6, 0x70, 0x6E, 0x55,
    0xEF, 0x5F, 0xC0, 0x3B, 0xDE, 0xEA, 0x58, 0x08, 0xFE, 0x41, 0x76, 0x87, 0x35, 0xBB, 0xE3, 0xF0,
    0x2F, 0x6E, 0x30, 0x1A, 0xB8, 0xFC, 0x42, 0xEC, 0x6A, 0xAF, 0x0F, 0x15, 0x89, 0xC9, 0xA2, 0xFC,
    0x2B, 0x15, 0x65, 0xFA, 0x9C, 0xC2, 0x9F, 0xC8, 0x00, 0x71, 0x3C, 0x33, 0x3A, 0x8D, 0xCD, 0x17,
    0x0D, 0xDB, 0xCF, 0x8A, 0x81, 0x52, 0x30, 0x58, 0x89, 0x2C, 0x0F, 0xB0, 0xE2, 0x3D, 0xC4, 0x1C,
    0x3E, 0x84, 0x20, 0xB6, 0xA2, 0x00, 0xF5, 0x9A, 0x0D, 0xC4, 0xD9, 0x97, 0x5A, 0x4E, 0x28, 0x2A,
    0x67, 0x15, 0x48, 0xAC, 0x77, 0x61, 0x31, 0xCA, 0xD5, 0x5F, 0x2C, 0x36, 0xBB, 0x75, 0xDA, 0x9C,
};
static const uint8_t rsa_pss_key_3072_SHA256_Sig[] =
{
    0x79, 0x76, 0xD4, 0x9E, 0xD9, 0x6E, 0x45, 0xF0, 0xD6, 0x0E, 0xAF, 0xCB, 0x01, 0x8F, 0x6E, 0xD4,
    0x9A, 0x89, 0xAE, 0x6F, 0x6B, 0x06, 0x82, 0x3C, 0xD3, 0xED, 0x4C, 0xC0, 0x4F, 0xD0, 0x10, 0xAD,
    0xE3, 0xA6, 0x0D, 0x6C, 0xD8, 0x23, 0x16, 0x81, 0x3A, 0x88, 0xDB, 0x38, 0xFE, 0x4E, 0xB8, 0x33,
    0x30, 0x35, 0x17, 0xC0, 0x88, 0x44, 0x9B, 0xE9, 0xCF, 0xDC, 0xA9, 0xF6, 0x8E, 0x92, 0xBF, 0x54,
    0xA5, 0x88, 0x22, 0xD5, 0xBA, 0x0F, 0x78, 0xC8, 0x9D, 0x08, 0x23, 0xF5, 0x38, 0x91, 0xB8, 0x33,
    0xCB, 0x40, 0x57, 0x66, 0x28, 0x33, 0xA3, 0x4C, 0x57, 0x2B, 0x68, 0xCA, 0x0F, 0x1C, 0x3B, 0xE7,
    0x5A, 0x2D, 0x1E, 0x32, 0xF1, 0xE5, 0x42, 0x92, 0x9A, 0xE5, 0xC0, 0x66, 0xD3, 0xAE, 0x0C, 0x45,
    0x53, 0x8F, 0x1C, 0x21, 0xEB, 0x75, 0x1D, 0x21, 0x10, 0xE6, 0x15, 0x6C, 0xFA, 0x19, 0x31, 0x55,
    0x1F, 0xE4, 0x0F, 0x34, 0xF1, 0xDA, 0x9C, 0xC1, 0x21, 0x17, 0xB1, 0xAE, 0x5B, 0xAE, 0xB0, 0x9F,
    0xD2, 0xAB, 0x45, 0x4E, 0x54, 0xBB, 0x05, 0x9C, 0x0E, 0x83, 0x0E, 0x04, 0xF4, 0x46, 0x9A, 0x5B,
    0xCE, 0x4D, 0x88, 0xC9, 0x22, 0x00, 0x99, 0x8D, 0xDA, 0x2C, 0x1C, 0x33, 0xE9, 0x55, 0x7E, 0x4D,
    0xE2, 0x47, 0xF2, 0xCD, 0x9D, 0x57, 0xA2, 0x59, 0x06, 0xA3, 0xF4, 0x7A, 0x01, 0x8F, 0xBC, 0x00,
    0x67, 0xD2, 0x36, 0x8C, 0x34, 0xB5, 0x23, 0x5A, 0xEF, 0xB8, 0x17, 0x2F, 0xDA, 0xB2, 0x83, 0x79,
    0x74, 0xAC, 0xE0, 0x67, 0x81, 0xD7, 0xCA, 0xFA, 0x3F, 0x81, 0x6B, 0xDC, 0xA8, 0xB7, 0xBC, 0xFB,
    0x55, 0x9B, 0xFC, 0x25, 0x8E, 0x70, 0x4F, 0x34, 0xC8, 0xDC, 0xCE, 0x23, 0xC6, 0x55, 0x98, 0x28,
    0xA7, 0x3D, 0x1B, 0xDE, 0xA5, 0xFD, 0xBB, 0x67, 0x3E, 0x70, 0x36, 0xC6, 0x5D, 0xF1, 0x35, 0xC3,
    0x23, 0x71, 0x27, 0xBC, 0x65, 0x3D, 0x1D, 0x9A, 0x88, 0x94, 0xB3, 0xBF, 0x64, 0x01, 0xDF, 0x16,
    0xAE, 0x67, 0x41, 0x5F, 0x3A, 0xFF, 0xB5, 0x55, 0x56, 0x9E, 0x59, 0xE1, 0xDA, 0x80, 0xF2, 0x86,
    0xBE, 0x0C, 0xEE, 0x1A, 0xE2, 0x05, 0x1A, 0x2D, 0x1D, 0xA3, 0xB2, 0x5C, 0x83, 0x14, 0x39, 0x14,
    0x9E, 0xB9, 0x03, 0x42, 0x77, 0x15, 0xCD, 0xDC, 0x2D, 0xF7, 0x5B, 0x23, 0xBF, 0x17, 0x97, 0x49,
    0x14, 0x16, 0xC5, 0x39, 0x4C, 0x77, 0x16, 0x84, 0x18, 0xA4, 0xF5, 0x9D, 0xD4, 0x02, 0x60, 0x12,
    0xF4, 0x97, 0x11, 0x38, 0xCB, 0xC9, 0x60, 0x99, 0xAC, 0x67, 0x62, 0x5F, 0x6E, 0x2F, 0x61, 0xF5,
    0xE1, 0xBE, 0xAE, 0x10, 0xAD, 0x5C, 0x24, 0xD9, 0x56, 0x2E, 0x88, 0x6F, 0xC9, 0x14, 0xCA, 0xCB,
    0xB9, 0x08, 0xC6, 0x87, 0x59, 0x8C, 0x00, 0xF7, 0x1D, 0x4B, 0x16, 0xE1, 0xC3, 0x70, 0x9E, 0x8B,
};
#ifdef DONOT_ENABLE_DEFINE_USED_FOR_REFERENCE_ONLY
static const uint8_t rsa_pss_key_3072_SHA256_Salt[] =
{
    0x63, 0x3C, 0x44, 0x25, 0x83, 0x9B, 0x2B, 0xA5, 0xAA, 0x73, 0x00, 0x4E, 0x77, 0xF5, 0x01, 0xF6,
    0xB7, 0xC8, 0x05, 0xAE, 0x89, 0xA4, 0xBA, 0xF4, 0xC1, 0x1D, 0x32, 0x2A, 0x8B, 0xBC, 0x9E, 0x47,
};
#endif


static const TestVector_RSA_PSS_Rec_t test_vectors_rsa_pss[] =
{
    {
        "rsa-pss-1024-sha1", 1024, 160,
        {
            rsa_pss_key_1024_SHA1_n, sizeof(rsa_pss_key_1024_SHA1_n),
            rsa_pss_key_1024_SHA1_e, sizeof(rsa_pss_key_1024_SHA1_e),
            rsa_pss_key_1024_SHA1_d, sizeof(rsa_pss_key_1024_SHA1_d)
        },
        rsa_pss_key_1024_SHA1_Msg, sizeof(rsa_pss_key_1024_SHA1_Msg),
        rsa_pss_key_1024_SHA1_Sig, sizeof(rsa_pss_key_1024_SHA1_Sig)
    },
    {
        "rsa-pss-1024-sha224", 1024, 224,
        {
            rsa_pss_key_1024_SHA224_n, sizeof(rsa_pss_key_1024_SHA224_n),
            rsa_pss_key_1024_SHA224_e, sizeof(rsa_pss_key_1024_SHA224_e),
            rsa_pss_key_1024_SHA224_d, sizeof(rsa_pss_key_1024_SHA224_d)
        },
        rsa_pss_key_1024_SHA224_Msg, sizeof(rsa_pss_key_1024_SHA224_Msg),
        rsa_pss_key_1024_SHA224_Sig, sizeof(rsa_pss_key_1024_SHA224_Sig)
    },
    {
        "rsa-pss-1024-sha256", 1024, 256,
        {
            rsa_pss_key_1024_SHA256_n, sizeof(rsa_pss_key_1024_SHA256_n),
            rsa_pss_key_1024_SHA256_e, sizeof(rsa_pss_key_1024_SHA256_e),
            rsa_pss_key_1024_SHA256_d, sizeof(rsa_pss_key_1024_SHA256_d)
        },
        rsa_pss_key_1024_SHA256_Msg, sizeof(rsa_pss_key_1024_SHA256_Msg),
        rsa_pss_key_1024_SHA256_Sig, sizeof(rsa_pss_key_1024_SHA256_Sig)
    },
    {
        "rsa-pss-2048-sha1", 2048, 160,
        {
            rsa_pss_key_2048_SHA1_n, sizeof(rsa_pss_key_2048_SHA1_n),
            rsa_pss_key_2048_SHA1_e, sizeof(rsa_pss_key_2048_SHA1_e),
            rsa_pss_key_2048_SHA1_d, sizeof(rsa_pss_key_2048_SHA1_d)
        },
        rsa_pss_key_2048_SHA1_Msg, sizeof(rsa_pss_key_2048_SHA1_Msg),
        rsa_pss_key_2048_SHA1_Sig, sizeof(rsa_pss_key_2048_SHA1_Sig)
    },
    {
        "rsa-pss-2048-sha224", 2048, 224,
        {
            rsa_pss_key_2048_SHA224_n, sizeof(rsa_pss_key_2048_SHA224_n),
            rsa_pss_key_2048_SHA224_e, sizeof(rsa_pss_key_2048_SHA224_e),
            rsa_pss_key_2048_SHA224_d, sizeof(rsa_pss_key_2048_SHA224_d)
        },
        rsa_pss_key_2048_SHA224_Msg, sizeof(rsa_pss_key_2048_SHA224_Msg),
        rsa_pss_key_2048_SHA224_Sig, sizeof(rsa_pss_key_2048_SHA224_Sig)
    },
    {
        "rsa-pss-2048-sha256", 2048, 256,
        {
            rsa_pss_key_2048_SHA256_n, sizeof(rsa_pss_key_2048_SHA256_n),
            rsa_pss_key_2048_SHA256_e, sizeof(rsa_pss_key_2048_SHA256_e),
            rsa_pss_key_2048_SHA256_d, sizeof(rsa_pss_key_2048_SHA256_d)
        },
        rsa_pss_key_2048_SHA256_Msg, sizeof(rsa_pss_key_2048_SHA256_Msg),
        rsa_pss_key_2048_SHA256_Sig, sizeof(rsa_pss_key_2048_SHA256_Sig)
    },
    {
        "rsa-pss-3072-sha1", 3072, 160,
        {
            rsa_pss_key_3072_SHA1_n, sizeof(rsa_pss_key_3072_SHA1_n),
            rsa_pss_key_3072_SHA1_e, sizeof(rsa_pss_key_3072_SHA1_e),
            rsa_pss_key_3072_SHA1_d, sizeof(rsa_pss_key_3072_SHA1_d)
        },
        rsa_pss_key_3072_SHA1_Msg, sizeof(rsa_pss_key_3072_SHA1_Msg),
        rsa_pss_key_3072_SHA1_Sig, sizeof(rsa_pss_key_3072_SHA1_Sig)
    },
    {
        "rsa-pss-3072-sha224", 3072, 224,
        {
            rsa_pss_key_3072_SHA224_n, sizeof(rsa_pss_key_3072_SHA224_n),
            rsa_pss_key_3072_SHA224_e, sizeof(rsa_pss_key_3072_SHA224_e),
            rsa_pss_key_3072_SHA224_d, sizeof(rsa_pss_key_3072_SHA224_d)
        },
        rsa_pss_key_3072_SHA224_Msg, sizeof(rsa_pss_key_3072_SHA224_Msg),
        rsa_pss_key_3072_SHA224_Sig, sizeof(rsa_pss_key_3072_SHA224_Sig)
    },
    {
        "rsa-pss-3072-sha256", 3072, 256,
        {
            rsa_pss_key_3072_SHA256_n, sizeof(rsa_pss_key_3072_SHA256_n),
            rsa_pss_key_3072_SHA256_e, sizeof(rsa_pss_key_3072_SHA256_e),
            rsa_pss_key_3072_SHA256_d, sizeof(rsa_pss_key_3072_SHA256_d)
        },
        rsa_pss_key_3072_SHA256_Msg, sizeof(rsa_pss_key_3072_SHA256_Msg),
        rsa_pss_key_3072_SHA256_Sig, sizeof(rsa_pss_key_3072_SHA256_Sig)
    }
};


//=============================================================================
// RSA OAEP

static const uint8_t rsa_oaep_key_1024_n[] =
{
    0xE1, 0x5E, 0xA1, 0xA6, 0x51, 0x44, 0x48, 0xEE, 0x1C, 0x8A, 0xCA, 0xB5, 0x10, 0x37, 0x3D, 0xCA,
    0xF4, 0xA1, 0x07, 0x4C, 0x20, 0x29, 0xFF, 0x83, 0x8D, 0xE7, 0x4B, 0x4C, 0xA1, 0x58, 0x67, 0x5E,
    0x07, 0x5C, 0x93, 0x22, 0x94, 0x7F, 0xBD, 0x82, 0xC3, 0xED, 0x45, 0xCC, 0x6B, 0xA5, 0xEC, 0x45,
    0x93, 0x39, 0x16, 0x81, 0x92, 0xCC, 0xC7, 0xC9, 0x74, 0xAC, 0x34, 0x8E, 0x15, 0xCB, 0xD3, 0x42,
    0x9F, 0x0C, 0xCC, 0x62, 0x7E, 0x37, 0x9B, 0x39, 0x9F, 0x52, 0x7F, 0xAD, 0x8D, 0x67, 0x96, 0xCC,
    0xA8, 0xD0, 0x6A, 0x50, 0x85, 0x2F, 0x49, 0x6D, 0x60, 0x8B, 0x58, 0x22, 0xE0, 0xD0, 0xB3, 0xBA,
    0x0E, 0x89, 0xB6, 0xA3, 0x0D, 0x46, 0xA9, 0x0E, 0x89, 0xD9, 0x44, 0x85, 0xC7, 0x99, 0x62, 0xAF,
    0x2A, 0x25, 0x34, 0xB5, 0x83, 0x90, 0xE4, 0x90, 0xA8, 0x83, 0x44, 0x75, 0x02, 0x81, 0xD9, 0x63,
};

static const uint8_t rsa_oaep_key_1024_e[] =
{
    0x00, 0x01, 0x00, 0x01,
};

static const uint8_t rsa_oaep_key_1024_d[] =
{
    0x03, 0xC6, 0x9C, 0x1A, 0xB7, 0x3D, 0xD7, 0xA2, 0xF5, 0xA3, 0x75, 0xA5, 0xF6, 0xF1, 0x95, 0xFD,
    0x72, 0x7F, 0xC8, 0x29, 0x84, 0x58, 0x6F, 0xC9, 0x7A, 0x75, 0x27, 0x93, 0xCF, 0x18, 0x36, 0x13,
    0x23, 0x38, 0x6F, 0xD6, 0xA2, 0x7A, 0x49, 0x68, 0x89, 0x73, 0xCE, 0x39, 0x90, 0x8C, 0x25, 0x1B,
    0x3D, 0x4E, 0x35, 0x8C, 0x52, 0x33, 0x50, 0x1D, 0x95, 0xF0, 0xD4, 0xA8, 0x94, 0xC0, 0xE7, 0x77,
    0x2C, 0x38, 0xAB, 0x6A, 0x6E, 0x96, 0x47, 0x9C, 0xB9, 0xDD, 0x7D, 0xBA, 0x4B, 0x4F, 0x6B, 0x68,
    0xBB, 0xA9, 0xC6, 0x89, 0x79, 0x3E, 0x52, 0xDE, 0x83, 0x57, 0x53, 0x07, 0xBD, 0xBB, 0x3D, 0x4D,
    0xF6, 0x39, 0x49, 0x0C, 0x10, 0xE0, 0x65, 0x74, 0x21, 0x71, 0x32, 0x22, 0xCE, 0x8B, 0x7B, 0xD1,
    0x8F, 0xBF, 0xB3, 0x29, 0xE2, 0x03, 0xF4, 0xB3, 0x45, 0x2E, 0x0F, 0x37, 0x43, 0x0D, 0x17, 0xD1,
};

static const uint8_t rsa_oaep_key_2048_n[] =
{
    0xCA, 0xBF, 0x76, 0xF4, 0x1B, 0xA3, 0xE7, 0x23, 0x59, 0x9C, 0x7B, 0xF9, 0xB9, 0x13, 0x3F, 0xFB,
    0x09, 0x42, 0xA2, 0xD0, 0x80, 0xCA, 0xD9, 0xB0, 0xE3, 0xCB, 0x6F, 0x82, 0x0C, 0xC6, 0x65, 0xFA,
    0x7D, 0x6A, 0x6B, 0x64, 0x1A, 0x3D, 0x40, 0xF3, 0xD1, 0x7A, 0x53, 0xBC, 0x43, 0xD5, 0x30, 0x96,
    0xBB, 0x1C, 0x95, 0xE5, 0x8E, 0xE7, 0xC3, 0xE8, 0xD9, 0xE7, 0x16, 0x2B, 0x99, 0xC3, 0x67, 0xA3,
    0x3E, 0x09, 0xF3, 0x2B, 0x8C, 0x7B, 0x88, 0x99, 0x5F, 0xC3, 0xC1, 0xDF, 0x0C, 0x7D, 0x57, 0xA6,
    0xAC, 0x67, 0x71, 0x68, 0x52, 0x8C, 0xD4, 0xCA, 0x8C, 0xDA, 0xE2, 0x39, 0xB6, 0x3A, 0x81, 0x67,
    0x00, 0x22, 0x26, 0x13, 0x4D, 0x42, 0x32, 0xE1, 0xC8, 0xFB, 0xAD, 0x25, 0x54, 0x4A, 0x94, 0x9E,
    0x85, 0x86, 0xB1, 0x8E, 0x00, 0x57, 0x77, 0x04, 0xFA, 0x21, 0xD3, 0xD0, 0x62, 0x53, 0xB2, 0xEA,
    0xEB, 0x73, 0x0A, 0x61, 0x2D, 0x92, 0x60, 0xA7, 0x62, 0x7E, 0x1B, 0x68, 0xD0, 0x05, 0xB9, 0xF1,
    0xDE, 0xF3, 0x08, 0x35, 0x8D, 0x84, 0x66, 0x6B, 0x54, 0x64, 0x2E, 0x72, 0x09, 0x74, 0x92, 0x17,
    0x44, 0x53, 0xBA, 0x65, 0xB2, 0xD2, 0x31, 0x4E, 0x90, 0xED, 0x4D, 0x16, 0x27, 0x3E, 0x03, 0x5C,
    0x93, 0x74, 0xAE, 0x0B, 0xC6, 0xF9, 0x28, 0x10, 0xA8, 0x0F, 0x8B, 0x2F, 0xAF, 0xA4, 0x8D, 0xAE,
    0x61, 0xCE, 0x82, 0xE0, 0x84, 0x10, 0x89, 0x97, 0x95, 0xE6, 0x3A, 0x53, 0xC2, 0x88, 0x11, 0xBF,
    0x40, 0xFF, 0xF8, 0x62, 0x9C, 0x5C, 0x7D, 0x31, 0x11, 0xD5, 0x01, 0x69, 0xE9, 0xD1, 0xC0, 0x59,
    0xA2, 0xC0, 0xB3, 0xFF, 0x2F, 0x3A, 0x15, 0xDD, 0x18, 0x29, 0xAB, 0x03, 0x8B, 0xF3, 0x17, 0x32,
    0x51, 0xBC, 0x69, 0x47, 0xC5, 0xEF, 0x9A, 0x7D, 0x39, 0xF8, 0xD9, 0x9E, 0xBC, 0xB6, 0x44, 0x8D,
};

static const uint8_t rsa_oaep_key_2048_e[] =
{
    0x00, 0x01, 0x00, 0x01,
};

static const uint8_t rsa_oaep_key_2048_d[] =
{
    0xC9, 0xDF, 0x56, 0x2B, 0xBC, 0x91, 0xB8, 0x05, 0x04, 0xA6, 0xC0, 0xF2, 0x67, 0x0A, 0xF9, 0xBB,
    0x94, 0xFE, 0xDA, 0x6A, 0x4C, 0xB2, 0xAD, 0x8A, 0x69, 0x66, 0x18, 0x03, 0x1F, 0x81, 0x33, 0xEC,
    0xF3, 0x8F, 0x50, 0x9A, 0x7D, 0x5D, 0xDC, 0x1C, 0x68, 0xC9, 0x2A, 0x32, 0xDC, 0x3F, 0x9B, 0x7F,
    0x99, 0x92, 0xDE, 0xD5, 0x91, 0x32, 0xC7, 0x68, 0x43, 0xFE, 0xC9, 0x9E, 0x64, 0x1D, 0xA2, 0x45,
    0x71, 0xF2, 0x2A, 0x43, 0x84, 0x3F, 0x44, 0x45, 0xA2, 0x8A, 0xA1, 0xB0, 0xDB, 0x18, 0xBA, 0x7B,
    0x64, 0x52, 0x23, 0x23, 0x42, 0x7E, 0xA3, 0x29, 0x82, 0x92, 0x36, 0x8A, 0x4C, 0x1D, 0x78, 0xD6,
    0xFB, 0xD5, 0x04, 0xA0, 0x57, 0x5E, 0xC0, 0x96, 0xFB, 0xAD, 0x4C, 0x3B, 0x4C, 0xF0, 0x6D, 0x86,
    0x61, 0x61, 0x39, 0xCD, 0x30, 0x1D, 0xE6, 0x8D, 0xF8, 0x18, 0x52, 0x74, 0xBC, 0x52, 0xA6, 0x63,
    0x66, 0x8B, 0x80, 0xE7, 0x83, 0xEE, 0x4E, 0x86, 0xB3, 0x37, 0x6C, 0xB3, 0x5D, 0x55, 0x63, 0xB9,
    0x76, 0xCB, 0x85, 0xD6, 0xF1, 0xAA, 0xFA, 0x7C, 0xA2, 0x5C, 0x59, 0xF0, 0x75, 0xEE, 0x69, 0x52,
    0x17, 0xC8, 0x2D, 0x6D, 0x3E, 0xE2, 0x90, 0x81, 0xF4, 0xC3, 0x28, 0x47, 0x0B, 0xB0, 0x99, 0x0F,
    0xD2, 0xDF, 0x8F, 0xE1, 0x01, 0xF9, 0x53, 0xAC, 0xB1, 0x82, 0x6B, 0x27, 0x5C, 0x74, 0xCF, 0xCA,
    0x48, 0x27, 0x22, 0xBD, 0x20, 0x28, 0xAB, 0x5A, 0xE5, 0x9C, 0xA5, 0xBD, 0xC4, 0x96, 0x32, 0xCB,
    0x6B, 0x42, 0x48, 0x4D, 0xAC, 0x98, 0x0D, 0x99, 0x8C, 0xC5, 0x89, 0x83, 0xDF, 0x5A, 0x09, 0xC2,
    0xBC, 0x1E, 0x54, 0x62, 0x54, 0x77, 0xA7, 0x47, 0x64, 0xD0, 0x46, 0xDE, 0x3B, 0x49, 0x10, 0xEE,
    0x96, 0xF3, 0xA9, 0xEC, 0xC8, 0x19, 0xF9, 0x1A, 0x77, 0x05, 0x05, 0xF5, 0xEA, 0x4F, 0xF9, 0x01,
};

static const uint8_t rsa_oaep_key_3072_n[] =
{
    0xAF, 0x73, 0xBD, 0xFB, 0xF2, 0xA3, 0xF0, 0x21, 0x7F, 0x7F, 0x22, 0x68, 0xBC, 0x4B, 0x39, 0xED,
    0xBD, 0x1D, 0x10, 0x37, 0x7B, 0x70, 0xD6, 0xC4, 0xB7, 0x14, 0xF8, 0x50, 0x54, 0x36, 0x63, 0x90,
    0x73, 0xF6, 0x63, 0x11, 0x41, 0x64, 0x9D, 0x26, 0xF1, 0xF5, 0x7C, 0xD6, 0x6B, 0x45, 0xAB, 0x40,
    0xD5, 0xC2, 0x3C, 0x55, 0x95, 0x76, 0x53, 0x8B, 0x35, 0x31, 0x1C, 0x97, 0x03, 0x25, 0x6F, 0x5C,
    0x20, 0x57, 0x43, 0xA9, 0xEB, 0x6C, 0x50, 0xDD, 0x96, 0xE1, 0xA8, 0xB7, 0x1D, 0xA6, 0x44, 0x3C,
    0xFF, 0xC2, 0xDA, 0x4E, 0xB9, 0xA8, 0x95, 0x83, 0x80, 0xAE, 0x94, 0xE7, 0xBE, 0xF6, 0x67, 0x6A,
    0x02, 0x5F, 0x0A, 0x7A, 0x0E, 0xCF, 0xB2, 0xE5, 0xDB, 0x7B, 0x50, 0x94, 0xCF, 0xF2, 0x25, 0x09,
    0x49, 0xF3, 0xD0, 0x10, 0x27, 0xD6, 0x06, 0xE5, 0x74, 0xD0, 0xC5, 0x3B, 0xF7, 0xCA, 0x55, 0x10,
    0xB6, 0xE3, 0x44, 0xEE, 0x9D, 0xAD, 0xBC, 0x2A, 0x60, 0x04, 0x92, 0x69, 0xF1, 0xAE, 0x0F, 0x54,
    0x7B, 0x28, 0x48, 0x27, 0x42, 0x11, 0x7D, 0x90, 0xBC, 0x2E, 0x7E, 0xB0, 0x21, 0xFD, 0xC7, 0xE7,
    0x0D, 0x8D, 0x6C, 0x71, 0xAE, 0xFB, 0x09, 0x77, 0xD3, 0x88, 0xDC, 0x10, 0xD0, 0x7A, 0xCD, 0xFF,
    0x25, 0xA5, 0x67, 0x89, 0xFA, 0x4D, 0xAC, 0x26, 0x8F, 0x35, 0xE0, 0x4B, 0xA1, 0xAC, 0xBB, 0xC4,
    0xE1, 0x1D, 0x2D, 0x7F, 0x87, 0xEE, 0x86, 0x2A, 0x74, 0xD4, 0x70, 0x72, 0x95, 0xFA, 0xAE, 0x46,
    0xB0, 0x4A, 0xDF, 0xD1, 0xD2, 0x72, 0x34, 0xCC, 0xE4, 0xAB, 0x0C, 0x71, 0x3E, 0x86, 0xCE, 0x2C,
    0xD7, 0x69, 0x74, 0x18, 0xF9, 0xD2, 0x56, 0x8B, 0xDE, 0x4F, 0x67, 0x0F, 0x22, 0xAF, 0xCB, 0xDF,
    0x72, 0x84, 0x5D, 0x3A, 0xC1, 0x50, 0x55, 0x93, 0xB1, 0xB6, 0xBB, 0x18, 0x08, 0x19, 0x47, 0x03,
    0xE9, 0x96, 0xBC, 0xD8, 0xC3, 0x3A, 0x87, 0xF0, 0x47, 0xBF, 0x67, 0xC9, 0xE4, 0x35, 0xA6, 0x8B,
    0xBD, 0xB6, 0x42, 0x43, 0x25, 0x07, 0x46, 0xAF, 0xA9, 0x35, 0x8E, 0x7F, 0x74, 0x54, 0x77, 0x1F,
    0xC6, 0xCC, 0x09, 0x10, 0x64, 0xB6, 0xAE, 0xE8, 0x23, 0x72, 0x89, 0xB2, 0x6B, 0xC3, 0x86, 0x8E,
    0x13, 0x80, 0x21, 0x04, 0x7B, 0xD6, 0x4F, 0xFB, 0x30, 0x30, 0x76, 0xB6, 0x6A, 0x61, 0x2B, 0x6E,
    0x51, 0x16, 0x71, 0xC0, 0xFD, 0x3E, 0xEF, 0x6D, 0x83, 0xC9, 0xAC, 0x30, 0x3F, 0xC3, 0x25, 0xD1,
    0x46, 0xBC, 0x20, 0xED, 0xC8, 0x41, 0x47, 0xA8, 0x0C, 0xCB, 0x51, 0x97, 0x1D, 0xBD, 0xD7, 0xB0,
    0x49, 0x36, 0x3C, 0x72, 0x66, 0x55, 0xD7, 0x2E, 0xA9, 0x9C, 0xC2, 0x20, 0xE0, 0x70, 0xE0, 0xCC,
    0x3F, 0x93, 0x03, 0xCB, 0x7F, 0x9F, 0x38, 0xB9, 0x59, 0xA1, 0xA0, 0x30, 0x33, 0xB0, 0x10, 0xB5,
};

static const uint8_t rsa_oaep_key_3072_e[] =
{
    0x00, 0x01, 0x00, 0x01,
};

static const uint8_t rsa_oaep_key_3072_d[] =
{
    0x45, 0x0B, 0x29, 0x12, 0x42, 0xB3, 0xDC, 0xC5, 0x71, 0xE4, 0xD7, 0xE7, 0x9B, 0x61, 0x87, 0x14,
    0x55, 0x3D, 0x60, 0xAA, 0x54, 0xBB, 0x5C, 0xE8, 0xE0, 0x9B, 0x31, 0xF4, 0x7A, 0x8F, 0x44, 0xB3,
    0x0D, 0xCF, 0x41, 0xC1, 0x02, 0x98, 0xD3, 0x77, 0x05, 0xF4, 0x73, 0x01, 0xF6, 0x08, 0xDE, 0x91,
    0x8F, 0x0C, 0xF6, 0xAD, 0x3F, 0x39, 0xE7, 0x3A, 0x7A, 0xDE, 0x2E, 0xC0, 0x06, 0x8E, 0xEE, 0xB9,
    0xB4, 0x48, 0x62, 0xEA, 0x35, 0x28, 0xD4, 0xD1, 0xBE, 0x94, 0x62, 0xCE, 0x5C, 0xAE, 0x97, 0x5F,
    0xE1, 0xCE, 0x0E, 0x16, 0xB8, 0xDC, 0xEC, 0xA9, 0x69, 0x34, 0x4A, 0x88, 0xC0, 0x0F, 0x3B, 0x36,
    0xEE, 0x63, 0xF4, 0x3D, 0x80, 0x22, 0x9F, 0xE5, 0xF0, 0x6F, 0x20, 0x90, 0xCF, 0x1C, 0x1D, 0x13,
    0x00, 0xB5, 0x1F, 0x85, 0x9C, 0x07, 0x8F, 0x83, 0x30, 0x6B, 0x0F, 0x92, 0xBF, 0xBA, 0x31, 0xAB,
    0x78, 0x2D, 0x0B, 0x6D, 0x53, 0x43, 0x91, 0x2E, 0xA3, 0xC6, 0x68, 0xCF, 0xA4, 0x39, 0xB8, 0xF2,
    0xA7, 0xDC, 0x7C, 0x38, 0x66, 0xB9, 0x77, 0x4E, 0x43, 0x9F, 0x90, 0x5F, 0x43, 0xA1, 0x18, 0xCF,
    0x85, 0xF7, 0xC7, 0x5B, 0x1D, 0x5E, 0xD0, 0xA5, 0x04, 0xEB, 0x70, 0x9E, 0x75, 0x4C, 0x3E, 0x50,
    0x4F, 0xC2, 0x3D, 0x72, 0x80, 0xBB, 0x9C, 0x29, 0x38, 0x66, 0x1D, 0x33, 0xE6, 0x15, 0x91, 0x76,
    0x0B, 0xC5, 0xA4, 0x04, 0xF5, 0x1D, 0xB4, 0xB6, 0x72, 0xCA, 0xC0, 0x9F, 0x02, 0x0D, 0x1A, 0x82,
    0x14, 0x7D, 0x80, 0xCB, 0x40, 0x1C, 0x25, 0x0A, 0xD0, 0xDD, 0x9A, 0xDD, 0x87, 0xED, 0xBF, 0xFE,
    0xC6, 0xAD, 0xB6, 0x73, 0x9F, 0x36, 0x6A, 0xCB, 0x5F, 0x6A, 0xFA, 0x82, 0x88, 0x4D, 0x5E, 0xB3,
    0x42, 0x25, 0xB9, 0xBB, 0x53, 0xC7, 0xE0, 0x50, 0x76, 0x96, 0x76, 0x20, 0x7D, 0x96, 0x16, 0x6C,
    0x05, 0x2C, 0x84, 0xFF, 0x78, 0x29, 0xB3, 0x90, 0xE3, 0x5E, 0x27, 0x44, 0xAC, 0x4A, 0xB0, 0xD0,
    0x4A, 0xC2, 0xCE, 0x8A, 0x16, 0x24, 0xD8, 0xBC, 0xE5, 0xF8, 0x18, 0x09, 0xD4, 0xB8, 0x5E, 0x33,
    0x47, 0xAE, 0x63, 0x57, 0x6E, 0xD2, 0xC5, 0x54, 0x72, 0x9F, 0xBD, 0x32, 0x4D, 0xD9, 0x95, 0x77,
    0xDE, 0x3E, 0xCF, 0xDA, 0xDD, 0xB7, 0x32, 0xC9, 0x07, 0xC4, 0x8D, 0xCB, 0x71, 0x2A, 0x4C, 0x60,
    0xAF, 0x67, 0x55, 0xFD, 0x9C, 0xF4, 0x61, 0x54, 0x8F, 0x05, 0x5F, 0xCB, 0x9C, 0xF0, 0x6D, 0xDF,
    0x19, 0x34, 0xCE, 0x2F, 0x48, 0x21, 0x00, 0xD7, 0x42, 0xA2, 0x79, 0x52, 0x92, 0xDC, 0x1E, 0x26,
    0x53, 0x27, 0x31, 0xA6, 0x57, 0x30, 0x6E, 0x01, 0x2D, 0xDC, 0x98, 0x00, 0x12, 0xDF, 0xE2, 0xBA,
    0xC5, 0x51, 0x8F, 0xF7, 0xE9, 0x1C, 0xC0, 0x8C, 0x14, 0xD7, 0x58, 0x77, 0x2A, 0xA7, 0x96, 0x81,
};


static const uint8_t rsa_oaep_addinput_1024_sha1[] =
{
    0x28, 0x1C, 0x81, 0xCB, 0x9A, 0xC1, 0x44, 0x48, 0x6D, 0xFD, 0xB7, 0xF2, 0x89, 0x8D, 0xFD, 0x30,
    0xC8, 0xCA, 0xD8, 0xC0, 0x27, 0xA9, 0xEC, 0x90, 0x5C, 0xF3, 0x8F, 0x69, 0x9D, 0xCD, 0x3A, 0x04,
    0x87, 0xF0, 0xAE, 0xA1, 0xA0, 0x7F, 0xBB, 0x3F, 0xE4, 0x46, 0xF1, 0xED, 0x13, 0x72, 0xBE, 0x73,
    0x82, 0xCE, 0xB4, 0xF5, 0x2A, 0xEC, 0xED, 0xA2, 0xF0, 0x40, 0xE1, 0xC6, 0x9C, 0x17, 0x07, 0x02,
    0x40, 0xC3, 0x62, 0xC6, 0xA0, 0x63, 0xE1, 0x09, 0x77, 0xD4, 0x20, 0xB5, 0x53, 0x06, 0x79, 0x85,
    0x0A, 0x90, 0x58, 0x01, 0x30, 0x1C, 0x8A, 0x0B, 0xED, 0xD8, 0xF1, 0x50, 0xE7, 0xFB, 0xC3, 0x46,
    0xAB, 0x98, 0x67, 0x4E, 0x0F, 0x20, 0x22, 0x7B, 0xA4, 0xC3, 0x0B, 0xD2, 0x0B, 0x8E, 0xBE, 0xA1,
    0xF3, 0x58, 0x95, 0x15, 0x8F, 0xD0, 0x33, 0x42, 0xB3, 0x40, 0x42, 0xEF, 0xFF, 0x27, 0xE6, 0x8D,
};

static const uint8_t rsa_oaep_addinputhash_1024_sha1[] =
{
    0xE5, 0xC0, 0xF2, 0xF4, 0x17, 0xF2, 0x2B, 0x78, 0xFE, 0x63, 0x00, 0xE6, 0xDC, 0x3C, 0x85, 0x29,
    0xD7, 0xB3, 0x9C, 0x31,
};

static const uint8_t rsa_oaep_plaindata_1024_sha1[] =
{
    0x4D, 0x7A, 0x95, 0xE8, 0x81, 0x48, 0xC1, 0x9E, 0x40, 0xE8, 0xFB, 0xCF, 0xE6, 0x4F, 0xBA, 0xE6,
    0xAF, 0x78, 0x19, 0x6F, 0x9C, 0xE9, 0xF7, 0x7A, 0xDD, 0x42, 0xCE, 0x8C, 0x03, 0xB8, 0x66, 0xD3,
    0xAB, 0x00, 0x7E, 0xDE, 0x3E, 0x53, 0xDE, 0x30, 0x91, 0x3D, 0xF7, 0xCD, 0x72, 0x14, 0x51, 0x82,
    0xEE, 0x1B, 0x8D, 0xB4, 0x8C, 0xD0, 0x8A, 0xF6, 0x9A, 0x96, 0x71, 0x98, 0x62, 0x93,
};

static const uint8_t rsa_oaep_wrappeddata_1024_sha1[] =
{
    0x89, 0x9B, 0x76, 0x63, 0xF2, 0xE6, 0x1F, 0x68, 0x9E, 0x11, 0x7C, 0xD4, 0xF5, 0xAD, 0xC6, 0x12,
    0x60, 0x08, 0x4B, 0x23, 0x30, 0x48, 0xD6, 0x9E, 0x6A, 0xEB, 0x0D, 0x51, 0x5C, 0xE6, 0xA9, 0x47,
    0x43, 0xEA, 0x6A, 0xB7, 0x69, 0x11, 0x19, 0xC2, 0x45, 0x4D, 0x11, 0x70, 0x5A, 0x3F, 0xA7, 0x87,
    0x35, 0xF4, 0x74, 0xDA, 0xF4, 0x16, 0x16, 0x48, 0xD4, 0xC3, 0xA2, 0x2D, 0x49, 0x8E, 0x82, 0x57,
    0x4F, 0xAC, 0xF1, 0x55, 0xEF, 0xDF, 0xC2, 0x2F, 0xA2, 0xE5, 0xA7, 0x0F, 0x20, 0xE4, 0xE1, 0xDB,
    0x5C, 0xBC, 0xFE, 0x07, 0x2D, 0x6D, 0xB5, 0xDA, 0x8B, 0xED, 0xB1, 0x9A, 0x1E, 0x04, 0x9B, 0xF4,
    0x66, 0x3C, 0x5A, 0x27, 0x14, 0x99, 0xE8, 0xEF, 0xC4, 0x08, 0x46, 0x34, 0x57, 0x83, 0x1F, 0x5B,
    0xA0, 0x53, 0x7C, 0x12, 0xDC, 0x20, 0x21, 0x73, 0x14, 0x21, 0xA5, 0x8D, 0xFE, 0x7B, 0x3B, 0xCD,
};


static const uint8_t rsa_oaep_addinput_2048_sha224[] =
{
    0x84, 0x6D, 0x5F, 0x85, 0x0E, 0x71, 0xC2, 0x78, 0x83, 0x4D, 0xDF, 0x4C, 0x2D, 0x20, 0xB9, 0xBE,
    0xC7, 0xFE, 0x4B, 0x53, 0x64, 0x6C, 0x09, 0x6E, 0x9E, 0xE9, 0x88, 0x79, 0xFD, 0xBC, 0xE6, 0x84,
    0xDF, 0x24, 0xD1, 0x2E, 0xCB, 0xB1, 0x51, 0x7F, 0x8B, 0xF2, 0x80, 0xB2, 0x31, 0x35, 0x35, 0xDA,
    0xEF, 0x00, 0x18, 0x6E, 0x96, 0x83, 0xAF, 0xF8, 0x05, 0xC5, 0xC3, 0xB4, 0x42, 0x1B, 0xB5, 0x01,
    0xC3, 0xDE, 0x2B, 0x3A, 0x50, 0x61, 0xF9, 0xC6, 0x51, 0x3F, 0x48, 0x5F, 0x07, 0xCF, 0x64, 0x38,
    0x56, 0x1E, 0x5D, 0x5C, 0xEA, 0x95, 0x67, 0x3E, 0x7F, 0x0A, 0xA8, 0x57, 0xE1, 0xE8, 0x0F, 0x5F,
    0x19, 0xB8, 0xD7, 0xC0, 0xB5, 0x4A, 0xC1, 0x35, 0x5F, 0xF8, 0xDF, 0xCE, 0x19, 0x6C, 0xAA, 0xD2,
    0x25, 0xC9, 0xF6, 0xA2, 0x04, 0xC5, 0x44, 0x13, 0x23, 0x44, 0x29, 0x09, 0x61, 0x11, 0x62, 0xC5,
};

static const uint8_t rsa_oaep_addinputhash_2048_sha224[] =
{
    0xD7, 0xF5, 0x15, 0x05, 0xC3, 0x52, 0x55, 0xC6, 0x3C, 0x36, 0x13, 0xB2, 0x6A, 0xEB, 0xF0, 0x57,
    0x8A, 0xE6, 0x33, 0xA5, 0x40, 0xED, 0x14, 0xC7, 0xB6, 0x8F, 0x56, 0x9B,
};

static const uint8_t rsa_oaep_plaindata_2048_sha224[] =
{
    0x54, 0xCD, 0xDB, 0x2D, 0xDE, 0x45, 0xC1, 0x39, 0xC8, 0xC8, 0xC7, 0xA9, 0x67, 0xAB, 0x1F, 0xD5,
    0x70, 0xAA, 0x16, 0x02, 0x4F, 0x3A, 0xD7, 0xAF, 0xAE, 0xD3, 0x21, 0xE4, 0x2B, 0x6C, 0xFF, 0x9F,
    0x87, 0x0A, 0x2D, 0xE5, 0x9A, 0x22, 0x47, 0xC4, 0xF8, 0x32, 0x15, 0x4C, 0x89, 0xAB, 0xAA, 0xB3,
    0x87, 0xEB, 0x52, 0x9C, 0x12, 0x7B, 0x8D, 0xEE, 0xB6, 0xA0, 0x70, 0x93, 0x3C, 0xC7,
};

static const uint8_t rsa_oaep_wrappeddata_2048_sha224[] =
{
    0xC4, 0x81, 0xA7, 0x5A, 0xC6, 0x1C, 0xFB, 0x4A, 0x00, 0xAA, 0x58, 0xBB, 0x51, 0x0A, 0x31, 0xC0,
    0x91, 0xFD, 0x12, 0x14, 0x3C, 0x6E, 0xA6, 0x1F, 0x26, 0x4A, 0x9D, 0x1C, 0x35, 0x65, 0xCB, 0xB5,
    0xA8, 0xEC, 0x2B, 0x9A, 0xC7, 0xA8, 0x86, 0xE4, 0xEF, 0xD5, 0xA3, 0x6C, 0x92, 0x30, 0x42, 0x93,
    0x7B, 0x71, 0x53, 0xF8, 0xA9, 0xEF, 0x4A, 0x6C, 0x52, 0x4F, 0x5D, 0xA9, 0x8F, 0x34, 0x1D, 0x44,
    0xA8, 0xF3, 0x44, 0xBC, 0x8D, 0x47, 0x15, 0xD0, 0xDA, 0x1D, 0x02, 0x53, 0xF8, 0xD2, 0x06, 0xA2,
    0x37, 0x59, 0x6B, 0x2A, 0x0C, 0x33, 0x71, 0xCF, 0xE3, 0x2B, 0xB2, 0x76, 0xE5, 0x53, 0x42, 0xFD,
    0x18, 0x63, 0x7A, 0x3B, 0xFD, 0x4E, 0xA6, 0x0B, 0xDA, 0xD0, 0x50, 0x69, 0xAE, 0xEE, 0xFA, 0xF2,
    0x6D, 0xEC, 0x1B, 0x66, 0x75, 0x21, 0xE3, 0xAA, 0xA2, 0x38, 0x56, 0x73, 0x65, 0x18, 0xCA, 0x48,
    0xF0, 0xF9, 0x1D, 0xB5, 0xF5, 0x35, 0x8B, 0xB6, 0xF3, 0x88, 0x9F, 0x12, 0x95, 0x1B, 0x85, 0x64,
    0x0D, 0xFF, 0xEC, 0xCC, 0x58, 0xFA, 0x37, 0x7D, 0x06, 0x6F, 0xB6, 0xC6, 0x7E, 0x52, 0xBB, 0xA5,
    0x1B, 0x33, 0x92, 0xD4, 0x42, 0xFF, 0xC8, 0x88, 0x46, 0x16, 0x62, 0x86, 0x4A, 0x02, 0xCD, 0x52,
    0xD3, 0xEB, 0x65, 0xC0, 0x80, 0xD4, 0xBD, 0x08, 0x2F, 0x35, 0x68, 0x18, 0x7F, 0x19, 0xFC, 0xC1,
    0xDF, 0x4D, 0xA5, 0x32, 0x48, 0x73, 0x94, 0xC3, 0x13, 0x21, 0xBD, 0x5C, 0x1F, 0x56, 0xBE, 0x5B,
    0x17, 0xE7, 0x7E, 0x64, 0xCE, 0x4D, 0x26, 0x4F, 0x4F, 0xD1, 0xDE, 0xF6, 0xC7, 0x8C, 0xEA, 0x4C,
    0xE0, 0xBF, 0x4B, 0x7D, 0x4E, 0xAC, 0xAC, 0xD4, 0xBA, 0x43, 0x83, 0x9F, 0x56, 0x51, 0x89, 0x5E,
    0x29, 0xE1, 0x32, 0xB0, 0x6A, 0x7B, 0x7B, 0xDA, 0x75, 0x8D, 0x5A, 0xD4, 0x7C, 0xA4, 0x7F, 0x99,
};


static const uint8_t rsa_oaep_addinput_3072_sha256[] =
{
    0x2C, 0xE1, 0x5C, 0xF2, 0xD3, 0xB6, 0x6B, 0xB8, 0xE5, 0xFB, 0x45, 0xD4, 0xE1, 0xC7, 0xA5, 0x5B,
    0xEF, 0x83, 0xA3, 0xFE, 0x55, 0x01, 0xF2, 0x1C, 0xA3, 0xC7, 0xD7, 0xF4, 0x9C, 0xC5, 0xBC, 0x9D,
    0xDF, 0xFE, 0x56, 0x3B, 0x14, 0x40, 0xA9, 0x4E, 0x00, 0x89, 0xAD, 0x38, 0x76, 0xAF, 0xD7, 0x76,
    0xC9, 0x4B, 0x1B, 0x77, 0x50, 0x34, 0xFB, 0x02, 0x5A, 0x53, 0x5C, 0xC7, 0x9B, 0x27, 0x2B, 0xB6,
    0x53, 0xF4, 0x67, 0xC3, 0x82, 0x26, 0x4E, 0xA4, 0xCD, 0x50, 0x55, 0x66, 0xD7, 0x0B, 0xF7, 0xD5,
    0x60, 0x70, 0xE1, 0x70, 0x0D, 0x6C, 0xB2, 0x5C, 0x50, 0xCE, 0x6C, 0xEF, 0xB8, 0x57, 0xAB, 0x6D,
    0x8F, 0x89, 0xEB, 0xF9, 0x9D, 0xCC, 0xDD, 0xE2, 0xAB, 0x2E, 0xBA, 0x02, 0x87, 0x9E, 0x3B, 0xB5,
    0x6E, 0x37, 0xE7, 0xAA, 0xC7, 0xC3, 0xFD, 0xA8, 0x25, 0x34, 0xC3, 0xCE, 0x5D, 0x84, 0x0A, 0x03,
};

static const uint8_t rsa_oaep_addinputhash_3072_sha256[] =
{
    0x6C, 0x01, 0xF6, 0x04, 0x4B, 0x9F, 0x94, 0xA3, 0xB8, 0xEF, 0xAA, 0x33, 0x0D, 0xBA, 0x8F, 0x75,
    0xAA, 0x0A, 0x85, 0x7D, 0xAB, 0x48, 0x26, 0xAF, 0xFD, 0x57, 0x5A, 0x97, 0x9C, 0x73, 0x89, 0xCC,
};

static const uint8_t rsa_oaep_plaindata_3072_sha256[] =
{
    0x38, 0x2E, 0x2F, 0xF3, 0x74, 0x55, 0x8D, 0xCE, 0x3B, 0x97, 0xD6, 0x6F, 0x83, 0x99, 0x42, 0x57,
    0xCD, 0x9E, 0xAD, 0x3E, 0x4E, 0x9D, 0x30, 0xE4, 0xEF, 0x1E, 0x06, 0x63, 0x4F, 0x19, 0xC7, 0xEE,
    0x81, 0xEB, 0xF7, 0x42, 0xCD, 0xA7, 0x51, 0xDC, 0x2E, 0x8B, 0x79, 0x1F, 0x52, 0x56, 0xA6, 0x7C,
    0xF7, 0x18, 0x7C, 0x1A, 0xC6, 0xF4, 0x4A, 0x1A, 0xA0, 0x1E, 0x1C, 0x27, 0x57, 0x7B,
};

static const uint8_t rsa_oaep_wrappeddata_3072_sha256[] =
{
    0x48, 0xE6, 0x08, 0x78, 0x54, 0xED, 0xBC, 0xE3, 0xE1, 0x68, 0xED, 0x2C, 0x82, 0x61, 0x2D, 0x5A,
    0x07, 0x3F, 0x6A, 0xED, 0x2F, 0x2E, 0x25, 0x60, 0x9C, 0xE4, 0x2E, 0xF1, 0x35, 0x15, 0xE9, 0x37,
    0xBA, 0xAA, 0x10, 0x79, 0x26, 0xD3, 0x2F, 0x4E, 0xF6, 0x6F, 0x8A, 0xFF, 0x3E, 0xCA, 0xED, 0xA9,
    0x00, 0x5E, 0x1E, 0xC7, 0xF2, 0x5B, 0xD2, 0xB0, 0x55, 0xB0, 0x4B, 0xDA, 0x30, 0x98, 0x81, 0xC8,
    0xF8, 0x8D, 0x66, 0x21, 0x99, 0x04, 0x5D, 0xA6, 0xD1, 0xE7, 0x98, 0x42, 0x5D, 0x61, 0x6B, 0x65,
    0x51, 0xD7, 0xD2, 0xB5, 0x88, 0x92, 0x13, 0x09, 0xE0, 0x1A, 0x55, 0x1C, 0x7A, 0x1A, 0x7C, 0xD0,
    0xD1, 0x10, 0x6E, 0xE2, 0x59, 0xAC, 0x34, 0xCF, 0x04, 0xFE, 0x35, 0x1C, 0x76, 0x2E, 0x02, 0x76,
    0x0D, 0x2C, 0x6D, 0xB0, 0x6F, 0xCA, 0x8B, 0xE2, 0x80, 0x92, 0xB4, 0xE8, 0xD3, 0x3E, 0x91, 0xD7,
    0xB2, 0x76, 0xD7, 0x05, 0xEC, 0xAA, 0xED, 0x2B, 0x06, 0xC9, 0x25, 0xDF, 0xE2, 0x01, 0xFD, 0x93,
    0x0C, 0x5C, 0x88, 0x71, 0xC4, 0x83, 0x78, 0x1F, 0x6D, 0xE0, 0xFE, 0x86, 0xC1, 0x17, 0x80, 0xEB,
    0x9F, 0xB9, 0xE5, 0xED, 0x99, 0x8C, 0x24, 0x0C, 0x3F, 0xCC, 0x4E, 0x3B, 0x40, 0x23, 0x4B, 0x04,
    0x73, 0xBB, 0xE7, 0x2E, 0xDF, 0xD6, 0x39, 0x2C, 0x81, 0x3F, 0x31, 0x73, 0x20, 0xB2, 0x33, 0x6B,
    0xB2, 0xBF, 0x4E, 0x8D, 0x1B, 0xA1, 0xF2, 0x11, 0x4C, 0xAC, 0x53, 0xC8, 0xAD, 0x39, 0xAA, 0x91,
    0x1B, 0x19, 0x3B, 0xB5, 0x40, 0x98, 0x57, 0x96, 0x53, 0xBB, 0x99, 0xE6, 0xC9, 0x3D, 0x86, 0xBE,
    0x00, 0x5A, 0x95, 0x07, 0x44, 0x30, 0x9C, 0x6F, 0xFF, 0x0A, 0xE6, 0x75, 0x25, 0x03, 0x85, 0x0B,
    0xC1, 0xB6, 0x66, 0xB6, 0xA4, 0xF2, 0x19, 0xBC, 0x98, 0x9A, 0x5E, 0xB9, 0xF2, 0xE3, 0x63, 0x5C,
    0x91, 0xD4, 0xE4, 0x69, 0xB7, 0x28, 0xF0, 0xA1, 0x4E, 0x1B, 0x23, 0x86, 0xD3, 0x39, 0xE5, 0xE9,
    0x85, 0xD6, 0x37, 0x47, 0x54, 0xA0, 0x68, 0x3F, 0x54, 0xAA, 0x22, 0xCF, 0xF6, 0x31, 0xD2, 0xF4,
    0x89, 0xF5, 0x6A, 0xF4, 0x1D, 0x26, 0xA8, 0x81, 0x19, 0xF1, 0x26, 0x8C, 0xBE, 0x18, 0x6D, 0xE4,
    0xD5, 0x75, 0xFE, 0x2E, 0x9E, 0xC5, 0xDD, 0x81, 0xA2, 0xBC, 0x75, 0x4E, 0x6A, 0x6F, 0x83, 0xA4,
    0x0A, 0xFC, 0xE9, 0xCF, 0x7D, 0x01, 0x6E, 0x55, 0xDE, 0xB6, 0x28, 0x77, 0x01, 0x7B, 0x83, 0xC9,
    0x48, 0xD1, 0xA2, 0x53, 0xB2, 0x2C, 0x90, 0x2D, 0x99, 0x7A, 0xB2, 0x56, 0x6A, 0xE5, 0x16, 0x8D,
    0x86, 0x9B, 0x0D, 0x74, 0x9B, 0x9C, 0xEB, 0x17, 0x08, 0xCC, 0x67, 0xD6, 0xC6, 0x46, 0xC8, 0x3A,
    0x42, 0x3A, 0x4C, 0xA2, 0xD3, 0x1F, 0xE0, 0x91, 0xEA, 0xDE, 0x9D, 0x20, 0xB4, 0x94, 0xF0, 0xA1,
};


static const TestVector_RSA_OAEP_Rec_t test_vectors_rsa_oaep[] =
{
    {
        "rsa-oaep-1024-sha1", 1024, 160,
        {
            rsa_oaep_key_1024_n, sizeof(rsa_oaep_key_1024_n),
            rsa_oaep_key_1024_e, sizeof(rsa_oaep_key_1024_e),
            rsa_oaep_key_1024_d, sizeof(rsa_oaep_key_1024_d)
        },
        rsa_oaep_addinput_1024_sha1, sizeof(rsa_oaep_addinput_1024_sha1),
        rsa_oaep_addinputhash_1024_sha1, sizeof(rsa_oaep_addinputhash_1024_sha1),
        rsa_oaep_plaindata_1024_sha1, sizeof(rsa_oaep_plaindata_1024_sha1),
        rsa_oaep_wrappeddata_1024_sha1, sizeof(rsa_oaep_wrappeddata_1024_sha1)
    },
    {
        "rsa-oaep-2048-sha224", 2048, 224,
        {
            rsa_oaep_key_2048_n, sizeof(rsa_oaep_key_2048_n),
            rsa_oaep_key_2048_e, sizeof(rsa_oaep_key_2048_e),
            rsa_oaep_key_2048_d, sizeof(rsa_oaep_key_2048_d)
        },
        rsa_oaep_addinput_2048_sha224, sizeof(rsa_oaep_addinput_2048_sha224),
        rsa_oaep_addinputhash_2048_sha224, sizeof(rsa_oaep_addinputhash_2048_sha224),
        rsa_oaep_plaindata_2048_sha224, sizeof(rsa_oaep_plaindata_2048_sha224),
        rsa_oaep_wrappeddata_2048_sha224, sizeof(rsa_oaep_wrappeddata_2048_sha224)
    },
    {
        "rsa-oaep-3072-sha256", 3072, 256,
        {
            rsa_oaep_key_3072_n, sizeof(rsa_oaep_key_3072_n),
            rsa_oaep_key_3072_e, sizeof(rsa_oaep_key_3072_e),
            rsa_oaep_key_3072_d, sizeof(rsa_oaep_key_3072_d)
        },
        rsa_oaep_addinput_3072_sha256, sizeof(rsa_oaep_addinput_3072_sha256),
        rsa_oaep_addinputhash_3072_sha256, sizeof(rsa_oaep_addinputhash_3072_sha256),
        rsa_oaep_plaindata_3072_sha256, sizeof(rsa_oaep_plaindata_3072_sha256),
        rsa_oaep_wrappeddata_3072_sha256, sizeof(rsa_oaep_wrappeddata_3072_sha256)
    },
};


//=============================================================================
// RSA PKCS#1v1.5 WRAP
// - 1K RSA-PKCS1-[Un]Wrap example:
static const uint8_t rsa_pkcs1v15wrap_key_1024_n[] =
{
    0x97, 0x6D, 0xFA, 0x68, 0xAF, 0x25, 0x16, 0x7D, 0x6A, 0x28, 0xFC, 0xEB, 0x91, 0xC1, 0x5B, 0x34,
    0x5E, 0xA7, 0x08, 0x23, 0x6F, 0x6F, 0x63, 0x07, 0xDA, 0x61, 0x05, 0x8B, 0xBD, 0x78, 0x23, 0x7A,
    0x12, 0x3B, 0x92, 0x92, 0xF5, 0x76, 0x45, 0x98, 0x72, 0x76, 0x11, 0x62, 0x6A, 0x76, 0x26, 0xCE,
    0x39, 0xF0, 0x01, 0xC1, 0x12, 0x7A, 0x86, 0xB7, 0xAA, 0x7F, 0xAA, 0x0A, 0xFD, 0xEB, 0x3A, 0xDA,
    0x33, 0x06, 0x4E, 0xFE, 0x0E, 0xB2, 0x6E, 0x88, 0x76, 0x60, 0x5A, 0x32, 0xF6, 0xC1, 0xA2, 0x01,
    0x7C, 0x16, 0x48, 0xC9, 0x46, 0x8F, 0x26, 0xE2, 0x3E, 0x41, 0x00, 0xB9, 0xCE, 0xAD, 0x53, 0x3A,
    0xB5, 0x7A, 0x92, 0x4E, 0x13, 0xE4, 0x86, 0x7C, 0x23, 0x99, 0x9B, 0x63, 0xE7, 0xA9, 0x98, 0xEC,
    0x54, 0x1D, 0x0B, 0xDC, 0x78, 0xB4, 0x72, 0x17, 0xBF, 0xDC, 0x10, 0xFF, 0xD1, 0xDE, 0x58, 0xC9
};

static const uint8_t rsa_pkcs1v15wrap_key_1024_e[] =
{
    0x00, 0x01, 0x00, 0x01,
};

static const uint8_t rsa_pkcs1v15wrap_key_1024_d[] =
{
    0x05, 0xE5, 0x8A, 0x72, 0xB9, 0x1F, 0x40, 0x98, 0xF1, 0xA1, 0x56, 0xF7, 0xF5, 0x5D, 0x0A, 0x28,
    0x27, 0xE7, 0x69, 0x31, 0xB8, 0x0D, 0x26, 0x56, 0x0F, 0xF2, 0xE7, 0x3C, 0x61, 0xCC, 0x63, 0xD5,
    0x45, 0x10, 0x7C, 0xCC, 0xAC, 0x32, 0x46, 0xD3, 0x80, 0xE1, 0x88, 0x1B, 0xC4, 0xF9, 0x84, 0xD9,
    0x52, 0xF8, 0x3D, 0x99, 0x3F, 0x16, 0xF6, 0x58, 0x00, 0x93, 0xA8, 0x13, 0x75, 0x7F, 0xCB, 0x72,
    0xD4, 0x5E, 0x3E, 0x64, 0xC6, 0x66, 0x75, 0x6A, 0x01, 0x0E, 0x27, 0x2B, 0x30, 0xA4, 0x78, 0x8F,
    0xD3, 0xED, 0x3E, 0x45, 0x4C, 0xFB, 0x5D, 0x27, 0x1D, 0x05, 0xED, 0xB9, 0xF3, 0x14, 0xFD, 0xDB,
    0x5A, 0x89, 0x54, 0x35, 0xF1, 0xD3, 0xFF, 0xB6, 0xDA, 0xBD, 0xCD, 0x3C, 0x95, 0xC7, 0x23, 0xAE,
    0xCB, 0xF4, 0xE0, 0x33, 0x29, 0xAE, 0x12, 0x47, 0x7E, 0x3D, 0x05, 0x07, 0xAA, 0x07, 0xB1, 0x81
};

static const uint8_t rsa_pkcs1v15wrap_pt_1024[] =
{
    0x1C, 0x58, 0xF5, 0x21, 0xF7, 0x5C, 0x79, 0x4A, 0xEF, 0xF5, 0xA2, 0x2F, 0xFE, 0x1A, 0x94, 0x28,
    0xE5, 0xF2, 0xCD, 0x50, 0x3E, 0xC1, 0x4A, 0x6B, 0x0B, 0x21, 0x05, 0x13, 0x12, 0x6B, 0x8C, 0xBD
};

static const uint8_t rsa_pkcs1v15wrap_ct_1024[] =
{
    0x58, 0x96, 0x55, 0xDC, 0x91, 0x5D, 0x8D, 0xBF, 0xB3, 0xE7, 0x18, 0xF7, 0xA3, 0x4F, 0x0F, 0x30,
    0x3A, 0xC0, 0x67, 0xB4, 0xC6, 0x82, 0x86, 0xEF, 0x54, 0xF2, 0xBD, 0xD0, 0x69, 0x21, 0xBE, 0x82,
    0xAF, 0xA1, 0xCB, 0x7D, 0x26, 0xB5, 0x56, 0x77, 0x92, 0x77, 0x3D, 0xA6, 0xB9, 0x70, 0x92, 0x2A,
    0xDA, 0xA3, 0x73, 0x8E, 0x3A, 0xE1, 0x96, 0x78, 0xCB, 0xDF, 0x47, 0x80, 0x65, 0x6A, 0x8D, 0xA8,
    0x49, 0xA5, 0x53, 0xED, 0x4D, 0x83, 0x71, 0xF6, 0x22, 0xE4, 0x66, 0x6A, 0xDE, 0x6D, 0xA8, 0x9C,
    0x31, 0x63, 0x78, 0x50, 0xA7, 0x25, 0xF9, 0xDF, 0xFA, 0x68, 0xEC, 0x17, 0x20, 0x26, 0x29, 0x81,
    0x0A, 0x5F, 0x92, 0x93, 0xBA, 0x78, 0x7E, 0x2D, 0xC2, 0xD7, 0x45, 0xAB, 0x3E, 0xFF, 0x25, 0x18,
    0x9B, 0xD1, 0xC5, 0x2C, 0xE8, 0x2C, 0x17, 0x0B, 0x11, 0x9A, 0x98, 0x05, 0xFD, 0xBE, 0xF9, 0x18
};


// - 2K RSA-PKCS1-[Un]Wrap example:
static const uint8_t rsa_pkcs1v15wrap_key_2048_n[] =
{
    0xE1, 0x5F, 0xA0, 0x44, 0x6A, 0x30, 0xA4, 0xE9, 0x53, 0x07, 0xFD, 0x03, 0x2C, 0xC4, 0x1D, 0xE7,
    0xE9, 0x87, 0x94, 0x0E, 0x39, 0x45, 0x25, 0xD2, 0x7A, 0x0E, 0xDE, 0xBE, 0x6A, 0x1B, 0xBB, 0xD8,
    0x4E, 0xBD, 0x71, 0xF9, 0x9B, 0x8E, 0x1C, 0x69, 0x90, 0x85, 0xC6, 0x1F, 0x5B, 0x4F, 0x69, 0x6E,
    0xB7, 0x50, 0x61, 0x13, 0x08, 0xCD, 0x92, 0x96, 0x39, 0xB7, 0xF7, 0x96, 0x47, 0x1D, 0x66, 0x4B,
    0xC1, 0xED, 0x25, 0xBB, 0xF8, 0x54, 0xBF, 0x8F, 0x48, 0x62, 0xDF, 0x70, 0xD2, 0x62, 0x7A, 0x3E,
    0xF7, 0xB0, 0xE2, 0x33, 0x4D, 0x1A, 0x86, 0x8F, 0x1E, 0xB9, 0xE6, 0xD0, 0x67, 0x99, 0x2D, 0x06,
    0x19, 0xD8, 0x7C, 0xCD, 0x20, 0x1F, 0x68, 0x00, 0xDA, 0x73, 0x32, 0xD7, 0x00, 0x69, 0x8C, 0x45,
    0xD1, 0xB6, 0x04, 0xA1, 0xC3, 0x2C, 0xFA, 0x92, 0xDE, 0x61, 0x2E, 0xF6, 0x6A, 0xB8, 0x8E, 0xC5,
    0xBB, 0x20, 0x30, 0x2F, 0x59, 0x1A, 0x40, 0xF1, 0x43, 0xAA, 0xD1, 0x8B, 0x8D, 0x54, 0x6D, 0x7F,
    0xBF, 0x46, 0x82, 0x4A, 0x2D, 0xD4, 0xB2, 0x52, 0xF6, 0xB7, 0x75, 0xE4, 0x62, 0xE2, 0x89, 0x51,
    0x74, 0xE5, 0x5A, 0x35, 0x61, 0x6A, 0x57, 0x51, 0x7A, 0x98, 0x07, 0x21, 0xF6, 0x08, 0x02, 0x91,
    0x39, 0xAC, 0xED, 0xA8, 0x63, 0x9E, 0xF8, 0x81, 0x80, 0x52, 0x34, 0x2F, 0xC7, 0x81, 0x9F, 0x6F,
    0x5E, 0x8A, 0xB5, 0x25, 0x8F, 0x7C, 0xD0, 0x46, 0xE2, 0xF1, 0x02, 0xD9, 0x70, 0x3C, 0x60, 0x4F,
    0xB4, 0x52, 0x58, 0x3C, 0x01, 0xE7, 0xEC, 0x6A, 0xB6, 0x70, 0xB7, 0xAB, 0x0E, 0xFB, 0x85, 0xB7,
    0x86, 0xD6, 0x1C, 0xFB, 0x52, 0xB3, 0x9E, 0x71, 0x96, 0x3F, 0x47, 0x02, 0x29, 0x04, 0x75, 0x4E,
    0x48, 0x32, 0xAC, 0xC6, 0x23, 0xC7, 0x28, 0x9D, 0x7C, 0x73, 0x7A, 0x22, 0x16, 0x47, 0xA1, 0x25
};

static const uint8_t rsa_pkcs1v15wrap_key_2048_e[] =
{
    0x00, 0x01, 0x00, 0x01,
};

static const uint8_t rsa_pkcs1v15wrap_key_2048_d[] =
{
    0x7D, 0x37, 0x60, 0x18, 0x22, 0xD7, 0xBC, 0x08, 0x56, 0xB5, 0x8D, 0x81, 0x82, 0x11, 0xC4, 0x7B,
    0xE1, 0x68, 0x0E, 0x7E, 0x88, 0x9B, 0x3E, 0x94, 0x5E, 0x74, 0x7C, 0x95, 0x56, 0xE6, 0xE9, 0xCB,
    0x18, 0x94, 0x71, 0x0A, 0xB9, 0xBE, 0x8F, 0x52, 0xA7, 0x95, 0x6B, 0xAA, 0x68, 0x55, 0x0A, 0xC3,
    0x14, 0xDE, 0x77, 0xD0, 0xD7, 0x87, 0x3F, 0xF6, 0x6F, 0x43, 0x23, 0x30, 0x3F, 0x7A, 0xBA, 0x27,
    0x45, 0x2B, 0xB9, 0x57, 0x62, 0x75, 0xD3, 0xA8, 0x8C, 0x13, 0x43, 0x09, 0xB0, 0x1A, 0x3E, 0xC9,
    0x55, 0x5C, 0xD5, 0x90, 0xA3, 0x3A, 0x25, 0xA0, 0xC6, 0xF5, 0x8A, 0xA4, 0x27, 0xAB, 0x17, 0x34,
    0xD8, 0x8F, 0x4B, 0x67, 0xBC, 0x7D, 0x36, 0x8F, 0xA2, 0xCF, 0x76, 0x63, 0xB6, 0x3A, 0xEE, 0x50,
    0xAC, 0x5F, 0x70, 0xDB, 0x5F, 0x51, 0x52, 0x36, 0xDF, 0x8F, 0x27, 0x44, 0x89, 0xAE, 0xD8, 0xC3,
    0x40, 0x76, 0xBB, 0x36, 0xBB, 0x32, 0x75, 0x52, 0xDC, 0x32, 0x52, 0x82, 0xA4, 0xE5, 0xFA, 0x10,
    0xA7, 0x5C, 0xC6, 0xE4, 0xF4, 0x8B, 0x56, 0x91, 0xE3, 0x3F, 0x87, 0xB7, 0xAB, 0x02, 0x7C, 0xA8,
    0x91, 0x7F, 0xB1, 0x95, 0xF9, 0xE3, 0x6A, 0x39, 0xAD, 0x0E, 0x5D, 0x39, 0x5F, 0x01, 0xAA, 0xBE,
    0xF3, 0xF1, 0x14, 0xEE, 0x49, 0xE6, 0x1F, 0xD9, 0x58, 0xF4, 0x2D, 0xBF, 0x26, 0x9B, 0x88, 0x35,
    0xFB, 0x68, 0x06, 0x6E, 0x66, 0x3E, 0x02, 0xA0, 0x4D, 0x01, 0x3F, 0xEC, 0xBE, 0x0B, 0xEA, 0xF1,
    0x7A, 0xD8, 0x1A, 0x3A, 0xFF, 0xC1, 0x67, 0x98, 0x6D, 0x5A, 0x4D, 0x03, 0x4B, 0x37, 0xBE, 0x7D,
    0xA7, 0x0C, 0xB1, 0x22, 0x34, 0xD6, 0x11, 0x1F, 0x13, 0xCD, 0x85, 0xA6, 0xA2, 0x16, 0x54, 0x54,
    0x65, 0x47, 0xCA, 0x04, 0xD0, 0x0A, 0xC1, 0x4B, 0xD2, 0xB0, 0x16, 0xFD, 0xCE, 0x9D, 0xF9, 0x01
};

static const uint8_t rsa_pkcs1v15wrap_pt_2048[] =
{
    0xF3, 0x2C, 0x2B, 0xA8, 0x28, 0x1C, 0x81, 0xCB, 0x9A, 0xC1, 0x44, 0x48, 0x6D, 0xFD, 0xB7, 0xF2
};

static const uint8_t rsa_pkcs1v15wrap_ct_2048[] =
{
    0xCD, 0x5B, 0x51, 0x59, 0xF6, 0x2E, 0xF0, 0x35, 0x00, 0xC1, 0xD9, 0xB3, 0x18, 0xE4, 0xD1, 0x69,
    0xA3, 0xE1, 0x4E, 0xAD, 0x9C, 0xE9, 0x85, 0xD4, 0x8E, 0x5E, 0xB3, 0xCB, 0x2E, 0x4E, 0x84, 0x53,
    0xA3, 0xE4, 0x33, 0x6A, 0x48, 0x9D, 0x88, 0xA4, 0x03, 0x0E, 0x32, 0x06, 0x86, 0x33, 0xA7, 0xF4,
    0xBA, 0xBD, 0xCD, 0x8D, 0x92, 0x6F, 0xF3, 0x92, 0x5A, 0x6D, 0x99, 0x3C, 0x28, 0xB1, 0x6C, 0xA6,
    0x8E, 0xA2, 0xA6, 0x9C, 0x61, 0x06, 0x38, 0x07, 0xEE, 0x8A, 0xF7, 0xB9, 0x0B, 0xC0, 0x58, 0x56,
    0xE4, 0x8B, 0x4F, 0x14, 0x1C, 0x11, 0xC2, 0xCB, 0xCC, 0xFD, 0xF8, 0x25, 0xB3, 0x48, 0xD9, 0x4D,
    0x6A, 0xF3, 0xA9, 0x14, 0x24, 0xF8, 0x91, 0x21, 0xAB, 0x3F, 0xA6, 0x8F, 0x18, 0x83, 0x16, 0x76,
    0x7F, 0x4E, 0x74, 0x00, 0x3C, 0x93, 0xAC, 0x11, 0x05, 0xD3, 0xDF, 0x9C, 0x3B, 0x60, 0xA9, 0x75,
    0x83, 0xB7, 0x91, 0xF7, 0x26, 0x85, 0xA4, 0x96, 0x9F, 0x39, 0xA9, 0xF6, 0x49, 0x1D, 0xBB, 0xAB,
    0x98, 0xDD, 0x75, 0xDB, 0x19, 0x60, 0x0F, 0xF1, 0xFD, 0xA9, 0x0A, 0x64, 0x4F, 0xB5, 0x1B, 0x99,
    0x16, 0x1B, 0xCA, 0x98, 0x1C, 0xE9, 0x79, 0xC9, 0x46, 0xAF, 0xD9, 0x8F, 0xD1, 0xBA, 0x3F, 0x69,
    0xEF, 0x6D, 0xDC, 0xD1, 0xCD, 0x90, 0xCD, 0x68, 0xAA, 0x29, 0xA1, 0xF0, 0x38, 0x54, 0xF0, 0x6A,
    0x3A, 0x05, 0x72, 0xF1, 0x16, 0xEB, 0xC7, 0x2D, 0xC8, 0xE9, 0xDA, 0x4F, 0xDC, 0xEF, 0x91, 0x79,
    0x62, 0xA5, 0x2F, 0x05, 0xE4, 0x28, 0xF0, 0x24, 0xA5, 0xC3, 0x3B, 0x0F, 0xF7, 0x4C, 0x43, 0xBB,
    0xAC, 0xD9, 0x6A, 0xB4, 0x50, 0xDF, 0xA7, 0x94, 0xF6, 0x36, 0x92, 0x53, 0xC0, 0xAF, 0x3D, 0x44,
    0x23, 0xBB, 0x74, 0x58, 0x28, 0x22, 0x75, 0xC4, 0xB9, 0xDA, 0x10, 0x22, 0x45, 0xC8, 0xC3, 0x54
};

// - 3K RSA-PKCS1-[Un]Wrap example:
static const uint8_t rsa_pkcs1v15wrap_key_3072_n[] =
{
    0x90, 0xE4, 0x65, 0xFE, 0x88, 0x85, 0x92, 0xEE, 0x52, 0x43, 0x52, 0x7F, 0x35, 0x0D, 0xF9, 0x2A,
    0x05, 0x1D, 0x17, 0x97, 0x6D, 0xE4, 0xCF, 0x56, 0x68, 0x6D, 0xD0, 0x79, 0x83, 0x96, 0x17, 0x49,
    0xC4, 0x24, 0x5C, 0xB9, 0xBD, 0x54, 0xB1, 0x3C, 0x75, 0xE4, 0x75, 0x29, 0x59, 0x3D, 0x57, 0x33,
    0xEE, 0xAA, 0xCF, 0xB4, 0x23, 0x4D, 0xC1, 0xAC, 0x8C, 0xD4, 0x7B, 0x3B, 0x4E, 0x62, 0xF8, 0x47,
    0x65, 0x52, 0xFF, 0x2D, 0x55, 0x1E, 0xEE, 0x9E, 0xAD, 0x63, 0x4D, 0xC3, 0xD6, 0xDE, 0x6F, 0xF3,
    0xDB, 0x1A, 0x33, 0x59, 0x55, 0x57, 0xA0, 0x83, 0x0A, 0xAF, 0xFC, 0xE0, 0x72, 0x0A, 0x41, 0x63,
    0xDD, 0xE9, 0x4C, 0x21, 0xF2, 0x29, 0x0F, 0xC5, 0x81, 0xC0, 0xD8, 0x16, 0x60, 0x27, 0xA6, 0xF0,
    0xE6, 0xF9, 0x01, 0xF3, 0x37, 0x5D, 0xD4, 0x0F, 0x87, 0xD4, 0x32, 0x55, 0xEA, 0x0B, 0x05, 0x56,
    0xDD, 0x41, 0x78, 0xC0, 0x59, 0xC4, 0x99, 0x05, 0x98, 0xE0, 0xEE, 0x46, 0x33, 0x0D, 0xF3, 0xFA,
    0xBE, 0x9B, 0x28, 0x11, 0x01, 0x9E, 0x22, 0xF6, 0x24, 0x14, 0xE0, 0x1B, 0xB5, 0xA4, 0xB2, 0x4D,
    0x2F, 0x5D, 0xB1, 0x08, 0x27, 0x3E, 0x29, 0x0B, 0x1C, 0xBA, 0x5B, 0xCD, 0xAF, 0xE4, 0x72, 0x80,
    0x0E, 0x31, 0xF1, 0x38, 0xC9, 0xD1, 0x61, 0xAB, 0x5E, 0x52, 0x30, 0x87, 0xF4, 0xCD, 0x57, 0xBA,
    0x24, 0x28, 0x7A, 0x56, 0x37, 0x46, 0x58, 0xCF, 0xE2, 0xC5, 0xF5, 0x94, 0xE6, 0xBA, 0xFC, 0x4C,
    0xCE, 0xFE, 0x9F, 0x0F, 0x79, 0x91, 0x23, 0x1C, 0x45, 0xB5, 0x42, 0xEF, 0x41, 0x5E, 0x14, 0x5A,
    0x06, 0x5D, 0xD1, 0xE0, 0x3C, 0xC0, 0x17, 0x76, 0xFC, 0x09, 0x15, 0x5A, 0xD0, 0xEA, 0xBE, 0x66,
    0x9B, 0x09, 0xD0, 0x22, 0xCE, 0xC9, 0x9A, 0xC1, 0xC8, 0xFC, 0xC0, 0x43, 0x20, 0x6B, 0x23, 0x16,
    0x21, 0x46, 0xB0, 0xF4, 0xD8, 0xD1, 0x1B, 0xD0, 0x3E, 0xE1, 0x05, 0x9A, 0x2D, 0x58, 0x9B, 0x2C,
    0xD0, 0xB7, 0x87, 0xD0, 0x41, 0x6D, 0xC3, 0x25, 0xC5, 0xBD, 0xC3, 0x04, 0x57, 0x63, 0x6F, 0x50,
    0x4B, 0x45, 0x2D, 0xCA, 0xD9, 0x29, 0xD1, 0xFF, 0xF1, 0x4B, 0x21, 0xF2, 0xFB, 0x6E, 0x28, 0x08,
    0x03, 0x84, 0xD2, 0x54, 0xFA, 0xA2, 0xCC, 0x81, 0x83, 0xBC, 0x5A, 0x34, 0xE5, 0xDA, 0x1F, 0xF0,
    0x91, 0x54, 0x82, 0x50, 0x7E, 0x65, 0xF4, 0x2E, 0xAF, 0x4E, 0x4F, 0x4F, 0xFF, 0xF7, 0xE6, 0x4D,
    0xF7, 0x88, 0x22, 0x21, 0x5A, 0xEA, 0xAD, 0x6C, 0x53, 0x92, 0xDD, 0xEB, 0x72, 0x8E, 0xEC, 0xC8,
    0xA3, 0x42, 0x19, 0x67, 0x88, 0x4E, 0xFB, 0xE8, 0x03, 0xF5, 0x3A, 0x6E, 0xAF, 0xA9, 0x38, 0xFB,
    0x8F, 0x7F, 0x0A, 0xA3, 0x76, 0x8D, 0x4E, 0xD9, 0x0E, 0xF2, 0x06, 0x9A, 0xA4, 0xD9, 0xF2, 0xFF
};

static const uint8_t rsa_pkcs1v15wrap_key_3072_e[] =
{
    0x00, 0x01, 0x00, 0x01,
};

static const uint8_t rsa_pkcs1v15wrap_key_3072_d[] =
{
    0x54, 0xE2, 0x19, 0x86, 0xA6, 0x80, 0x6A, 0x75, 0xC8, 0x27, 0xBC, 0x9A, 0xDD, 0x80, 0x14, 0x2A,
    0xB3, 0xD8, 0x39, 0x4B, 0xF3, 0x8B, 0x8A, 0x94, 0x3A, 0x95, 0xAA, 0xFE, 0xA5, 0x42, 0x36, 0xDE,
    0x76, 0x54, 0x3F, 0x26, 0x69, 0x6E, 0xC6, 0x6E, 0x7F, 0x3A, 0x9A, 0x10, 0xE1, 0x40, 0xF8, 0x67,
    0x6A, 0x39, 0x13, 0x79, 0x9A, 0xFD, 0x20, 0xAB, 0x6F, 0xCD, 0xC3, 0x6C, 0x19, 0x1E, 0x0E, 0x09,
    0xF5, 0xA8, 0x4B, 0xEA, 0x48, 0xE5, 0xD8, 0x31, 0x89, 0xAE, 0x95, 0x8E, 0x57, 0xC0, 0xF4, 0xA1,
    0x4E, 0x08, 0xE9, 0x70, 0x3A, 0x79, 0x1D, 0x85, 0xE7, 0xAA, 0xF6, 0x60, 0x9F, 0x2E, 0xB6, 0xE4,
    0x44, 0xCB, 0x3A, 0x58, 0xE0, 0xBF, 0x81, 0x87, 0xD9, 0xDE, 0x1A, 0x39, 0xF1, 0x97, 0x09, 0x4C,
    0x34, 0x64, 0x48, 0xEA, 0x2D, 0xD3, 0x80, 0x3A, 0xA0, 0xFE, 0x85, 0x86, 0xA3, 0x98, 0x55, 0x46,
    0x70, 0x54, 0xBC, 0xE3, 0x23, 0x33, 0xF3, 0xD9, 0xBD, 0x98, 0x78, 0xBF, 0x13, 0x85, 0xE7, 0x1B,
    0x4C, 0xB3, 0x25, 0x23, 0xE1, 0x68, 0xBD, 0x5E, 0xAA, 0x00, 0xB8, 0xD2, 0x42, 0xF5, 0xFB, 0xA7,
    0x10, 0x4A, 0xB9, 0x3D, 0xE7, 0x8F, 0x99, 0x07, 0xF3, 0x8A, 0x91, 0xE1, 0xCC, 0x5B, 0xEF, 0x60,
    0x69, 0xF0, 0x84, 0x3B, 0x1A, 0xB0, 0xD9, 0xA1, 0x45, 0x9E, 0xAC, 0xE3, 0xD9, 0x5C, 0xBB, 0x39,
    0x65, 0x14, 0x71, 0x4D, 0x68, 0xF9, 0x68, 0x9B, 0xE7, 0x9C, 0x31, 0xB4, 0x19, 0x87, 0x95, 0x89,
    0x6C, 0x95, 0x6D, 0x81, 0x3D, 0x98, 0x4F, 0x1D, 0x54, 0x21, 0xC0, 0x55, 0x85, 0x77, 0x25, 0x85,
    0xFB, 0x3D, 0x74, 0xAD, 0x1E, 0xF4, 0x2B, 0x29, 0x1A, 0xBD, 0x5F, 0x23, 0x65, 0x9A, 0x19, 0x34,
    0x69, 0x43, 0x1B, 0x54, 0xD2, 0xFE, 0x39, 0xB1, 0x99, 0xFF, 0x1A, 0x7E, 0x3C, 0x15, 0x13, 0xFF,
    0x1D, 0x6E, 0x3F, 0xE7, 0x82, 0xDC, 0xED, 0x33, 0x21, 0xA3, 0xC6, 0x22, 0xD2, 0x26, 0xAE, 0x88,
    0xB2, 0x2F, 0xF0, 0xF8, 0x0E, 0x13, 0x80, 0x4A, 0xCE, 0x86, 0xBD, 0x81, 0xF1, 0xA0, 0xDE, 0x5C,
    0xBD, 0x25, 0x26, 0xE4, 0xA7, 0x6E, 0xB7, 0x4B, 0x2C, 0x5C, 0xB6, 0xFC, 0x14, 0x35, 0x78, 0x4B,
    0x73, 0x54, 0x2E, 0x6B, 0xA3, 0xAB, 0x10, 0x77, 0x7E, 0xEB, 0xD9, 0x24, 0x7A, 0x22, 0x25, 0xB3,
    0x6F, 0x8F, 0x66, 0x12, 0x4A, 0x62, 0x15, 0x41, 0x6F, 0x39, 0xF4, 0xE3, 0x92, 0x88, 0x6D, 0x5E,
    0x26, 0x2F, 0x5D, 0x8C, 0x41, 0xE8, 0xA5, 0x09, 0x40, 0x82, 0xEB, 0xEB, 0x9D, 0xA6, 0xEA, 0x72,
    0x06, 0x32, 0x73, 0xF6, 0x3F, 0x13, 0xB3, 0xE6, 0x4E, 0xC8, 0x3F, 0xF9, 0x07, 0x97, 0x25, 0xD4,
    0x46, 0x49, 0x83, 0x12, 0xCA, 0x00, 0x35, 0x80, 0x4D, 0x8A, 0xB1, 0xC7, 0xED, 0x97, 0x6E, 0xC1
};

static const uint8_t rsa_pkcs1v15wrap_pt_3072[] =
{
    0x01, 0xDC, 0x8E, 0xC1, 0x7D, 0xB0, 0xEE, 0x8F, 0xDF, 0x57, 0x18, 0x01, 0x3A, 0xD6, 0x4F, 0x39,
    0x7E, 0xF2, 0x82, 0x57, 0x13, 0x92, 0x39, 0x5E
};

static const uint8_t rsa_pkcs1v15wrap_ct_3072[] =
{
    0x19, 0x9E, 0x40, 0xFE, 0x64, 0x9F, 0xD1, 0x9B, 0xEE, 0x58, 0xB4, 0x66, 0x41, 0x5A, 0x57, 0x24,
    0xA3, 0x48, 0x68, 0x92, 0x33, 0x8E, 0xF7, 0x55, 0x31, 0x6E, 0x7D, 0xE1, 0x34, 0x13, 0x64, 0x00,
    0xCE, 0x76, 0xD2, 0x85, 0x53, 0xBF, 0x5C, 0xE6, 0x21, 0xA3, 0xF6, 0xC1, 0xCF, 0xB7, 0xDC, 0xD2,
    0xD3, 0x1E, 0x8A, 0xD5, 0xD4, 0x01, 0x80, 0x2B, 0x31, 0xAB, 0x3C, 0x4F, 0xAF, 0xA9, 0x34, 0xE3,
    0x43, 0xF7, 0x6B, 0xEF, 0xDF, 0x6F, 0x65, 0x92, 0x78, 0xEF, 0xFC, 0x2C, 0x5A, 0xD8, 0x21, 0xFB,
    0x73, 0x8D, 0xDD, 0xED, 0x54, 0x0B, 0x27, 0x1D, 0xD5, 0x5E, 0x60, 0xEB, 0xBE, 0x1F, 0x4E, 0xE7,
    0x93, 0xDB, 0xDC, 0xA1, 0x02, 0x37, 0x6C, 0xB8, 0x11, 0x82, 0x9E, 0x71, 0x77, 0x1E, 0xEF, 0x5D,
    0xD5, 0xB1, 0x53, 0x22, 0xE3, 0x39, 0x12, 0x0E, 0xF6, 0x57, 0xDA, 0x0F, 0x16, 0xBF, 0xDF, 0x8F,
    0x92, 0xEA, 0x69, 0x42, 0x46, 0x28, 0x9A, 0x5F, 0x6F, 0xF4, 0xF8, 0xA7, 0xBE, 0xD0, 0x1D, 0xB2,
    0xD7, 0xD7, 0xE8, 0xE1, 0x67, 0x0D, 0xF6, 0x6E, 0x47, 0xB6, 0x3D, 0x4D, 0x19, 0x26, 0x35, 0xBC,
    0x99, 0x3A, 0x7C, 0xF2, 0xA9, 0x85, 0xCB, 0x2F, 0x3A, 0xD1, 0x76, 0xBB, 0x21, 0xF3, 0x7D, 0x47,
    0x99, 0xF7, 0xD8, 0xD9, 0x07, 0x52, 0x34, 0xAC, 0x01, 0x71, 0xEC, 0x82, 0x6A, 0x56, 0x87, 0x0A,
    0x6F, 0xD1, 0xFA, 0x69, 0xB2, 0xE2, 0x33, 0x87, 0x42, 0xFD, 0x1D, 0x35, 0x11, 0x6A, 0x05, 0x93,
    0x2F, 0x96, 0x05, 0x3D, 0x84, 0x12, 0x64, 0x30, 0x74, 0xF5, 0x6A, 0x2D, 0x30, 0x0C, 0x04, 0x6B,
    0xC5, 0x71, 0x0D, 0xF8, 0x8F, 0xE0, 0xDA, 0x62, 0xEF, 0xAC, 0x6D, 0xF6, 0x36, 0xCF, 0xF6, 0x5C,
    0x02, 0x1E, 0xA8, 0x9F, 0xBD, 0x4E, 0xC4, 0xD1, 0x5F, 0x39, 0x42, 0xEF, 0x17, 0x82, 0x4C, 0x54,
    0x1A, 0x4D, 0xEB, 0x4B, 0xB0, 0x96, 0x79, 0x42, 0xC6, 0x6D, 0x1C, 0xEC, 0x18, 0xBF, 0x6A, 0x40,
    0x3B, 0x70, 0xF0, 0xD7, 0xE4, 0xFD, 0xEE, 0x53, 0x65, 0x1E, 0x64, 0x39, 0xC7, 0x1D, 0x9E, 0x97,
    0xEE, 0x59, 0x6A, 0xEB, 0x43, 0x0F, 0x85, 0x24, 0xEF, 0x8D, 0xBB, 0x12, 0xEB, 0x35, 0xA0, 0xED,
    0xB1, 0xD7, 0xF6, 0xAA, 0x1B, 0xF0, 0x4B, 0x7F, 0x94, 0xAC, 0xD3, 0xBC, 0xFD, 0x9C, 0x0C, 0x6E,
    0x2F, 0x1D, 0xB7, 0xB0, 0x17, 0x8F, 0xA7, 0x79, 0xA0, 0x0B, 0x5F, 0x98, 0xA1, 0xFD, 0x55, 0x4C,
    0x57, 0x97, 0x8F, 0xDE, 0xD2, 0x2B, 0xB8, 0xDD, 0xF7, 0x2E, 0x0B, 0x74, 0xD7, 0x09, 0xFE, 0x01,
    0x1C, 0x18, 0x39, 0xFD, 0xF6, 0x9E, 0x9D, 0x3A, 0xD5, 0x61, 0x07, 0xA6, 0x46, 0x35, 0x68, 0xE8,
    0x14, 0xC1, 0x0E, 0xD2, 0x73, 0xEB, 0x95, 0xAD, 0xB3, 0xCB, 0x79, 0x8A, 0x09, 0xF1, 0x4E, 0x0E
};

static const TestVector_RSA_PKCS1V15WRAP_Rec_t test_vectors_rsa_pkcs1v15wrap[] =
{
    {
        "rsa-pkcs1v15wrap-1024", 1024, 256,
        {
            rsa_pkcs1v15wrap_key_1024_n, sizeof(rsa_pkcs1v15wrap_key_1024_n),
            rsa_pkcs1v15wrap_key_1024_e, sizeof(rsa_pkcs1v15wrap_key_1024_e),
            rsa_pkcs1v15wrap_key_1024_d, sizeof(rsa_pkcs1v15wrap_key_1024_d)
        },
        rsa_pkcs1v15wrap_pt_1024, sizeof(rsa_pkcs1v15wrap_pt_1024),
        rsa_pkcs1v15wrap_ct_1024, sizeof(rsa_pkcs1v15wrap_ct_1024)
    },
    {
        "rsa-pkcs1v15wrap-2048", 2048, 256,
        {
            rsa_pkcs1v15wrap_key_2048_n, sizeof(rsa_pkcs1v15wrap_key_2048_n),
            rsa_pkcs1v15wrap_key_2048_e, sizeof(rsa_pkcs1v15wrap_key_2048_e),
            rsa_pkcs1v15wrap_key_2048_d, sizeof(rsa_pkcs1v15wrap_key_2048_d)
        },
        rsa_pkcs1v15wrap_pt_2048, sizeof(rsa_pkcs1v15wrap_pt_2048),
        rsa_pkcs1v15wrap_ct_2048, sizeof(rsa_pkcs1v15wrap_ct_2048)
    },
    {
        "rsa-pkcs1v15wrap-3072", 3072, 256,
        {
            rsa_pkcs1v15wrap_key_3072_n, sizeof(rsa_pkcs1v15wrap_key_3072_n),
            rsa_pkcs1v15wrap_key_3072_e, sizeof(rsa_pkcs1v15wrap_key_3072_e),
            rsa_pkcs1v15wrap_key_3072_d, sizeof(rsa_pkcs1v15wrap_key_3072_d)
        },
        rsa_pkcs1v15wrap_pt_3072, sizeof(rsa_pkcs1v15wrap_pt_3072),
        rsa_pkcs1v15wrap_ct_3072, sizeof(rsa_pkcs1v15wrap_ct_3072)
    },
};


/* end of file testvectors_rsa_data.h */
