/* testvectors_poly1305_data.h
 *
 * Description: Poly1305 test vector data take from
 *              RFC7539    - "ChaCha20 and Poly1305 for IETF protocols"
 *                           Y. Nir, A. Langley, Google Inc.,
 *                           May, 2015
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

#ifndef INCLUDE_GUARD_TESTVECTORS_POLY1305_DATA_H
#define INCLUDE_GUARD_TESTVECTORS_POLY1305_DATA_H

#include <third_party/hsmddk/include/Kit/DriverFramework/Basic_Defs_API/incl/basic_defs.h>

/* KAT1 */
static const uint8_t Poly1305_KAT1_Key[] = {
    0x85, 0xD6, 0xBE, 0x78, 0x57, 0x55, 0x6D, 0x33, 0x7F, 0x44, 0x52, 0xFE, 0x42, 0xD5, 0x06, 0xA8,
    0x01, 0x03, 0x80, 0x8A, 0xFB, 0x0D, 0xB2, 0xFD, 0x4A, 0xBF, 0xF6, 0xAF, 0x41, 0x49, 0xF5, 0x1B
};
static const uint8_t Poly1305_KAT1_Message[] = {
    0x43, 0x72, 0x79, 0x70, 0x74, 0x6F, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x20, 0x46, 0x6F,
    0x72, 0x75, 0x6D, 0x20, 0x52, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x20, 0x47, 0x72, 0x6F,
    0x75, 0x70
};
static const uint8_t Poly1305_KAT1_Tag[] = {
    0xA8, 0x06, 0x1D, 0xC1, 0x30, 0x51, 0x36, 0xC6, 0xC2, 0x2B, 0x8B, 0xAF, 0x0C, 0x01, 0x27, 0xA9
};

/* KAT2 */
static const uint8_t Poly1305_KAT2_Key[] = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F
};
static const uint8_t Poly1305_KAT2_Message[] = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
};
static const uint8_t Poly1305_KAT2_Tag[] = {
    0x92, 0x19, 0x0A, 0x26, 0x2D, 0xDF, 0xFB, 0x42, 0x74, 0x4F, 0x94, 0x02, 0x5A, 0x5A, 0xC3, 0x54
};

/* KAT3 */
static const uint8_t Poly1305_KAT3_Key[] = {
    0xE8, 0xFB, 0xCF, 0xE6, 0x4F, 0xBA, 0xE6, 0xAF, 0x78, 0x19, 0x6F, 0x9C, 0xE9, 0xF7, 0x7A, 0xDD,
    0xD8, 0xC2, 0x6B, 0x42, 0x82, 0x67, 0xC8, 0x4D, 0x7A, 0x95, 0xE8, 0x81, 0x48, 0xC1, 0x9E, 0x40
};
static const uint8_t Poly1305_KAT3_Message[] = {
    0x3D, 0xF7, 0xCD, 0x72, 0x14, 0x51, 0x82, 0xEE, 0x1B, 0x8D, 0xB4, 0x8C, 0xD0, 0x8A, 0xF6, 0x9A,
    0x96, 0x71, 0x98, 0x62, 0x93, 0x4A, 0x30, 0x2F, 0x9C, 0xA8, 0x79, 0x16, 0xC1, 0xE0, 0xEC, 0xD7,
    0xE5, 0xEC, 0x8A, 0x64, 0xB4, 0x46, 0xCF, 0xD9, 0xE5, 0x96, 0xF3, 0x94, 0x73, 0xA9, 0xFF, 0xEA,
    0xCB, 0x15, 0x9C, 0x7C, 0xA1, 0xD8, 0x3E, 0xBB, 0x1D, 0x38, 0xCB, 0x55, 0xD0, 0x19, 0x25, 0xB2,
    0x0B, 0x92, 0xE8, 0x88, 0xAE, 0x06, 0xA2, 0x9B, 0x93, 0x64, 0x5E, 0xFB, 0x09, 0x05, 0xF6, 0x2F,
    0x1F, 0x35, 0xCC, 0xEF, 0x05, 0x6C, 0x19, 0x42, 0x38, 0xA5, 0x59, 0x2E, 0x80, 0x0A, 0x19, 0xFC,
    0x33, 0x5B, 0xBB, 0xD6
};
static const uint8_t Poly1305_KAT3_Tag[] = {
    0x1D, 0x89, 0xF9, 0x7E, 0x66, 0x6C, 0x58, 0x7F, 0x70, 0xC2, 0x26, 0xFE, 0x92, 0x8B, 0x52, 0x6D
};

/* KAT4 */
static const uint8_t Poly1305_KAT4_Key[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const uint8_t Poly1305_KAT4_Message[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static const uint8_t Poly1305_KAT4_Tag[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

/* KAT5 */
static const uint8_t Poly1305_KAT5_Key[] = {
    0x1C, 0x92, 0x40, 0xA5, 0xEB, 0x55, 0xD3, 0x8A, 0xF3, 0x33, 0x88, 0x86, 0x04, 0xF6, 0xB5, 0xF0,
    0x47, 0x39, 0x17, 0xC1, 0x40, 0x2B, 0x80, 0x09, 0x9D, 0xCA, 0x5C, 0xBC, 0x20, 0x70, 0x75, 0xC0
};
static const uint8_t Poly1305_KAT5_Message[] = {
    0x27, 0x54, 0x77, 0x61, 0x73, 0x20, 0x62, 0x72, 0x69, 0x6C, 0x6C, 0x69, 0x67, 0x2C, 0x20, 0x61,
    0x6E, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x6C, 0x69, 0x74, 0x68, 0x79, 0x20, 0x74, 0x6F,
    0x76, 0x65, 0x73, 0x0A, 0x44, 0x69, 0x64, 0x20, 0x67, 0x79, 0x72, 0x65, 0x20, 0x61, 0x6E, 0x64,
    0x20, 0x67, 0x69, 0x6D, 0x62, 0x6C, 0x65, 0x20, 0x69, 0x6E, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77,
    0x61, 0x62, 0x65, 0x3A, 0x0A, 0x41, 0x6C, 0x6C, 0x20, 0x6D, 0x69, 0x6D, 0x73, 0x79, 0x20, 0x77,
    0x65, 0x72, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x6F, 0x72, 0x6F, 0x67, 0x6F, 0x76, 0x65,
    0x73, 0x2C, 0x0A, 0x41, 0x6E, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6D, 0x6F, 0x6D, 0x65, 0x20,
    0x72, 0x61, 0x74, 0x68, 0x73, 0x20, 0x6F, 0x75, 0x74, 0x67, 0x72, 0x61, 0x62, 0x65, 0x2E
};
static const uint8_t Poly1305_KAT5_Tag[] = {
    0x45, 0x41, 0x66, 0x9A, 0x7E, 0xAA, 0xEE, 0x61, 0xE7, 0x08, 0xDC, 0x7C, 0xBC, 0xC5, 0xEB, 0x62
};


#endif /* INCLUDE_GUARD_TESTVECTORS_POLY1305_DATA_H */

/* end of file testvectors_poly1305_data.h */
