/* testvectors_des_data.h
 *
 * Description: DES test vector data, automatically generated from
 *              stdvect.des.des_ecb_nist.py and
 *              stdvect.des.des_fips81.py
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

#ifndef INCLUDE_GUARD_TESTVECTORS_DES_DATA_H
#define INCLUDE_GUARD_TESTVECTORS_DES_DATA_H

#include <third_party/hsmddk/include/Kit/DriverFramework/Basic_Defs_API/incl/basic_defs.h>

static const uint8_t
App_A_key [] = {
    0x10, 0x31, 0x6e, 0x02, 0x8c, 0x8f, 0x3b, 0x4a
};

static const uint8_t
App_A_ptx [] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t
App_A_ctx [] = {
    0x82, 0xdc, 0xba, 0xfb, 0xde, 0xab, 0x66, 0x02
};

static const uint8_t
IP_and_E_Test_key [] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
};

static const uint8_t
IP_and_E_Test_ptx [] = {
    0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};

static const uint8_t
IP_and_E_Test_ctx [] = {
    0x95, 0xf8, 0xa5, 0xe5, 0xdd, 0x31, 0xd9, 0x00, 0xdd, 0x7f, 0x12, 0x1c,
    0xa5, 0x01, 0x56, 0x19, 0x2e, 0x86, 0x53, 0x10, 0x4f, 0x38, 0x34, 0xea,
    0x4b, 0xd3, 0x88, 0xff, 0x6c, 0xd8, 0x1d, 0x4f, 0x20, 0xb9, 0xe7, 0x67,
    0xb2, 0xfb, 0x14, 0x56, 0x55, 0x57, 0x93, 0x80, 0xd7, 0x71, 0x38, 0xef,
    0x6c, 0xc5, 0xde, 0xfa, 0xaf, 0x04, 0x51, 0x2f, 0x0d, 0x9f, 0x27, 0x9b,
    0xa5, 0xd8, 0x72, 0x60, 0xd9, 0x03, 0x1b, 0x02, 0x71, 0xbd, 0x5a, 0x0a,
    0x42, 0x42, 0x50, 0xb3, 0x7c, 0x3d, 0xd9, 0x51, 0xb8, 0x06, 0x1b, 0x7e,
    0xcd, 0x9a, 0x21, 0xe5, 0xf1, 0x5d, 0x0f, 0x28, 0x6b, 0x65, 0xbd, 0x28,
    0xad, 0xd0, 0xcc, 0x8d, 0x6e, 0x5d, 0xeb, 0xa1, 0xe6, 0xd5, 0xf8, 0x27,
    0x52, 0xad, 0x63, 0xd1, 0xec, 0xbf, 0xe3, 0xbd, 0x3f, 0x59, 0x1a, 0x5e,
    0xf3, 0x56, 0x83, 0x43, 0x79, 0xd1, 0x65, 0xcd, 0x2b, 0x9f, 0x98, 0x2f,
    0x20, 0x03, 0x7f, 0xa9, 0x88, 0x9d, 0xe0, 0x68, 0xa1, 0x6f, 0x0b, 0xe6,
    0xe1, 0x9e, 0x27, 0x5d, 0x84, 0x6a, 0x12, 0x98, 0x32, 0x9a, 0x8e, 0xd5,
    0x23, 0xd7, 0x1a, 0xec, 0xe7, 0xfc, 0xe2, 0x25, 0x57, 0xd2, 0x3c, 0x97,
    0x12, 0xa9, 0xf5, 0x81, 0x7f, 0xf2, 0xd6, 0x5d, 0xa4, 0x84, 0xc3, 0xad,
    0x38, 0xdc, 0x9c, 0x19, 0xfb, 0xe0, 0x0a, 0x8a, 0x1e, 0xf8, 0xad, 0x72,
    0x75, 0x0d, 0x07, 0x94, 0x07, 0x52, 0x13, 0x63, 0x64, 0xfe, 0xed, 0x9c,
    0x72, 0x4c, 0x2f, 0xaf, 0xf0, 0x2b, 0x26, 0x3b, 0x32, 0x8e, 0x2b, 0x60,
    0x9d, 0x64, 0x55, 0x5a, 0x9a, 0x10, 0xb8, 0x52, 0xd1, 0x06, 0xff, 0x0b,
    0xed, 0x52, 0x55, 0xd7, 0xe1, 0x65, 0x2c, 0x6b, 0x13, 0x8c, 0x64, 0xa5,
    0xe4, 0x28, 0x58, 0x11, 0x86, 0xec, 0x8f, 0x46, 0xae, 0xb5, 0xf5, 0xed,
    0xe2, 0x2d, 0x1a, 0x36, 0xe9, 0x43, 0xd7, 0x56, 0x8a, 0xec, 0x0c, 0x5c,
    0xdf, 0x98, 0xc8, 0x27, 0x6f, 0x54, 0xb0, 0x4b, 0xb1, 0x60, 0xe4, 0x68,
    0x0f, 0x6c, 0x69, 0x6f, 0xfa, 0x07, 0x52, 0xb0, 0x7d, 0x9c, 0x4a, 0xb8,
    0xca, 0x3a, 0x2b, 0x03, 0x6d, 0xbc, 0x85, 0x02, 0x5e, 0x09, 0x05, 0x51,
    0x7b, 0xb5, 0x9b, 0xcf, 0x81, 0x4e, 0xeb, 0x3b, 0x91, 0xd9, 0x07, 0x26,
    0x4d, 0x49, 0xdb, 0x15, 0x32, 0x91, 0x9c, 0x9f, 0x25, 0xeb, 0x5f, 0xc3,
    0xf8, 0xcf, 0x06, 0x21, 0xab, 0x6a, 0x20, 0xc0, 0x62, 0x0d, 0x1c, 0x6f,
    0x79, 0xe9, 0x0d, 0xbc, 0x98, 0xf9, 0x2c, 0xca, 0x86, 0x6e, 0xce, 0xdd,
    0x80, 0x72, 0xbb, 0x0e, 0x8b, 0x54, 0x53, 0x6f, 0x2f, 0x3e, 0x64, 0xa8,
    0xea, 0x51, 0xd3, 0x97, 0x55, 0x95, 0xb8, 0x6b, 0xca, 0xff, 0xc6, 0xac,
    0x45, 0x42, 0xde, 0x31, 0x8d, 0xd4, 0x5a, 0x2d, 0xdf, 0x90, 0x79, 0x6c,
    0x10, 0x29, 0xd5, 0x5e, 0x88, 0x0e, 0xc2, 0xd0, 0x5d, 0x86, 0xcb, 0x23,
    0x63, 0x9d, 0xbe, 0xa9, 0x1d, 0x1c, 0xa8, 0x53, 0xae, 0x7c, 0x0c, 0x5f,
    0xce, 0x33, 0x23, 0x29, 0x24, 0x8f, 0x32, 0x28, 0x84, 0x05, 0xd1, 0xab,
    0xe2, 0x4f, 0xb9, 0x42, 0xe6, 0x43, 0xd7, 0x80, 0x90, 0xca, 0x42, 0x07,
    0x48, 0x22, 0x1b, 0x99, 0x37, 0x74, 0x8a, 0x23, 0xdd, 0x7c, 0x0b, 0xbd,
    0x61, 0xfa, 0xfd, 0x54, 0x2f, 0xbc, 0x29, 0x1a, 0x57, 0x0d, 0xb5, 0xc4,
    0xe0, 0x7c, 0x30, 0xd7, 0xe4, 0xe2, 0x6e, 0x12, 0x09, 0x53, 0xe2, 0x25,
    0x8e, 0x8e, 0x90, 0xa1, 0x5b, 0x71, 0x1b, 0xc4, 0xce, 0xeb, 0xf2, 0xee,
    0xcc, 0x08, 0x3f, 0x1e, 0x6d, 0x9e, 0x85, 0xf6, 0xd2, 0xfd, 0x88, 0x67,
    0xd5, 0x0d, 0x2d, 0xfe, 0x06, 0xe7, 0xea, 0x22, 0xce, 0x92, 0x70, 0x8f,
    0x16, 0x6b, 0x40, 0xb4, 0x4a, 0xba, 0x4b, 0xd6
};

static const uint8_t
FIPS81_B1_key [] = {
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef
};

static const uint8_t
FIPS81_B1_ptx [] = {
    0x4e, 0x6f, 0x77, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74,
    0x69, 0x6d, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x61, 0x6c, 0x6c, 0x20
};

static const uint8_t
FIPS81_B1_ctx [] = {
    0x3f, 0xa4, 0x0e, 0x8a, 0x98, 0x4d, 0x48, 0x15, 0x6a, 0x27, 0x17, 0x87,
    0xab, 0x88, 0x83, 0xf9, 0x89, 0x3d, 0x51, 0xec, 0x4b, 0x56, 0x3b, 0x53
};

static const uint8_t
FIPS81_C1_key [] = {
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef
};

static const uint8_t
FIPS81_C1_ptx [] = {
    0x4e, 0x6f, 0x77, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74,
    0x69, 0x6d, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x61, 0x6c, 0x6c, 0x20
};

static const uint8_t
FIPS81_C1_ctx [] = {
    0xe5, 0xc7, 0xcd, 0xde, 0x87, 0x2b, 0xf2, 0x7c, 0x43, 0xe9, 0x34, 0x00,
    0x8c, 0x38, 0x9c, 0x0f, 0x68, 0x37, 0x88, 0x49, 0x9a, 0x7c, 0x05, 0xf6
};

static const uint8_t
FIPS81_C1_iv [] = {
    0x12, 0x34, 0x56, 0x78, 0x90, 0xab, 0xcd, 0xef
};

static const uint8_t
B_1_3DES_ECB_key [] = {
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x23, 0x45, 0x67, 0x89,
    0xab, 0xcd, 0xef, 0x01, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23
};

static const uint8_t
B_1_3DES_ECB_ptx [] = {
    0x54, 0x68, 0x65, 0x20, 0x71, 0x75, 0x66, 0x63, 0x6b, 0x20, 0x62, 0x72,
    0x6f, 0x77, 0x6e, 0x20, 0x66, 0x6f, 0x78, 0x20, 0x6a, 0x75, 0x6d, 0x70
};

static const uint8_t
B_1_3DES_ECB_ctx [] = {
    0xa8, 0x26, 0xfd, 0x8c, 0xe5, 0x3b, 0x85, 0x5f, 0xcc, 0xe2, 0x1c, 0x81,
    0x12, 0x25, 0x6f, 0xe6, 0x68, 0xd5, 0xc0, 0x5d, 0xd9, 0xb6, 0xb9, 0x00
};

static const uint8_t
TDES_ECB_Ex1_key [] = {
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x23, 0x45, 0x67, 0x89,
    0xab, 0xcd, 0xef, 0x01, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23
};

static const uint8_t
TDES_ECB_Ex1_ptx [] = {
    0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96, 0xe9, 0x3d, 0x7e, 0x11,
    0x73, 0x93, 0x17, 0x2a, 0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
    0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51
};

static const uint8_t
TDES_ECB_Ex1_ctx [] = {
    0x71, 0x47, 0x72, 0xf3, 0x39, 0x84, 0x1d, 0x34, 0x26, 0x7f, 0xcc, 0x4b,
    0xd2, 0x94, 0x9c, 0xc3, 0xee, 0x11, 0xc2, 0x2a, 0x57, 0x6a, 0x30, 0x38,
    0x76, 0x18, 0x3f, 0x99, 0xc0, 0xb6, 0xde, 0x87
};

static const uint8_t
TDES_ECB_Ex2_key [] = {
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x23, 0x45, 0x67, 0x89,
    0xab, 0xcd, 0xef, 0x01, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef
};

static const uint8_t
TDES_ECB_Ex2_ptx [] = {
    0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96, 0xe9, 0x3d, 0x7e, 0x11,
    0x73, 0x93, 0x17, 0x2a, 0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
    0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51
};

static const uint8_t
TDES_ECB_Ex2_ctx [] = {
    0x06, 0xed, 0xe3, 0xd8, 0x28, 0x84, 0x09, 0x0a, 0xff, 0x32, 0x2c, 0x19,
    0xf0, 0x51, 0x84, 0x86, 0x73, 0x05, 0x76, 0x97, 0x2a, 0x66, 0x6e, 0x58,
    0xb6, 0xc8, 0x8c, 0xf1, 0x07, 0x34, 0x0d, 0x3d
};

static const uint8_t
TDES_CBC_Ex1_key [] = {
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x23, 0x45, 0x67, 0x89,
    0xab, 0xcd, 0xef, 0x01, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x01, 0x23
};

static const uint8_t
TDES_CBC_Ex1_ptx [] = {
    0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96, 0xe9, 0x3d, 0x7e, 0x11,
    0x73, 0x93, 0x17, 0x2a, 0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
    0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51
};

static const uint8_t
TDES_CBC_Ex1_ctx [] = {
    0x20, 0x79, 0xc3, 0xd5, 0x3a, 0xa7, 0x63, 0xe1, 0x93, 0xb7, 0x9e, 0x25,
    0x69, 0xab, 0x52, 0x62, 0x51, 0x65, 0x70, 0x48, 0x1f, 0x25, 0xb5, 0x0f,
    0x73, 0xc0, 0xbd, 0xa8, 0x5c, 0x8e, 0x0d, 0xa7
};

static const uint8_t
TDES_CBC_Ex1_iv [] = {
    0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17
};

static const uint8_t
TDES_CBC_Ex2_key [] = {
    0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 0x23, 0x45, 0x67, 0x89,
    0xab, 0xcd, 0xef, 0x01, 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef
};

static const uint8_t
TDES_CBC_Ex2_ptx [] = {
    0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96, 0xe9, 0x3d, 0x7e, 0x11,
    0x73, 0x93, 0x17, 0x2a, 0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
    0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51
};

static const uint8_t
TDES_CBC_Ex2_ctx [] = {
    0x74, 0x01, 0xce, 0x1e, 0xab, 0x6d, 0x00, 0x3c, 0xaf, 0xf8, 0x4b, 0xf4,
    0x7b, 0x36, 0xcc, 0x21, 0x54, 0xf0, 0x23, 0x8f, 0x9f, 0xfe, 0xcd, 0x8f,
    0x6a, 0xcf, 0x11, 0x83, 0x92, 0xb4, 0x55, 0x81
};

static const uint8_t
TDES_CBC_Ex2_iv [] = {
    0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17
};


#endif /* INCLUDE_GUARD_TESTVECTORS_DES_DATA_H */

/* end of file testvectors_des_data.h */
