## Introduction

The Radio Control Layer (RCL) component for the LPF3 SDK consists of:

- High-level Radio Control Layer driver providing scheduling and power management
- Low-level RF protocol implementation
- Radio core firmware images
- RF configuration arrays and settings
- API documentation

## Disclaimer

See [Upgrade and Compatibility Information](#upgrade-and-compatibility-information)
for details.

## Documentation

The following documentation is included in RCL.

- [API documentation](./html/index.html)
- [Release Notes](rcl_release_notes.html) (this document)

## Build Size

The following is the output of the TI ARM Clang size tool:

Component | Flash Size (Bytes)  | RAM Size (Bytes)
--------- |---------------------|------------------
$SIZE_LIST

Note this is the total size of the archive, not necessarily the size of the
final linked program.

## Dependencies

- coresdk_lpf3: $CORESDK_VER
- TI ARM LLVM: $TIARMLLVM_VER
- GCC: $GCC_VER
- IAR: $IAR_VER
- Radioconfig: $RADIOCONFIG_VER

## Hardware Setup

This release is tested with the following hardware:

* LP_EM_CC2340R5
* LP_EM_CC2745R10_Q1

No hardware modifications are required.

## What's New

This list contains all new features in: v$VERSION_STREAM

$${JQL:project in (RCL) AND issuetype = Story AND resolution != unresolved AND fixVersion ~ "LOKI_RCL_$JIRA_VERSION_STREAM*" AND labels in (ReleaseNote) ORDER BY project desc, priority}

## Fixed Issues

This list contains all bugfixes in: v$VERSION_STREAM

$${JQL:project in (RCL) AND issuetype in (Bug, Task) AND resolution != unresolved AND fixVersion ~ "LOKI_RCL_$JIRA_VERSION_STREAM*" AND labels in (ReleaseNote) ORDER BY project desc, priority}

## Known Issues

$${JQL:project in (RCL) AND issueType in (Bug) AND resolution = unresolved AND (affectedVersion ~ "LOKI_RCL_$JIRA_VERSION_STREAM*" OR affectedVersion < "LOKI_RCL_$JIRA_VERSION_BASE") AND labels in (ReleaseNote) ORDER BY project desc, priority}

## Upgrade and Compatibility Information

**IEEE 802.15.4 API**

The function `RCL_IEEE_getPartialFrame` has been deprecated. Use `RCL_IEEE_readPartialFrame` instead.

## Known Limitations

The following scenarios have limited test coverage in the RCL module tests:

- Stress testing or throughput testing of connection
- Testing of adding buffers to the radio while it is running
- The testing of fields in the `stats` structures

## Versioning

This product's version follows a version format, **M.mm.pp.bb**, where **M** is a single digit Major number, **mm** is 2 digit minor number, **pp** is a 2 digit patch number, and **b** is an unrestricted set of digits used as an incrementing build counter.
