\page periodic_advertiser_handler Periodic Advertiser Command Handler


# Introduction

In [Bluetooth&reg; Low Energy (BLE)](https://www.bluetooth.com/learn-about-bluetooth/tech-overview/), periodic advertising (without responses) refers to a feature in which an advertiser can broadcast data at regular intervals without expecting or allowing a response from receiving devices. This advertising method relies on the use of [extended advertising](rcl_glossary.html##extended-advertising) PDUs, and is particularly useful for applications requiring consistent data transmission over time, such as broadcasting sensor data, location beacons, or public information in a power-efficient manner. By not waiting for acknowledgments or replies, periodic advertising minimizes power consumption and reduces the complexity of maintaining a connection.

Please note that periodic advertising with responses was introduced with version v5.4 of the Bluetooth Core Specification, but it is not currently supported by the periodic advertising command handler.

| PDU Type |        PDU Name       | Physical Channel       | LE 1M | LE 2M | LE Coded | Currently Supported |
|:--------:|:---------------------:|------------------------|:-----:|:-----:|:--------:|:-------------------:|
|  0b0111  |      ADV_EXT_IND      | Primary                |   *   |       |     *    |          *          |
|  0b0111  |      AUX_ADV_IND      | Secondary              |   *   |   *   |     *    |          *          |
|  0b0111  |      AUX_SYNC_IND     | Periodic               |   *   |   *   |     *    |          *          |
|  0b0111  |     AUX_CHAIN_IND     | Secondary and Periodic |   *   |   *   |     *    |          *          |
|  0b0111  | AUX_SYNC_SUBEVENT_IND | Periodic               |   *   |   *   |     *    |                     |
|  0b0111  | AUX_SYNC_SUBEVENT_RSP | Periodic               |   *   |   *   |     *    |                     |

# Usage

The periodic advertising command handler can be considered a simplified version of the advertiser command handler, which only sends AUX_SYNC_IND and AUX_CHAIN_IND PDUs. To inform potential scanners about the periodic advertising, a procedure known as periodic advertising establishment is required.

This procedure involves sending an ADV_EXT_IND PDU pointing to an AUX_ADV_IND that contains the [SyncInfo](rcl_glossary.html##sync-info) needed by scanners to synchronize to the periodic advertising event.

Once periodic advertising has been established, the user must decide whether to inform other devices about the ongoing periodic advertising by invoking the periodic advertising establishment procedure as needed.

![Example of periodic advertising events from the same advertising set](docs/rcl/source/images/periodic_advertising_example.png)

The following basic steps need to be executed to perform periodic advertising, including periodic advertising establishment.

1. Initialize the RCL (See ::RCL_init) and provide a handle (See ::RCL_open).
2. Initialize and configure a ::RCL_CMD_BLE5_ADV_t command for periodic advertising establishment.
3. Provide the necessary Tx buffer(s) such that they have been initialized and configured to contain the necessary syncInfo needed for the periodic advertising.
4. Submit the command with ::RCL_Command_submit, and either use ::RCL_Command_pend or a callback to wait for the command's conclusion and proceed with any additional tasks such as post-processing or the submitting of new commands.

If the execution of the command is successful, it can be assumed that the periodic advertisement establishment is done, and the user can proceed with the periodic advertising.

5. Initialize and configure a ::RCL_CMD_BLE5_PER_ADV_t command.
6. Use the start time of the ::RCL_CMD_BLE5_ADV_t command,  ::RCL_BLE5_getAuxAdvStartTimeDelta, and the [SyncInfo](rcl_glossary.html##sync-info) needed to set up the start time of the ::RCL_CMD_BLE5_PER_ADV_t command.
7. Provide the necessary Tx buffer(s) such that they have been initialized and configured to contain the desired advertising data.
8. Submit the command ::RCL_Command_submit, and either use ::RCL_Command_pend or a callback to wait for the command's conclusion and proceed with any additional tasks such as post-processing or the submitting of new commands.
9. Rely on the start time of the previous ::RCL_CMD_BLE5_PER_ADV_t command to schedule new periodic advertising commands.

The following code snippet shows how to establish a periodic advertising as an advertiser:

\snippet source/snippets/ble_example/ble_example.c periodicAdv_code_snippet

As mentioned before, periodic advertising establishment requires that an AUX_ADV_IND PDU be sent with the necessary [SyncInfo](rcl_glossary.html##sync-info). This information is used by potential scanners to properly follow the periodic advertising events. In the previous code snippet, the Tx buffer corresponding to the AUX_ADV_IND is built with a helper function that populates the Tx buffer with appropriate values for each field in the [Common Extended Advertising Payload Format](rcl_glossary.html##common-extended-advertising-payload-format).

\snippet source/snippets/ble_example/ble_example.c syncInfo_code_snippet

\snippet source/snippets/ble_example/ble_example.c setAuxAdvSyncBuffer_code_snippet

Notice how the previously defined [SyncInfo](rcl_glossary.html##sync-info) is used to populate the Tx buffer with the help of a C struct.

Using the periodic advertising command handler requires at least one Tx buffer in the buffer list corresponding to the AUX_SYNC_IND PDU. If needed, the user can rely on the callback to the command to provide additional Tx buffers corresponding to AUX_CHAIN_IND PDUs.

Considering that the [syncPacketWindowOffset](rcl_glossary.html##sync-packet-window-offset) indicates the transmission time of an AUX_SYNC_IND, and that the reference point is the start time of the AUX_ADV_IND, the RCL provides the ::RCL_BLE5_getAuxAdvStartTimeDelta API to ease the calculation of the start time of the periodic advertising command.

This API can also be used once periodic advertising is ongoing, but the advertiser needs to inform new scanner devices about the ongoing periodic advertising.

# Architecture

The life cycle of the periodic advertiser command handler depends on the number of packets that are part of the periodic advertising event.

The command handler requires at least one Tx buffer in the buffer list at command start. This buffer will be inspected to determine if an AuxPtr has been provided, and based on this, the operation will either conclude after transmitting the packet or schedule a new operation corresponding to the auxiliary packet.

It's worth mentioning that only non-connectable/non-scannable PDUs can be sent with the periodic advertising command, and other PDUs will be rejected and the command will end indicating a Tx buffer corruption.

@startuml
skinparam defaultTextAlignment center
:Start;
:===Configure Radio Operation\n\n(FIFO config, set AA, set CRC Init);
:===Prepare LRF\n\n(set start time, configure PBE regs,\nenable interrupts, etc.);
repeat :===Enter payload\n\n(check PDU type,extract AuxPtr info,\nput packet in PBE FIFO, etc.);
:Start Tx Operation;
:Wait for LRF events;
switch (LRF event?)
    case ( opError )
        :===Process error\n\n(find //endCause//, set //cmdStatus//,\nraise //lastCmdDone// event);
    case ( opDone )
        if (//endCause// is ENDOK?) then (no)
           :Set //cmdStatus// to\n//endCause//, raise\n//lastCmdDone// event;
           :Set //runAuxAdv//\nto **FALSE**;
       else
           if ( AuxPtr is present? ) then (no)
               :Set //runAuxAdv//\nto **FALSE**;
               :Set //cmdStatus//, raise\n//lastCmdDone// event;
           else
               :Set //runAuxAdv//\nto **TRUE**;
               :Reset TX PBE FIFO;
           endif
       endif
endswitch
backward:===Process AuxPtr\n\n(update channel, set new start\ntime, prepare LRF, etc.);
repeat while (//runAuxAdv//?) is (Yes) not (No)
: Update stats;
: Done;
stop
@enduml


| RCL Event (In)              | Description                     |
|-----------------------------|---------------------------------|
| ::RCL_EventSetup            | Setup has been performed        |
| ::RCL_EventTimerStart       | Timer-based start signalled     |
| ::RCL_EventGracefulStop     | Graceful stop has been observed |
| ::RCL_EventHardStop         | Hard stop has been observed     |

| RCL Event (Out)             | Description                                                   |
|-----------------------------|---------------------------------------------------------------|
| ::RCL_EventLastCmdDone      | The RCL is finished with the command                          |
| ::RCL_EventCmdStarted       | Command handler has accepted and started executing            |
| ::RCL_EventTxBufferFinished | An TX buffer is finished                                      |

| LRF Event            | Description                                                       |
|----------------------|-------------------------------------------------------------------|
| ::LRF_EventOpDone    | The PBE operation has finished                                    |
| ::LRF_EventOpError   | Something went wrong. Cause located in the PBE ENDCAUSE register  |
