\page ble5_channel_assessment_handler BLE5 Channel Assessment Command Handler

# Introduction
The purpose of the Channel Assessment command handler is to assess the noise level of a BLE channel. The return status status will indicate if the BLE channel is busy or idle, with reference to a specified threshold.

# Usage

1. RCL has been initialized (See ::RCL_init) and a handle must exist (See ::RCL_open).
2. The ::RCL_CMD_BLE5_CH_ASSESSMENT_t command has been initialized and configured.

Once these steps have been completed, ::RCL_Command_submit is called to start the command. Once submitted, the caller can either use ::RCL_Command_pend or a callback to wait for the command's conclusion and proceed with any additional tasks such as post-processing or the submitting of new commands.

The stop time needs to be longer than the *assessmentDuration* parameter. Otherwise, the command will be stopped before measurement has been completed. Also the *assessmentDuration* should not be lower than 8 (2us). This will result in  ::RCL_CommandStatus_Error_Param.

Since this command is very simple, it doesn't use a context struct or a stats struct like
other BLE commands. The following code snippet shows a normal use-case for the command.

\snippet source/snippets/ble_example/ble_example.c channelAssessment_code_snippet

# Architecture

This command handler is based on the BLE5 Generic Rx Command Handler. However, it is simpler in design and will only open an Rx window for RSSI measurements the possibility of receiving any packets. The Rx window is open during the time specified by the *assessmentDuration* parameter. During this time, a sample is collected every 5us. The averaged result of all samples within the Rx window is then compared to the *assessmentThreshold* parameter. The comparison will yield either ::RCL_CommandStatus_ChannelBusy or ::RCL_CommandStatus_ChannelIdle as the commend status, when the averaged result is respectively above or below the configured *assessmentThreshold* parameter. If 0 samples have been collected at this point, ::RCL_CommandStatus_Error_Param will be given instead. The Rx window is then closed.

The following activity diagram illustrates the behavior of the channel assessment command handler.

@startuml "BLE Channel Assessment handler state machine"
skinparam defaultTextAlignment center
:Start;
:===Configure Radio \n\n(Enable Synth, Disable sync, set start time, etc);
:===Start RX Operation \n\n(Open RX window for given measurement duration);
if (Wait for LRF event) then (rfesoft0 )
    :==RSSI measurement \n\n(Sample every 5us, average all samples);
    switch (Compare averaged result with threshold)
        case ( Above threshold )
            :Save RCL_CommandStatus_ChannelBusy;
        case ( Below threshold )
            :Save RCL_CommandStatus_ChannelIdle;
        case (0 samples)
            :Save RCL_CommandStatus_Error_Param \n\n(Duration parameter is too low most likely);
    endswitch
    :==Close RX window;
    :Wait for LRF event;
endif
switch (LRF event?)
    case ( opError )
        :===Process error\n\n(find //endCause//, set //cmdStatus//,\nraise //lastCmdDone// event);
    case ( opDone )
        if (//endCause// is ENDOK?) then (no)
           :Set //cmdStatus// to\n//endCause//, raise\n//lastCmdDone// event;
       else
            :Set //cmdStatus//, raise\n//lastCmdDone// event;
       endif
endswitch
: Done;
stop
@enduml

## Events

The following tables list the events handled.

| RCL Event (In)              | Description                                     |
|-----------------------------|-------------------------------------------------|
| ::RCL_EventSetup            | Setup has been performed                        |
| ::RCL_EventTimerStart       | Timer-based start signalled                     |

| RCL Event (Out)             | Description                                        |
|-----------------------------|----------------------------------------------------|
| ::RCL_EventCmdStarted       | Command handler has accepted and started executing |
| ::RCL_EventLastCmdDone      | The RCL is finished with the command               |

| LRF Event                   | Description                                               |
|-----------------------------|-----------------------------------------------------------|
| ::LRF_EventOpDone           | The PBE operation has finished                            |
| ::LRF_EventOpError          | The PBE operation has finished with error or hard stop    |
| ::LRF_EventRfesoft0         | The RFE confirms the first RSSI measurement can be read   |