\page rcl_coex Wired RF Coexistence

The RCL component supports 3-wire coexistence with other RF devices (typically a WiFi device). The interface can also be 1-wire or 2-wire by using only a subset of the signals. The RCL supports a client role for the coexistence interface and assumes connection with a device implementing the host role.

# Definition
The three signals used are:
* REQUEST: This is an output signal indicating when the device performs an RF operation and requests the other device to be quiet.
* PRIORITY: This is a multi-purpose output signal indicating the priority of the request and whether the device is doing Rx or Tx.
* GRANT: This is an input signal indicating if the device is allowed to send

An example diagram with some timing definitions is shown below:

![Coexistence signals](docs/rcl/source/images/coex.png)

The timing requirements for the module are listed in the table below. T1 and T2 are configurable, while the remaining timing will be within the limits, or requires that external signaling is within the limits.

| Parameter  | Minimal (µs)   | Maximal (µs)                 | Default (µs)     |
|------------|----------------|------------------------------|------------------|
| T1         | 90             | 150                          | 120              |
| T2         | 0<sup>1</sup>  | 30                           | 20               |
| T3         | 50<sup>2</sup> | T1 &minus; T2                | -                |
| T4         | 0              | T<sub>idle</sub><sup>3</sup> | -                |
| T5         | 0              | 25                           | -                |

<sup>1</sup> A non-zero time needs to be at least 3 µs<br>
<sup>2</sup> In practice, much lower values will work, down to around 1 µs<br>
<sup>3</sup> Note that if the LNA enable signal is used to see Rx activity, it is deasserted some microseconds after the end of Rx

# Configuration
The Coexistence feature can be enabled using SysConfig. When the RCL module is added, the checkbox _Enable RF Coexistence_ can be checked to enable coexistence.

## Signal setup
The signals used is selected using the _Coex Mode_ dropdown. This will decide which of the signals are used. The signals can be mapped to IO pins using the _PinMux_ box.

## Specifying parameters
The _RF Coexistence Configuration_ box holds parameters to be set. The signal levels can be selected for each signal; by default, REQUEST and PRIORITY are active high, and GRANT is active low (low means grant given). This is as shown in the figure.

The T1 and T2 values can be specified using the _Coex RF Activity Latency Time_ and _Priority Indication Time_ settings, respectively. The default values are given in the table. A value of 0 for T2 is achieved by deselecting _Enable Priority Indication_.

If _Coex Configuration Changeable_ is checked, the parameters may be changed at runtime, using code as shown below. If unchecked the parameters are constants. This may give code size savings.

```C
#include <ti/drivers/rcl/RCL.h>
#include "ti_drivers_config.h"

    /* In code, parameters can be set as follows */
    lrfCoexConfiguration.T1 = RCL_SCHEDULER_SYSTIM_US(90); /* Example: Set T1 to 90 us */
    lrfCoexConfiguration.T2 = RCL_SCHEDULER_SYSTIM_US(10); /* Example: Set T2 to 10 us */
```
The parameters should only be modified when no RCL command is running.

## Usage in commands
RCL commands that support coexistence will have have a `coexControl` field of the type ::RCL_Command_CoexControl. This field enables and controls the coexistence feature for each command.
* If `grantEnable` is 1, the GRANT pin is used, provided it was configured. Otherwise, the GRANT signal is ignored
* If `requestPriorityEnable` is 1, the REQUEST and PRIORITY pins are used if configured. To use only one of these pins (normally REQUEST), the other should not be configured. Otherwise, these pins will stay at zero level. If the pins are not configured, the field is ignored.
* The `priority` field tells the priority signaled on the PRIORITY line for T2 µs after rising edge on REQUEST.
* The `rxMode` field tells how the REQUEST signal is treated during Rx. Details of this operation depends on the command.

# Operation of the Coexistence Features
## REQUEST and PRIORITY signals
If enabled, the REQUEST signal will be asserted by the radio when needed. In all cases, it will be asserted during Tx. In some cases, it will also be asserted under Rx. This is the case if `coexControl.rxMode` is ::RCL_CoexRxMode_AlwaysRequest, and under some circumstances also when it is ::RCL_CoexRxMode_RequestOnPacket.

At a positive edge of REQUEST, the PRIORITY signal will tell the priority of the request for the time T2 (if T2 is 0, this is not done). The priority is interpreted by the coexistence host. High priority is signaled with a high output level. After this, the PRIORITY signal changes its role and signals whether the radio is doing Tx or Rx; a high signal means Tx. When REQUEST is low, PRIORITY is also always low.

## GRANT signal
The GRANT input signal should be sent by the coexistence host to indicate if the client is allowed to do RF operations. The RCL implementation only checks the GRANT signal when doing Tx. It will check that the signal is low (meaning grant given) before starting to output any Tx power and constantly during transmission. If the signal changes to high (grant not given), transmission will stop as soon as possible. This situation is signaled to the user in one of two ways:

1. The command or action will end with ::RCL_CommandStatus_CoexNoGrant as the status
2. The event ::RCL_EventCoexNoTx is asserted, but the command continues. A callback may be set up for this event

The way of signaling in use depends on the situation and is described for each command.

# Command Specific Coexistence Operation
NOTE: Currently, the only command that supports coexistence is [RCL_CMD_IEEE_RX_TX](ieee_rxtx_handler.html).

## IEEE 802.15.4 support
Coexistence is supported with [RCL_CMD_IEEE_RX_TX](ieee_rxtx_handler.html).

If REQUEST is configured, it will be asserted in the following situations:

* If `coexControl.rxMode` is ::RCL_CoexRxMode_AlwaysRequest, it is asserted for the entire duration of the command.
* If `coexControl.rxMode` is ::RCL_CoexRxMode_RequestOnPacket, it is asserted in the following cases:
    1. If a preamble is found, indicating a frame may be received. If no sync is found, REQUEST will be deasserted again, otherwise, it stays asserted until the end of the frame
    2. During transmission of an ACK; in this case, REQUEST stays high from the reception of the frame until the end of the transmitted ACK
    3. When transmitting a frame using a Tx action
    4. When trying to receive an ACK after frame transmission; in this case, REQUEST stays high from the transmission of the frame until ACK is received or given up (that is, until the end of the Tx action)

The PRIORITY signal behaves as described above. A Tx action may have a different priority than the command it belongs to. The priority of the Tx action is set in the `coexPriority` field of the TX action struct (::RCL_CmdIeee_TxAction_t). If this priority is different from the priority of the command, the updated priority will be used during transmission and ACK reception. Note that if `coexControl.rxMode` is ::RCL_CoexRxMode_AlwaysRequest, the REQUEST signal will go low and high again in order for the priority to be signaled. There will then also be a T1 wait time before transmission of the frame. REQUEST will also go low and high again after the Tx action is done in order to set the original priority before continuing.

Note that if `coexControl.rxMode` is ::RCL_CoexRxMode_RequestOnPacket, REQUEST will not be asserted during CCA. If this is required, it is recommended to do the following procedure:
1. Stop the IEEE command that is already running.
2. Start a new IEEE command with a Tx action from the beginning. For this command `coexControl` should be set with `rxMode` as ::RCL_CoexRxMode_AlwaysRequest and `priority` as the same priority as in the Tx action. The Tx action should have `endCmdWhenDone`set.
3. When this command ends, start a new IEEE command without a Tx action and with the original setting of `coexControl`.

The GRANT signal is checked before and during transmission of a frame using a Tx action or an ACK frame. If grant is denied (from start of transmission or during the frame) for a frame transmitted with a Tx action, the Tx action will end with ::RCL_CommandStatus_CoexNoGrant as the status. If grant is denied for an ACK (Enh-ACK or Imm-Ack) transmitted in response to a received frame, the event ::RCL_EventCoexNoTx is asserted, and the command continues with Rx.
