/*
 * Copyright (c) 2024-2025, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef APU_FW_IMAGE_SEQ_APU_H
#define APU_FW_IMAGE_SEQ_APU_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

#define APULPF3_FW_SIZE 914

static const uint32_t lrf_fw_image_seq_apu[APULPF3_FW_SIZE] =
    {0x20506017, 0xE41020A1, 0x10011005, 0x35003100, 0x10012010, 0x35002000, 0x00010000, 0x00010003, 0x02000003,
     0xFF000080, 0x03CE0100, 0x731007FF, 0x1203720F, 0xB0F01214, 0xB1007100, 0x8051A0F0, 0x1C12CFF2, 0x8042441F,
     0xC1917205, 0x48461C21, 0x11011632, 0x6C011421, 0x604F604E, 0x60726056, 0x60A2608C, 0x6380636A, 0x60D4604E,
     0x60D860D0, 0x604E604E, 0x611C6101, 0x61686382, 0x614D638A, 0x604E6386, 0x614B6384, 0x6388638C, 0x60491221,
     0x90511211, 0xB021B026, 0x6017B0D0, 0xB0016048, 0x91E18061, 0x64586048, 0x631D7301, 0x60486458, 0x92F39213,
     0x80719283, 0x40602201, 0x92F0C090, 0x679B6798, 0x92318061, 0x94419311, 0x678E92A4, 0x7240679E, 0x943278E2,
     0xB0F367A5, 0x7100B1F0, 0x7000A0F3, 0x92F39213, 0x80719283, 0x407A2201, 0x92F0C090, 0x679B6798, 0x92318061,
     0x92A19311, 0x92D49264, 0x934180B1, 0x7240679E, 0xB0F367B0, 0x7100B1F0, 0x6048A0F3, 0x92F39213, 0x67989283,
     0x8061679B, 0x93119231, 0x926492A2, 0x80B192D4, 0x679E9341, 0x94318071, 0xB0F367AB, 0x7100B1F0, 0x6048A0F3,
     0x9281C011, 0x92F19211, 0x7222C011, 0x92919301, 0x679B6798, 0x101B679E, 0x82DC678E, 0x924167A1, 0x101592B1,
     0x923167A3, 0x10169321, 0x931A80BA, 0x67A51A1A, 0x943178E1, 0x720F9446, 0xC007B0F3, 0x927B9257, 0x14CB1617,
     0x933010A0, 0xB10392C0, 0x7100B1F0, 0x1C7568C7, 0x604844C2, 0x9281C011, 0x60A4C031, 0x9281C011, 0x60A4C021,
     0x92849214, 0x930392F4, 0x92939223, 0x93339253, 0x679892C3, 0x679E679B, 0x923167A3, 0x67A19311, 0x93219241,
     0x101592B1, 0x678E1A15, 0x67AB1012, 0x943178C1, 0x1206B0F3, 0x82771050, 0xB1F0B103, 0x16167100, 0x93369256,
     0x92771427, 0xA0F368F6, 0xB0256048, 0xC0017242, 0x678E9421, 0x67BA654F, 0x679E9283, 0x80671016, 0x92A49234,
     0x10701A17, 0x1016679E, 0x9208B0F4, 0xB1049276, 0x7100B1F0, 0x16161618, 0x60486913, 0x7242B025, 0x9421C011,
     0x654F678E, 0x93F1C041, 0x679E9283, 0x80671016, 0x92A79237, 0x67C692F3, 0xB0F4B104, 0x7100B1F0, 0x93F1C051,
     0x92758095, 0xB10467CB, 0x7100B1F0, 0x92349276, 0x92A49314, 0x10701A17, 0x93F1C001, 0x92E567C0, 0x92769206,
     0xB1F0B104, 0x16167100, 0x69411615, 0x73016048, 0x7301611B, 0x722060F3, 0x9211C081, 0x92717961, 0x9201B1F0,
     0x9211C071, 0x9281C071, 0xB1039273, 0xB1F0B0F3, 0xA0F37100, 0x67989213, 0x80611018, 0x78F19231, 0x70009401,
     0x795867DA, 0x791167D0, 0x67D51082, 0x79211612, 0x161267D5, 0x67D5C001, 0x92721612, 0x9201C011, 0x9211C081,
     0x1622B1F0, 0x72209272, 0x1A12B1F0, 0x72217931, 0x806A67D5, 0x1A1910A9, 0x80A210A0, 0x7944C003, 0x67D51041,
     0xC0011612, 0x10A0698B, 0x16131041, 0x458B1C93, 0x723E67D5, 0x820B6798, 0xC021820C, 0x92F19211, 0x93619281,
     0x9221C011, 0x92919301, 0xC0119371, 0x93419261, 0x93B192D1, 0x939A9231, 0x7243724C, 0x7244B430, 0xC0068074,
     0x7242C017, 0x72417240, 0xC011723F, 0x93219241, 0x722C92B1, 0x106DA1E1, 0x107E14BD, 0x920D14BE, 0x10829257,
     0x92721682, 0x93D17881, 0xB0F4B104, 0x7100B1F0, 0x723DB104, 0x72259202, 0x92E21A52, 0x93C17811, 0x7100B1F0,
     0xA0F4B104, 0x9256920D, 0x933792EE, 0x92721662, 0x7871723C, 0xB1F093D1, 0x72337225, 0x1A129202, 0x162292E2,
     0x723D9272, 0x93C17841, 0x9202B1F0, 0x10807225, 0x16F016F0, 0x92701610, 0x93C17841, 0x93F1C051, 0x9200B1F0,
     0x92E01A10, 0x92701620, 0x9431C011, 0x93D17871, 0xB104723C, 0xB1F0B0F4, 0xB1047100, 0x723DA0F4, 0x22018451,
     0x92024716, 0x92721612, 0x7881723C, 0xB0F493D1, 0xB104B1F0, 0x1AA29202, 0x781192E2, 0x710093C1, 0x927216B2,
     0xB1F0723D, 0x9202A0F4, 0x93C17841, 0x93F1C051, 0x92E2B1F0, 0x92021A72, 0xB1F0723F, 0x92021672, 0x92721612,
     0x93D17881, 0xC011723C, 0xB0F49421, 0xB104B1F0, 0x16129202, 0x93C17841, 0x92727100, 0xC041723D, 0xB1F093F1,
     0x92721612, 0x93F1C051, 0x9202B1F0, 0x92E21A12, 0x92721622, 0x78B1723C, 0xB0F493E1, 0xB104B1F0, 0x9257920D,
     0x93D17881, 0x71007242, 0x1612723E, 0xB0F49272, 0xB104B1F0, 0x72259202, 0x93C17841, 0x723D7100, 0x93F1C051,
     0x92E2B1F0, 0x92021AC2, 0xB1F0723F, 0x92028272, 0x92721612, 0x723CB420, 0x93D17881, 0xB1F0B0F4, 0x9202B104,
     0x92721612, 0x71007222, 0xB1F0723D, 0x1A42B220, 0x165292E2, 0x723D9272, 0x93C17811, 0x9202B1F0, 0x1AA29272,
     0x92E21A62, 0x16F2B1F0, 0x16229202, 0x1A629272, 0xB1F092E2, 0x9256920D, 0x92721682, 0xB1F0723C, 0x9257920E,
     0x92721612, 0xC071B1F0, 0x1AA29211, 0x72279202, 0xC031B1F0, 0xB1F09271, 0x9271C011, 0x92021672, 0xC021B1F0,
     0x1A129271, 0xB1F09202, 0xC021B1E1, 0x67989211, 0x927192E1, 0x924A9351, 0x92BA932A, 0x93379256, 0x93A792C6,
     0x93C17831, 0x93D17871, 0xB410B400, 0x720F7243, 0x7310B0F3, 0x80A1B1F0, 0x92E19201, 0x93519271, 0xC0117100,
     0x92F19211, 0x93619281, 0xB1F07310, 0xA0F37100, 0xC011A1E1, 0x72259241, 0x9211C021, 0x928192F1, 0x10829361,
     0x92021622, 0x14618081, 0x92C79271, 0x723D723C, 0x1662B1F0, 0x722C9202, 0x1A729272, 0x723392E2, 0x78117240,
     0xB1F093C1, 0x93F1C041, 0x93C17841, 0x16F2B1F0, 0x166292E2, 0x78119272, 0xB1F093C1, 0x161292E2, 0x72339202,
     0x14618081, 0x92C69271, 0x7871723C, 0xB1F093D1, 0x92021612, 0x14718081, 0x92C79271, 0xB1F0B430, 0x1C671616,
     0x61B1431A, 0x1617C006, 0x45B11C7A, 0x22016724, 0x1A144448, 0x604845AF, 0x9431C031, 0x7344B026, 0x93D17861,
     0x93C17851, 0x93F1C061, 0x16651085, 0x722C9275, 0xB0F37221, 0x1090B0E3, 0xC0111A10, 0x109310B2, 0x92021412,
     0x94431403, 0x92317100, 0xB103B1F0, 0x6B3A1611, 0xC0217100, 0xC0119441, 0x92059231, 0x93F1C051, 0xC041B1F0,
     0xB1F093F1, 0x7100B103, 0xC011723C, 0x78719431, 0x105193D1, 0x92E11611, 0x165116F1, 0xB0F49271, 0xB104B1F0,
     0x84517100, 0xC020723C, 0x72439210, 0x7244B430, 0x7000720F, 0x678E67DA, 0x67989264, 0x92418071, 0x92318061,
     0x9211C0A1, 0xC001679E, 0x22008090, 0xC091437A, 0xB1039281, 0xB1F0B0F3, 0x60487100, 0x600E7301, 0x60347301,
     0x61F37301, 0x622F7301, 0x627D7301, 0x62B07301, 0x62D07301, 0x81E0C011, 0x43932200, 0x9261C021, 0x92D19341,
     0x700093B1, 0x92018081, 0x80917000, 0x700092E1, 0x927180A1, 0x80617000, 0x80717000, 0x78117000, 0x786193C1,
     0x723E93D1, 0x723C7000, 0x93D17871, 0x7000723E, 0x93C17811, 0x723E723D, 0x723C7000, 0x93D17881, 0x7000723E,
     0x93C17811, 0x93D17881, 0x7000723E, 0x93C17841, 0x93D17881, 0x7000723E, 0x93C17821, 0x723E723D, 0x78417000,
     0x723D93C1, 0x7000723E, 0x93E178A1, 0x7228B490, 0x92727000, 0x94A1B1F1, 0x7000B4B0, 0x723D723C, 0x7000723E,
     0x730167D0, 0x67D56314, 0x63177301, 0x7301678E, 0x9160631A, 0x22008150, 0xB14047E8, 0x00007000, 0x00000000,
     0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x60177201,
     0x20503100, 0x1005E410, 0x35000000, 0x00000000, 0x10013500, 0x03CE0100, 0x80978076, 0x806A8088, 0xC01980AB,
     0xC0019069, 0x671B9071, 0xB026B0F3, 0x92391619, 0x94499319, 0x92081A18, 0x927B161B, 0x7100B1F0, 0x1CA9B103,
     0xB0264419, 0x92E71617, 0x927B161B, 0x7100B1F0, 0x1619B103, 0x44271C96, 0x60487201, 0x8065721E, 0x18158071,
     0x10191615, 0xDFFD1411, 0x161D14DD, 0xC001181D, 0xC0919211, 0xC02192F1, 0x80719281, 0x92B192A1, 0xC0119235,
     0xC0119291, 0x93419261, 0x723E92D1, 0x93D17821, 0x93C17831, 0x9431C031, 0x72409445, 0x92068086, 0x92788098,
     0xC0021067, 0x1A101090, 0x92E7B0F3, 0x92E76065, 0x92C27100, 0xB103B1F0, 0x16171612, 0xC0126863, 0x1A1B109B,
     0x149E10DE, 0x106F106A, 0x1086145F, 0x161810D7, 0x7100C00C, 0x9281C001, 0x92F1C091, 0x7831723D, 0x722693C1,
     0x931B923B, 0x920A92AB, 0x927D92EA, 0xB103B1F0, 0x920F161A, 0x927E92EF, 0x7100161F, 0xB103B1F0, 0x92ED920E,
     0xC011927D, 0x71009431, 0x723CB260, 0x93D17871, 0x92F1C001, 0xB103B1F0, 0x1A1010B0, 0x72237100, 0xC001B230,
     0x10219431, 0x14C814C6, 0x14169206, 0x92781418, 0x161792E7, 0x1611B1F0, 0x142C68A8, 0x14268096, 0x80981612,
     0x10D71428, 0x447A1A1B, 0x80A17100, 0x44F11C41, 0xB0F48098, 0xB103B104, 0x9211C001, 0x109065E5, 0x140EC00E,
     0x108268C7, 0x102D14E2, 0x109CC01A, 0x10EF18AC, 0xC00B189F, 0x14F11081, 0x920114C1, 0xB1F0927D, 0x161B161D,
     0x14BF189F, 0x44D21CBA, 0x1091161A, 0x1CA11611, 0xC00144CD, 0x92089211, 0x92E29278, 0x931E923E, 0xC00192AE,
     0xB0F465DE, 0xB103B104, 0x720165EF, 0x78D26048, 0x80768065, 0x80988087, 0x9211C001, 0xC0919281, 0x920792F1,
     0x927892E7, 0x93449264, 0x103A92D3, 0x1A101060, 0x6906145A, 0x931A923A, 0x92A4944A, 0x9431C031, 0xB0F46514,
     0x65EFB104, 0x60487201, 0x93C17831, 0x93D17821, 0x93E17891, 0x78D87000, 0x8069B027, 0x808B807A, 0x723D723C,
     0x6712723E, 0x108278C1, 0x92496715, 0x92B992B9, 0x92649399, 0xC00193B4, 0xC01192F1, 0xC0019361, 0x92919221,
     0x93719301, 0x10BDC006, 0xB104B0F4, 0x186E10AE, 0x9211C091, 0x92F1C001, 0x10D19281, 0x92011461, 0x108292E1,
     0x92721622, 0x92D49344, 0x18651095, 0x93159235, 0x65D192A5, 0xC00165EF, 0x92029211, 0x92721492, 0x94759235,
     0x92D392A4, 0x65D7C011, 0x848F65EF, 0x45611E15, 0x92021A1F, 0x92721612, 0x16111081, 0x923492E1, 0xC0119314,
     0x65EF65DE, 0x1E018451, 0x1E0F45CB, 0xC011418C, 0x92569211, 0x1612920D, 0x923E9272, 0x92D492AE, 0x65EF65E5,
     0x14618481, 0xC0119251, 0x92B99281, 0x92C6927D, 0xC00165EF, 0x92029211, 0x14618481, 0x65EF92C1, 0x92021082,
     0x92E21622, 0x92721612, 0x9281C001, 0x92A49234, 0x65EF65E9, 0x9211C091, 0x146110D1, 0x92E29201, 0x92721612,
     0x65EF65D1, 0x9211C011, 0x920D9281, 0x92E2927D, 0x931E923E, 0x925692AE, 0x934392C6, 0x65EF92D4, 0x1C76C007,
     0x10D141C8, 0x92E11471, 0x9281C001, 0x93439256, 0x92721612, 0x65EF65D1, 0x92C79257, 0x934492E2, 0x9281C011,
     0xC011927D, 0x65EF65DE, 0x1C791617, 0x161645B1, 0x1C69149D, 0x7201453A, 0x723C6048, 0x723E723D, 0x93C17831,
     0x94617000, 0x723D723C, 0x78B1723E, 0x700093E1, 0x723C9431, 0x723E723D, 0x93D17871, 0x723C7000, 0x723E723D,
     0x723C7000, 0x723E723D, 0x93E178A1, 0xB1F07000, 0xB1047100, 0xB0277000, 0x92F39213, 0x80719283, 0x80669461,
     0x78D78085, 0x93436718, 0x62001018, 0xB0F3B027, 0x92056702, 0x92349277, 0xB1F09314, 0xB1037100, 0x92369275,
     0x94769316, 0x92A492B4, 0x723D723C, 0x93E178B1, 0x7100B1F0, 0x8482B103, 0x10511080, 0x14211821, 0x92716A1B,
     0x67029207, 0x93149234, 0xB1F0B0F3, 0xA0F37100, 0x1485B103, 0x46001A16, 0x60487201, 0x7201B1E2, 0xB1E16048,
     0x806AA1E0, 0x8085923A, 0x80719205, 0x462C2201, 0x2211A1E2, 0xC051463D, 0xC061623E, 0x92F19211, 0x93619281,
     0x391610A6, 0x93169236, 0x938692A6, 0x92759205, 0x9261C011, 0x92D19341, 0x784193B1, 0x787193C1, 0xB40093D1,
     0x7243B410, 0xC018C017, 0x1059B0F4, 0x92E91489, 0x62639359, 0x14891059, 0x935992E9, 0x92577100, 0x92C79337,
     0xB1F093A7, 0x3118B104, 0x1C8A1617, 0x7100465E, 0x7240A1E1, 0x723C7241, 0x7243723D, 0x72337225, 0x723A722C,
     0x722E7235, 0x72017236, 0x80656048, 0x80878076, 0x80A98098, 0x723D723C, 0xB0F3720F, 0xC0017310, 0x92819211,
     0x9221C011, 0x92649291, 0x107D9468, 0xC00A161D, 0x14AC106C, 0x927D920C, 0x92A49234, 0x723E92D4, 0x7100B1F0,
     0x9207B103, 0x9471C021, 0x92A19231, 0x109E92D3, 0x927E14AE, 0x93E178B1, 0x7100B1F0, 0x161AB103, 0x46921CA5,
     0x60487201, 0x80768065, 0x80988087, 0xC00180A9, 0x92F19211, 0x92649281, 0x92D49344, 0x92E79206, 0x92359279,
     0x92A59315, 0x723D723C, 0x720F723E, 0x7310B0F3, 0x785193F8, 0xB1F093C1, 0xB1037100, 0x60487201, 0x80768065,
     0x723C8087, 0x723E723D, 0xB0F4720F, 0xC0017310, 0x92649281, 0x105092D4, 0xC00A1A10, 0x107978D8, 0x9211C021,
     0x9221C011, 0x925A9206, 0x92459278, 0x92A59235, 0x7100B1F0, 0xC001B104, 0x10819211, 0x920114A1, 0x16111001,
     0x92A19231, 0xB1F09279, 0xB1047100, 0x1409161A, 0x6AE21619, 0x60487201, 0x723D723C, 0x7000723E, 0xB1E16702,
     0x92017000, 0x927292E2, 0x92339351, 0xB1F0B103, 0x70007100, 0x63DE7201, 0x72017000, 0x700063E1, 0x63E47201,
     0x72017000, 0x70006053, 0x81509160, 0x471F2200, 0x7000B140};

#ifdef __cplusplus
}
#endif

#endif /* APU_FW_IMAGE_SEQ_APU_H */
