/*
 * Copyright (c) 2020-2022, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 *  ======== QueueP.h ========
 */

#ifndef kernel_freertos_dpl_QueueP__include
#define kernel_freertos_dpl_QueueP__include

#include <stdint.h>
#include <stdbool.h>
#include <stddef.h>

typedef struct _QueueP_Elem
{
    struct _QueueP_Elem *volatile next;
    struct _QueueP_Elem *volatile prev;
} QueueP_Elem;

typedef struct _QueueP_Obj
{
    QueueP_Elem elem;
} QueueP_Obj;

typedef QueueP_Obj *QueueP_Handle;

void QueueP_init(QueueP_Obj *obj);
uintptr_t QueueP_head(QueueP_Obj *obj);
uintptr_t QueueP_next(QueueP_Elem *qelem);
uintptr_t QueueP_prev(QueueP_Elem *qelem);
uintptr_t QueueP_get(QueueP_Obj *obj);
void QueueP_put(QueueP_Obj *obj, QueueP_Elem *elem);
void QueueP_remove(QueueP_Elem *qelem);
bool QueueP_empty(QueueP_Obj *obj);

#endif
