## Example Summary

Example that uses the I2S driver to echo the audio received from the
Line In (Audio source) over the Line Out (headphones|speakers).
This example shows:

* How to initialize the I2S driver in streaming mode with audio echo.
* How to achieve I2S transfers with CD quality (16bits - 44.1 kHz).
* How to treat (filter) sample data.

## Peripherals & Pin Assignments

When this project is built, the SysConfig tool will generate the TI-Driver
configurations into the __ti_drivers_config.c__ and __ti_drivers_config.h__
files. Information on pins and resources used is present in both generated
files. Additionally, the System Configuration file (\*.syscfg) present in the
project may be opened with SysConfig's graphical user interface to determine
pins and resources used.

* `CONFIG_GPIO_LED_0` - Indicates that the board was initialized within
`mainThread()`.
* `CONFIG_I2C_0` - Used to configure the TI codec on the Audio BoosterPack.
* `CONFIG_I2S_0` - Used to echo sounds received from Audio In on Audio Out.

## BoosterPacks, Board Resources & Jumper Settings

This example requires a [__CC3200 Audio BoosterPack__][cc3200audboost]

For board specific jumper settings, resources and BoosterPack modifications,
refer to the __Board.html__ file. Due to the required jumper wires, some boards
will not use the CC3200AUDBOOST hardware component in SysConfig but will instead
assign the I2S pins manually.

> If you're using an IDE such as Code Composer Studio (CCS) or IAR, please
refer to Board.html in your project directory for resources used and
board-specific jumper settings.

The Board.html can also be found in your SDK installation:

```text
<SDK_INSTALL_DIR>/source/ti/boards/<BOARD>
```

* A pair of (headphones|speakers) and an audio source (smartphone) are
required to observe functionality.

## Example Usage

* Mount the CC3200 Audio BoosterPack.

* Connect headphones or speakers to the Audio BoosterPack, as well as an audio source.

* Run the example. `CONFIG_GPIO_LED_0` turns ON to indicate driver
initialization is complete.

* Sounds captured on audio line in are echoed after basic filtering.

* The quality of the audio output is directly related to the quality of your audio
source. For this purpose, avoid using a highly disturbed audio source.
For example, when using your smartphone as an audio source, avoid leaving it in charge
at the same time: this creates a lot of audio disturbances.

> If you halt the target during execution of this example, and then
run again, the echoing will not resume. You will need to reload the program.

## Application Design Details

* One thread, `echoThread` is used to configure the codec and start
the I2S transfers.

* Ten I2S_Transactions are declared and a buffer is associated to each
of them (in this example, the buffer held by a transaction remains the
same during execution).

* The I2S transactions are initially queued in two lists: `i2sReadList`
and `i2sWriteList`. `treatmentList` will be populated later (i.e. when
some transaction of the `i2sReadList` will be finished).

* The buffers held by the transactions are successively written (by the
read interface), treated and sent out (by the write interface).
Here is a scheme showing the path followed by a transaction:

```text

    `i2sReadList`          `treatmentList`          `i2sWriteList`
    [Transaction] ... (1)   [Transaction] ... (2)   [Transaction]....  (3)
    [Transaction]   :......>[Transaction]   :       [Transaction]   :
    [Transaction]                           :       [Transaction]   :
 ..>[Transaction]                           :......>[Transaction]   :
 :                                                                  :
 :..................................................................:
```

*(1) The read interface systematically fills the buffer contained in the head
transaction of the i2sReadList. When the buffer held by this transaction is
full, the transaction is dequeued from the i2sReadList  and queued as the
tail of the treatmentList. The read interface continues receiving data by
using the next transaction of the i2sReadList.*

*(2) The treatment function treats the sample data contained by the transactions
queued in the treatmentList. The transaction treated is the head transaction
of the treatmentList. Once this transaction is treated, the transaction is
dequeued from the treatmentList and queued in the i2sWriteList.*

*(3) The write interface systematically sends out the buffer contained in the
head transaction of the i2sWriteList. When the buffer held by this transaction
has been completely sent out, the corresponding transaction is dequeued from
the i2sWriteList and queued in the i2sReadList . The write interface continues
sending out data by using the next transaction of the i2sWriteList.*

> The drivers by default are non-instrumented in order to limit code size.

FreeRTOS:

* Please view the `FreeRTOSConfig.h` header file for example configuration
information.

[cc3200audboost]: https://www.ti.com/tool/cc3200audboost
