import enum


class CommonCommands(enum.IntEnum):
    COMMON_CMD_GET_DEV_ADDR = 0x00
    COMMON_CMD_RESET_DEVICE = 0x01


class CentralCommands(enum.IntEnum):
    CENTRAL_CMD_SCAN_START = 0x00
    CENTRAL_CMD_SCAN_STOP = 0x01
    CENTRAL_CMD_CONNECT = 0x02


class PeripheralCommands(enum.IntEnum):
    PERI_CMD_ADVERTISE_START = 0x00
    PERI_CMD_ADVERTISE_STOP = 0x01


class HandoverCommands(enum.IntEnum):
    HANDOVER_CMD_START_SN = 0x00
    HANDOVER_CMD_START_CN = 0x01
    HANDOVER_CMD_CLOSE_SN = 0x02


class CsCommands(enum.IntEnum):
    CS_CMD_READ_LOCAL_CAP = 0x00
    CS_CMD_READ_REMOTE_CAP = 0x01
    CS_CMD_CREATE_CONFIG = 0x02
    CS_CMD_SECURITY_ENABLE = 0x03
    CS_CMD_SET_DEFAULT_SETTINGS = 0x04
    CS_CMD_READ_FAE_TABLE = 0x05
    CS_CMD_WRITE_FAE_TABLE = 0x06
    CS_CMD_REMOVE_CONFIG = 0x07
    CS_CMD_SET_CHNL_CLASS = 0x08
    CS_CMD_SET_PROCEDURE_PARAMS = 0x09
    CS_CMD_PROCEDURE_ENABLE = 0x0A
    CS_CMD_SET_DEFAULT_ANT = 0x0B


class RREQStatus(enum.IntEnum):
    RREQ_STATUS_TIMEOUT = 0x00
    RREQ_STATUS_ABORTED_SUCCESSFULLY = 0x01
    RREQ_STATUS_ABORTED_UNSUCCESSFULLY = 0x02
    RREQ_STATUS_SERVER_BUSY = 0x03
    RREQ_STATUS_PROCEDURE_NOT_COMPLETED = 0x04
    RREQ_STATUS_NO_RECORDS = 0x05
    RREQ_STATUS_DATA_INVALID = 0x06
    RREQ_STATUS_DATA_OVERWRITTEN = 0x07


class ConnectionCommands(enum.IntEnum):
    CONNECTION_CMD_REGISTER_CONN_EVENT = 0x00
    CONNECTION_CMD_UNREGISTER_CONN_EVENT = 0x01
    CONNECTION_CMD_SET_PHY = 0x02
    CONNECTION_CMD_TERMINATE_LINK = 0x03


class PairingCommands(enum.IntEnum):
    PAIRING_CMD_GET_MAX_NUM_CHAR_CFG = 0x00
    PAIRING_CMD_READ_BOND = 0x01
    PAIRING_CMD_WRITE_BOND = 0x02
    PAIRING_CMD_SET_OOB_ENABLE = 0x03
    PAIRING_CMD_SET_REMOTE_OOB_DATA = 0x04
    PAIRING_CMD_GET_LOCAL_OOB_DATA = 0x05
    PAIRING_CMD_GENERATE_ECC_KEYS = 0x06


class GATTCommands(enum.IntEnum):
    GATT_CMD_MTU_EXCHANGE = 0x00


class L2CAPCommands(enum.IntEnum):
    L2CAP_CMD_CREATE_PSM = 0x00
    L2CAP_CMD_CLOSE_PSM = 0x01
    L2CAP_CMD_CONNECT_REQ = 0x02
    L2CAP_CMD_DISCONNECT_REQ = 0x03
    L2CAP_CMD_SEND_SDU = 0x04


class CmCommands(enum.IntEnum):
    CM_CMD_START_SERVING = 0x00
    CM_CMD_START_MONITORING = 0x01
    CM_CMD_STOP_MONITORING = 0x02
    CM_CMD_UPDATE_CONN = 0x03


class CaServerCommands(enum.IntEnum):
    CA_SERVER_CMD_SEND_INDICATION = 0x00


class RREQCommands(enum.IntEnum):
    RREQ_CMD_START = 0x00
    RREQ_CMD_ENABLE = 0x01
    RREQ_CMD_DISABLE = 0x02
    RREQ_CMD_GET_RANGING_DATA = 0x03
    RREQ_CMD_ABORT = 0x04


class RRSPCommands(enum.IntEnum):
    RRSP_CMD_SEND_CS_ENABLE_EVENT = 0x01
    RRSP_CMD_SEND_CS_EVENT = 0x02
    RRSP_CMD_SEND_CS_EVENT_CONT = 0x03


class AppSpecifier(enum.IntEnum):
    APP_SPECIFIER_CENTRAL = 0x00
    APP_SPECIFIER_PERIPHERAL = 0x01
    APP_SPECIFIER_CONNECTION = 0x02
    APP_SPECIFIER_PAIRING = 0x03
    APP_SPECIFIER_HANDOVER = 0x04
    APP_SPECIFIER_CS = 0x05
    APP_SPECIFIER_CM = 0x06
    APP_SPECIFIER_COMMON = 0x07
    APP_SPECIFIER_L2CAP = 0x08
    APP_SPECIFIER_GATT = 0x09
    APP_SPECIFIER_CA_SERVER = 0x0A
    APP_SPECIFIER_RREQ = 0x0B
    APP_SPECIFIER_RRSP = 0x0C


class RtlsCapabilities(enum.IntEnum):
    RTLS_CAP_NOT_INITIALIZED = 0x00000000
    RTLS_CAP_CM = 0x00000001
    RTLS_CAP_AOA_TX = 0x00000002
    RTLS_CAP_AOA_RX = 0x00000004
    RTLS_CAP_RESERVED1 = 0x00000008
    RTLS_CAP_CL_AOA = 0x00000010
    RTLS_CAP_RESERVED3 = 0x00000020
    RTLS_CAP_RTLS_RESPONDER = 0x00000040
    RTLS_CAP_RTLS_COORDINATOR = 0x00000080
    RTLS_CAP_RTLS_PASSIVE = 0x00000100
    RTLS_CAP_RTLS_CONNECTION_MONITOR = 0x00000200
    RTLS_CAP_CENTRAL = 0x00000400
    RTLS_CAP_PERIPHERAL = 0x00000800
    RTLS_CAP_HANDOVER = 0x00001000
    RTLS_CAP_CONNECTION = 0x00002000
    RTLS_CAP_PAIRING = 0x00004000
    RTLS_CAP_L2CAPCOC = 0x00008000
    RTLS_CAP_CS = 0x00010000
    RTLS_CAP_GATT = 0x00020000
    RTLS_CAP_CA_SERVER = 0x00040000
    RTLS_CAP_RREQ = 0x00080000
    RTLS_CAP_RRSP = 0x00100000


class CommonEventType(enum.IntEnum):
    NWP_COMMON_DEVICE_ADDRESS = 0x0020
    NWP_COMMON_COMMAND_STATUS_EVENT = 0x0021
    NWP_COMMON_HCI_COMPLETE_EVENT = 0x0022
    NWP_COMMON_HCI_LE_EVENT = 0x0023


class PeripheralEventType(enum.IntEnum):
    NWP_ADV_START_AFTER_ENABLE = 0x0001
    NWP_ADV_END_AFTER_DISABLE = 0x0002


class CentralEventType(enum.IntEnum):
    NWP_SCAN_ENABLED = 0x0003
    NWP_SCAN_DISABLED = 0x0004
    NWP_ADV_REPORT = 0x0005


class ConnectionEventType(enum.IntEnum):
    NWP_LINK_ESTABLISHED_EVENT = 0x0006
    NWP_LINK_TERMINATED_EVENT = 0x0007
    NWP_LINK_PARAM_UPDATE_REQ_EVENT = 0x0008
    NWP_LINK_PARAM_UPDATE_EVENT = 0x0009
    NWP_CONN_NOTI_CONN_EVENT = 0x000A
    NWP_CONN_DEVICE_ADDRESS = 0x0020


class PairingEventType(enum.IntEnum):
    NWP_PAIRING_STATE_STARTED = 0x000C
    NWP_PAIRING_STATE_COMPLETE = 0x000D
    NWP_PAIRING_STATE_ENCRYPTED = 0x000E
    NWP_PAIRING_STATE_BOND_SAVED = 0x000F
    NWP_PAIRING_MAX_NUM_CHAR_CFG = 0x0090
    NWP_PAIRING_READ_BOND = 0x0091
    NWP_PAIRING_WRITE_BOND = 0x0092
    NWP_PAIRING_GET_LOCAL_OOB_DATA = 0x0093


class GATTEventType(enum.IntEnum):
    NWP_GATT_MTU_UPDATED_EVENT = 0x0024


class HandoverEventType(enum.IntEnum):
    NWP_HANDOVER_SN_DATA = 0x000B
    NWP_HANDOVER_CN_STATUS = 0x0010


class CmEventType(enum.IntEnum):
    NWP_CM_SERVING_DATA = 0x0011
    NWP_CM_REPORT = 0x0012
    NWP_CM_START = 0x0013
    NWP_CM_STOP = 0x0014
    NWP_CM_CONN_UPDATE_EVENT = 0x0015


class L2CAPEventType(enum.IntEnum):
    NWP_L2CAP_DATA_RECEIVED = 0x0030
    NWP_L2CAP_CHANNEL_ESTABLISHED = 0x0031
    NWP_L2CAP_CHANNEL_TERMINATED = 0x0032
    NWP_L2CAP_OUT_OF_CREDIT = 0x0033


class CaServerEventType(enum.IntEnum):
    NWP_CA_SERVER_CCC_UPDATE = (0x0080,)
    NWP_CA_SERVER_INDICATION_CNF = (0x0081,)
    NWP_CA_SERVER_LONG_WRITE_DONE = 0x0082


class RREQEventType(enum.IntEnum):
    NWP_RREQ_DATA_READY = 0x00A0
    NWP_RREQ_STATUS = 0x00A1


class RRSPEventType(enum.IntEnum):
    NWP_RRSP_SEND_CS_ENABLE_EVENT = 0x00B1
    NWP_RRSP_SEND_CS_EVENT = 0x00B2
    NWP_RRSP_SEND_CS_EVENT_CONT = 0x00B3


class CmConnUpdateType(enum.IntEnum):
    CM_PHY_UPDATE_EVT = 0x00
    CM_CHAN_MAP_UPDATE_EVT = 0x01
    CM_PARAM_UPDATE_EVT = 0x02


class CsEventType(enum.IntEnum):
    NWP_CS_READ_REMOTE_CAPS = 0x0040
    NWP_CS_CONFIG_COMPLETE = 0x0041
    NWP_CS_READ_REMOTE_FAE_TABLE = 0x0042
    NWP_CS_SECURITY_ENABLE_COMPLETE = 0x0043
    NWP_CS_PROCEDURE_ENABLE_COMPLETE = 0x0044
    NWP_CS_SUBEVENT_RESULTS = 0x0045
    NWP_CS_SUBEVENT_RESULTS_CONTINUE = 0x0046
    NWP_CS_APP_DISTANCE_RESULTS = 0x0060
    NWP_CS_APP_DISTANCE_EXTENDED_RESULTS = 0x0061


class CsProcedureDoneStatusType(enum.IntEnum):
    NWP_CS_PROCEDURE_DONE = 0x00
    NWP_CS_PROCEDURE_ACTIVE = 0x01
    NWP_CS_PROCEDURE_ABORTED = 0x0F


class CsSubeventDoneStatusType(enum.IntEnum):
    NWP_CS_SUBEVENT_DONE = 0x00
    NWP_CS_SUBEVENT_ACTIVE = 0x01
    NWP_CS_SUBEVENT_ABORTED = 0x0F


class CmStopReasonType(enum.IntEnum):
    CM_SUPERVISION_TIMEOUT = 0x00
    CM_USER_TERM = 0x01
    CM_SYNC_FAILED = 0x02


class AddressType(enum.IntEnum):
    ADDRTYPE_PUBLIC = 0x00
    ADDRTYPE_RANDOM = 0x01
    ADDRTYPE_PUBLIC_ID = 0x02
    ADDRTYPE_RANDOM_ID = 0x03
    ADDRTYPE_RANDOM_NR = 0xFE
    ADDRTYPE_NONE = 0xFF


class AddressMode(enum.IntEnum):
    # Use Public Address
    ADDRMODE_PUBLIC = (0x00,)
    # Use Random Static Address
    ADDRMODE_RANDOM = (0x01,)
    # Use Resolvable Private Address with Public Identity Address
    ADDRMODE_RP_WITH_PUBLIC_ID = (0x02,)
    # Use Resolvable Private Address with Random Identity Address
    ADDRMODE_RP_WITH_RANDOM_ID = (0x03,)
    ADDRTYPE_NONE = 0xFF


class ConnectionRoleType(enum.IntEnum):
    PERIPHERAL_ROLE = 0x04
    CENTRAL_ROLE = 0x08


class ConnectionEventStatus(enum.IntEnum):
    CONNECTION_EVENT_STATUS_SUCCESS = 0x0
    CONNECTION_EVENT_STATUS_CRC_ERR = 0x1
    CONNECTION_EVENT_STATUS_MISSED = 0x2


class ConnectionPhy(enum.IntEnum):
    CONNECTION_PHY_NONE = 0x00
    CONNECTION_PHY_1M = 0x01
    CONNECTION_PHY_2M = 0x02
    CONNECTION_PHY_CODED = 0x04


class ConnectionEventTaskType(enum.IntEnum):
    CONNECTION_EVENT_TASK_TYPE_ADV = 0x0001
    CONNECTION_EVENT_TASK_TYPE_INIT = 0x0004
    CONNECTION_EVENT_TASK_TYPE_PERIPHERAL = 0x0040
    CONNECTION_EVENT_TASK_TYPE_SCAN = 0x0002
    CONNECTION_EVENT_TASK_TYPE_CENTRAL = 0x0080
    CONNECTION_EVENT_TASK_TYPE_NONE = 0xFFFF


class ConnectionEventNotifyType(enum.IntEnum):
    CONNECTION_EVENT_INVALID = 0x00
    CONNECTION_EVENT_ESTABLISHED = 0x01
    CONNECTION_EVENT_PHY_UPDATE = 0x02
    CONNECTION_EVENT_ALL = 0xFF


class ConnectionPhyOpts(enum.IntEnum):
    CONNECTION_PHY_OPT_NONE = 0x00
    CONNECTION_PHY_OPT_S2 = 0x01
    CONNECTION_PHY_OPT_S8 = 0x02


class ConnectionPhysPreference(enum.IntEnum):
    CONNECTION_USE_TX_RX_PHY_PARAM = 0x00
    CONNECTION_ANY_TX_USE_RX_PHY_PARAM = 0x01
    CONNECTION_USE_TX_ANY_RX_PHY_PARAM = 0x02
    CONNECTION_ANY_TX_ANY_RX_PHY_PARAM = 0x03


class CmPacketStatus(enum.IntEnum):
    CM_PKT_STATUS_NOT_RECEIVED = 0x00
    CM_PKT_VALID_CENTRAL = 0x01
    CM_PKT_VALID_PERIPHERAL = 0x02
    CM_PKT_STATUS_UNDETERMINED = 0x03


class BondReadTypes(enum.IntEnum):
    READ_BOND_BY_ADDRESS = 0x00
    READ_BOND_BY_INDEX = 0x01


class BondAddressTypes(enum.IntEnum):
    BOND_PEER_ADDRESS_PUBLIC_OR_PUBLIC_ID = 0x00
    BOND_PEER_ADDRESS_RANDOM_OR_RANDOM_ID = 0x01


class RREQEnableModes(enum.IntEnum):
    RREQ_ON_DEMAND = 0x01
    RREQ_REAL_TIME = 0x02
