/*
 * Copyright (c) 2018-2022, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 *  ======== TRNG.c ========
 *
 *  This file contains default values for the TRNG_Params struct
 *
 */

#include <stdlib.h>
#include <string.h>

#include <ti/drivers/dpl/DebugP.h>
#include <ti/drivers/dpl/SemaphoreP.h>
#include <ti/drivers/TRNG.h>

/* Extern globals */
extern const TRNG_Config TRNG_config[];
extern const uint_least8_t TRNG_count;

const TRNG_Params TRNG_defaultParams = {
    .returnBehavior         = TRNG_RETURN_BEHAVIOR_BLOCKING,
    .cryptoKeyCallbackFxn   = NULL,
    .randomBytesCallbackFxn = NULL,
    .timeout                = SemaphoreP_WAIT_FOREVER,
    .custom                 = NULL,
};

/*
 *  ======== TRNG_Params_init ========
 */
void TRNG_Params_init(TRNG_Params *params)
{
    *params = TRNG_defaultParams;
}

/*
 *  ======== TRNG_open ========
 */
__attribute__((weak)) TRNG_Handle TRNG_open(uint_least8_t index, TRNG_Params *params)
{
    DebugP_assert(index <= TRNG_count);

    TRNG_Config *config = (TRNG_Config *)&TRNG_config[index];

    return TRNG_construct(config, params);
}
