// NB! This file is autogenerated, do not edit!

// Ensure that object is not created twice
const InstanceCache = {};

// Exported functions
exports = {
    get: get,
    create: create
};

/*!
 *  ======== get ========
 *  Get the Javascript utility module. Create if it doesn't exist.
 *
 *  @param phyGroup - ble, prop, ieee_154
 *  @param phyName - PHY instance ID
 *  @param imports - Support functions from PHY instance
 */
function get(phyGroup, phyName, imports) {
    if (!(phyName in InstanceCache)) {
        InstanceCache[phyName] = create(phyGroup, imports);
    }
    // Update PHY functions in case PHY handler object has been cloned
    InstanceCache[phyName].setContext(imports);

    return InstanceCache[phyName];
}

/*!
 *  ======== create ========
 *  Create the Javascript utility module.
 *
 *  @param phyGroup - ble, prop, ieee_154
 */
function create(phyGroup) {
    // Module imports and exports
    const PhyGroup = phyGroup;    let getPhyProperty;

    function setContext(imports) {
        getPhyProperty = imports.getPhyProperty;
    }

    function getPpFrequency() {
        if (PhyGroup === "ble") {
            return getPpFrequencyBle();
        }
        else if (PhyGroup === "prop") {
            return getPpFrequencyProp();
        }
        return getPpFrequency154();
    }

    function convBleChannelToFreq(channel, customFreq) {
        if (channel == 40) {
            return customFreq;
        } else if (channel == 37) {
            return 2402;
        } else if (channel == 38) {
            return 2426;
        } else if (channel == 39) {
            return 2480;
        } else if ((channel >= 0) && (channel <= 10)) {
            return 2402 + 2 + (2 * channel);
        } else if ((channel >= 11) && (channel <= 36)) {
            return 2402 + 2 + 2 + (2 * channel);
        } else {
            return NaN;
        }
    }

    function convIeee802154ChannelToFreq(channel) {
        if ((channel >= 11) && (channel <= 26)) {
            return 2405 + (5 * (channel - 11));
        } else {
            return NaN;
        }
    }

    function convPaTableSettingToBinary(txPower, value, isHighPa) {
        var tempCoeff = (value >> 16) & 0xFF;
        var settingData = [];
        settingData[0] = Math.ceil(txPower * 2) & 0xFF;
        settingData[1] = tempCoeff;
        settingData[2] = (value >> 0) & 0xFF;
        settingData[3] = (value >> 8) & 0xFF;
        return settingData;
    }

    function convPaTableSettingToString(txPower, value, isHighPa) {
        var txPowerInt         = Math.ceil(txPower * 2) >> 1;
        var txPowerFract       = Math.ceil(txPower * 2) & 1;
        var tempCoeff          = (value >> 16) & 0xFF;
        var ibBoost            = (value >> 0) & 0x03;
        var ib                 = (value >> 2) & 0x3F;
        var gain               = (value >> 8) & 0x07;
        var mode               = (value >> 11) & 0x03;
        // The pa20dBmEsdCtl and rtrimTxCompCtl fields are initialized to zero by default.
        // RCL dynamically sets these fields based on the mode and VDDS values.
        var noIfampRfLdoBypass = (value >> 15) & 0x01;
        return "{ .power = { .fraction = " + txPowerFract +
               ", .dBm = " + txPowerInt +
               " }, .tempCoeff = " + tempCoeff +
               ", .value = { .ibBoost = " + ibBoost +
               ", .ib = " + ib +
               ", .gain = " + gain +
               ", .mode = " + mode +
               ", .rtrimTxCompCtl = 0" +
               ", .pa20dBmEsdCtl = 0" +
               ", .noIfampRfLdoBypass = " + noIfampRfLdoBypass +
               " } }";
    }

    function convTxPowerLimitTableEntryToBinary(regulatoryDomainNameList, minFreq, maxFreq, maxTxPower) {
        var entryData = [];
        entryData[0] = (minFreq >> 0) & 0xFF;
        entryData[1] = (minFreq >> 8) & 0xFF;
        entryData[2] = (maxFreq >> 0) & 0xFF;
        entryData[3] = (maxFreq >> 8) & 0xFF;
        entryData[4] = getRegulatoryDomainMask(regulatoryDomainNameList);
        entryData[5] = Math.floor(maxTxPower * 2);
        return entryData;
    }

    function convTxPowerLimitTableEntryToString(regulatoryDomainNameList, minFreq, maxFreq, maxTxPower) {
        var regulatoryMask     = getRegulatoryDomainMask(regulatoryDomainNameList);
        var maxTxPowerInt      = Math.floor(maxTxPower * 2) >> 1;
        var maxTxPowerFract    = Math.floor(maxTxPower * 2) & 1;
        if (minFreq < 0) {
            minFreq = 0x0000;
        }
        if (maxFreq < 0) {
            maxFreq = 0xFFFF;
        }
        return "{ .minFreq = " + minFreq + ", .maxFreq = " + maxFreq + ", .regulatoryMask = 0x" + hexString(regulatoryMask, 2) + ", .maxTxPower = { .fraction = " + maxTxPowerFract + ", .dBm = " + maxTxPowerInt + " } }"
    }

    function genRegulatoryDomainConstants() {
        var constantDefList = [];

        // Add header comment
        constantDefList[0] = "Regulatory domains (for channel specific TX output power limitation)";

        // Add constants
        var n = constantDefList.length;
        constantDefList[n++] = "RCL_REGULATORY_DOMAIN_ETSI,0x" + hexString(getRegulatoryDomainMask("etsi"), 2);
        constantDefList[n++] = "RCL_REGULATORY_DOMAIN_FCC,0x" +  hexString(getRegulatoryDomainMask("fcc"), 2);
        constantDefList[n++] = "RCL_REGULATORY_DOMAIN_MIIT,0x" + hexString(getRegulatoryDomainMask("miit"), 2);

        return constantDefList;
    }

    function getFrequencyWithOffset() {
        return getPpFrequency() + getTestProperty("frequencyOffset");
    }

    function getPpFrequencyBle() {
        return convBleChannelToFreq(getPhyProperty("bleChannel"), getPhyProperty("frequency"));
    }

    function getPpFrequency154() {
        return convIeee802154ChannelToFreq(getPhyProperty("ieee802154Channel"));
    }

    function getRegulatoryDomainMask(name) {
        var nameList = String(name).split(",");
        var mask = 0x00;
        if (nameList.indexOf("etsi") >= 0) {
            mask |= 0x01;
        }
        if (nameList.indexOf("fcc") >= 0) {
            mask |= 0x02;
        }
        if (nameList.indexOf("miit") >= 0) {
            mask |= 0x04;
        }
        if (nameList.indexOf("all") >= 0) {
            mask |= 0xFF;
        }
        return mask
    }

    function zeroPadStart(valueString, width) {
        while (valueString.length < width) {
            valueString = "0" + valueString;
        }
        return valueString;
    }

    function hexString(value, width) {
        return zeroPadStart(Number(value).toString(16), width);
    }

    function byteString(values) {
        var bytes = [];
        for (i = 0; i < values.length; i++) {
            bytes[i] = zeroPadStart(Number(values[i]).toString(16), 2);
        }
        return bytes.join(" ");
    }

    function valueToBytesBe(value, byteCount) {
        var bytes = [];
        for (i = 0; i < byteCount; i++) {
            bytes[i] = (value >> (8 * (byteCount - 1 - i))) & 0xFF;
        }
        return bytes
    }

    function valueToBytesLe(value, byteCount) {
        var bytes = [];
        for (i = 0; i < byteCount; i++) {
            bytes[i] = (value >> (8 * i)) & 0xFF;
        }
        return bytes
    }

    function genCrcSection(bitCount) {
        section = "CRC-" + bitCount + ";XX";
        for (n = 1; n < (bitCount / 8); n++) {
            section = section + " XX";
        }
        return section;
    }

    function updCfRfFrequency() {
        return Math.floor(getPpFrequency() * 1e6);
    }

    function testGenRegulatoryDomainMask() {

        // Find the name of the regulatory domain
        var regulatoryDomain = getPhyProperty("regulatoryDomain");

        // Convert to mask
        return getRegulatoryDomainMask(regulatoryDomain);
    }

    // Exported functions
    return {
        setContext: setContext,
        getPpFrequency: getPpFrequency,
        convBleChannelToFreq: convBleChannelToFreq,
        convIeee802154ChannelToFreq: convIeee802154ChannelToFreq,
        convPaTableSettingToBinary: convPaTableSettingToBinary,
        convPaTableSettingToString: convPaTableSettingToString,
        convTxPowerLimitTableEntryToBinary: convTxPowerLimitTableEntryToBinary,
        convTxPowerLimitTableEntryToString: convTxPowerLimitTableEntryToString,
        genRegulatoryDomainConstants: genRegulatoryDomainConstants,
        getFrequencyWithOffset: getFrequencyWithOffset,
        getPpFrequencyBle: getPpFrequencyBle,
        getPpFrequency154: getPpFrequency154,
        getRegulatoryDomainMask: getRegulatoryDomainMask,
        genCrcSection: genCrcSection,
        updCfRfFrequency: updCfRfFrequency,
        testGenRegulatoryDomainMask: testGenRegulatoryDomainMask
    }
}
