/*
 * Copyright (c) 2018-2019 Arm Limited. All rights reserved
 * Copyright (c) 2019-2020, Cypress Semiconductor Corporation. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//-------- <<< Use Configuration Wizard in Context Menu >>> --------------------

#ifndef __RTE_DEVICE_H__
#define __RTE_DEVICE_H__

// <e> MPC (Memory Protection Controller) [Driver_SMPU0]
// <i> Configuration settings for Driver_SMPU0 in component ::Drivers:MPC
#define   RTE_SMPU0                                 1
// </e> MPC (Memory Protection Controller) [Driver_SMPU0]

// <e> MPC (Memory Protection Controller) [Driver_SMPU1]
// <i> Configuration settings for Driver_SMPU1 in component ::Drivers:MPC
#define   RTE_SMPU1                                 1
// </e> MPC (Memory Protection Controller) [Driver_SMPU1]

// <e> MPC (Memory Protection Controller) [Driver_SMPU2]
// <i> Configuration settings for Driver_SMPU2 in component ::Drivers:MPC
#define   RTE_SMPU2                                 1
// </e> MPC (Memory Protection Controller) [Driver_SMPU2]

// <e> MPC (Memory Protection Controller) [Driver_SMPU3]
// <i> Configuration settings for Driver_SMPU3 in component ::Drivers:MPC
#define   RTE_SMPU3                                 1
// </e> MPC (Memory Protection Controller) [Driver_SMPU3]

// <e> MPC (Memory Protection Controller) [Driver_SMPU4]
// <i> Configuration settings for Driver_SMPU4 in component ::Drivers:MPC
#define   RTE_SMPU4                                 0
// </e> MPC (Memory Protection Controller) [Driver_SMPU4]

// <e> MPC (Memory Protection Controller) [Driver_SMPU5]
// <i> Configuration settings for Driver_SMPU5 in component ::Drivers:MPC
#define   RTE_SMPU5                                 0
// </e> MPC (Memory Protection Controller) [Driver_SMPU5]

// <e> MPC (Memory Protection Controller) [Driver_SMPU6]
// <i> Configuration settings for Driver_SMPU6 in component ::Drivers:MPC
#define   RTE_SMPU6                                 1
// </e> MPC (Memory Protection Controller) [Driver_SMPU6]

// <e> MPC (Memory Protection Controller) [Driver_SMPU7]
// <i> Configuration settings for Driver_SMPU7 in component ::Drivers:MPC
#define   RTE_SMPU7                                 1
// </e> MPC (Memory Protection Controller) [Driver_SMPU7]

// <e> MPC (Memory Protection Controller) [Driver_SMPU8]
// <i> Configuration settings for Driver_SMPU8 in component ::Drivers:MPC
#define   RTE_SMPU8                                 1
// </e> MPC (Memory Protection Controller) [Driver_SMPU8]

// <e> MPC (Memory Protection Controller) [Driver_SMPU9]
// <i> Configuration settings for Driver_SMPU9 in component ::Drivers:MPC
#define   RTE_SMPU9                                 1
// </e> MPC (Memory Protection Controller) [Driver_SMPU9]

// <e> MPC (Memory Protection Controller) [Driver_SMPU10]
// <i> Configuration settings for Driver_SMPU10 in component ::Drivers:MPC
#define   RTE_SMPU10                                0
// </e> MPC (Memory Protection Controller) [Driver_SMPU10]

// <e> MPC (Memory Protection Controller) [Driver_SMPU11]
// <i> Configuration settings for Driver_SMPU11 in component ::Drivers:MPC
#define   RTE_SMPU11                                0
// </e> MPC (Memory Protection Controller) [Driver_SMPU11]

// <e> MPC (Memory Protection Controller) [Driver_SMPU12]
// <i> Configuration settings for Driver_SMPU12 in component ::Drivers:MPC
#define   RTE_SMPU12                                0
// </e> MPC (Memory Protection Controller) [Driver_SMPU12]

// <e> MPC (Memory Protection Controller) [Driver_SMPU13]
// <i> Configuration settings for Driver_SMPU13 in component ::Drivers:MPC
#define   RTE_SMPU13                                0
// </e> MPC (Memory Protection Controller) [Driver_SMPU13]

/* SMPUs 14 and 15 are used by flashboot */

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART0]
// <i> Configuration settings for Driver_USART0 in component ::Drivers:USART
#define   RTE_USART0                                0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART0]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART1]
// <i> Configuration settings for Driver_USART1 in component ::Drivers:USART
#define   RTE_USART1                                0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART1]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART2]
// <i> Configuration settings for Driver_USART2 in component ::Drivers:USART
#define   RTE_USART2                                0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART2]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART3]
// <i> Configuration settings for Driver_USART3 in component ::Drivers:USART
#define   RTE_USART3                                0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART3]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART4]
// <i> Configuration settings for Driver_USART4 in component ::Drivers:USART
#define   RTE_USART4                                0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART4]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART5]
// <i> Configuration settings for Driver_USART5 in component ::Drivers:USART
#define   RTE_USART5                                1
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART5]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART6]
// <i> Configuration settings for Driver_USART6 in component ::Drivers:USART
#define   RTE_USART6                                0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART6]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART7]
// <i> Configuration settings for Driver_USART7 in component ::Drivers:USART
#define   RTE_USART7                                0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART7]

// <e> PPC (Peripheral Protection Controller) [Driver_MS_PPU_PR7]
// <i> Configuration settings for Driver_MS_PPU_PR7 in component ::Drivers:PPC
#define   RTE_MS_PPU_PR7                            0
// </e> PPC (Peripheral Protection Controller) [Driver_MS_PPU_PR7]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_MAIN]
// <i> Configuration settings for Driver_PPU_PERI_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_PERI_MAIN                      0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR0_GROUP]
// <i> Configuration settings for Driver_PPU_PERI_GR0_GROUP in component ::Drivers:PPC
#define   RTE_MS_PPU_PERI_GR0_GROUP                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR0_GROUP]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR1_GROUP]
// <i> Configuration settings for Driver_PPU_PERI_GR1_GROUP in component ::Drivers:PPC
#define   RTE_MS_PPU_PERI_GR1_GROUP                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR1_GROUP]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR2_GROUP]
// <i> Configuration settings for Driver_PPU_PERI_GR2_GROUP in component ::Drivers:PPC
#define   RTE_MS_PPU_PERI_GR2_GROUP                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR2_GROUP]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR3_GROUP]
// <i> Configuration settings for Driver_PPU_PERI_GR3_GROUP in component ::Drivers:PPC
#define   RTE_MS_PPU_PERI_GR3_GROUP                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR3_GROUP]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR4_GROUP]
// <i> Configuration settings for Driver_PPU_PERI_GR4_GROUP in component ::Drivers:PPC
#define   RTE_MS_PPU_PERI_GR4_GROUP                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR4_GROUP]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR6_GROUP]
// <i> Configuration settings for Driver_PPU_PERI_GR6_GROUP in component ::Drivers:PPC
#define   RTE_MS_PPU_PERI_GR6_GROUP                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR6_GROUP]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR9_GROUP]
// <i> Configuration settings for Driver_PPU_PERI_GR9_GROUP in component ::Drivers:PPC
#define   RTE_MS_PPU_PERI_GR9_GROUP                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR9_GROUP]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR10_GROUP]
// <i> Configuration settings for Driver_PPU_PERI_GR10_GROUP in component ::Drivers:PPC
#define   RTE_MS_PPU_PERI_GR10_GROUP                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_GR10_GROUP]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_TR]
// <i> Configuration settings for Driver_PPU_PERI_TR in component ::Drivers:PPC
#define   RTE_MS_PPU_PERI_TR                        0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PERI_TR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_MAIN]
// <i> Configuration settings for Driver_PPU_CRYPTO_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_CRYPTO_MAIN                    1
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_CRYPTO]
// <i> Configuration settings for Driver_PPU_CRYPTO_CRYPTO in component ::Drivers:PPC
#define   RTE_MS_PPU_CRYPTO_CRYPTO                  1
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_CRYPTO]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_BOOT]
// <i> Configuration settings for Driver_PPU_CRYPTO_BOOT in component ::Drivers:PPC
#define   RTE_MS_PPU_CRYPTO_BOOT                    0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_BOOT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_KEY0]
// <i> Configuration settings for Driver_PPU_CRYPTO_KEY0 in component ::Drivers:PPC
#define   RTE_MS_PPU_CRYPTO_KEY0                    0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_KEY0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_KEY1]
// <i> Configuration settings for Driver_PPU_CRYPTO_KEY1 in component ::Drivers:PPC
#define   RTE_MS_PPU_CRYPTO_KEY1                    0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_KEY1]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_BUF]
// <i> Configuration settings for Driver_PPU_CRYPTO_BUF in component ::Drivers:PPC
#define   RTE_MS_PPU_CRYPTO_BUF                     1
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CRYPTO_BUF]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CPUSS_CM4]
// <i> Configuration settings for Driver_PPU_CPUSS_CM4 in component ::Drivers:PPC
#define   RTE_MS_PPU_CPUSS_CM4                      0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CPUSS_CM4]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CPUSS_CM0]
// <i> Configuration settings for Driver_PPU_CPUSS_CM0 in component ::Drivers:PPC
#define   RTE_MS_PPU_CPUSS_CM0                      0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CPUSS_CM0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CPUSS_BOOT]
// <i> Configuration settings for Driver_PPU_CPUSS_BOOT in component ::Drivers:PPC
#define   RTE_MS_PPU_CPUSS_BOOT                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CPUSS_BOOT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CPUSS_CM0_INT]
// <i> Configuration settings for Driver_PPU_CPUSS_CM0_INT in component ::Drivers:PPC
#define   RTE_MS_PPU_CPUSS_CM0_INT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CPUSS_CM0_INT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CPUSS_CM4_INT]
// <i> Configuration settings for Driver_PPU_CPUSS_CM4_INT in component ::Drivers:PPC
#define   RTE_MS_PPU_CPUSS_CM4_INT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CPUSS_CM4_INT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FAULT_STRUCT0_MAIN]
// <i> Configuration settings for Driver_PPU_FAULT_STRUCT0_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_FAULT_STRUCT0_MAIN             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FAULT_STRUCT0_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FAULT_STRUCT1_MAIN]
// <i> Configuration settings for Driver_PPU_FAULT_STRUCT1_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_FAULT_STRUCT1_MAIN             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FAULT_STRUCT1_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT0_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT0_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT0_IPC                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT0_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT1_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT1_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT1_IPC                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT1_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT2_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT2_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT2_IPC                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT2_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT3_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT3_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT3_IPC                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT3_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT4_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT4_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT4_IPC                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT4_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT5_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT5_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT5_IPC                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT5_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT6_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT6_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT6_IPC                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT6_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT7_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT7_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT7_IPC                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT7_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT8_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT8_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT8_IPC                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT8_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT9_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT9_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT9_IPC                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT9_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT10_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT10_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT10_IPC               0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT10_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT11_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT11_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT11_IPC               0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT11_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT12_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT12_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT12_IPC               0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT12_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT13_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT13_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT13_IPC               0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT13_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT14_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT14_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT14_IPC               0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT14_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT15_IPC]
// <i> Configuration settings for Driver_PPU_IPC_STRUCT15_IPC in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_STRUCT15_IPC               0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_STRUCT15_IPC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT0_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT0_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT0_INTR          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT0_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT1_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT1_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT1_INTR          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT1_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT2_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT2_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT2_INTR          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT2_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT3_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT3_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT3_INTR          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT3_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT4_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT4_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT4_INTR          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT4_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT5_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT5_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT5_INTR          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT5_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT6_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT6_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT6_INTR          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT6_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT7_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT7_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT7_INTR          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT7_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT8_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT8_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT8_INTR          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT8_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT9_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT9_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT9_INTR          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT9_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT10_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT10_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT10_INTR         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT10_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT11_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT11_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT11_INTR         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT11_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT12_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT12_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT12_INTR         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT12_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT13_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT13_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT13_INTR         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT13_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT14_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT14_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT14_INTR         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT14_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT15_INTR]
// <i> Configuration settings for Driver_PPU_IPC_INTR_STRUCT15_INTR in component ::Drivers:PPC
#define   RTE_MS_PPU_IPC_INTR_STRUCT15_INTR         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_IPC_INTR_STRUCT15_INTR]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_SMPU_MAIN]
// <i> Configuration settings for Driver_PPU_PROT_SMPU_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_PROT_SMPU_MAIN                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_SMPU_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_MPU0_MAIN]
// <i> Configuration settings for Driver_PPU_PROT_MPU0_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_PROT_MPU0_MAIN                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_MPU0_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_MPU5_MAIN]
// <i> Configuration settings for Driver_PPU_PROT_MPU5_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_PROT_MPU5_MAIN                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_MPU5_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_MPU6_MAIN]
// <i> Configuration settings for Driver_PPU_PROT_MPU6_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_PROT_MPU6_MAIN                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_MPU6_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_MPU14_MAIN]
// <i> Configuration settings for Driver_PPU_PROT_MPU14_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_PROT_MPU14_MAIN                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_MPU14_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_MPU15_MAIN]
// <i> Configuration settings for Driver_PPU_PROT_MPU15_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_PROT_MPU15_MAIN                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PROT_MPU15_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_MAIN]
// <i> Configuration settings for Driver_PPU_FLASHC_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_MAIN                    0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_CMD]
// <i> Configuration settings for Driver_PPU_FLASHC_CMD in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_CMD                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_CMD]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_DFT]
// <i> Configuration settings for Driver_PPU_FLASHC_DFT in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_DFT                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_DFT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_CM0]
// <i> Configuration settings for Driver_PPU_FLASHC_CM0 in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_CM0                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_CM0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_CM4]
// <i> Configuration settings for Driver_PPU_FLASHC_CM4 in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_CM4                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_CM4]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_CRYPTO]
// <i> Configuration settings for Driver_PPU_FLASHC_CRYPTO in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_CRYPTO                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_CRYPTO]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_DW0]
// <i> Configuration settings for Driver_PPU_FLASHC_DW0 in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_DW0                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_DW0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_DW1]
// <i> Configuration settings for Driver_PPU_FLASHC_DW1 in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_DW1                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_DW1]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_DMAC]
// <i> Configuration settings for Driver_PPU_FLASHC_DMAC in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_DMAC                    0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_DMAC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_EXT_MS0]
// <i> Configuration settings for Driver_PPU_FLASHC_EXT_MS0 in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_EXT_MS0                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_EXT_MS0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_EXT_MS1]
// <i> Configuration settings for Driver_PPU_FLASHC_EXT_MS1 in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_EXT_MS1                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_EXT_MS1]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_FM]
// <i> Configuration settings for Driver_PPU_FLASHC_FM in component ::Drivers:PPC
#define   RTE_MS_PPU_FLASHC_FM                      0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_FLASHC_FM]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN1]
// <i> Configuration settings for Driver_PPU_SRSS_MAIN1 in component ::Drivers:PPC
#define   RTE_MS_PPU_SRSS_MAIN1                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN1]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN2]
// <i> Configuration settings for Driver_PPU_SRSS_MAIN2 in component ::Drivers:PPC
#define   RTE_MS_PPU_SRSS_MAIN2                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN2]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_WDT]
// <i> Configuration settings for Driver_PPU_WDT in component ::Drivers:PPC
#define   RTE_MS_PPU_WDT                            0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_WDT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_MAIN]
// <i> Configuration settings for Driver_PPU_MAIN in component ::Drivers:PPC
#define   RTE_MS_PPU_MAIN                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_MAIN]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN3]
// <i> Configuration settings for Driver_PPU_SRSS_MAIN3 in component ::Drivers:PPC
#define   RTE_MS_PPU_SRSS_MAIN3                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN3]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN4]
// <i> Configuration settings for Driver_PPU_SRSS_MAIN4 in component ::Drivers:PPC
#define   RTE_MS_PPU_SRSS_MAIN4                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN4]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN5]
// <i> Configuration settings for Driver_PPU_SRSS_MAIN5 in component ::Drivers:PPC
#define   RTE_MS_PPU_SRSS_MAIN5                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN5]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN6]
// <i> Configuration settings for Driver_PPU_SRSS_MAIN6 in component ::Drivers:PPC
#define   RTE_MS_PPU_SRSS_MAIN6                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN6]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN7]
// <i> Configuration settings for Driver_PPU_SRSS_MAIN7 in component ::Drivers:PPC
#define   RTE_MS_PPU_SRSS_MAIN7                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SRSS_MAIN7]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_BACKUP_BACKUP]
// <i> Configuration settings for Driver_PPU_BACKUP_BACKUP in component ::Drivers:PPC
#define   RTE_MS_PPU_BACKUP_BACKUP                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_BACKUP_BACKUP]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_DW]
// <i> Configuration settings for Driver_PPU_DW0_DW in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_DW                         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_DW]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_DW]
// <i> Configuration settings for Driver_PPU_DW1_DW in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_DW                         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_DW]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_DW_CRC]
// <i> Configuration settings for Driver_PPU_DW0_DW_CRC in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_DW_CRC                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_DW_CRC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_DW_CRC]
// <i> Configuration settings for Driver_PPU_DW1_DW_CRC in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_DW_CRC                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_DW_CRC]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT0_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT0_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT0_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT0_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT1_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT1_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT1_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT1_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT2_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT2_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT2_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT2_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT3_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT3_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT3_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT3_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT4_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT4_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT4_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT4_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT5_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT5_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT5_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT5_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT6_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT6_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT6_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT6_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT7_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT7_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT7_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT7_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT8_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT8_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT8_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT8_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT9_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT9_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT9_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT9_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT10_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT10_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT10_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT10_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT11_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT11_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT11_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT11_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT12_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT12_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT12_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT12_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT13_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT13_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT13_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT13_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT14_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT14_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT14_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT14_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT15_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT15_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT15_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT15_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT16_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT16_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT16_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT16_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT17_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT17_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT17_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT17_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT18_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT18_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT18_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT18_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT19_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT19_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT19_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT19_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT20_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT20_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT20_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT20_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT21_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT21_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT21_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT21_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT22_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT22_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT22_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT22_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT23_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT23_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT23_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT23_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT24_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT24_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT24_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT24_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT25_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT25_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT25_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT25_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT26_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT26_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT26_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT26_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT27_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT27_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT27_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT27_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT28_CH]
// <i> Configuration settings for Driver_PPU_DW0_CH_STRUCT28_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW0_CH_STRUCT28_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW0_CH_STRUCT28_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT0_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT0_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT0_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT0_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT1_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT1_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT1_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT1_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT2_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT2_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT2_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT2_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT3_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT3_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT3_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT3_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT4_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT4_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT4_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT4_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT5_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT5_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT5_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT5_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT6_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT6_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT6_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT6_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT7_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT7_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT7_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT7_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT8_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT8_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT8_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT8_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT9_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT9_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT9_CH              0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT9_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT10_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT10_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT10_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT10_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT11_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT11_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT11_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT11_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT12_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT12_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT12_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT12_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT13_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT13_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT13_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT13_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT14_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT14_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT14_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT14_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT15_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT15_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT15_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT15_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT16_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT16_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT16_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT16_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT17_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT17_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT17_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT17_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT18_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT18_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT18_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT18_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT19_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT19_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT19_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT19_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT20_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT20_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT20_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT20_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT21_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT21_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT21_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT21_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT22_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT22_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT22_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT22_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT23_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT23_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT23_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT23_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT24_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT24_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT24_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT24_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT25_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT25_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT25_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT25_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT26_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT26_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT26_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT26_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT27_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT27_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT27_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT27_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT28_CH]
// <i> Configuration settings for Driver_PPU_DW1_CH_STRUCT28_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DW1_CH_STRUCT28_CH             0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DW1_CH_STRUCT28_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DMAC_TOP]
// <i> Configuration settings for Driver_PPU_DMAC_TOP in component ::Drivers:PPC
#define   RTE_MS_PPU_DMAC_TOP                       0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DMAC_TOP]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DMAC_CH0_CH]
// <i> Configuration settings for Driver_PPU_DMAC_CH0_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DMAC_CH0_CH                    0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DMAC_CH0_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DMAC_CH1_CH]
// <i> Configuration settings for Driver_PPU_DMAC_CH1_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DMAC_CH1_CH                    0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DMAC_CH1_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DMAC_CH2_CH]
// <i> Configuration settings for Driver_PPU_DMAC_CH2_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DMAC_CH2_CH                    0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DMAC_CH2_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_DMAC_CH3_CH]
// <i> Configuration settings for Driver_PPU_DMAC_CH3_CH in component ::Drivers:PPC
#define   RTE_MS_PPU_DMAC_CH3_CH                    0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_DMAC_CH3_CH]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_EFUSE_CTL]
// <i> Configuration settings for Driver_PPU_EFUSE_CTL in component ::Drivers:PPC
#define   RTE_MS_PPU_EFUSE_CTL                      0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_EFUSE_CTL]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_EFUSE_DATA]
// <i> Configuration settings for Driver_PPU_EFUSE_DATA in component ::Drivers:PPC
#define   RTE_MS_PPU_EFUSE_DATA                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_EFUSE_DATA]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PROFILE]
// <i> Configuration settings for Driver_PPU_PROFILE in component ::Drivers:PPC
#define   RTE_MS_PPU_PROFILE                        0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PROFILE]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT0_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT0_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT0_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT0_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT1_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT1_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT1_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT1_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT2_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT2_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT2_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT2_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT3_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT3_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT3_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT3_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT4_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT4_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT4_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT4_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT5_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT5_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT5_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT5_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT6_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT6_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT6_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT6_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT7_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT7_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT7_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT7_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT8_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT8_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT8_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT8_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT9_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT9_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT9_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT9_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT10_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT10_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT10_PRT                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT10_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT11_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT11_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT11_PRT                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT11_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT12_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT12_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT12_PRT                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT12_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT13_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT13_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT13_PRT                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT13_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT14_PRT]
// <i> Configuration settings for Driver_PPU_HSIOM_PRT14_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_PRT14_PRT                0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_PRT14_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_AMUX]
// <i> Configuration settings for Driver_PPU_HSIOM_AMUX in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_AMUX                     0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_AMUX]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_MON]
// <i> Configuration settings for Driver_PPU_HSIOM_MON in component ::Drivers:PPC
#define   RTE_MS_PPU_HSIOM_MON                      0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_HSIOM_MON]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT0_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT0_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT0_PRT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT0_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT1_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT1_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT1_PRT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT1_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT2_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT2_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT2_PRT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT2_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT3_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT3_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT3_PRT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT3_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT4_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT4_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT4_PRT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT4_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT5_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT5_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT5_PRT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT5_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT6_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT6_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT6_PRT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT6_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT7_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT7_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT7_PRT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT7_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT8_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT8_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT8_PRT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT8_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT9_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT9_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT9_PRT                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT9_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT10_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT10_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT10_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT10_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT11_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT11_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT11_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT11_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT12_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT12_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT12_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT12_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT13_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT13_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT13_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT13_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT14_PRT]
// <i> Configuration settings for Driver_PPU_GPIO_PRT14_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT14_PRT                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT14_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT0_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT0_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT0_CFG                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT0_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT1_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT1_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT1_CFG                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT1_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT2_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT2_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT2_CFG                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT2_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT3_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT3_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT3_CFG                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT3_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT4_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT4_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT4_CFG                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT4_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT5_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT5_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT5_CFG                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT5_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT6_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT6_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT6_CFG                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT6_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT7_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT7_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT7_CFG                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT7_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT8_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT8_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT8_CFG                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT8_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT9_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT9_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT9_CFG                  0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT9_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT10_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT10_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT10_CFG                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT10_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT11_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT11_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT11_CFG                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT11_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT12_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT12_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT12_CFG                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT12_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT13_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT13_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT13_CFG                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT13_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT14_CFG]
// <i> Configuration settings for Driver_PPU_GPIO_PRT14_CFG in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_PRT14_CFG                 0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_PRT14_CFG]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_GPIO]
// <i> Configuration settings for Driver_PPU_GPIO_GPIO in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_GPIO                      0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_GPIO]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_TEST]
// <i> Configuration settings for Driver_PPU_GPIO_TEST in component ::Drivers:PPC
#define   RTE_MS_PPU_GPIO_TEST                      0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_GPIO_TEST]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SMARTIO_PRT8_PRT]
// <i> Configuration settings for Driver_PPU_SMARTIO_PRT8_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_SMARTIO_PRT8_PRT               0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SMARTIO_PRT8_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SMARTIO_PRT9_PRT]
// <i> Configuration settings for Driver_PPU_SMARTIO_PRT9_PRT in component ::Drivers:PPC
#define   RTE_MS_PPU_SMARTIO_PRT9_PRT               0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SMARTIO_PRT9_PRT]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_LPCOMP]
// <i> Configuration settings for Driver_PPU_LPCOMP in component ::Drivers:PPC
#define   RTE_MS_PPU_LPCOMP                         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_LPCOMP]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_CSD0]
// <i> Configuration settings for Driver_PPU_CSD0 in component ::Drivers:PPC
#define   RTE_MS_PPU_CSD0                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_CSD0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_TCPWM0]
// <i> Configuration settings for Driver_PPU_TCPWM0 in component ::Drivers:PPC
#define   RTE_MS_PPU_TCPWM0                         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_TCPWM0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_TCPWM1]
// <i> Configuration settings for Driver_PPU_TCPWM1 in component ::Drivers:PPC
#define   RTE_MS_PPU_TCPWM1                         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_TCPWM1]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_LCD0]
// <i> Configuration settings for Driver_PPU_LCD0 in component ::Drivers:PPC
#define   RTE_MS_PPU_LCD0                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_LCD0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_USBFS0]
// <i> Configuration settings for Driver_PPU_USBFS0 in component ::Drivers:PPC
#define   RTE_MS_PPU_USBFS0                         0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_USBFS0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SMIF0]
// <i> Configuration settings for Driver_PPU_SMIF0 in component ::Drivers:PPC
#define   RTE_MS_PPU_SMIF0                          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SMIF0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SDHC0]
// <i> Configuration settings for Driver_PPU_SDHC0 in component ::Drivers:PPC
#define   RTE_MS_PPU_SDHC0                          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SDHC0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SDHC1]
// <i> Configuration settings for Driver_PPU_SDHC1 in component ::Drivers:PPC
#define   RTE_MS_PPU_SDHC1                          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SDHC1]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB0]
// <i> Configuration settings for Driver_PPU_SCB0 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB0                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB1]
// <i> Configuration settings for Driver_PPU_SCB1 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB1                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB1]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB2]
// <i> Configuration settings for Driver_PPU_SCB2 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB2                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB2]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB3]
// <i> Configuration settings for Driver_PPU_SCB3 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB3                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB3]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB4]
// <i> Configuration settings for Driver_PPU_SCB4 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB4                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB4]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB5]
// <i> Configuration settings for Driver_PPU_SCB5 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB5                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB5]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB6]
// <i> Configuration settings for Driver_PPU_SCB6 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB6                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB6]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB7]
// <i> Configuration settings for Driver_PPU_SCB7 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB7                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB7]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB8]
// <i> Configuration settings for Driver_PPU_SCB8 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB8                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB8]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB9]
// <i> Configuration settings for Driver_PPU_SCB9 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB9                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB9]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB10]
// <i> Configuration settings for Driver_PPU_SCB10 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB10                          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB10]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB11]
// <i> Configuration settings for Driver_PPU_SCB11 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB11                          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB11]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB12]
// <i> Configuration settings for Driver_PPU_SCB12 in component ::Drivers:PPC
#define   RTE_MS_PPU_SCB12                          0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_SCB12]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_PDM0]
// <i> Configuration settings for Driver_PPU_PDM0 in component ::Drivers:PPC
#define   RTE_MS_PPU_PDM0                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_PDM0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_I2S0]
// <i> Configuration settings for Driver_PPU_I2S0 in component ::Drivers:PPC
#define   RTE_MS_PPU_I2S0                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_I2S0]

// <e> PPC (Peripheral Protection Controller) [Driver_PPU_I2S1]
// <i> Configuration settings for Driver_PPU_I2S1 in component ::Drivers:PPC
#define   RTE_MS_PPU_I2S1                           0
// </e> PPC (Peripheral Protection Controller) [Driver_PPU_I2S1]

// <e> FLASH (Flash Memory) [Driver_FLASH0]
// <i> Configuration settings for Driver_FLASH0 in component ::Drivers:FLASH
#define   RTE_FLASH0                                1
// </e> FLASH (Flash Memory) [Driver_FLASH0]

#endif  /* __RTE_DEVICE_H__ */
