/* testvectors_milenage_data.h
 *
 * Description: Milenage conformance vectors data take from
 *              3GPP TS35.208 V13.0.0 (2016-01)
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

#ifndef INCLUDE_GUARD_TESTVECTORS_MILENAGE_DATA_H
#define INCLUDE_GUARD_TESTVECTORS_MILENAGE_DATA_H

#include <third_party/hsmddk/include/Kit/DriverFramework/Basic_Defs_API/incl/basic_defs.h>

/* Test Set1 */
static const uint8_t Milenage_TS1_K[] = {
    0x46, 0x5B, 0x5C, 0xE8, 0xB1, 0x99, 0xB4, 0x9F, 0xAA, 0x5F, 0x0A, 0x2E, 0xE2, 0x38, 0xA6, 0xBC
};
static const uint8_t Milenage_TS1_RAND[] = {
    0x23, 0x55, 0x3C, 0xBE, 0x96, 0x37, 0xA8, 0x9D, 0x21, 0x8A, 0xE6, 0x4D, 0xAE, 0x47, 0xBF, 0x35
};
static const uint8_t Milenage_TS1_SQN[] = {
    0xFF, 0x9B, 0xB4, 0xD0, 0xB6, 0x07
};
static const uint8_t Milenage_TS1_AMF[] = {
    0xB9, 0xB9
};
static const uint8_t Milenage_TS1_OP[] = {
    0xCD, 0xC2, 0x02, 0xD5, 0x12, 0x3E, 0x20, 0xF6, 0x2B, 0x6D, 0x67, 0x6A, 0xC7, 0x2C, 0xB3, 0x18
};
static const uint8_t Milenage_TS1_OPc[] = {
    0xCD, 0x63, 0xCB, 0x71, 0x95, 0x4A, 0x9F, 0x4E, 0x48, 0xA5, 0x99, 0x4E, 0x37, 0xA0, 0x2B, 0xAF
};
static const uint8_t Milenage_TS1_f1[] = {
    0x4A, 0x9F, 0xFA, 0xC3, 0x54, 0xDF, 0xAF, 0xB3
};
static const uint8_t Milenage_TS1_f1star[] = {
    0x01, 0xCF, 0xAF, 0x9E, 0xC4, 0xE8, 0x71, 0xE9
};
static const uint8_t Milenage_TS1_f2[] = {
    0xA5, 0x42, 0x11, 0xD5, 0xE3, 0xBA, 0x50, 0xBF
};
static const uint8_t Milenage_TS1_f3[] = {
    0xB4, 0x0B, 0xA9, 0xA3, 0xC5, 0x8B, 0x2A, 0x05, 0xBB, 0xF0, 0xD9, 0x87, 0xB2, 0x1B, 0xF8, 0xCB
};
static const uint8_t Milenage_TS1_f4[] = {
    0xF7, 0x69, 0xBC, 0xD7, 0x51, 0x04, 0x46, 0x04, 0x12, 0x76, 0x72, 0x71, 0x1C, 0x6D, 0x34, 0x41
};
static const uint8_t Milenage_TS1_f5[] = {
    0xAA, 0x68, 0x9C, 0x64, 0x83, 0x70
};
static const uint8_t Milenage_TS1_f5star[] = {
    0x45, 0x1E, 0x8B, 0xEC, 0xA4, 0x3B
};
/* Test Set2 */
static const uint8_t Milenage_TS2_K[] = {
    0x46, 0x5B, 0x5C, 0xE8, 0xB1, 0x99, 0xB4, 0x9F, 0xAA, 0x5F, 0x0A, 0x2E, 0xE2, 0x38, 0xA6, 0xBC
};
static const uint8_t Milenage_TS2_RAND[] = {
    0x23, 0x55, 0x3C, 0xBE, 0x96, 0x37, 0xA8, 0x9D, 0x21, 0x8A, 0xE6, 0x4D, 0xAE, 0x47, 0xBF, 0x35
};
static const uint8_t Milenage_TS2_SQN[] = {
    0xFF, 0x9B, 0xB4, 0xD0, 0xB6, 0x07
};
static const uint8_t Milenage_TS2_AMF[] = {
    0xB9, 0xB9
};
static const uint8_t Milenage_TS2_OP[] = {
    0xCD, 0xC2, 0x02, 0xD5, 0x12, 0x3E, 0x20, 0xF6, 0x2B, 0x6D, 0x67, 0x6A, 0xC7, 0x2C, 0xB3, 0x18
};
static const uint8_t Milenage_TS2_OPc[] = {
    0xCD, 0x63, 0xCB, 0x71, 0x95, 0x4A, 0x9F, 0x4E, 0x48, 0xA5, 0x99, 0x4E, 0x37, 0xA0, 0x2B, 0xAF
};
static const uint8_t Milenage_TS2_f1[] = {
    0x4A, 0x9F, 0xFA, 0xC3, 0x54, 0xDF, 0xAF, 0xB3
};
static const uint8_t Milenage_TS2_f1star[] = {
    0x01, 0xCF, 0xAF, 0x9E, 0xC4, 0xE8, 0x71, 0xE9
};
static const uint8_t Milenage_TS2_f2[] = {
    0xA5, 0x42, 0x11, 0xD5, 0xE3, 0xBA, 0x50, 0xBF
};
static const uint8_t Milenage_TS2_f3[] = {
    0xB4, 0x0B, 0xA9, 0xA3, 0xC5, 0x8B, 0x2A, 0x05, 0xBB, 0xF0, 0xD9, 0x87, 0xB2, 0x1B, 0xF8, 0xCB
};
static const uint8_t Milenage_TS2_f4[] = {
    0xF7, 0x69, 0xBC, 0xD7, 0x51, 0x04, 0x46, 0x04, 0x12, 0x76, 0x72, 0x71, 0x1C, 0x6D, 0x34, 0x41
};
static const uint8_t Milenage_TS2_f5[] = {
    0xAA, 0x68, 0x9C, 0x64, 0x83, 0x70
};
static const uint8_t Milenage_TS2_f5star[] = {
    0x45, 0x1E, 0x8B, 0xEC, 0xA4, 0x3B
};
/* Test Set3 */
static const uint8_t Milenage_TS3_K[] = {
    0xFE, 0xC8, 0x6B, 0xA6, 0xEB, 0x70, 0x7E, 0xD0, 0x89, 0x05, 0x75, 0x7B, 0x1B, 0xB4, 0x4B, 0x8F
};
static const uint8_t Milenage_TS3_RAND[] = {
    0x9F, 0x7C, 0x8D, 0x02, 0x1A, 0xCC, 0xF4, 0xDB, 0x21, 0x3C, 0xCF, 0xF0, 0xC7, 0xF7, 0x1A, 0x6A
};
static const uint8_t Milenage_TS3_SQN[] = {
    0x9D, 0x02, 0x77, 0x59, 0x5F, 0xFC
};
static const uint8_t Milenage_TS3_AMF[] = {
    0x72, 0x5C
};
static const uint8_t Milenage_TS3_OP[] = {
    0xDB, 0xC5, 0x9A, 0xDC, 0xB6, 0xF9, 0xA0, 0xEF, 0x73, 0x54, 0x77, 0xB7, 0xFA, 0xDF, 0x83, 0x74
};
static const uint8_t Milenage_TS3_OPc[] = {
    0x10, 0x06, 0x02, 0x0F, 0x0A, 0x47, 0x8B, 0xF6, 0xB6, 0x99, 0xF1, 0x5C, 0x06, 0x2E, 0x42, 0xB3
};
static const uint8_t Milenage_TS3_f1[] = {
    0x9C, 0xAB, 0xC3, 0xE9, 0x9B, 0xAF, 0x72, 0x81
};
static const uint8_t Milenage_TS3_f1star[] = {
    0x95, 0x81, 0x4B, 0xA2, 0xB3, 0x04, 0x43, 0x24
};
static const uint8_t Milenage_TS3_f2[] = {
    0x80, 0x11, 0xC4, 0x8C, 0x0C, 0x21, 0x4E, 0xD2
};
static const uint8_t Milenage_TS3_f3[] = {
    0x5D, 0xBD, 0xBB, 0x29, 0x54, 0xE8, 0xF3, 0xCD, 0xE6, 0x65, 0xB0, 0x46, 0x17, 0x9A, 0x50, 0x98
};
static const uint8_t Milenage_TS3_f4[] = {
    0x59, 0xA9, 0x2D, 0x3B, 0x47, 0x6A, 0x04, 0x43, 0x48, 0x70, 0x55, 0xCF, 0x88, 0xB2, 0x30, 0x7B
};
static const uint8_t Milenage_TS3_f5[] = {
    0x33, 0x48, 0x4D, 0xC2, 0x13, 0x6B
};
static const uint8_t Milenage_TS3_f5star[] = {
    0xDE, 0xAC, 0xDD, 0x84, 0x8C, 0xC6
};
/* Test Set4 */
static const uint8_t Milenage_TS4_K[] = {
    0x9E, 0x59, 0x44, 0xAE, 0xA9, 0x4B, 0x81, 0x16, 0x5C, 0x82, 0xFB, 0xF9, 0xF3, 0x2D, 0xB7, 0x51
};
static const uint8_t Milenage_TS4_RAND[] = {
    0xCE, 0x83, 0xDB, 0xC5, 0x4A, 0xC0, 0x27, 0x4A, 0x15, 0x7C, 0x17, 0xF8, 0x0D, 0x01, 0x7B, 0xD6
};
static const uint8_t Milenage_TS4_SQN[] = {
    0x0B, 0x60, 0x4A, 0x81, 0xEC, 0xA8
};
static const uint8_t Milenage_TS4_AMF[] = {
    0x9E, 0x09
};
static const uint8_t Milenage_TS4_OP[] = {
    0x22, 0x30, 0x14, 0xC5, 0x80, 0x66, 0x94, 0xC0, 0x07, 0xCA, 0x1E, 0xEE, 0xF5, 0x7F, 0x00, 0x4F
};
static const uint8_t Milenage_TS4_OPc[] = {
    0xA6, 0x4A, 0x50, 0x7A, 0xE1, 0xA2, 0xA9, 0x8B, 0xB8, 0x8E, 0xB4, 0x21, 0x01, 0x35, 0xDC, 0x87
};
static const uint8_t Milenage_TS4_f1[] = {
    0x74, 0xA5, 0x82, 0x20, 0xCB, 0xA8, 0x4C, 0x49
};
static const uint8_t Milenage_TS4_f1star[] = {
    0xAC, 0x2C, 0xC7, 0x4A, 0x96, 0x87, 0x18, 0x37
};
static const uint8_t Milenage_TS4_f2[] = {
    0xF3, 0x65, 0xCD, 0x68, 0x3C, 0xD9, 0x2E, 0x96
};
static const uint8_t Milenage_TS4_f3[] = {
    0xE2, 0x03, 0xED, 0xB3, 0x97, 0x15, 0x74, 0xF5, 0xA9, 0x4B, 0x0D, 0x61, 0xB8, 0x16, 0x34, 0x5D
};
static const uint8_t Milenage_TS4_f4[] = {
    0x0C, 0x45, 0x24, 0xAD, 0xEA, 0xC0, 0x41, 0xC4, 0xDD, 0x83, 0x0D, 0x20, 0x85, 0x4F, 0xC4, 0x6B
};
static const uint8_t Milenage_TS4_f5[] = {
    0xF0, 0xB9, 0xC0, 0x8A, 0xD0, 0x2E
};
static const uint8_t Milenage_TS4_f5star[] = {
    0x60, 0x85, 0xA8, 0x6C, 0x6F, 0x63
};
/* Test Set5 */
static const uint8_t Milenage_TS5_K[] = {
    0x4A, 0xB1, 0xDE, 0xB0, 0x5C, 0xA6, 0xCE, 0xB0, 0x51, 0xFC, 0x98, 0xE7, 0x7D, 0x02, 0x6A, 0x84
};
static const uint8_t Milenage_TS5_RAND[] = {
    0x74, 0xB0, 0xCD, 0x60, 0x31, 0xA1, 0xC8, 0x33, 0x9B, 0x2B, 0x6C, 0xE2, 0xB8, 0xC4, 0xA1, 0x86
};
static const uint8_t Milenage_TS5_SQN[] = {
    0xE8, 0x80, 0xA1, 0xB5, 0x80, 0xB6
};
static const uint8_t Milenage_TS5_AMF[] = {
    0x9F, 0x07
};
static const uint8_t Milenage_TS5_OP[] = {
    0x2D, 0x16, 0xC5, 0xCD, 0x1F, 0xDF, 0x6B, 0x22, 0x38, 0x35, 0x84, 0xE3, 0xBE, 0xF2, 0xA8, 0xD8
};
static const uint8_t Milenage_TS5_OPc[] = {
    0xDC, 0xF0, 0x7C, 0xBD, 0x51, 0x85, 0x52, 0x90, 0xB9, 0x2A, 0x07, 0xA9, 0x89, 0x1E, 0x52, 0x3E
};
static const uint8_t Milenage_TS5_f1[] = {
    0x49, 0xE7, 0x85, 0xDD, 0x12, 0x62, 0x6E, 0xF2
};
static const uint8_t Milenage_TS5_f1star[] = {
    0x9E, 0x85, 0x79, 0x03, 0x36, 0xBB, 0x3F, 0xA2
};
static const uint8_t Milenage_TS5_f2[] = {
    0x58, 0x60, 0xFC, 0x1B, 0xCE, 0x35, 0x1E, 0x7E
};
static const uint8_t Milenage_TS5_f3[] = {
    0x76, 0x57, 0x76, 0x6B, 0x37, 0x3D, 0x1C, 0x21, 0x38, 0xF3, 0x07, 0xE3, 0xDE, 0x92, 0x42, 0xF9
};
static const uint8_t Milenage_TS5_f4[] = {
    0x1C, 0x42, 0xE9, 0x60, 0xD8, 0x9B, 0x8F, 0xA9, 0x9F, 0x27, 0x44, 0xE0, 0x70, 0x8C, 0xCB, 0x53
};
static const uint8_t Milenage_TS5_f5[] = {
    0x31, 0xE1, 0x1A, 0x60, 0x91, 0x18
};
static const uint8_t Milenage_TS5_f5star[] = {
    0xFE, 0x25, 0x55, 0xE5, 0x4A, 0xA9
};
/* Test Set6 */
static const uint8_t Milenage_TS6_K[] = {
    0x6C, 0x38, 0xA1, 0x16, 0xAC, 0x28, 0x0C, 0x45, 0x4F, 0x59, 0x33, 0x2E, 0xE3, 0x5C, 0x8C, 0x4F
};
static const uint8_t Milenage_TS6_RAND[] = {
    0xEE, 0x64, 0x66, 0xBC, 0x96, 0x20, 0x2C, 0x5A, 0x55, 0x7A, 0xBB, 0xEF, 0xF8, 0xBA, 0xBF, 0x63
};
static const uint8_t Milenage_TS6_SQN[] = {
    0x41, 0x4B, 0x98, 0x22, 0x21, 0x81
};
static const uint8_t Milenage_TS6_AMF[] = {
    0x44, 0x64
};
static const uint8_t Milenage_TS6_OP[] = {
    0x1B, 0xA0, 0x0A, 0x1A, 0x7C, 0x67, 0x00, 0xAC, 0x8C, 0x3F, 0xF3, 0xE9, 0x6A, 0xD0, 0x87, 0x25
};
static const uint8_t Milenage_TS6_OPc[] = {
    0x38, 0x03, 0xEF, 0x53, 0x63, 0xB9, 0x47, 0xC6, 0xAA, 0xA2, 0x25, 0xE5, 0x8F, 0xAE, 0x39, 0x34
};
static const uint8_t Milenage_TS6_f1[] = {
    0x07, 0x8A, 0xDF, 0xB4, 0x88, 0x24, 0x1A, 0x57
};
static const uint8_t Milenage_TS6_f1star[] = {
    0x80, 0x24, 0x6B, 0x8D, 0x01, 0x86, 0xBC, 0xF1
};
static const uint8_t Milenage_TS6_f2[] = {
    0x16, 0xC8, 0x23, 0x3F, 0x05, 0xA0, 0xAC, 0x28
};
static const uint8_t Milenage_TS6_f3[] = {
    0x3F, 0x8C, 0x75, 0x87, 0xFE, 0x8E, 0x4B, 0x23, 0x3A, 0xF6, 0x76, 0xAE, 0xDE, 0x30, 0xBA, 0x3B
};
static const uint8_t Milenage_TS6_f4[] = {
    0xA7, 0x46, 0x6C, 0xC1, 0xE6, 0xB2, 0xA1, 0x33, 0x7D, 0x49, 0xD3, 0xB6, 0x6E, 0x95, 0xD7, 0xB4
};
static const uint8_t Milenage_TS6_f5[] = {
    0x45, 0xB0, 0xF6, 0x9A, 0xB0, 0x6C
};
static const uint8_t Milenage_TS6_f5star[] = {
    0x1F, 0x53, 0xCD, 0x2B, 0x11, 0x13
};
/* Test Set7 */
static const uint8_t Milenage_TS7_K[] = {
    0x2D, 0x60, 0x9D, 0x4D, 0xB0, 0xAC, 0x5B, 0xF0, 0xD2, 0xC0, 0xDE, 0x26, 0x70, 0x14, 0xDE, 0x0D
};
static const uint8_t Milenage_TS7_RAND[] = {
    0x19, 0x4A, 0xA7, 0x56, 0x01, 0x38, 0x96, 0xB7, 0x4B, 0x4A, 0x2A, 0x3B, 0x0A, 0xF4, 0x53, 0x9E
};
static const uint8_t Milenage_TS7_SQN[] = {
    0x6B, 0xF6, 0x94, 0x38, 0xC2, 0xE4
};
static const uint8_t Milenage_TS7_AMF[] = {
    0x5F, 0x67
};
static const uint8_t Milenage_TS7_OP[] = {
    0x46, 0x0A, 0x48, 0x38, 0x54, 0x27, 0xAA, 0x39, 0x26, 0x4A, 0xAC, 0x8E, 0xFC, 0x9E, 0x73, 0xE8
};
static const uint8_t Milenage_TS7_OPc[] = {
    0xC3, 0x5A, 0x0A, 0xB0, 0xBC, 0xBF, 0xC9, 0x25, 0x2C, 0xAF, 0xF1, 0x5F, 0x24, 0xEF, 0xBD, 0xE0
};
static const uint8_t Milenage_TS7_f1[] = {
    0xBD, 0x07, 0xD3, 0x00, 0x3B, 0x9E, 0x5C, 0xC3
};
static const uint8_t Milenage_TS7_f1star[] = {
    0xBC, 0xB6, 0xC2, 0xFC, 0xAD, 0x15, 0x22, 0x50
};
static const uint8_t Milenage_TS7_f2[] = {
    0x8C, 0x25, 0xA1, 0x6C, 0xD9, 0x18, 0xA1, 0xDF
};
static const uint8_t Milenage_TS7_f3[] = {
    0x4C, 0xD0, 0x84, 0x60, 0x20, 0xF8, 0xFA, 0x07, 0x31, 0xDD, 0x47, 0xCB, 0xDC, 0x6B, 0xE4, 0x11
};
static const uint8_t Milenage_TS7_f4[] = {
    0x88, 0xAB, 0x80, 0xA4, 0x15, 0xF1, 0x5C, 0x73, 0x71, 0x12, 0x54, 0xA1, 0xD3, 0x88, 0xF6, 0x96
};
static const uint8_t Milenage_TS7_f5[] = {
    0x7E, 0x64, 0x55, 0xF3, 0x4C, 0xF3
};
static const uint8_t Milenage_TS7_f5star[] = {
    0xDC, 0x6D, 0xD0, 0x1E, 0x8F, 0x15
};
/* Test Set8 */
static const uint8_t Milenage_TS8_K[] = {
    0xA5, 0x30, 0xA7, 0xFE, 0x42, 0x8F, 0xAD, 0x10, 0x82, 0xC4, 0x5E, 0xDD, 0xFC, 0xE1, 0x38, 0x84
};
static const uint8_t Milenage_TS8_RAND[] = {
    0x3A, 0x4C, 0x2B, 0x32, 0x45, 0xC5, 0x0E, 0xB5, 0xC7, 0x1D, 0x08, 0x63, 0x93, 0x95, 0x76, 0x4D
};
static const uint8_t Milenage_TS8_SQN[] = {
    0xF6, 0x3F, 0x5D, 0x76, 0x87, 0x84
};
static const uint8_t Milenage_TS8_AMF[] = {
    0xB9, 0x0E
};
static const uint8_t Milenage_TS8_OP[] = {
    0x51, 0x1C, 0x6C, 0x4E, 0x83, 0xE3, 0x8C, 0x89, 0xB1, 0xC5, 0xD8, 0xDD, 0xE6, 0x24, 0x26, 0xFA
};
static const uint8_t Milenage_TS8_OPc[] = {
    0x27, 0x95, 0x3E, 0x49, 0xBC, 0x8A, 0xF6, 0xDC, 0xC6, 0xE7, 0x30, 0xEB, 0x80, 0x28, 0x6B, 0xE3
};
static const uint8_t Milenage_TS8_f1[] = {
    0x53, 0x76, 0x1F, 0xBD, 0x67, 0x9B, 0x0B, 0xAD
};
static const uint8_t Milenage_TS8_f1star[] = {
    0x21, 0xAD, 0xFD, 0x33, 0x4A, 0x10, 0xE7, 0xCE
};
static const uint8_t Milenage_TS8_f2[] = {
    0xA6, 0x32, 0x41, 0xE1, 0xFF, 0xC3, 0xE5, 0xAB
};
static const uint8_t Milenage_TS8_f3[] = {
    0x10, 0xF0, 0x5B, 0xAB, 0x75, 0xA9, 0x9A, 0x5F, 0xBB, 0x98, 0xA9, 0xC2, 0x87, 0x67, 0x9C, 0x3B
};
static const uint8_t Milenage_TS8_f4[] = {
    0xF9, 0xEC, 0x08, 0x65, 0xEB, 0x32, 0xF2, 0x23, 0x69, 0xCA, 0xDE, 0x40, 0xC5, 0x9C, 0x3A, 0x44
};
static const uint8_t Milenage_TS8_f5[] = {
    0x88, 0x19, 0x6C, 0x47, 0x98, 0x6F
};
static const uint8_t Milenage_TS8_f5star[] = {
    0xC9, 0x87, 0xA3, 0xD2, 0x31, 0x15
};
/* Test Set9 */
static const uint8_t Milenage_TS9_K[] = {
    0xD9, 0x15, 0x1C, 0xF0, 0x48, 0x96, 0xE2, 0x58, 0x30, 0xBF, 0x2E, 0x08, 0x26, 0x7B, 0x83, 0x60
};
static const uint8_t Milenage_TS9_RAND[] = {
    0xF7, 0x61, 0xE5, 0xE9, 0x3D, 0x60, 0x3F, 0xEB, 0x73, 0x0E, 0x27, 0x55, 0x6C, 0xB8, 0xA2, 0xCA
};
static const uint8_t Milenage_TS9_SQN[] = {
    0x47, 0xEE, 0x01, 0x99, 0x82, 0x0A
};
static const uint8_t Milenage_TS9_AMF[] = {
    0x91, 0x13
};
static const uint8_t Milenage_TS9_OP[] = {
    0x75, 0xFC, 0x22, 0x33, 0xA4, 0x42, 0x94, 0xEE, 0x8E, 0x6D, 0xE2, 0x5C, 0x43, 0x53, 0xD2, 0x6B
};
static const uint8_t Milenage_TS9_OPc[] = {
    0xC4, 0xC9, 0x3E, 0xFF, 0xE8, 0xA0, 0x81, 0x38, 0xC2, 0x03, 0xD4, 0xC2, 0x7C, 0xE4, 0xE3, 0xD9
};
static const uint8_t Milenage_TS9_f1[] = {
    0x66, 0xCC, 0x4B, 0xE4, 0x48, 0x62, 0xAF, 0x1F
};
static const uint8_t Milenage_TS9_f1star[] = {
    0x7A, 0x4B, 0x8D, 0x7A, 0x87, 0x53, 0xF2, 0x46
};
static const uint8_t Milenage_TS9_f2[] = {
    0x4A, 0x90, 0xB2, 0x17, 0x1A, 0xC8, 0x3A, 0x76
};
static const uint8_t Milenage_TS9_f3[] = {
    0x71, 0x23, 0x6B, 0x71, 0x29, 0xF9, 0xB2, 0x2A, 0xB7, 0x7E, 0xA7, 0xA5, 0x4C, 0x96, 0xDA, 0x22
};
static const uint8_t Milenage_TS9_f4[] = {
    0x90, 0x52, 0x7E, 0xBA, 0xA5, 0x58, 0x89, 0x68, 0xDB, 0x41, 0x72, 0x73, 0x25, 0xA0, 0x4D, 0x9E
};
static const uint8_t Milenage_TS9_f5[] = {
    0x82, 0xA0, 0xF5, 0x28, 0x7A, 0x71
};
static const uint8_t Milenage_TS9_f5star[] = {
    0x52, 0x7D, 0xBF, 0x41, 0xF3, 0x5F
};
/* Test Set10 */
static const uint8_t Milenage_TS10_K[] = {
    0xA0, 0xE2, 0x97, 0x1B, 0x68, 0x22, 0xE8, 0xD3, 0x54, 0xA1, 0x8C, 0xC2, 0x35, 0x62, 0x4E, 0xCB
};
static const uint8_t Milenage_TS10_RAND[] = {
    0x08, 0xEF, 0xF8, 0x28, 0xB1, 0x3F, 0xDB, 0x56, 0x27, 0x22, 0xC6, 0x5C, 0x7F, 0x30, 0xA9, 0xB2
};
static const uint8_t Milenage_TS10_SQN[] = {
    0xDB, 0x5C, 0x06, 0x64, 0x81, 0xE0
};
static const uint8_t Milenage_TS10_AMF[] = {
    0x71, 0x6B
};
static const uint8_t Milenage_TS10_OP[] = {
    0x32, 0x37, 0x92, 0xFA, 0xCA, 0x21, 0xFB, 0x4D, 0x5D, 0x6F, 0x13, 0xC1, 0x45, 0xA9, 0xD2, 0xC1
};
static const uint8_t Milenage_TS10_OPc[] = {
    0x82, 0xA2, 0x6F, 0x22, 0xBB, 0xA9, 0xE9, 0x48, 0x8F, 0x94, 0x9A, 0x10, 0xD9, 0x8E, 0x9C, 0xC4
};
static const uint8_t Milenage_TS10_f1[] = {
    0x94, 0x85, 0xFE, 0x24, 0x62, 0x1C, 0xB9, 0xF6
};
static const uint8_t Milenage_TS10_f1star[] = {
    0xBC, 0xE3, 0x25, 0xCE, 0x03, 0xE2, 0xE9, 0xB9
};
static const uint8_t Milenage_TS10_f2[] = {
    0x4B, 0xC2, 0x21, 0x2D, 0x86, 0x24, 0x91, 0x0A
};
static const uint8_t Milenage_TS10_f3[] = {
    0x08, 0xCE, 0xF6, 0xD0, 0x04, 0xEC, 0x61, 0x47, 0x1A, 0x3C, 0x3C, 0xDA, 0x04, 0x81, 0x37, 0xFA
};
static const uint8_t Milenage_TS10_f4[] = {
    0xED, 0x03, 0x18, 0xCA, 0x5D, 0xEB, 0x92, 0x06, 0x27, 0x2F, 0x6E, 0x8F, 0xA6, 0x4B, 0xA4, 0x11
};
static const uint8_t Milenage_TS10_f5[] = {
    0xA2, 0xF8, 0x58, 0xAA, 0x9E, 0x5D
};
static const uint8_t Milenage_TS10_f5star[] = {
    0x74, 0xE7, 0x6F, 0xBB, 0xEC, 0x38
};
/* Test Set11 */
static const uint8_t Milenage_TS11_K[] = {
    0x0D, 0xA6, 0xF7, 0xBA, 0x86, 0xD5, 0xEA, 0xC8, 0xA1, 0x9C, 0xF5, 0x63, 0xAC, 0x58, 0x64, 0x2D
};
static const uint8_t Milenage_TS11_RAND[] = {
    0x67, 0x9A, 0xC4, 0xDB, 0xAC, 0xD7, 0xD2, 0x33, 0xFF, 0x9D, 0x68, 0x06, 0xF4, 0x14, 0x9C, 0xE3
};
static const uint8_t Milenage_TS11_SQN[] = {
    0x6E, 0x23, 0x31, 0xD6, 0x92, 0xAD
};
static const uint8_t Milenage_TS11_AMF[] = {
    0x22, 0x4A
};
static const uint8_t Milenage_TS11_OP[] = {
    0x4B, 0x9A, 0x26, 0xFA, 0x45, 0x9E, 0x3A, 0xCB, 0xFF, 0x36, 0xF4, 0x01, 0x5D, 0xE3, 0xBD, 0xC1
};
static const uint8_t Milenage_TS11_OPc[] = {
    0x0D, 0xB1, 0x07, 0x1F, 0x87, 0x67, 0x56, 0x2C, 0xA4, 0x3A, 0x0A, 0x64, 0xC4, 0x1E, 0x8D, 0x08
};
static const uint8_t Milenage_TS11_f1[] = {
    0x28, 0x31, 0xD7, 0xAE, 0x90, 0x88, 0xE4, 0x92
};
static const uint8_t Milenage_TS11_f1star[] = {
    0x9B, 0x2E, 0x16, 0x95, 0x11, 0x35, 0xD5, 0x23
};
static const uint8_t Milenage_TS11_f2[] = {
    0x6F, 0xC3, 0x0F, 0xEE, 0x6D, 0x12, 0x35, 0x23
};
static const uint8_t Milenage_TS11_f3[] = {
    0x69, 0xB1, 0xCA, 0xE7, 0xC7, 0x42, 0x9D, 0x97, 0x5E, 0x24, 0x5C, 0xAC, 0xB0, 0x5A, 0x51, 0x7C
};
static const uint8_t Milenage_TS11_f4[] = {
    0x74, 0xF2, 0x4E, 0x8C, 0x26, 0xDF, 0x58, 0xE1, 0xB3, 0x8D, 0x7D, 0xCD, 0x4F, 0x1B, 0x7F, 0xBD
};
static const uint8_t Milenage_TS11_f5[] = {
    0x4C, 0x53, 0x9A, 0x26, 0xE1, 0xFA
};
static const uint8_t Milenage_TS11_f5star[] = {
    0x07, 0x86, 0x1E, 0x12, 0x69, 0x28
};
/* Test Set12 */
static const uint8_t Milenage_TS12_K[] = {
    0x77, 0xB4, 0x58, 0x43, 0xC8, 0x8E, 0x58, 0xC1, 0x0D, 0x20, 0x26, 0x84, 0x51, 0x5E, 0xD4, 0x30
};
static const uint8_t Milenage_TS12_RAND[] = {
    0x4C, 0x47, 0xEB, 0x30, 0x76, 0xDC, 0x55, 0xFE, 0x51, 0x06, 0xCB, 0x20, 0x34, 0xB8, 0xCD, 0x78
};
static const uint8_t Milenage_TS12_SQN[] = {
    0xFE, 0x1A, 0x87, 0x31, 0x00, 0x5D
};
static const uint8_t Milenage_TS12_AMF[] = {
    0xAD, 0x25
};
static const uint8_t Milenage_TS12_OP[] = {
    0xBF, 0x32, 0x86, 0xC7, 0xA5, 0x14, 0x09, 0xCE, 0x95, 0x72, 0x4D, 0x50, 0x3B, 0xFE, 0x6E, 0x70
};
static const uint8_t Milenage_TS12_OPc[] = {
    0xD4, 0x83, 0xAF, 0xAE, 0x56, 0x24, 0x09, 0xA3, 0x26, 0xB5, 0xBB, 0x0B, 0x20, 0xC4, 0xD7, 0x62
};
static const uint8_t Milenage_TS12_f1[] = {
    0x08, 0x33, 0x2D, 0x7E, 0x9F, 0x48, 0x45, 0x70
};
static const uint8_t Milenage_TS12_f1star[] = {
    0xED, 0x41, 0xB7, 0x34, 0x48, 0x9D, 0x52, 0x07
};
static const uint8_t Milenage_TS12_f2[] = {
    0xAE, 0xFA, 0x35, 0x7B, 0xEA, 0xC2, 0xA8, 0x7A
};
static const uint8_t Milenage_TS12_f3[] = {
    0x90, 0x8C, 0x43, 0xF0, 0x56, 0x9C, 0xB8, 0xF7, 0x4B, 0xC9, 0x71, 0xE7, 0x06, 0xC3, 0x6C, 0x5F
};
static const uint8_t Milenage_TS12_f4[] = {
    0xC2, 0x51, 0xDF, 0x0D, 0x88, 0x8D, 0xD9, 0x32, 0x9B, 0xCF, 0x46, 0x65, 0x5B, 0x22, 0x6E, 0x40
};
static const uint8_t Milenage_TS12_f5[] = {
    0x30, 0xFF, 0x25, 0xCD, 0xAD, 0xF6
};
static const uint8_t Milenage_TS12_f5star[] = {
    0xE8, 0x4E, 0xD0, 0xD4, 0x67, 0x7E
};
/* Test Set13 */
static const uint8_t Milenage_TS13_K[] = {
    0x72, 0x9B, 0x17, 0x72, 0x92, 0x70, 0xDD, 0x87, 0xCC, 0xDF, 0x1B, 0xFE, 0x29, 0xB4, 0xE9, 0xBB
};
static const uint8_t Milenage_TS13_RAND[] = {
    0x31, 0x1C, 0x4C, 0x92, 0x97, 0x44, 0xD6, 0x75, 0xB7, 0x20, 0xF3, 0xB7, 0xE9, 0xB1, 0xCB, 0xD0
};
static const uint8_t Milenage_TS13_SQN[] = {
    0xC8, 0x5C, 0x4C, 0xF6, 0x59, 0x16
};
static const uint8_t Milenage_TS13_AMF[] = {
    0x5B, 0xB2
};
static const uint8_t Milenage_TS13_OP[] = {
    0xD0, 0x4C, 0x9C, 0x35, 0xBD, 0x22, 0x62, 0xFA, 0x81, 0x0D, 0x29, 0x24, 0xD0, 0x36, 0xFD, 0x13
};
static const uint8_t Milenage_TS13_OPc[] = {
    0x22, 0x8C, 0x2F, 0x2F, 0x06, 0xAC, 0x32, 0x68, 0xA9, 0xE6, 0x16, 0xEE, 0x16, 0xDB, 0x4B, 0xA1
};
static const uint8_t Milenage_TS13_f1[] = {
    0xFF, 0x79, 0x4F, 0xE2, 0xF8, 0x27, 0xEB, 0xF8
};
static const uint8_t Milenage_TS13_f1star[] = {
    0x24, 0xFE, 0x4D, 0xC6, 0x1E, 0x87, 0x4B, 0x52
};
static const uint8_t Milenage_TS13_f2[] = {
    0x98, 0xDB, 0xBD, 0x09, 0x9B, 0x3B, 0x40, 0x8D
};
static const uint8_t Milenage_TS13_f3[] = {
    0x44, 0xC0, 0xF2, 0x3C, 0x54, 0x93, 0xCF, 0xD2, 0x41, 0xE4, 0x8F, 0x19, 0x7E, 0x1D, 0x10, 0x12
};
static const uint8_t Milenage_TS13_f4[] = {
    0x0C, 0x9F, 0xB8, 0x16, 0x13, 0x88, 0x4C, 0x25, 0x35, 0xDD, 0x0E, 0xAB, 0xF3, 0xB4, 0x40, 0xD8
};
static const uint8_t Milenage_TS13_f5[] = {
    0x53, 0x80, 0xD1, 0x58, 0xCF, 0xE3
};
static const uint8_t Milenage_TS13_f5star[] = {
    0x87, 0xAC, 0x3B, 0x55, 0x9F, 0xB6
};
/* Test Set14 */
static const uint8_t Milenage_TS14_K[] = {
    0x72, 0x9B, 0x17, 0x72, 0x92, 0x70, 0xDD, 0x87, 0xCC, 0xDF, 0x1B, 0xFE, 0x29, 0xB4, 0xE9, 0xBB
};
static const uint8_t Milenage_TS14_RAND[] = {
    0x31, 0x1C, 0x4C, 0x92, 0x97, 0x44, 0xD6, 0x75, 0xB7, 0x20, 0xF3, 0xB7, 0xE9, 0xB1, 0xCB, 0xD0
};
static const uint8_t Milenage_TS14_SQN[] = {
    0xC8, 0x5C, 0x4C, 0xF6, 0x59, 0x16
};
static const uint8_t Milenage_TS14_AMF[] = {
    0x5B, 0xB2
};
static const uint8_t Milenage_TS14_OP[] = {
    0xD0, 0x4C, 0x9C, 0x35, 0xBD, 0x22, 0x62, 0xFA, 0x81, 0x0D, 0x29, 0x24, 0xD0, 0x36, 0xFD, 0x13
};
static const uint8_t Milenage_TS14_OPc[] = {
    0x22, 0x8C, 0x2F, 0x2F, 0x06, 0xAC, 0x32, 0x68, 0xA9, 0xE6, 0x16, 0xEE, 0x16, 0xDB, 0x4B, 0xA1
};
static const uint8_t Milenage_TS14_f1[] = {
    0xFF, 0x79, 0x4F, 0xE2, 0xF8, 0x27, 0xEB, 0xF8
};
static const uint8_t Milenage_TS14_f1star[] = {
    0x24, 0xFE, 0x4D, 0xC6, 0x1E, 0x87, 0x4B, 0x52
};
static const uint8_t Milenage_TS14_f2[] = {
    0x98, 0xDB, 0xBD, 0x09, 0x9B, 0x3B, 0x40, 0x8D
};
static const uint8_t Milenage_TS14_f3[] = {
    0x44, 0xC0, 0xF2, 0x3C, 0x54, 0x93, 0xCF, 0xD2, 0x41, 0xE4, 0x8F, 0x19, 0x7E, 0x1D, 0x10, 0x12
};
static const uint8_t Milenage_TS14_f4[] = {
    0x0C, 0x9F, 0xB8, 0x16, 0x13, 0x88, 0x4C, 0x25, 0x35, 0xDD, 0x0E, 0xAB, 0xF3, 0xB4, 0x40, 0xD8
};
static const uint8_t Milenage_TS14_f5[] = {
    0x53, 0x80, 0xD1, 0x58, 0xCF, 0xE3
};
static const uint8_t Milenage_TS14_f5star[] = {
    0x87, 0xAC, 0x3B, 0x55, 0x9F, 0xB6
};
/* Test Set15 */
static const uint8_t Milenage_TS15_K[] = {
    0xAF, 0x7C, 0x65, 0xE1, 0x92, 0x72, 0x21, 0xDE, 0x59, 0x11, 0x87, 0xA2, 0xC5, 0x98, 0x7A, 0x53
};
static const uint8_t Milenage_TS15_RAND[] = {
    0x1F, 0x0F, 0x85, 0x78, 0x46, 0x4F, 0xD5, 0x9B, 0x64, 0xBE, 0xD2, 0xD0, 0x94, 0x36, 0xB5, 0x7A
};
static const uint8_t Milenage_TS15_SQN[] = {
    0x3D, 0x62, 0x7B, 0x01, 0x41, 0x8D
};
static const uint8_t Milenage_TS15_AMF[] = {
    0x84, 0xF6
};
static const uint8_t Milenage_TS15_OP[] = {
    0x0C, 0x7A, 0xCB, 0x8D, 0x95, 0xB7, 0xD4, 0xA3, 0x1C, 0x5A, 0xCA, 0x6D, 0x26, 0x34, 0x5A, 0x88
};
static const uint8_t Milenage_TS15_OPc[] = {
    0xA4, 0xCF, 0x5C, 0x81, 0x55, 0xC0, 0x8A, 0x7E, 0xFF, 0x41, 0x8E, 0x54, 0x43, 0xB9, 0x8E, 0x55
};
static const uint8_t Milenage_TS15_f1[] = {
    0xC3, 0x7C, 0xAE, 0x78, 0x05, 0x64, 0x20, 0x32
};
static const uint8_t Milenage_TS15_f1star[] = {
    0x68, 0xCD, 0x09, 0xA4, 0x52, 0xD8, 0xDB, 0x7C
};
static const uint8_t Milenage_TS15_f2[] = {
    0x7B, 0xFF, 0xA5, 0xC2, 0xF4, 0x1F, 0xBC, 0x05
};
static const uint8_t Milenage_TS15_f3[] = {
    0x3F, 0x8C, 0x3F, 0x3C, 0xCF, 0x76, 0x25, 0xBF, 0x77, 0xFC, 0x94, 0xBC, 0xFD, 0x22, 0xFD, 0x26
};
static const uint8_t Milenage_TS15_f4[] = {
    0xAB, 0xCB, 0xAE, 0x8F, 0xD4, 0x61, 0x15, 0xE9, 0x96, 0x1A, 0x55, 0xD0, 0xDA, 0x5F, 0x20, 0x78
};
static const uint8_t Milenage_TS15_f5[] = {
    0x83, 0x7F, 0xD7, 0xB7, 0x44, 0x19
};
static const uint8_t Milenage_TS15_f5star[] = {
    0x56, 0xE9, 0x7A, 0x60, 0x90, 0xB1
};
/* Test Set16 */
static const uint8_t Milenage_TS16_K[] = {
    0x5B, 0xD7, 0xEC, 0xD3, 0xD3, 0x12, 0x7A, 0x41, 0xD1, 0x25, 0x39, 0xBE, 0xD4, 0xE7, 0xCF, 0x71
};
static const uint8_t Milenage_TS16_RAND[] = {
    0x59, 0xB7, 0x5F, 0x14, 0x25, 0x1C, 0x75, 0x03, 0x1D, 0x0B, 0xCB, 0xAC, 0x1C, 0x2C, 0x04, 0xC7
};
static const uint8_t Milenage_TS16_SQN[] = {
    0xA2, 0x98, 0xAE, 0x89, 0x29, 0xDC
};
static const uint8_t Milenage_TS16_AMF[] = {
    0xD0, 0x56
};
static const uint8_t Milenage_TS16_OP[] = {
    0xF9, 0x67, 0xF7, 0x60, 0x38, 0xB9, 0x20, 0xA9, 0xCD, 0x25, 0xE1, 0x0C, 0x08, 0xB4, 0x99, 0x24
};
static const uint8_t Milenage_TS16_OPc[] = {
    0x76, 0x08, 0x9D, 0x3C, 0x0F, 0xF3, 0xEF, 0xDC, 0x6E, 0x36, 0x72, 0x1D, 0x4F, 0xCE, 0xB7, 0x47
};
static const uint8_t Milenage_TS16_f1[] = {
    0xC3, 0xF2, 0x5C, 0xD9, 0x43, 0x09, 0x10, 0x7E
};
static const uint8_t Milenage_TS16_f1star[] = {
    0xB0, 0xC8, 0xBA, 0x34, 0x36, 0x65, 0xAF, 0xCC
};
static const uint8_t Milenage_TS16_f2[] = {
    0x7E, 0x3F, 0x44, 0xC7, 0x59, 0x1F, 0x6F, 0x45
};
static const uint8_t Milenage_TS16_f3[] = {
    0xD4, 0x2B, 0x2D, 0x61, 0x5E, 0x49, 0xA0, 0x3A, 0xC2, 0x75, 0xA5, 0xAE, 0xF9, 0x7A, 0xF8, 0x92
};
static const uint8_t Milenage_TS16_f4[] = {
    0x0B, 0x3F, 0x8D, 0x02, 0x4F, 0xE6, 0xBF, 0xAF, 0xAA, 0x98, 0x2B, 0x8F, 0x82, 0xE3, 0x19, 0xC2
};
static const uint8_t Milenage_TS16_f5[] = {
    0x5B, 0xE1, 0x14, 0x95, 0x52, 0x5D
};
static const uint8_t Milenage_TS16_f5star[] = {
    0x4D, 0x6A, 0x34, 0xA1, 0xE4, 0xEB
};
/* Test Set17 */
static const uint8_t Milenage_TS17_K[] = {
    0x6C, 0xD1, 0xC6, 0xCE, 0xB1, 0xE0, 0x1E, 0x14, 0xF1, 0xB8, 0x23, 0x16, 0xA9, 0x0B, 0x7F, 0x3D
};
static const uint8_t Milenage_TS17_RAND[] = {
    0xF6, 0x9B, 0x78, 0xF3, 0x00, 0xA0, 0x56, 0x8B, 0xCE, 0x9F, 0x0C, 0xB9, 0x3C, 0x4B, 0xE4, 0xC9
};
static const uint8_t Milenage_TS17_SQN[] = {
    0xB4, 0xFC, 0xE5, 0xFE, 0xB0, 0x59
};
static const uint8_t Milenage_TS17_AMF[] = {
    0xE4, 0xBB
};
static const uint8_t Milenage_TS17_OP[] = {
    0x07, 0x8B, 0xFC, 0xA9, 0x56, 0x46, 0x59, 0xEC, 0xD8, 0x85, 0x1E, 0x84, 0xE6, 0xC5, 0x9B, 0x48
};
static const uint8_t Milenage_TS17_OPc[] = {
    0xA2, 0x19, 0xDC, 0x37, 0xF1, 0xDC, 0x7D, 0x66, 0x73, 0x8B, 0x58, 0x43, 0xC7, 0x99, 0xF2, 0x06
};
static const uint8_t Milenage_TS17_f1[] = {
    0x69, 0xA9, 0x08, 0x69, 0xC2, 0x68, 0xCB, 0x7B
};
static const uint8_t Milenage_TS17_f1star[] = {
    0x2E, 0x0F, 0xDC, 0xF9, 0xFD, 0x1C, 0xFA, 0x6A
};
static const uint8_t Milenage_TS17_f2[] = {
    0x70, 0xF6, 0xBD, 0xB9, 0xAD, 0x21, 0x52, 0x5F
};
static const uint8_t Milenage_TS17_f3[] = {
    0x6E, 0xDA, 0xF9, 0x9E, 0x5B, 0xD9, 0xF8, 0x5D, 0x5F, 0x36, 0xD9, 0x1C, 0x12, 0x72, 0xFB, 0x4B
};
static const uint8_t Milenage_TS17_f4[] = {
    0xD6, 0x1C, 0x85, 0x3C, 0x28, 0x0D, 0xD9, 0xC4, 0x6F, 0x29, 0x7B, 0xAE, 0xC3, 0x86, 0xDE, 0x17
};
static const uint8_t Milenage_TS17_f5[] = {
    0x1C, 0x40, 0x8A, 0x85, 0x8B, 0x3E
};
static const uint8_t Milenage_TS17_f5star[] = {
    0xAA, 0x4A, 0xE5, 0x2D, 0xAA, 0x30
};
/* Test Set18 */
static const uint8_t Milenage_TS18_K[] = {
    0xB7, 0x3A, 0x90, 0xCB, 0xCF, 0x3A, 0xFB, 0x62, 0x2D, 0xBA, 0x83, 0xC5, 0x8A, 0x84, 0x15, 0xDF
};
static const uint8_t Milenage_TS18_RAND[] = {
    0xB1, 0x20, 0xF1, 0xC1, 0xA0, 0x10, 0x2A, 0x2F, 0x50, 0x7D, 0xD5, 0x43, 0xDE, 0x68, 0x28, 0x1F
};
static const uint8_t Milenage_TS18_SQN[] = {
    0xF1, 0xE8, 0xA5, 0x23, 0xA3, 0x6D
};
static const uint8_t Milenage_TS18_AMF[] = {
    0x47, 0x1B
};
static const uint8_t Milenage_TS18_OP[] = {
    0xB6, 0x72, 0x04, 0x7E, 0x00, 0x3B, 0xB9, 0x52, 0xDC, 0xA6, 0xCB, 0x8A, 0xF0, 0xE5, 0xB7, 0x79
};
static const uint8_t Milenage_TS18_OPc[] = {
    0xDF, 0x0C, 0x67, 0x86, 0x8F, 0xA2, 0x5F, 0x74, 0x8B, 0x70, 0x44, 0xC6, 0xE7, 0xC2, 0x45, 0xB8
};
static const uint8_t Milenage_TS18_f1[] = {
    0xEB, 0xD7, 0x03, 0x41, 0xBC, 0xD4, 0x15, 0xB0
};
static const uint8_t Milenage_TS18_f1star[] = {
    0x12, 0x35, 0x9F, 0x5D, 0x82, 0x22, 0x0C, 0x14
};
static const uint8_t Milenage_TS18_f2[] = {
    0x47, 0x9D, 0xD2, 0x5C, 0x20, 0x79, 0x2D, 0x63
};
static const uint8_t Milenage_TS18_f3[] = {
    0x66, 0x19, 0x5D, 0xBE, 0xD0, 0x31, 0x32, 0x74, 0xC5, 0xCA, 0x77, 0x66, 0x61, 0x5F, 0xA2, 0x5E
};
static const uint8_t Milenage_TS18_f4[] = {
    0x66, 0xBE, 0xC7, 0x07, 0xEB, 0x2A, 0xFC, 0x47, 0x6D, 0x74, 0x08, 0xA8, 0xF2, 0x92, 0x7B, 0x36
};
static const uint8_t Milenage_TS18_f5[] = {
    0xAE, 0xFD, 0xAA, 0x5D, 0xDD, 0x99
};
static const uint8_t Milenage_TS18_f5star[] = {
    0x12, 0xEC, 0x2B, 0x87, 0xFB, 0xB1
};
/* Test Set19 */
static const uint8_t Milenage_TS19_K[] = {
    0x51, 0x22, 0x25, 0x02, 0x14, 0xC3, 0x3E, 0x72, 0x3A, 0x5D, 0xD5, 0x23, 0xFC, 0x14, 0x5F, 0xC0
};
static const uint8_t Milenage_TS19_RAND[] = {
    0x81, 0xE9, 0x2B, 0x6C, 0x0E, 0xE0, 0xE1, 0x2E, 0xBC, 0xEB, 0xA8, 0xD9, 0x2A, 0x99, 0xDF, 0xA5
};
static const uint8_t Milenage_TS19_SQN[] = {
    0x16, 0xF3, 0xB3, 0xF7, 0x0F, 0xC2
};
static const uint8_t Milenage_TS19_AMF[] = {
    0xC3, 0xAB
};
static const uint8_t Milenage_TS19_OP[] = {
    0xC9, 0xE8, 0x76, 0x32, 0x86, 0xB5, 0xB9, 0xFF, 0xBD, 0xF5, 0x6E, 0x12, 0x97, 0xD0, 0x88, 0x7B
};
static const uint8_t Milenage_TS19_OPc[] = {
    0x98, 0x1D, 0x46, 0x4C, 0x7C, 0x52, 0xEB, 0x6E, 0x50, 0x36, 0x23, 0x49, 0x84, 0xAD, 0x0B, 0xCF
};
static const uint8_t Milenage_TS19_f1[] = {
    0x2A, 0x5C, 0x23, 0xD1, 0x5E, 0xE3, 0x51, 0xD5
};
static const uint8_t Milenage_TS19_f1star[] = {
    0x62, 0xDA, 0xE3, 0x85, 0x3F, 0x3A, 0xF9, 0xD2
};
static const uint8_t Milenage_TS19_f2[] = {
    0x28, 0xD7, 0xB0, 0xF2, 0xA2, 0xEC, 0x3D, 0xE5
};
static const uint8_t Milenage_TS19_f3[] = {
    0x53, 0x49, 0xFB, 0xE0, 0x98, 0x64, 0x9F, 0x94, 0x8F, 0x5D, 0x2E, 0x97, 0x3A, 0x81, 0xC0, 0x0F
};
static const uint8_t Milenage_TS19_f4[] = {
    0x97, 0x44, 0x87, 0x1A, 0xD3, 0x2B, 0xF9, 0xBB, 0xD1, 0xDD, 0x5C, 0xE5, 0x4E, 0x3E, 0x2E, 0x5A
};
static const uint8_t Milenage_TS19_f5[] = {
    0xAD, 0xA1, 0x5A, 0xEB, 0x7B, 0xB8
};
static const uint8_t Milenage_TS19_f5star[] = {
    0xD4, 0x61, 0xBC, 0x15, 0x47, 0x5D
};
/* Test Set20 */
static const uint8_t Milenage_TS20_K[] = {
    0x90, 0xDC, 0xA4, 0xED, 0xA4, 0x5B, 0x53, 0xCF, 0x0F, 0x12, 0xD7, 0xC9, 0xC3, 0xBC, 0x6A, 0x89
};
static const uint8_t Milenage_TS20_RAND[] = {
    0x9F, 0xDD, 0xC7, 0x20, 0x92, 0xC6, 0xAD, 0x03, 0x6B, 0x6E, 0x46, 0x47, 0x89, 0x31, 0x5B, 0x78
};
static const uint8_t Milenage_TS20_SQN[] = {
    0x20, 0xF8, 0x13, 0xBD, 0x41, 0x41
};
static const uint8_t Milenage_TS20_AMF[] = {
    0x61, 0xDF
};
static const uint8_t Milenage_TS20_OP[] = {
    0x3F, 0xFC, 0xFE, 0x5B, 0x7B, 0x11, 0x11, 0x58, 0x99, 0x20, 0xD3, 0x52, 0x8E, 0x84, 0xE6, 0x55
};
static const uint8_t Milenage_TS20_OPc[] = {
    0xCB, 0x9C, 0xCC, 0xC4, 0xB9, 0x25, 0x8E, 0x6D, 0xCA, 0x47, 0x60, 0x37, 0x9F, 0xB8, 0x25, 0x81
};
static const uint8_t Milenage_TS20_f1[] = {
    0x09, 0xDB, 0x94, 0xEA, 0xB4, 0xF8, 0x14, 0x9E
};
static const uint8_t Milenage_TS20_f1star[] = {
    0xA2, 0x94, 0x68, 0xAA, 0x97, 0x75, 0xB5, 0x27
};
static const uint8_t Milenage_TS20_f2[] = {
    0xA9, 0x51, 0x00, 0xE2, 0x76, 0x09, 0x52, 0xCD
};
static const uint8_t Milenage_TS20_f3[] = {
    0xB5, 0xF2, 0xDA, 0x03, 0x88, 0x3B, 0x69, 0xF9, 0x6B, 0xF5, 0x2E, 0x02, 0x9E, 0xD9, 0xAC, 0x45
};
static const uint8_t Milenage_TS20_f4[] = {
    0xB4, 0x72, 0x13, 0x68, 0xBC, 0x16, 0xEA, 0x67, 0x87, 0x5C, 0x55, 0x98, 0x68, 0x8B, 0xB0, 0xEF
};
static const uint8_t Milenage_TS20_f5[] = {
    0x83, 0xCF, 0xD5, 0x4D, 0xB9, 0x13
};
static const uint8_t Milenage_TS20_f5star[] = {
    0x4F, 0x20, 0x39, 0x39, 0x2D, 0xDC
};


#endif /* INCLUDE_GUARD_TESTVECTORS_MILENAGE_DATA_H */

/* end of file testvectors_milenage_data.h */
