/* testvectors_aria_gcm_data.h
 *
 * Description: Test vectors for ARIA GCM, test vector contents.
 *              This file has been generated automatically.
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

#include <third_party/hsmddk/include/Kit/DriverFramework/Basic_Defs_API/incl/basic_defs.h>

/* ARIA128(GCM)VTEF COUNT = 0 */
static const uint8_t ARIA_GCM_128_0_K[] =
{
    0x3A, 0xBE, 0xCB, 0x09, 0x94, 0xD0, 0x72, 0xBB, 0xC0, 0xC1, 0x7C, 0x43, 0x74, 0x02, 0xE9, 0xB0
};
static const uint8_t ARIA_GCM_128_0_P[] =
{
    0xFA, 0x53, 0x8F, 0x34, 0xA8, 0xD2, 0xB6, 0x11, 0x5D, 0x0F, 0x26, 0x8E, 0xBB, 0xBA, 0x1B, 0x0C,
    0x6E, 0x59, 0x57, 0x50, 0xF9, 0xF4, 0x0C, 0xD6, 0xB5, 0x12, 0xFC, 0x68, 0x16, 0xE5, 0xDF, 0xF0,
    0x31, 0xC2, 0x05, 0x8B, 0x7B, 0xD4, 0x3C, 0xDE, 0xD4, 0x10, 0xF4, 0xAD, 0xC4, 0x6B, 0xA1, 0xA9,
    0x04, 0x4B, 0x61, 0x8A, 0x40, 0x3C, 0xDF, 0x5E, 0x1B, 0xE5, 0x77, 0x21, 0x74, 0x3A, 0x9B, 0x8D,
    0xE7, 0xF3, 0x75, 0x33, 0x97, 0x3C, 0xCD, 0xCB, 0x2B, 0xAE, 0x2E, 0xC9, 0x17, 0x7E, 0x44, 0x31,
    0x1D, 0xF4, 0x89, 0xAB, 0x13, 0x1F, 0x21, 0xDA, 0xE6, 0xC8, 0x01, 0xEA, 0xDF, 0xA4, 0x57, 0x68,
    0x25, 0xCD, 0x26, 0x57, 0x84, 0x73, 0x31, 0x80, 0x6C, 0xCF, 0x1B, 0x09, 0x3D, 0x59, 0xCC, 0x49,
    0xC1, 0x3B, 0x17, 0xDB, 0xFA, 0x05, 0x99, 0xF1, 0x1F, 0xA2, 0xE4, 0xEB, 0xE1, 0x8B, 0xDD, 0x29
};
static const uint8_t ARIA_GCM_128_0_C[] =
{
    0x8C, 0xFB, 0x44, 0x75, 0xFD, 0xCA, 0xED, 0xFC, 0xB3, 0xEC, 0x26, 0xC8, 0x2E, 0xA2, 0xBE, 0xED,
    0xF2, 0x81, 0xFD, 0x45, 0x9A, 0x1C, 0xFC, 0x1E, 0x22, 0x6E, 0x09, 0x78, 0x08, 0x89, 0x99, 0x80,
    0xE7, 0xDD, 0x2E, 0x2A, 0x37, 0x8A, 0x85, 0x0C, 0x6E, 0x50, 0xF9, 0x63, 0x63, 0x7C, 0xD6, 0xC9,
    0x54, 0xCF, 0xE3, 0x46, 0xD3, 0x3E, 0x70, 0x49, 0xD1, 0xDD, 0x84, 0xE2, 0x93, 0x32, 0xC6, 0x2E,
    0xF5, 0xAC, 0xDE, 0xA6, 0xA8, 0xF4, 0xD3, 0x07, 0xF7, 0xD6, 0x2A, 0x06, 0x92, 0x7C, 0x12, 0xF8,
    0xDD, 0x84, 0x65, 0xDA, 0x49, 0xBA, 0xF7, 0x45, 0xC1, 0xBD, 0x53, 0x63, 0x86, 0x85, 0x9C, 0xF8,
    0x52, 0x13, 0x82, 0x36, 0xC7, 0x57, 0x26, 0xB1, 0xC7, 0x14, 0x5C, 0x40, 0x9D, 0x20, 0xC3, 0x3B,
    0x1F, 0xDF, 0x44, 0xC2, 0x9A, 0x19, 0xB9, 0xEA, 0x7B, 0xBF, 0xA1, 0x83, 0x7C, 0xB5, 0x2B, 0x34
};
static const uint8_t ARIA_GCM_128_0_A[] = { };
static const uint8_t ARIA_GCM_128_0_IV[] =
{
    0x53, 0x34, 0x23, 0xD4, 0xB6, 0xE0, 0xE0, 0x99, 0xAC, 0x68, 0x49, 0x99, 0x40, 0x3D, 0x5C, 0xE8
};
static const uint8_t ARIA_GCM_128_0_H[] =
{
    0x83, 0xD5, 0x56, 0x2C, 0x5F, 0x2F, 0xE6, 0xA2, 0x2C, 0x78, 0xC2, 0x67, 0x37, 0x2D, 0x56, 0x79
};
static const uint8_t ARIA_GCM_128_0_Y0[] =
{
    0xA8, 0x61, 0x23, 0xC2, 0x5F, 0xB4, 0x9F, 0xBC, 0xAB, 0x21, 0x24, 0x42, 0x42, 0xAA, 0xF4, 0xBA
};
static const uint8_t ARIA_GCM_128_0_GH[] =
{
    0x30, 0x0B, 0xF8, 0x22, 0x01, 0xD3, 0x49, 0xDD, 0x37, 0x70, 0x81, 0x31, 0x55, 0xFE, 0xBF, 0xA4
};
static const uint8_t ARIA_GCM_128_0_T[] =
{
    0x57, 0x31, 0x6C, 0x87, 0x0D, 0x49, 0x28, 0xF8, 0x01, 0x20, 0xC5, 0xCD, 0x58, 0x74, 0x0D, 0x40
};

/* ARIA128(GCM)VTEF COUNT = 0 */
static const uint8_t ARIA_GCM_128_1_K[] =
{
    0x46, 0x8F, 0x78, 0xA2, 0xE2, 0x93, 0x20, 0xCC, 0x41, 0x26, 0x9D, 0xF2, 0x35, 0x5D, 0xFF, 0xF7
};
static const uint8_t ARIA_GCM_128_1_P[] = { };
static const uint8_t ARIA_GCM_128_1_C[] = { };
static const uint8_t ARIA_GCM_128_1_A[] =
{
    0x2F, 0x69, 0x2C, 0xBD, 0xEA, 0x7A, 0x77, 0xA8, 0x0D, 0xA7, 0x6E, 0x89, 0x55, 0x47, 0x5A, 0x97,
    0xF1, 0x66, 0x6E, 0x4D, 0x3E, 0x73, 0xA8, 0xBD, 0xD5, 0x39, 0xF8, 0x27, 0xC7, 0x11, 0xA4, 0xCA,
    0x27, 0x55, 0xEB, 0xFA, 0xC9, 0x17, 0xE9, 0x73, 0x4A, 0x13, 0xBA, 0xED, 0x50, 0xE3, 0xE2, 0xF0,
    0x13, 0x72, 0xEC, 0xEA, 0x1D, 0xB3, 0x52, 0x7F, 0x4E, 0x93, 0x9D, 0x20, 0x22, 0x2C, 0xCD, 0xDF,
    0x37, 0x3B, 0xFB, 0x81, 0x09, 0xD4, 0x3D, 0xD5, 0x00, 0x54, 0xCA, 0x45, 0xAE, 0x98, 0x5F, 0xAB,
    0x51, 0x6C, 0xE1, 0x66, 0xA0, 0x46, 0x43, 0xAC, 0xC4, 0x35, 0xAA, 0x21, 0xA4, 0x14, 0xCF, 0xA9,
    0x65, 0x03, 0xA5, 0x7B, 0x31, 0x18, 0x3D, 0x78, 0x38, 0x51, 0xE6, 0xBA, 0xF5, 0xCD, 0x98, 0x6F,
    0xB3, 0x3C, 0x93, 0xE8, 0x4F, 0x95, 0x43, 0xED, 0x3F, 0x07, 0x67, 0x54, 0xD3, 0x31, 0x72, 0xD2
};
static const uint8_t ARIA_GCM_128_1_IV[] =
{
    0xE1, 0x60, 0x1D, 0x66, 0x7B, 0x1E, 0x7C, 0xBE, 0x51, 0x3F, 0x73, 0x0E, 0x0A, 0x5A, 0x8C, 0xC2
};
static const uint8_t ARIA_GCM_128_1_H[] =
{
    0xC9, 0x36, 0xFF, 0x43, 0x1B, 0x31, 0x29, 0x11, 0xF1, 0x94, 0x59, 0xAA, 0xDC, 0x68, 0xE6, 0xD9
};
static const uint8_t ARIA_GCM_128_1_Y0[] =
{
    0x3D, 0xE9, 0x4D, 0x67, 0xFA, 0xDA, 0xEE, 0x8C, 0xD1, 0xBD, 0xA2, 0x7C, 0x7C, 0xCA, 0x6F, 0x9C
};
static const uint8_t ARIA_GCM_128_1_GH[] =
{
    0x9E, 0x6C, 0x63, 0x3C, 0xE0, 0xB1, 0xA1, 0xF5, 0x17, 0x9E, 0xFB, 0xA0, 0x6C, 0x96, 0x31, 0xDE
};
static const uint8_t ARIA_GCM_128_1_T[] =
{
    0xAF, 0x67, 0x18, 0xED, 0xBC, 0x85, 0x7B, 0x43, 0x8B, 0x41, 0xD5, 0xFE, 0x35, 0xA7, 0x6F, 0x03
};

/* ARIA128(GCM)VTEF COUNT = 0 */
static const uint8_t ARIA_GCM_128_2_K[] =
{
    0xE9, 0xFA, 0x38, 0x60, 0xB3, 0x06, 0x18, 0xF0, 0xAE, 0x53, 0xB8, 0xC0, 0x72, 0xAA, 0x09, 0x09
};
static const uint8_t ARIA_GCM_128_2_P[] =
{
    0xC8, 0x72, 0x93, 0x05, 0x9A, 0xCC, 0x50, 0xA8, 0x64, 0x95, 0xC3, 0x26, 0xA7, 0xD8, 0x19, 0x09,
    0x93, 0x94, 0xA7, 0x60, 0xCD, 0x6B, 0xD0, 0x12, 0x6F, 0x9E, 0x29, 0x71, 0x51, 0x39, 0xDB, 0x12,
    0x87, 0x8B, 0x49, 0xDD, 0x2A, 0xD9, 0xF3, 0x60, 0x5C, 0x54, 0x9A, 0x68, 0x86, 0x47, 0xA6, 0xD3,
    0xE4, 0x95, 0xC4, 0xA0, 0x44, 0x63, 0xD3, 0x48, 0x0A, 0x12, 0x01, 0x51, 0x78, 0x70, 0x31, 0x20,
    0x2C, 0x2F, 0xA1, 0x0F, 0xEA, 0x96, 0xC9, 0xBF, 0x9C, 0x76, 0x86, 0xB0, 0x97, 0x60, 0x77, 0x0E,
    0x20, 0x15, 0xA7, 0xCE, 0x2F, 0x3E, 0x6D, 0xFA, 0x73, 0x5D, 0x91, 0x49, 0x95, 0x04, 0xB0, 0xF3,
    0xC1, 0x45, 0xE2, 0xC3, 0x63, 0x69, 0x99, 0x6E, 0x2E, 0xE4, 0xCD, 0x23, 0x63, 0x89, 0x56, 0x63,
    0x50, 0xFB, 0x99, 0x13, 0x17, 0x64, 0x66, 0xD0, 0xB0, 0x69, 0x21, 0x82, 0x31, 0x5D, 0x20, 0x34
};
static const uint8_t ARIA_GCM_128_2_C[] =
{
    0x88, 0x9D, 0x11, 0x7C, 0xED, 0x3F, 0xA3, 0x06, 0x7C, 0xB7, 0x56, 0x17, 0x6C, 0x21, 0xA9, 0xCF,
    0x14, 0xD4, 0xD0, 0xC2, 0x24, 0x84, 0x5D, 0xF6, 0xA6, 0x65, 0x30, 0xB2, 0xF5, 0x06, 0x64, 0x0B,
    0xBD, 0xC9, 0x5C, 0xB5, 0xB9, 0xCC, 0x19, 0xE3, 0x95, 0x8F, 0xC7, 0xDC, 0x87, 0xCC, 0xF6, 0xB4,
    0x25, 0xAF, 0x0B, 0x6E, 0x5A, 0x46, 0x9F, 0x11, 0x4D, 0x56, 0x19, 0x2D, 0xA2, 0x35, 0xE1, 0x0F,
    0x3A, 0xDA, 0xAF, 0x72, 0x56, 0x60, 0x72, 0x87, 0x7E, 0x5F, 0x80, 0xC5, 0xE6, 0xA6, 0x89, 0x45,
    0x91, 0x3E, 0xCE, 0x80, 0x35, 0x63, 0x0E, 0xAC, 0x84, 0xB2, 0x3E, 0x4E, 0xC7, 0x69, 0x9F, 0x11,
    0xE3, 0xDF, 0xC1, 0x9B, 0xFA, 0xDB, 0xA9, 0xCE, 0xE4, 0xC7, 0x1F, 0x47, 0xFB, 0x21, 0xE4, 0xD8,
    0xE2, 0x3E, 0x2E, 0xA0, 0xFB, 0x2E, 0x34, 0x74, 0x14, 0x48, 0x37, 0x49, 0xCB, 0x1E, 0xD5, 0x88
};
static const uint8_t ARIA_GCM_128_2_A[] =
{
    0x4D, 0xB4, 0x55, 0x23, 0x1B, 0xBB, 0x2D, 0x14, 0x19, 0x87, 0xB7, 0xEB, 0x71, 0x2B, 0x09, 0x7A,
    0x7B, 0x2F, 0xE0, 0x97, 0x82, 0x3D, 0x86, 0x71, 0xCB, 0x1C, 0xF9, 0x24, 0xD3, 0xE3, 0x49, 0x8A,
    0xD9, 0x66, 0x42, 0x54, 0x9C, 0xF5, 0x4B, 0x5A, 0x66, 0x46, 0x8E, 0x30, 0x49, 0xAF, 0x59, 0xFA,
    0xA9, 0x98, 0xC4, 0x81, 0xFB, 0x31, 0x95, 0x86, 0xCB, 0x60, 0x60, 0x56, 0x04, 0xFE, 0xF3, 0x9E,
    0x6C, 0x42, 0xF1, 0x81, 0x6E, 0x7D, 0xBC, 0xE8, 0x1C, 0x08, 0x98, 0x19, 0x74, 0x7B, 0x0E, 0x8C,
    0xE2, 0x20, 0x8F, 0xF9, 0x07, 0xA8, 0x5A, 0xB6, 0xB9, 0x1C, 0xA0, 0x40, 0x4B, 0x16, 0xE5, 0x18,
    0x0E, 0x30, 0xA9, 0xD0, 0x17, 0xBD, 0x48, 0x65, 0x43, 0xB7, 0x1F, 0xCF, 0x79, 0xF9, 0xF0, 0xD7,
    0x2F, 0xAE, 0x87, 0x29, 0x30, 0x0A, 0x9E, 0xAA, 0x9C, 0x38, 0xFF, 0x0B, 0x30, 0x93, 0xE8, 0x9F
};
static const uint8_t ARIA_GCM_128_2_IV[] =
{
    0x25, 0x28, 0x07, 0xE7, 0x42, 0xEF, 0x9B, 0xAF, 0x99, 0x1B, 0xC0, 0x82, 0x98, 0xF8, 0xE6, 0x22
};
static const uint8_t ARIA_GCM_128_2_H[] =
{
    0x16, 0xC1, 0x50, 0x27, 0xB9, 0x33, 0x90, 0xEF, 0x1D, 0xFC, 0x9B, 0xE7, 0x47, 0x12, 0x42, 0x42
};
static const uint8_t ARIA_GCM_128_2_Y0[] =
{
    0xF8, 0x99, 0x14, 0x5D, 0x52, 0x21, 0xDB, 0xA2, 0x5C, 0x4C, 0x5A, 0xD0, 0x73, 0x3D, 0x85, 0xAD
};
static const uint8_t ARIA_GCM_128_2_GH[] =
{
    0x35, 0xC4, 0xEA, 0xC9, 0x59, 0xC0, 0x1E, 0x67, 0xB9, 0xB4, 0x96, 0xAD, 0x6D, 0xF8, 0xB4, 0x63
};
static const uint8_t ARIA_GCM_128_2_T[] =
{
    0x5D, 0x52, 0x92, 0xCA, 0x16, 0x3C, 0xE5, 0xE5, 0xDA, 0x7B, 0x03, 0x46, 0x4D, 0xDC, 0xA7, 0xAE
};


/* ARIA192(GCM)VTEF COUNT = 1 */
static const uint8_t ARIA_GCM_192_0_K[] =
{
    0xA3, 0x54, 0x34, 0x6C, 0x2C, 0xDE, 0x65, 0xAB, 0x3A, 0x96, 0xD5, 0xD0, 0xA5, 0x05, 0xB9, 0xD2,
    0xDD, 0xEA, 0xA6, 0x7A, 0xD1, 0x89, 0x9C, 0x5F
};
static const uint8_t ARIA_GCM_192_0_P[] = { };
static const uint8_t ARIA_GCM_192_0_C[] = { };
static const uint8_t ARIA_GCM_192_0_A[] =
{
    0x0E, 0x44, 0x54, 0xC2, 0x8A, 0x28, 0xE0, 0xAF, 0x46, 0xA7, 0x84, 0x9F, 0x2B, 0x1B, 0x05, 0xCA,
    0xE1, 0x96, 0xF7, 0x05, 0x38, 0xBD, 0x3F, 0x38, 0xC7, 0xDA, 0xD0, 0x11, 0xD3, 0x2C, 0xB8, 0xFA,
    0x72, 0x82, 0x60, 0x49, 0xEF, 0x08, 0x0F, 0xB7, 0x71, 0x60, 0xB1, 0x14, 0xD8, 0xF4, 0xD7, 0x39,
    0xE8, 0x8B, 0xFE, 0x3D, 0xA9, 0x1B, 0x14, 0xEC, 0x0D, 0xDE, 0x38, 0x74, 0xD4, 0xA8, 0xC2, 0x62,
    0xAD, 0x78, 0x83, 0xCD, 0x9E, 0x4D, 0x4E, 0xD1, 0xA5, 0x3B, 0xB6, 0x40, 0xA0, 0xBD, 0x1A, 0x93,
    0x6A, 0x4D, 0xDF, 0x27, 0x47, 0x32, 0xFD, 0xA6, 0x82, 0x9A, 0xBD, 0xC2, 0x54, 0xE8, 0xC1, 0x2A,
    0x08, 0x4F, 0x44, 0xB6, 0x5D, 0xA0, 0xA3, 0xE5, 0x2C, 0x60, 0x1C, 0x8A, 0x4A, 0x1E, 0xD6, 0xC2,
    0xB0, 0x03, 0x22, 0x29, 0xD9, 0xAB, 0x01, 0x4E, 0x6C, 0x33, 0xE6, 0x64, 0x1B, 0x94, 0xBD, 0x3A
};
static const uint8_t ARIA_GCM_192_0_IV[] =
{
    0x0F, 0x45, 0x43, 0x15, 0x2C, 0x71, 0x74, 0xA2, 0x66, 0x64, 0xFB, 0x31, 0x88, 0xCB, 0x9C, 0x0B
};
static const uint8_t ARIA_GCM_192_0_H[] =
{
    0xDA, 0xFD, 0xA6, 0x32, 0x79, 0x5D, 0x31, 0xC5, 0xA0, 0x32, 0x4B, 0x58, 0x6A, 0xE3, 0xA5, 0x2F
};
static const uint8_t ARIA_GCM_192_0_Y0[] =
{
    0xDC, 0xBF, 0x62, 0x66, 0x60, 0x7B, 0xE9, 0xE8, 0xA5, 0x68, 0xB6, 0x61, 0xCE, 0x8F, 0xEE, 0x05
};
static const uint8_t ARIA_GCM_192_0_GH[] =
{
    0xC2, 0xDF, 0x44, 0x82, 0x6D, 0x3B, 0x33, 0xCC, 0x02, 0x24, 0x96, 0xFB, 0x7C, 0x86, 0xF7, 0xBD
};
static const uint8_t ARIA_GCM_192_0_T[] =
{
    0xE5, 0xFB, 0x71, 0xB2, 0x23, 0x41, 0x87, 0xEA, 0x91, 0xA8, 0x14, 0xA5, 0x39, 0xDA, 0xB8, 0x24
};

/* ARIA192(GCM)VTEF COUNT = 1 */
static const uint8_t ARIA_GCM_192_1_K[] =
{
    0x08, 0x9A, 0x87, 0x84, 0x34, 0x5D, 0xA8, 0x24, 0x87, 0x07, 0xFC, 0x71, 0x06, 0x9C, 0x47, 0xAE,
    0x35, 0x9D, 0xD9, 0x7C, 0x7F, 0xDA, 0x0F, 0x51
};
static const uint8_t ARIA_GCM_192_1_P[] =
{
    0x7F, 0xD9, 0x5D, 0xCA, 0x86, 0x7D, 0x83, 0x5F, 0xF5, 0xE8, 0x5F, 0xB5, 0x6F, 0x3B, 0x5A, 0x24,
    0x44, 0x9E, 0xD1, 0x26, 0x4D, 0x8F, 0x15, 0x53, 0x18, 0x79, 0xB6, 0x90, 0x45, 0x89, 0x01, 0x83,
    0x30, 0xBD, 0xC7, 0x4A, 0xD1, 0x3E, 0x60, 0x6C, 0xE0, 0xEF, 0xF0, 0x0F, 0x3C, 0x46, 0xE9, 0x6C,
    0x8D, 0x5B, 0xD1, 0x81, 0x28, 0x3E, 0x46, 0x05, 0x34, 0x8E, 0x3F, 0xA1, 0x0B, 0x47, 0x94, 0x5D,
    0xE3, 0xDC, 0xC1, 0x59, 0xAE, 0x86, 0xE7, 0xBD, 0x3F, 0xDB, 0x13, 0xF2, 0xAD, 0xA2, 0xC3, 0x13,
    0xFC, 0xE6, 0xA6, 0x9E, 0xFA, 0x49, 0xA4, 0x70, 0x68, 0x9B, 0x1E, 0xF0, 0x5A, 0xAB, 0x77, 0x8A,
    0xE1, 0x5D, 0xD3, 0x5F, 0xE6, 0xFD, 0x1E, 0x3A, 0x59, 0xD3, 0x51, 0xC6, 0x8C, 0xF8, 0xF0, 0xFF,
    0xD9, 0x68, 0xD7, 0xE7, 0x8B, 0x57, 0x37, 0x7A, 0xFC, 0xC9, 0xDC, 0xE3, 0xFA, 0x5D, 0xB1, 0xF0
};
static const uint8_t ARIA_GCM_192_1_C[] =
{
    0x2B, 0x14, 0x43, 0x05, 0x84, 0x2E, 0x5B, 0xC8, 0x8B, 0xC5, 0x96, 0xB3, 0x68, 0xEF, 0x71, 0x2E,
    0x7B, 0xF9, 0x02, 0x0D, 0x27, 0x2B, 0x36, 0x53, 0x53, 0xA1, 0x10, 0xFD, 0x16, 0xF9, 0xC1, 0xCF,
    0xF6, 0x27, 0xB2, 0x1D, 0xE3, 0x49, 0x09, 0xB4, 0x08, 0x3C, 0xE2, 0xAA, 0x0E, 0x52, 0x5C, 0xA0,
    0x8A, 0x3F, 0x9C, 0x42, 0x09, 0x01, 0x88, 0x85, 0xFC, 0x87, 0xF5, 0x36, 0x26, 0x3C, 0x93, 0x6B,
    0x78, 0x9C, 0xFA, 0x6B, 0xE3, 0x28, 0xD4, 0x52, 0xCA, 0x01, 0x83, 0x7E, 0x1E, 0xB7, 0x5D, 0x13,
    0x37, 0x98, 0x5A, 0xF9, 0x76, 0x6D, 0x6E, 0x8A, 0x43, 0xFC, 0xFF, 0x53, 0x65, 0xAA, 0xF2, 0xFE,
    0x08, 0x40, 0x52, 0x59, 0x2D, 0x86, 0xFB, 0x05, 0xA5, 0xC3, 0x4C, 0xE5, 0x01, 0xFB, 0x48, 0x73,
    0xFE, 0x1F, 0x57, 0x34, 0xDA, 0x2F, 0x33, 0x92, 0x04, 0xB0, 0x57, 0x55, 0x04, 0xB6, 0x8B, 0x5E
};
static const uint8_t ARIA_GCM_192_1_A[] = { };
static const uint8_t ARIA_GCM_192_1_IV[] =
{
    0xD8, 0x88, 0x1C, 0x27, 0xA1, 0x93, 0x09, 0x71, 0xCC, 0x36, 0xFB, 0x53, 0x40, 0xC8, 0xB5, 0x12
};
static const uint8_t ARIA_GCM_192_1_H[] =
{
    0xFC, 0xC2, 0x9F, 0xCC, 0x50, 0xA4, 0x3D, 0xDF, 0xEC, 0x54, 0xAB, 0xA3, 0xF6, 0x85, 0x43, 0xEA
};
static const uint8_t ARIA_GCM_192_1_Y0[] =
{
    0xAC, 0xF6, 0xFD, 0xAA, 0x9A, 0x05, 0xD4, 0x8C, 0x69, 0xB7, 0x9B, 0xB1, 0x64, 0x04, 0x70, 0x7C
};
static const uint8_t ARIA_GCM_192_1_GH[] =
{
    0x90, 0xA5, 0xAA, 0x33, 0x75, 0x7B, 0xDB, 0x9B, 0x6E, 0x08, 0xD3, 0x06, 0x31, 0x19, 0xD2, 0xAC
};
static const uint8_t ARIA_GCM_192_1_T[] =
{
    0x65, 0x11, 0xA2, 0x31, 0x12, 0x95, 0xB9, 0xC0, 0x6A, 0x91, 0xC9, 0x64, 0xA9, 0x6B, 0xEE, 0x52
};

/* ARIA192(GCM)VTEF COUNT = 1 */
static const uint8_t ARIA_GCM_192_2_K[] =
{
    0xAA, 0x5C, 0xC4, 0xC1, 0x18, 0x5B, 0x2A, 0xA5, 0x69, 0xAF, 0x9C, 0x4C, 0xC6, 0xED, 0x26, 0x1E,
    0x3F, 0xF1, 0x08, 0xEC, 0xB5, 0x2E, 0xBA, 0xE1
};
static const uint8_t ARIA_GCM_192_2_P[] =
{
    0x1C, 0xDD, 0x36, 0x0A, 0xE4, 0x81, 0x98, 0x3D, 0x85, 0x39, 0xE6, 0x2F, 0x56, 0x0B, 0xE2, 0x2E,
    0xC3, 0xC6, 0xE7, 0xB4, 0xAB, 0xDD, 0x72, 0xDF, 0x07, 0x76, 0xE2, 0x21, 0xCD, 0xBF, 0x7C, 0x39,
    0x14, 0x81, 0xB2, 0x62, 0x78, 0xF7, 0xA5, 0xCA, 0xC0, 0xE0, 0xE8, 0x45, 0xBE, 0xD3, 0x87, 0x43,
    0x77, 0xD3, 0x48, 0x00, 0x84, 0x23, 0x30, 0xFA, 0xB8, 0x5B, 0x49, 0xA8, 0x03, 0xBC, 0xA3, 0x69,
    0x96, 0xC1, 0x99, 0xBB, 0x48, 0xF6, 0x55, 0xAD, 0x39, 0x0D, 0x97, 0x97, 0xB5, 0x2F, 0xB1, 0x08,
    0x5B, 0x90, 0xD7, 0x00, 0x7E, 0x46, 0x95, 0x5F, 0xCB, 0x5B, 0xA1, 0x9E, 0x2C, 0x21, 0xD3, 0xBD,
    0xED, 0xC5, 0x72, 0x7C, 0x1E, 0x27, 0xB1, 0xCE, 0x38, 0xE9, 0x79, 0x8B, 0x03, 0xC7, 0x69, 0x65,
    0xB6, 0x26, 0x1C, 0x1D, 0x60, 0xEF, 0xAA, 0xF7, 0x88, 0x9D, 0x71, 0x6B, 0x10, 0x95, 0x15, 0x1D
};
static const uint8_t ARIA_GCM_192_2_C[] =
{
    0xF2, 0x3F, 0x0B, 0x96, 0x38, 0x00, 0xC7, 0xC4, 0x51, 0x48, 0x9B, 0x66, 0xFD, 0x64, 0x93, 0x2C,
    0x12, 0x30, 0x55, 0x26, 0xB0, 0xDB, 0x5E, 0xFF, 0xCD, 0x8D, 0xF9, 0xD8, 0x0B, 0x93, 0xDF, 0xF2,
    0x39, 0x81, 0xED, 0x20, 0xD0, 0x5F, 0x52, 0x5D, 0x1B, 0x84, 0x5E, 0xCF, 0x5E, 0x11, 0x00, 0xDC,
    0xE8, 0x1E, 0xE7, 0x97, 0x1C, 0xCF, 0x52, 0x31, 0xFC, 0xC7, 0x10, 0x4E, 0x6B, 0xBE, 0x8A, 0x7E,
    0x7A, 0x3C, 0x9E, 0x7F, 0xE0, 0xE1, 0x6F, 0xF3, 0xFD, 0x4E, 0xFE, 0x78, 0xB3, 0x16, 0x2F, 0xC3,
    0x1E, 0xD6, 0xFE, 0xA1, 0x56, 0x83, 0x6B, 0xC4, 0x4C, 0x72, 0xF1, 0x5B, 0x33, 0x39, 0x48, 0x2B,
    0x7C, 0xAA, 0x03, 0x95, 0x53, 0x5A, 0x32, 0xBA, 0xE4, 0x62, 0x04, 0x15, 0x66, 0x9A, 0x56, 0xF9,
    0x66, 0xBE, 0x64, 0x1B, 0xC8, 0x4C, 0xED, 0xD9, 0xB4, 0x2F, 0x7E, 0x61, 0x25, 0xAA, 0x87, 0x6B
};
static const uint8_t ARIA_GCM_192_2_A[] =
{
    0x60, 0xB6, 0xC5, 0x0F, 0xC0, 0x32, 0xC0, 0x15, 0x04, 0x9C, 0x18, 0x8A, 0x6F, 0x42, 0xB6, 0x42,
    0xD2, 0xBC, 0x9F, 0xBF, 0xF4, 0xC5, 0x76, 0xA8, 0x36, 0x4A, 0x41, 0x76, 0x77, 0xC1, 0x70, 0x71,
    0x36, 0xBC, 0x1B, 0xDB, 0xF6, 0xBE, 0x8B, 0x6B, 0xE7, 0x4D, 0xFC, 0xFD, 0xC2, 0x48, 0xA1, 0x87,
    0xF5, 0x7B, 0xE9, 0x4F, 0x00, 0x71, 0x01, 0x5B, 0x1F, 0x89, 0x9A, 0x29, 0x29, 0x4C, 0xEC, 0xA1,
    0xB8, 0xFE, 0xFA, 0x48, 0x8A, 0x73, 0x18, 0xB6, 0x27, 0x25, 0xAB, 0x4A, 0xC4, 0x83, 0x31, 0x1C,
    0x68, 0x8B, 0x81, 0x33, 0x4D, 0x9A, 0x53, 0xF9, 0x89, 0x83, 0x02, 0xEB, 0xED, 0xDF, 0x91, 0x95,
    0x2E, 0xA5, 0xED, 0xBE, 0x42, 0xFB, 0x71, 0xE0, 0x0D, 0x4B, 0xAF, 0xDB, 0x3D, 0x98, 0x6E, 0xE9,
    0x73, 0x13, 0xEF, 0xD5, 0xA3, 0xE9, 0x75, 0x68, 0xBD, 0x60, 0x03, 0x25, 0x8D, 0x22, 0x68, 0x36
};
static const uint8_t ARIA_GCM_192_2_IV[] =
{
    0xF7, 0x42, 0x2D, 0xB6, 0x2B, 0xCD, 0x54, 0x26, 0x70, 0x84, 0xE3, 0xA2, 0xC1, 0x81, 0x57, 0x45
};
static const uint8_t ARIA_GCM_192_2_H[] =
{
    0x61, 0x39, 0x39, 0x93, 0xA9, 0x51, 0xA9, 0x2E, 0xC3, 0x43, 0x29, 0xA7, 0x99, 0x56, 0x8E, 0x7E
};
static const uint8_t ARIA_GCM_192_2_Y0[] =
{
    0xB8, 0xEE, 0xD8, 0xFF, 0x9A, 0x04, 0x61, 0x66, 0xC8, 0xD4, 0x76, 0xF0, 0x6C, 0xD1, 0x83, 0x04
};
static const uint8_t ARIA_GCM_192_2_GH[] =
{
    0x85, 0xBC, 0x79, 0x23, 0x42, 0xFA, 0x3A, 0x9D, 0xBA, 0x43, 0x95, 0xD0, 0x52, 0xCC, 0x4E, 0x06
};
static const uint8_t ARIA_GCM_192_2_T[] =
{
    0xD9, 0x12, 0x3C, 0x6D, 0xC4, 0xA2, 0xB7, 0x92, 0x7D, 0x57, 0xEB, 0x9E, 0x3B, 0x54, 0x60, 0x52
};

/* ARIA256(GCM)VTEF COUNT = 2 */
static const uint8_t ARIA_GCM_256_0_K[] =
{
    0xA8, 0x63, 0x7A, 0xD3, 0x9D, 0xAC, 0x6C, 0xCF, 0x6C, 0x35, 0x2C, 0xBD, 0x5A, 0x82, 0x3E, 0xDF,
    0x32, 0x84, 0xDE, 0x4E, 0x37, 0xBD, 0x96, 0x3E, 0x5E, 0xA5, 0x0F, 0x83, 0xBA, 0x4B, 0x28, 0x55
};
static const uint8_t ARIA_GCM_256_0_P[] = { };
static const uint8_t ARIA_GCM_256_0_C[] = { };
static const uint8_t ARIA_GCM_256_0_A[] =
{
    0x88, 0x2D, 0xE4, 0x3A, 0x78, 0xEE, 0x2C, 0x01, 0x81, 0xF6, 0xEB, 0x80, 0x19, 0x31, 0x6E, 0x97,
    0x2E, 0x27, 0x30, 0xAD, 0x18, 0x20, 0x63, 0xF8, 0xCC, 0x8B, 0xCD, 0xF8, 0x52, 0xA0, 0xD5, 0x45,
    0x79, 0x45, 0xDE, 0x8B, 0xC9, 0x2E, 0xD3, 0xD3, 0xB9, 0x49, 0x03, 0x04, 0x22, 0x59, 0x30, 0xA9,
    0xF4, 0xE0, 0xE2, 0xF4, 0x28, 0x43, 0x01, 0x03, 0xF5, 0x29, 0xA3, 0x63, 0x47, 0x24, 0x23, 0xD3,
    0x6D, 0x93, 0x73, 0x4A, 0x11, 0xC7, 0xB3, 0x3B, 0x6E, 0x64, 0x02, 0x17, 0xBD, 0x0A, 0x94, 0x14,
    0xF0, 0x35, 0x04, 0x2D, 0xA3, 0x62, 0xEC, 0x69, 0x50, 0x74, 0xB4, 0x61, 0xC2, 0x55, 0xA7, 0xFC,
    0xCC, 0xE0, 0x4C, 0x7E, 0x3A, 0xFF, 0xF3, 0xC1, 0x08, 0x10, 0x8E, 0xC1, 0xD2, 0x8E, 0xC2, 0x5F,
    0x8C, 0xED, 0x3E, 0x5E, 0x73, 0xC5, 0x4C, 0xB2, 0x43, 0x33, 0xA5, 0xFA, 0xAB, 0x7D, 0x8A, 0x4B
};
static const uint8_t ARIA_GCM_256_0_IV[] =
{
    0x38, 0x3F, 0x45, 0x50, 0x8C, 0xB0, 0xE9, 0xBE, 0x6B, 0xD2, 0x88, 0x19, 0xFB, 0x82, 0x96, 0xCC
};
static const uint8_t ARIA_GCM_256_0_H[] =
{
    0x74, 0xB3, 0x6A, 0xD7, 0x8C, 0xC4, 0x22, 0x4F, 0xE8, 0xE6, 0xD8, 0xA8, 0x94, 0xE4, 0x94, 0xAD
};
static const uint8_t ARIA_GCM_256_0_Y0[] =
{
    0x69, 0x6B, 0x6B, 0xD4, 0x0B, 0x4C, 0xC7, 0x7D, 0xDE, 0x08, 0xE3, 0xF8, 0xE7, 0xAF, 0x67, 0xF0
};
static const uint8_t ARIA_GCM_256_0_GH[] =
{
    0x07, 0x5E, 0xAB, 0xDE, 0x9A, 0x77, 0xA9, 0x40, 0xD5, 0xFD, 0xC3, 0xA9, 0xEE, 0x96, 0xC0, 0x6C
};
static const uint8_t ARIA_GCM_256_0_T[] =
{
    0x28, 0x83, 0xB3, 0xEE, 0xCB, 0xDA, 0xDA, 0x6D, 0x7E, 0x0A, 0x0F, 0x09, 0x48, 0xF3, 0xE4, 0x1D
};

/* ARIA256(GCM)VTEF COUNT = 2 */
static const uint8_t ARIA_GCM_256_1_K[] =
{
    0xC5, 0x15, 0x4D, 0xA0, 0x66, 0xC4, 0xC9, 0xCA, 0x47, 0x43, 0x24, 0x73, 0x60, 0xFC, 0x2D, 0xFC,
    0x1E, 0xF8, 0xDB, 0x4D, 0x58, 0x00, 0xE2, 0x1A, 0x84, 0x02, 0x88, 0x65, 0x2B, 0xB6, 0xB5, 0x45
};
static const uint8_t ARIA_GCM_256_1_P[] =
{
    0xC7, 0x06, 0x91, 0x88, 0x8B, 0xB7, 0xC5, 0x5A, 0x12, 0x74, 0xE3, 0x44, 0xC4, 0x4D, 0xC7, 0x86,
    0x72, 0x23, 0xE4, 0x98, 0x47, 0xC5, 0xD8, 0x6B, 0xFC, 0x59, 0x43, 0xF2, 0x4C, 0xFE, 0xDA, 0xE1,
    0xA8, 0xAF, 0xB7, 0xB5, 0x2B, 0x6A, 0xF3, 0xF4, 0xD0, 0x92, 0x77, 0xB6, 0xE3, 0x93, 0x0F, 0x64,
    0xB5, 0xC4, 0xC1, 0xC0, 0x94, 0x91, 0x5C, 0x25, 0xFA, 0xD9, 0x53, 0x10, 0x05, 0x95, 0xCC, 0xE0,
    0x27, 0xBB, 0xF5, 0xDA, 0x1F, 0x62, 0x97, 0x70, 0x28, 0x26, 0xED, 0xC3, 0x70, 0xCE, 0xB6, 0x66,
    0xCB, 0x2C, 0x89, 0x65, 0xA9, 0x45, 0x69, 0x86, 0x46, 0xB2, 0x99, 0xCE, 0x20, 0x46, 0xB1, 0x47,
    0xAE, 0xF1, 0xF2, 0x01, 0x4F, 0xE4, 0xD7, 0x57, 0x81, 0xF6, 0xEC, 0x73, 0x53, 0x47, 0xE3, 0x15,
    0x1D, 0x23, 0xE5, 0x8F, 0x6E, 0x29, 0x26, 0x15, 0x46, 0xAC, 0xBC, 0x33, 0x85, 0x59, 0xB1, 0x9F
};
static const uint8_t ARIA_GCM_256_1_C[] =
{
    0x5A, 0x33, 0xCF, 0x61, 0xEC, 0x9A, 0x04, 0x0F, 0x31, 0x7B, 0xE1, 0x8B, 0x4F, 0xE3, 0xF6, 0xC1,
    0xED, 0xFD, 0xC7, 0x34, 0x3D, 0x56, 0x04, 0xBF, 0x54, 0xEA, 0x1F, 0x7C, 0x49, 0xEB, 0x35, 0xE5,
    0xA3, 0xB4, 0xAF, 0xF4, 0x34, 0xA2, 0x3C, 0x79, 0x6E, 0xB3, 0x87, 0x3D, 0x06, 0x98, 0xAC, 0x98,
    0x23, 0xD9, 0x51, 0x36, 0x3A, 0xB5, 0xAA, 0xCB, 0xCA, 0x6A, 0x82, 0x2E, 0xEF, 0xAF, 0x90, 0xB2,
    0x6F, 0x2A, 0xB2, 0xE3, 0xAE, 0x1E, 0x6B, 0x53, 0xE7, 0x60, 0x85, 0x8B, 0x8E, 0xD6, 0x67, 0x3A,
    0x63, 0x1F, 0x62, 0x33, 0x88, 0xBF, 0x4F, 0x6B, 0x43, 0x82, 0x23, 0x9B, 0x02, 0xCB, 0x26, 0xA3,
    0xED, 0x00, 0x16, 0xBD, 0x62, 0x67, 0x5D, 0xF7, 0x69, 0x96, 0x1B, 0x1E, 0x87, 0xA4, 0x4E, 0xA5,
    0xF2, 0x6E, 0x04, 0xE2, 0x46, 0x4D, 0xA6, 0xD4, 0x11, 0xAB, 0xF1, 0x77, 0xE3, 0xFE, 0x4C, 0x5F
};
static const uint8_t ARIA_GCM_256_1_A[] = { };
static const uint8_t ARIA_GCM_256_1_IV[] =
{
    0x9A, 0x80, 0x4A, 0xE5, 0xDB, 0x99, 0xB4, 0xCF, 0xE3, 0x6A, 0xC1, 0x6B, 0x0D, 0x38, 0xB2, 0xC2
};
static const uint8_t ARIA_GCM_256_1_H[] =
{
    0xBD, 0xDC, 0xC2, 0x59, 0x35, 0x9B, 0x62, 0x9A, 0x0F, 0xAC, 0xB2, 0x93, 0xDE, 0x56, 0x11, 0xE6
};
static const uint8_t ARIA_GCM_256_1_Y0[] =
{
    0xB7, 0xA9, 0xE7, 0x7C, 0xFC, 0xF3, 0xE8, 0xB2, 0x48, 0x9E, 0x99, 0xFB, 0x7B, 0xA0, 0xE0, 0x2C
};
static const uint8_t ARIA_GCM_256_1_GH[] =
{
    0x05, 0xD6, 0x24, 0x34, 0x26, 0x71, 0xAE, 0x44, 0x98, 0x75, 0x92, 0xC0, 0xBA, 0x98, 0xD8, 0xB2
};
static const uint8_t ARIA_GCM_256_1_T[] =
{
    0xA1, 0x6E, 0xD5, 0xF9, 0x64, 0x48, 0xA6, 0x51, 0x65, 0xC2, 0xE2, 0x2F, 0x16, 0xAE, 0x30, 0x75
};

/* ARIA256(GCM)VTEF COUNT = 2 */
static const uint8_t ARIA_GCM_256_2_K[] =
{
    0xE5, 0xA1, 0xE4, 0x23, 0xFF, 0x90, 0x9E, 0xA1, 0xC0, 0xDB, 0x50, 0x10, 0x23, 0xE5, 0xE5, 0x81,
    0x86, 0xDB, 0xDF, 0x3A, 0xA5, 0xDF, 0xEE, 0xFE, 0xC9, 0x66, 0xC1, 0x8E, 0x3D, 0xDE, 0x1C, 0x6F
};
static const uint8_t ARIA_GCM_256_2_P[] =
{
    0xA6, 0xE7, 0x7C, 0x20, 0xB7, 0x5E, 0x5A, 0xFE, 0xF4, 0x60, 0x61, 0xFB, 0x0B, 0x38, 0xC7, 0x44,
    0xFE, 0x2B, 0xC9, 0xF2, 0x1C, 0x9F, 0x42, 0x44, 0x30, 0x83, 0x7B, 0x2C, 0xF8, 0xEA, 0x45, 0x0E,
    0xD8, 0xF9, 0x45, 0xC4, 0xD0, 0x04, 0x90, 0xE5, 0xAC, 0xF4, 0x78, 0x47, 0x7A, 0xEC, 0xA5, 0xC2,
    0x41, 0x2C, 0x67, 0x37, 0xF0, 0x35, 0x4A, 0xD1, 0x95, 0x2D, 0xEB, 0x8B, 0xCF, 0x86, 0x0B, 0xF3,
    0x86, 0xDB, 0xE2, 0x2D, 0xD9, 0x1A, 0xB5, 0x3A, 0x58, 0xE8, 0xAB, 0x7B, 0x74, 0x41, 0xDD, 0x70,
    0x33, 0x5F, 0xAC, 0xC6, 0x29, 0xDE, 0x57, 0x91, 0xA3, 0x1D, 0xCD, 0xD6, 0x25, 0xE7, 0xBF, 0x4C,
    0x17, 0x53, 0xFA, 0x63, 0xBB, 0xE8, 0xF4, 0x86, 0x62, 0x05, 0xA4, 0x9D, 0xE0, 0x80, 0x97, 0xD7,
    0x3D, 0x8E, 0x41, 0xA6, 0xAD, 0xE3, 0x91, 0x0B, 0xC2, 0x1A, 0xC8, 0x13, 0xE1, 0x56, 0x8A, 0xA2
};
static const uint8_t ARIA_GCM_256_2_C[] =
{
    0xB1, 0xAB, 0x45, 0x33, 0xFC, 0x75, 0xD6, 0x8B, 0x2F, 0x8F, 0xB5, 0xE6, 0x0F, 0xED, 0x95, 0x11,
    0x9B, 0x42, 0x8F, 0x80, 0x49, 0xE1, 0x76, 0x1E, 0x5D, 0xAC, 0x45, 0xEC, 0xFB, 0x78, 0x2F, 0x9C,
    0x03, 0x76, 0x2D, 0xD3, 0x43, 0x2B, 0xA2, 0xEC, 0x6B, 0x1B, 0x22, 0x07, 0x35, 0xFC, 0x51, 0x97,
    0x2D, 0xF7, 0x76, 0x9B, 0xE1, 0xD3, 0x27, 0x1F, 0x01, 0x87, 0xC6, 0x1B, 0x7F, 0x39, 0x98, 0x32,
    0x12, 0x93, 0xEE, 0x1F, 0xC8, 0x21, 0xD3, 0x8F, 0x9D, 0x7F, 0xEE, 0x47, 0xC9, 0x5A, 0x2E, 0x14,
    0x53, 0xC0, 0x37, 0xEC, 0xF3, 0xDD, 0x4D, 0x1E, 0xD9, 0x1C, 0x1E, 0x8D, 0x1A, 0xA7, 0x87, 0xA7,
    0x43, 0x24, 0x51, 0x9A, 0x22, 0xA2, 0xEF, 0xAB, 0xD6, 0x81, 0x2D, 0x25, 0x42, 0x28, 0x69, 0xF4,
    0xCC, 0x19, 0x49, 0x4A, 0x5E, 0xED, 0x73, 0xF2, 0x7E, 0x98, 0x9A, 0x06, 0xA8, 0xCC, 0x09, 0x01
};
static const uint8_t ARIA_GCM_256_2_A[] =
{
    0xF3, 0x2A, 0x35, 0x6F, 0x5C, 0xB6, 0x73, 0x50, 0x31, 0x13, 0x0B, 0xB8, 0xA5, 0xF2, 0xFD, 0x7D,
    0xC5, 0x7F, 0xCD, 0xDF, 0x66, 0x8C, 0x1F, 0xC7, 0x5B, 0xEB, 0x84, 0x4C, 0xEB, 0x1B, 0x94, 0x7B,
    0x82, 0x28, 0x3D, 0x58, 0xA6, 0xCC, 0x5A, 0x20, 0x2D, 0xDA, 0x87, 0xD1, 0xAD, 0xDC, 0x34, 0xEC,
    0x35, 0xFB, 0xF9, 0x7A, 0x3A, 0x20, 0x29, 0x4D, 0xD4, 0x59, 0xAA, 0x88, 0x2B, 0x7E, 0x04, 0x62,
    0x2B, 0x14, 0xB7, 0x26, 0x80, 0x71, 0xD2, 0x7E, 0xBE, 0x21, 0xC1, 0xF2, 0xDF, 0x89, 0x67, 0xAC,
    0xF3, 0xCA, 0x6D, 0x7E, 0x13, 0xE9, 0xD9, 0x26, 0x97, 0x2C, 0xE2, 0xD0, 0x89, 0xC7, 0x02, 0xDC,
    0x59, 0xB7, 0x4E, 0xE2, 0xD1, 0xEF, 0x03, 0xF3, 0x4C, 0xB2, 0x61, 0x22, 0x23, 0x40, 0xBC, 0x43,
    0x69, 0xB4, 0xD0, 0xF3, 0xD8, 0x2D, 0x55, 0xD9, 0x0A, 0x2C, 0xD3, 0x2B, 0xED, 0x3D, 0xB8, 0x73
};
static const uint8_t ARIA_GCM_256_2_IV[] =
{
    0x02, 0x95, 0x2B, 0xEE, 0xC3, 0xD6, 0x16, 0x62, 0x0B, 0x55, 0xD5, 0xB1, 0xB6, 0xCC, 0x46, 0x15
};
static const uint8_t ARIA_GCM_256_2_H[] =
{
    0xB7, 0x35, 0x74, 0x15, 0x51, 0x05, 0xB3, 0x98, 0xDB, 0xC8, 0x25, 0x95, 0x2C, 0xD5, 0xCC, 0x3F
};
static const uint8_t ARIA_GCM_256_2_Y0[] =
{
    0x6A, 0x4E, 0xC8, 0xFC, 0x7B, 0x4A, 0x77, 0x13, 0x0F, 0xA2, 0x48, 0xDD, 0x98, 0xD8, 0x24, 0x14
};
static const uint8_t ARIA_GCM_256_2_GH[] =
{
    0xCA, 0xF0, 0xA7, 0x8B, 0x7A, 0x1A, 0x5F, 0x40, 0xC7, 0xC2, 0xB3, 0x11, 0x89, 0x17, 0xC5, 0x5C
};
static const uint8_t ARIA_GCM_256_2_T[] =
{
    0x6C, 0x06, 0xBB, 0xDC, 0x5C, 0x8A, 0x23, 0x7F, 0xE6, 0xEF, 0x36, 0xBF, 0xB4, 0xAB, 0x54, 0xA4
};

/* ARIA GCM vectors with 12 byte IV */

/* 128 BIT */
static const uint8_t ARIA_GCM_128_3_K[] =
{
    0xBE, 0x96, 0xC0, 0xA1, 0x94, 0xE5, 0xA8, 0xAC, 0x63, 0xE6, 0x95, 0x55, 0x5D, 0x59, 0x58, 0xF4
};
static const uint8_t ARIA_GCM_128_3_P[] = {
    0x0C, 0x79, 0x71, 0x40, 0x61, 0x41, 0x09, 0xEA, 0x46, 0x2A, 0xC8, 0x7D, 0x65, 0x82, 0xD8, 0x42,
    0x73, 0x82, 0xA0, 0xDB, 0x1C, 0x73, 0x50, 0x83, 0x39, 0x14, 0xB9, 0x97, 0x49, 0x40, 0x63, 0x56,
    0x1F, 0xCC, 0xD9, 0xE5, 0xD8, 0xAF, 0x48, 0x95, 0x10, 0x65, 0x48, 0x69, 0x56, 0x95, 0xFA, 0xD3,
    0xDC, 0xF1, 0x53, 0xBF, 0x73, 0x5D, 0xB7, 0xD2, 0xB7, 0x54, 0xCA, 0xF4, 0x87, 0x88, 0x83, 0x0C,
    0xB9, 0xC9, 0x82, 0x0A, 0x0B, 0x28, 0xA3, 0x2B, 0x5C, 0x5C, 0xD3, 0x78, 0x1C, 0x65, 0x22, 0x91,
    0x01, 0x6F, 0x1A, 0xA8, 0xFB, 0xF8, 0x4F, 0xD0, 0x6B, 0x35, 0x38, 0x78, 0x90, 0xB2, 0x3D, 0x32,
    0x41, 0x3A, 0x11, 0xBA, 0xE2, 0xF6, 0x42, 0x33, 0x91, 0xD8, 0x0F, 0xB3, 0xA0, 0x3B, 0x79, 0x02,
    0x48, 0xC3, 0x9D, 0x9F, 0x9B, 0x8B, 0x40, 0x04, 0xBB, 0x7F, 0xAC, 0x2B, 0x4A, 0x06, 0xBB, 0x51
};
static const uint8_t ARIA_GCM_128_3_C[] =
{
    0xF1, 0xAC, 0x68, 0x22, 0x9D, 0xF0, 0xDF, 0xD1, 0x66, 0x71, 0xAD, 0xE5, 0xD4, 0x0C, 0x7C, 0xB7,
    0x23, 0xBC, 0x1B, 0x2F, 0x54, 0x8A, 0xB0, 0xE9, 0x7F, 0x88, 0x7D, 0x9E, 0x48, 0x7F, 0x45, 0x19,
    0xA3, 0x5C, 0x6C, 0xD6, 0xFF, 0xFB, 0xCD, 0x8F, 0xCE, 0xE9, 0xE1, 0x9B, 0x4B, 0xFA, 0x04, 0x84,
    0x8A, 0x58, 0xB4, 0x58, 0x2E, 0xBE, 0x9E, 0x0E, 0x96, 0x5A, 0xEC, 0xBF, 0x7A, 0x16, 0xC5, 0x77,
    0xC5, 0x85, 0x1B, 0x11, 0x3C, 0x2F, 0x0B, 0x09, 0xCA, 0xC1, 0x22, 0x59, 0x69, 0xCA, 0x6B, 0x85,
    0x00, 0xDC, 0x9E, 0xDE, 0x95, 0x0B, 0x30, 0xA9, 0x42, 0x4D, 0xB5, 0x12, 0x78, 0x3E, 0x98, 0x03,
    0x27, 0x64, 0x39, 0x5B, 0xDE, 0xA2, 0xAE, 0x33, 0x8E, 0x6F, 0x38, 0xAA, 0x68, 0x60, 0x6B, 0xA8,
    0x77, 0x38, 0xF6, 0x59, 0xBB, 0xAB, 0xA4, 0x8D, 0xEB, 0x19, 0x8C, 0xAD, 0x92, 0x4C, 0xD3, 0x9C
};
static const uint8_t ARIA_GCM_128_3_A[] =
{
    0x21, 0xE5, 0x31, 0xFA, 0x45, 0x60, 0x4E, 0x35, 0x16, 0xA1, 0xA4, 0x21, 0xCA, 0x5E, 0x27, 0xB0, 0x1A,
    0xB7, 0x83, 0xAB, 0x3B, 0x5D, 0xB2, 0xF7, 0x10, 0xF9, 0xCD, 0x16, 0x9E, 0xCC, 0x22, 0xF0, 0xC0, 0x92,
    0x88, 0xD4, 0x1C, 0xAD, 0xEF, 0xBA, 0x55, 0x7F, 0x3B, 0xCB, 0x83, 0x18, 0x53, 0x23, 0xE0, 0x11, 0x74,
    0xD5, 0xC3, 0xB7, 0xCC, 0x2F, 0xD3, 0x6D, 0x44, 0x40, 0x74, 0x4B, 0x9D, 0x98, 0x86, 0x0B, 0xBE, 0x4F,
    0x4F, 0x26, 0x4C, 0x49, 0xB5, 0x3A, 0x7C, 0xB7, 0xB1, 0xAF, 0x25, 0xE1, 0x00, 0x9A, 0x1A, 0x24, 0x1C,
    0xE1, 0xB6, 0x36, 0x6A, 0xA1, 0xB8, 0xB2, 0xB5, 0xCC, 0x51, 0xD0, 0xDB, 0x17, 0x7C, 0x73, 0xC6, 0x13,
    0x8E, 0x6A, 0x9E, 0x99, 0x0E, 0xEF, 0x3D, 0x6C, 0xC6, 0x74, 0xE4, 0x1A, 0x1A, 0xA0, 0x2C, 0x23, 0x99,
    0x94, 0x3F, 0x5D, 0xD2, 0x72, 0x47, 0x97, 0x69, 0x20
};
static const uint8_t ARIA_GCM_128_3_IV[] =
{
    0x0C, 0xEF, 0xF0, 0x5A, 0x88, 0xAD, 0x5E, 0x5A, 0xED, 0x92, 0xB5, 0x88
};
static const uint8_t ARIA_GCM_128_3_H[] =
{
    0xF5, 0x2B, 0x54, 0x14, 0x7B, 0x1D, 0x99, 0x08, 0x45, 0x5A, 0xD3, 0x59, 0xF3, 0xE1, 0x0A, 0x1B
};
static const uint8_t ARIA_GCM_128_3_Y0[] =
{
    0x0C, 0xEF, 0xF0, 0x5A, 0x88, 0xAD, 0x5E, 0x5A, 0xED, 0x92, 0xB5, 0x88, 0x00, 0x00, 0x00, 0x01
};
static const uint8_t ARIA_GCM_128_3_GH[] ={ };
static const uint8_t ARIA_GCM_128_3_T[] =
{
    0x1F, 0x79, 0x3D, 0xD9, 0xBB, 0xF2, 0x06, 0xC8, 0x1E, 0x0B, 0x46, 0xB2, 0x5D, 0x50, 0x03, 0x28
};

/* 192 BIT */

static const uint8_t ARIA_GCM_192_3_K[] =
{
    0x1B, 0x0E, 0x30, 0x42, 0x55, 0x34, 0x80, 0x4E, 0x80, 0x08, 0x43, 0x8C, 0x7A, 0x41, 0x64, 0x06,
    0xB3, 0xDF, 0xF4, 0x5B, 0xE1, 0x0E, 0x7D, 0xC0
};
static const uint8_t ARIA_GCM_192_3_P[] =
{
    0x66, 0x0D, 0xD8, 0xA5, 0x5F, 0xBE, 0x2A, 0xBC, 0x37, 0x26, 0x67, 0xE9, 0x3F, 0x9D, 0x93, 0xF5,
    0xB0, 0xCA, 0xC7, 0x5F, 0x9D, 0xC7, 0xCC, 0xA1, 0x25, 0x80, 0xE9, 0xB5, 0xED, 0x5C, 0xF8, 0xD8,
    0xCE, 0x20, 0xBF, 0x8E, 0xCA, 0x10, 0x7E, 0xE6, 0x45, 0x57, 0xC5, 0xFF, 0x71, 0xA8, 0x88, 0xCB,
    0x0B, 0x26, 0x75, 0x13, 0x45, 0x81, 0x85, 0xBB, 0x03, 0x62, 0xD2, 0x48, 0x49, 0x0A, 0xA8, 0x9F,
    0xF4, 0x36, 0xDE, 0x0F, 0xA9, 0x45, 0x67, 0x92, 0x0C, 0x9C, 0x24, 0x50, 0x32, 0x4A, 0xFC, 0x65,
    0x58, 0xE8, 0x2F, 0xE4, 0xD5, 0xC3, 0xE7, 0x1C, 0x4D, 0x3E, 0x11, 0x1A, 0x28, 0x71, 0x6A, 0x6F,
    0x42, 0x16, 0xDD, 0x33, 0xE4, 0xA6, 0x0C, 0x49, 0xF4, 0xBF, 0x2D, 0xE5, 0x68, 0xC9, 0x17, 0x4C,
    0x00, 0xD9, 0x9C, 0xDB, 0x35, 0xD5, 0x1A, 0x4B, 0x6D, 0xDA, 0x4D, 0x33, 0x70, 0xDA, 0x67, 0xCE
};
static const uint8_t ARIA_GCM_192_3_C[] =
{
    0xA5, 0x5C, 0x0F, 0xB8, 0x44, 0x10, 0x71, 0x1A, 0x6C, 0xC4, 0xEE, 0x55, 0x67, 0x35, 0xF8, 0xB9,
    0x25, 0xA7, 0x81, 0x4A, 0xB9, 0xD2, 0xAF, 0xF9, 0xEB, 0x00, 0x4A, 0x46, 0x8A, 0x1E, 0x92, 0x32,
    0x9C, 0x2F, 0x91, 0xB8, 0xBA, 0x1F, 0x2A, 0x55, 0x98, 0xA5, 0xAE, 0xDB, 0x0A, 0x52, 0x5E, 0xC8,
    0xAF, 0x8C, 0x3F, 0xCA, 0xF4, 0x8E, 0x73, 0x6F, 0x8F, 0xA8, 0x3E, 0x20, 0x5C, 0x98, 0xBC, 0xA2,
    0xC5, 0x77, 0xA8, 0x57, 0xE8, 0x31, 0x07, 0xAD, 0xDE, 0x66, 0x4F, 0xDD, 0x39, 0x06, 0xCF, 0x89,
    0xD4, 0xEC, 0x8C, 0x3B, 0x49, 0x4B, 0x6B, 0x3D, 0x0D, 0xE1, 0xC7, 0xDE, 0xDC, 0x05, 0x87, 0x5B,
    0x5D, 0x1E, 0xE3, 0xC0, 0xA8, 0xE4, 0xF5, 0x1D, 0x95, 0x8A, 0xEB, 0xB4, 0x5E, 0x89, 0x4C, 0x71,
    0xDC, 0x20, 0x24, 0x9F, 0xF8, 0x16, 0xA8, 0xFC, 0xE6, 0x6B, 0x61, 0x39, 0x5C, 0xEA, 0x06, 0x3B
};
static const uint8_t ARIA_GCM_192_3_A[] =
{
    0x1F, 0x8A, 0x63, 0xFF, 0x64, 0x7B, 0x96, 0x92, 0x65, 0x86, 0x87, 0xC5, 0xFD, 0x6E, 0x00, 0x07,
    0x6C, 0xC1, 0x65, 0xFF, 0x4D, 0xFF, 0x45, 0xD0, 0xC9, 0xFE, 0x2F, 0x9C, 0x0B, 0x8D, 0xC7, 0x47,
    0xF3, 0x58, 0x18, 0x7D, 0x0F, 0x0C, 0x2C, 0xF6, 0xC7, 0xBB, 0xDA, 0xF8, 0xD7, 0x81, 0xE0, 0x1E,
    0x03, 0x68, 0x32, 0x59, 0x05, 0x89, 0x91, 0x34, 0xCB, 0x74, 0x5E, 0x5C, 0xDF, 0xD2, 0xB1, 0x5F,
    0x27, 0x49, 0xA6, 0xB4, 0xCE, 0xA0, 0xF7, 0xFC, 0x82, 0x24, 0xD0, 0x87, 0xE0, 0x4A, 0xDE, 0x1A,
    0x2C, 0x95, 0xAA, 0xEF, 0x46, 0xBA, 0x25, 0xFE, 0xD9, 0x03, 0x83, 0x7B, 0xD6, 0xF1, 0x4D, 0xA0,
    0x21, 0x25, 0xB2, 0xAC, 0x8A, 0x80, 0x1F, 0x2C, 0xFE, 0x8A, 0x0F, 0x79, 0xFE, 0x10, 0x23, 0x82,
    0x51, 0x12, 0x75, 0xCB, 0xF6, 0xDC, 0x2A, 0xB6, 0x5D, 0x72, 0x46, 0x02, 0xD7, 0x31, 0xC4, 0x91
};
static const uint8_t ARIA_GCM_192_3_IV[] =
{
    0xF5, 0x4C, 0x93, 0x45, 0x4D, 0xCE, 0xAD, 0x5A, 0x2B, 0x20, 0x33, 0x91
};
static const uint8_t ARIA_GCM_192_3_H[] =
{
    0x4B, 0x4E, 0x86, 0xAB, 0x6B, 0x7B, 0x83, 0xA2, 0xE1, 0xEA, 0xF4, 0x6A, 0x1E, 0x71, 0x02, 0x80
};
static const uint8_t ARIA_GCM_192_3_Y0[] =
{
    0xF5, 0x4C, 0x93, 0x45, 0x4D, 0xCE, 0xAD, 0x5A, 0x2B, 0x20, 0x33, 0x91, 0x00, 0x00, 0x00, 0x01
};
static const uint8_t ARIA_GCM_192_3_GH[] = { };
static const uint8_t ARIA_GCM_192_3_T[] =
{
    0x41, 0xF0, 0x90, 0xCC, 0x86, 0x7C, 0x15, 0x04, 0x0F, 0x24, 0x63, 0xAD, 0xFB, 0x2B, 0xEF, 0xE9
};

/* 256 BIT */

static const uint8_t ARIA_GCM_256_3_K[] =
{
    0x4E, 0xA5, 0x59, 0x80, 0xF5, 0xCB, 0xD7, 0x79, 0xF5, 0x48, 0x2E, 0x4E, 0x29, 0xD9, 0x35, 0x4B,
    0x37, 0xDD, 0xDF, 0x6B, 0xC2, 0xB9, 0x0D, 0xD6, 0xE1, 0x7C, 0xA6, 0xA8, 0xD0, 0xBF, 0xEA, 0xF4
};
static const uint8_t ARIA_GCM_256_3_P[] =
{
    0xFF, 0x21, 0xFC, 0x16, 0x7A, 0x26, 0xCC, 0x4A, 0x32, 0x44, 0xDD, 0x13, 0x20, 0xE3, 0x09, 0xB6,
    0x01, 0x18, 0x1F, 0x93, 0x4E, 0xCA, 0x7E, 0x60, 0x6F, 0x13, 0xE2, 0xB5, 0x2C, 0xE8, 0x7D, 0xCD,
    0x64, 0xFD, 0x4A, 0x8B, 0x01, 0xE3, 0x9E, 0xBB, 0x2B, 0x73, 0x00, 0x9B, 0xBC, 0x70, 0x3A, 0x99,
    0xF4, 0x68, 0xB0, 0x5F, 0x6F, 0xDB, 0xF1, 0x0D, 0x53, 0xA0, 0x8C, 0xC5, 0xCE, 0x83, 0x25, 0x6D,
    0xC0, 0x33, 0xC7, 0xB0, 0xB4, 0x5C, 0x7C, 0x46, 0x15, 0x10, 0x1B, 0x76, 0x9F, 0x6B, 0x62, 0xD9,
    0x13, 0x77, 0x44, 0x60, 0x2F, 0x4D, 0x84, 0x98, 0xDD, 0x7D, 0x83, 0x2D, 0xAB, 0xB0, 0x57, 0xAE,
    0x7B, 0x8C, 0x1C, 0x8F, 0x7B, 0xD8, 0x8F, 0x74, 0x58, 0xE1, 0xD9, 0xAD, 0xAF, 0x1C, 0xA8, 0xFC,
    0xC5, 0x0C, 0x84, 0x9F, 0x77, 0x66, 0x61, 0x8A, 0x74, 0x74, 0x70, 0xF5, 0xA9, 0xB7, 0x3B, 0x16
};
static const uint8_t ARIA_GCM_256_3_C[] =
{
    0x29, 0xC1, 0xF5, 0xF4, 0xE1, 0xEA, 0xB1, 0xEC, 0x33, 0x95, 0xC2, 0x55, 0xEB, 0x25, 0x6B, 0x22,
    0x62, 0x40, 0x28, 0xBC, 0x0F, 0x1F, 0x91, 0xE5, 0x9B, 0x2E, 0x07, 0x27, 0x41, 0x51, 0x59, 0x7D,
    0xBC, 0xC1, 0x40, 0x14, 0x86, 0x31, 0xDB, 0xFD, 0xDC, 0x28, 0x0C, 0xFD, 0xF4, 0x5E, 0xE2, 0xE1,
    0x33, 0xD3, 0xDF, 0xB4, 0xD0, 0x51, 0xCB, 0x22, 0xDD, 0x27, 0xD0, 0x72, 0x14, 0xC8, 0x31, 0x79,
    0x63, 0x4E, 0x88, 0xC8, 0x9A, 0xFC, 0xAD, 0x4C, 0x37, 0xC7, 0x63, 0x16, 0x12, 0x46, 0x9B, 0xBE,
    0x58, 0x0D, 0x0B, 0xE8, 0x4E, 0xF5, 0xAC, 0x4A, 0xC7, 0x44, 0x2E, 0x11, 0xEB, 0x6B, 0xF1, 0xB9,
    0x5D, 0x28, 0x0D, 0x6E, 0xFD, 0xD6, 0xF9, 0xF8, 0xBE, 0x53, 0x9A, 0xB9, 0x36, 0x59, 0x6A, 0xBC,
    0xBE, 0x50, 0x3C, 0x9C, 0x35, 0x8D, 0xBB, 0xE0, 0x96, 0xFA, 0x78, 0xC3, 0xA1, 0xF7, 0xDD, 0xA1
};
static const uint8_t ARIA_GCM_256_3_A[] =
{
    0xFD, 0xD0, 0xF1, 0x30, 0x3F, 0xA1, 0xFE, 0xCC, 0x5C, 0xAF, 0xDF, 0x46, 0xD6, 0xCA, 0x35, 0x8C,
    0x71, 0xF1, 0x18, 0x23, 0x30, 0x70, 0xAD, 0x6B, 0x7F, 0x4B, 0xFB, 0x23, 0xB2, 0xDF, 0xFA, 0x2F,
    0xAE, 0xC7, 0xED, 0x99, 0xE6, 0xFD, 0xF2, 0xD7, 0x8A, 0x41, 0xD8, 0x4C, 0xFA, 0xBF, 0x30, 0x11,
    0x81, 0xEC, 0xA7, 0xF4, 0x40, 0xB1, 0x93, 0xC1, 0x68, 0xCB, 0xCB, 0xC1, 0xAD, 0x72, 0xBC, 0x81,
    0xF7, 0x38, 0xB9, 0xD4, 0x5A, 0x35, 0x93, 0x1B, 0x48, 0x61, 0x6A, 0xC4, 0x05, 0x41, 0xC2, 0x11,
    0x5C, 0xC6, 0xD9, 0x1B, 0x91, 0x72, 0x39, 0x16, 0x96, 0xBC, 0x89, 0xD6, 0x81, 0xB6, 0xA8, 0x92,
    0x3E, 0xED, 0xFD, 0xE9, 0x81, 0x90, 0x08, 0x22, 0xFF, 0xD5, 0x3D, 0xB8, 0xDE, 0x99, 0x13, 0x16,
    0x6A, 0x47, 0x58, 0x9F, 0x09, 0xFA, 0xC7, 0xF1, 0x71, 0xE6, 0xDC, 0x6B, 0x18, 0xF4, 0xE7, 0xED
};
static const uint8_t ARIA_GCM_256_3_IV[] =
{
    0xE6, 0xD0, 0x03, 0x09, 0xC7, 0x0F, 0xDD, 0xF3, 0xDB, 0x97, 0x38, 0x45
};
static const uint8_t ARIA_GCM_256_3_H[] =
{
    0xB8, 0x26, 0xA3, 0x2A, 0xBE, 0x34, 0xAD, 0xFC, 0xA7, 0x3F, 0x03, 0x97, 0xB7, 0x9F, 0x59, 0x9B
};
static const uint8_t ARIA_GCM_256_3_Y0[] =
{
    0xE6, 0xD0, 0x03, 0x09, 0xC7, 0x0F, 0xDD, 0xF3, 0xDB, 0x97, 0x38, 0x45, 0x00, 0x00, 0x00, 0x01
};
static const uint8_t ARIA_GCM_256_3_GH[] ={ };
static const uint8_t ARIA_GCM_256_3_T[] =
{
    0x9D, 0x0A, 0x79, 0x6D, 0x9F, 0xBE, 0x20, 0x98, 0x1B, 0xBC, 0x29, 0xFF, 0x53, 0x92, 0x9E, 0x77
};

/* end of file testvectors_aria_gcm_data.h */
