/* testvectors_aria_ccm_data.h
 *
 * Description: Test vectors for ARIA CCM, test vector contents.
 */

/* -------------------------------------------------------------------------- */
/*                                                                            */
/*   Module        : DDK-130_bsd                                              */
/*   Version       : 4.1.1                                                    */
/*   Configuration : DDK_EIP130_BSD                                           */
/*                                                                            */
/*   Date          : 2023-Mar-10                                              */
/*                                                                            */
/* Copyright (c) 2014-2023 by Rambus, Inc. and/or its subsidiaries.           */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or without         */
/* modification, are permitted provided that the following conditions are     */
/* met:                                                                       */
/*                                                                            */
/* 1. Redistributions of source code must retain the above copyright          */
/* notice, this list of conditions and the following disclaimer.              */
/*                                                                            */
/* 2. Redistributions in binary form must reproduce the above copyright       */
/* notice, this list of conditions and the following disclaimer in the        */
/* documentation and/or other materials provided with the distribution.       */
/*                                                                            */
/* 3. Neither the name of the copyright holder nor the names of its           */
/* contributors may be used to endorse or promote products derived from       */
/* this software without specific prior written permission.                   */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR      */
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT       */
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,     */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           */
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,      */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      */
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      */
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.       */
/* -------------------------------------------------------------------------- */

#include <third_party/hsmddk/include/Kit/DriverFramework/Basic_Defs_API/incl/basic_defs.h>

/* ARIA128(CCM)GE COUNT = 15 */
static const uint8_t ARIA_CCM_128_1_K[] =
{
    0x28, 0x02, 0xA1, 0x0F, 0xF8, 0xE2, 0x00, 0x32, 0x0B, 0x7A, 0xF4, 0x89, 0x37, 0x14, 0xCA, 0x2F
};
static const uint8_t ARIA_CCM_128_1_N[] =
{
    0x99, 0x80, 0x12, 0xEE, 0xF6, 0x9A, 0x35
};
static const uint8_t ARIA_CCM_128_1_A[] =
{
    0x0D, 0x58, 0x16, 0x32, 0xD0, 0xCB, 0xDD, 0x9B, 0x09, 0xAB, 0xCA, 0x8B, 0xEC, 0x67, 0x07, 0xAB
};
static const uint8_t ARIA_CCM_128_1_P[] =
{
    0x88, 0x1D, 0xD1, 0x03, 0x0A, 0xFA, 0xF2, 0xA9, 0x46, 0xCE, 0xBA, 0x08, 0x82, 0xAB, 0xAE, 0xD8
};
static const uint8_t ARIA_CCM_128_1_C[] =
{
    0xAC, 0xFB, 0x80, 0x4F, 0x7F, 0x0D, 0x37, 0xD0, 0x56, 0x90, 0x95, 0x17, 0xA6, 0xC1, 0x46, 0x6F,
    0x48, 0x14, 0x5C, 0xA1, 0x88, 0x61, 0x5D, 0x1D, 0x53, 0x6B, 0x5F, 0xB9, 0xDF, 0x59, 0xED, 0x1D
};

/* ARIA128(CCM)GE COUNT = 195 */
static const uint8_t ARIA_CCM_128_2_K[] =
{
    0x5C, 0xCF, 0x16, 0xD1, 0x29, 0x5E, 0xF2, 0x64, 0xB6, 0xA6, 0xFC, 0x86, 0xDC, 0xC7, 0x63, 0x8C
};
static const uint8_t ARIA_CCM_128_2_N[] =
{
    0x65, 0x68, 0x8D, 0x9C, 0x65, 0x5A, 0x69, 0x50, 0x4E, 0xF7, 0x5F, 0x8C
};
static const uint8_t ARIA_CCM_128_2_A[] =
{
    0xA5, 0x9D, 0x09, 0xEE, 0xCA, 0xFC, 0x5E, 0xF1, 0xB2, 0x8F, 0x73, 0x47, 0xF6, 0xFA, 0x7E, 0x6C,
    0x36, 0x98, 0x45, 0x09, 0x1A, 0x0B, 0x93, 0x20, 0xED, 0x0A, 0xF2, 0x88, 0x39, 0x39, 0x41, 0xD8
};
static const uint8_t ARIA_CCM_128_2_P[] =
{
    0x3F, 0x53, 0x4A, 0x27, 0xC1, 0x74, 0x17, 0xC7, 0xFF, 0xBE, 0x17, 0x6F, 0x52, 0x2E, 0xC2, 0xE7,
    0x47, 0xE1, 0xEA, 0xBB, 0xAF, 0x93, 0x5E, 0xFB, 0x77, 0xA3, 0xFD, 0x8F, 0xCA, 0x61, 0xF2, 0x30,
    0x4E, 0xE9, 0x35, 0x82, 0xF1
};
static const uint8_t ARIA_CCM_128_2_C[] =
{
    0xFA, 0x15, 0xAE, 0x8F, 0x8E, 0x09, 0xA9, 0x46, 0xFB, 0x31, 0xB1, 0x5D, 0xAA, 0x61, 0x32, 0x6C,
    0x3B, 0x30, 0x03, 0xAC, 0x1D, 0x12, 0x03, 0x32, 0x08, 0x40, 0x2F, 0xDA, 0xDA, 0xED, 0xC6, 0xDE,
    0x4E, 0x26, 0x87, 0xB8, 0xC5, 0x44, 0xEB, 0xAE, 0x7E, 0xC7, 0x77, 0x85, 0x48, 0x4D, 0x67, 0x6B,
    0x35, 0x2C, 0x22, 0xCC, 0x57
};

/* ARIA192(CCM)GE COUNT = 16 */
static const uint8_t ARIA_CCM_192_1_K[] =
{
    0xBC, 0x74, 0x60, 0xCE, 0x18, 0x74, 0x4C, 0xBB, 0xE1, 0x84, 0x94, 0x5A, 0x10, 0x95, 0x41, 0x70,
    0x25, 0x3E, 0xDB, 0x11, 0x69, 0x82, 0x26, 0xFC
};
static const uint8_t ARIA_CCM_192_1_N[] =
{
    0x0C, 0x2E, 0x3C, 0xEC, 0x30, 0x42, 0x5F
};
static const uint8_t ARIA_CCM_192_1_A[] =
{
    0xC8, 0x9C, 0x83, 0x74, 0xD4, 0x37, 0xAB, 0x84, 0xC3, 0xEE, 0x4D, 0x38, 0xF0, 0x3B, 0xF1, 0xAD
};
static const uint8_t ARIA_CCM_192_1_P[] =
{
    0x77, 0xE5, 0x63, 0x90, 0x8B, 0x2A, 0xDA, 0xE2, 0xC2, 0x00, 0xDF, 0x55, 0xA1, 0x85, 0x90, 0xA4
};
static const uint8_t ARIA_CCM_192_1_C[] =
{
    0xBD, 0xF5, 0x27, 0x04, 0xF2, 0xCE, 0x85, 0xC5, 0x11, 0xE1, 0x54, 0x32, 0x3E, 0xD6, 0x9A, 0x7A,
    0xC3, 0xB1, 0xFA, 0xD2, 0xE1, 0xC6, 0xF6, 0xB1, 0xFF, 0x0B, 0x9C, 0xE5, 0xDE, 0xFD, 0x79, 0x15
};

/* ARIA192(CCM)GE COUNT = 120 */
static const uint8_t ARIA_CCM_192_2_K[] =
{
    0xF7, 0x59, 0xC3, 0xDA, 0x06, 0x5E, 0xC2, 0xDB, 0x9B, 0x1F, 0x20, 0x68, 0x60, 0x80, 0x21, 0x71,
    0xBE, 0x0F, 0x2A, 0x10, 0x20, 0xF0, 0x2E, 0xD1
};
static const uint8_t ARIA_CCM_192_2_N[] =
{
    0x2E, 0xBF, 0x24, 0xF3, 0x34, 0xF6, 0xED, 0x5E, 0x5F, 0xEA, 0x8A, 0x9D
};
static const uint8_t ARIA_CCM_192_2_A[] =
{
    0xE9, 0xD5, 0x0D, 0xA6, 0xE9, 0x0A, 0x35, 0xAE, 0xF2, 0xC1, 0x0E, 0xDD, 0x16
};
static const uint8_t ARIA_CCM_192_2_P[] =
{
    0x9E, 0x91, 0x21, 0x8D, 0x6A, 0x93, 0xF0, 0x98, 0x08, 0x01, 0x37, 0xCA, 0x35, 0xCA, 0x46, 0x63
};
static const uint8_t ARIA_CCM_192_2_C[] =
{
    0xE7, 0xC2, 0x1D, 0x65, 0x9C, 0xD0, 0xB2, 0x99, 0xD3, 0x83, 0xFC, 0xEA, 0x70, 0x5D, 0x67, 0x30,
    0x6C, 0x68, 0x34, 0x71, 0x4B, 0x64, 0x1D, 0xCB, 0x40, 0x5D, 0x77, 0xC3, 0xEF, 0x3B, 0x45, 0xE5
};

/* ARIA256(CCM)GE COUNT = 17 */
static const uint8_t ARIA_CCM_256_1_K[] =
{
    0x5F, 0xAF, 0x40, 0xE5, 0xEF, 0x6C, 0x06, 0xDB, 0x73, 0xDF, 0x1F, 0x03, 0x52, 0x37, 0x42, 0xE5,
    0x5C, 0x4E, 0x99, 0x63, 0x55, 0x11, 0x23, 0xA5, 0xD7, 0x0C, 0xBD, 0x25, 0xBF, 0x35, 0x4A, 0x4F
};
static const uint8_t ARIA_CCM_256_1_N[] =
{
    0xFA, 0xB5, 0x12, 0x95, 0xED, 0xBE, 0xD0
};
static const uint8_t ARIA_CCM_256_1_A[] =
{
    0x53, 0x51, 0x27, 0x80, 0x8C, 0xB9, 0xEF, 0x77, 0xC3, 0x97, 0x54, 0xC7, 0xED, 0x03, 0x9A, 0x79
};
static const uint8_t ARIA_CCM_256_1_P[] =
{
    0xE6, 0x0B, 0x3C, 0xA9, 0x3F, 0xD9, 0xA0, 0xFF, 0xE3, 0x6F, 0xFE, 0xA5, 0x6A, 0x46, 0x9B, 0x28
};
static const uint8_t ARIA_CCM_256_1_C[] =
{
    0x4A, 0x62, 0xD2, 0xD1, 0x35, 0xD3, 0xDE, 0x3A, 0xCE, 0xE5, 0x3D, 0xE9, 0x44, 0x26, 0xEA, 0x66,
    0x3D, 0x0F, 0x8B, 0x32, 0x18, 0x0F, 0x42, 0x84, 0x4B, 0x9C, 0x5E, 0x94, 0x09, 0x15, 0x0E, 0x4E
};

/* ARIA256(CCM)GE COUNT = 123 */
static const uint8_t ARIA_CCM_256_2_K[] =
{
    0x7F, 0xE5, 0xF6, 0x8C, 0x39, 0xF3, 0xCB, 0xDF, 0x46, 0x4A, 0xAF, 0x59, 0xCD, 0xA9, 0x3B, 0x1C,
    0x18, 0xA7, 0xDC, 0xE0, 0x93, 0xC7, 0x20, 0x19, 0xF2, 0x31, 0x44, 0x80, 0x43, 0xA1, 0xFA, 0xDB
};
static const uint8_t ARIA_CCM_256_2_N[] =
{
    0x2A, 0xC0, 0xF3, 0x75, 0x1F, 0x98, 0x40, 0x29, 0xEF, 0x2F, 0x03, 0x68
};
static const uint8_t ARIA_CCM_256_2_A[] =
{
    0x43, 0x13, 0x7F, 0x26, 0x7C, 0xE2, 0x11, 0x17, 0xA8, 0x8F, 0x19, 0x12, 0xDB
};
static const uint8_t ARIA_CCM_256_2_P[] =
{
    0x6E, 0x50, 0x27, 0xB3, 0xD7, 0xAB, 0x22, 0x4D, 0x5B, 0x35, 0x0F, 0x76, 0x59, 0x08, 0x81, 0x5A
};
static const uint8_t ARIA_CCM_256_2_C[] =
{
    0xEC, 0x27, 0x13, 0x88, 0x4A, 0xE8, 0xA5, 0xBA, 0x51, 0x12, 0x08, 0x85, 0x2F, 0x41, 0x3A, 0xD7,
    0xA4, 0xFA, 0xB4, 0x10, 0x7F, 0x06, 0x16, 0x9B, 0xAA, 0x73, 0x0B, 0x9D, 0x56, 0xA4, 0xC3, 0x78
};


/* end of file testvectors_aria_ccm_data.h */
