# HSM FW Updates

This example is primarily for the demonstration of how to perform an in the
field HSM FW on supporting devices. Given that this example performs HSM FW
update on the device that it is programmed to, it can also be used as an
alternative method of provisioning the HSM FW for the first time.

The example compiles the HSM FW inside of it by way of first converting the HSM
FW binary into a C-style header file which can be compiled against. The tool to
do this is the standard Unix tool called `xxd`. See instructions below if you
should wish to do this yourself.

# Which HSM FW is it programming

By default, it is using the original HSM FW which was shipped in the SDK which
can be found at `<sdk>/bin/hsm/`. You will find a copy of this HSM FW binary at
the root of the project folder in it's original .bin format as well as a
converted C-style .h file.

If you should ever need to change the HSM FW that is being programmed by this
example then please see how to rebuild with a different HSM FW version
[below](#rebuilding-with-a-different-hsm-fw-version)

# HSM FW Update Procedure

The HSM FW update procedure is as follows.

The application is to communicate the following information to System ROM.

1. Where is the image to update (must be sector aligned and in FLASH)
2. What type of image is at that location (HSM_FW, APP or SSB)
	- This example of course pertains to the **HSM_FW** image type
	- See TRM for more details on the other image types

There are HAPI functions available in `<ti/devices/<device>/driverlib/hapi.h>`
that the application can use to communicate this information. Within these
APIs, the information is being stored in a semi-non-volatile 3v3 SYS0 register.
This register will persist its contents through system resets but will not
persist its contents through a Power on Reset (PoR).

Once the application has communicated the `Where` and the `What`, the final
action is to reset the device so that the System ROM can process our requested
update. Since the 3v3 register has persisted our request through the system
reset, System ROM will handle the request and once completed will return
execution back to the application.

Finally, if desired, the application can query the status of the requested
update by, again, using a HAPI function. We can therefore use this result as
the success/fail of update procedure.

## PoR vs Reset

- PoR
	- **P**ower **O**n **R**eset - Requires the device to be completely removed
	from power for a moment
	- Clears the semi-non-volatile 3v3 SYS0 registers used for app/ROM
	communication
- Reset
	- Requires the device's reset pin to be held inactive for a moment
	- Does ***not*** clear the 3v3 registers used for app/ROM communication.
	Thus allowing the application to successfully request the HSM FW update
	across the reset

# Rebuilding with a different HSM FW image

One reason you may wish to rebuild this example with a different HSM FW image
is because you wish to sign the HSM FW image with your own private key first.
Learn more about this process in `<sdk>/tools/hsm/README.md` and return once you
have the new/signed HSM FW binary image.

1. Locate the HSM FW image you wish to use
2. Using a Unix-like environment, execute the following cmd to convert the HSM FW
into a C-style header file. This should work in `Git Bash`, `WSL2` or any such
native Linux environment.

	```
	$ xxd -i path_to_hsm_fw_binary hsm_fw.h
	```

3. Copy/Move the new `hsm_fw.h` file into the root of this project
4. Update the first line of `hsm_Fw.h` to match the pattern

	```
	const unsigned char hsmFwBinary[] __attribute__((aligned(0x800))) = {
	```
	- This will allows the example to access a char[] `hsmFwBinary` which the
	linker will automatically sector align for us

5. Update `hsmFwUpdate.c` to #include the new `hsm_fw.h` instead of the default
header file.
6. Rebuild the project

# Applying this process to your own app

The process used at runtime need not be any different in your own application.
The only major difference you are likely to deal with is the staging of the HSM
FW image. In this example we are staging the HSM FW directly into the app by
compiling it inside of the application. In your case though, you will more than
likely need to transfer the HSM FW image over to your device. This can be done
Over the Air (OTA) or via some other physical connection (SPI, CAN, UART, etc).

No matter how the HSM FW is staged onto your device, it **must** be staged in
FLASH and must be located at a sector aligned address. From that point on, the
process used in this example is identical to what you can use in your app.
