/*
 * Decompiled with CFR 0.152.
 */
package com.ti.msp430.imagereformer;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.math.BigInteger;

public class Compression {
    BufferedImage destination;

    public Compression(BufferedImage imageBuff) {
        this.destination = imageBuff;
    }

    public DataBufferInt rle_4_1bpp() {
        int i;
        DataBuffer buff = this.destination.getRaster().getDataBuffer();
        DataBufferInt tempBuffer = new DataBufferInt(buff.getSize() * 10);
        byte[] nextByte = new byte[8];
        int encodedLength = 0;
        int runLength = 0;
        int count = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            nextByte[i2] = (byte)buff.getElem(count++);
        }
        byte nextPixel = nextByte[0];
        int index = 1;
        int length = buff.getSize();
        while (count < length) {
            int missing;
            int i3;
            byte currentPixel = nextPixel;
            if (index == 8) {
                if (length - count > 7) {
                    for (i3 = 0; i3 < 8; ++i3) {
                        nextByte[i3] = (byte)buff.getElem(count++);
                    }
                } else {
                    missing = length - count - 1;
                    for (i = 0; i <= missing; ++i) {
                        nextByte[i] = (byte)buff.getElem(count++);
                    }
                }
                nextPixel = nextByte[0];
                index = 1;
            } else {
                nextPixel = nextByte[index++];
            }
            while (nextPixel == currentPixel && runLength < 15 && count < length) {
                ++runLength;
                currentPixel = nextPixel;
                if (index == 8) {
                    if (length - count > 7) {
                        for (i3 = 0; i3 < 8; ++i3) {
                            nextByte[i3] = (byte)buff.getElem(count++);
                        }
                    } else {
                        missing = length - count - 1;
                        for (i = 0; i <= missing; ++i) {
                            nextByte[i] = (byte)buff.getElem(count++);
                        }
                    }
                    nextPixel = nextByte[0];
                    index = 1;
                    continue;
                }
                nextPixel = nextByte[index++];
            }
            tempBuffer.setElem(encodedLength++, runLength << 4 | currentPixel);
            runLength = 0;
        }
        DataBufferInt compBuffer = new DataBufferInt(encodedLength);
        for (i = 0; i < encodedLength; ++i) {
            compBuffer.setElem(i, tempBuffer.getElem(i));
        }
        return compBuffer;
    }

    public DataBufferInt rle_4_2bpp() {
        int i;
        DataBuffer buff = this.destination.getRaster().getDataBuffer();
        DataBufferInt tempBuffer = new DataBufferInt(buff.getSize() * 10);
        byte[] nextByte = new byte[4];
        int encodedLength = 0;
        int runLength = 0;
        int count = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            nextByte[i2] = (byte)buff.getElem(count++);
        }
        byte nextPixel = nextByte[0];
        int index = 1;
        int length = buff.getSize();
        while (count < length) {
            int missing;
            int i3;
            byte currentPixel = nextPixel;
            if (index == 4) {
                if (length - count > 3) {
                    for (i3 = 0; i3 < 4; ++i3) {
                        nextByte[i3] = (byte)buff.getElem(count++);
                    }
                } else {
                    missing = length - count - 1;
                    for (i = 0; i <= missing; ++i) {
                        nextByte[i] = (byte)buff.getElem(count++);
                    }
                }
                nextPixel = nextByte[0];
                index = 1;
            } else {
                nextPixel = nextByte[index++];
            }
            while (nextPixel == currentPixel && runLength < 15 && count < length) {
                ++runLength;
                currentPixel = nextPixel;
                if (index == 4) {
                    if (length - count > 3) {
                        for (i3 = 0; i3 < 3; ++i3) {
                            nextByte[i3] = (byte)buff.getElem(count++);
                        }
                    } else {
                        missing = length - count - 1;
                        for (i = 0; i <= missing; ++i) {
                            nextByte[i] = (byte)buff.getElem(count++);
                        }
                    }
                    nextPixel = nextByte[0];
                    index = 1;
                    continue;
                }
                nextPixel = nextByte[index++];
            }
            tempBuffer.setElem(encodedLength++, runLength << 4 | currentPixel);
            runLength = 0;
        }
        DataBufferInt compBuffer = new DataBufferInt(encodedLength);
        for (i = 0; i < encodedLength; ++i) {
            compBuffer.setElem(i, tempBuffer.getElem(i));
        }
        return compBuffer;
    }

    public DataBufferInt rle_4_4bpp() {
        DataBuffer buff = this.destination.getRaster().getDataBuffer();
        DataBufferInt tempBuffer = new DataBufferInt(buff.getSize());
        int encodedLength = 0;
        int runLength = 0;
        int count = 0;
        byte[] nextByte = new byte[]{(byte)buff.getElem(count++), (byte)buff.getElem(count++)};
        byte nextPixel = nextByte[0];
        boolean index = true;
        int length = buff.getSize();
        while (count < length) {
            byte currentPixel = nextPixel;
            if (index) {
                index = false;
                if (length - count > 0) {
                    nextByte[0] = (byte)buff.getElem(count++);
                    nextByte[1] = (byte)buff.getElem(count++);
                } else {
                    nextByte[0] = (byte)buff.getElem(count++);
                }
                nextPixel = nextByte[0];
            } else {
                nextPixel = nextByte[1];
                index = true;
            }
            while (nextPixel == currentPixel && runLength < 15 && count < length) {
                ++runLength;
                currentPixel = nextPixel;
                if (index) {
                    index = false;
                    if (length - count > 0) {
                        nextByte[0] = (byte)buff.getElem(count++);
                        nextByte[1] = (byte)buff.getElem(count++);
                    } else {
                        nextByte[0] = (byte)buff.getElem(count++);
                    }
                    nextPixel = nextByte[0];
                    continue;
                }
                index = true;
                nextPixel = nextByte[1];
            }
            tempBuffer.setElem(encodedLength++, runLength << 4 | currentPixel);
            runLength = 0;
        }
        DataBufferInt compBuffer = new DataBufferInt(encodedLength);
        for (int i = 0; i < encodedLength; ++i) {
            compBuffer.setElem(i, tempBuffer.getElem(i));
        }
        return compBuffer;
    }

    public DataBufferInt rle_8_8bpp() {
        DataBuffer buff = this.destination.getRaster().getDataBuffer();
        DataBufferInt tempBuffer = new DataBufferInt(buff.getSize() * 3);
        int count = 0;
        int length = buff.getSize();
        int runLength = 0;
        int encodedLength = 0;
        while (count < length - 1) {
            byte currentPixel = (byte)buff.getElem(count++);
            while ((byte)buff.getElem(count) == currentPixel && runLength < 255 && count < length - 1) {
                ++runLength;
                ++count;
            }
            if (count == length - 1) {
                ++runLength;
            }
            tempBuffer.setElem(encodedLength++, runLength);
            tempBuffer.setElem(encodedLength++, currentPixel);
            runLength = 0;
        }
        DataBufferInt compBuffer = new DataBufferInt(encodedLength);
        for (int i = 0; i < encodedLength; ++i) {
            compBuffer.setElem(i, tempBuffer.getElem(i));
        }
        return compBuffer;
    }

    public DataBufferInt rle_8_8bpp_mod() {
        DataBuffer buff = this.destination.getRaster().getDataBuffer();
        DataBufferInt tempBuffer = new DataBufferInt(buff.getSize() * 3);
        int count = 0;
        int length = buff.getSize();
        int runLength = 0;
        int encodedLength = 1;
        int bits = 0;
        int position = 1;
        int encode = 0;
        boolean missing = false;
        byte currentPixel = 0;
        while (count < length - 1) {
            if (runLength == 0 && !missing) {
                currentPixel = (byte)buff.getElem(count++);
                while ((byte)buff.getElem(count) == currentPixel && runLength < 255 && count < length - 1) {
                    ++runLength;
                    ++count;
                }
                if (count == length - 1) {
                    ++runLength;
                }
            }
            if (bits == 7 && runLength > 2 && count < length) {
                tempBuffer.setElem(encodedLength - position, encode |= 1 << 7 - bits);
                tempBuffer.setElem(encodedLength++, runLength);
                tempBuffer.setElem(encodedLength++, currentPixel);
                runLength = 0;
                bits = 0;
                encode = 0;
                position = 1;
                missing = false;
                continue;
            }
            if (bits == 7 && runLength <= 2 && count < length) {
                tempBuffer.setElem(encodedLength - position, encode);
                tempBuffer.setElem(encodedLength++, currentPixel);
                ++encodedLength;
                --runLength;
                bits = 0;
                encode = 0;
                position = 1;
                while (runLength != -1) {
                    tempBuffer.setElem(encodedLength++, currentPixel);
                    ++bits;
                    ++position;
                    --runLength;
                }
                runLength = 0;
                missing = false;
                continue;
            }
            if (runLength > 2 && count < length) {
                encode |= 1 << 7 - bits;
                tempBuffer.setElem(encodedLength++, runLength);
                tempBuffer.setElem(encodedLength++, currentPixel);
                runLength = 0;
                ++bits;
                position += 2;
                continue;
            }
            if (runLength > 2 || count >= length) continue;
            while (bits < 7 && runLength != -1) {
                tempBuffer.setElem(encodedLength++, currentPixel);
                ++bits;
                ++position;
                --runLength;
            }
            if (runLength != -1) {
                missing = true;
                continue;
            }
            runLength = 0;
        }
        DataBufferInt temp2Buffer = new DataBufferInt(tempBuffer.getSize());
        length = encodedLength;
        encodedLength = 1;
        runLength = 0;
        count = 0;
        encode = 0;
        bits = 0;
        position = 0;
        boolean state = true;
        boolean get = false;
        boolean overflow = false;
        int change = 0;
        encode = tempBuffer.getElem(count);
        state = BigInteger.valueOf(encode).testBit(7);
        while (count < length - 1) {
            if (bits == 0 && change == 0 && !get) {
                encode = (byte)tempBuffer.getElem(count++);
            } else if (bits == 0 && change > 0) {
                encode = (byte)tempBuffer.getElem(count + change);
                position = change;
            } else if (get) {
                get = false;
            } else if (overflow) {
                state = BigInteger.valueOf(encode).testBit(7 - bits);
                overflow = false;
            }
            if (state) {
                while (bits < 8 && BigInteger.valueOf(encode).testBit(7 - bits) && runLength < 127 && count < length - 1) {
                    if (change > 0) {
                        while (position != 0) {
                            temp2Buffer.setElem(encodedLength++, 0);
                            temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                            --position;
                            --change;
                            ++runLength;
                        }
                        ++count;
                        while (change != 0) {
                            temp2Buffer.setElem(encodedLength++, 0);
                            temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                            --change;
                            ++runLength;
                        }
                    }
                    temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                    temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                    ++bits;
                    ++runLength;
                }
                while (bits < 8 && !BigInteger.valueOf(encode).testBit(7 - bits) && change <= 2 && count < length - 1) {
                    ++change;
                    ++bits;
                }
            } else {
                while (bits < 8 && BigInteger.valueOf(encode).testBit(7 - bits) == state && runLength < 127 && count <= length - 1) {
                    temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                    ++bits;
                    ++runLength;
                }
                if (bits == 0 && runLength < 127 && count < length - 1) {
                    temp2Buffer.setElem(encodedLength - runLength - 1, runLength);
                    runLength = 0;
                    ++encodedLength;
                    state = true;
                    get = true;
                } else if (bits != 8 && runLength < 127 && count < length - 1) {
                    temp2Buffer.setElem(encodedLength - runLength - 1, runLength);
                    runLength = 0;
                    ++encodedLength;
                    state = true;
                }
            }
            if (runLength == 127 && count < length - 1) {
                if (state) {
                    temp2Buffer.setElem(encodedLength - 2 * runLength - 1, 0x80 | runLength);
                    ++encodedLength;
                    runLength = 0;
                } else if (!state) {
                    temp2Buffer.setElem(encodedLength - runLength - 1, runLength);
                    ++encodedLength;
                    runLength = 0;
                }
                overflow = true;
            } else if (change <= 2 && bits < 8 && count < length - 1 && runLength > 0 && runLength < 127) {
                runLength += change;
                if (position != 0) {
                    while (position != 0) {
                        temp2Buffer.setElem(encodedLength++, 0);
                        temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                        --position;
                        --change;
                    }
                    ++count;
                    while (change != 0) {
                        temp2Buffer.setElem(encodedLength++, 0);
                        temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                        --change;
                    }
                } else {
                    for (int i = 0; i < change; ++i) {
                        temp2Buffer.setElem(encodedLength++, 0);
                        temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                    }
                }
                change = 0;
            } else if (change <= 2 && bits < 8 && change + runLength > 127 && count < length - 1) {
                if (position != 0) {
                    while (position != 0 || runLength != 127) {
                        temp2Buffer.setElem(encodedLength++, 0);
                        temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                        --position;
                        --change;
                        ++runLength;
                    }
                    if (runLength == 127) {
                        temp2Buffer.setElem(encodedLength - 2 * runLength - 1, 0x80 | runLength);
                        ++encodedLength;
                        runLength = 0;
                        while (position != 0) {
                            temp2Buffer.setElem(encodedLength++, 0);
                            temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                            --position;
                            --change;
                            ++runLength;
                        }
                        ++count;
                        while (change != 0) {
                            temp2Buffer.setElem(encodedLength++, 0);
                            temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                            --change;
                            ++runLength;
                        }
                    } else if (position == 0) {
                        ++count;
                        while (runLength != 127) {
                            temp2Buffer.setElem(encodedLength++, 0);
                            temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                            --change;
                            ++runLength;
                        }
                        temp2Buffer.setElem(encodedLength - 2 * runLength - 1, 0x80 | runLength);
                        ++encodedLength;
                        runLength = 0;
                        while (change != 0) {
                            temp2Buffer.setElem(encodedLength++, 0);
                            temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                            --change;
                            ++runLength;
                        }
                    }
                } else {
                    while (runLength != 127) {
                        temp2Buffer.setElem(encodedLength++, 0);
                        temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                        --change;
                        ++runLength;
                    }
                    temp2Buffer.setElem(encodedLength - 2 * runLength - 1, 0x80 | runLength);
                    ++encodedLength;
                    runLength = 0;
                    while (change != 0) {
                        temp2Buffer.setElem(encodedLength++, 0);
                        temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                        --change;
                        ++runLength;
                    }
                }
            } else if (change > 2 && count < length - 1) {
                temp2Buffer.setElem(encodedLength - 2 * runLength - 1, 0x80 | runLength);
                ++encodedLength;
                if (position != 0) {
                    while (position != 0) {
                        temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                        --position;
                        --change;
                    }
                    ++count;
                }
                while (change != 0) {
                    temp2Buffer.setElem(encodedLength++, tempBuffer.getElem(count++));
                    --change;
                }
                runLength = 3;
                state = false;
            }
            if (bits != 8) continue;
            bits = 0;
        }
        if (runLength != 0) {
            if (state) {
                temp2Buffer.setElem(encodedLength - 2 * runLength - 1, 0x80 | runLength);
            } else {
                temp2Buffer.setElem(encodedLength - runLength - 1, runLength);
            }
        }
        DataBufferInt compBuffer = new DataBufferInt(encodedLength);
        for (int i = 0; i < encodedLength; ++i) {
            compBuffer.setElem(i, temp2Buffer.getElem(i));
        }
        return compBuffer;
    }
}

