typedef read_only image3d_t read_only_image3d_float;

kernel void sample_kernel(
  read_only_image3d_float input,
  sampler_t imageSampler,
  global float *xOffsets,
  global float *yOffsets,
  global float *zOffsets, 
  global float4 *results )
{
   int tidX = get_global_id(0), tidY = get_global_id(1), tidZ = get_global_id(2);
   int offset = tidZ*get_image_width(input)*get_image_height(input) + tidY*get_image_width(input) + tidX;
   float4 coords = (float4)( tidX, tidY, tidZ, 0.0f );
   results[offset] = read_imagef( input, imageSampler, coords );
}
