typedef read_only image2d_array_t read_only_image2d_array_float;

__kernel void sample_kernel( read_only_image2d_array_float input, sampler_t imageSampler, __global float *xOffsets, __global float *yOffsets, __global float *zOffsets,  __global float4 *results )
{
   int tidX = get_global_id(0), tidY = get_global_id(1), tidZ = get_global_id(2);
   int offset = tidZ*get_image_width(input)*get_image_height(input) + tidY*get_image_width(input) + tidX;
   int4 coords = (int4)( (int) tidX, (int) tidY, (int) tidZ, 0 );
   results[offset] = read_imagef( input, imageSampler, coords );
}
