typedef read_only image1d_array_t read_only_image1d_array_int;

__kernel void sample_kernel( read_only_image1d_array_int input, sampler_t imageSampler, __global float *xOffsets, __global float *yOffsets, __global int4 *results )
{
   int tidX = get_global_id(0), tidY = get_global_id(1);
   int offset = tidY*get_image_width(input) + tidX;
   int2 coords = (int2)( tidX, tidY);
   results[offset] = read_imagei( input, imageSampler, coords );
}
