#pragma OPENCL EXTENSION cl_khr_local_int32_base_atomics : enable
__kernel void test_atomic_fn(__global int *src, __global int *finalDest,
  volatile __local int *destMemory)
{
  int tid = get_global_id(0), gid = get_group_id(0), lid = get_local_id(0);
  destMemory[gid] = src[gid];
  barrier(CLK_LOCAL_MEM_FENCE);
  atomic_add(&destMemory[gid], 2);
  barrier(CLK_LOCAL_MEM_FENCE);
  finalDest[gid] = destMemory[gid];
}
