#ifdef cles_khr_int64
#pragma OPENCL EXTENSION cles_khr_int64 : enable
#endif
__kernel void test_convert_long3_sat_char3( __global char *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rte_char3( __global char *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtn_char3( __global char *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtp_char3( __global char *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtz_char3( __global char *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_char3( __global char *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rte_char3( __global char *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtn_char3( __global char *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtp_char3( __global char *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtz_char3( __global char *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_char3( __global char *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rte_char3( __global char *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtn_char3( __global char *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtp_char3( __global char *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtz_char3( __global char *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_char3( __global char *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rte_char3( __global char *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtn_char3( __global char *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtp_char3( __global char *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtz_char3( __global char *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtz(vload3(tid, src)), tid, dst);
}
