__kernel void test_convert_double3_char3( __global char *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rte_char3( __global char *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtn_char3( __global char *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtp_char3( __global char *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtz_char3( __global char *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_uchar3( __global uchar *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rte_uchar3( __global uchar *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtn_uchar3( __global uchar *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtp_uchar3( __global uchar *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtz_uchar3( __global uchar *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_uchar3( __global uchar *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rte_uchar3( __global uchar *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtn_uchar3( __global uchar *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtp_uchar3( __global uchar *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtz_uchar3( __global uchar *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_uchar3( __global uchar *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rte_uchar3( __global uchar *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtn_uchar3( __global uchar *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtp_uchar3( __global uchar *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtz_uchar3( __global uchar *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_uchar3( __global uchar *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(vload3(tid, src), tid, dst);
}

__kernel void test_convert_uchar3_rte_uchar3( __global uchar *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtn_uchar3( __global uchar *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtp_uchar3( __global uchar *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtz_uchar3( __global uchar *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_uchar3( __global uchar *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rte_uchar3( __global uchar *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtn_uchar3( __global uchar *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtp_uchar3( __global uchar *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtz_uchar3( __global uchar *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_uchar3( __global uchar *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rte_uchar3( __global uchar *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtn_uchar3( __global uchar *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtp_uchar3( __global uchar *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtz_uchar3( __global uchar *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_uchar3( __global uchar *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rte_uchar3( __global uchar *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtn_uchar3( __global uchar *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtp_uchar3( __global uchar *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtz_uchar3( __global uchar *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_uchar3( __global uchar *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rte_uchar3( __global uchar *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtn_uchar3( __global uchar *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtp_uchar3( __global uchar *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtz_uchar3( __global uchar *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_uchar3( __global uchar *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rte_uchar3( __global uchar *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtn_uchar3( __global uchar *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtp_uchar3( __global uchar *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtz_uchar3( __global uchar *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_uchar3( __global uchar *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rte_uchar3( __global uchar *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtn_uchar3( __global uchar *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtp_uchar3( __global uchar *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtz_uchar3( __global uchar *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_uchar3( __global uchar *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rte_uchar3( __global uchar *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtn_uchar3( __global uchar *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtp_uchar3( __global uchar *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtz_uchar3( __global uchar *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_uchar3( __global uchar *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rte_uchar3( __global uchar *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtn_uchar3( __global uchar *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtp_uchar3( __global uchar *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtz_uchar3( __global uchar *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_uchar3( __global uchar *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rte_uchar3( __global uchar *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtn_uchar3( __global uchar *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtp_uchar3( __global uchar *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtz_uchar3( __global uchar *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_uchar3( __global uchar *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rte_uchar3( __global uchar *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtn_uchar3( __global uchar *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtp_uchar3( __global uchar *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtz_uchar3( __global uchar *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_uchar3( __global uchar *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rte_uchar3( __global uchar *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtn_uchar3( __global uchar *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtp_uchar3( __global uchar *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtz_uchar3( __global uchar *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_uchar3( __global uchar *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rte_uchar3( __global uchar *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtn_uchar3( __global uchar *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtp_uchar3( __global uchar *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtz_uchar3( __global uchar *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_uchar3( __global uchar *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rte_uchar3( __global uchar *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtn_uchar3( __global uchar *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtp_uchar3( __global uchar *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtz_uchar3( __global uchar *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_uchar3( __global uchar *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rte_uchar3( __global uchar *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtn_uchar3( __global uchar *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtp_uchar3( __global uchar *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtz_uchar3( __global uchar *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_int3( __global int *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rte_int3( __global int *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtn_int3( __global int *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtp_int3( __global int *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtz_int3( __global int *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_int3( __global int *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rte_int3( __global int *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtn_int3( __global int *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtp_int3( __global int *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtz_int3( __global int *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_int3( __global int *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rte_int3( __global int *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtn_int3( __global int *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtp_int3( __global int *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtz_int3( __global int *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_int3( __global int *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rte_int3( __global int *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtn_int3( __global int *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtp_int3( __global int *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtz_int3( __global int *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_int3( __global int *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rte_int3( __global int *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtn_int3( __global int *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtp_int3( __global int *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtz_int3( __global int *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_int3( __global int *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(vload3(tid, src), tid, dst);
}

__kernel void test_convert_int3_rte_int3( __global int *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtn_int3( __global int *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtp_int3( __global int *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtz_int3( __global int *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_int3( __global int *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rte_int3( __global int *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtn_int3( __global int *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtp_int3( __global int *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtz_int3( __global int *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_int3( __global int *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rte_int3( __global int *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtn_int3( __global int *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtp_int3( __global int *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtz_int3( __global int *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_int3( __global int *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rte_int3( __global int *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtn_int3( __global int *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtp_int3( __global int *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtz_int3( __global int *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_int3( __global int *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rte_int3( __global int *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtn_int3( __global int *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtp_int3( __global int *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtz_int3( __global int *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_int3( __global int *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rte_int3( __global int *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtn_int3( __global int *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtp_int3( __global int *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtz_int3( __global int *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_int3( __global int *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rte_int3( __global int *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtn_int3( __global int *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtp_int3( __global int *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtz_int3( __global int *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_int3( __global int *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rte_int3( __global int *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtn_int3( __global int *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtp_int3( __global int *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtz_int3( __global int *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_int3( __global int *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rte_int3( __global int *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtn_int3( __global int *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtp_int3( __global int *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtz_int3( __global int *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_int3( __global int *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rte_int3( __global int *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtn_int3( __global int *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtp_int3( __global int *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtz_int3( __global int *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_int3( __global int *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rte_int3( __global int *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtn_int3( __global int *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtp_int3( __global int *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtz_int3( __global int *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_int3( __global int *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rte_int3( __global int *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtn_int3( __global int *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtp_int3( __global int *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtz_int3( __global int *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_int3( __global int *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rte_int3( __global int *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtn_int3( __global int *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtp_int3( __global int *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtz_int3( __global int *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_uint3( __global uint *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rte_uint3( __global uint *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtn_uint3( __global uint *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtp_uint3( __global uint *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtz_uint3( __global uint *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_uint3( __global uint *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rte_uint3( __global uint *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtn_uint3( __global uint *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtp_uint3( __global uint *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtz_uint3( __global uint *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_uint3( __global uint *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rte_uint3( __global uint *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtn_uint3( __global uint *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtp_uint3( __global uint *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtz_uint3( __global uint *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_uint3( __global uint *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rte_uint3( __global uint *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtn_uint3( __global uint *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtp_uint3( __global uint *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtz_uint3( __global uint *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_uint3( __global uint *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rte_uint3( __global uint *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtn_uint3( __global uint *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtp_uint3( __global uint *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtz_uint3( __global uint *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_uint3( __global uint *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rte_uint3( __global uint *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtn_uint3( __global uint *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtp_uint3( __global uint *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtz_uint3( __global uint *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_uint3( __global uint *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rte_uint3( __global uint *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtn_uint3( __global uint *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtp_uint3( __global uint *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtz_uint3( __global uint *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_uint3( __global uint *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(vload3(tid, src), tid, dst);
}

__kernel void test_convert_uint3_rte_uint3( __global uint *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtn_uint3( __global uint *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtp_uint3( __global uint *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtz_uint3( __global uint *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_uint3( __global uint *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rte_uint3( __global uint *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtn_uint3( __global uint *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtp_uint3( __global uint *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtz_uint3( __global uint *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_uint3( __global uint *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rte_uint3( __global uint *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtn_uint3( __global uint *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtp_uint3( __global uint *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtz_uint3( __global uint *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_uint3( __global uint *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rte_uint3( __global uint *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtn_uint3( __global uint *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtp_uint3( __global uint *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtz_uint3( __global uint *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_uint3( __global uint *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rte_uint3( __global uint *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtn_uint3( __global uint *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtp_uint3( __global uint *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtz_uint3( __global uint *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_uint3( __global uint *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rte_uint3( __global uint *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtn_uint3( __global uint *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtp_uint3( __global uint *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtz_uint3( __global uint *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_uint3( __global uint *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rte_uint3( __global uint *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtn_uint3( __global uint *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtp_uint3( __global uint *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtz_uint3( __global uint *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_uint3( __global uint *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rte_uint3( __global uint *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtn_uint3( __global uint *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtp_uint3( __global uint *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtz_uint3( __global uint *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_uint3( __global uint *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rte_uint3( __global uint *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtn_uint3( __global uint *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtp_uint3( __global uint *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtz_uint3( __global uint *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_uint3( __global uint *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rte_uint3( __global uint *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtn_uint3( __global uint *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtp_uint3( __global uint *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtz_uint3( __global uint *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_uint3( __global uint *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rte_uint3( __global uint *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtn_uint3( __global uint *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtp_uint3( __global uint *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtz_uint3( __global uint *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_short3( __global short *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rte_short3( __global short *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtn_short3( __global short *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtp_short3( __global short *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtz_short3( __global short *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_short3( __global short *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rte_short3( __global short *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtn_short3( __global short *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtp_short3( __global short *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtz_short3( __global short *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_short3( __global short *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rte_short3( __global short *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtn_short3( __global short *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtp_short3( __global short *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtz_short3( __global short *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_short3( __global short *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rte_short3( __global short *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtn_short3( __global short *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtp_short3( __global short *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtz_short3( __global short *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_short3( __global short *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rte_short3( __global short *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtn_short3( __global short *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtp_short3( __global short *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtz_short3( __global short *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_short3( __global short *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rte_short3( __global short *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtn_short3( __global short *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtp_short3( __global short *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtz_short3( __global short *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_short3( __global short *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rte_short3( __global short *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtn_short3( __global short *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtp_short3( __global short *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtz_short3( __global short *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_short3( __global short *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rte_short3( __global short *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtn_short3( __global short *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtp_short3( __global short *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtz_short3( __global short *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_short3( __global short *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rte_short3( __global short *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtn_short3( __global short *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtp_short3( __global short *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtz_short3( __global short *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_short3( __global short *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(vload3(tid, src), tid, dst);
}

__kernel void test_convert_short3_rte_short3( __global short *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtn_short3( __global short *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtp_short3( __global short *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtz_short3( __global short *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_short3( __global short *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rte_short3( __global short *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtn_short3( __global short *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtp_short3( __global short *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtz_short3( __global short *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_short3( __global short *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rte_short3( __global short *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtn_short3( __global short *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtp_short3( __global short *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtz_short3( __global short *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_short3( __global short *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rte_short3( __global short *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtn_short3( __global short *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtp_short3( __global short *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtz_short3( __global short *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_short3( __global short *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rte_short3( __global short *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtn_short3( __global short *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtp_short3( __global short *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtz_short3( __global short *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_short3( __global short *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rte_short3( __global short *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtn_short3( __global short *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtp_short3( __global short *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtz_short3( __global short *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_short3( __global short *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rte_short3( __global short *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtn_short3( __global short *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtp_short3( __global short *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtz_short3( __global short *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_short3( __global short *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rte_short3( __global short *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtn_short3( __global short *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtp_short3( __global short *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtz_short3( __global short *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_short3( __global short *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rte_short3( __global short *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtn_short3( __global short *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtp_short3( __global short *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtz_short3( __global short *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_ushort3( __global ushort *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rte_ushort3( __global ushort *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtn_ushort3( __global ushort *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtp_ushort3( __global ushort *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtz_ushort3( __global ushort *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_ushort3( __global ushort *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rte_ushort3( __global ushort *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtn_ushort3( __global ushort *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtp_ushort3( __global ushort *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtz_ushort3( __global ushort *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_ushort3( __global ushort *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rte_ushort3( __global ushort *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtn_ushort3( __global ushort *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtp_ushort3( __global ushort *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtz_ushort3( __global ushort *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_ushort3( __global ushort *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rte_ushort3( __global ushort *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtn_ushort3( __global ushort *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtp_ushort3( __global ushort *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtz_ushort3( __global ushort *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_ushort3( __global ushort *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rte_ushort3( __global ushort *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtn_ushort3( __global ushort *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtp_ushort3( __global ushort *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtz_ushort3( __global ushort *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_ushort3( __global ushort *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rte_ushort3( __global ushort *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtn_ushort3( __global ushort *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtp_ushort3( __global ushort *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtz_ushort3( __global ushort *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_ushort3( __global ushort *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rte_ushort3( __global ushort *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtn_ushort3( __global ushort *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtp_ushort3( __global ushort *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtz_ushort3( __global ushort *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_ushort3( __global ushort *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rte_ushort3( __global ushort *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtn_ushort3( __global ushort *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtp_ushort3( __global ushort *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtz_ushort3( __global ushort *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_ushort3( __global ushort *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rte_ushort3( __global ushort *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtn_ushort3( __global ushort *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtp_ushort3( __global ushort *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtz_ushort3( __global ushort *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_ushort3( __global ushort *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rte_ushort3( __global ushort *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtn_ushort3( __global ushort *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtp_ushort3( __global ushort *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtz_ushort3( __global ushort *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_ushort3( __global ushort *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rte_ushort3( __global ushort *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtn_ushort3( __global ushort *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtp_ushort3( __global ushort *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtz_ushort3( __global ushort *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_ushort3( __global ushort *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(vload3(tid, src), tid, dst);
}

__kernel void test_convert_ushort3_rte_ushort3( __global ushort *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtn_ushort3( __global ushort *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtp_ushort3( __global ushort *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtz_ushort3( __global ushort *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_ushort3( __global ushort *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rte_ushort3( __global ushort *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtn_ushort3( __global ushort *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtp_ushort3( __global ushort *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtz_ushort3( __global ushort *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_ushort3( __global ushort *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rte_ushort3( __global ushort *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtn_ushort3( __global ushort *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtp_ushort3( __global ushort *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtz_ushort3( __global ushort *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_ushort3( __global ushort *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rte_ushort3( __global ushort *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtn_ushort3( __global ushort *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtp_ushort3( __global ushort *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtz_ushort3( __global ushort *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_ushort3( __global ushort *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rte_ushort3( __global ushort *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtn_ushort3( __global ushort *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtp_ushort3( __global ushort *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtz_ushort3( __global ushort *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_ushort3( __global ushort *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rte_ushort3( __global ushort *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtn_ushort3( __global ushort *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtp_ushort3( __global ushort *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtz_ushort3( __global ushort *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_ushort3( __global ushort *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rte_ushort3( __global ushort *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtn_ushort3( __global ushort *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtp_ushort3( __global ushort *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtz_ushort3( __global ushort *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_long3( __global long *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rte_long3( __global long *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtn_long3( __global long *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtp_long3( __global long *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtz_long3( __global long *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_long3( __global long *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rte_long3( __global long *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtn_long3( __global long *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtp_long3( __global long *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtz_long3( __global long *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_long3( __global long *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rte_long3( __global long *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtn_long3( __global long *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtp_long3( __global long *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtz_long3( __global long *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_long3( __global long *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rte_long3( __global long *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtn_long3( __global long *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtp_long3( __global long *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtz_long3( __global long *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_long3( __global long *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rte_long3( __global long *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtn_long3( __global long *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtp_long3( __global long *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtz_long3( __global long *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_long3( __global long *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rte_long3( __global long *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtn_long3( __global long *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtp_long3( __global long *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtz_long3( __global long *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_long3( __global long *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rte_long3( __global long *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtn_long3( __global long *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtp_long3( __global long *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtz_long3( __global long *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_long3( __global long *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rte_long3( __global long *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtn_long3( __global long *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtp_long3( __global long *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtz_long3( __global long *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_long3( __global long *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rte_long3( __global long *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtn_long3( __global long *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtp_long3( __global long *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtz_long3( __global long *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_long3( __global long *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rte_long3( __global long *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtn_long3( __global long *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtp_long3( __global long *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtz_long3( __global long *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_long3( __global long *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rte_long3( __global long *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtn_long3( __global long *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtp_long3( __global long *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtz_long3( __global long *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_long3( __global long *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rte_long3( __global long *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtn_long3( __global long *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtp_long3( __global long *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtz_long3( __global long *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_long3( __global long *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rte_long3( __global long *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtn_long3( __global long *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtp_long3( __global long *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtz_long3( __global long *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_long3( __global long *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(vload3(tid, src), tid, dst);
}

__kernel void test_convert_long3_rte_long3( __global long *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtn_long3( __global long *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtp_long3( __global long *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtz_long3( __global long *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_long3( __global long *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rte_long3( __global long *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtn_long3( __global long *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtp_long3( __global long *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtz_long3( __global long *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_long3( __global long *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rte_long3( __global long *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtn_long3( __global long *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtp_long3( __global long *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtz_long3( __global long *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_long3( __global long *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rte_long3( __global long *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtn_long3( __global long *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtp_long3( __global long *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtz_long3( __global long *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_long3( __global long *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rte_long3( __global long *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtn_long3( __global long *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtp_long3( __global long *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtz_long3( __global long *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_ulong3( __global ulong *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rte_ulong3( __global ulong *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtn_ulong3( __global ulong *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtp_ulong3( __global ulong *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtz_ulong3( __global ulong *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_ulong3( __global ulong *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rte_ulong3( __global ulong *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtn_ulong3( __global ulong *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtp_ulong3( __global ulong *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtz_ulong3( __global ulong *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_ulong3( __global ulong *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rte_ulong3( __global ulong *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtn_ulong3( __global ulong *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtp_ulong3( __global ulong *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtz_ulong3( __global ulong *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_ulong3( __global ulong *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rte_ulong3( __global ulong *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtn_ulong3( __global ulong *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtp_ulong3( __global ulong *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtz_ulong3( __global ulong *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_ulong3( __global ulong *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rte_ulong3( __global ulong *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtn_ulong3( __global ulong *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtp_ulong3( __global ulong *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtz_ulong3( __global ulong *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_ulong3( __global ulong *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rte_ulong3( __global ulong *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtn_ulong3( __global ulong *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtp_ulong3( __global ulong *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtz_ulong3( __global ulong *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_ulong3( __global ulong *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rte_ulong3( __global ulong *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtn_ulong3( __global ulong *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtp_ulong3( __global ulong *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtz_ulong3( __global ulong *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_ulong3( __global ulong *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rte_ulong3( __global ulong *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtn_ulong3( __global ulong *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtp_ulong3( __global ulong *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtz_ulong3( __global ulong *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_ulong3( __global ulong *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rte_ulong3( __global ulong *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtn_ulong3( __global ulong *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtp_ulong3( __global ulong *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtz_ulong3( __global ulong *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_ulong3( __global ulong *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rte_ulong3( __global ulong *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtn_ulong3( __global ulong *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtp_ulong3( __global ulong *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtz_ulong3( __global ulong *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_ulong3( __global ulong *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rte_ulong3( __global ulong *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtn_ulong3( __global ulong *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtp_ulong3( __global ulong *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtz_ulong3( __global ulong *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_ulong3( __global ulong *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rte_ulong3( __global ulong *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtn_ulong3( __global ulong *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtp_ulong3( __global ulong *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtz_ulong3( __global ulong *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_ulong3( __global ulong *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rte_ulong3( __global ulong *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtn_ulong3( __global ulong *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtp_ulong3( __global ulong *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtz_ulong3( __global ulong *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_ulong3( __global ulong *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rte_ulong3( __global ulong *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtn_ulong3( __global ulong *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtp_ulong3( __global ulong *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtz_ulong3( __global ulong *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_ulong3( __global ulong *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rte_ulong3( __global ulong *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtn_ulong3( __global ulong *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtp_ulong3( __global ulong *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtz_ulong3( __global ulong *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_ulong3( __global ulong *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(vload3(tid, src), tid, dst);
}

__kernel void test_convert_ulong3_rte_ulong3( __global ulong *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtn_ulong3( __global ulong *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtp_ulong3( __global ulong *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtz_ulong3( __global ulong *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_ulong3( __global ulong *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rte_ulong3( __global ulong *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtn_ulong3( __global ulong *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtp_ulong3( __global ulong *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtz_ulong3( __global ulong *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_ulong3( __global ulong *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rte_ulong3( __global ulong *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtn_ulong3( __global ulong *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtp_ulong3( __global ulong *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtz_ulong3( __global ulong *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_float3( __global float *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rte_float3( __global float *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtn_float3( __global float *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtp_float3( __global float *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtz_float3( __global float *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_float3( __global float *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rte_float3( __global float *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtn_float3( __global float *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtp_float3( __global float *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtz_float3( __global float *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_float3( __global float *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rte_float3( __global float *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtn_float3( __global float *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtp_float3( __global float *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtz_float3( __global float *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_float3( __global float *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rte_float3( __global float *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtn_float3( __global float *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtp_float3( __global float *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtz_float3( __global float *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_float3( __global float *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rte_float3( __global float *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtn_float3( __global float *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtp_float3( __global float *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtz_float3( __global float *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_float3( __global float *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rte_float3( __global float *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtn_float3( __global float *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtp_float3( __global float *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtz_float3( __global float *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_float3( __global float *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rte_float3( __global float *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtn_float3( __global float *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtp_float3( __global float *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtz_float3( __global float *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_float3( __global float *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rte_float3( __global float *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtn_float3( __global float *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtp_float3( __global float *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtz_float3( __global float *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_float3( __global float *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rte_float3( __global float *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtn_float3( __global float *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtp_float3( __global float *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtz_float3( __global float *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_float3( __global float *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rte_float3( __global float *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtn_float3( __global float *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtp_float3( __global float *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtz_float3( __global float *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_float3( __global float *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rte_float3( __global float *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtn_float3( __global float *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtp_float3( __global float *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtz_float3( __global float *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_float3( __global float *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rte_float3( __global float *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtn_float3( __global float *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtp_float3( __global float *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtz_float3( __global float *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_float3( __global float *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rte_float3( __global float *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtn_float3( __global float *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtp_float3( __global float *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtz_float3( __global float *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_float3( __global float *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rte_float3( __global float *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtn_float3( __global float *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtp_float3( __global float *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtz_float3( __global float *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_float3( __global float *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rte_float3( __global float *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtn_float3( __global float *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtp_float3( __global float *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtz_float3( __global float *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_float3( __global float *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rte_float3( __global float *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtn_float3( __global float *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtp_float3( __global float *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtz_float3( __global float *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_float3( __global float *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(vload3(tid, src), tid, dst);
}

__kernel void test_convert_float3_rte_float3( __global float *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtn_float3( __global float *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtp_float3( __global float *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtz_float3( __global float *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_float3( __global float *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rte_float3( __global float *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtn_float3( __global float *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtp_float3( __global float *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtz_float3( __global float *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_double3( __global double *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rte_double3( __global double *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtn_double3( __global double *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtp_double3( __global double *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_sat_rtz_double3( __global double *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_double3( __global double *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rte_double3( __global double *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtn_double3( __global double *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtp_double3( __global double *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_char3_rtz_double3( __global double *src, __global char *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_char3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_double3( __global double *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rte_double3( __global double *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtn_double3( __global double *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtp_double3( __global double *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_sat_rtz_double3( __global double *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_double3( __global double *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rte_double3( __global double *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtn_double3( __global double *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtp_double3( __global double *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uchar3_rtz_double3( __global double *src, __global uchar *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uchar3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_double3( __global double *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rte_double3( __global double *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtn_double3( __global double *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtp_double3( __global double *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_sat_rtz_double3( __global double *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_double3( __global double *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rte_double3( __global double *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtn_double3( __global double *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtp_double3( __global double *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_int3_rtz_double3( __global double *src, __global int *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_int3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_double3( __global double *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rte_double3( __global double *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtn_double3( __global double *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtp_double3( __global double *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_sat_rtz_double3( __global double *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_double3( __global double *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rte_double3( __global double *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtn_double3( __global double *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtp_double3( __global double *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_uint3_rtz_double3( __global double *src, __global uint *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_uint3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_double3( __global double *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rte_double3( __global double *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtn_double3( __global double *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtp_double3( __global double *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_sat_rtz_double3( __global double *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_double3( __global double *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rte_double3( __global double *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtn_double3( __global double *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtp_double3( __global double *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_short3_rtz_double3( __global double *src, __global short *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_short3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_double3( __global double *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rte_double3( __global double *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtn_double3( __global double *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtp_double3( __global double *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_sat_rtz_double3( __global double *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_double3( __global double *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rte_double3( __global double *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtn_double3( __global double *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtp_double3( __global double *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ushort3_rtz_double3( __global double *src, __global ushort *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ushort3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_double3( __global double *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rte_double3( __global double *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtn_double3( __global double *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtp_double3( __global double *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_sat_rtz_double3( __global double *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_double3( __global double *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rte_double3( __global double *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtn_double3( __global double *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtp_double3( __global double *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_long3_rtz_double3( __global double *src, __global long *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_long3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_double3( __global double *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rte_double3( __global double *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtn_double3( __global double *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtp_double3( __global double *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_sat_rtz_double3( __global double *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_sat_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_double3( __global double *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rte_double3( __global double *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtn_double3( __global double *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtp_double3( __global double *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_ulong3_rtz_double3( __global double *src, __global ulong *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_ulong3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_double3( __global double *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rte_double3( __global double *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtn_double3( __global double *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtp_double3( __global double *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_float3_rtz_double3( __global double *src, __global float *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_float3_rtz(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_double3( __global double *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(vload3(tid, src), tid, dst);
}

__kernel void test_convert_double3_rte_double3( __global double *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rte(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtn_double3( __global double *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtn(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtp_double3( __global double *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtp(vload3(tid, src)), tid, dst);
}

__kernel void test_convert_double3_rtz_double3( __global double *src, __global double *dst ){
    size_t tid = get_global_id(0);
    // Only each 3rd WI is activated
    if (tid % 3 || tid*3+2 >= get_global_size(0))
      return;
    vstore3(convert_double3_rtz(vload3(tid, src)), tid, dst);
}


