__kernel void test_fn(__global uchar4 *srcValues, __global uchar3 *destBuffer) {
  #define SIZE 128
  __private uchar3 priv[SIZE];
  int tid = get_global_id(0);
  //avoid accessing outside buffer limits
  if (SIZE <= tid*3 )
    return;
  vstore3(srcValues[tid].xyz, tid, (__private uchar *)priv);
  uchar3 val = vload3(tid, (__private uchar *)priv);
  vstore3(val, tid, (__global uchar *)destBuffer);
}