__kernel void test_fn(__global short4 *srcValues, __global short3 *destBuffer) {
  #define SIZE 128
  __private short3 priv[SIZE];
  int tid = get_global_id(0);
  //avoid accessing outside buffer limits
  if (SIZE <= tid*3 )
    return;
  vstore3(srcValues[tid].xyz, tid, (__private short *)priv);
  short3 val = vload3(tid, (__private short *)priv);
  vstore3(val, tid, (__global short *)destBuffer);
}